# Bundle document - Referto di Medicina di Laboratorio - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle document - Referto di Medicina di Laboratorio**

## Example Bundle: Bundle document - Referto di Medicina di Laboratorio

**Document Details**

Profile: [Bundle - Lab Report](StructureDefinition-bundle-it-lab.md)

Final Document at 2022-03-30 11:24:26+0100 by [PractitionerRole Generalist Medical Practitioners](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c) for [Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5) in encounter [Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2023-02-25 11:45:00+0100 --> 2023-02-25 12:45:00+0100](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-7b06368c-7089-4f66-acc8-29e1fcbd31f6)

-------

**Document Subject**

Profile: [Patient - Lab Report](StructureDefinition-patient-it-lab.md)

Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)

-------

-------

**Document Content**

## Laboratory studies (set)

### Esame del sangue

* 

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Microalbumina massa/volume in urine |  | Urine | 20 |  | mg/L | 0 - 20 |  | N |  |


-------

## Additional Resources Included in Document

-------

Entry 2 - fullUrl = urn:uuid:56f19992-e73e-45b5-bbdd-6d9aeb60b15a

Resource DiagnosticReport:

> 

Profile: [DiagnosticReport - Lab Report](StructureDefinition-diagnosticreport-it-lab.md)

## Laboratory report (Hematology studies (set) ) 

| | |
| :--- | :--- |
| Subject | Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E) |
| When For | 2023-02-25 11:45:00+0100 --> 2023-02-25 12:45:00+0100 |
| Reported | 2023-02-25 12:45:00+0100 |
| Performer | [PractitionerRole Generalist Medical Practitioners](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c) |
| Identifier | urn:uuid:10b545ea-725c-446d-9b95-8aeb444eddf3 (use: official, ) |

**Report Details**

* **Code**: [Hematology studies (set)](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-7e2f354b-de83-4472-bd07-1571cdb50fde)
  * **Value**: 70 mg/dL(Details: UCUM codemg/dL = 'mg/dL')
  * **Flags**: Final
  * **When For**: 2022-10-25 13:35:00+0100

**Coded Conclusions:**
* Blood glucose normal

-------

Entry 3 - fullUrl = urn:uuid:7e2f354b-de83-4472-bd07-1571cdb50fde

Resource Observation:

> 

Profile: [Observation Document - Lab Report](StructureDefinition-observation-doc-it-lab.md)

**status**: Final**category**:Laboratory**code**:Hematology studies (set)**subject**:[Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5)**encounter**:[Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2023-02-25 11:45:00+0100 --> 2023-02-25 12:45:00+0100](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-7b06368c-7089-4f66-acc8-29e1fcbd31f6)**effective**: 2022-10-25 13:35:00+0100**performer**:[PractitionerRole Generalist Medical Practitioners](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c)**value**: 70 mg/dL(Details: UCUM codemg/dL = 'mg/dL')**specimen**:[Specimen: type = Whole blood](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-168d4960-0a0b-43af-8025-180f0965f325)**device**:[Device](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-168d4960-0a0b-43af-8025-180f0965f324)**derivedFrom**:[Media: status = completed; type = Image; created[x] = 2023-06-21; issued = 2023-06-21 14:56:18+0000; height = 128; width = 128](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-059927b1-7e17-409e-ae60-68cc3c0b3aea)

-------

Entry 4 - fullUrl = urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5

Resource Patient:

> 

Profile: [Patient - Lab Report](StructureDefinition-patient-it-lab.md)

Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)
-------

-------

Entry 5 - fullUrl = urn:uuid:7b06368c-7089-4f66-acc8-29e1fcbd31f6

Resource Encounter:

> 

Profile: [Encounter - Lab Report](StructureDefinition-encounter-it-lab.md)

**status**: completed**class**:ambulatory**subject**:[Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5)**basedOn**:[ServiceRequest Leukocyte poor blood preparation](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-463ae6fe-60d4-4b38-84b3-1008e0925678)

### Participants

| | |
| :--- | :--- |
| - | **Type** |
| * | Secondary performer |

### Locations

| | |
| :--- | :--- |
| - | **Location** |
| * | [Location Policlinico di Roma](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-f148e54a-2046-4534-b9e9-54e7e9632224) |


-------

Entry 6 - fullUrl = urn:uuid:168d4960-0a0b-43af-8025-180f0965f325

Resource Specimen:

> 

Profile: [Specimen - Lab Report](StructureDefinition-specimen-it-lab.md)

**type**:Whole blood**subject**:[Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5)

### Collections

| | |
| :--- | :--- |
| - | **BodySite** |
| * | No display for Specimen.collection.bodySite (concept: Anterior surface of arm) |

> **container**

-------

Entry 7 - fullUrl = urn:uuid:463ae6fe-60d4-4b38-84b3-1008e0925678

Resource ServiceRequest:

> 

Profile: [ServiceRequest - Lab Report](StructureDefinition-servicerequest-it-lab.md)

**identifier**: 12345 (, period: 2023-03-15 --> 2023-04-15)**requisition**: 1300A4000000248**status**: Completed**intent**: Order**category**:Laboratory procedure**priority**: Routine**code**: No display for ServiceRequest.code (concept: Leukocyte poor blood preparation)**subject**:[Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5)**authoredOn**: 2023-03-15**specimen**:[Specimen: type = Whole blood](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-168d4960-0a0b-43af-8025-180f0965f325)

-------

Entry 8 - fullUrl = urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803c

Resource PractitionerRole:

> 

Profile: [PractitionerRole - Lab Report](StructureDefinition-practitionerrole-it-lab.md)

**identifier**:`http://esempio_policlinico.it/codiceEmatologo`/12345 (use: official, )**active**: true**practitioner**:[Practitioner Prova Medico](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803d)**organization**:[Organization Azienda Sanitara Locale Roma 1](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8)**code**:Generalist Medical Practitioners**specialty**:Clinical hematology

-------

Entry 9 - fullUrl = urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803d

Resource Practitioner:

> 

Profile: [Practitioner - Lab Report](StructureDefinition-practitioner-it-lab.md)

**identifier**:`http://hl7.it/sid/codiceFiscale`/MDCPRV80A01H501G (use: official, )**name**: Prova Medico**telecom**:[medico.prova@policlinico.it](mailto:medico.prova@policlinico.it), ph: 331793423(Work)**gender**: Male

-------

Entry 10 - fullUrl = urn:uuid:134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c

Resource Practitioner:

> 

Profile: [Practitioner - Lab Report](StructureDefinition-practitioner-it-lab.md)

**identifier**:`http://hl7.it/sid/codiceFiscale`/NFRPRV80A01H501G (use: official, )**name**: Prova Infermiere**telecom**:[infermiere.prova@policlinico.it](mailto:infermiere.prova@policlinico.it), ph: 331793553(Work)**gender**: Male

-------

Entry 11 - fullUrl = urn:uuid:5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8

Resource Organization:

> 

Profile: [Organization - Lab Report](StructureDefinition-organization-it-lab.md)

**identifier**:`http://hl7.it/sid/fls`/120201,`http://hl7.it/sid/vda/asl`/201**active**: true**type**:Azienda Sanitaria Locale**name**: Azienda Sanitara Locale Roma 1

### Contacts

| | |
| :--- | :--- |
| - | **Telecom** |
| * | ph: 06 123456 |


-------

Entry 12 - fullUrl = urn:uuid:ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8

Resource Organization:

> 

Profile: [Organization operatore sanitario/socio sanitario - Lab Report](StructureDefinition-organizationOperatore-it-lab.md)

**identifier**:`http://hl7.it/sid/fls`/020101**active**: true**type**:Azienda Sanitaria Locale**name**: AZIENDA U.S.L. VALLE D'AOSTA
> **contact****telecom**: ph: (0165) 5431, fax: (0165) 544587,[protocollo@pec.ausl.vda.it](mailto:protocollo@pec.ausl.vda.it),[http://www.ausl.vda.it](http://www.ausl.vda.it)**address**: VIA GUIDO REY 1 AOSTA VALLE D'AOSTA 11100 IT

-------

Entry 13 - fullUrl = urn:uuid:f148e54a-2046-4534-b9e9-54e7e9632224

Resource Location:

> 

Profile: [Location - Lab Report](StructureDefinition-location-it-lab.md)

**identifier**: 123456 (use: usual, )**status**: Active**name**: Policlinico di Roma**alias**: Poliambulatorio di Roma, Ospedale universitario di Roma**type**:Hospital**address**: ROMA 00144

-------

Entry 14 - fullUrl = urn:uuid:168d4960-0a0b-43af-8025-180f0965f324

Resource Device:

> 

Profile: [Device - Lab Report](StructureDefinition-device-it-lab.md)


-------

Entry 15 - fullUrl = urn:uuid:059927b1-7e17-409e-ae60-68cc3c0b3aea

Resource DocumentReference:

> 

Profile: [Media - Lab Report](StructureDefinition-media-it-lab.md)




## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "Bundle-Lab-Esempio",
  "meta" : {
    "profile" : [
      "http://hl7.it/fhir/lab-report/StructureDefinition/bundle-it-lab"
    ]
  },
  "identifier" : {
    "system" : "urn:ietf:rfc:39861",
    "value" : "urn:uuid:bfcf00e2-e2bb-4a7d-adaa-3de9d419d27e"
  },
  "type" : "document",
  "timestamp" : "2023-02-25T14:30:00+01:00",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:2ae95a5c-9094-41a3-a437-ce6d34c55a54",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "2ae95a5c-9094-41a3-a437-ce6d34c55a54",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/composition-it-lab"
          ]
        },
        "language" : "it-IT",
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"it-IT\" lang=\"it-IT\"><a name=\"Composition_2ae95a5c-9094-41a3-a437-ce6d34c55a54\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composizione 2ae95a5c-9094-41a3-a437-ce6d34c55a54</b></p><a name=\"2ae95a5c-9094-41a3-a437-ce6d34c55a54\"> </a><a name=\"hc2ae95a5c-9094-41a3-a437-ce6d34c55a54\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Language: it-IT</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-composition-it-lab.html\">Composition - Lab Report</a></p></div><blockquote><p><b>DataEnterer</b></p><ul><li>dataEnterer: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803d\">Practitioner Prova Medico </a></li><li>http://hl7.it/fhir/StructureDefinition/dataEnterer-time: 2023-02-25 10:45:00+0100</li></ul></blockquote><p><b>identifier</b>: urn:uuid:10b545ea-725c-446d-9b95-8aeb444eddf3 (use: official, )</p><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 11502-2}\">Referto di laboratorio</span></p><p><b>category</b>: <span title=\"Codes:{http://loinc.org 18723-7}\">Hematology studies (set)</span></p><p><b>encounter</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-7b06368c-7089-4f66-acc8-29e1fcbd31f6\">Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2023-02-25 11:45:00+0100 --&gt; 2023-02-25 12:45:00+0100</a></p><p><b>date</b>: 2022-03-30 11:24:26+0100</p><p><b>author</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c\">PractitionerRole Generalist Medical Practitioners</a></p><p><b>title</b>: Referto di Laboratorio</p><p><b>confidentiality</b>: normal</p><h3>Attesters</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Mode</b></td><td><b>Time</b></td><td><b>Party</b></td></tr><tr><td style=\"display: none\">*</td><td>Legal</td><td>2023-02-25 12:45:00+0100</td><td><a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c\">PractitionerRole Generalist Medical Practitioners</a></td></tr></table><p><b>custodian</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8\">Organization Azienda Sanitara Locale Roma 1</a></p></div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "dataEnterer",
                "valueReference" : {
                  "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803d"
                }
              },
              {
                "url" : "http://hl7.it/fhir/StructureDefinition/dataEnterer-time",
                "valueDateTime" : "2023-02-25T10:45:00+01:00"
              }
            ],
            "url" : "http://hl7.it/fhir/StructureDefinition/composition-dataenterer-it"
          }
        ],
        "identifier" : {
          "use" : "official",
          "value" : "urn:uuid:10b545ea-725c-446d-9b95-8aeb444eddf3",
          "assigner" : {
            "display" : "Regione Lazio"
          }
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11502-2",
              "display" : "Laboratory report"
            }
          ],
          "text" : "Referto di laboratorio"
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "18723-7",
                "display" : "Hematology studies (set)"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
        },
        "encounter" : {
          "reference" : "urn:uuid:7b06368c-7089-4f66-acc8-29e1fcbd31f6"
        },
        "date" : "2022-03-30T11:24:26+01:00",
        "author" : [
          {
            "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803c"
          }
        ],
        "title" : "Referto di Laboratorio",
        "confidentiality" : "N",
        "attester" : [
          {
            "mode" : "legal",
            "time" : "2023-02-25T12:45:00+01:00",
            "party" : {
              "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803c"
            }
          }
        ],
        "custodian" : {
          "reference" : "urn:uuid:5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8"
        },
        "section" : [
          {
            "title" : "Laboratory studies (set)",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "26436-6",
                  "display" : "Laboratory studies (set)"
                }
              ]
            },
            "section" : [
              {
                "title" : "Esame del sangue",
                "code" : {
                  "coding" : [
                    {
                      "system" : "http://loinc.org",
                      "code" : "18723-7",
                      "display" : "Hematology studies (set)"
                    }
                  ]
                },
                "text" : {
                  "status" : "generated",
                  "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li><table id=\"nota1\"><thead><tr><th>Esame</th><th>Metodo utilizzato per l'esame</th><th>Materiale utilizzato per l'esame</th><th>Risultato dell'esame</th><th>Commenti e note</th><th>Unità di Misura</th><th>Range di Riferimento</th><th>Criteri per il range di riferimento</th><th>Interpretazione</th><th>Allegati multimediali</th></tr></thead><tbody><tr><td>Microalbumina massa/volume in urine</td><td/><td>Urine</td><td>20</td><td/><td>mg/L</td><td>0 - 20</td><td/><td>N</td><td/></tr></tbody></table></li></ul></div>"
                },
                "entry" : [
                  {
                    "reference" : "urn:uuid:7e2f354b-de83-4472-bd07-1571cdb50fde"
                  }
                ]
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:56f19992-e73e-45b5-bbdd-6d9aeb60b15a",
      "resource" : {
        "resourceType" : "DiagnosticReport",
        "id" : "56f19992-e73e-45b5-bbdd-6d9aeb60b15a",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/diagnosticreport-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DiagnosticReport_56f19992-e73e-45b5-bbdd-6d9aeb60b15a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: RefertoDiagnostico 56f19992-e73e-45b5-bbdd-6d9aeb60b15a</b></p><a name=\"56f19992-e73e-45b5-bbdd-6d9aeb60b15a\"> </a><a name=\"hc56f19992-e73e-45b5-bbdd-6d9aeb60b15a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-diagnosticreport-it-lab.html\">DiagnosticReport - Lab Report</a></p></div><h2><span title=\"Codes:{http://loinc.org 11502-2}\">Laboratory report</span> (<span title=\"Codes:{http://loinc.org 18723-7}\">Hematology studies (set)</span>) </h2><table class=\"grid\"><tr><td>Subject</td><td>Maria Rossi  Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)</td></tr><tr><td>When For</td><td>2023-02-25 11:45:00+0100 --&gt; 2023-02-25 12:45:00+0100</td></tr><tr><td>Reported</td><td>2023-02-25 12:45:00+0100</td></tr><tr><td>Performer</td><td> <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c\">PractitionerRole Generalist Medical Practitioners</a></td></tr><tr><td>Identifier</td><td> urn:uuid:10b545ea-725c-446d-9b95-8aeb444eddf3 (use: official, )</td></tr></table><p><b>Report Details</b></p><table class=\"grid\"><tr><td><b>Code</b></td><td><b>Value</b></td><td><b>Flags</b></td><td><b>When For</b></td></tr><tr><td><a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-7e2f354b-de83-4472-bd07-1571cdb50fde\"><span title=\"Codes:{http://loinc.org 18723-7}\">Hematology studies (set)</span></a></td><td>70 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></td><td>Final</td><td>2022-10-25 13:35:00+0100</td></tr></table><p><b>Coded Conclusions:</b></p><ul><li><span title=\"Codes:{http://snomed.info/sct 166921001}\">Blood glucose normal</span></li></ul></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-DiagnosticReport.composition",
            "valueReference" : {
              "reference" : "urn:uuid:2ae95a5c-9094-41a3-a437-ce6d34c55a54"
            }
          }
        ],
        "identifier" : [
          {
            "use" : "official",
            "value" : "urn:uuid:10b545ea-725c-446d-9b95-8aeb444eddf3"
          }
        ],
        "basedOn" : [
          {
            "reference" : "urn:uuid:463ae6fe-60d4-4b38-84b3-1008e0925678"
          }
        ],
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "18723-7",
                "display" : "Hematology studies (set)"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11502-2",
              "display" : "Laboratory report"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
        },
        "encounter" : {
          "reference" : "urn:uuid:7b06368c-7089-4f66-acc8-29e1fcbd31f6"
        },
        "effectivePeriod" : {
          "start" : "2023-02-25T11:45:00+01:00",
          "end" : "2023-02-25T12:45:00+01:00"
        },
        "issued" : "2023-02-25T12:45:00+01:00",
        "performer" : [
          {
            "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803c"
          }
        ],
        "specimen" : [
          {
            "reference" : "urn:uuid:168d4960-0a0b-43af-8025-180f0965f325"
          }
        ],
        "result" : [
          {
            "reference" : "urn:uuid:7e2f354b-de83-4472-bd07-1571cdb50fde"
          }
        ],
        "conclusionCode" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "166921001",
                "display" : "Blood glucose normal"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:7e2f354b-de83-4472-bd07-1571cdb50fde",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "7e2f354b-de83-4472-bd07-1571cdb50fde",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/observation-doc-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_7e2f354b-de83-4472-bd07-1571cdb50fde\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Osservazione 7e2f354b-de83-4472-bd07-1571cdb50fde</b></p><a name=\"7e2f354b-de83-4472-bd07-1571cdb50fde\"> </a><a name=\"hc7e2f354b-de83-4472-bd07-1571cdb50fde\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-observation-doc-it-lab.html\">Observation Document - Lab Report</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 18723-7}\">Hematology studies (set)</span></p><p><b>subject</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5\">Maria Rossi  Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)</a></p><p><b>encounter</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-7b06368c-7089-4f66-acc8-29e1fcbd31f6\">Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2023-02-25 11:45:00+0100 --&gt; 2023-02-25 12:45:00+0100</a></p><p><b>effective</b>: 2022-10-25 13:35:00+0100</p><p><b>performer</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c\">PractitionerRole Generalist Medical Practitioners</a></p><p><b>value</b>: 70 mg/dL<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg/dL = 'mg/dL')</span></p><p><b>specimen</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-168d4960-0a0b-43af-8025-180f0965f325\">Specimen: type = Whole blood</a></p><p><b>device</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-168d4960-0a0b-43af-8025-180f0965f324\">Device</a></p><p><b>derivedFrom</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-059927b1-7e17-409e-ae60-68cc3c0b3aea\">Media: status = completed; type = Image; created[x] = 2023-06-21; issued = 2023-06-21 14:56:18+0000; height = 128; width = 128</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "18723-7",
              "display" : "Hematology studies (set)"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
        },
        "encounter" : {
          "reference" : "urn:uuid:7b06368c-7089-4f66-acc8-29e1fcbd31f6"
        },
        "effectiveDateTime" : "2022-10-25T13:35:00+01:00",
        "performer" : [
          {
            "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803c"
          }
        ],
        "valueQuantity" : {
          "value" : 70,
          "unit" : "mg/dL",
          "system" : "http://unitsofmeasure.org",
          "code" : "mg/dL"
        },
        "specimen" : {
          "reference" : "urn:uuid:168d4960-0a0b-43af-8025-180f0965f325"
        },
        "device" : {
          "reference" : "urn:uuid:168d4960-0a0b-43af-8025-180f0965f324"
        },
        "derivedFrom" : [
          {
            "reference" : "urn:uuid:059927b1-7e17-409e-ae60-68cc3c0b3aea"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "8472931c-fbd0-437b-9ed1-4f66472c78b5",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_8472931c-fbd0-437b-9ed1-4f66472c78b5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Paziente 8472931c-fbd0-437b-9ed1-4f66472c78b5</b></p><a name=\"8472931c-fbd0-437b-9ed1-4f66472c78b5\"> </a><a name=\"hc8472931c-fbd0-437b-9ed1-4f66472c78b5\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-patient-it-lab.html\">Patient - Lab Report</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Maria Rossi  Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li>ph: 3331245678</li><li><a href=\"mailto:maria.rossi@mail.com\">maria.rossi@mail.com</a></li><li>Via della Libertà, 52 Milano 20100 IT (home)</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Nominated Contact: Emergency Contact\">Emergency Contact:</td><td colspan=\"3\"><ul><li>Luigi Rossi </li><li>ph: 3312345567</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Nominated Contact: Emergency Contact\">Emergency Contact:</td><td colspan=\"3\"><ul><li>Maria Bianchi </li><li>ph: 3311234598</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Patient Links\">Links:</td><td colspan=\"3\"><ul><li>General Practitioner: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8\">Organization AZIENDA U.S.L. VALLE D'AOSTA</a></li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Estensione per gestire la professione del paziente come CodeableConcept.\"><a href=\"StructureDefinition-patient-occupation-it.html\">Professione del paziente</a></td><td colspan=\"3\"><span title=\"Codes:{http://hl7.it/fhir/lab-report/CodeSystem/istat-professioni 1.1.3}\">Dirigenti della magistratura</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Estensione per gestire il Titolo di studio del paziente come CodeableConcept.\"><a href=\"StructureDefinition-patient-qualification-it.html\">Titolo di Studio del paziente</a></td><td colspan=\"3\"><span title=\"Codes:{http://hl7.it/fhir/lab-report/CodeSystem/istat-ctsi03 40205013}\">Giuridico economico aziendale</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Codice comune e/o stato di nascita.\"><a href=\"StructureDefinition-patient-codeableBirthPlace.html\">Codice comune e/o stato di nascita</a></td><td colspan=\"3\"><span title=\"Codes:{http://hl7.it/fhir/lab-report/CodeSystem/istat-unitaAmministrativeTerritorialiEstere 100}\">Italia</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The registered place of birth of the patient. A sytem may use the address.text if they don't store the birthPlace address in discrete elements.\"><a href=\"http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-birthPlace.html\">Patient Birth Place</a></td><td colspan=\"3\">Via della Vittoria, 1 Milano 20100 IT </td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-birthPlace",
            "valueAddress" : {
              "line" : ["Via della Vittoria, 1"],
              "_line" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                      "valueString" : "Via della Vittoria"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                      "valueString" : "1"
                    }
                  ]
                }
              ],
              "city" : "Milano",
              "postalCode" : "20100",
              "country" : "IT"
            }
          },
          {
            "url" : "http://hl7.it/fhir/StructureDefinition/patient-occupation-it",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-professioni",
                  "code" : "1.1.3",
                  "display" : "Dirigenti della magistratura"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.it/fhir/StructureDefinition/patient-qualification-it",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-ctsi03",
                  "code" : "40205013",
                  "display" : "Giuridico economico aziendale"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-unitaAmministrativeTerritorialiEstere",
                  "code" : "100",
                  "display" : "Italia"
                }
              ]
            }
          }
        ],
        "identifier" : [
          {
            "extension" : [
              {
                "extension" : [
                  {
                    "url" : "when",
                    "valueDateTime" : "2022-05-01"
                  }
                ],
                "url" : "http://hl7.it/fhir/StructureDefinition/recordCertification"
              }
            ],
            "system" : "http://hl7.it/sid/codiceFiscale",
            "value" : "RSSMRA71E01F205E"
          }
        ],
        "name" : [
          {
            "family" : "Rossi",
            "given" : ["Maria"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "3331245678"
          },
          {
            "system" : "email",
            "value" : "maria.rossi@mail.com"
          }
        ],
        "gender" : "female",
        "birthDate" : "1971-05-01",
        "address" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/address-official",
                "valueBoolean" : true
              }
            ],
            "use" : "home",
            "line" : ["Via della Libertà, 52"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.it/fhir/StructureDefinition/address-dug",
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.it/fhir/lab-report/CodeSystem/dug",
                          "code" : "67",
                          "display" : "via"
                        }
                      ]
                    }
                  }
                ]
              }
            ],
            "city" : "Milano",
            "postalCode" : "20100",
            "country" : "IT"
          }
        ],
        "contact" : [
          {
            "relationship" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
                    "code" : "C",
                    "display" : "Emergency Contact"
                  }
                ]
              }
            ],
            "name" : {
              "family" : "Rossi",
              "given" : ["Luigi"]
            },
            "telecom" : [
              {
                "system" : "phone",
                "value" : "3312345567"
              }
            ]
          },
          {
            "relationship" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
                    "code" : "C",
                    "display" : "Emergency Contact"
                  }
                ]
              }
            ],
            "name" : {
              "family" : "Bianchi",
              "given" : ["Maria"]
            },
            "telecom" : [
              {
                "system" : "phone",
                "value" : "3311234598"
              }
            ]
          }
        ],
        "generalPractitioner" : [
          {
            "reference" : "urn:uuid:ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:7b06368c-7089-4f66-acc8-29e1fcbd31f6",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "7b06368c-7089-4f66-acc8-29e1fcbd31f6",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/encounter-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_7b06368c-7089-4f66-acc8-29e1fcbd31f6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Encounter 7b06368c-7089-4f66-acc8-29e1fcbd31f6</b></p><a name=\"7b06368c-7089-4f66-acc8-29e1fcbd31f6\"> </a><a name=\"hc7b06368c-7089-4f66-acc8-29e1fcbd31f6\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-encounter-it-lab.html\">Encounter - Lab Report</a></p></div><p><b>status</b>: Finished</p><p><b>class</b>: <a href=\"http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB\">ActCode: AMB</a> (ambulatory)</p><p><b>subject</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5\">Maria Rossi  Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)</a></p><p><b>basedOn</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-463ae6fe-60d4-4b38-84b3-1008e0925678\">ServiceRequest Leukocyte poor blood preparation</a></p><h3>Participants</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Type</b></td><td><b>Individual</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ParticipationType SPRF}\">Secondary performer</span></td><td><a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c\">Practitioner Prova Infermiere </a></td></tr></table><p><b>period</b>: 2023-02-25 11:45:00+0100 --&gt; 2023-02-25 12:45:00+0100</p><h3>Locations</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Location</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-f148e54a-2046-4534-b9e9-54e7e9632224\">Location Policlinico di Roma</a></td></tr></table></div>"
        },
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "AMB",
          "display" : "ambulatory"
        },
        "subject" : {
          "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
        },
        "basedOn" : [
          {
            "reference" : "urn:uuid:463ae6fe-60d4-4b38-84b3-1008e0925678"
          }
        ],
        "participant" : [
          {
            "type" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                    "code" : "SPRF",
                    "display" : "Secondary performer"
                  }
                ]
              }
            ],
            "individual" : {
              "reference" : "urn:uuid:134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c"
            }
          }
        ],
        "period" : {
          "start" : "2023-02-25T11:45:00+01:00",
          "end" : "2023-02-25T12:45:00+01:00"
        },
        "location" : [
          {
            "location" : {
              "reference" : "urn:uuid:f148e54a-2046-4534-b9e9-54e7e9632224"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:168d4960-0a0b-43af-8025-180f0965f325",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "168d4960-0a0b-43af-8025-180f0965f325",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/specimen-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_168d4960-0a0b-43af-8025-180f0965f325\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Campione 168d4960-0a0b-43af-8025-180f0965f325</b></p><a name=\"168d4960-0a0b-43af-8025-180f0965f325\"> </a><a name=\"hc168d4960-0a0b-43af-8025-180f0965f325\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-specimen-it-lab.html\">Specimen - Lab Report</a></p></div><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-SpecimenType BLD}\">Whole blood</span></p><p><b>subject</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5\">Maria Rossi  Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)</a></p><h3>Collections</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>BodySite</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 7311008}\">Anterior surface of arm</span></td></tr></table><h3>Containers</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Type</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 706052002}\">Evacuated blood collection tube</span></td></tr></table></div>"
        },
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-SpecimenType",
              "code" : "BLD",
              "display" : "Whole blood"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
        },
        "collection" : {
          "bodySite" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "7311008",
                "display" : "Anterior surface of arm"
              }
            ]
          }
        },
        "container" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "706052002",
                  "display" : "Evacuated blood collection tube"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:463ae6fe-60d4-4b38-84b3-1008e0925678",
      "resource" : {
        "resourceType" : "ServiceRequest",
        "id" : "463ae6fe-60d4-4b38-84b3-1008e0925678",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/servicerequest-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ServiceRequest_463ae6fe-60d4-4b38-84b3-1008e0925678\"> </a><p class=\"res-header-id\"><b>Generated Narrative: RichiestaDiServizio 463ae6fe-60d4-4b38-84b3-1008e0925678</b></p><a name=\"463ae6fe-60d4-4b38-84b3-1008e0925678\"> </a><a name=\"hc463ae6fe-60d4-4b38-84b3-1008e0925678\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-servicerequest-it-lab.html\">ServiceRequest - Lab Report</a></p></div><p><b>identifier</b>: 12345 (, period: 2023-03-15 --&gt; 2023-04-15)</p><p><b>requisition</b>: 1300A4000000248</p><p><b>status</b>: Completed</p><p><b>intent</b>: Order</p><p><b>category</b>: <span title=\"Codes:{http://snomed.info/sct 108252007}\">Laboratory procedure</span></p><p><b>priority</b>: Routine</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 5357009}\">Leukocyte poor blood preparation</span></p><p><b>subject</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5\">Maria Rossi  Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)</a></p><p><b>authoredOn</b>: 2023-03-15</p><p><b>reasonCode</b>: <span title=\"Codes:{http://snomed.info/sct 4307007}\">Pregestational diabetes mellitus AND/OR impaired glucose tolerance, modified White class F</span></p><p><b>specimen</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-168d4960-0a0b-43af-8025-180f0965f325\">Specimen: type = Whole blood</a></p></div>"
        },
        "identifier" : [
          {
            "value" : "12345",
            "period" : {
              "start" : "2023-03-15",
              "end" : "2023-04-15"
            }
          }
        ],
        "requisition" : {
          "value" : "1300A4000000248"
        },
        "status" : "completed",
        "intent" : "order",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "108252007",
                "display" : "Laboratory procedure"
              }
            ]
          }
        ],
        "priority" : "routine",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "5357009",
              "display" : "Leukocyte poor blood preparation"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
        },
        "authoredOn" : "2023-03-15",
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "4307007",
                "display" : "Pregestational diabetes mellitus AND/OR impaired glucose tolerance, modified White class F"
              }
            ]
          }
        ],
        "specimen" : [
          {
            "reference" : "urn:uuid:168d4960-0a0b-43af-8025-180f0965f325"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803c",
      "resource" : {
        "resourceType" : "PractitionerRole",
        "id" : "dc5842a1-83b6-43c7-b063-75ae989b803c",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"PractitionerRole_dc5842a1-83b6-43c7-b063-75ae989b803c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: PractitionerRole dc5842a1-83b6-43c7-b063-75ae989b803c</b></p><a name=\"dc5842a1-83b6-43c7-b063-75ae989b803c\"> </a><a name=\"hcdc5842a1-83b6-43c7-b063-75ae989b803c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-practitionerrole-it-lab.html\">PractitionerRole - Lab Report</a></p></div><p><b>identifier</b>: <code>http://esempio_policlinico.it/codiceEmatologo</code>/12345 (use: official, )</p><p><b>active</b>: true</p><p><b>practitioner</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803d\">Practitioner Prova Medico </a></p><p><b>organization</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8\">Organization Azienda Sanitara Locale Roma 1</a></p><p><b>code</b>: <span title=\"Codes:{urn:oid:2.16.840.1.113883.2.9.6.2.7 2211}\">Generalist Medical Practitioners</span></p><p><b>specialty</b>: <span title=\"Codes:{http://snomed.info/sct 394803006}\">Clinical hematology</span></p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "http://esempio_policlinico.it/codiceEmatologo",
            "value" : "12345"
          }
        ],
        "active" : true,
        "practitioner" : {
          "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803d"
        },
        "organization" : {
          "reference" : "urn:uuid:5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8"
        },
        "code" : [
          {
            "coding" : [
              {
                "system" : "urn:oid:2.16.840.1.113883.2.9.6.2.7",
                "code" : "2211",
                "display" : "Generalist Medical Practitioners"
              }
            ]
          }
        ],
        "specialty" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "394803006",
                "display" : "Clinical hematology"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803d",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "dc5842a1-83b6-43c7-b063-75ae989b803d",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_dc5842a1-83b6-43c7-b063-75ae989b803d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner dc5842a1-83b6-43c7-b063-75ae989b803d</b></p><a name=\"dc5842a1-83b6-43c7-b063-75ae989b803d\"> </a><a name=\"hcdc5842a1-83b6-43c7-b063-75ae989b803d\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-practitioner-it-lab.html\">Practitioner - Lab Report</a></p></div><p><b>identifier</b>: <code>http://hl7.it/sid/codiceFiscale</code>/MDCPRV80A01H501G (use: official, )</p><p><b>name</b>: Prova Medico </p><p><b>telecom</b>: <a href=\"mailto:medico.prova@policlinico.it\">medico.prova@policlinico.it</a>, ph: 331793423(Work)</p><p><b>gender</b>: Male</p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "http://hl7.it/sid/codiceFiscale",
            "value" : "MDCPRV80A01H501G"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "family" : "Medico",
            "given" : ["Prova"]
          }
        ],
        "telecom" : [
          {
            "system" : "email",
            "value" : "medico.prova@policlinico.it",
            "use" : "work",
            "rank" : 1
          },
          {
            "system" : "phone",
            "value" : "331793423",
            "use" : "work",
            "rank" : 2
          }
        ],
        "gender" : "male"
      }
    },
    {
      "fullUrl" : "urn:uuid:134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c</b></p><a name=\"134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c\"> </a><a name=\"hc134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-practitioner-it-lab.html\">Practitioner - Lab Report</a></p></div><p><b>identifier</b>: <code>http://hl7.it/sid/codiceFiscale</code>/NFRPRV80A01H501G (use: official, )</p><p><b>name</b>: Prova Infermiere </p><p><b>telecom</b>: <a href=\"mailto:infermiere.prova@policlinico.it\">infermiere.prova@policlinico.it</a>, ph: 331793553(Work)</p><p><b>gender</b>: Male</p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "http://hl7.it/sid/codiceFiscale",
            "value" : "NFRPRV80A01H501G"
          }
        ],
        "name" : [
          {
            "use" : "usual",
            "family" : "Infermiere",
            "given" : ["Prova"]
          }
        ],
        "telecom" : [
          {
            "system" : "email",
            "value" : "infermiere.prova@policlinico.it",
            "use" : "work",
            "rank" : 1
          },
          {
            "system" : "phone",
            "value" : "331793553",
            "use" : "work",
            "rank" : 2
          }
        ],
        "gender" : "male"
      }
    },
    {
      "fullUrl" : "urn:uuid:5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organizzazione 5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8</b></p><a name=\"5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8\"> </a><a name=\"hc5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-organization-it-lab.html\">Organization - Lab Report</a></p></div><p><b>identifier</b>: <code>http://hl7.it/sid/fls</code>/120201, <code>http://hl7.it/sid/vda/asl</code>/201</p><p><b>active</b>: true</p><p><b>type</b>: <span title=\"Codes:{http://hl7.it/fhir/lab-report/CodeSystem/it-tipoEntita asl}\">Azienda Sanitaria Locale</span></p><p><b>name</b>: Azienda Sanitara Locale Roma 1</p><h3>Contacts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Telecom</b></td></tr><tr><td style=\"display: none\">*</td><td>ph: 06 123456</td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://hl7.it/sid/fls",
            "value" : "120201"
          },
          {
            "system" : "http://hl7.it/sid/vda/asl",
            "value" : "201"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.it/fhir/lab-report/CodeSystem/it-tipoEntita",
                "code" : "asl",
                "display" : "Azienda Sanitaria Locale"
              }
            ]
          }
        ],
        "name" : "Azienda Sanitara Locale Roma 1",
        "contact" : [
          {
            "telecom" : [
              {
                "system" : "phone",
                "value" : "06 123456"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/organizationOperatore-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organizzazione ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8</b></p><a name=\"ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8\"> </a><a name=\"hcae0365ea-d8a1-45e0-a39d-f14fac4ccfe8\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-organizationOperatore-it-lab.html\">Organization operatore sanitario/socio sanitario - Lab Report</a></p></div><p><b>identifier</b>: <code>http://hl7.it/sid/fls</code>/020101</p><p><b>active</b>: true</p><p><b>type</b>: <span title=\"Codes:{http://hl7.it/fhir/lab-report/CodeSystem/it-tipoEntita asl}\">Azienda Sanitaria Locale</span></p><p><b>name</b>: AZIENDA U.S.L. VALLE D'AOSTA</p><p><b>telecom</b>: ph: (0165) 5431, fax: (0165) 544587, <a href=\"mailto:protocollo@pec.ausl.vda.it\">protocollo@pec.ausl.vda.it</a>, <a href=\"http://www.ausl.vda.it\">http://www.ausl.vda.it</a></p><p><b>address</b>: VIA GUIDO REY 1 AOSTA VALLE D'AOSTA 11100 IT </p></div>"
        },
        "identifier" : [
          {
            "system" : "http://hl7.it/sid/fls",
            "value" : "020101"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.it/fhir/lab-report/CodeSystem/it-tipoEntita",
                "code" : "asl",
                "display" : "Azienda Sanitaria Locale"
              }
            ]
          }
        ],
        "name" : "AZIENDA U.S.L. VALLE D'AOSTA",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "(0165) 5431"
          },
          {
            "system" : "fax",
            "value" : "(0165) 544587"
          },
          {
            "system" : "email",
            "value" : "protocollo@pec.ausl.vda.it"
          },
          {
            "system" : "url",
            "value" : "http://www.ausl.vda.it"
          }
        ],
        "address" : [
          {
            "line" : ["VIA GUIDO REY 1"],
            "city" : "AOSTA",
            "_city" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
                  "valueCoding" : {
                    "system" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-unitaAmministrativeTerritoriali",
                    "code" : "007003",
                    "display" : "AOSTA"
                  }
                }
              ]
            },
            "district" : "AO",
            "state" : "VALLE D'AOSTA",
            "_state" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
                  "valueCoding" : {
                    "system" : "http://hl7.it/fhir/lab-report/CodeSystem/minsan-regione",
                    "code" : "020",
                    "display" : "VALLE D'AOSTA"
                  }
                }
              ]
            },
            "postalCode" : "11100",
            "country" : "IT"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:f148e54a-2046-4534-b9e9-54e7e9632224",
      "resource" : {
        "resourceType" : "Location",
        "id" : "f148e54a-2046-4534-b9e9-54e7e9632224",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/location-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Location_f148e54a-2046-4534-b9e9-54e7e9632224\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Location f148e54a-2046-4534-b9e9-54e7e9632224</b></p><a name=\"f148e54a-2046-4534-b9e9-54e7e9632224\"> </a><a name=\"hcf148e54a-2046-4534-b9e9-54e7e9632224\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-location-it-lab.html\">Location - Lab Report</a></p></div><p><b>identifier</b>: 123456 (use: usual, )</p><p><b>status</b>: Active</p><p><b>name</b>: Policlinico di Roma</p><p><b>alias</b>: Poliambulatorio di Roma, Ospedale universitario di Roma</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-RoleCode HOSP}\">Hospital</span></p><p><b>telecom</b>: ph: 33324567</p><p><b>address</b>: ROMA 00144 </p></div>"
        },
        "identifier" : [
          {
            "use" : "usual",
            "value" : "123456"
          }
        ],
        "status" : "active",
        "name" : "Policlinico di Roma",
        "alias" : ["Poliambulatorio di Roma", "Ospedale universitario di Roma"],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
                "code" : "HOSP",
                "display" : "Hospital"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "33324567"
          }
        ],
        "address" : {
          "type" : "physical",
          "city" : "ROMA",
          "postalCode" : "00144"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:168d4960-0a0b-43af-8025-180f0965f324",
      "resource" : {
        "resourceType" : "Device",
        "id" : "168d4960-0a0b-43af-8025-180f0965f324",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/device-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Device_168d4960-0a0b-43af-8025-180f0965f324\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Dispositivo 168d4960-0a0b-43af-8025-180f0965f324</b></p><a name=\"168d4960-0a0b-43af-8025-180f0965f324\"> </a><a name=\"hc168d4960-0a0b-43af-8025-180f0965f324\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-device-it-lab.html\">Device - Lab Report</a></p></div><h3>DeviceNames</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Name</b></td><td><b>Type</b></td></tr><tr><td style=\"display: none\">*</td><td>Analizzatore Automatico</td><td>other</td></tr></table></div>"
        },
        "deviceName" : [
          {
            "name" : "Analizzatore Automatico",
            "type" : "other"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:059927b1-7e17-409e-ae60-68cc3c0b3aea",
      "resource" : {
        "resourceType" : "Media",
        "id" : "059927b1-7e17-409e-ae60-68cc3c0b3aea",
        "meta" : {
          "profile" : [
            "http://hl7.it/fhir/lab-report/StructureDefinition/media-it-lab"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Media_059927b1-7e17-409e-ae60-68cc3c0b3aea\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Media 059927b1-7e17-409e-ae60-68cc3c0b3aea</b></p><a name=\"059927b1-7e17-409e-ae60-68cc3c0b3aea\"> </a><a name=\"hc059927b1-7e17-409e-ae60-68cc3c0b3aea\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-media-it-lab.html\">Media - Lab Report</a></p></div><p><b>status</b>: Completed</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/media-type image}\">Image</span></p><p><b>subject</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5\">Maria Rossi  Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)</a></p><p><b>created</b>: 2023-06-21</p><p><b>issued</b>: 2023-06-21 14:56:18+0000</p><p><b>operator</b>: <a href=\"Bundle-Bundle-Lab-Esempio-2.html#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c\">PractitionerRole Generalist Medical Practitioners</a></p><p><b>height</b>: 128</p><p><b>width</b>: 128</p><blockquote><p><b>content</b></p><blockquote><p><b>id</b></p>a1</blockquote><p><b>contentType</b>: image/png</p><p><b>data</b>: (base64 data - 5,388 base64 chars)</p><p><b>creation</b>: 2023-06-21</p></blockquote></div>"
        },
        "status" : "completed",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/media-type",
              "code" : "image",
              "display" : "Image"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
        },
        "createdDateTime" : "2023-06-21",
        "issued" : "2023-06-21T14:56:18Z",
        "operator" : {
          "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803c"
        },
        "height" : 128,
        "width" : 128,
        "content" : {
          "id" : "a1",
          "contentType" : "image/png",
          "data" : "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",
          "creation" : "2023-06-21"
        }
      }
    }
  ]
}

```
