# Home - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ImplementationGuide/hl7.fhir.it.lab-report | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:HL7ITLabReport |

### Scopo

L'obiettivo della seguente guida è quello di definire, secondo lo standard HL7 FHIR versione R4, le specifiche per l'implementazione dei profili che verranno utilizzati nel referto di medicina di laboratorio nel contesto italiano.

### Definizione del Referto di Medicina di Laboratorio

Il referto di laboratorio appartiene al nucleo minimo dei documenti del Fascicolo Sanitario Elettronico. Ai sensi dell'articolo 27, comma 1, lettera d), del decreto n. 178 del 29 settembre 2015, il referto di laboratorio e' il documento redatto dal medico di medicina di laboratorio. Il contenuto informativo del Referto di Laboratorio è disciplinato all'art.2 dal Decreto del 18 maggio 2022 del Ministero della Salute ([Decreto Contenuti](https://www.gazzettaufficiale.it/eli/id/2022/07/11/22A03960)).

### Contesto

La guida intende fornire delle specifiche adeguate al contesto italiano secondo lo standard HL7 FHIR, per assicurare l’accuratezza dei risultati degli esami di laboratorio e la trasmissione degli stessi, al paziente o ad altra figura professionale, in modo chiaro e corretto. Questa guida implementativa è stata creata per descrivere in modo più completo gli elementi standard necessari per supportare lo scambio sia semantico che sintattico di informazioni inerenti al referto di laboratorio e viene sviluppata considerando come soggetto la risorsa Patient.

La guida può essere utilizzata per descrivere i risultati di laboratorio nei settori chiave della diagnostica in vitro, come:

* biochimica clinica
* ematologia
* medicina trasfusionale
* microbiologia
* immunologia.

### Navigazione

Questa guida implementativa utilizza come metodo di pubblicazione i tool web-based offerti dallo standard FHIR. Ciò consente una facile navigazione tra le varie risorse, i data type, i set di valori e altri componenti offerti dallo standard FHIR. Questo approccio consente inoltre agli implementatori di accedere facilmente alle informazioni necessarie per lo sviluppo di sistemi di interoperabilità.

### Dipendenze







### Details

#### Cross-Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.it.lab-report.r4)](package.r4.tgz) and [R4B (hl7.fhir.it.lab-report.r4b)](package.r4b.tgz) are available.

### Autori e contributori

| | | | |
| :--- | :--- | :--- | :--- |
| Autore | Leonardo Alcaro | HL7 Italia | leonardo.alcaro@teamdigitale.governo.it |
| Autore | Mario Sicuranza | HL7 Italia | mario.sicuranza@icar.cnr.it |
| Autore | Davide Spanu | EY Advisory S.p.A. | davide.spanu@it.ey.com |
| Autore | Valeria Cesaro' | EY Advisory S.p.A. | valeria.cesaro@it.ey.com |
| Autore | Maria Giovanna Antida Preziosi | SOGEI | mpreziosi@sogei.it |
| Contributore | Giorgio Cangioli | HL7 Italia | giorgio.cangioli@gmail.com |

### Intellectual Property Statements

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [contactRole2](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0131.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md) and [Patient/8472931c-fbd0-437b-9ed1-4f66472c78b5](Patient-8472931c-fbd0-437b-9ed1-4f66472c78b5.md)


* ISO Maintains the copyright on the country codes, and controls it's use carefully. For futher details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/5.3.0/CodeSystem-ISO3166Part1.html): [AddressItBase](StructureDefinition-address-it.md), [Autore](StructureDefinition-Autore.md)...Show 105 more,[BirthPlaceIta](StructureDefinition-birth-place-ita.md),[BundleRefertoLabIt](StructureDefinition-bundle-it-lab.md),[CSItTipoEntita](CodeSystem-it-tipoEntita.md),[Campione](StructureDefinition-Campione.md),[CompositionRefertoLabIt](StructureDefinition-composition-it-lab.md),[CsAifaAic](CodeSystem-aifa-aic.md),[CsContinente](CodeSystem-istat-continente.md),[CsIstatComuni](CodeSystem-istat-comuni.md),[CsIstatDug](CodeSystem-dug.md),[CsIstatEstere](CodeSystem-istat-unitaAmministrativeTerritorialiEstere.md),[CsIstatProfessioni](CodeSystem-istat-professioni.md),[CsIstatStatoCivile](CodeSystem-istat-statoCivile.md),[CsIstatTitoliStudio](CodeSystem-istat-ctsi03.md),[CsIstatUnitaAmministrativeTerritoriali](CodeSystem-istat-unitaAmministrativeTerritoriali.md),[CsItIdentifierType](CodeSystem-it-identifier-type.md),[CsItRoleCode](CodeSystem-it-V3RoleCode.md),[CsMDSASL](CodeSystem-cs-asl.md),[CsMDSIdStruttureInterne](CodeSystem-cs-mds-idStruttureInterne.md),[CsMDStruttureRicovero](CodeSystem-minsan-hsp.md),[CsMinSanRegioni](CodeSystem-minsan-regione.md),[CsProvinceISTAT](CodeSystem-province-istat.md),[CsRipartizionegeografica](CodeSystem-istat-ripartizione-geografica.md),[CsSupItAdministrativeGender](CodeSystem-administrative-gender.md),[CsSupItV3MaritalStatus](CodeSystem-v3-MaritalStatus.md),[CsTipoStruttura](CodeSystem-mds-tipo-struttura.md),[Destinatario](StructureDefinition-Destinatario.md),[DeviceRefertoLabIt](StructureDefinition-device-it-lab.md),[DiagnosticReportRefertoLabIt](StructureDefinition-diagnosticreport-it-lab.md),[EncounterRefertoLabIt](StructureDefinition-encounter-it-lab.md),[ExtCodeableBirthPlace](StructureDefinition-patient-codeableBirthPlace.md),[ExtDataEnterer](StructureDefinition-composition-dataenterer-it.md),[ExtDataEntererTIME](StructureDefinition-dataEnterer-time.md),[ExtDug](StructureDefinition-address-dug.md),[ExtProfessionePaziente](StructureDefinition-patient-occupation-it.md),[ExtRecordCertification](StructureDefinition-recordCertification.md),[ExtTitoloStudioPaziente](StructureDefinition-patient-qualification-it.md),[Firmatario](StructureDefinition-Firmatario.md),[HL7ITLabReport](index.md),[HL7_ISTAT_StatoCivile](ConceptMap-ConceptMap-statoCivile.md),[LabOrderCodes](ValueSet-lab-orderCodes-it-lab.md),[LocationRefertoLabIt](StructureDefinition-location-it-lab.md),[MediaRefertoLabIt](StructureDefinition-media-it-lab.md),[ObservationDocRefertoLabIt](StructureDefinition-observation-doc-it-lab.md),[ObservationGroupingRefertoLabIt](StructureDefinition-observation-grouping-it-lab.md),[ObservationRefertoLabIt](StructureDefinition-observation-it-lab.md),[ObservationStatusCodeLabReport](ValueSet-valueset-status-obs-it.md),[OfficialAddress](StructureDefinition-address-official.md),[OrganizationOperatoreSanitarioRefertoLabIt](StructureDefinition-organizationOperatore-it-lab.md),[OrganizationRefertoLabIt](StructureDefinition-organization-it-lab.md),[Organizer](StructureDefinition-Organizer.md),[PatientRefertoLabIt](StructureDefinition-patient-it-lab.md),[PractitionerRefertoLabIt](StructureDefinition-practitioner-it-lab.md),[PractitionerRoleMMGPLSRefertoLabIt](StructureDefinition-practitionerrole-MMGPLS-it-lab.md),[PractitionerRoleRefertoLabIt](StructureDefinition-practitionerrole-it-lab.md),[QuantityLab](StructureDefinition-quantity-it-lab.md),[RefertoLaboratorio](StructureDefinition-RefertoLaboratorio.md),[ResultLabEhn](StructureDefinition-Risultato.md),[Richiesta](StructureDefinition-Richiesta.md),[ServiceRequestRefertoLabIt](StructureDefinition-servicerequest-it-lab.md),[SoggettoCura](StructureDefinition-SoggettoCura.md),[SpecimenAdditiveSubstanceRefertoLabIt](StructureDefinition-substance-additive-specimen-it-lab.md),[SpecimenRefertoLabIt](StructureDefinition-specimen-it-lab.md),[UriIdEni](ValueSet-uri-idEni.md),[ValidatorLabEhn](StructureDefinition-Validatore.md),[VsAic](ValueSet-aifa-aic.md),[VsAnagrafiRegionali](ValueSet-vs-anagrafi-regionali.md),[VsEHICCountryCodes](ValueSet-iso-ehicCountryCode.md),[VsEHICPersonalIdOid](ValueSet-oid-ehicPersonalId.md),[VsGruppoSanguigno](ValueSet-results-observation-bloodgroup.md),[VsIcd9cm](ValueSet-who-icd9cm.md),[VsIstatCittadinanza](ValueSet-istat-cittadinanza.md),[VsIstatComune](ValueSet-istat-comune.md),[VsIstatDug](ValueSet-istat-dug.md),[VsIstatLuogoNascita](ValueSet-istat-luogoNascita.md),[VsIstatProfessionePaziente](ValueSet-istat-professione.md),[VsIstatProvincia](ValueSet-istat-provincia.md),[VsIstatStato](ValueSet-istat-stato.md),[VsIstatStatoCivile](ValueSet-istat-statoCivile-vs.md),[VsIstatTitoloStudio](ValueSet-istat-titoloStudio.md),[VsLabSpecimenAdditiveIt](ValueSet-additivo-campione-it.md),[VsLabSpecimenContainerIt](ValueSet-campione-container-lab-it.md),[VsLabSpecimenTypesIt](ValueSet-tipo-campione-lab-it.md),[VsMicroorganismiOsservazioni](ValueSet-results-microorganism-snomed-ct-ips-free-set.md),[VsMinisteroSaluteAsl](ValueSet-minsan-asl.md),[VsMinisteroSaluteEsenzioni](ValueSet-minsan-esenzioni.md),[VsMinisteroSaluteIdAziendeOspedaliere](ValueSet-minsan-idAziendeOspedaliere.md),[VsMinisteroSaluteIdStrutture](ValueSet-minsan-idStrutture.md),[VsMinisteroSaluteIdStruttureInterne](ValueSet-minsan-idStruttureInterne.md),[VsMinsanregione](ValueSet-minsan-regione.md),[VsMmgPlsRoles](ValueSet-mmgOrPls.md),[VsObservationBloodGroup](ValueSet-valueset-observation-value-bloodgroup.md),[VsObservationMicroorganismi](ValueSet-valueset-observation-value-microorganism.md),[VsObservationPresenzaAssenza](ValueSet-valueset-observation-value-presence-absence.md),[VsObservationValueCodeableConcept](ValueSet-valueset-valuecodeableconcept-obs-it.md),[VsResultsLaboratoryObservation](ValueSet-risultato-osservazione.md),[VsResultsPresenceAbsenceSnomedCtIpsFreeSet](ValueSet-results-presence-absence-snomed-ct-ips-free-set.md),[VsSezioniRefertoLaboratorio](ValueSet-sezione-referto-laboratorio.md),[VsStatoCivile](ValueSet-statoCivile.md),[VsTipoCampione](ValueSet-tipo-campione.md),[VsTipoCertificatore](ValueSet-tipoCertificatore.md),[VsTipoOrgSocioSanitaria](ValueSet-tipoOrgSocioSanitaria.md),[VsTipoOrganizzazione](ValueSet-tipoOrganizzazione.md),[VsURIIdStp](ValueSet-URI-idStp.md),[VsUriIdAslRegione](ValueSet-uri-idAslRegione.md)and[VstipoIdentificatore](ValueSet-VstipoIdentificatore.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/5.3.0/CodeSystem-v3-ucum.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)...Show 8 more,[Observation/5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c](Observation-5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c.md),[Observation/7e2f354b-de83-4472-bd07-1571cdb50fde](Observation-7e2f354b-de83-4472-bd07-1571cdb50fde.md),[Observation/9474efca-8c8a-436d-a1a4-5706a1dd057a](Observation-9474efca-8c8a-436d-a1a4-5706a1dd057a.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246.md),[Observation/a8a27a81-4543-45a9-8859-fa17053d963e](Observation-a8a27a81-4543-45a9-8859-fa17053d963e.md)and[QuantityLab](StructureDefinition-quantity-it-lab.md)


* The information in the various pages of the WHO web site is issued by the World Health Organization for general distribution. The information presented is protected under the Berne Convention for the Protection of Literature and Artistic works, under other international conventions and under national laws on copyright and neighbouring rights. Extracts of the information in the web site may be reviewed, reproduced or translated for research or private study but not for sale or for use in conjunction with commercial purposes. Any use of information in the web site should be accompanied by an acknowledgment of WHO as the source, citing the uniform resource locator (URL) of the article. Reproduction or translation of substantial portions of the web site, or any use other than for educational or other non-commercial purposes, require explicit, prior authorization in writing. Applications and enquiries should be addressed to the programme responsible for the page used. The designations employed and the presentation of the material in this publication do not imply the expression of any opinion whatsoever on the part of the World Health Organization concerning the legal status of any country, territory, city or area or of its authorities, or concerning the delimitation of its frontiers or boundaries. Dotted and dashed lines on maps represent approximate border lines for which there may not yet be full agreement. The mention of specific companies or of certain manufacturers' products does not imply that they are endorsed or recommended by the World Health Organization in preference to others of a similar nature that are not mentioned. Errors and omissions excepted, the names of proprietary products are distinguished by initial capital letters. The World Health Organization does not warrant that the information contained in the web site is complete and correct and shall not be liable whatsoever for any damages incurred as a result of its use.

* [ICD-9-CM](http://tx.fhir.org/r4/ValueSet/icd-9-cm): [VsIcd9cm](ValueSet-who-icd9cm.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/5.3.0/CodeSystem-v3-loinc.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)...Show 18 more,[Composition/2ae95a5c-9094-41a3-a437-ce6d34c55a54](Composition-2ae95a5c-9094-41a3-a437-ce6d34c55a54.md),[CompositionRefertoLabIt](StructureDefinition-composition-it-lab.md),[DiagnosticReport/56f19992-e73e-45b5-bbdd-6d9aeb60b15a](DiagnosticReport-56f19992-e73e-45b5-bbdd-6d9aeb60b15a.md),[DiagnosticReportRefertoLabIt](StructureDefinition-diagnosticreport-it-lab.md),[LabOrderCodes](ValueSet-lab-orderCodes-it-lab.md),[Observation/5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c](Observation-5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c.md),[Observation/7e2f354b-de83-4472-bd07-1571cdb50fde](Observation-7e2f354b-de83-4472-bd07-1571cdb50fde.md),[Observation/9474efca-8c8a-436d-a1a4-5706a1dd057a](Observation-9474efca-8c8a-436d-a1a4-5706a1dd057a.md),[Observation/Observation-Lab-Esempio-Group](Observation-Observation-Lab-Esempio-Group.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246.md),[Observation/a8a27a81-4543-45a9-8859-fa17053d963e](Observation-a8a27a81-4543-45a9-8859-fa17053d963e.md),[ObservationGroupingRefertoLabIt](StructureDefinition-observation-grouping-it-lab.md),[ObservationRefertoLabIt](StructureDefinition-observation-it-lab.md),[ServiceRequestRefertoLabIt](StructureDefinition-servicerequest-it-lab.md),[VsResultsLaboratoryObservation](ValueSet-risultato-osservazione.md)and[VsSezioniRefertoLaboratorio](ValueSet-sezione-referto-laboratorio.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)...Show 19 more,[DeviceRefertoLabIt](StructureDefinition-device-it-lab.md),[DiagnosticReport/56f19992-e73e-45b5-bbdd-6d9aeb60b15a](DiagnosticReport-56f19992-e73e-45b5-bbdd-6d9aeb60b15a.md),[ObservationRefertoLabIt](StructureDefinition-observation-it-lab.md),[PractitionerRole/dc5842a1-83b6-43c7-b063-75ae989b803c](PractitionerRole-dc5842a1-83b6-43c7-b063-75ae989b803c.md),[PractitionerRoleRefertoLabIt](StructureDefinition-practitionerrole-it-lab.md),[ServiceRequest/463ae6fe-60d4-4b38-84b3-1008e0925678](ServiceRequest-463ae6fe-60d4-4b38-84b3-1008e0925678.md),[Specimen/168d4960-0a0b-43af-8025-180f0965f325](Specimen-168d4960-0a0b-43af-8025-180f0965f325.md),[SpecimenAdditiveSubstanceRefertoLabIt](StructureDefinition-substance-additive-specimen-it-lab.md),[SpecimenRefertoLabIt](StructureDefinition-specimen-it-lab.md),[Substance/168d4960-0a0b-43af-8025-180f0965f326](Substance-168d4960-0a0b-43af-8025-180f0965f326.md),[VsGruppoSanguigno](ValueSet-results-observation-bloodgroup.md),[VsLabSpecimenAdditiveIt](ValueSet-additivo-campione-it.md),[VsLabSpecimenContainerIt](ValueSet-campione-container-lab-it.md),[VsLabSpecimenTypesIt](ValueSet-tipo-campione-lab-it.md),[VsMicroorganismiOsservazioni](ValueSet-results-microorganism-snomed-ct-ips-free-set.md),[VsObservationBloodGroup](ValueSet-valueset-observation-value-bloodgroup.md),[VsObservationMicroorganismi](ValueSet-valueset-observation-value-microorganism.md),[VsObservationPresenzaAssenza](ValueSet-valueset-observation-value-presence-absence.md)and[VsResultsPresenceAbsenceSnomedCtIpsFreeSet](ValueSet-results-presence-absence-snomed-ct-ips-free-set.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Observation Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)...Show 11 more,[Observation/5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c](Observation-5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c.md),[Observation/7e2f354b-de83-4472-bd07-1571cdb50fde](Observation-7e2f354b-de83-4472-bd07-1571cdb50fde.md),[Observation/9474efca-8c8a-436d-a1a4-5706a1dd057a](Observation-9474efca-8c8a-436d-a1a4-5706a1dd057a.md),[Observation/Observation-Lab-Esempio-Group](Observation-Observation-Lab-Esempio-Group.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245.md),[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246.md),[Observation/a8a27a81-4543-45a9-8859-fa17053d963e](Observation-a8a27a81-4543-45a9-8859-fa17053d963e.md),[ObservationDocRefertoLabIt](StructureDefinition-observation-doc-it-lab.md),[ObservationGroupingRefertoLabIt](StructureDefinition-observation-grouping-it-lab.md)and[ObservationRefertoLabIt](StructureDefinition-observation-it-lab.md)
* [Practitioner role](http://terminology.hl7.org/7.0.0/CodeSystem-practitioner-role.html): [PractitionerRoleRefertoLabIt](StructureDefinition-practitionerrole-it-lab.md)
* [identifierType](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0203.html): [PatientRefertoLabIt](StructureDefinition-patient-it-lab.md) and [VstipoIdentificatore](ValueSet-VstipoIdentificatore.md)
* [ActCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md), [Encounter/7b06368c-7089-4f66-acc8-29e1fcbd31f6](Encounter-7b06368c-7089-4f66-acc8-29e1fcbd31f6.md) and [EncounterRefertoLabIt](StructureDefinition-encounter-it-lab.md)
* [Confidentiality](http://terminology.hl7.org/7.0.0/CodeSystem-v3-Confidentiality.html): [CompositionRefertoLabIt](StructureDefinition-composition-it-lab.md)
* [MaritalStatus](http://terminology.hl7.org/7.0.0/CodeSystem-v3-MaritalStatus.html): [CsSupItV3MaritalStatus](CodeSystem-v3-MaritalStatus.md) and [VsStatoCivile](ValueSet-statoCivile.md)
* [NullFlavor](http://terminology.hl7.org/7.0.0/CodeSystem-v3-NullFlavor.html): [VsIstatComune](ValueSet-istat-comune.md), [VsIstatProvincia](ValueSet-istat-provincia.md) and [VsStatoCivile](ValueSet-statoCivile.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ObservationInterpretation.html): [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)
* [ParticipationType](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ParticipationType.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md) and [Encounter/7b06368c-7089-4f66-acc8-29e1fcbd31f6](Encounter-7b06368c-7089-4f66-acc8-29e1fcbd31f6.md)
* [RoleCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-RoleCode.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md)...Show 4 more,[ExtRecordCertification](StructureDefinition-recordCertification.md),[LocationRefertoLabIt](StructureDefinition-location-it-lab.md),[Policlinico di Roma](Location-f148e54a-2046-4534-b9e9-54e7e9632224.md)and[VsTipoCertificatore](ValueSet-tipoCertificatore.md)
* [SpecimenType](http://terminology.hl7.org/7.0.0/CodeSystem-v3-SpecimenType.html): [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md), [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md), [Specimen/168d4960-0a0b-43af-8025-180f0965f325](Specimen-168d4960-0a0b-43af-8025-180f0965f325.md), [SpecimenRefertoLabIt](StructureDefinition-specimen-it-lab.md) and [VsTipoCampione](ValueSet-tipo-campione.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.it.lab-report",
  "url" : "http://hl7.it/fhir/lab-report/ImplementationGuide/hl7.fhir.it.lab-report",
  "version" : "0.2.0",
  "name" : "HL7ITLabReport",
  "title" : "HL7 FHIR Implementation Guide Laboratory Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "HL7 FHIR Implementation Guide Laboratory Report specifica come utilizzare lo standard HL7 FHIR per documentare un referto di medicina di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.it.lab-report",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_eu_laboratory",
      "uri" : "http://hl7.eu/fhir/laboratory/ImplementationGuide/hl7.fhir.eu.laboratory",
      "packageId" : "hl7.fhir.eu.laboratory",
      "version" : "0.1.0"
    },
    {
      "id" : "hl7_fhir_uv_ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "1.1.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2022+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "trial-use"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/StructureDefinition/address-official"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/composition-basedOn-order-or-requisition-it"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/composition-dataenterer-it"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/dataEnterer-time"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/patient-occupation-it"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/patient-qualification-it"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/recordCertification"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/address-dug"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/lab-report/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2022+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "trial-use"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/StructureDefinition/address-official"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/composition-basedOn-order-or-requisition-it"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/composition-dataenterer-it"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/dataEnterer-time"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/patient-occupation-it"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/patient-qualification-it"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/recordCertification"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/StructureDefinition/address-dug"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.it/fhir/lab-report/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "LabReportLogicalModel",
        "name" : "Linee Guida Referto di Laboratorio",
        "description" : "Modelli Logici che rappresentano il contenuto informativo del Referto di Laboratorio."
      },
      {
        "id" : "LabReportDOC",
        "name" : "Profili Risorse Documento FHIR",
        "description" : "Profili risorse necessarie per produrre il documento FHIR Lab Report."
      },
      {
        "id" : "LabReportRES",
        "name" : "Profili Risorse",
        "description" : "Profili risorse specifiche per il dominio di Lab Report."
      },
      {
        "id" : "LabReportCSTerminology",
        "name" : "Terminology - Code Systems",
        "description" : "Codesystems per il dominio di Lab Report. I seguenti CodeSystems successivamente saranno spostati all'interno della Guida Terminologica Italiana."
      },
      {
        "id" : "LabReportVSTerminology",
        "name" : "Terminology - Value Sets",
        "description" : "ValueSets per il dominio di Lab Report. I seguenti ValueSets successivamente saranno spostati all'interno della Guida Terminologica Italiana."
      },
      {
        "id" : "LabReportCMTerminology",
        "name" : "Terminology - Concept Maps",
        "description" : "La seguente Concept Maps successivamente sarà spostata all'interno della Guida Terminologica Italiana."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RefertoLaboratorio"
        },
        "name" : "A - Referto di Laboratorio",
        "description" : "Referto di Laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportLogicalModel"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SoggettoCura"
        },
        "name" : "A.1.1, A.1.2 - Soggetto delle cure",
        "description" : "Paziente o Soggetto delle cure.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportLogicalModel"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Destinatario"
        },
        "name" : "A.1.4 - Informazioni Destinatario",
        "description" : "Destinatario delle informazioni (destinatario o destinatari del referto, ulteriori destinatari potrebbero essere individuati dal committente, ad es. medico di base, altro specialista), se applicabile.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportLogicalModel"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Autore"
        },
        "name" : "A.1.5 - Autore",
        "description" : "Autore (da chi è stato redatto il referto sui risultati di laboratorio o un sottoinsieme dei risultati).",
        "exampleBoolean" : false,
        "groupingId" : "LabReportLogicalModel"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Firmatario"
        },
        "name" : "A.1.6 - Firmatario",
        "description" : "Firmatario legale (La persona che si assume la responsabilità del contenuto medico del documento).",
        "exampleBoolean" : false,
        "groupingId" : "LabReportLogicalModel"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Validatore"
        },
        "name" : "A.1.7 - Validatore",
        "description" : "Validatore del documento.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportLogicalModel"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Richiesta"
        },
        "name" : "A.2,A.3 - Richiesta",
        "description" : "Informazioni sulla richiesta (A.2) e motivazioni (A3).",
        "exampleBoolean" : false,
        "groupingId" : "LabReportLogicalModel"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Campione"
        },
        "name" : "A.4 - Informazioni sul Campione",
        "description" : "Informazioni sul campione.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportLogicalModel"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Risultato"
        },
        "name" : "A.5 - Risultato",
        "description" : "Risultato dell'esame.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportLogicalModel"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/Organizer"
        },
        "name" : "A.6 - Organizer",
        "description" : "Risultato di un insieme di esami.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportLogicalModel"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/additivo-campione-it"
        },
        "name" : "Additivo Campione",
        "description" : "Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione dell'additivo utilizzato per il campione di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/address-it"
        },
        "name" : "Address - ITA",
        "description" : "Descrizione di Address con parti addizionali specifiche per gli indirizzi italiani. Questo profilo struttura l'elemento  Address.line in più parti, consente la codifica di alcune di queste parti e supporta la caratterizzazine degli indirizzi di tipo Residenza. Questa prima versione è ispirata al data type Address Olandese.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/birth-place-ita"
        },
        "name" : "Address Birth Place",
        "description" : "Definizione dell'indirizzo base per la descrizione del luogo di nascita.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/aifa-aic"
        },
        "name" : "AIFA - Autorizzazione Immissione in Commercio",
        "description" : "AIFA - Autorizzazione Immissione in Commercio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/aifa-aic"
        },
        "name" : "AIFA AIC",
        "description" : "AIFA - Codice identificativo dei medicinali ad uso umano",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/vs-anagrafi-regionali"
        },
        "name" : "Anagrafi Regionali",
        "description" : "Anagrafi Regionali",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/bundle-it-lab"
        },
        "name" : "Bundle - Lab Report",
        "description" : "Descrizione del contenuto informativo del report tramite il profilo della risorsa Bundle per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportDOC"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/Bundle-Lab-Esempio"
        },
        "name" : "Bundle document - Referto di Medicina di Laboratorio",
        "description" : "Esempio di un Bundle rappresentante un FHIR document completo di Referto di Medicina di Laboratorio.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/bundle-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/recordCertification"
        },
        "name" : "Certificazione",
        "description" : "Estensione usata per indicare che l'informazione associata è stata certificata (od autocertificata) da una certa entità (persona, organizzazione).  L'estensione è caratterizzata da: (a) una data di certificazione o da una periodo di validità (b) un codice od un riferimento al certificatore.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-codeableBirthPlace"
        },
        "name" : "Codice comune e/o stato di nascita",
        "description" : "Codice comune e/o stato di nascita.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/lab-orderCodes-it-lab"
        },
        "name" : "Codice Richiesta esame di Laboratorio [LOINC]",
        "description" : "Codice della richiesta per un esame di Laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/composition-it-lab"
        },
        "name" : "Composition - Lab Report",
        "description" : "Descrizione del referto di laboratorio tramite il profilo della risorsa Composition per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportDOC"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/campione-container-lab-it"
        },
        "name" : "Container Campione",
        "description" : "Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del container del campione di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/composition-dataenterer-it"
        },
        "name" : "DataEnterer",
        "description" : "Persona o dispositivo che trasforma un testo dettato nel documento FHIR.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/device-it-lab"
        },
        "name" : "Device - Lab Report",
        "description" : "Descrizione di un dispositivo tramite il profilo della risorsa Device per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/diagnosticreport-it-lab"
        },
        "name" : "DiagnosticReport - Lab Report",
        "description" : "Descrizione delle informazioni cliniche tramite il profilo della risorsa DiagnosticReport per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportDOC"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/56f19992-e73e-45b5-bbdd-6d9aeb60b15a"
        },
        "name" : "DiagnosticReport-Lab-Esempio",
        "description" : "Esempio di un report diagnostico: report prodotto durante l'incontro.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/diagnosticreport-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/address-dug"
        },
        "name" : "DUG (Denominazione Urbanistica Generica)",
        "description" : "Denominazione Urbanistica Ufficiale.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/oid-ehicPersonalId"
        },
        "name" : "EHIC Personal ID (system IDs - oid)",
        "description" : "Sistema di identificazione delle persone fisiche",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/encounter-it-lab"
        },
        "name" : "Encounter - Lab Report",
        "description" : "Descrizione dei dati relativi all'incontro per la specifica richiesta tramite il profilo della risorsa Encounter per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/7b06368c-7089-4f66-acc8-29e1fcbd31f6"
        },
        "name" : "Encounter-Lab-Esempio",
        "description" : "Esempio di incontro: informazioni di base per descrivere un incontro ambulatoriale pianificato.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/encounter-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/168d4960-0a0b-43af-8025-180f0965f324"
        },
        "name" : "Esempio di Device",
        "description" : "Esempio di device utilizzato per l'analisi dell'emocromo: Analizzatore per analisi del sangue",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/device-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8"
        },
        "name" : "Esempio di risorsa Organization che descrive le informazioni dell' operatore sanitario/socio sanitario",
        "description" : "Esempio di Organization: Azienda di Assistenza del paziente",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/organizationOperatore-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Substance"
          }
        ],
        "reference" : {
          "reference" : "Substance/168d4960-0a0b-43af-8025-180f0965f326"
        },
        "name" : "Esempio di Sostanza Additiva",
        "description" : "Esempio di campione: sangue prelevato dall'avambraccio del paziente.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/substance-additive-specimen-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/168d4960-0a0b-43af-8025-180f0965f325"
        },
        "name" : "EsempioCampione",
        "description" : "Esempio di campione: sangue prelevato dall'avambraccio del paziente.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/specimen-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/administrative-gender"
        },
        "name" : "HL7 Italia - AdministrativeGender (translation)",
        "description" : "HL7 Italia - Il genere di una persona, utilizzato per fini amministrativi.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/it-V3RoleCode"
        },
        "name" : "HL7 Italia - HL7 V3 RoleCode (estensione)",
        "description" : "HL7 Italia - Estensione del Vocabolario HL7 V3 RoleCode",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/it-identifier-type"
        },
        "name" : "HL7 Italia - Tipi di identificatore",
        "description" : "Estensione (codici addizionali) alla tabella  per i tipi di identificatore",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/it-tipoEntita"
        },
        "name" : "HL7 Italia - Tipo di Entità",
        "description" : "HL7 Italia - Codifica delle diverse entità che hanno compiuto, compiono od intendono compiere un certo atto. Per esempio la certificazione di un record Paziente",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/v3-MaritalStatus"
        },
        "name" : "HL7 Italia - v3 Code System MaritalStatus (translation)",
        "description" : "HL7 Italia - v3 Code System MaritalStatus (translation)",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/uri-idEni"
        },
        "name" : "Identificativi per codici ENI regionali",
        "description" : "Identificativi per codici ENI regionali.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/URI-idStp"
        },
        "name" : "Identificativi per codici STP regionali",
        "description" : "Identificativi per codici STP regionali.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/uri-idAslRegione"
        },
        "name" : "Identificativi regionali per ASL (3 char)",
        "description" : "Identificativi regionali per ASL a 3 caratteri, come da file ministeriale",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/address-official"
        },
        "name" : "IndirizzoUfficiale",
        "description" : "Definizione dell'indirizzo inteso come indirizzo 'ufficiale' di quella persona. Il significato di indirizzo 'ufficiale' dipende dal Paese. Questa estensione consente di specificare se questo indirizzo è o non è l'indirizzo ufficiale, oppure di indicare che si tratta dell'indirizzo ufficiale di quel Paese.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c"
        },
        "name" : "Infermiere-Lab-Esempio",
        "description" : "Esempio di un professionista sanitario: infermiere.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/iso-ehicCountryCode"
        },
        "name" : "ISO 3166 - EHIC Country Codes",
        "description" : "Codifica geografica standardizzata",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/istat-cittadinanza"
        },
        "name" : "ISTAT - Cittadinanza",
        "description" : "ISTAT - Cittadinanza",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/istat-ctsi03"
        },
        "name" : "ISTAT - Classificazione dei titoli di studio italiani",
        "description" : "ISTAT - Classificazione dei titoli di studio italiani",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/istat-professioni"
        },
        "name" : "ISTAT - Classificazione delle professioni",
        "description" : "ISTAT - Classificazione delle professioni",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/istat-luogoNascita"
        },
        "name" : "ISTAT - Comune/Stato di Nascita",
        "description" : "ISTAT - Comune/Stato di Nascita",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/istat-comune"
        },
        "name" : "ISTAT - Comuni",
        "description" : "ISTAT - Comuni più sconosciuto",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/istat-comuni"
        },
        "name" : "ISTAT - Comuni",
        "description" : "ISTAT - Comuni",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/istat-continente"
        },
        "name" : "ISTAT - Continente",
        "description" : "ISTAT - Continente",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/istat-dug"
        },
        "name" : "ISTAT - DUG",
        "description" : "ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG)",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/istat-professione"
        },
        "name" : "ISTAT - Professioni",
        "description" : "ISTAT - Professioni",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/istat-provincia"
        },
        "name" : "ISTAT - Province",
        "description" : "ISTAT - Province più sconosciuto",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/province-istat"
        },
        "name" : "ISTAT - Province",
        "description" : "ISTAT - Province",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/dug"
        },
        "name" : "ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG)",
        "description" : "ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG)",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/istat-ripartizione-geografica"
        },
        "name" : "ISTAT - Ripartizione Geografica",
        "description" : "ISTAT - Codice Istat della Ripartizione geografica secondo la suddivisione del territorio nazionale",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/istat-stato"
        },
        "name" : "ISTAT - Stati",
        "description" : "ISTAT - Stati",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/istat-statoCivile-vs"
        },
        "name" : "ISTAT - Stato Civile",
        "description" : "ISTAT - Stato Civile",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/istat-statoCivile"
        },
        "name" : "ISTAT - Stato Civile",
        "description" : "Tabella ISTAT Stato Civile",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/istat-titoloStudio"
        },
        "name" : "ISTAT - Titolo Studio",
        "description" : "ISTAT - Titolo Studio",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/istat-unitaAmministrativeTerritorialiEstere"
        },
        "name" : "ISTAT - Unita Amministrative Territoriali Estere",
        "description" : "ISTAT - Unita Amministrative Territoriali Estere",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/istat-unitaAmministrativeTerritoriali"
        },
        "name" : "ISTAT - Unità Amministrative Territoriali",
        "description" : "ISTAT - Unità Amministrative Territoriali",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/location-it-lab"
        },
        "name" : "Location - Lab Report",
        "description" : "Descrizione delle informazioni relative alle strutture fisiche tramite il profilo della risorsa Location per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/f148e54a-2046-4534-b9e9-54e7e9632224"
        },
        "name" : "Location-Lab-Esempio",
        "description" : "Esempio di location: struttura ospedaliera di Roma.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/location-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/ConceptMap-statoCivile"
        },
        "name" : "Mapping fra VS HL7 e Tabella ISTAT Stato Civile",
        "description" : "Mapping da Value 'statoCivile' a Tabella Istat Stato Civile.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCMTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/minsan-asl"
        },
        "name" : "MDS - ASL",
        "description" : "MDS - ASL",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cs-asl"
        },
        "name" : "MDS - ASL",
        "description" : "MDS - ASL",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/minsan-regione"
        },
        "name" : "MDS - Codici Regionali",
        "description" : "MDS - Codici Regionali usati nei file FLS11. La regione Trentino Alto-Adige è rappresentata dalle province autonome di cui è composta.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/minsan-regione"
        },
        "name" : "MDS - Codici Regioni / PPAA",
        "description" : "MDS - Codici Regioni / Province Autonome usati nei file FLS11.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/minsan-esenzioni"
        },
        "name" : "MDS - Esenzioni",
        "description" : "MDS - Codice Esenzioni",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/minsan-idAziendeOspedaliere"
        },
        "name" : "MDS - ID Aziende Ospedaliere",
        "description" : "MDS - Aziende Ospedaliere (HSP11)",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/minsan-idStruttureInterne"
        },
        "name" : "MDS - ID Strutture Interne di Ricovero",
        "description" : "MDS - Identificativi Strutture Interne di Ricovero",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cs-mds-idStruttureInterne"
        },
        "name" : "MDS - ID Strutture Interne di Ricovero",
        "description" : "MDS - Identificativi Strutture Interne di Ricovero",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/minsan-idStrutture"
        },
        "name" : "MDS - ID Strutture Ricovero",
        "description" : "MDS - Identificativi Strutture Ricovero (HSP11)",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/minsan-hsp"
        },
        "name" : "MDS - Strutture di Ricovero",
        "description" : "MDS - Strutture di Ricovero",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/mds-tipo-struttura"
        },
        "name" : "MDS - Tipo di Struttura per Srutture di ricovero",
        "description" : "MDS - TIpologia di Struttura che identifica le Strutture di ricovero",
        "exampleBoolean" : false,
        "groupingId" : "LabReportCSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/media-it-lab"
        },
        "name" : "Media - Lab Report",
        "description" : "Descrizione dei contenuti multimediali tramite il profilo della risorsa Media per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Media"
          }
        ],
        "reference" : {
          "reference" : "Media/059927b1-7e17-409e-ae60-68cc3c0b3aea"
        },
        "name" : "Media-Lab-Esempio",
        "description" : "Esempio di file multimediale: Valori di albumina ottenuti con elettroforesi.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/media-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/Bundle-Lab-Esempio-2"
        },
        "name" : "Microbiologia - DiagnosticReport - Observation - Specimen",
        "description" : "Esempio di un Report diagnostico per esame del sangue che mette in evidenza i risultati di microbiologia.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/observation-it-lab"
        },
        "name" : "Observation - Lab Report",
        "description" : "Descrizione delle rilevazioni cliniche tramite il profilo della risorsa Observation per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/observation-grouping-it-lab"
        },
        "name" : "Observation battery - Lab Report",
        "description" : "Descrizione di un inseme di esami tramite il profilo della risorsa Observation per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/observation-doc-it-lab"
        },
        "name" : "Observation Document - Lab Report",
        "description" : "Descrizione dei vincoli aggiuntivi per Observation-Lab Report tramite il profilo della risorsa Observation per il referto di laboratorio..",
        "exampleBoolean" : false,
        "groupingId" : "LabReportDOC"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/valueset-status-obs-it"
        },
        "name" : "Observation status code",
        "description" : "Valueset contenente i codici di di stato per la risorsa Observation Document - Lab Report.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c"
        },
        "name" : "Observation-Lab-Esempio-Cloruro",
        "description" : "Esempio di un'osservazione: rilevazione di cloruro nel sangue.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246"
        },
        "name" : "Observation-Lab-Esempio-Elettroforesi",
        "description" : "Esempio di un'osservazione: rilevazione di albumina da elettroforesi.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/7e2f354b-de83-4472-bd07-1571cdb50fde"
        },
        "name" : "Observation-Lab-Esempio-Glucosio",
        "description" : "Esempio di un'osservazione: rilevazione di glucosio nel sangue.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/observation-doc-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/Observation-Lab-Esempio-Group"
        },
        "name" : "Observation-Lab-Esempio-Group",
        "description" : "Esempio di contenitore per Battery Test: rilevazione di glucosio nel sangue.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/observation-grouping-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244"
        },
        "name" : "Observation-TimedTest-T0-Lab-Esempio",
        "description" : "Esempio di un'osservazione: rilevazione di insulina nel sangue a digiuno, dopo 30 minuti, dopo 60 minuti, dopo 90 minuti e dopo 120 minuti.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245"
        },
        "name" : "Observation-TimedTest-T1-Lab-Esempio",
        "description" : "Esempio di un'osservazione: rilevazione di insulina nel sangue dopo 30 minuti.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/9474efca-8c8a-436d-a1a4-5706a1dd057a"
        },
        "name" : "Observation-TimedTest-T2-Lab-Esempio",
        "description" : "Esempio di un'osservazione: rilevazione di insulina nel sangue dopo 60 minuti.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/a8a27a81-4543-45a9-8859-fa17053d963e"
        },
        "name" : "Observation-TimedTest-T3-Lab-Esempio",
        "description" : "Esempio di un'osservazione: rilevazione di insulina nel sangue dopo 90 minuti.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/organization-it-lab"
        },
        "name" : "Organization - Lab Report",
        "description" : "Descrizione delle informazioni relative all'organizzazione tramite il profilo della risorsa Organization per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/organizationOperatore-it-lab"
        },
        "name" : "Organization operatore sanitario/socio sanitario - Lab Report",
        "description" : "Descrizione delle informazioni relative all'operatore socio/sanitario tramite il profilo della risorsa Organization per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8"
        },
        "name" : "Organization-Lab-Esempio",
        "description" : "Esempio di un'organizzazione: Azienda Sanitaria Locale.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-it-lab"
        },
        "name" : "Patient - Lab Report",
        "description" : "Descrizione delle informazioni del paziente nei documenti FHIR.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportDOC"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/8472931c-fbd0-437b-9ed1-4f66472c78b5"
        },
        "name" : "Paziente-SSN",
        "description" : "Esempio di un paziente: soggetto iscritto al Sistema Sanitario Nazionale (SSN) con rappresentazione strutturata dell'attributo birthPlace.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitioner-it-lab"
        },
        "name" : "Practitioner - Lab Report",
        "description" : "Descrizione dei dati del professionista sanitario tramite il profilo della risorsa Practitioner per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/dc5842a1-83b6-43c7-b063-75ae989b803d"
        },
        "name" : "Practitioner-Lab-Esempio",
        "description" : "Esempio di un professionista sanitario: medico.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitionerrole-it-lab"
        },
        "name" : "PractitionerRole - Lab Report",
        "description" : "Descrizione delle informazioni relative al ruolo del professionista sanitario tramite il profilo della risorsa PractitionerRole per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/practitionerrole-MMGPLS-it-lab"
        },
        "name" : "PractitionerRole MMG/PLS - Lab Report",
        "description" : "Descrizione delle informazioni del MMG/PLS tramite il profilo della risorsa PractitionerRole per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/dc5842a1-83b6-43c7-b063-75ae989b803c"
        },
        "name" : "PractitionerRole-Lab-Esempio",
        "description" : "Esempio di un PractitionerRole: medico in ematologia clinica presso il policlinico.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/dc5842a1-83b6-43c7-b063-75ae989b803k"
        },
        "name" : "PractitionerRoleMMG-Lab-Esempio",
        "description" : "Esempio di un PractitionerRole: medico di medicina generale.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-MMGPLS-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-occupation-it"
        },
        "name" : "Professione del paziente",
        "description" : "Estensione per gestire la professione del paziente come CodeableConcept.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/quantity-it-lab"
        },
        "name" : "Quantity - Lab Report",
        "description" : "Descrizione del valore ottenuto da una misurazione.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/2ae95a5c-9094-41a3-a437-ce6d34c55a54"
        },
        "name" : "Referto di Laboratorio",
        "description" : "Esempio di Composition: esempio di referto di laboratorio.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/composition-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/valueset-valuecodeableconcept-obs-it"
        },
        "name" : "Risultato osservazione codificato",
        "description" : "Valueset contenente i codici per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/results-presence-absence-snomed-ct-ips-free-set"
        },
        "name" : "Risultato osservazione codificato -  presenza/assenza IPS di SNOMED CT",
        "description" : "Valueset che include i codici per i risultati di presenza o assenza dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/results-observation-bloodgroup"
        },
        "name" : "Risultato osservazione codificato - Gruppo Sanguigno IPS di SNOMED CT",
        "description" : "Valueset che include i codici per i risultati dei gruppi sanguigni dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/results-microorganism-snomed-ct-ips-free-set"
        },
        "name" : "Risultato osservazione codificato - microorganismo IPS di SNOMED CT",
        "description" : "Valueset che include i codici per i microrganismi dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/valueset-observation-value-bloodgroup"
        },
        "name" : "Risultato osservazione codificato gruppo sanguigno",
        "description" : "Valueset contenente i codici SNOMED di gruppo sanguigno per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/valueset-observation-value-microorganism"
        },
        "name" : "Risultato osservazione codificato microorganismi",
        "description" : "Valueset contenente i codici SNOMED di microorganismi per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/valueset-observation-value-presence-absence"
        },
        "name" : "Risultato osservazione codificato presenza/assenza",
        "description" : "Valueset contenente i codici SNOMED di presenza/assenza per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/servicerequest-it-lab"
        },
        "name" : "ServiceRequest - Lab Report",
        "description" : "Descrizione delle informazioni della prescrizione tramite il profilo della risorsa ServiceRequest per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/463ae6fe-60d4-4b38-84b3-1008e0925678"
        },
        "name" : "ServiceRequest-Lab-Esempio",
        "description" : "Esempio di richiesta: prestazione richiesta facente parte di un'autorizzazione simultanea per esami di laboratorio.",
        "exampleCanonical" : "http://hl7.it/fhir/lab-report/StructureDefinition/servicerequest-it-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/sezione-referto-laboratorio"
        },
        "name" : "Sezioni Composition Lab Report",
        "description" : "Valueset contenente i codici LOINC per la specialità di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/specimen-it-lab"
        },
        "name" : "Specimen - Lab Report",
        "description" : "Descrizione delle informazioni del campione tramite il profilo della risorsa Specimen per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/statoCivile"
        },
        "name" : "Stato Civile",
        "description" : "Questo value set definisce una serie di codici per rappresentare lo stato civile di una persona. Specializza ed estende il value set http://hl7.org/fhir/ValueSet/marital-status",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/substance-additive-specimen-it-lab"
        },
        "name" : "Substance (specimen additive) - Lab Report",
        "description" : "Descrizione dell'additivo usato sul campione tramite il profilo della risorsa Substance per il referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportRES"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/dataEnterer-time"
        },
        "name" : "TempoCompilazione",
        "description" : "Riferimento temporale.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/tipo-campione-lab-it"
        },
        "name" : "Tipo campione",
        "description" : "Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del tipo di campione di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/tipo-campione"
        },
        "name" : "Tipo Campione",
        "description" : "Tipo Campione",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/tipoCertificatore"
        },
        "name" : "Tipo certificatore",
        "description" : "Tipo di Entità (organizzazione o persona) che ha certificato un certo record",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/VstipoIdentificatore"
        },
        "name" : "Tipo identificatore",
        "description" : "Value set che descrivie i diversi tipi di identificatori. Include i codici della tabella http://terminology.hl7.org/CodeSystem/v2-0203 piu' 'STP' ed 'ENI'",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/mmgOrPls"
        },
        "name" : "Tipo medico di famiglia",
        "description" : "Tipo medico di famiglia: Medico Medicina Generale o Pediatra di Libera Scelta",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/tipoOrganizzazione"
        },
        "name" : "Tipo organizzazione (esempio)",
        "description" : "Tipo di organizzazione: value set di esempio",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/tipoOrgSocioSanitaria"
        },
        "name" : "Tipo organizzazione socio-sanitaria",
        "description" : "Tipo di organizzazione socio-sanitaria",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/risultato-osservazione"
        },
        "name" : "Tipo Osservazione",
        "description" : "Valueset contente i codici che identificano il tipo di osservazione nel referto di laboratorio.",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/patient-qualification-it"
        },
        "name" : "Titolo di Studio del paziente",
        "description" : "Estensione per gestire il Titolo di studio del paziente come CodeableConcept.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/who-icd9cm"
        },
        "name" : "WHO ICD-9-CM",
        "description" : "WHO ICD-9-CM",
        "exampleBoolean" : false,
        "groupingId" : "LabReportVSTerminology"
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "modelliLogici.html"
            }
          ],
          "nameUrl" : "modelliLogici.html",
          "title" : "Modelli Logici",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
