# Artifacts Summary - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Linee Guida Referto di Laboratorio 

Modelli Logici che rappresentano il contenuto informativo del Referto di Laboratorio.

| | |
| :--- | :--- |
| [A - Referto di Laboratorio](StructureDefinition-RefertoLaboratorio.md) | Referto di Laboratorio. |
| [A.1.1, A.1.2 - Soggetto delle cure](StructureDefinition-SoggettoCura.md) | Paziente o Soggetto delle cure. |
| [A.1.4 - Informazioni Destinatario](StructureDefinition-Destinatario.md) | Destinatario delle informazioni (destinatario o destinatari del referto, ulteriori destinatari potrebbero essere individuati dal committente, ad es. medico di base, altro specialista), se applicabile. |
| [A.1.5 - Autore](StructureDefinition-Autore.md) | Autore (da chi è stato redatto il referto sui risultati di laboratorio o un sottoinsieme dei risultati). |
| [A.1.6 - Firmatario](StructureDefinition-Firmatario.md) | Firmatario legale (La persona che si assume la responsabilità del contenuto medico del documento). |
| [A.1.7 - Validatore](StructureDefinition-Validatore.md) | Validatore del documento. |
| [A.2,A.3 - Richiesta](StructureDefinition-Richiesta.md) | Informazioni sulla richiesta (A.2) e motivazioni (A3). |
| [A.4 - Informazioni sul Campione](StructureDefinition-Campione.md) | Informazioni sul campione. |
| [A.5 - Risultato](StructureDefinition-Risultato.md) | Risultato dell'esame. |
| [A.6 - Organizer](StructureDefinition-Organizer.md) | Risultato di un insieme di esami. |

### Profili Risorse Documento FHIR 

Profili risorse necessarie per produrre il documento FHIR Lab Report.

| | |
| :--- | :--- |
| [Bundle - Lab Report](StructureDefinition-bundle-it-lab.md) | Descrizione del contenuto informativo del report tramite il profilo della risorsa Bundle per il referto di laboratorio. |
| [Composition - Lab Report](StructureDefinition-composition-it-lab.md) | Descrizione del referto di laboratorio tramite il profilo della risorsa Composition per il referto di laboratorio. |
| [DiagnosticReport - Lab Report](StructureDefinition-diagnosticreport-it-lab.md) | Descrizione delle informazioni cliniche tramite il profilo della risorsa DiagnosticReport per il referto di laboratorio. |
| [Observation Document - Lab Report](StructureDefinition-observation-doc-it-lab.md) | Descrizione dei vincoli aggiuntivi per Observation-Lab Report tramite il profilo della risorsa Observation per il referto di laboratorio.. |
| [Patient - Lab Report](StructureDefinition-patient-it-lab.md) | Descrizione delle informazioni del paziente nei documenti FHIR. |

### Profili Risorse 

Profili risorse specifiche per il dominio di Lab Report.

| | |
| :--- | :--- |
| [Device - Lab Report](StructureDefinition-device-it-lab.md) | Descrizione di un dispositivo tramite il profilo della risorsa Device per il referto di laboratorio. |
| [Encounter - Lab Report](StructureDefinition-encounter-it-lab.md) | Descrizione dei dati relativi all'incontro per la specifica richiesta tramite il profilo della risorsa Encounter per il referto di laboratorio. |
| [Location - Lab Report](StructureDefinition-location-it-lab.md) | Descrizione delle informazioni relative alle strutture fisiche tramite il profilo della risorsa Location per il referto di laboratorio. |
| [Media - Lab Report](StructureDefinition-media-it-lab.md) | Descrizione dei contenuti multimediali tramite il profilo della risorsa Media per il referto di laboratorio. |
| [Observation - Lab Report](StructureDefinition-observation-it-lab.md) | Descrizione delle rilevazioni cliniche tramite il profilo della risorsa Observation per il referto di laboratorio. |
| [Observation battery - Lab Report](StructureDefinition-observation-grouping-it-lab.md) | Descrizione di un inseme di esami tramite il profilo della risorsa Observation per il referto di laboratorio. |
| [Organization - Lab Report](StructureDefinition-organization-it-lab.md) | Descrizione delle informazioni relative all'organizzazione tramite il profilo della risorsa Organization per il referto di laboratorio. |
| [Organization operatore sanitario/socio sanitario - Lab Report](StructureDefinition-organizationOperatore-it-lab.md) | Descrizione delle informazioni relative all'operatore socio/sanitario tramite il profilo della risorsa Organization per il referto di laboratorio. |
| [Practitioner - Lab Report](StructureDefinition-practitioner-it-lab.md) | Descrizione dei dati del professionista sanitario tramite il profilo della risorsa Practitioner per il referto di laboratorio. |
| [PractitionerRole - Lab Report](StructureDefinition-practitionerrole-it-lab.md) | Descrizione delle informazioni relative al ruolo del professionista sanitario tramite il profilo della risorsa PractitionerRole per il referto di laboratorio. |
| [PractitionerRole MMG/PLS - Lab Report](StructureDefinition-practitionerrole-MMGPLS-it-lab.md) | Descrizione delle informazioni del MMG/PLS tramite il profilo della risorsa PractitionerRole per il referto di laboratorio. |
| [ServiceRequest - Lab Report](StructureDefinition-servicerequest-it-lab.md) | Descrizione delle informazioni della prescrizione tramite il profilo della risorsa ServiceRequest per il referto di laboratorio. |
| [Specimen - Lab Report](StructureDefinition-specimen-it-lab.md) | Descrizione delle informazioni del campione tramite il profilo della risorsa Specimen per il referto di laboratorio. |
| [Substance (specimen additive) - Lab Report](StructureDefinition-substance-additive-specimen-it-lab.md) | Descrizione dell'additivo usato sul campione tramite il profilo della risorsa Substance per il referto di laboratorio. |

### Terminology - Code Systems 

Codesystems per il dominio di Lab Report. I seguenti CodeSystems successivamente saranno spostati all'interno della Guida Terminologica Italiana.

| | |
| :--- | :--- |
| [AIFA - Autorizzazione Immissione in Commercio](CodeSystem-aifa-aic.md) | AIFA - Autorizzazione Immissione in Commercio. |
| [HL7 Italia - AdministrativeGender (translation)](CodeSystem-administrative-gender.md) | HL7 Italia - Il genere di una persona, utilizzato per fini amministrativi. |
| [HL7 Italia - HL7 V3 RoleCode (estensione)](CodeSystem-it-V3RoleCode.md) | HL7 Italia - Estensione del Vocabolario HL7 V3 RoleCode |
| [HL7 Italia - Tipi di identificatore](CodeSystem-it-identifier-type.md) | Estensione (codici addizionali) alla tabella per i tipi di identificatore |
| [HL7 Italia - Tipo di Entità](CodeSystem-it-tipoEntita.md) | HL7 Italia - Codifica delle diverse entità che hanno compiuto, compiono od intendono compiere un certo atto. Per esempio la certificazione di un record Paziente |
| [HL7 Italia - v3 Code System MaritalStatus (translation)](CodeSystem-v3-MaritalStatus.md) | HL7 Italia - v3 Code System MaritalStatus (translation) |
| [ISTAT - Classificazione dei titoli di studio italiani](CodeSystem-istat-ctsi03.md) | ISTAT - Classificazione dei titoli di studio italiani |
| [ISTAT - Classificazione delle professioni](CodeSystem-istat-professioni.md) | ISTAT - Classificazione delle professioni |
| [ISTAT - Comuni](CodeSystem-istat-comuni.md) | ISTAT - Comuni |
| [ISTAT - Continente](CodeSystem-istat-continente.md) | ISTAT - Continente |
| [ISTAT - Province](CodeSystem-province-istat.md) | ISTAT - Province |
| [ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG)](CodeSystem-dug.md) | ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG) |
| [ISTAT - Ripartizione Geografica](CodeSystem-istat-ripartizione-geografica.md) | ISTAT - Codice Istat della Ripartizione geografica secondo la suddivisione del territorio nazionale |
| [ISTAT - Stato Civile](CodeSystem-istat-statoCivile.md) | Tabella ISTAT Stato Civile |
| [ISTAT - Unita Amministrative Territoriali Estere](CodeSystem-istat-unitaAmministrativeTerritorialiEstere.md) | ISTAT - Unita Amministrative Territoriali Estere |
| [ISTAT - Unità Amministrative Territoriali](CodeSystem-istat-unitaAmministrativeTerritoriali.md) | ISTAT - Unità Amministrative Territoriali |
| [MDS - ASL](CodeSystem-cs-asl.md) | MDS - ASL |
| [MDS - Codici Regioni / PPAA](CodeSystem-minsan-regione.md) | MDS - Codici Regioni / Province Autonome usati nei file FLS11. |
| [MDS - ID Strutture Interne di Ricovero](CodeSystem-cs-mds-idStruttureInterne.md) | MDS - Identificativi Strutture Interne di Ricovero |
| [MDS - Strutture di Ricovero](CodeSystem-minsan-hsp.md) | MDS - Strutture di Ricovero |
| [MDS - Tipo di Struttura per Srutture di ricovero](CodeSystem-mds-tipo-struttura.md) | MDS - TIpologia di Struttura che identifica le Strutture di ricovero |

### Terminology - Value Sets 

ValueSets per il dominio di Lab Report. I seguenti ValueSets successivamente saranno spostati all'interno della Guida Terminologica Italiana.

| | |
| :--- | :--- |
| [Additivo Campione](ValueSet-additivo-campione-it.md) | Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione dell'additivo utilizzato per il campione di laboratorio. |
| [AIFA AIC](ValueSet-aifa-aic.md) | AIFA - Codice identificativo dei medicinali ad uso umano |
| [Anagrafi Regionali](ValueSet-vs-anagrafi-regionali.md) | Anagrafi Regionali |
| [Codice Richiesta esame di Laboratorio [LOINC]](ValueSet-lab-orderCodes-it-lab.md) | Codice della richiesta per un esame di Laboratorio. |
| [Container Campione](ValueSet-campione-container-lab-it.md) | Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del container del campione di laboratorio. |
| [EHIC Personal ID (system IDs - oid)](ValueSet-oid-ehicPersonalId.md) | Sistema di identificazione delle persone fisiche |
| [Identificativi per codici ENI regionali](ValueSet-uri-idEni.md) | Identificativi per codici ENI regionali. |
| [Identificativi per codici STP regionali](ValueSet-URI-idStp.md) | Identificativi per codici STP regionali. |
| [Identificativi regionali per ASL (3 char)](ValueSet-uri-idAslRegione.md) | Identificativi regionali per ASL a 3 caratteri, come da file ministeriale |
| [ISO 3166 - EHIC Country Codes](ValueSet-iso-ehicCountryCode.md) | Codifica geografica standardizzata |
| [ISTAT - Cittadinanza](ValueSet-istat-cittadinanza.md) | ISTAT - Cittadinanza |
| [ISTAT - Comune/Stato di Nascita](ValueSet-istat-luogoNascita.md) | ISTAT - Comune/Stato di Nascita |
| [ISTAT - Comuni](ValueSet-istat-comune.md) | ISTAT - Comuni più sconosciuto |
| [ISTAT - DUG](ValueSet-istat-dug.md) | ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG) |
| [ISTAT - Professioni](ValueSet-istat-professione.md) | ISTAT - Professioni |
| [ISTAT - Province](ValueSet-istat-provincia.md) | ISTAT - Province più sconosciuto |
| [ISTAT - Stati](ValueSet-istat-stato.md) | ISTAT - Stati |
| [ISTAT - Stato Civile](ValueSet-istat-statoCivile-vs.md) | ISTAT - Stato Civile |
| [ISTAT - Titolo Studio](ValueSet-istat-titoloStudio.md) | ISTAT - Titolo Studio |
| [MDS - ASL](ValueSet-minsan-asl.md) | MDS - ASL |
| [MDS - Codici Regionali](ValueSet-minsan-regione.md) | MDS - Codici Regionali usati nei file FLS11. La regione Trentino Alto-Adige è rappresentata dalle province autonome di cui è composta. |
| [MDS - Esenzioni](ValueSet-minsan-esenzioni.md) | MDS - Codice Esenzioni |
| [MDS - ID Aziende Ospedaliere](ValueSet-minsan-idAziendeOspedaliere.md) | MDS - Aziende Ospedaliere (HSP11) |
| [MDS - ID Strutture Interne di Ricovero](ValueSet-minsan-idStruttureInterne.md) | MDS - Identificativi Strutture Interne di Ricovero |
| [MDS - ID Strutture Ricovero](ValueSet-minsan-idStrutture.md) | MDS - Identificativi Strutture Ricovero (HSP11) |
| [Observation status code](ValueSet-valueset-status-obs-it.md) | Valueset contenente i codici di di stato per la risorsa Observation Document - Lab Report. |
| [Risultato osservazione codificato](ValueSet-valueset-valuecodeableconcept-obs-it.md) | Valueset contenente i codici per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Risultato osservazione codificato - presenza/assenza IPS di SNOMED CT](ValueSet-results-presence-absence-snomed-ct-ips-free-set.md) | Valueset che include i codici per i risultati di presenza o assenza dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT. |
| [Risultato osservazione codificato - Gruppo Sanguigno IPS di SNOMED CT](ValueSet-results-observation-bloodgroup.md) | Valueset che include i codici per i risultati dei gruppi sanguigni dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT. |
| [Risultato osservazione codificato - microorganismo IPS di SNOMED CT](ValueSet-results-microorganism-snomed-ct-ips-free-set.md) | Valueset che include i codici per i microrganismi dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT. |
| [Risultato osservazione codificato gruppo sanguigno](ValueSet-valueset-observation-value-bloodgroup.md) | Valueset contenente i codici SNOMED di gruppo sanguigno per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Risultato osservazione codificato microorganismi](ValueSet-valueset-observation-value-microorganism.md) | Valueset contenente i codici SNOMED di microorganismi per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Risultato osservazione codificato presenza/assenza](ValueSet-valueset-observation-value-presence-absence.md) | Valueset contenente i codici SNOMED di presenza/assenza per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Sezioni Composition Lab Report](ValueSet-sezione-referto-laboratorio.md) | Valueset contenente i codici LOINC per la specialità di laboratorio. |
| [Stato Civile](ValueSet-statoCivile.md) | Questo value set definisce una serie di codici per rappresentare lo stato civile di una persona. Specializza ed estende il value set http://hl7.org/fhir/ValueSet/marital-status |
| [Tipo campione](ValueSet-tipo-campione-lab-it.md) | Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del tipo di campione di laboratorio. |
| [Tipo Campione](ValueSet-tipo-campione.md) | Tipo Campione |
| [Tipo certificatore](ValueSet-tipoCertificatore.md) | Tipo di Entità (organizzazione o persona) che ha certificato un certo record |
| [Tipo identificatore](ValueSet-VstipoIdentificatore.md) | Value set che descrivie i diversi tipi di identificatori. Include i codici della tabella http://terminology.hl7.org/CodeSystem/v2-0203 piu' 'STP' ed 'ENI' |
| [Tipo medico di famiglia](ValueSet-mmgOrPls.md) | Tipo medico di famiglia: Medico Medicina Generale o Pediatra di Libera Scelta |
| [Tipo organizzazione (esempio)](ValueSet-tipoOrganizzazione.md) | Tipo di organizzazione: value set di esempio |
| [Tipo organizzazione socio-sanitaria](ValueSet-tipoOrgSocioSanitaria.md) | Tipo di organizzazione socio-sanitaria |
| [Tipo Osservazione](ValueSet-risultato-osservazione.md) | Valueset contente i codici che identificano il tipo di osservazione nel referto di laboratorio. |
| [WHO ICD-9-CM](ValueSet-who-icd9cm.md) | WHO ICD-9-CM |

### Terminology - Concept Maps 

La seguente Concept Maps successivamente sarà spostata all'interno della Guida Terminologica Italiana.

| | |
| :--- | :--- |
| [Mapping fra VS HL7 e Tabella ISTAT Stato Civile](ConceptMap-ConceptMap-statoCivile.md) | Mapping da Value 'statoCivile' a Tabella Istat Stato Civile. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Address - ITA](StructureDefinition-address-it.md) | Descrizione di Address con parti addizionali specifiche per gli indirizzi italiani. Questo profilo struttura l'elemento Address.line in più parti, consente la codifica di alcune di queste parti e supporta la caratterizzazine degli indirizzi di tipo Residenza. Questa prima versione è ispirata al data type Address Olandese. |
| [Quantity - Lab Report](StructureDefinition-quantity-it-lab.md) | Descrizione del valore ottenuto da una misurazione. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Address Birth Place](StructureDefinition-birth-place-ita.md) | Definizione dell'indirizzo base per la descrizione del luogo di nascita. |
| [Certificazione](StructureDefinition-recordCertification.md) | Estensione usata per indicare che l'informazione associata è stata certificata (od autocertificata) da una certa entità (persona, organizzazione). L'estensione è caratterizzata da: (a) una data di certificazione o da una periodo di validità (b) un codice od un riferimento al certificatore. |
| [Codice comune e/o stato di nascita](StructureDefinition-patient-codeableBirthPlace.md) | Codice comune e/o stato di nascita. |
| [DUG (Denominazione Urbanistica Generica)](StructureDefinition-address-dug.md) | Denominazione Urbanistica Ufficiale. |
| [DataEnterer](StructureDefinition-composition-dataenterer-it.md) | Persona o dispositivo che trasforma un testo dettato nel documento FHIR. |
| [IndirizzoUfficiale](StructureDefinition-address-official.md) | Definizione dell'indirizzo inteso come indirizzo 'ufficiale' di quella persona. Il significato di indirizzo 'ufficiale' dipende dal Paese. Questa estensione consente di specificare se questo indirizzo è o non è l'indirizzo ufficiale, oppure di indicare che si tratta dell'indirizzo ufficiale di quel Paese. |
| [Professione del paziente](StructureDefinition-patient-occupation-it.md) | Estensione per gestire la professione del paziente come CodeableConcept. |
| [TempoCompilazione](StructureDefinition-dataEnterer-time.md) | Riferimento temporale. |
| [Titolo di Studio del paziente](StructureDefinition-patient-qualification-it.md) | Estensione per gestire il Titolo di studio del paziente come CodeableConcept. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Bundle document - Referto di Medicina di Laboratorio](Bundle-Bundle-Lab-Esempio.md) | Esempio di un Bundle rappresentante un FHIR document completo di Referto di Medicina di Laboratorio. |
| [DiagnosticReport-Lab-Esempio](DiagnosticReport-56f19992-e73e-45b5-bbdd-6d9aeb60b15a.md) | Esempio di un report diagnostico: report prodotto durante l'incontro. |
| [Encounter-Lab-Esempio](Encounter-7b06368c-7089-4f66-acc8-29e1fcbd31f6.md) | Esempio di incontro: informazioni di base per descrivere un incontro ambulatoriale pianificato. |
| [Esempio di Device](Device-168d4960-0a0b-43af-8025-180f0965f324.md) | Esempio di device utilizzato per l'analisi dell'emocromo: Analizzatore per analisi del sangue |
| [Esempio di Sostanza Additiva](Substance-168d4960-0a0b-43af-8025-180f0965f326.md) | Esempio di campione: sangue prelevato dall'avambraccio del paziente. |
| [Esempio di risorsa Organization che descrive le informazioni dell' operatore sanitario/socio sanitario](Organization-ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8.md) | Esempio di Organization: Azienda di Assistenza del paziente |
| [EsempioCampione](Specimen-168d4960-0a0b-43af-8025-180f0965f325.md) | Esempio di campione: sangue prelevato dall'avambraccio del paziente. |
| [Infermiere-Lab-Esempio](Practitioner-134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c.md) | Esempio di un professionista sanitario: infermiere. |
| [Location-Lab-Esempio](Location-f148e54a-2046-4534-b9e9-54e7e9632224.md) | Esempio di location: struttura ospedaliera di Roma. |
| [Media-Lab-Esempio](Media-059927b1-7e17-409e-ae60-68cc3c0b3aea.md) | Esempio di file multimediale: Valori di albumina ottenuti con elettroforesi. |
| [Microbiologia - DiagnosticReport - Observation - Specimen](Bundle-Bundle-Lab-Esempio-2.md) | Esempio di un Report diagnostico per esame del sangue che mette in evidenza i risultati di microbiologia. |
| [Observation-Lab-Esempio-Cloruro](Observation-5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c.md) | Esempio di un'osservazione: rilevazione di cloruro nel sangue. |
| [Observation-Lab-Esempio-Elettroforesi](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246.md) | Esempio di un'osservazione: rilevazione di albumina da elettroforesi. |
| [Observation-Lab-Esempio-Glucosio](Observation-7e2f354b-de83-4472-bd07-1571cdb50fde.md) | Esempio di un'osservazione: rilevazione di glucosio nel sangue. |
| [Observation-Lab-Esempio-Group](Observation-Observation-Lab-Esempio-Group.md) | Esempio di contenitore per Battery Test: rilevazione di glucosio nel sangue. |
| [Observation-TimedTest-T0-Lab-Esempio](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244.md) | Esempio di un'osservazione: rilevazione di insulina nel sangue a digiuno, dopo 30 minuti, dopo 60 minuti, dopo 90 minuti e dopo 120 minuti. |
| [Observation-TimedTest-T1-Lab-Esempio](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245.md) | Esempio di un'osservazione: rilevazione di insulina nel sangue dopo 30 minuti. |
| [Observation-TimedTest-T2-Lab-Esempio](Observation-9474efca-8c8a-436d-a1a4-5706a1dd057a.md) | Esempio di un'osservazione: rilevazione di insulina nel sangue dopo 60 minuti. |
| [Observation-TimedTest-T3-Lab-Esempio](Observation-a8a27a81-4543-45a9-8859-fa17053d963e.md) | Esempio di un'osservazione: rilevazione di insulina nel sangue dopo 90 minuti. |
| [Organization-Lab-Esempio](Organization-5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8.md) | Esempio di un'organizzazione: Azienda Sanitaria Locale. |
| [Paziente-SSN](Patient-8472931c-fbd0-437b-9ed1-4f66472c78b5.md) | Esempio di un paziente: soggetto iscritto al Sistema Sanitario Nazionale (SSN) con rappresentazione strutturata dell'attributo birthPlace. |
| [Practitioner-Lab-Esempio](Practitioner-dc5842a1-83b6-43c7-b063-75ae989b803d.md) | Esempio di un professionista sanitario: medico. |
| [PractitionerRole-Lab-Esempio](PractitionerRole-dc5842a1-83b6-43c7-b063-75ae989b803c.md) | Esempio di un PractitionerRole: medico in ematologia clinica presso il policlinico. |
| [PractitionerRoleMMG-Lab-Esempio](PractitionerRole-dc5842a1-83b6-43c7-b063-75ae989b803k.md) | Esempio di un PractitionerRole: medico di medicina generale. |
| [Referto di Laboratorio](Composition-2ae95a5c-9094-41a3-a437-ce6d34c55a54.md) | Esempio di Composition: esempio di referto di laboratorio. |
| [ServiceRequest-Lab-Esempio](ServiceRequest-463ae6fe-60d4-4b38-84b3-1008e0925678.md) | Esempio di richiesta: prestazione richiesta facente parte di un'autorizzazione simultanea per esami di laboratorio. |

