# Risultato osservazione codificato - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risultato osservazione codificato**

## ValueSet: Risultato osservazione codificato 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ValueSet/valueset-valuecodeableconcept-obs-it | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:VsObservationValueCodeableConcept |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Valueset contenente i codici per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. 

 **References** 

* [Observation - Lab Report](StructureDefinition-observation-it-lab.md)

### Logical Definition (CLD)

Profile: [Shareable ValueSet](http://hl7.org/fhir/R4/shareablevalueset.html)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [Risultato osservazione codificato microorganismi](ValueSet-valueset-observation-value-microorganism.md)
* Import all the codes that are contained in [Risultato osservazione codificato gruppo sanguigno](ValueSet-valueset-observation-value-bloodgroup.md)
* Import all the codes that are contained in [Risultato osservazione codificato presenza/assenza](ValueSet-valueset-observation-value-presence-absence.md)

 

### Expansion

Expansion from tx.fhir.org based on:

* SNOMED CT International edition 01-Feb 2025
* [valueset Risultato osservazione codificato gruppo sanguigno v0.2.0 (ValueSet)](ValueSet-valueset-observation-value-bloodgroup.md)
* [valueset Risultato osservazione codificato microorganismi v0.2.0 (ValueSet)](ValueSet-valueset-observation-value-microorganism.md)
* [valueset Risultato osservazione codificato presenza/assenza v0.2.0 (ValueSet)](ValueSet-valueset-observation-value-presence-absence.md)

This value set has >1000 codes in it. In order to keep the publication size manageable, only a selection (1000 codes) of the whole set of codes is shown

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "valueset-valuecodeableconcept-obs-it",
  "meta" : {
    "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
  },
  "url" : "http://hl7.it/fhir/lab-report/ValueSet/valueset-valuecodeableconcept-obs-it",
  "version" : "0.2.0",
  "name" : "VsObservationValueCodeableConcept",
  "title" : "Risultato osservazione codificato",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Valueset contenente i codici per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://hl7.it/fhir/lab-report/ValueSet/valueset-observation-value-microorganism"
        ]
      },
      {
        "valueSet" : [
          "http://hl7.it/fhir/lab-report/ValueSet/valueset-observation-value-bloodgroup"
        ]
      },
      {
        "valueSet" : [
          "http://hl7.it/fhir/lab-report/ValueSet/valueset-observation-value-presence-absence"
        ]
      }
    ]
  }
}

```
