# Identificativi per codici ENI regionali - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Identificativi per codici ENI regionali**

## ValueSet: Identificativi per codici ENI regionali 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ValueSet/uri-idEni | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:UriIdEni |
| **Copyright/Legal**: Copyright (C) The Internet Society (2005) | |

 
Identificativi per codici ENI regionali. 

 **References** 

* [Patient - Lab Report](StructureDefinition-patient-it-lab.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on codesystem unknown version n/a

This value set contains 5 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "uri-idEni",
  "url" : "http://hl7.it/fhir/lab-report/ValueSet/uri-idEni",
  "version" : "0.2.0",
  "name" : "UriIdEni",
  "title" : "Identificativi per codici ENI regionali",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Identificativi per codici ENI regionali.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "Copyright (C) The Internet Society (2005)",
  "compose" : {
    "include" : [
      {
        "system" : "urn:ietf:rfc:3986",
        "concept" : [
          {
            "code" : "http://hl7.it/sid/eni",
            "display" : "Codici ENI"
          },
          {
            "code" : "http://hl7.it/sid/lazio/eni",
            "display" : "Codici ENI - Lazio"
          },
          {
            "code" : "http://hl7.it/sid/piemonte/eni",
            "display" : "Codici ENI - Piemonte"
          },
          {
            "code" : "http://hl7.it/sid/vallee/eni",
            "display" : "Codici ENI - Valle d'Aosta"
          },
          {
            "code" : "urn:oid:2.16.840.1.113883.2.9.2.50.4.1.4",
            "display" : "Codici ENI - Veneto"
          }
        ]
      }
    ]
  }
}

```
