# Risultato osservazione codificato - Gruppo Sanguigno IPS di SNOMED CT - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risultato osservazione codificato - Gruppo Sanguigno IPS di SNOMED CT**

## ValueSet: Risultato osservazione codificato - Gruppo Sanguigno IPS di SNOMED CT 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ValueSet/results-observation-bloodgroup | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:VsGruppoSanguigno |
| **Copyright/Legal**: This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement | |

 
Valueset che include i codici per i risultati dei gruppi sanguigni dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on SNOMED CT International edition 01-Feb 2025

This value set contains 13 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "results-observation-bloodgroup",
  "url" : "http://hl7.it/fhir/lab-report/ValueSet/results-observation-bloodgroup",
  "version" : "0.2.0",
  "name" : "VsGruppoSanguigno",
  "title" : "Risultato osservazione codificato - Gruppo Sanguigno IPS di SNOMED CT",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Valueset che include i codici per i risultati dei gruppi sanguigni dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "278154007",
            "display" : "Blood group AB Rh(D) negative"
          },
          {
            "code" : "278153001",
            "display" : "Blood group B Rh(D) negative"
          },
          {
            "code" : "278152006",
            "display" : "Blood group A Rh(D) negative"
          },
          {
            "code" : "278151004",
            "display" : "Blood group AB Rh(D) positive"
          },
          {
            "code" : "278150003",
            "display" : "Blood group B Rh(D) positive"
          },
          {
            "code" : "278149003",
            "display" : "Blood group A Rh(D) positive"
          },
          {
            "code" : "278148006",
            "display" : "Blood group O Rh(D) negative"
          },
          {
            "code" : "278147001",
            "display" : "Blood group O Rh(D) positive"
          },
          {
            "code" : "165746003",
            "display" : "RhD negative"
          },
          {
            "code" : "165743006",
            "display" : "Blood group AB"
          },
          {
            "code" : "112149005",
            "display" : "Blood group B"
          },
          {
            "code" : "112144000",
            "display" : "Blood group A"
          },
          {
            "code" : "58460004",
            "display" : "Blood group O"
          }
        ]
      }
    ]
  }
}

```
