# Codice Richiesta esame di Laboratorio [LOINC] - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Codice Richiesta esame di Laboratorio [LOINC]**

## ValueSet: Codice Richiesta esame di Laboratorio [LOINC] 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ValueSet/lab-orderCodes-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LabOrderCodes |
| **Copyright/Legal**: This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc | | |

 
Codice della richiesta per un esame di Laboratorio. 

 **References** 

* [ServiceRequest - Lab Report](StructureDefinition-servicerequest-it-lab.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include codes from[`http://loinc.org`](http://loinc.org)version Not Stated (use latest from terminology server) where ORDER_OBS = Order, where the codes are contained in [Results Laboratory Observation - IPS](http://hl7.org/fhir/uv/ips/STU1.1/ValueSet-results-laboratory-observations-uv-ips.html)
* Include codes from[`http://loinc.org`](http://loinc.org)version Not Stated (use latest from terminology server) where ORDER_OBS = Both, where the codes are contained in [Results Laboratory Observation - IPS](http://hl7.org/fhir/uv/ips/STU1.1/ValueSet-results-laboratory-observations-uv-ips.html)

 

### Expansion

Expansion from tx.fhir.org based on Loinc v2.81

This value set cannot be expanded because the terminology server(s) deemed it too costly to do so

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "lab-orderCodes-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/ValueSet/lab-orderCodes-it-lab",
  "version" : "0.2.0",
  "name" : "LabOrderCodes",
  "title" : "Codice Richiesta esame di Laboratorio [LOINC]",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Codice della richiesta per un esame di Laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "copyright" : "This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "filter" : [
          {
            "property" : "ORDER_OBS",
            "op" : "=",
            "value" : "Order"
          }
        ],
        "valueSet" : [
          "http://hl7.org/fhir/uv/ips/ValueSet/results-laboratory-observations-uv-ips"
        ]
      },
      {
        "system" : "http://loinc.org",
        "filter" : [
          {
            "property" : "ORDER_OBS",
            "op" : "=",
            "value" : "Both"
          }
        ],
        "valueSet" : [
          "http://hl7.org/fhir/uv/ips/ValueSet/results-laboratory-observations-uv-ips"
        ]
      }
    ]
  }
}

```
