# ISTAT - DUG - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISTAT - DUG**

## ValueSet: ISTAT - DUG 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ValueSet/istat-dug | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:VsIstatDug |

 
ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG) 

 **References** 

* [DUG (Denominazione Urbanistica Generica)](StructureDefinition-address-dug.md)

### Logical Definition (CLD)

* Include all codes defined in [`http://hl7.it/fhir/lab-report/CodeSystem/dug`](CodeSystem-dug.md)version 📦0.2.0

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "istat-dug",
  "url" : "http://hl7.it/fhir/lab-report/ValueSet/istat-dug",
  "version" : "0.2.0",
  "name" : "VsIstatDug",
  "title" : "ISTAT - DUG",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.it/fhir/lab-report/CodeSystem/dug"
      }
    ]
  }
}

```
