# ISTAT - Comuni - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISTAT - Comuni**

## ValueSet: ISTAT - Comuni 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ValueSet/istat-comune | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:VsIstatComune |

 
ISTAT - Comuni più sconosciuto 

 **References** 

* Included into [VsIstatLuogoNascita](ValueSet-istat-luogoNascita.md)

### Logical Definition (CLD)

 

### Expansion

This value set has 7,902 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "istat-comune",
  "url" : "http://hl7.it/fhir/lab-report/ValueSet/istat-comune",
  "version" : "0.2.0",
  "name" : "VsIstatComune",
  "title" : "ISTAT - Comuni",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "ISTAT - Comuni più sconosciuto",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-unitaAmministrativeTerritoriali"
      },
      {
        "system" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-unitaAmministrativeTerritoriali"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "concept" : [
          {
            "code" : "UNK",
            "display" : "Sconosciuto"
          }
        ]
      }
    ]
  }
}

```
