# ISTAT - Cittadinanza - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISTAT - Cittadinanza**

## ValueSet: ISTAT - Cittadinanza 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ValueSet/istat-cittadinanza | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:VsIstatCittadinanza |

 
ISTAT - Cittadinanza 

 **References** 

* [Patient - Lab Report](StructureDefinition-patient-it-lab.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "istat-cittadinanza",
  "url" : "http://hl7.it/fhir/lab-report/ValueSet/istat-cittadinanza",
  "version" : "0.2.0",
  "name" : "VsIstatCittadinanza",
  "title" : "ISTAT - Cittadinanza",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "ISTAT - Cittadinanza",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-unitaAmministrativeTerritorialiEstere",
        "concept" : [
          {
            "code" : "100",
            "display" : "Italia"
          },
          {
            "code" : "201",
            "display" : "Albania"
          },
          {
            "code" : "202",
            "display" : "Andorra"
          },
          {
            "code" : "203",
            "display" : "Austria"
          },
          {
            "code" : "206",
            "display" : "Belgio"
          },
          {
            "code" : "209",
            "display" : "Bulgaria"
          },
          {
            "code" : "212",
            "display" : "Danimarca"
          },
          {
            "code" : "214",
            "display" : "Finlandia"
          },
          {
            "code" : "215",
            "display" : "Francia"
          },
          {
            "code" : "216",
            "display" : "Germania"
          },
          {
            "code" : "219",
            "display" : "Regno Unito"
          },
          {
            "code" : "220",
            "display" : "Grecia"
          },
          {
            "code" : "221",
            "display" : "Irlanda"
          },
          {
            "code" : "223",
            "display" : "Islanda"
          },
          {
            "code" : "225",
            "display" : "Liechtenstein"
          },
          {
            "code" : "226",
            "display" : "Lussemburgo"
          },
          {
            "code" : "227",
            "display" : "Malta"
          },
          {
            "code" : "229",
            "display" : "Monaco"
          },
          {
            "code" : "231",
            "display" : "Norvegia"
          },
          {
            "code" : "232",
            "display" : "Paesi Bassi"
          },
          {
            "code" : "233",
            "display" : "Polonia"
          },
          {
            "code" : "234",
            "display" : "Portogallo"
          },
          {
            "code" : "235",
            "display" : "Romania"
          },
          {
            "code" : "236",
            "display" : "San Marino"
          },
          {
            "code" : "239",
            "display" : "Spagna"
          },
          {
            "code" : "240",
            "display" : "Svezia"
          },
          {
            "code" : "241",
            "display" : "Svizzera"
          },
          {
            "code" : "243",
            "display" : "Ucraina"
          },
          {
            "code" : "244",
            "display" : "Ungheria"
          },
          {
            "code" : "245",
            "display" : "Federazione russa"
          },
          {
            "code" : "246",
            "display" : "Stato della Città del Vaticano"
          },
          {
            "code" : "247",
            "display" : "Estonia"
          },
          {
            "code" : "248",
            "display" : "Lettonia"
          },
          {
            "code" : "249",
            "display" : "Lituania"
          },
          {
            "code" : "250",
            "display" : "Croazia"
          },
          {
            "code" : "251",
            "display" : "Slovenia"
          },
          {
            "code" : "252",
            "display" : "Bosnia-Erzegovina"
          },
          {
            "code" : "253",
            "display" : "Macedonia del Nord"
          },
          {
            "code" : "254",
            "display" : "Moldova"
          },
          {
            "code" : "255",
            "display" : "Slovacchia"
          },
          {
            "code" : "256",
            "display" : "Bielorussia"
          },
          {
            "code" : "257",
            "display" : "Repubblica ceca"
          },
          {
            "code" : "270",
            "display" : "Montenegro"
          },
          {
            "code" : "271",
            "display" : "Serbia"
          },
          {
            "code" : "272",
            "display" : "Kosovo"
          },
          {
            "code" : "301",
            "display" : "Afghanistan"
          },
          {
            "code" : "302",
            "display" : "Arabia Saudita"
          },
          {
            "code" : "304",
            "display" : "Bahrein"
          },
          {
            "code" : "305",
            "display" : "Bangladesh"
          },
          {
            "code" : "306",
            "display" : "Bhutan"
          },
          {
            "code" : "307",
            "display" : "Myanmar/Birmania"
          },
          {
            "code" : "309",
            "display" : "Brunei Darussalam"
          },
          {
            "code" : "310",
            "display" : "Cambogia"
          },
          {
            "code" : "311",
            "display" : "Sri Lanka"
          },
          {
            "code" : "314",
            "display" : "Cina"
          },
          {
            "code" : "315",
            "display" : "Cipro"
          },
          {
            "code" : "319",
            "display" : "Corea del Nord"
          },
          {
            "code" : "320",
            "display" : "Corea del Sud"
          },
          {
            "code" : "322",
            "display" : "Emirati Arabi Uniti"
          },
          {
            "code" : "323",
            "display" : "Filippine"
          },
          {
            "code" : "324",
            "display" : "Palestina"
          },
          {
            "code" : "326",
            "display" : "Giappone"
          },
          {
            "code" : "327",
            "display" : "Giordania"
          },
          {
            "code" : "330",
            "display" : "India"
          },
          {
            "code" : "331",
            "display" : "Indonesia"
          },
          {
            "code" : "332",
            "display" : "Iran"
          },
          {
            "code" : "333",
            "display" : "Iraq"
          },
          {
            "code" : "334",
            "display" : "Israele"
          },
          {
            "code" : "335",
            "display" : "Kuwait"
          },
          {
            "code" : "336",
            "display" : "Laos"
          },
          {
            "code" : "337",
            "display" : "Libano"
          },
          {
            "code" : "338",
            "display" : "Timor Leste"
          },
          {
            "code" : "339",
            "display" : "Maldive"
          },
          {
            "code" : "340",
            "display" : "Malaysia"
          },
          {
            "code" : "341",
            "display" : "Mongolia"
          },
          {
            "code" : "342",
            "display" : "Nepal"
          },
          {
            "code" : "343",
            "display" : "Oman"
          },
          {
            "code" : "344",
            "display" : "Pakistan"
          },
          {
            "code" : "345",
            "display" : "Qatar"
          },
          {
            "code" : "346",
            "display" : "Singapore"
          },
          {
            "code" : "348",
            "display" : "Siria"
          },
          {
            "code" : "349",
            "display" : "Thailandia"
          },
          {
            "code" : "351",
            "display" : "Turchia"
          },
          {
            "code" : "353",
            "display" : "Vietnam"
          },
          {
            "code" : "354",
            "display" : "Yemen"
          },
          {
            "code" : "356",
            "display" : "Kazakhstan"
          },
          {
            "code" : "357",
            "display" : "Uzbekistan"
          },
          {
            "code" : "358",
            "display" : "Armenia"
          },
          {
            "code" : "359",
            "display" : "Azerbaigian"
          },
          {
            "code" : "360",
            "display" : "Georgia"
          },
          {
            "code" : "361",
            "display" : "Kirghizistan"
          },
          {
            "code" : "362",
            "display" : "Tagikistan"
          },
          {
            "code" : "363",
            "display" : "Taiwan"
          },
          {
            "code" : "364",
            "display" : "Turkmenistan"
          },
          {
            "code" : "401",
            "display" : "Algeria"
          },
          {
            "code" : "402",
            "display" : "Angola"
          },
          {
            "code" : "404",
            "display" : "Costa d'Avorio"
          },
          {
            "code" : "406",
            "display" : "Benin"
          },
          {
            "code" : "408",
            "display" : "Botswana"
          },
          {
            "code" : "409",
            "display" : "Burkina Faso"
          },
          {
            "code" : "410",
            "display" : "Burundi"
          },
          {
            "code" : "411",
            "display" : "Camerun"
          },
          {
            "code" : "413",
            "display" : "Capo Verde"
          },
          {
            "code" : "414",
            "display" : "Repubblica Centrafricana"
          },
          {
            "code" : "415",
            "display" : "Ciad"
          },
          {
            "code" : "417",
            "display" : "Comore"
          },
          {
            "code" : "418",
            "display" : "Congo"
          },
          {
            "code" : "419",
            "display" : "Egitto"
          },
          {
            "code" : "420",
            "display" : "Etiopia"
          },
          {
            "code" : "421",
            "display" : "Gabon"
          },
          {
            "code" : "422",
            "display" : "Gambia"
          },
          {
            "code" : "423",
            "display" : "Ghana"
          },
          {
            "code" : "424",
            "display" : "Gibuti"
          },
          {
            "code" : "425",
            "display" : "Guinea"
          },
          {
            "code" : "426",
            "display" : "Guinea-Bissau"
          },
          {
            "code" : "427",
            "display" : "Guinea equatoriale"
          },
          {
            "code" : "428",
            "display" : "Kenya"
          },
          {
            "code" : "429",
            "display" : "Lesotho"
          },
          {
            "code" : "430",
            "display" : "Liberia"
          },
          {
            "code" : "431",
            "display" : "Libia"
          },
          {
            "code" : "432",
            "display" : "Madagascar"
          },
          {
            "code" : "434",
            "display" : "Malawi"
          },
          {
            "code" : "435",
            "display" : "Mali"
          },
          {
            "code" : "436",
            "display" : "Marocco"
          },
          {
            "code" : "437",
            "display" : "Mauritania"
          },
          {
            "code" : "438",
            "display" : "Maurizio"
          },
          {
            "code" : "440",
            "display" : "Mozambico"
          },
          {
            "code" : "441",
            "display" : "Namibia"
          },
          {
            "code" : "442",
            "display" : "Niger"
          },
          {
            "code" : "443",
            "display" : "Nigeria"
          },
          {
            "code" : "446",
            "display" : "Ruanda"
          },
          {
            "code" : "448",
            "display" : "Sao Tomé e Principe"
          },
          {
            "code" : "449",
            "display" : "Seychelles"
          },
          {
            "code" : "450",
            "display" : "Senegal"
          },
          {
            "code" : "451",
            "display" : "Sierra Leone"
          },
          {
            "code" : "453",
            "display" : "Somalia"
          },
          {
            "code" : "454",
            "display" : "Sudafrica"
          },
          {
            "code" : "455",
            "display" : "Sudan"
          },
          {
            "code" : "456",
            "display" : "Eswatini"
          },
          {
            "code" : "457",
            "display" : "Tanzania"
          },
          {
            "code" : "458",
            "display" : "Togo"
          },
          {
            "code" : "460",
            "display" : "Tunisia"
          },
          {
            "code" : "461",
            "display" : "Uganda"
          },
          {
            "code" : "463",
            "display" : "Repubblica Democratica del Congo"
          },
          {
            "code" : "464",
            "display" : "Zambia"
          },
          {
            "code" : "465",
            "display" : "Zimbabwe"
          },
          {
            "code" : "466",
            "display" : "Eritrea"
          },
          {
            "code" : "467",
            "display" : "Sud Sudan"
          },
          {
            "code" : "503",
            "display" : "Antigua e Barbuda"
          },
          {
            "code" : "505",
            "display" : "Bahamas"
          },
          {
            "code" : "506",
            "display" : "Barbados"
          },
          {
            "code" : "507",
            "display" : "Belize"
          },
          {
            "code" : "509",
            "display" : "Canada"
          },
          {
            "code" : "513",
            "display" : "Costa Rica"
          },
          {
            "code" : "514",
            "display" : "Cuba"
          },
          {
            "code" : "515",
            "display" : "Dominica"
          },
          {
            "code" : "516",
            "display" : "Repubblica Dominicana"
          },
          {
            "code" : "517",
            "display" : "El Salvador"
          },
          {
            "code" : "518",
            "display" : "Giamaica"
          },
          {
            "code" : "519",
            "display" : "Grenada"
          },
          {
            "code" : "523",
            "display" : "Guatemala"
          },
          {
            "code" : "524",
            "display" : "Haiti"
          },
          {
            "code" : "525",
            "display" : "Honduras"
          },
          {
            "code" : "527",
            "display" : "Messico"
          },
          {
            "code" : "529",
            "display" : "Nicaragua"
          },
          {
            "code" : "530",
            "display" : "Panama"
          },
          {
            "code" : "532",
            "display" : "Santa Lucia"
          },
          {
            "code" : "533",
            "display" : "Saint Vincent e Grenadine"
          },
          {
            "code" : "534",
            "display" : "Saint Kitts e Nevis"
          },
          {
            "code" : "536",
            "display" : "Stati Uniti d'America"
          },
          {
            "code" : "602",
            "display" : "Argentina"
          },
          {
            "code" : "604",
            "display" : "Bolivia"
          },
          {
            "code" : "605",
            "display" : "Brasile"
          },
          {
            "code" : "606",
            "display" : "Cile"
          },
          {
            "code" : "608",
            "display" : "Colombia"
          },
          {
            "code" : "609",
            "display" : "Ecuador"
          },
          {
            "code" : "612",
            "display" : "Guyana"
          },
          {
            "code" : "614",
            "display" : "Paraguay"
          },
          {
            "code" : "615",
            "display" : "Perù"
          },
          {
            "code" : "616",
            "display" : "Suriname"
          },
          {
            "code" : "617",
            "display" : "Trinidad e Tobago"
          },
          {
            "code" : "618",
            "display" : "Uruguay"
          },
          {
            "code" : "619",
            "display" : "Venezuela"
          },
          {
            "code" : "701",
            "display" : "Australia"
          },
          {
            "code" : "703",
            "display" : "Figi"
          },
          {
            "code" : "708",
            "display" : "Kiribati"
          },
          {
            "code" : "712",
            "display" : "Isole Marshall"
          },
          {
            "code" : "713",
            "display" : "Stati Federati di Micronesia"
          },
          {
            "code" : "715",
            "display" : "Nauru"
          },
          {
            "code" : "719",
            "display" : "Nuova Zelanda"
          },
          {
            "code" : "720",
            "display" : "Palau"
          },
          {
            "code" : "721",
            "display" : "Papua Nuova Guinea"
          },
          {
            "code" : "725",
            "display" : "Isole Salomone"
          },
          {
            "code" : "727",
            "display" : "Samoa"
          },
          {
            "code" : "730",
            "display" : "Tonga"
          },
          {
            "code" : "731",
            "display" : "Tuvalu"
          },
          {
            "code" : "732",
            "display" : "Vanuatu"
          },
          {
            "code" : "905",
            "display" : "Sahara occidentale"
          },
          {
            "code" : "926",
            "display" : "Aruba"
          },
          {
            "code" : "928",
            "display" : "Sint Maarten (NL)"
          },
          {
            "code" : "966",
            "display" : "Curaçao"
          },
          {
            "code" : "888",
            "display" : "Non cittadini riconosciuti"
          },
          {
            "code" : "998",
            "display" : "Altro/Non indicato/In corso di definizione"
          },
          {
            "code" : "999",
            "display" : "Apolide"
          }
        ]
      }
    ]
  }
}

```
