# Tipo identificatore - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Tipo identificatore**

## ValueSet: Tipo identificatore 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ValueSet/VstipoIdentificatore | *Version*:0.2.0 |
| Active as of 2019-11-01 | *Computable Name*:VstipoIdentificatore |

 
Value set che descrivie i diversi tipi di identificatori. Include i codici della tabella http://terminology.hl7.org/CodeSystem/v2-0203 piu' 'STP' ed 'ENI' 

 **References** 

* [Patient - Lab Report](StructureDefinition-patient-it-lab.md)

### Logical Definition (CLD)

 

### Expansion

This value set contains 22 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "VstipoIdentificatore",
  "url" : "http://hl7.it/fhir/lab-report/ValueSet/VstipoIdentificatore",
  "version" : "0.2.0",
  "name" : "VstipoIdentificatore",
  "title" : "Tipo identificatore",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-11-01T09:29:23+11:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Value set che descrivie i diversi tipi di identificatori. Include i codici della tabella http://terminology.hl7.org/CodeSystem/v2-0203 piu' 'STP' ed 'ENI' ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "concept" : [
          {
            "code" : "DL",
            "display" : "Patente di Guida"
          },
          {
            "code" : "PPN",
            "display" : "Numero Passaporto"
          },
          {
            "code" : "BRN",
            "display" : "Breed Registry Number"
          },
          {
            "code" : "MR",
            "display" : "Medical record number"
          },
          {
            "code" : "MCN",
            "display" : "Microchip Number"
          },
          {
            "code" : "EN",
            "display" : "Employer number"
          },
          {
            "code" : "TAX",
            "display" : "Tax ID number"
          },
          {
            "code" : "NIIP",
            "display" : "National Insurance Payor Identifier (Payor)"
          },
          {
            "code" : "PRN",
            "display" : "Provider number"
          },
          {
            "code" : "MD",
            "display" : "Medical License number"
          },
          {
            "code" : "DR",
            "display" : "Donor Registration Number"
          },
          {
            "code" : "ACSN",
            "display" : "Accession ID"
          },
          {
            "code" : "UDI",
            "display" : "Universal Device Identifier"
          },
          {
            "code" : "SNO",
            "display" : "Serial Number"
          },
          {
            "code" : "SB",
            "display" : "Social Beneficiary Identifier"
          },
          {
            "code" : "PLAC",
            "display" : "Placer Identifier"
          },
          {
            "code" : "FILL",
            "display" : "Filler Identifier"
          }
        ]
      },
      {
        "system" : "http://hl7.it/fhir/lab-report/CodeSystem/it-identifier-type"
      }
    ]
  }
}

```
