# ServiceRequest - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest - Lab Report**

## Resource Profile: ServiceRequest - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/servicerequest-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ServiceRequestRefertoLabIt |

 
Descrizione delle informazioni della prescrizione tramite il profilo della risorsa ServiceRequest per il referto di laboratorio. 

**Usages:**

* Use this Profile: [Bundle - Lab Report](StructureDefinition-bundle-it-lab.md)
* Refer to this Profile: [DiagnosticReport - Lab Report](StructureDefinition-diagnosticreport-it-lab.md) and [Encounter - Lab Report](StructureDefinition-encounter-it-lab.md)
* Examples for this Profile: [ServiceRequest/463ae6fe-60d4-4b38-84b3-1008e0925678](ServiceRequest-463ae6fe-60d4-4b38-84b3-1008e0925678.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/servicerequest-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-servicerequest-it-lab.csv), [Excel](StructureDefinition-servicerequest-it-lab.xlsx), [Schematron](StructureDefinition-servicerequest-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "servicerequest-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/servicerequest-it-lab",
  "version" : "0.2.0",
  "name" : "ServiceRequestRefertoLabIt",
  "title" : "ServiceRequest - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione delle informazioni della prescrizione tramite il profilo della risorsa ServiceRequest per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ServiceRequest",
  "baseDefinition" : "http://hl7.eu/fhir/laboratory/StructureDefinition/ServiceRequest-eu-lab",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ServiceRequest",
        "path" : "ServiceRequest",
        "short" : "ServiceRequest Referto di Laboratorio"
      },
      {
        "id" : "ServiceRequest.identifier",
        "path" : "ServiceRequest.identifier",
        "short" : "Identificativo assegnato all'ordine."
      },
      {
        "id" : "ServiceRequest.requisition",
        "path" : "ServiceRequest.requisition",
        "short" : "Idenificativo comune a più ServiceRequest autorizzate simultaneamente. Rappresenta l'identificativo univoco della richiesta."
      },
      {
        "id" : "ServiceRequest.intent",
        "path" : "ServiceRequest.intent",
        "short" : "Descrizione attributo: Indica lo scopo associato ad una richiesta. Possibili valori: proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/request-intent"
        }
      },
      {
        "id" : "ServiceRequest.priority",
        "path" : "ServiceRequest.priority",
        "short" : "Descrizione attributo: Priorità della richiesta. Possibili valori: routine | urgent | asap | stat",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/request-priority"
        }
      },
      {
        "id" : "ServiceRequest.code",
        "path" : "ServiceRequest.code",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/lab-orderCodes-it-lab"
        }
      },
      {
        "id" : "ServiceRequest.quantity[x]",
        "path" : "ServiceRequest.quantity[x]",
        "short" : "Molteplicità della prestazione."
      },
      {
        "id" : "ServiceRequest.subject",
        "path" : "ServiceRequest.subject",
        "short" : "Soggetto cui si riferisce la richiesta.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.authoredOn",
        "path" : "ServiceRequest.authoredOn",
        "short" : "Data di invio della richiesta."
      },
      {
        "id" : "ServiceRequest.reasonCode",
        "path" : "ServiceRequest.reasonCode",
        "short" : "Quesito diagnostico associato alla richiesta."
      },
      {
        "id" : "ServiceRequest.specimen",
        "path" : "ServiceRequest.specimen",
        "short" : "Reference usata solo se il campione cui punta la richiesta è già stato prelevato ed esiste.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/specimen-it-lab"
            ]
          }
        ]
      }
    ]
  }
}

```
