# Professione del paziente - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Professione del paziente**

## Extension: Professione del paziente 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/patient-occupation-it | *Version*:0.2.0 |
| Active as of 2020-06-30 | *Computable Name*:ExtProfessionePaziente |

Estensione per gestire la professione del paziente come CodeableConcept.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Patient - Lab Report](StructureDefinition-patient-it-lab.md)
* Examples for this Extension: [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md), [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md) and [Patient/8472931c-fbd0-437b-9ed1-4f66472c78b5](Patient-8472931c-fbd0-437b-9ed1-4f66472c78b5.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/patient-occupation-it)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient-occupation-it.csv), [Excel](StructureDefinition-patient-occupation-it.xlsx), [Schematron](StructureDefinition-patient-occupation-it.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient-occupation-it",
  "url" : "http://hl7.it/fhir/StructureDefinition/patient-occupation-it",
  "version" : "0.2.0",
  "name" : "ExtProfessionePaziente",
  "title" : "Professione del paziente",
  "status" : "active",
  "date" : "2020-06-30T18:23:29+02:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Estensione per gestire la professione del paziente come CodeableConcept.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Professione del paziente",
        "definition" : "Estensione per gestire la professione del paziente come CodeableConcept."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.it/fhir/StructureDefinition/patient-occupation-it"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/istat-professione"
        }
      }
    ]
  }
}

```
