# Codice comune e/o stato di nascita - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Codice comune e/o stato di nascita**

## Extension: Codice comune e/o stato di nascita 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:ExtCodeableBirthPlace |

Codice comune e/o stato di nascita.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Patient - Lab Report](StructureDefinition-patient-it-lab.md)
* Examples for this Extension: [Bundle/Bundle-Lab-Esempio-2](Bundle-Bundle-Lab-Esempio-2.md), [Bundle/Bundle-Lab-Esempio](Bundle-Bundle-Lab-Esempio.md) and [Patient/8472931c-fbd0-437b-9ed1-4f66472c78b5](Patient-8472931c-fbd0-437b-9ed1-4f66472c78b5.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/patient-codeableBirthPlace)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient-codeableBirthPlace.csv), [Excel](StructureDefinition-patient-codeableBirthPlace.xlsx), [Schematron](StructureDefinition-patient-codeableBirthPlace.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient-codeableBirthPlace",
  "url" : "http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace",
  "version" : "0.2.0",
  "name" : "ExtCodeableBirthPlace",
  "title" : "Codice comune e/o stato di nascita",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Codice comune e/o stato di nascita.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Codice comune e/o stato di nascita",
        "definition" : "Codice comune e/o stato di nascita."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
