# Organization - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization - Lab Report**

## Resource Profile: Organization - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:OrganizationRefertoLabIt |

 
Descrizione delle informazioni relative all'organizzazione tramite il profilo della risorsa Organization per il referto di laboratorio. 

**Usages:**

* Derived from this Profile: [Organization operatore sanitario/socio sanitario - Lab Report](StructureDefinition-organizationOperatore-it-lab.md)
* Use this Profile: [Bundle - Lab Report](StructureDefinition-bundle-it-lab.md)
* Refer to this Profile: [Composition - Lab Report](StructureDefinition-composition-it-lab.md), [DiagnosticReport - Lab Report](StructureDefinition-diagnosticreport-it-lab.md), [Location - Lab Report](StructureDefinition-location-it-lab.md), [Media - Lab Report](StructureDefinition-media-it-lab.md)...Show 3 more,[Observation - Lab Report](StructureDefinition-observation-it-lab.md),[Patient - Lab Report](StructureDefinition-patient-it-lab.md)and[PractitionerRole - Lab Report](StructureDefinition-practitionerrole-it-lab.md)
* Examples for this Profile: [Azienda Sanitara Locale Roma 1](Organization-5fd3f1a6-b2c8-44cb-8237-0b5f0a81f2a8.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/organization-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-organization-it-lab.csv), [Excel](StructureDefinition-organization-it-lab.xlsx), [Schematron](StructureDefinition-organization-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "organization-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Organization-uv-ips"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab",
  "version" : "0.2.0",
  "name" : "OrganizationRefertoLabIt",
  "title" : "Organization - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione delle informazioni relative all'organizzazione tramite il profilo della risorsa Organization per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization",
        "short" : "Organization Referto di Laboratorio"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "short" : "Identificativo dell'organizzazione."
      },
      {
        "id" : "Organization.active",
        "path" : "Organization.active",
        "short" : "Indica se la risorsa è attiva."
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "short" : "Tipo di organizzazione.",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/tipoOrganizzazione"
        }
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "short" : "Nome human-readable dell'organizzazione."
      }
    ]
  }
}

```
