# Observation - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation - Lab Report**

## Resource Profile: Observation - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ObservationRefertoLabIt |

 
Descrizione delle rilevazioni cliniche tramite il profilo della risorsa Observation per il referto di laboratorio. 

**Usages:**

* Derived from this Profile: [Observation Document - Lab Report](StructureDefinition-observation-doc-it-lab.md) and [Observation battery - Lab Report](StructureDefinition-observation-grouping-it-lab.md)
* Refer to this Profile: [Composition - Lab Report](StructureDefinition-composition-it-lab.md), [DiagnosticReport - Lab Report](StructureDefinition-diagnosticreport-it-lab.md) and [Observation - Lab Report](StructureDefinition-observation-it-lab.md)
* Examples for this Profile: [Observation/5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c](Observation-5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c.md), [Observation/9474efca-8c8a-436d-a1a4-5706a1dd057a](Observation-9474efca-8c8a-436d-a1a4-5706a1dd057a.md), [Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6244.md), [Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6245.md)...Show 2 more,[Observation/a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246](Observation-a7d1b3b0-9aee-4bc7-b0f2-46d441ba6246.md)and[Observation/a8a27a81-4543-45a9-8859-fa17053d963e](Observation-a8a27a81-4543-45a9-8859-fa17053d963e.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/observation-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-observation-it-lab.csv), [Excel](StructureDefinition-observation-it-lab.xlsx), [Schematron](StructureDefinition-observation-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "observation-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab",
  "version" : "0.2.0",
  "name" : "ObservationRefertoLabIt",
  "title" : "Observation - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione delle rilevazioni cliniche tramite il profilo della risorsa Observation per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.eu/fhir/laboratory/StructureDefinition/Observation-resultslab-eu-lab",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Observation Referto di Laboratorio"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "short" : "Descrizione attributo: Stato dell'osservazione. Possibili valori: registered | preliminary | final | amended +",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-status"
        }
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "short" : "Codice che classifica il tipo di osservazione.",
        "definition" : "La categoria di osservazione può definire la classificazione tramite diversi livelli di dettaglio, a partire da laboratory."
      },
      {
        "id" : "Observation.category:laboratory",
        "path" : "Observation.category",
        "sliceName" : "laboratory",
        "short" : "Indica genericamente che si riferisce ad un esame di Laboratorio"
      },
      {
        "id" : "Observation.category:studyType",
        "path" : "Observation.category",
        "sliceName" : "studyType",
        "short" : "Classificazione per tipo di studio"
      },
      {
        "id" : "Observation.category:specialty",
        "path" : "Observation.category",
        "sliceName" : "specialty",
        "short" : "Classificazione per specialità"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "Tipo di osservazione tramite codice.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/risultato-osservazione"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "Soggetto della rilevazione clinica.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Observation.encounter",
        "path" : "Observation.encounter",
        "short" : "Contesto in cui è stata prodotta l'osservazione.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/encounter-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "short" : "Soggetto responsabile dell'osservazione.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitioner-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/practitionerrole-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/organization-it-lab",
              "http://hl7.org/fhir/StructureDefinition/CareTeam",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "Risultato dell'osservazione."
      },
      {
        "id" : "Observation.value[x]:valueQuantity",
        "path" : "Observation.value[x]",
        "sliceName" : "valueQuantity",
        "short" : "Risultato misurabile tramite una quantità.",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/quantity-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept",
        "path" : "Observation.value[x]",
        "sliceName" : "valueCodeableConcept",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.it/fhir/lab-report/ValueSet/valueset-valuecodeableconcept-obs-it"
        }
      },
      {
        "id" : "Observation.interpretation",
        "path" : "Observation.interpretation",
        "short" : "Interpretazione del risultato (Alto, Basso, Normale, ecc.)"
      },
      {
        "id" : "Observation.bodySite",
        "path" : "Observation.bodySite",
        "short" : "Sito corporeo dell'osservazione."
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "short" : "Metodo di rilevazione dell'osservazione.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-methods"
        }
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "short" : "Reference al campione su cui si basa l'osservazione.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/specimen-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Observation.device",
        "path" : "Observation.device",
        "short" : "Dispositivo utilizzato per ottenere l'osservazione.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/device-it-lab",
              "http://hl7.org/fhir/StructureDefinition/DeviceMetric"
            ]
          }
        ]
      },
      {
        "id" : "Observation.referenceRange",
        "path" : "Observation.referenceRange",
        "short" : "Range di riferimento per la caratterizzazione dell'osservazione sulla base di un criterio.\nEsempio: Range di normalità per uomo adulto."
      },
      {
        "id" : "Observation.referenceRange.low",
        "path" : "Observation.referenceRange.low",
        "short" : "Limite inferiore del range di riferimento, se rilevante."
      },
      {
        "id" : "Observation.referenceRange.high",
        "path" : "Observation.referenceRange.high",
        "short" : "Limite superiore del range di riferimento, se rilevante."
      },
      {
        "id" : "Observation.referenceRange.type",
        "path" : "Observation.referenceRange.type",
        "short" : "Contesto del range di riferimento. Esempio: Un intervallo atteso in un individuo prima della pubertà."
      },
      {
        "id" : "Observation.referenceRange.appliesTo",
        "path" : "Observation.referenceRange.appliesTo",
        "short" : "Categoria della popolazione a cui si applica il range di riferimento."
      },
      {
        "id" : "Observation.referenceRange.age",
        "path" : "Observation.referenceRange.age",
        "short" : "Età a cui si applica, se rilevante."
      },
      {
        "id" : "Observation.referenceRange.text",
        "path" : "Observation.referenceRange.text",
        "short" : "Note testuali."
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "short" : "Osservazioni correlate alla risorsa.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "short" : "Reference dell'osservazione da cui deriva questo valore di osservazione. Ad esempio, un gap anionico calcolato o una misurazione fetale basata su un'immagine ecografica.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab",
              "http://hl7.it/fhir/lab-report/StructureDefinition/media-it-lab"
            ]
          }
        ]
      }
    ]
  }
}

```
