# Device - Lab Report - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Device - Lab Report**

## Resource Profile: Device - Lab Report 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/device-it-lab | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:DeviceRefertoLabIt |

 
Descrizione di un dispositivo tramite il profilo della risorsa Device per il referto di laboratorio. 

**Usages:**

* Refer to this Profile: [Media - Lab Report](StructureDefinition-media-it-lab.md) and [Observation - Lab Report](StructureDefinition-observation-it-lab.md)
* Examples for this Profile: [Device/168d4960-0a0b-43af-8025-180f0965f324](Device-168d4960-0a0b-43af-8025-180f0965f324.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/device-it-lab)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-device-it-lab.csv), [Excel](StructureDefinition-device-it-lab.xlsx), [Schematron](StructureDefinition-device-it-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "device-it-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/device-it-lab",
  "version" : "0.2.0",
  "name" : "DeviceRefertoLabIt",
  "title" : "Device - Lab Report",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione di un dispositivo tramite il profilo della risorsa Device per il referto di laboratorio.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "udi",
      "uri" : "http://fda.gov/UDI",
      "name" : "UDI Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Device",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Device",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Device",
        "path" : "Device",
        "short" : "Dispositivo coinvolto nel dominio di Referto di Laboratorio",
        "definition" : "Il dispositivo coinvolto nel dominio di Referto di Laboratorio può essere il dispositivo di raccolta del contenuto multimediale (Media) o utilizzato nella rilevazione dell'Observation."
      },
      {
        "id" : "Device.identifier",
        "path" : "Device.identifier",
        "short" : "Identificativo del dispositivo, se presente."
      },
      {
        "id" : "Device.deviceName",
        "path" : "Device.deviceName",
        "short" : "Il nome del dispositivo fornito dal produttore."
      },
      {
        "id" : "Device.deviceName.name",
        "path" : "Device.deviceName.name",
        "short" : "Il nome che identifica il dispositivo."
      },
      {
        "id" : "Device.deviceName.type",
        "path" : "Device.deviceName.type",
        "short" : "Descrizione attributo: Tipologia di nome. Possibili valori:  udi-label-name | user-friendly-name | patient-reported-name | manufacturer-name | model-name | other",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/device-nametype"
        }
      },
      {
        "id" : "Device.type",
        "path" : "Device.type",
        "short" : "Il tipo di dispositivo",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/device-type"
        }
      }
    ]
  }
}

```
