# Address Birth Place - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Address Birth Place**

## Extension: Address Birth Place 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/birth-place-ita | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:BirthPlaceIta |

Definizione dell'indirizzo base per la descrizione del luogo di nascita.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Patient - Lab Report](StructureDefinition-patient-it-lab.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/birth-place-ita)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-birth-place-ita.csv), [Excel](StructureDefinition-birth-place-ita.xlsx), [Schematron](StructureDefinition-birth-place-ita.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "birth-place-ita",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/birth-place-ita",
  "version" : "0.2.0",
  "name" : "BirthPlaceIta",
  "title" : "Address Birth Place",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Definizione dell'indirizzo base per la descrizione del luogo di nascita.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/patient-birthPlace",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Address Birth Place",
        "definition" : "Definizione dell'indirizzo base per la descrizione del luogo di nascita."
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Address",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/address-it"
            ]
          }
        ]
      }
    ]
  }
}

```
