# Address - ITA - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Address - ITA**

## Data Type Profile: Address - ITA 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/address-it | *Version*:0.2.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:AddressItBase |

 
Descrizione di Address con parti addizionali specifiche per gli indirizzi italiani. Questo profilo struttura l'elemento Address.line in più parti, consente la codifica di alcune di queste parti e supporta la caratterizzazine degli indirizzi di tipo Residenza. Questa prima versione è ispirata al data type Address Olandese. 

**Usages:**

* Use this DataType Profile: [Address Birth Place](StructureDefinition-birth-place-ita.md) and [Patient - Lab Report](StructureDefinition-patient-it-lab.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/address-it)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-address-it.csv), [Excel](StructureDefinition-address-it.xlsx), [Schematron](StructureDefinition-address-it.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "address-it",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/address-it",
  "version" : "0.2.0",
  "name" : "AddressItBase",
  "title" : "Address - ITA",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Descrizione di Address con parti addizionali specifiche per gli indirizzi italiani. Questo profilo struttura l'elemento  Address.line in più parti, consente la codifica di alcune di queste parti e supporta la caratterizzazine degli indirizzi di tipo Residenza. Questa prima versione è ispirata al data type Address Olandese.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "vcard",
      "uri" : "http://w3.org/vcard",
      "name" : "vCard Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Address",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Address",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Address",
        "path" : "Address",
        "short" : "Indirizzo fisico o postale",
        "definition" : "Esiste una varietà di formati di indirizzi postali definiti in tutto il mondo. Questo profilo (address-it-base) estende il datatype base Address includendo una serie di informazioni rilevanti per esprimere gli indirizzi in Italia. \r \n \r \n Un address-it-base è un indirizzo FHIR valido; i sistemi che non supportano le estensioni utilizzate saranno in grado comunque di eseguire il rendering e lavorare con un XXXX. \r \n \r \n Un indirizzo rende alcune parti di indirizzo comunicabili separatamente. Queste parti sono necessarie in alcuni scenari d'uso italiani, ma potrebbero non avere valore per i sistemi internazionali quando le informazioni vengono inviate all'estero.",
        "comment" : "Nota: address è per indirizzi postali, non per la localizzazione fisica.",
        "alias" : ["Indirizzo"]
      },
      {
        "id" : "Address.extension:residenza",
        "path" : "Address.extension",
        "sliceName" : "residenza",
        "short" : "Indica l'indirizzo di residenza",
        "definition" : "Indica se questo indirizzo è quello di residenza, come indirizzo 'ufficialmente registrato' address.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.it/fhir/lab-report/StructureDefinition/address-official"
            ]
          }
        ]
      },
      {
        "id" : "Address.extension:certificazioneIndirizzo",
        "path" : "Address.extension",
        "sliceName" : "certificazioneIndirizzo",
        "short" : "Certificazione Indirizzo",
        "definition" : "Indica che i dati di questo indirizzo sono stati certificati da una specifica entità",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/recordCertification"]
          }
        ]
      },
      {
        "id" : "Address.line",
        "path" : "Address.line",
        "short" : "Nome completo strada (e.g. Via Corta 1, interno 2)"
      },
      {
        "id" : "Address.line.extension",
        "path" : "Address.line.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Address.line.extension:odonimo",
        "path" : "Address.line.extension",
        "sliceName" : "odonimo",
        "short" : "Odonimo, Toponimo Stradale",
        "requirements" : "Nome della Strada",
        "alias" : ["Toponimo Stradale", "user content"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName"
            ]
          }
        ],
        "example" : [
          {
            "label" : "ex-1",
            "valueString" : "Via Corta"
          }
        ]
      },
      {
        "id" : "Address.line.extension:dugCode",
        "path" : "Address.line.extension",
        "sliceName" : "dugCode",
        "short" : "Codice Denominazione Urbanistica Generica (DUG)",
        "alias" : ["specie", "user content"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.it/fhir/StructureDefinition/address-dug"]
          }
        ],
        "example" : [
          {
            "label" : "ex-1",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.it/fhir/lab-report/CodeSystem/dug",
                  "code" : "67",
                  "display" : "via"
                }
              ]
            }
          }
        ]
      },
      {
        "id" : "Address.line.extension:denominazioneUrbanisticaUfficiale",
        "path" : "Address.line.extension",
        "sliceName" : "denominazioneUrbanisticaUfficiale",
        "short" : "Denominazione Urbanistica Ufficiale (DUF)",
        "alias" : ["denominazione", "user content"],
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameBase"
            ]
          }
        ],
        "example" : [
          {
            "label" : "ex-1",
            "valueString" : "Corta"
          }
        ]
      },
      {
        "id" : "Address.line.extension:houseNumber",
        "path" : "Address.line.extension",
        "sliceName" : "houseNumber",
        "short" : "Numero Civico",
        "requirements" : "Numero Civico",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber"
            ]
          }
        ],
        "example" : [
          {
            "label" : "ex-1",
            "valueString" : "1"
          }
        ]
      },
      {
        "id" : "Address.line.extension:denominazioneUrbanisticaGenerica",
        "path" : "Address.line.extension",
        "sliceName" : "denominazioneUrbanisticaGenerica",
        "short" : "Denominazione Urbanistica Generica (DUG)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameType"
            ]
          }
        ],
        "example" : [
          {
            "label" : "ex-1",
            "valueString" : "Via"
          }
        ]
      },
      {
        "id" : "Address.city",
        "path" : "Address.city",
        "definition" : "Nome della città, paese, frazione, ecc.",
        "alias" : ["Comune"]
      },
      {
        "id" : "Address.district",
        "path" : "Address.district",
        "short" : "Nome della Provincia",
        "definition" : "Nome dell'area amministrativa (county).\r\nPer gli indirizzi italiani è usato per indicare la Provincia",
        "alias" : ["Provincia"]
      },
      {
        "id" : "Address.district.extension",
        "path" : "Address.district.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Address.district.extension:codiceProvincia",
        "path" : "Address.district.extension",
        "sliceName" : "codiceProvincia",
        "short" : "Codice Provincia",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding"]
          }
        ]
      },
      {
        "id" : "Address.state",
        "path" : "Address.state",
        "short" : "Sotto-unità dello stato (Regione).",
        "definition" : "Sotto-unità dello stato con limitata sovranità in uno stato oragnizzato federalmente.\r\nNel contesto italiano indica la \"Regione\"",
        "alias" : ["Regione", "Territory"]
      },
      {
        "id" : "Address.state.extension",
        "path" : "Address.state.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Address.state.extension:codiceRegione",
        "path" : "Address.state.extension",
        "sliceName" : "codiceRegione",
        "short" : "Codice Regione",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding"]
          }
        ]
      },
      {
        "id" : "Address.postalCode",
        "path" : "Address.postalCode",
        "comment" : "I codici postali italiani hanno un pattern '[1,9]{4}'.",
        "alias" : ["CAP", "postcode"],
        "constraint" : [
          {
            "key" : "it-postal-code-pattern",
            "severity" : "error",
            "human" : "I codici postali italiani hanno un pattern 'nnnnn' (n intero)",
            "expression" : "matches('[0-9]{5}')",
            "xpath" : "matches(@value,'[0-9]{5}')",
            "source" : "http://hl7.it/fhir/lab-report/StructureDefinition/address-it"
          }
        ]
      },
      {
        "id" : "Address.country.extension",
        "path" : "Address.country.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Address.country.extension:codiceStato",
        "path" : "Address.country.extension",
        "sliceName" : "codiceStato",
        "short" : "Codice Stato",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding"]
          }
        ]
      }
    ]
  }
}

```
