# A.1.7 - Validatore - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.7 - Validatore**

## Logical Model: A.1.7 - Validatore 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/Validatore | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:ValidatorLabEhn |

 
Validatore del documento. 

**Usages:**

* Use this Logical Model: [A - Referto di Laboratorio](StructureDefinition-RefertoLaboratorio.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/Validatore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Validatore.csv), [Excel](StructureDefinition-Validatore.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Validatore",
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/Validatore",
  "version" : "0.2.0",
  "name" : "ValidatorLabEhn",
  "title" : "A.1.7 - Validatore",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Validatore del documento.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "eHN Lab Validator model to FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.it/fhir/lab-report/StructureDefinition/Validatore",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Validatore",
        "path" : "Validatore",
        "short" : "A.1.7 - Validatore",
        "definition" : "Validatore del documento.",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.attester.where(mode=http://hl7.org/fhir/composition-attestation-mode#professional)"
          }
        ]
      },
      {
        "id" : "Validatore.identifier",
        "path" : "Validatore.identifier",
        "short" : "A.1.7.1 Identificativo del validatore dei risultati",
        "definition" : "Numero di identificazione dell'operatore sanitario. Identificativo assegnato da un'istituzione erogatrice di assistenza sanitaria o (preferibilmente) un'identificativo nazionale dell'operatore sanitario come il numero di licenza o di registrazione. - Sistema: ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".party.resolve().ofType(PractictionerRole).identifier"
          },
          {
            "identity" : "fhir",
            "map" : ".party.resolve().ofType(PractictionerRole).practictioner.resolve().identifier"
          }
        ]
      },
      {
        "id" : "Validatore.name",
        "path" : "Validatore.name",
        "short" : "A.1.7.2 Nome del validatore dei risultati",
        "definition" : "Nome della persona. - Sistema: ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".party.resolve().ofType(PractictionerRole).practictioner.resolve().name"
          }
        ]
      },
      {
        "id" : "Validatore.organization",
        "path" : "Validatore.organization",
        "short" : "A.1.7.3 Organizzazione del validatore",
        "definition" : "Informazioni sull'organizzazione dell'operatore sanitario. - Sistema: ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".party.resolve().ofType(PractictionerRole).organization.resolve()"
          },
          {
            "identity" : "fhir",
            "map" : ".party.resolve().ofType(Organization)"
          }
        ]
      },
      {
        "id" : "Validatore.dateTime",
        "path" : "Validatore.dateTime",
        "short" : "A.1.7.4 Data e ora di convalida",
        "definition" : "Data e ora in cui il documento è stato validato. - Sistema: ISO 8601",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".time"
          }
        ]
      }
    ]
  }
}

```
