# A.1.1, A.1.2 - Soggetto delle cure - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.1, A.1.2 - Soggetto delle cure**

## Logical Model: A.1.1, A.1.2 - Soggetto delle cure 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/SoggettoCura | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:SoggettoCura |

 
Paziente o Soggetto delle cure. 

**Usages:**

* Use this Logical Model: [A - Referto di Laboratorio](StructureDefinition-RefertoLaboratorio.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/SoggettoCura)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SoggettoCura.csv), [Excel](StructureDefinition-SoggettoCura.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SoggettoCura",
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/SoggettoCura",
  "version" : "0.2.0",
  "name" : "SoggettoCura",
  "title" : "A.1.1, A.1.2 - Soggetto delle cure",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Paziente o Soggetto delle cure.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "eHN Lab Subject model to FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.it/fhir/lab-report/StructureDefinition/SoggettoCura",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "SoggettoCura",
        "path" : "SoggettoCura",
        "short" : "A.1.1, A.1.2 - Soggetto delle cure",
        "definition" : "Paziente o Soggetto delle cure.",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.conformsTo('http://hl7.eu/fhir/laboratory/StructureDefinition/Patient-eu-lab')"
          }
        ]
      },
      {
        "id" : "SoggettoCura.identificazione",
        "path" : "SoggettoCura.identificazione",
        "short" : "A.1.1 Identificazione del paziente/soggetto",
        "definition" : "A.1.1 Identificazione del paziente/soggetto",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient"
          }
        ]
      },
      {
        "id" : "SoggettoCura.identificazione.cognome",
        "path" : "SoggettoCura.identificazione.cognome",
        "short" : "A.1.1.1 Cognome",
        "definition" : "Il cognome del paziente. Questo campo può contenere più di un elemento oppure possono essere presenti più campi.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.name.family"
          }
        ]
      },
      {
        "id" : "SoggettoCura.identificazione.nome",
        "path" : "SoggettoCura.identificazione.nome",
        "short" : "A.1.1.2 Nome",
        "definition" : "Il nome del paziente . Questo campo può contenere più di un elemento. ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.name.given"
          }
        ]
      },
      {
        "id" : "SoggettoCura.identificazione.dataNascita",
        "path" : "SoggettoCura.identificazione.dataNascita",
        "short" : "A.1.1.3 Data di nascita",
        "definition" : "La data di nascita del paziente [ISO TS 22220]. Poiché l'età del paziente potrebbe essere importante per la corretta interpretazione dei valori dei risultati del test, è necessario fornire la data di nascita completa - Sistema/i preferito/i: data completa, senza ora, seguendo la norma ISO 8601 ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.birthDate"
          }
        ]
      },
      {
        "id" : "SoggettoCura.identificazione.identificativo",
        "path" : "SoggettoCura.identificazione.identificativo",
        "short" : "A.1.1.4 Identificativo personale",
        "definition" : "Un identificatore del paziente unico all'interno di un ambito definito. Esempio: ID nazionale (numero di nascita) per il paziente ceco. Potrebbero essere forniti identificatori multipli. ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.identifier"
          }
        ]
      },
      {
        "id" : "SoggettoCura.identificazione.gender",
        "path" : "SoggettoCura.identificazione.gender",
        "short" : "A.1.1.5 Gender",
        "definition" : "Questo campo deve contenere un valore valido riconosciuto per 'genere amministrativo'.\nSe diverso, il \"genere fisiologico\" dovrebbe essere comunicato altrove Sistema: - Sistema: HL7 Administrative Gender ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.gender"
          }
        ]
      },
      {
        "id" : "SoggettoCura.recapito",
        "path" : "SoggettoCura.recapito",
        "short" : "A.1.2 Informazioni di contatto relative al paziente/soggetto",
        "definition" : "A.1.2 Informazioni di contatto relative al paziente/soggetto",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.address"
          }
        ]
      },
      {
        "id" : "SoggettoCura.recapito.indirizzo",
        "path" : "SoggettoCura.recapito.indirizzo",
        "short" : "A.1.2.1 Indirizzo",
        "definition" : "Indirizzi postali e di casa o ufficio. Gli indirizzi sono sempre sequenze di parti di indirizzo (ad es. riga dell'indirizzo, paese, codice postale, città) anche se i formati dell'indirizzo postale possono variare a seconda del paese Un indirizzo può includere o meno uno specifico codice d'uso, se tale attributo non è presente si assume che sia l'indirizzo di default utile per qualsiasi scopo - Sistema/i preferito/i: ISO 3166",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.address"
          }
        ]
      },
      {
        "id" : "SoggettoCura.recapito.telefono",
        "path" : "SoggettoCura.recapito.telefono",
        "short" : "A.1.2.2 Telecom",
        "definition" : "Informazioni sui contatti di telecomunicazione (indirizzi) associati a una persona. Potrebbero essere forniti più indirizzi di telecomunicazione. - Sistema/i preferito/i: ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Patient.telecom"
          }
        ]
      }
    ]
  }
}

```
