# A.6 - Organizer - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.6 - Organizer**

## Logical Model: A.6 - Organizer 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/Organizer | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:Organizer |

 
Risultato di un insieme di esami. 

**Usages:**

* Use this Logical Model: [A - Referto di Laboratorio](StructureDefinition-RefertoLaboratorio.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/Organizer)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Organizer.csv), [Excel](StructureDefinition-Organizer.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Organizer",
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/Organizer",
  "version" : "0.2.0",
  "name" : "Organizer",
  "title" : "A.6 - Organizer",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Risultato di un insieme di esami.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "eHN Modello Logico Organizer - FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.it/fhir/lab-report/StructureDefinition/Organizer",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Organizer",
        "path" : "Organizer",
        "short" : "A.6 - Organizer",
        "definition" : "Risultato di un insieme di esami.",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.conformsTo('http://hl7.it/fhir/lab-report/StructureDefinition/ObservationGroupingRefertoLabIt')"
          }
        ]
      },
      {
        "id" : "Organizer.osservazione",
        "path" : "Organizer.osservazione",
        "short" : "A.5.2 Dettagli dell'osservazione",
        "definition" : "A.5.2 Dettagli dell'osservazione (il rapporto può consistere di più osservazioni) ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.hasMember.resolve()"
          },
          {
            "identity" : "fhir",
            "map" : "Observation.component"
          }
        ]
      },
      {
        "id" : "Organizer.osservazione.data",
        "path" : "Organizer.osservazione.data",
        "short" : "A.5.2.1 Data dell'osservazione",
        "definition" : "Data e ora dell'osservazione - Sistema di codifica: ISO 8601",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.effective[x]"
          }
        ]
      },
      {
        "id" : "Organizer.osservazione.codice",
        "path" : "Organizer.osservazione.codice",
        "short" : "A.5.2.3 Codice dell'osservazione",
        "definition" : "Codice che rappresenta l'osservazione utilizzando i sistemi di codici concordati.\n- Sistema/i preferito/i: LOINC\n  - Sistema/i preferito/i: NPU\n  - Sistema/i preferito/i: SNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.code"
          }
        ]
      },
      {
        "id" : "Organizer.osservazione.risultato",
        "path" : "Organizer.osservazione.risultato",
        "short" : "A.5.2.11 Risultato dell'osservazione",
        "definition" : "Risultato e codifica della misura relativa all'osservazione inclusi testo, risultati numerici e codificati. Il contenuto del risultato dell'osservazione varierà a seconda del tipo di osservazione.\n- Sistema/i preferito/i: SNOMED CT (per i risultati in scala ordinale o nominale e codifica dei risultati)\n- Sistema/i preferito/i: UCUM (per unità)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.value[x]"
          }
        ]
      }
    ]
  }
}

```
