# A.1.6 - Firmatario - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.6 - Firmatario**

## Logical Model: A.1.6 - Firmatario 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/Firmatario | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:Firmatario |

 
Firmatario legale (La persona che si assume la responsabilità del contenuto medico del documento). 

**Usages:**

* Use this Logical Model: [A - Referto di Laboratorio](StructureDefinition-RefertoLaboratorio.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/Firmatario)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Firmatario.csv), [Excel](StructureDefinition-Firmatario.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Firmatario",
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/Firmatario",
  "version" : "0.2.0",
  "name" : "Firmatario",
  "title" : "A.1.6 - Firmatario",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Firmatario legale (La persona che si assume la responsabilità del contenuto medico del documento).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "eHN Lab LegalAuthenticator model to FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.it/fhir/lab-report/StructureDefinition/Firmatario",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Firmatario",
        "path" : "Firmatario",
        "short" : "A.1.6 - Firmatario",
        "definition" : "Firmatario legale (La persona che si assume la responsabilità del contenuto medico del documento).",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.attester.where(mode=http://hl7.org/fhir/composition-attestation-mode#legal)"
          }
        ]
      },
      {
        "id" : "Firmatario.identificativo",
        "path" : "Firmatario.identificativo",
        "short" : "A.1.6.1 Identificatore dell'autenticatore legale",
        "definition" : "Il numero di identificazione dell'operatore sanitario. Un identificativo interno assegnato da un'istituzione erogatrice di assistenza sanitaria o (preferibilmente) un'identificazione nazionale dell'operatore sanitario come il numero di licenza o di registrazione. - Sistema preferito( S): ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".party.resolve().ofType(PractictionerRole).identifier"
          }
        ]
      },
      {
        "id" : "Firmatario.nome",
        "path" : "Firmatario.nome",
        "short" : "A.1.6.2 Nome dell'autenticatore legale",
        "definition" : "Nome della persona. - Sistema/i preferito/i: ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".party.resolve().ofType(PractictionerRole).practictioner.resolve().name"
          }
        ]
      },
      {
        "id" : "Firmatario.organizzazione",
        "path" : "Firmatario.organizzazione",
        "short" : "A.1.6.3 Organizzazione dell'autenticatore legale",
        "definition" : "Informazioni sull'organizzazione dell'operatore sanitario. - Sistema/i preferito/i: ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".party.resolve().ofType(PractictionerRole).organization.resolve()"
          },
          {
            "identity" : "fhir",
            "map" : ".party.resolve().ofType(Organization)"
          }
        ]
      },
      {
        "id" : "Firmatario.data",
        "path" : "Firmatario.data",
        "short" : "A.1.6.4 Data e ora di autenticazione",
        "definition" : "Data e ora in cui il documento è stato autorizzato. - Sistema/i preferito/i: ISO 8601",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".time"
          }
        ]
      }
    ]
  }
}

```
