# A.1.4 - Informazioni Destinatario - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.4 - Informazioni Destinatario**

## Logical Model: A.1.4 - Informazioni Destinatario 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/Destinatario | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:Destinatario |

 
Destinatario delle informazioni (destinatario o destinatari del referto, ulteriori destinatari potrebbero essere individuati dal committente, ad es. medico di base, altro specialista), se applicabile. 

**Usages:**

* Use this Logical Model: [A - Referto di Laboratorio](StructureDefinition-RefertoLaboratorio.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/Destinatario)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Destinatario.csv), [Excel](StructureDefinition-Destinatario.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Destinatario",
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/Destinatario",
  "version" : "0.2.0",
  "name" : "Destinatario",
  "title" : "A.1.4 - Informazioni Destinatario",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Destinatario delle informazioni (destinatario o destinatari del referto, ulteriori destinatari potrebbero essere individuati dal committente, ad es. medico di base, altro specialista), se applicabile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "eHN Lab Recipient model to FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.it/fhir/lab-report/StructureDefinition/Destinatario",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Destinatario",
        "path" : "Destinatario",
        "short" : "A.1.4 - Informazioni Destinatario",
        "definition" : "Destinatario delle informazioni (destinatario o destinatari del referto, ulteriori destinatari potrebbero essere individuati dal committente, ad es. medico di base, altro specialista), se applicabile.",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Organization"
          },
          {
            "identity" : "fhir",
            "map" : "PractictionerRole"
          },
          {
            "identity" : "fhir",
            "map" : "Practictioner"
          },
          {
            "identity" : "fhir",
            "map" : "Patient"
          },
          {
            "identity" : "fhir",
            "map" : "RelatedPerson"
          }
        ]
      },
      {
        "id" : "Destinatario.identificativo",
        "path" : "Destinatario.identificativo",
        "short" : "A.1.4.1 Identificativo del destinatario",
        "definition" : "Il numero di identificazione dell'operatore sanitario.\nUn identificatore interno assegnato da un istituto di assistenza sanitaria o (preferibilmente) un ID professionale sanitario nazionale come il numero di licenza o di registrazione.\nNel caso in cui il destinatario non sia un operatore sanitario, ad es. paziente, deve essere utilizzato un identificatore personale appropriato.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : ".identifier"
          }
        ]
      },
      {
        "id" : "Destinatario.nome",
        "path" : "Destinatario.nome",
        "short" : "A.1.4.2 Nome del destinatario",
        "definition" : "Person name.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Organization.name"
          },
          {
            "identity" : "fhir",
            "map" : "PractictionerRole.practitioner.resolve().name"
          },
          {
            "identity" : "fhir",
            "map" : "Practictioner.name"
          },
          {
            "identity" : "fhir",
            "map" : "Patientn.name"
          },
          {
            "identity" : "fhir",
            "map" : "RelatedPerson.name"
          }
        ]
      },
      {
        "id" : "Destinatario.organizzazione",
        "path" : "Destinatario.organizzazione",
        "short" : "A.1.4.3 Organizzazione di appartenenza del destinatario",
        "definition" : "The healthcare provider organization information.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "PractictionerRole.organization.resolve()"
          }
        ]
      }
    ]
  }
}

```
