# A.4 - Informazioni sul Campione - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.4 - Informazioni sul Campione**

## Logical Model: A.4 - Informazioni sul Campione 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/Campione | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:Campione |

 
Informazioni sul campione. 

**Usages:**

* Use this Logical Model: [A - Referto di Laboratorio](StructureDefinition-RefertoLaboratorio.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/Campione)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Campione.csv), [Excel](StructureDefinition-Campione.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Campione",
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/Campione",
  "version" : "0.2.0",
  "name" : "Campione",
  "title" : "A.4 - Informazioni sul Campione",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Informazioni sul campione.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "eHN Lab Specimen model to FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.it/fhir/lab-report/StructureDefinition/Campione",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Campione",
        "path" : "Campione",
        "short" : "A.4 - Informazioni sul Campione",
        "definition" : "Informazioni sul campione.",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Observation.conformsTo('http://hl7.eu/fhir/ig/xeh/StructureDefinition/Observation-results-laboratory-eu-xeh').specimen.resolve()"
          }
        ]
      },
      {
        "id" : "Campione.identificativo",
        "path" : "Campione.identificativo",
        "short" : "A.4.1 identificativo del campione",
        "definition" : "Identificativo unicvoco del campione . Esempio: Identificativo assegnato dal sistema di campionamento, Identificativo assegnato dal laboratorio ecc. È possibile utilizzare più Identificativi. - Sistema di Codifica : ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Specimen.identifier"
          }
        ]
      },
      {
        "id" : "Campione.tipoCampione",
        "path" : "Campione.tipoCampione",
        "short" : "A.4.2 Tipo di campione",
        "definition" : "Tipo biologico del campione. - Sistema di Codifica: SNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Specimen.type"
          }
        ]
      },
      {
        "id" : "Campione.dataRaccolta",
        "path" : "Campione.dataRaccolta",
        "short" : "A.4.4 Periodo di raccolta",
        "definition" : "Data, ora o periodo di raccolta. - Sistema: ISO 8601",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Specimen.collection.collected[x]"
          }
        ]
      },
      {
        "id" : "Campione.posizioneAnatomica",
        "path" : "Campione.posizioneAnatomica",
        "short" : "A.4.5 Sede anatomica",
        "definition" : "Posizione anatomica (posizione del corpo, lateralità) in cui il campione viene raccolto, ad es. Gomito, sinistra - Sistema: SNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Specimen.collection.bodySite"
          }
        ]
      },
      {
        "id" : "Campione.metodoRaccolta",
        "path" : "Campione.metodoRaccolta",
        "short" : "A.4.8 Procedura/metodo di raccolta",
        "definition" : "Se rilevante per i risultati, il metodo per ottenere il campione. - Sistema: SNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Specimen.collection.method"
          }
        ]
      },
      {
        "id" : "Campione.dataRicezione",
        "path" : "Campione.dataRicezione",
        "short" : "A.4.9 Data di ricezione",
        "definition" : "Data e ora in cui il materiale viene consegnato al laboratorio o al centro di raccolta dei campioni. - Sistema: ISO 8601",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Specimen.receivedTime"
          }
        ]
      }
    ]
  }
}

```
