# A.1.5 - Autore - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **A.1.5 - Autore**

## Logical Model: A.1.5 - Autore 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/StructureDefinition/Autore | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:Autore |

 
Autore (da chi è stato redatto il referto sui risultati di laboratorio o un sottoinsieme dei risultati). 

**Usages:**

* Use this Logical Model: [A - Referto di Laboratorio](StructureDefinition-RefertoLaboratorio.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.lab-report|current/StructureDefinition/Autore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Autore.csv), [Excel](StructureDefinition-Autore.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Autore",
  "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/Autore",
  "version" : "0.2.0",
  "name" : "Autore",
  "title" : "A.1.5 - Autore",
  "status" : "active",
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Autore (da chi è stato redatto il referto sui risultati di laboratorio o un sottoinsieme dei risultati).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir",
      "uri" : "hl7.org/fhir/r4",
      "name" : "eHN Lab Author model to FHIR R4 Map"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://hl7.it/fhir/lab-report/StructureDefinition/Autore",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Autore",
        "path" : "Autore",
        "short" : "A.1.5 - Autore",
        "definition" : "Autore (da chi è stato redatto il referto sui risultati di laboratorio o un sottoinsieme dei risultati).",
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.author.resolve()"
          }
        ]
      },
      {
        "id" : "Autore.identificativo",
        "path" : "Autore.identificativo",
        "short" : "A.1.5.1 Identificativo dell'autore",
        "definition" : "Numero per l'identificazione dell'operatore sanitario o del dispositivo autore. Un identificatore interno assegnato da un'istituzione erogatrice di assistenza sanitaria o (preferibilmente) un identificativo nazionale dell'operatore sanitario come il numero di licenza o di registrazione. - Sistema: ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.author.resolve().ofType(PractictionerRole).practictioner.resolve().identifier"
          },
          {
            "identity" : "fhir",
            "map" : "Composition.author.resolve().ofType(PractictionerRole).identifier"
          }
        ]
      },
      {
        "id" : "Autore.nome",
        "path" : "Autore.nome",
        "short" : "A.1.5.2 Nome dell'autore",
        "definition" : "Nome della persona o del dispositivo. - Sistema: ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.author.resolve().ofType(PractictionerRole).practictioner.resolve().name"
          }
        ]
      },
      {
        "id" : "Autore.organizzazione",
        "path" : "Autore.organizzazione",
        "short" : "A.1.5.3 Organizzazione dell'autore",
        "definition" : "Informazioni sull'organizzazione dell'operatore sanitario. - Sistema: ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir",
            "map" : "Composition.author.resolve().ofType(PractictionerRole).organization.resolve()"
          }
        ]
      }
    ]
  }
}

```
