# EsempioCampione - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EsempioCampione**

## Example Specimen: EsempioCampione

Profile: [Specimen - Lab Report](StructureDefinition-specimen-it-lab.md)

**type**: Whole blood

**subject**: [Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5)

### Collections

| | |
| :--- | :--- |
| - | **BodySite** |
| * | Anterior surface of arm |

### Containers

| | |
| :--- | :--- |
| - | **Type** |
| * | Evacuated blood collection tube |



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "168d4960-0a0b-43af-8025-180f0965f325",
  "meta" : {
    "profile" : [
      "http://hl7.it/fhir/lab-report/StructureDefinition/specimen-it-lab"
    ]
  },
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-SpecimenType",
        "code" : "BLD",
        "display" : "Whole blood"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
  },
  "collection" : {
    "bodySite" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "7311008",
          "display" : "Anterior surface of arm"
        }
      ]
    }
  },
  "container" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "706052002",
            "display" : "Evacuated blood collection tube"
          }
        ]
      }
    }
  ]
}

```
