# ServiceRequest-Lab-Esempio - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest-Lab-Esempio**

## Example ServiceRequest: ServiceRequest-Lab-Esempio

Profile: [ServiceRequest - Lab Report](StructureDefinition-servicerequest-it-lab.md)

**identifier**: 12345 (, period: 2023-03-15 --> 2023-04-15)

**requisition**: 1300A4000000248

**status**: Completed

**intent**: Order

**category**: Laboratory procedure

**priority**: Routine

**code**: Leukocyte poor blood preparation

**subject**: [Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5)

**authoredOn**: 2023-03-15

**reasonCode**: Pregestational diabetes mellitus AND/OR impaired glucose tolerance, modified White class F

**specimen**: [Specimen: type = Whole blood](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-168d4960-0a0b-43af-8025-180f0965f325)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "463ae6fe-60d4-4b38-84b3-1008e0925678",
  "meta" : {
    "profile" : [
      "http://hl7.it/fhir/lab-report/StructureDefinition/servicerequest-it-lab"
    ]
  },
  "identifier" : [
    {
      "value" : "12345",
      "period" : {
        "start" : "2023-03-15",
        "end" : "2023-04-15"
      }
    }
  ],
  "requisition" : {
    "value" : "1300A4000000248"
  },
  "status" : "completed",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "108252007",
          "display" : "Laboratory procedure"
        }
      ]
    }
  ],
  "priority" : "routine",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "5357009",
        "display" : "Leukocyte poor blood preparation"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
  },
  "authoredOn" : "2023-03-15",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "4307007",
          "display" : "Pregestational diabetes mellitus AND/OR impaired glucose tolerance, modified White class F"
        }
      ]
    }
  ],
  "specimen" : [
    {
      "reference" : "urn:uuid:168d4960-0a0b-43af-8025-180f0965f325"
    }
  ]
}

```
