# Paziente-SSN - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Paziente-SSN**

## Example Patient: Paziente-SSN

Profile: [Patient - Lab Report](StructureDefinition-patient-it-lab.md)

Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)

-------

| | |
| :--- | :--- |
| Contact Detail | * ph: 3331245678
* [maria.rossi@mail.com](mailto:maria.rossi@mail.com)
* Via della Libertà, 52 Milano 20100 IT (home)
 |
| Emergency Contact: | * Luigi Rossi 
* ph: 3312345567
 |
| Emergency Contact: | * Maria Bianchi 
* ph: 3311234598
 |
| Links: | * General Practitioner: [Organization AZIENDA U.S.L. VALLE D'AOSTA](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8)
 |
| [Professione del paziente](StructureDefinition-patient-occupation-it.md) | Dirigenti della magistratura |
| [Titolo di Studio del paziente](StructureDefinition-patient-qualification-it.md) | Giuridico economico aziendale |
| [Codice comune e/o stato di nascita](StructureDefinition-patient-codeableBirthPlace.md) | Italia |
| [Patient Birth Place](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-birthPlace.html) | Via della Vittoria, 1 Milano 20100 IT |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "8472931c-fbd0-437b-9ed1-4f66472c78b5",
  "meta" : {
    "profile" : [
      "http://hl7.it/fhir/lab-report/StructureDefinition/patient-it-lab"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-birthPlace",
      "valueAddress" : {
        "line" : ["Via della Vittoria, 1"],
        "_line" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                "valueString" : "Via della Vittoria"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                "valueString" : "1"
              }
            ]
          }
        ],
        "city" : "Milano",
        "postalCode" : "20100",
        "country" : "IT"
      }
    },
    {
      "url" : "http://hl7.it/fhir/StructureDefinition/patient-occupation-it",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-professioni",
            "code" : "1.1.3",
            "display" : "Dirigenti della magistratura"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.it/fhir/StructureDefinition/patient-qualification-it",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-ctsi03",
            "code" : "40205013",
            "display" : "Giuridico economico aziendale"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-unitaAmministrativeTerritorialiEstere",
            "code" : "100",
            "display" : "Italia"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "extension" : [
        {
          "extension" : [
            {
              "url" : "when",
              "valueDateTime" : "2022-05-01"
            }
          ],
          "url" : "http://hl7.it/fhir/StructureDefinition/recordCertification"
        }
      ],
      "system" : "http://hl7.it/sid/codiceFiscale",
      "value" : "RSSMRA71E01F205E"
    }
  ],
  "name" : [
    {
      "family" : "Rossi",
      "given" : ["Maria"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "3331245678"
    },
    {
      "system" : "email",
      "value" : "maria.rossi@mail.com"
    }
  ],
  "gender" : "female",
  "birthDate" : "1971-05-01",
  "address" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.it/fhir/lab-report/StructureDefinition/address-official",
          "valueBoolean" : true
        }
      ],
      "use" : "home",
      "line" : ["Via della Libertà, 52"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.it/fhir/StructureDefinition/address-dug",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.it/fhir/lab-report/CodeSystem/dug",
                    "code" : "67",
                    "display" : "via"
                  }
                ]
              }
            }
          ]
        }
      ],
      "city" : "Milano",
      "postalCode" : "20100",
      "country" : "IT"
    }
  ],
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "C",
              "display" : "Emergency Contact"
            }
          ]
        }
      ],
      "name" : {
        "family" : "Rossi",
        "given" : ["Luigi"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "3312345567"
        }
      ]
    },
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "C",
              "display" : "Emergency Contact"
            }
          ]
        }
      ],
      "name" : {
        "family" : "Bianchi",
        "given" : ["Maria"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "3311234598"
        }
      ]
    }
  ],
  "generalPractitioner" : [
    {
      "reference" : "urn:uuid:ae0365ea-d8a1-45e0-a39d-f14fac4ccfe8"
    }
  ]
}

```
