# Observation-Lab-Esempio-Cloruro - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation-Lab-Esempio-Cloruro**

## Example Observation: Observation-Lab-Esempio-Cloruro

Profile: [Observation - Lab Report](StructureDefinition-observation-it-lab.md)

**status**: Final

**category**: Laboratory

**code**: Chloride [Moles/volume] in Mixed venous blood

**subject**: [Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2023-02-25 11:45:00+0100 --> 2023-02-25 12:45:00+0100](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-7b06368c-7089-4f66-acc8-29e1fcbd31f6)

**effective**: 2023-05-01

**performer**: [PractitionerRole Generalist Medical Practitioners](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-dc5842a1-83b6-43c7-b063-75ae989b803c)

**value**: 100 meq/L(Details: UCUM codemeq/L = 'meq/L')

**specimen**: [Specimen: type = Whole blood](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-168d4960-0a0b-43af-8025-180f0965f325)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "5ea6e05a-e271-4ef9-bcc1-0bd10e55c90c",
  "meta" : {
    "profile" : [
      "http://hl7.it/fhir/lab-report/StructureDefinition/observation-it-lab"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "100745-9",
        "display" : "Chloride [Moles/volume] in Mixed venous blood"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
  },
  "encounter" : {
    "reference" : "urn:uuid:7b06368c-7089-4f66-acc8-29e1fcbd31f6"
  },
  "effectiveDateTime" : "2023-05-01",
  "performer" : [
    {
      "reference" : "urn:uuid:dc5842a1-83b6-43c7-b063-75ae989b803c"
    }
  ],
  "valueQuantity" : {
    "value" : 100,
    "unit" : "meq/L",
    "system" : "http://unitsofmeasure.org",
    "code" : "meq/L"
  },
  "specimen" : {
    "reference" : "urn:uuid:168d4960-0a0b-43af-8025-180f0965f325"
  }
}

```
