# Encounter-Lab-Esempio - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Encounter-Lab-Esempio**

## Example Encounter: Encounter-Lab-Esempio

Profile: [Encounter - Lab Report](StructureDefinition-encounter-it-lab.md)

**status**: Finished

**class**: [ActCode: AMB](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB) (ambulatory)

**subject**: [Maria Rossi Female, DoB: 1971-05-01 ( http://hl7.it/sid/codiceFiscale#RSSMRA71E01F205E)](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-8472931c-fbd0-437b-9ed1-4f66472c78b5)

**basedOn**: [ServiceRequest Leukocyte poor blood preparation](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-463ae6fe-60d4-4b38-84b3-1008e0925678)

### Participants

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Individual** |
| * | Secondary performer | [Practitioner Prova Infermiere](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c) |

**period**: 2023-02-25 11:45:00+0100 --> 2023-02-25 12:45:00+0100

### Locations

| | |
| :--- | :--- |
| - | **Location** |
| * | [Location Policlinico di Roma](Bundle-Bundle-Lab-Esempio-2.md#urn-uuid-f148e54a-2046-4534-b9e9-54e7e9632224) |



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "7b06368c-7089-4f66-acc8-29e1fcbd31f6",
  "meta" : {
    "profile" : [
      "http://hl7.it/fhir/lab-report/StructureDefinition/encounter-it-lab"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB",
    "display" : "ambulatory"
  },
  "subject" : {
    "reference" : "urn:uuid:8472931c-fbd0-437b-9ed1-4f66472c78b5"
  },
  "basedOn" : [
    {
      "reference" : "urn:uuid:463ae6fe-60d4-4b38-84b3-1008e0925678"
    }
  ],
  "participant" : [
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "SPRF",
              "display" : "Secondary performer"
            }
          ]
        }
      ],
      "individual" : {
        "reference" : "urn:uuid:134a0bb1-aa0a-46b9-aa1e-a5d0e379e77c"
      }
    }
  ],
  "period" : {
    "start" : "2023-02-25T11:45:00+01:00",
    "end" : "2023-02-25T12:45:00+01:00"
  },
  "location" : [
    {
      "location" : {
        "reference" : "urn:uuid:f148e54a-2046-4534-b9e9-54e7e9632224"
      }
    }
  ]
}

```
