# Mapping fra VS HL7 e Tabella ISTAT Stato Civile - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mapping fra VS HL7 e Tabella ISTAT Stato Civile**

## ConceptMap: Mapping fra VS HL7 e Tabella ISTAT Stato Civile (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/ConceptMap/ConceptMap-statoCivile | *Version*:0.2.0 |
| Active as of 2012-06-13 | *Computable Name*:HL7_ISTAT_StatoCivile |

 
Mapping da Value 'statoCivile' a Tabella Istat Stato Civile. 

 
Esempio di mapping fra value set. 

Mapping from [Stato Civile](ValueSet-statoCivile.md) to [ISTAT - Stato Civile](ValueSet-istat-statoCivile-vs.md)

**Group 1**Mapping from [MaritalStatus](http://terminology.hl7.org/7.0.0/CodeSystem-v3-MaritalStatus.html) to [ISTAT - Stato Civile](CodeSystem-istat-statoCivile.md)

* **Source Code**: S (Never Married)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: 1 (Celibe/Nubile)
  * **Comment**: 
* **Source Code**: M (Married)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: 2 (Coniugato/a)
  * **Comment**: 
* **Source Code**: D (Divorced)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: 4 (Divorziato/a)
  * **Comment**: 
* **Source Code**: W (Widowed)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: 3 (Vedovo/a)
  * **Comment**: 
* **Source Code**: A (Annulled)
  * **Relationship**: [maps loosely to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#inexact)
  * **Target Code**: 9 (Non classificabile/ignoto/n.c)
  * **Comment**: Concetto non classificato nel target, quindi associato alla classe 9 'Non classificabile/ignoto/n.c'
* **Source Code**: L (Legally Separated)
  * **Relationship**: [maps loosely to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#inexact)
  * **Target Code**: 9 (Non classificabile/ignoto/n.c)
  * **Comment**: Concetto non classificato nel target, quindi associato alla classe 9 'Non classificabile/ignoto/n.c'

-------

**Group 2**Mapping from [NullFlavor](http://terminology.hl7.org/7.0.0/CodeSystem-v3-NullFlavor.html) to [ISTAT - Stato Civile](CodeSystem-istat-statoCivile.md)

* **Source Code**: UNK (Unknown)
  * **Relationship**: [maps to wider concept](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#wider)
  * **Target Code**: 9 (Non classificabile/ignoto/n.c)
  * **Comment**: Il target comprende concetti come 'non classificabile' che corrspondono a nullFlavor tipo UNC e/o OTH

-------

**Group 3**Mapping from [ISTAT - Stato Civile](CodeSystem-istat-statoCivile.md) to [ISTAT - Stato Civile](CodeSystem-istat-statoCivile.md)

* **Source Code**: 6 (Unito civilmente)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: 6 (Unito civilmente)
* **Source Code**: 7 (Stato libero a seguito di decesso della parte unita civilmente)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: 7 (Stato libero a seguito di decesso della parte unita civilmente)
* **Source Code**: 8 (Stato libero a seguito di scioglimento dell'unione)
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: 8 (Stato libero a seguito di scioglimento dell'unione)



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "ConceptMap-statoCivile",
  "url" : "http://hl7.it/fhir/lab-report/ConceptMap/ConceptMap-statoCivile",
  "version" : "0.2.0",
  "name" : "HL7_ISTAT_StatoCivile",
  "title" : "Mapping fra VS HL7 e Tabella ISTAT Stato Civile",
  "status" : "active",
  "experimental" : true,
  "date" : "2012-06-13",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "Mapping da Value 'statoCivile' a Tabella Istat Stato Civile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "purpose" : "Esempio di mapping fra value set.",
  "sourceCanonical" : "http://hl7.it/fhir/lab-report/ValueSet/statoCivile",
  "targetCanonical" : "http://hl7.it/fhir/lab-report/ValueSet/istat-statoCivile-vs",
  "group" : [
    {
      "source" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
      "target" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-statoCivile",
      "element" : [
        {
          "code" : "S",
          "display" : "Never Married",
          "target" : [
            {
              "code" : "1",
              "display" : "Celibe/Nubile",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "M",
          "display" : "Married",
          "target" : [
            {
              "code" : "2",
              "display" : "Coniugato/a",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "D",
          "display" : "Divorced",
          "target" : [
            {
              "code" : "4",
              "display" : "Divorziato/a",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "W",
          "display" : "Widowed",
          "target" : [
            {
              "code" : "3",
              "display" : "Vedovo/a",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "A",
          "display" : "Annulled",
          "target" : [
            {
              "code" : "9",
              "display" : "Non classificabile/ignoto/n.c",
              "equivalence" : "inexact",
              "comment" : "Concetto non classificato nel target, quindi associato alla classe 9  'Non classificabile/ignoto/n.c'"
            }
          ]
        },
        {
          "code" : "L",
          "display" : "Legally Separated",
          "target" : [
            {
              "code" : "9",
              "display" : "Non classificabile/ignoto/n.c",
              "equivalence" : "inexact",
              "comment" : "Concetto non classificato nel target, quindi associato alla classe 9  'Non classificabile/ignoto/n.c'"
            }
          ]
        }
      ]
    },
    {
      "source" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
      "target" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-statoCivile",
      "element" : [
        {
          "code" : "UNK",
          "display" : "Unknown",
          "target" : [
            {
              "code" : "9",
              "display" : "Non classificabile/ignoto/n.c",
              "equivalence" : "wider",
              "comment" : "Il target comprende concetti come 'non classificabile' che corrspondono a nullFlavor tipo UNC e/o OTH"
            }
          ]
        }
      ]
    },
    {
      "source" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-statoCivile",
      "target" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-statoCivile",
      "element" : [
        {
          "code" : "6",
          "display" : "Unito civilmente",
          "target" : [
            {
              "code" : "6",
              "display" : "Unito civilmente",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "7",
          "display" : "Stato libero a seguito di decesso della parte unita civilmente",
          "target" : [
            {
              "code" : "7",
              "display" : "Stato libero a seguito di decesso della parte unita civilmente",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "8",
          "display" : "Stato libero a seguito di scioglimento dell'unione",
          "target" : [
            {
              "code" : "8",
              "display" : "Stato libero a seguito di scioglimento dell'unione",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
