# ISTAT - Classificazione delle professioni - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISTAT - Classificazione delle professioni**

## CodeSystem: ISTAT - Classificazione delle professioni 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/CodeSystem/istat-professioni | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:CsIstatProfessioni |

 
ISTAT - Classificazione delle professioni 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsIstatProfessionePaziente](ValueSet-istat-professione.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "istat-professioni",
  "url" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-professioni",
  "version" : "0.2.0",
  "name" : "CsIstatProfessioni",
  "title" : "ISTAT - Classificazione delle professioni",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "ISTAT - Classificazione delle professioni",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "concept" : [
    {
      "code" : "1",
      "display" : "LEGISLATORI, IMPRENDITORI E ALTA DIRIGENZA",
      "definition" : "Il primo grande gruppo comprende le professioni che richiedono un livello di conoscenza necessario a definire e implementare strategie di indirizzo e regolazione in ambito politico, istituzionale ed economico, anche avvalendosi di contributi specialistici. I loro compiti consistono nel definire e formulare le politiche di governo, le leggi e le norme a livello centrale e locale; sovrintendere alla loro interpretazione ed applicazione; rappresentare lo Stato ed il governo ed agire per loro conto; pianificare, dirigere, coordinare e valutare le politiche e gli obiettivi; orientare le attività generali di imprese, organizzazioni o unità organizzative complesse, pubbliche e private. Il livello di conoscenza richiesta dalle professioni comprese in questo grande gruppo non è sempre individuabile in un particolare livello di istruzione formale.",
      "concept" : [
        {
          "code" : "1.1",
          "display" : "Membri dei corpi legislativi e di governo, dirigenti ed equiparati dell'amministrazione pubblica, nella magistratura, nei servizi di sanità, istruzione e ricerca e nelle organizzazioni di interesse nazionale e sovranazionale",
          "definition" : "Le professioni raccolte in questo gruppo svolgono attività legate alla produzione legislativa e regolamentare, al governo, alla formulazione e alla implementazione delle politiche a livello nazionale e locale; rappresentano lo Stato e il governo e agiscono per loro conto; dirigono e organizzano settori dell’amministrazione pubblica, della magistratura, della sanità, dell'istruzione e della ricerca. Sono incluse in questo gruppo anche le professioni che organizzano, dirigono e rappresentano associazioni, a carattere nazionale e sovranazionale che tutelano e raccolgono interessi collettivi, umanitari, culturali e scientifici.",
          "concept" : [
            {
              "code" : "1.1.1",
              "display" : "Membri di organismi di governo e di assemblee con potestà legislativa e regolamentare",
              "definition" : "Le professioni comprese in questa classe esercitano attività e compiti legati alla produzione di leggi, statuti e regolamenti validi sul territorio nazionale e locale, alla definizione e alla realizzazione di politiche e alla relativa allocazione di risorse nei vari livelli territoriali in cui è organizzato il governo del paese. L’esercizio di tali professioni comporta, in genere, l’aver ottenuto un mandato in elezioni politiche o amministrative. Tale mandato, tuttavia, non risulta necessario qualora si tratti di componenti del governo nazionale e delle giunte delle amministrazioni locali."
            },
            {
              "code" : "1.1.1.1",
              "display" : "Membri di organismi di governo e di assemblee con potestà legislativa e regolamentare a livello nazionale",
              "definition" : "Le professioni classificate in questa categoria definiscono, discutono e approvano leggi, regolamenti e statuti validi sull’intero territorio nazionale, definiscono e implementano le politiche di governo individuando e allocando le risorse necessarie alla loro realizzazione."
            },
            {
              "code" : "1.1.1.1.0",
              "display" : "Membri di organismi di governo e di assemblee nazionali con potestà legislativa e regolamentare",
              "definition" : "Le professioni classificate in questa unità definiscono, discutono e approvano leggi, regolamenti e statuti validi sull’intero territorio nazionale, definiscono e implementano le politiche di governo individuando e allocando le risorse necessarie alla loro realizzazione."
            },
            {
              "code" : "1.1.1.2",
              "display" : "Membri di organismi di governo e di assemblee con potestà legislativa e regolamentare a livello regionale e di Province autonome",
              "definition" : "Le professioni classificate in questa categoria applicano sul territorio leggi nazionali e, negli ambiti previsti dall’organizzazione dello Stato, definiscono, discutono e approvano leggi, regolamenti e statuti validi sul territorio regionale e delle Province autonome, definiscono e implementano le politiche di governo locale individuando e allocando le risorse necessarie alla loro realizzazione."
            },
            {
              "code" : "1.1.1.2.0",
              "display" : "Membri di organismi di governo e di assemblee regionali e di Province autonome con potestà legislativa e regolamentare",
              "definition" : "Le professioni classificate in questa unità applicano sul territorio leggi nazionali e, negli ambiti previsti dall’organizzazione dello Stato, definiscono, discutono e approvano leggi, regolamenti e statuti validi sul territorio regionale e delle Province autonome, definiscono e implementano le politiche di governo locale individuando e allocando le risorse necessarie alla loro realizzazione."
            },
            {
              "code" : "1.1.1.3",
              "display" : "Membri di organismi di governo e di assemblee con potestà regolamentare a livello provinciale",
              "definition" : "Le professioni classificate in questa categoria applicano sul territorio leggi nazionali e locali e, negli ambiti previsti dall’organizzazione dello Stato e della Regione di appartenenza, definiscono, discutono e approvano regolamenti e statuti validi sul territorio provinciale, definiscono e implementano le politiche di governo locale individuando e allocando le risorse necessarie alla loro realizzazione."
            },
            {
              "code" : "1.1.1.3.0",
              "display" : "Membri di organismi di governo e di assemblee provinciali con potestà regolamentare",
              "definition" : "Le professioni classificate in questa unità applicano sul territorio leggi nazionali e locali e, negli ambiti previsti dall’organizzazione dello Stato e della Regione di appartenenza, definiscono, discutono e approvano regolamenti e statuti validi sul territorio provinciale, definiscono e implementano le politiche di governo locale individuando e allocando le risorse necessarie alla loro realizzazione."
            },
            {
              "code" : "1.1.1.4",
              "display" : "Membri di organismi di governo e di assemblee con potestà regolamentare a livello comunale e sub-provinciale",
              "definition" : "Le professioni classificate in questa categoria applicano sul territorio leggi nazionali e locali e, negli ambiti previsti dall’organizzazione dello Stato, della Regione e della Provincia di appartenenza, definiscono, discutono e approvano regolamenti e statuti validi sul territorio comunale o sub-provinciale, definiscono e implementano le politiche di governo locale individuando e allocando le risorse necessarie alla loro realizzazione."
            },
            {
              "code" : "1.1.1.4.0",
              "display" : "Membri di organismi di governo e di assemblee sub-provinciali e comunali con potestà regolamentare",
              "definition" : "Le professioni classificate in questa unità applicano sul territorio leggi nazionali e locali e, negli ambiti previsti dall’organizzazione dello Stato, della Regione e della Provincia di appartenenza, definiscono, discutono e approvano regolamenti e statuti validi sul territorio comunale o sub-provinciale, definiscono e implementano le politiche di governo locale individuando e allocando le risorse necessarie alla loro realizzazione."
            },
            {
              "code" : "1.1.2",
              "display" : "Direttori, dirigenti ed equiparati dell’amministrazione pubblica e nei servizi di sanità, istruzione e ricerca",
              "definition" : "Le professioni comprese in questa classe supportano il governo nazionale e locale nella definizione e nella formulazione delle leggi e delle politiche, pianificano, organizzano e dirigono le operazioni di grandi strutture dell’amministrazione pubblica, dell'Istruzione, dell'Università e della Sanità pubblica e privata, rappresentano lo Stato e il governo del paese e garantiscono, avvalendosi di altre professioni dirigenziali, la realizzazione delle politiche e l’applicazione delle leggi sul territorio nazionale."
            },
            {
              "code" : "1.1.2.1",
              "display" : "Ambasciatori, ministri plenipotenziari ed alti dirigenti della carriera diplomatica",
              "definition" : "Le professioni classificate in questa categoria agiscono per conto e rappresentano lo Stato e il governo presso altri Stati e presso le Organizzazioni Internazionali, tutelano gli interessi nazionali e i diritti dei concittadini all’estero e, nei casi previsti dalla legge, garantiscono la vigilanza sulle attività di organismi nazionali operanti all’estero e le funzioni amministrative sussidiarie."
            },
            {
              "code" : "1.1.2.1.0",
              "display" : "Ambasciatori, ministri plenipotenziari ed alti dirigenti della carriera diplomatica",
              "definition" : "Le professioni classificate in questa unità agiscono per conto dello Stato e del governo e li rappresentano presso altri Stati e presso le organizzazioni internazionali, tutelano gli interessi nazionali e i diritti dei concittadini all’estero e, nei casi previsti dalla legge, garantiscono la vigilanza sulle attività di organismi nazionali operanti all’estero e svolgono funzioni amministrative sussidiarie."
            },
            {
              "code" : "1.1.2.2",
              "display" : "Commissari di governo, prefetti e vice prefetti, capi e vice capi della polizia di stato, questori, segretari generali e professioni assimilate",
              "definition" : "Le professioni classificate in questa categoria assicurano e garantiscono sul territorio l’unitarietà e l’efficacia delle politiche di governo e dell’azione delle amministrazioni periferiche dello Stato coordinando attività e funzioni di queste ultime con quelle delle amministrazioni locali; rappresentano il governo sul territorio, sovrintendono alle attività degli organi di pubblica sicurezza e di protezione civile e adottano misure volte a garantire la sicurezza dei cittadini; collaborano con gli organi dello Stato e delle amministrazioni locali fornendo assistenza giuridico-amministrativa al fine di assicurare la conformità dell’azione amministrativa nazionale e locale alle leggi, agli statuti e ai regolamenti vigenti."
            },
            {
              "code" : "1.1.2.2.1",
              "display" : "Commissari di governo, prefetti e vice prefetti",
              "definition" : "Le professioni classificate in questa unità assicurano e garantiscono sul territorio l’unitarietà e l’efficacia delle politiche di governo e dell’azione delle amministrazioni periferiche dello Stato, coordinando attività e funzioni di queste ultime con quelle delle amministrazioni locali; rappresentano il governo sul territorio."
            },
            {
              "code" : "1.1.2.2.2",
              "display" : "Capi e vice capi della polizia di Stato, questori ed alti responsabili della sicurezza pubblica",
              "definition" : "Le professioni classificate in questa unità sovrintendono alle attività degli organi di pubblica sicurezza e di protezione civile e adottano misure volte a garantire la sicurezza dei cittadini."
            },
            {
              "code" : "1.1.2.2.3",
              "display" : "Segretari generali e responsabili del controllo e della gestione nella amministrazione pubblica",
              "definition" : "Le professioni classificate in questa unità collaborano con gli organi dello Stato e delle amministrazioni locali fornendo assistenza giuridico-amministrativa al fine di assicurare la conformità dell’azione amministrativa nazionale e locale alle leggi, agli statuti ed ai regolamenti vigenti."
            },
            {
              "code" : "1.1.2.3",
              "display" : "Direttori degli uffici scolastici territoriali, sovrintendenti al patrimonio culturale nazionale ed equiparati",
              "definition" : "Le professioni classificate in questa categoria sovrintendono e garantiscono sul territorio, in collaborazione con le amministrazioni locali e gli organismi territoriali preposti, l’attuazione degli ordinamenti scolastici e il raggiungimento degli standard educativi programmati fornendo assistenza alle istituzioni scolastiche e assegnando loro le risorse finanziarie e di personale necessarie; attuano sul territorio gli indirizzi in materia di tutela, salvaguardia e conservazione dei beni storico-artistici, archeologici, architettonici, paesaggistici e archivistici vigilando sull’osservanza, da parte di soggetti pubblici e privati detentori, delle leggi in materia di tutela, proponendo priorità nella allocazione delle risorse e promuovendo iniziative per il recupero e la valorizzazione."
            },
            {
              "code" : "1.1.2.3.1",
              "display" : "Direttori degli uffici scolastici territoriali ed equiparati",
              "definition" : "Le professioni classificate in questa unità sovrintendono e garantiscono sul territorio, in collaborazione con le amministrazioni locali e gli organismi territoriali preposti, l’attuazione degli ordinamenti scolastici e il raggiungimento degli standard educativi programmati, fornendo assistenza alle istituzioni scolastiche e assegnando loro le risorse umane e finanziarie necessarie."
            },
            {
              "code" : "1.1.2.3.2",
              "display" : "Sovrintendenti al patrimonio culturale nazionale",
              "definition" : "Le professioni classificate in questa unità attuano sul territorio gli indirizzi in materia di tutela, salvaguardia e conservazione dei beni storico-artistici, archeologici, architettonici, paesaggistici e archivistici vigilando sull’osservanza delle leggi in materia di tutela da parte di soggetti pubblici e privati detentori dei suddetti beni, proponendo priorità nell'allocazione delle risorse e promuovendo iniziative per il recupero e la valorizzazione."
            },
            {
              "code" : "1.1.2.4",
              "display" : "Direttori generali, dipartimentali ed equiparati delle amministrazioni dello Stato, degli enti pubblici non economici, degli enti locali, delle università, degli enti di ricerca e nella sanità",
              "definition" : "Le professioni classificate in questa categoria dirigono grandi strutture dell’amministrazione statale e locale, delle università, degli enti di ricerca e del Servizio Sanitario Nazionale, formulano proposte e pareri agli organi cui fanno riferimento, curano l’attuazione dei programmi e delle politiche adottando e definendo le modalità organizzative e le risorse necessarie alla loro realizzazione, esercitando poteri di spesa e attribuendo ai dirigenti subordinati le responsabilità di progetti nonché le risorse necessarie a realizzarli, verificandone e controllandone le attività rispetto agli obiettivi fissati e mantenendo la responsabilità della gestione e dei risultati raggiunti."
            },
            {
              "code" : "1.1.2.4.1",
              "display" : "Direttori generali, dipartimentali ed equiparati delle amministrazioni dello Stato, degli enti pubblici non economici e degli enti locali",
              "definition" : "Le professioni classificate in questa unità dirigono grandi strutture dell’amministrazione statale e locale, degli enti pubblici non economici e degli enti locali, formulano proposte e pareri agli organi cui fanno riferimento, curano l’attuazione dei programmi e delle politiche adottando e definendo le modalità organizzative e le risorse necessarie alla loro realizzazione, esercitando poteri di spesa e attribuendo ai dirigenti subordinati le responsabilità di progetti nonché le risorse necessarie a realizzarli, verificandone e controllandone le attività rispetto agli obiettivi fissati e mantenendo la responsabilità della gestione e dei risultati raggiunti."
            },
            {
              "code" : "1.1.2.4.2",
              "display" : "Rettori di università, direttori di istituzioni dell’Alta Formazione e di enti di ricerca",
              "definition" : "Le professioni classificate in questa unità dirigono università pubbliche e private, istituzioni dell'Alta Formazione Artistica, Musicale e Coreutica riconosciute, che rilasciano titoli di livello universitario ed enti di ricerca, formulano proposte e pareri agli organi cui fanno riferimento, curano l’attuazione dei programmi e delle politiche adottando e definendo le modalità organizzative e le risorse necessarie alla loro realizzazione, esercitando poteri di spesa e attribuendo ai dirigenti subordinati le responsabilità di progetti nonché le risorse necessarie a realizzarli, verificandone e controllandone le attività rispetto agli obiettivi fissati e mantenendo la responsabilità della gestione e dei risultati raggiunti."
            },
            {
              "code" : "1.1.2.4.3",
              "display" : "Direttori generali ed equiparati nella sanità",
              "definition" : "Le professioni classificate in questa unità dirigono grandi strutture del Servizio Sanitario Nazionale, formulano proposte e pareri agli organi cui fanno riferimento, curano l’attuazione dei programmi e delle politiche adottando e definendo le modalità organizzative e le risorse necessarie alla loro realizzazione, esercitando poteri di spesa e attribuendo ai dirigenti subordinati le responsabilità di progetti nonchè le risorse necessarie a realizzarli, verificandone e controllandone le attività rispetto agli obiettivi fissati e mantenendo la responsabilità della gestione e dei risultati raggiunti."
            },
            {
              "code" : "1.1.2.5",
              "display" : "Dirigenti scolastici ed equiparati",
              "definition" : "Le professioni comprese in questa categoria dirigono, coordinano e organizzano l’attività delle istituzioni scolastiche di ogni ordine e grado, pubbliche e private riconosciute, assicurano e sono responsabili della gestione delle risorse finanziarie e strumentali dell’istituzione scolastica, ne hanno la rappresentanza legale. Valorizzano le risorse umane, promuovono interventi e attività per assicurare la qualità dei processi formativi e la collaborazione delle risorse culturali, professionali, sociali ed economiche del territorio; garantiscono l'esercizio della libertà di insegnamento e di innovazione metodologica e didattica, la scelta educativa delle famiglie e l'attuazione del diritto all'apprendimento da parte degli alunni. Coinvolgono il personale docente e gli organi collegiali nelle decisioni in materia di organizzazione delle attività scolastiche, di didattica ed offerta formativa"
            },
            {
              "code" : "1.1.2.5.0",
              "display" : "Dirigenti scolastici ed equiparati",
              "definition" : "Le professioni comprese in questa unità dirigono, coordinano e organizzano l'attività delle istituzioni scolastiche di ogni ordine e grado, pubbliche e private riconosciute, assicurano e sono responsabili della gestione delle risorse finanziarie e strumentali dell'istituzione scolastica, ne hanno la rappresentanza legale. Valorizzano le risorse umane, promuovono interventi e attività per assicurare la qualità dei processi formativi e la collaborazione delle risorse culturali, professionali, sociali ed economiche del territorio; garantiscono l'esercizio della libertà di insegnamento e di innovazione metodologica e didattica, la scelta educativa delle famiglie e l'attuazione del diritto all'apprendimento da parte degli alunni. Coinvolgono il personale docente e gli organi collegiali nelle decisioni in materia di organizzazione delle attività scolastiche, di didattica ed offerta formativa"
            },
            {
              "code" : "1.1.2.6",
              "display" : "Dirigenti ed equiparati delle amministrazioni dello Stato, degli enti pubblici non economici, degli enti locali, delle università, degli enti di ricerca e nella sanità",
              "definition" : "Le professioni classificate in questa categoria dirigono uffici apicali dell’amministrazione statale e locale delle università, degli enti di ricerca e del Servizio Sanitario Nazionale, formulano proposte e pareri ai direttori generali o dipartimentali da cui dipendono funzionalmente, curano l’attuazione dei progetti loro affidati adottando e definendo, nei limiti di competenza, le modalità organizzative e le risorse necessarie alla loro realizzazione, esercitando i poteri di spesa loro attribuiti, coordinando le attività degli uffici loro subordinati, individuando i responsabili delle procedure affidate al proprio ufficio e verificando e controllando le attività complessive dell’ufficio rispetto agli obiettivi fissati. Sono responsabili della gestione e dei risultati raggiunti."
            },
            {
              "code" : "1.1.2.6.1",
              "display" : "Dirigenti ed equiparati delle amministrazioni dello Stato, degli enti pubblici non economici e degli enti locali",
              "definition" : "Le professioni classificate in questa unità dirigono articolazioni funzionali dell’amministrazione statale e locale, degli enti pubblici non economici e degli enti locali, formulano proposte e pareri ai direttori generali o dipartimentali da cui dipendono, curano l’attuazione dei progetti loro affidati adottando e definendo, nei limiti di competenza, le modalità organizzative e le risorse necessarie alla loro realizzazione, esercitando i poteri di spesa loro attribuiti, coordinando le attività degli uffici loro subordinati, individuando i responsabili delle procedure affidate al proprio ufficio e verificando e controllando le attività complessive dell’ufficio rispetto agli obiettivi fissati. Sono responsabili della gestione e dei risultati raggiunti."
            },
            {
              "code" : "1.1.2.6.2",
              "display" : "Dirigenti ed equiparati delle università e degli enti di ricerca",
              "definition" : "Le professioni classificate in questa unità dirigono articolazioni funzionali delle università e degli enti di ricerca, formulano proposte e pareri ai direttori generali o dipartimentali da cui dipendono, curano l’attuazione dei progetti loro affidati adottando e definendo, nei limiti di competenza, le modalità organizzative e le risorse necessarie alla loro realizzazione, esercitando i poteri di spesa loro attribuiti, coordinando le attività degli uffici loro subordinati, individuando i responsabili delle procedure affidate al proprio ufficio e verificando e controllando le attività complessive dell’ufficio rispetto agli obiettivi fissati. Sono responsabili della gestione e dei risultati raggiunti."
            },
            {
              "code" : "1.1.2.6.3",
              "display" : "Dirigenti ed equiparati nella sanità",
              "definition" : "Le professioni classificate in questa unità dirigono articolazioni funzionali del Servizio Sanitario Nazionale, formulano proposte e pareri ai direttori generali o dipartimentali da cui dipendono, curano l’attuazione dei progetti loro affidati adottando e definendo, nei limiti di competenza, le modalità organizzative e le risorse necessarie alla loro realizzazione, esercitando i poteri di spesa loro attribuiti, coordinando le attività degli uffici loro subordinati, individuando i responsabili delle procedure affidate al proprio ufficio e verificando e controllando le attività complessive dell’ufficio rispetto agli obiettivi fissati. Sono responsabili della gestione e dei risultati raggiunti."
            },
            {
              "code" : "1.1.3",
              "display" : "Dirigenti della magistratura",
              "definition" : "Le professioni comprese in questa classe dirigono e organizzano gli uffici giudiziari e le corti delle giurisdizioni speciali, ne coordinano le attività, distribuiscono il lavoro fra i giudici, vigilano sulla loro attività e su quelle dei servizi ausiliari, curano e garantiscono lo scambio di informazioni giurisprudenziali."
            },
            {
              "code" : "1.1.3.1",
              "display" : "Dirigenti della magistratura ordinaria (Preture, Tribunali, Corti di Appello, Corte di Cassazione)",
              "definition" : "Le professioni comprese in questa categoria presiedono, dirigono e organizzano gli uffici giudiziari e le sezioni del Tribunale Ordinario, ne coordinano le attività, distribuiscono il lavoro fra i giudici, vigilano sulla loro attività e su quelle dei servizi ausiliari, curano e garantiscono lo scambio di informazioni giurisprudenziali."
            },
            {
              "code" : "1.1.3.1.0",
              "display" : "Dirigenti della magistratura ordinaria",
              "definition" : "Le professioni classificate in questa unità presiedono, dirigono e organizzano gli uffici giudiziari e le sezioni del Tribunale Ordinario, ne coordinano le attività, distribuiscono il lavoro fra i giudici, vigilano sulla loro attività e su quelle dei servizi ausiliari, curano e garantiscono lo scambio di informazioni giurisprudenziali."
            },
            {
              "code" : "1.1.3.2",
              "display" : "Dirigenti della magistratura amministrativa e delle giurisdizioni speciali (Tribunali Amministrativi Regionali, Consiglio di Stato, Corte dei Conti e Corte costituzionale)",
              "definition" : "Le professioni comprese in questa categoria presiedono, dirigono e organizzano i rispettivi uffici giudiziari, le sezioni dei Tribunali Amministrativi Regionali, della Corte costituzionale, della Corte dei Conti e del Consiglio di Stato, ne coordinano le attività, distribuiscono il lavoro fra i giudici, vigilano sulla loro attività e su quelle dei servizi ausiliari, curano e garantiscono lo scambio di informazioni giurisprudenziali."
            },
            {
              "code" : "1.1.3.2.0",
              "display" : "Dirigenti della magistratura amministrativa e delle giurisdizioni speciali",
              "definition" : "Le professioni classificate in questa unità presiedono, dirigono e organizzano i rispettivi uffici giudiziari, le sezioni dei Tribunali Amministrativi Regionali, della Corte costituzionale, della Corte dei Conti e del Consiglio di Stato, ne coordinano le attività, distribuiscono il lavoro fra i giudici, vigilano sulla loro attività e su quelle dei servizi ausiliari, curano e garantiscono lo scambio di informazioni giurisprudenziali."
            },
            {
              "code" : "1.1.4",
              "display" : "Dirigenti di organizzazioni di interesse nazionale e sovranazionale",
              "definition" : "Le professioni comprese in questa classe definiscono, promuovono, attuano e dirigono le politiche e le strategie di organizzazioni rivolte alla rappresentanza di interessi collettivi quali i partiti politici e le organizzazioni sindacali ovvero di organizzazioni umanitarie, sportive, culturali e simili, rappresentandole e agendo per loro conto. In genere tali attività sono esercitate seguendo le direttive di un organo collegiale."
            },
            {
              "code" : "1.1.4.1",
              "display" : "Dirigenti di organizzazioni di interesse nazionale e sovranazionale per la rappresentanza di interessi collettivi (partiti e movimenti politici, sindacati delle imprese e dei lavoratori, associazioni per la tutela dell'ambiente e dei consumatori)",
              "definition" : "Le professioni comprese in questa categoria definiscono, promuovono, attuano e dirigono le politiche e le strategie di organizzazioni quali i partiti politici, le organizzazioni sindacali ovvero di altre associazioni che tutelano gli interessi economici dei cittadini, di categorie economiche o sociali; le rappresentano nei confronti di parti terze e agiscono per loro conto; organizzano campagne elettorali e di promozione delle finalità associative nonché il reclutamento e la formazione degli associati."
            },
            {
              "code" : "1.1.4.1.1",
              "display" : "Dirigenti di partiti e movimenti politici",
              "definition" : "Le professioni classificate in questa unità definiscono, promuovono, dirigono e attuano le politiche e le strategie dei partiti e movimenti politici; organizzano campagne elettorali e di propaganda."
            },
            {
              "code" : "1.1.4.1.2",
              "display" : "Dirigenti di sindacati e altre organizzazioni a tutela di interessi economici e sociali",
              "definition" : "Le professioni classificate in questa unità definiscono, promuovono, dirigono e attuano le politiche e le strategie delle organizzazioni sindacali ovvero di altre associazioni che tutelano gli interessi economici dei cittadini, di categorie economiche o sociali; rappresentano le suddette organizzazioni o associazioni nei confronti di parti terze e agiscono per loro conto; organizzano campagne di promozione delle finalità associative nonché il reclutamento e la formazione degli associati."
            },
            {
              "code" : "1.1.4.2",
              "display" : "Dirigenti di associazioni umanitarie, culturali, scientifiche e sportive di interesse nazionale o sovranazionale",
              "definition" : "Le professioni comprese in questa categoria definiscono, promuovono, dirigono e attuano le politiche e le strategie delle organizzazioni di cui fanno parte; le rappresentano nei confronti di parti terze e agiscono per loro conto; organizzano campagne di promozione delle finalità associative nonché il reclutamento e la formazione degli associati."
            },
            {
              "code" : "1.1.4.2.0",
              "display" : "Dirigenti di associazioni umanitarie, culturali, scientifiche e sportive di interesse nazionale o sovranazionale",
              "definition" : "Le professioni classificate in questa unità definiscono, promuovono, dirigono e attuano le politiche e le strategie delle organizzazioni di cui fanno parte; le rappresentano nei confronti di parti terze e agiscono per loro conto; organizzano campagne di promozione delle finalità associative nonché il reclutamento e la formazione degli associati."
            }
          ]
        },
        {
          "code" : "1.2",
          "display" : "Imprenditori, amministratori e direttori di grandi aziende",
          "definition" : "Le professioni classificate in questo gruppo pianificano, dirigono e coordinano unitariamente le attività di grandi imprese o delle strutture in cui queste sono organizzate; individuano e attuano strategie e politiche relative alla produzione e commercializzazione dei beni e dei servizi prodotti, tenendo in conto le caratteristiche del sistema competitivo, del posizionamento di mercato e delle risorse disponibili. Tali attività sono esercitate in ambienti organizzativi complessi che richiedono la presenza di un apparato gestionale al quale è affidato il compito di dirigere unitariamente l’impresa o l’organizzazione, anche a scopo non lucrativo. La presenza di tale apparato, che prevede almeno un livello intermedio di coordinamento (uno o più direttori, che coordinano strutture dirigenziali), costituisce il carattere distintivo delle professioni classificate in questo gruppo.",
          "concept" : [
            {
              "code" : "1.2.1",
              "display" : "Imprenditori e amministratori di grandi aziende",
              "definition" : "Le professioni comprese in questa classe guidano imprese o organizzazioni, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di una struttura che prevede almeno un livello intermedio di coordinamento (uno o più direttori, che coordinano strutture dirigenziali) ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.1",
              "display" : "Imprenditori e amministratori di grandi aziende che operano nell'agricoltura, nell'allevamento, nella silvicoltura, nella caccia e nella pesca",
              "definition" : "Le professioni classificate in questa categoria guidano imprese o organizzazioni che operano nei settori economici dell’agricoltura, silvicoltura e pesca, classificati sotto la Sezione A della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.1.0",
              "display" : "Imprenditori e amministratori di grandi aziende che operano nell'agricoltura, nell'allevamento, nella silvicoltura, nella caccia e nella pesca",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni che operano nel settore economico dell’agricoltura, silvicoltura e pesca, classificato sotto la Sezione A della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.2",
              "display" : "Imprenditori e amministratori di grandi aziende che operano nell'estrazione dei minerali, nella manifattura, nella produzione e distribuzione di energia elettrica, gas, acqua e nelle attività di gestione dei rifiuti",
              "definition" : "Le professioni classificate in questa categoria guidano imprese o organizzazioni che operano nei settori economici delle attività estrattive, manifatturiere, della fornitura di energia elettrica, gas, vapore e aria condizionata, della fornitura di acqua delle reti fognarie e delle attività di trattamento dei rifiuti e risanamento, classificati rispettivamente sotto le Sezioni B, C, D ed E della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.2.0",
              "display" : "Imprenditori e amministratori di grandi aziende che operano nell'estrazione dei minerali, nella manifattura, nella produzione e distribuzione di energia elettrica, gas e acqua e nella gestione dei rifiuti",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni che operano nei settori economici delle attività estrattive, manifatturiere, della fornitura di energia elettrica, gas, vapore e aria condizionata, della fornitura di acqua delle reti fognarie e delle attività di trattamento dei rifiuti e risanamento, classificati rispettivamente sotto le Sezioni B, C, D ed E della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.3",
              "display" : "Imprenditori e amministratori di grandi aziende di costruzioni",
              "definition" : "Le professioni classificate in questa categoria guidano imprese o organizzazioni che operano nel settore economico delle costruzioni, classificato sotto la Sezione F della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.3.0",
              "display" : "Imprenditori e amministratori di grandi aziende di costruzioni",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni che operano nel settore economico delle costruzioni, classificato sotto la Sezione F della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.4",
              "display" : "Imprenditori e amministratori di grandi aziende nel commercio",
              "definition" : "Le professioni classificate in questa categoria guidano imprese o organizzazioni che operano nei settori economici del commercio all’ingrosso e al dettaglio e della riparazione di autoveicoli e motocicli, classificati sotto la Sezione G della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.4.0",
              "display" : "Imprenditori e amministratori di grandi aziende nel commercio",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni che operano nel settore economico del commercio all’ingrosso e al dettaglio e della riparazione di autoveicoli e motocicli, classificato sotto la Sezione G della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.5",
              "display" : "Imprenditori e amministratori di grandi aziende nei servizi di alloggio e ristorazione",
              "definition" : "Le professioni classificate in questa categoria guidano imprese o organizzazioni che operano nel settore economico delle attività dei servizi di alloggio e ristorazione, classificato sotto la Sezione I della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.5.0",
              "display" : "Imprenditori e amministratori di grandi aziende nei servizi di alloggio e ristorazione",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni che operano nel settore economico dei servizi di alloggio e ristorazione, classificato sotto la Sezione I della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.6",
              "display" : "Imprenditori e amministratori di grandi aziende nel settore dei trasporti e magazzinaggio e nei servizi di informazione e comunicazione",
              "definition" : "Le professioni classificate in questa categoria guidano imprese o organizzazioni che operano nei settori economici del trasporto e magazzinaggio e dei servizi di informazione e comunicazione, classificati rispettivamente nelle Sezioni H e J della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.6.1",
              "display" : "Imprenditori e amministratori di grandi aziende nel settore dei trasporti e magazzinaggio",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni che operano nel settore economico dei trasporti e del magazzinaggio, classificato nella Sezione H della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.6.2",
              "display" : "Imprenditori e amministratori di grandi aziende nei servizi editoriali, di produzione cinematografica, radiofonica e televisiva",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni che operano nelle attività editoriali, di produzione cinematografica, di video e di programmi televisivi, di registrazioni musicali e sonore, e delle attività di programmazione e trasmissione, classificate rispettivamente nelle Divisioni 58, 59 e 60 della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.6.3",
              "display" : "Imprenditori e amministratori di grandi aziende nei servizi informatici e di telecomunicazione",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni che operano nelle telecomunicazioni, nella produzione di software, nella consulenza informatica e attività connesse e nelle attività dei servizi di informazione e altri servizi informatici, classificati rispettivamente nelle Divisioni 61, 62 e 63 della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.7",
              "display" : "Imprenditori e amministratori di grandi banche, assicurazioni, agenzie immobiliari e di intermediazione finanziaria",
              "definition" : "Le professioni classificate in questa categoria guidano imprese o organizzazioni che operano nei settori economici delle attività finanziarie, assicurative e immobiliari, classificati rispettivamente sotto le Sezioni K e L della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.7.0",
              "display" : "Imprenditori e amministratori di grandi banche, assicurazioni, agenzie immobiliari, di intermediazione finanziaria",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni che operano nei settori economici delle attività finanziarie, assicurative e immobiliari, classificati rispettivamente sotto le Sezioni K e L della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.8",
              "display" : "Imprenditori e amministratori di grandi aziende nei servizi alle imprese e alle persone",
              "definition" : "Le professioni classificate in questa categoria guidano imprese o organizzazioni che operano nei settori economici delle attività professionali, scientifiche e tecniche, delle attività amministrative e di servizi di supporto e delle altre attività di servizi, classificati rispettivamente sotto le Sezioni M, N e S della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.8.0",
              "display" : "Imprenditori e amministratori di grandi aziende nei servizi alle imprese e alle persone",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni che operano nei settori economici delle attività professionali, scientifiche e tecniche, delle attività amministrative e di servizi di supporto e delle altre attività di servizi, classificati rispettivamente sotto le Sezioni M, N e S della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.9",
              "display" : "Imprenditori e amministratori di grandi aziende private nei servizi di istruzione, sanità, assistenza sociale e nelle attività artistiche, sportive, di intrattenimento e divertimento",
              "definition" : "Le professioni classificate in questa categoria guidano imprese o organizzazioni private che operano nei settori economici dell’istruzione, della sanità e dell’assistenza sociale, delle attività artistiche, sportive, di intrattenimento e divertimento, classificati rispettivamente sotto le Sezioni P, Q e R della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.9.1",
              "display" : "Imprenditori e amministratori di grandi istituti scolastici, universitari e di ricerca privati",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni private che operano nel settore economico dell’istruzione, classificato sotto la Sezione P della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.9.2",
              "display" : "Imprenditori e amministratori di grandi ospedali, cliniche private o grandi aziende di assistenza sociale",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni private che operano nel settore economico della sanità e dell’assistenza sociale, classificato sotto la Sezione Q della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.1.9.3",
              "display" : "Imprenditori e amministratori di grandi aziende nel settore delle attività sportive, ricreative, di intrattenimento e di divertimento",
              "definition" : "Le professioni classificate in questa unità guidano imprese o organizzazioni che operano nel settore economico delle attività sportive, ricreative, di intrattenimento e di divertimento, classificato sotto la Sezione R della Classificazione delle attività economiche, direttamente come proprietari o per conto della proprietà, le rappresentano nei confronti di terze parti e, con il supporto di uno o più direttori che coordinano strutture dirigenziali, ne definiscono, pianificano, dirigono e coordinano le politiche, le strategie produttive e le attività, generalmente seguendo le direttive di un consiglio di amministrazione o di direzione a cui rispondono per le decisioni prese e i risultati ottenuti."
            },
            {
              "code" : "1.2.2",
              "display" : "Direttori e dirigenti generali di aziende",
              "definition" : "Le professioni comprese in questa classe programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti e in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata. L'autonomia decisionale in merito al bilancio, alla direzione strategica e operativa e all'assunzione o licenziamento costituisce il carattere distintivo delle professioni classificate in questa classe."
            },
            {
              "code" : "1.2.2.1",
              "display" : "Direttori e dirigenti generali di aziende che operano nell'agricoltura, nell'allevamento, nella silvicoltura, nella caccia e nella pesca",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nei settori economici dell’agricoltura, silvicoltura e pesca, classificati sotto la Sezione A della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati."
            },
            {
              "code" : "1.2.2.1.0",
              "display" : "Direttori e dirigenti generali di aziende che operano nell'agricoltura, nell'allevamento, nella silvicoltura, nella caccia e nella pesca",
              "definition" : "Le professioni classificate in questa unità, nell'ambito delle imprese o organizzazioni che operano nel settore economico dell’agricoltura, silvicoltura e pesca, classificato sotto la Sezione A della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti, in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata."
            },
            {
              "code" : "1.2.2.2",
              "display" : "Direttori e dirigenti generali di aziende che operano nell'estrazione dei minerali, nella manifattura, nella produzione e distribuzione di energia elettrica, gas, acqua e nelle attività di gestione dei rifiuti",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nei settori economici delle attività estrattive, manifatturiere, della fornitura di energia elettrica, gas, vapore e aria condizionata, della fornitura di acqua delle reti fognarie e delle attività di trattamento dei rifiuti e risanamento, classificati rispettivamente sotto le Sezioni B, C, D ed E della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati."
            },
            {
              "code" : "1.2.2.2.0",
              "display" : "Direttori e dirigenti generali di aziende che operano nella manifattura, nell'estrazione dei minerali, nella produzione e distribuzione di energia elettrica, gas, acqua e nelle attività di gestione dei rifiuti",
              "definition" : "Le professioni classificate in questa unità, nell'ambito delle imprese o organizzazioni che operano nei settori economici delle attività estrattive, manifatturiere, della fornitura di energia elettrica, gas, vapore e aria condizionata, della fornitura di acqua delle reti fognarie e delle attività di trattamento dei rifiuti e risanamento, classificati rispettivamente sotto le Sezioni B, C, D ed E della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti, in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata."
            },
            {
              "code" : "1.2.2.3",
              "display" : "Direttori e dirigenti generali di aziende nelle costruzioni",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nel settore economico delle costruzioni, classificato sotto la Sezione F della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati."
            },
            {
              "code" : "1.2.2.3.0",
              "display" : "Direttori e dirigenti generali di aziende nelle costruzioni",
              "definition" : "Le professioni classificate in questa unità, nell'ambito delle imprese o organizzazioni che operano nel settore economico delle costruzioni, classificato sotto la Sezione F della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti, in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata."
            },
            {
              "code" : "1.2.2.4",
              "display" : "Direttori e dirigenti generali di aziende nel commercio",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nei settori economici del commercio all’ingrosso e al dettaglio e della riparazione di autoveicoli e motocicli, classificati sotto la Sezione G della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati."
            },
            {
              "code" : "1.2.2.4.0",
              "display" : "Direttori e dirigenti generali di aziende nel commercio",
              "definition" : "Le professioni classificate in questa unità, nell'ambito delle imprese o organizzazioni che operano nel settore economico del commercio all’ingrosso e al dettaglio e della riparazione di autoveicoli e motocicli, classificato sotto la Sezione G della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti, in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata."
            },
            {
              "code" : "1.2.2.5",
              "display" : "Direttori e dirigenti generali di aziende nel settore dei servizi di alloggio e ristorazione",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nel settore economico delle attività dei servizi di alloggio e ristorazione, classificato sotto la Sezione I della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati."
            },
            {
              "code" : "1.2.2.5.0",
              "display" : "Direttori e dirigenti generali di aziende nel settore dei servizi di alloggio e ristorazione",
              "definition" : "Le professioni classificate in questa unità, nell'ambito delle imprese o organizzazioni che operano nel settore economico dei servizi di alloggio e ristorazione, classificato sotto la Sezione I della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti, in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata."
            },
            {
              "code" : "1.2.2.6",
              "display" : "Direttori e dirigenti generali di aziende nel settore dei trasporti e magazzinaggio e nei servizi di informazione e comunicazione",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nei settori economici del trasporto e magazzinaggio e dei servizi di informazione e comunicazione, classificati rispettivamente nelle Sezioni H e J della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati."
            },
            {
              "code" : "1.2.2.6.1",
              "display" : "Direttori e dirigenti generali di aziende nel settore dei trasporti e magazzinaggio",
              "definition" : "Le professioni classificate in questa unità, nell'ambito delle imprese o organizzazioni che operano nel settore economico dei trasporti e del magazzinaggio, classificato sotto la Sezione H della Classificazione delle attività economiche programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti, in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata."
            },
            {
              "code" : "1.2.2.6.2",
              "display" : "Direttori e dirigenti generali di aziende nei servizi editoriali, di produzione cinematografica, radiofonica e televisiva",
              "definition" : "Le professioni classificate in questa unità, nell'ambito delle imprese o organizzazioni che operano nelle attività editoriali, di produzione cinematografica, di video e di programmi televisivi, di registrazioni musicali e sonore, e delle attività di programmazione e trasmissione, classificate rispettivamente nelle Divisioni 58, 59 e 60 della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti, in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata."
            },
            {
              "code" : "1.2.2.6.3",
              "display" : "Direttori e dirigenti generali di aziende nei servizi informatici e di telecomunicazione",
              "definition" : "Le professioni classificate in questa unità, nell'ambito delle imprese o organizzazioni che operano nelle telecomunicazioni, nella produzione di software, nella consulenza informatica e attività connesse e nelle attività dei servizi di informazione e altri servizi informatici, classificate rispettivamente nelle Divisioni 61, 62 e 63 della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti, in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata."
            },
            {
              "code" : "1.2.2.7",
              "display" : "Direttori e dirigenti generali di banche, assicurazioni, agenzie immobiliari e di intermediazione finanziaria",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nei settori economici delle attività finanziarie, assicurative e immobiliari, classificati rispettivamente sotto le Sezioni K e L della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati."
            },
            {
              "code" : "1.2.2.7.0",
              "display" : "Direttori e dirigenti generali di banche, assicurazioni, agenzie immobiliari e di intermediazione finanziaria",
              "definition" : "Le professioni classificate in questa unità, nell'ambito delle imprese o organizzazioni che operano nel settore economico delle attività finanziarie, assicurative e immobiliari, classificato sotto le Sezioni K e L della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti, in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata."
            },
            {
              "code" : "1.2.2.8",
              "display" : "Direttori e dirigenti generali di aziende di servizi alle imprese e alle persone",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nei settori economici delle attività professionali, scientifiche e tecniche, delle attività amministrative e di servizi di supporto e delle altre attività di servizi, classificati rispettivamente sotto le Sezioni M, N e S della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati."
            },
            {
              "code" : "1.2.2.8.0",
              "display" : "Direttori e dirigenti generali di aziende di servizi alle imprese e alle persone",
              "definition" : "Le professioni classificate in questa unità, nell'ambito delle imprese o organizzazioni che operano nei settori economici delle attività professionali, scientifiche e tecniche, delle attività amministrative e di servizi di supporto e delle altre attività di servizi, classificati rispettivamente sotto le Sezioni M, N e S della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti, in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata."
            },
            {
              "code" : "1.2.2.9",
              "display" : "Direttori e dirigenti generali di aziende nel settore delle attività artistiche, sportive, di intrattenimento e di divertimento",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nel settore economico delle attività artistiche, di intrattenimento e di divertimento classificati sotto la Sezione R della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati."
            },
            {
              "code" : "1.2.2.9.0",
              "display" : "Direttori e dirigenti generali di aziende nel settore delle attività sportive, ricreative, di intrattenimento e divertimento",
              "definition" : "Le professioni classificate in questa unità, nell'ambito delle imprese o organizzazioni che operano nel settore economico delle attività artistiche, sportive, di intrattenimento e di divertimento classificati sotto la Sezione R della Classificazione delle attività economiche, programmano, dirigono e coordinano le attività inerenti la produzione di beni e di servizi dell’impresa o dell’organizzazione in cui operano e assicurano l’utilizzazione efficiente delle risorse a disposizione e il raggiungimento degli obiettivi produttivi prefissati. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione a cui rispondono per le decisioni prese e i risultati ottenuti, in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata."
            },
            {
              "code" : "1.2.3",
              "display" : "Direttori e dirigenti dipartimentali di aziende",
              "definition" : "Le professioni comprese in questa classe programmano, dirigono e coordinano le attività di dipartimenti e settori gestionali diversi da quelli direttamente coinvolti nella produzione dei beni e dei servizi prodotti dalle imprese o dalle organizzazioni in cui operano. Generalmente tali attività vengono esercitate in ottemperanza delle direttive degli organi decisionali dell’impresa o dell’organizzazione, a cui rispondono per le decisioni prese e i risultati ottenuti, e in collaborazione con le altre direzioni in cui l’impresa o l’organizzazione è strutturata. L'autonomia decisionale in merito al bilancio, alla direzione strategia e operativa e all'assunzione o licenziamento costituisce il carattere distintivo delle professioni classificate in questa classe."
            },
            {
              "code" : "1.2.3.1",
              "display" : "Direttori e dirigenti del dipartimento finanza ed amministrazione",
              "definition" : "Le professioni classificate in questa categoria programmano, dirigono e coordinano l’amministrazione interna e/o le operazioni finanziarie, definiscono le procedure amministrative, verificano e controllano la spesa e l’uso adeguato delle risorse."
            },
            {
              "code" : "1.2.3.1.0",
              "display" : "Direttori e dirigenti del dipartimento finanza ed amministrazione",
              "definition" : "Le professioni classificate in questa unità programmano, dirigono e coordinano l’amministrazione interna e/o le operazioni finanziarie, definiscono le procedure amministrative, verificano e controllano la spesa e l’uso adeguato delle risorse."
            },
            {
              "code" : "1.2.3.2",
              "display" : "Direttori e dirigenti del dipartimento organizzazione, gestione delle risorse umane e delle relazioni industriali",
              "definition" : "Le professioni classificate in questa categoria definiscono, dirigono e coordinano le politiche relative al personale e alle relazioni sindacali ovvero i programmi di reclutamento e di formazione del personale, la struttura salariale, i percorsi di carriera; sovrintendono all’applicazione dei criteri di sicurezza e di salvaguardia della salute dei lavoratori."
            },
            {
              "code" : "1.2.3.2.0",
              "display" : "Direttori e dirigenti del dipartimento organizzazione, gestione delle risorse umane e delle relazioni industriali",
              "definition" : "Le professioni classificate in questa unità definiscono, dirigono e coordinano le politiche relative al personale e alle relazioni sindacali, i programmi di reclutamento e di formazione del personale, la struttura salariale, i percorsi di carriera; sovrintendono all’applicazione dei criteri di sicurezza e di salvaguardia della salute dei lavoratori."
            },
            {
              "code" : "1.2.3.3",
              "display" : "Direttori e dirigenti del dipartimento vendite e commercializzazione",
              "definition" : "Le professioni classificate in questa categoria definiscono, dirigono e coordinano le strategie di vendita, di commercializzazione e di distribuzione dei beni o dei servizi prodotti; ne definiscono i prezzi di mercato, gli sconti, le promozioni e gli incentivi da applicare."
            },
            {
              "code" : "1.2.3.3.0",
              "display" : "Direttori e dirigenti del dipartimento vendite e commercializzazione",
              "definition" : "Le professioni classificate in questa unità definiscono, dirigono e coordinano le strategie di vendita, di commercializzazione e di distribuzione dei beni o dei servizi prodotti; ne definiscono i prezzi di mercato, gli sconti, le promozioni e gli incentivi da applicare."
            },
            {
              "code" : "1.2.3.4",
              "display" : "Direttori e dirigenti del dipartimento comunicazione, pubblicità e pubbliche relazioni",
              "definition" : "Le professioni classificate in questa categoria definiscono, dirigono e coordinano le strategie di comunicazione e pubblicitarie, ne negoziano i costi di diffusione, curano l’immagine dell’impresa presso cui operano definendo e gestendo programmi di informazione diretti al pubblico o a particolari corpi sociali, di sostegno ad attività benefiche, culturali, sportive e ad organizzazioni umanitarie."
            },
            {
              "code" : "1.2.3.4.0",
              "display" : "Direttori e dirigenti del dipartimento comunicazione, pubblicità e pubbliche relazioni",
              "definition" : "Le professioni classificate in questa unità definiscono, dirigono e coordinano le strategie di comunicazione e pubblicitarie, ne negoziano i costi di diffusione, curano l’immagine dell’impresa presso cui operano definendo e gestendo programmi di informazione diretti al pubblico o a particolari corpi sociali, programmi di sostegno ad attività benefiche, culturali, sportive e ad organizzazioni umanitarie."
            },
            {
              "code" : "1.2.3.5",
              "display" : "Direttori e dirigenti del dipartimento approvvigionamento e distribuzione",
              "definition" : "Le professioni classificate in questa categoria pianificano, dirigono e coordinano gli approvvigionamenti, il magazzino scorte e la logistica interna dei materiali e delle attrezzature necessarie al funzionamento dell’impresa in cui operano; individuano i sistemi di inventario e di controllo dei consumi; definiscono le procedure e negoziano gli acquisti con i fornitori, assicurandone la qualità."
            },
            {
              "code" : "1.2.3.5.0",
              "display" : "Direttori e dirigenti del dipartimento approvvigionamento e distribuzione",
              "definition" : "Le professioni classificate in questa unità pianificano, dirigono e coordinano gli approvvigionamenti, il magazzino scorte e la logistica interna dei materiali e delle attrezzature necessarie al funzionamento dell’impresa in cui operano; individuano i sistemi di inventario e di controllo dei consumi; definiscono le procedure e negoziano gli acquisti con i fornitori, assicurandone la qualità."
            },
            {
              "code" : "1.2.3.6",
              "display" : "Direttori e dirigenti del dipartimento servizi informatici",
              "definition" : "Le professioni classificate in questa categoria sovrintendono al corretto funzionamento dei sistemi e dei servizi informatici; ne pianificano, dirigono e coordinano l’acquisto, l’installazione, l’aggiornamento e la manutenzione; definiscono le priorità e i modi dell’informatizzazione delle procedure e delle attività dell'impresa, sovrintendono al rispetto delle norme sul trattamento delle informazioni in materia di sicurezza e di tutela dei dati personali."
            },
            {
              "code" : "1.2.3.6.0",
              "display" : "Direttori e dirigenti del dipartimento servizi informatici",
              "definition" : "Le professioni classificate in questa unità sovrintendono al corretto funzionamento dei sistemi e dei servizi informatici; ne pianificano, dirigono e coordinano l’acquisto, l’installazione, l’aggiornamento e la manutenzione; definiscono le priorità e i modi dell’informatizzazione delle procedure e delle attività dell'impresa, sovrintendono al rispetto delle norme sul trattamento delle informazioni in materia di sicurezza e di tutela dei dati personali."
            },
            {
              "code" : "1.2.3.7",
              "display" : "Direttori e dirigenti del dipartimento ricerca e sviluppo",
              "definition" : "Le professioni classificate in questa categoria pianificano, dirigono e coordinano, per l’impresa o su commessa esterna, attività di ricerca finalizzate a migliorare e sviluppare i processi tecnici di produzione, i beni o i servizi prodotti, i materiali necessari a produrli e il loro uso, i modi e le tecnologie di distribuzione, sovrintendendo al deposito dei brevetti."
            },
            {
              "code" : "1.2.3.7.0",
              "display" : "Direttori e dirigenti del dipartimento ricerca e sviluppo",
              "definition" : "Le professioni classificate in questa unità pianificano, dirigono e coordinano, per l’impresa o su commessa esterna, attività di ricerca finalizzate a migliorare e sviluppare i processi tecnici di produzione, i beni o i servizi prodotti, i materiali necessari a produrli e il loro uso, i modi e le tecnologie di distribuzione, sovrintendendo al deposito dei brevetti."
            },
            {
              "code" : "1.2.3.9",
              "display" : "Altri direttori e dirigenti di dipartimento non altrove classificati",
              "definition" : "Le professioni classificate in questa categoria pianificano, dirigono e coordinano attività di informazione, di servizio e di supporto agli organi decisionali diversamente strutturate e non ricomprese in quelle descritte dalle categorie precedenti."
            },
            {
              "code" : "1.2.3.9.0",
              "display" : "Altri direttori e dirigenti di dipartimento",
              "definition" : "Le professioni classificate in questa unità pianificano, dirigono e coordinano attività di informazione, di servizio e di supporto agli organi decisionali diversamente strutturate e non ricomprese nei settori della finanza e amministrazione, del personale e relazioni sindacali, delle vendite e commercializzazione, della pubblicità e pubbliche relazioni, dell'approvvigionamento, logistica e distribuzione, dei sistemi e servizi informatici, della ricerca e sviluppo."
            }
          ]
        },
        {
          "code" : "1.3",
          "display" : "Imprenditori e responsabili di piccole aziende",
          "definition" : "Le professioni classificate in questo gruppo pianificano, dirigono e coordinano le attività di piccole imprese; individuano e attuano strategie e politiche relative alla produzione e commercializzazione dei beni o dei servizi prodotti. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore o responsabile nella sua attività. L’assenza di tale apparato costituisce il carattere distintivo delle professioni classificate in questo gruppo. Possono essere saltuariamente impegnati nel processo di produzione di beni o di fornitura di servizi.",
          "concept" : [
            {
              "code" : "1.3.1",
              "display" : "Imprenditori e responsabili di piccole aziende",
              "definition" : "Le professioni comprese in questa classe sono a capo di piccole imprese di cui definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore o del responsabile nella sua attività. Le professioni comprese in questa classe possono essere saltuariamente impegnate nel processo di produzione di beni o di fornitura di servizi."
            },
            {
              "code" : "1.3.1.1",
              "display" : "Imprenditori e responsabili di piccole aziende che operano nell'agricoltura, nell'allevamento, nella silvicoltura, nella caccia e nella pesca",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nei settori economici dell’agricoltura, silvicoltura e pesca, classificati sotto la Sezione A della Classificazione delle attività economiche, definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa categoria possono essere saltuariamente impegnate nel processo materiale di produzione."
            },
            {
              "code" : "1.3.1.1.0",
              "display" : "Imprenditori e responsabili di piccole aziende che operano nell'agricoltura, nell'allevamento, nella silvicoltura, nella caccia e nella pesca",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nel settore economico dell’agricoltura, silvicoltura e pesca classificato sotto la Sezione A della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo materiale di produzione."
            },
            {
              "code" : "1.3.1.2",
              "display" : "Imprenditori e responsabili di piccole aziende che operano nell'estrazione di minerali, nella manifattura, nella produzione e distribuzione di energia elettrica, gas e acqua e nelle attività di gestione dei rifiuti",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nei settori economici delle attività estrattive, manifatturiere, della fornitura di energia elettrica, gas, vapore e aria condizionata, della fornitura di acqua delle reti fognarie e delle attività di trattamento dei rifiuti e risanamento, classificati rispettivamente sotto le Sezioni B, C, D ed E della Classificazione delle attività economiche, definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa categoria possono essere saltuariamente impegnate nel processo materiale di produzione."
            },
            {
              "code" : "1.3.1.2.0",
              "display" : "Imprenditori e responsabili di piccole aziende che operano nell'estrazione di minerali, nella manifattura, nella produzione e distribuzione di energia elettrica, gas e acqua e nelle attività di gestione dei rifiuti",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nei settori economici delle attività estrattive, manifatturiere, della fornitura di energia elettrica, gas, vapore e aria condizionata, della fornitura di acqua delle reti fognarie e delle attività di trattamento dei rifiuti e risanamento, classificati rispettivamente sotto le Sezioni B, C, D ed E della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo materiale di produzione."
            },
            {
              "code" : "1.3.1.3",
              "display" : "Imprenditori e responsabili di piccole aziende nelle costruzioni",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nel settore economico delle costruzioni, classificato sotto la Sezione F della Classificazione delle attività economiche, definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa categoria possono essere saltuariamente impegnate nel processo materiale di produzione."
            },
            {
              "code" : "1.3.1.3.0",
              "display" : "Imprenditori e responsabili di piccole aziende nelle costruzioni",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nel settore economico delle costruzioni, classificato sotto la Sezione F della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo materiale di produzione."
            },
            {
              "code" : "1.3.1.4",
              "display" : "Imprenditori e responsabili di piccole aziende nel commercio",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni private che operano nei settori economici del commercio all’ingrosso e al dettaglio e della riparazione di autoveicoli e motocicli, classificati sotto la Sezione G della Classificazione delle attività economiche, definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa categoria possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.4.0",
              "display" : "Imprenditori e responsabili di piccole aziende nel commercio",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nel settore economico del commercio all’ingrosso e al dettaglio e della riparazione di autoveicoli e motocicli, classificato sotto la Sezione G della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.5",
              "display" : "Imprenditori e responsabili di piccole aziende nei servizi di alloggio e ristorazione",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nel settore economico delle attività dei servizi di alloggio e ristorazione, classificato sotto la Sezione I della Classificazione delle attività economiche, definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa categoria possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.5.0",
              "display" : "Imprenditori e responsabili di piccoli alberghi, alloggi o aree di campeggio e di piccoli esercizi di ristorazione",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nel settore economico dei servizi di alloggio e ristorazione, classificato sotto la Sezione I della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.6",
              "display" : "Imprenditori e responsabili di piccole aziende nei trasporti, magazzinaggio e nei servizi di informazione e comunicazione",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nei settori economici del trasporto e magazzinaggio e dei servizi di informazione e comunicazione, classificati rispettivamente nelle Sezioni H e J della Classificazione delle attività economiche, definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa categoria possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.6.1",
              "display" : "Imprenditori e responsabili di piccole aziende nei trasporti e magazzinaggio",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nel settore economico dei trasporti e del magazzinaggio, classificato sotto la Sezione H della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.6.2",
              "display" : "Imprenditori e responsabili di piccole aziende nei servizi editoriali, di produzione cinematografica, radiofonica e televisiva",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nelle attività editoriali, di produzione cinematografica, di video e di programmi televisivi, di registrazioni musicali e sonore, e delle attività di programmazione e trasmissione, classificate rispettivamente nelle Divisioni 58, 59 e 60 della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.6.3",
              "display" : "Imprenditori e responsabili di piccole aziende nei servizi informatici e di telecomunicazione",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano e gestiscono le politiche e le strategie di produzione e valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nelle telecomunicazioni, nella produzione di software, nella consulenza informatica e attività connesse e nelle attività dei servizi di informazione e altri servizi informatici, classificate rispettivamente nelle Divisioni 61, 62 e 63 della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.7",
              "display" : "Imprenditori e responsabili di piccoli istituti di credito e di intermediazione finanziaria, assicurativa e immobiliare",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nei settori economici delle attività finanziarie, assicurative e immobiliari, classificati rispettivamente sotto le Sezioni K e L della Classificazione delle attività economiche, definiscono, pianificano, implementano, gestiscono le politiche e le strategie e valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa categoria possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.7.0",
              "display" : "Imprenditori e responsabili di piccoli istituti di credito e di intermediazione finanziaria, assicurativa e immobiliare",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano, gestiscono le politiche e le strategie e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nei settori economici delle attività finanziarie, assicurative e immobiliari, classificati sotto le Sezioni K e L della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.8",
              "display" : "Imprenditori e responsabili di piccole aziende nei servizi alle imprese e alle persone",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni che operano nei settori economici delle attività professionali, scientifiche e tecniche, delle attività amministrative e di servizi di supporto e delle altre attività di servizi, classificati rispettivamente sotto le Sezioni M, N e S della Classificazione delle attività economiche, definiscono, pianificano, implementano, gestiscono le politiche e le strategie e valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa categoria possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.8.0",
              "display" : "Imprenditori e responsabili di piccole aziende nei servizi alle imprese e alle persone",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano, gestiscono le politiche e le strategie e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nei settori economici delle attività professionali, scientifiche e tecniche, delle attività amministrative e di servizi di supporto e delle altre attività di servizi, classificati rispettivamente sotto le Sezioni M, N e S della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.9",
              "display" : "Imprenditori e responsabili di piccole aziende nei servizi di istruzione, formazione, ricerca, sanità, assistenza sociale e nelle attività artistiche, sportive, di intrattenimento e divertimento",
              "definition" : "Le professioni classificate in questa categoria, nell'ambito delle imprese o organizzazioni private che operano nei settori economici dell’istruzione, della sanità e dell’assistenza sociale, delle attività artistiche, sportive, di intrattenimento e divertimento, classificati sotto le Sezioni P, Q e R della Classificazione delle attività economiche, definiscono, pianificano, implementano, gestiscono le politiche e le strategie e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa categoria possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.9.1",
              "display" : "Imprenditori e responsabili di piccole aziende nei servizi di istruzione, formazione e ricerca",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano, gestiscono le politiche e le strategie e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nel settore economico dell’istruzione, classificato sotto la Sezione P della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Possono essere saltuariamente impegnati nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.9.2",
              "display" : "Imprenditori e responsabili di piccole aziende nei servizi di sanità e assistenza sociale",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano, gestiscono le politiche e le strategie e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nel settore economico della sanità e dell’assistenza sociale, classificato sotto la Sezione Q della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            },
            {
              "code" : "1.3.1.9.3",
              "display" : "Imprenditori e responsabili di piccole aziende nel settore delle attività sportive, ricreative, di intrattenimento e divertimento",
              "definition" : "Le professioni classificate in questa unità sono a capo di piccole imprese di cui definiscono, pianificano, implementano, gestiscono le politiche e le strategie e ne valutano i risultati; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e produttiva. Le professioni classificate in questa unità esercitano le attività descritte in imprese o organizzazioni che operano nel settore economico delle attività sportive, ricreative, di intrattenimento e di divertimento, classificato sotto la Sezione R della Classificazione delle attività economiche. Tali attività sono esercitate in imprese che dispongono di un apparato organizzativo semplice, che non prevede livelli intermedi di coordinamento (nessun direttore che coordina strutture dirigenziali) a supporto dell’imprenditore nella sua attività. Le professioni comprese in questa unità possono essere saltuariamente impegnate nel processo di fornitura dei servizi."
            }
          ]
        }
      ]
    },
    {
      "code" : "2",
      "display" : "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE",
      "definition" : "Il secondo grande gruppo comprende le professioni che richiedono un elevato livello di conoscenza teorica per analizzare e rappresentare, in ambiti disciplinari specifici, situazioni e problemi complessi, definire le possibili soluzioni e assumere le relative decisioni. I loro compiti consistono nell’arricchire le conoscenze esistenti, promuovendo e conducendo la ricerca scientifica; nell'applicare le conoscenze e i metodi per la prevenzione, la diagnosi e la cura delle malattie e delle disfunzioni; nell’interpretare criticamente e sviluppare concetti, teorie scientifiche e norme; nell’insegnarli e trasmetterli in modo sistematico; nell’applicarli alla soluzione di problemi concreti; nell’eseguire performance artistiche. Il livello di conoscenza richiesta dalle professioni comprese in questo grande gruppo è acquisito attraverso il completamento di percorsi di istruzione universitaria di II livello o post-universitaria o percorsi di apprendimento, anche non formale, di pari complessità.",
      "concept" : [
        {
          "code" : "2.1",
          "display" : "Specialisti in scienze matematiche, informatiche, chimiche, fisiche e naturali",
          "definition" : "Le professioni classificate in questo gruppo approfondiscono e perfezionano concetti, teorie e metodi di indagine in ambito matematico, fisico, chimico, informatico, geologico e meteorologico, ovvero applicano la conoscenza scientifica acquisita in tali ambiti scientifici nei processi di produzione di beni o di servizi."
        },
        {
          "code" : "2.1.1",
          "display" : "Specialisti in scienze matematiche, informatiche, chimiche, fisiche e naturali",
          "definition" : "Le professioni comprese in questa classe contribuiscono ad ampliare la conoscenza scientifica conducendo ricerche e sperimentazioni nei campi della fisica meccanica e della materia, della termodinamica, dell’ottica, dell’acustica, dell’elettricità e dell’elettronica, del magnetismo, della fisica nucleare e delle particelle; della matematica e delle sue applicazioni; nei diversi settori della chimica; dell’astronomia; della meteorologia; della geologia e della geofisica, nonché nei campi delle scienze dell'informazione e della telematica. Applicano e rendono disponibili tali conoscenze per la produzione di beni e servizi, la ricerca scientifica, la navigazione e l’esplorazione dello spazio, le telecomunicazioni."
        },
        {
          "code" : "2.1.1.1",
          "display" : "Fisici e astronomi",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche sui fenomeni fisici e astronomici, individuano e applicano metodi di indagine, formulano teorie e leggi sulla base di osservazioni e di esperimenti, incrementano la conoscenza scientifica in materia, utilizzano tale conoscenza per la soluzione di problemi pratici e la trasferiscono nell’industria, nel settore della ricerca scientifica ovvero in altri settori della produzione di beni e servizi."
        },
        {
          "code" : "2.1.1.1.1",
          "display" : "Fisici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche sui fenomeni fisici, individuano e applicano metodi di indagine, formulano teorie e leggi sulla base di osservazioni e di esperimenti, incrementano la conoscenza scientifica in materia, utilizzano tale conoscenza per la soluzione di problemi pratici e la trasferiscono nell’industria, nel settore della ricerca scientifica e della produzione di beni e servizi."
        },
        {
          "code" : "2.1.1.1.2",
          "display" : "Astronomi ed astrofisici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche sui fenomeni astronomici, individuano e applicano metodi di indagine, formulano teorie e leggi sulla base di osservazioni e di esperimenti, incrementano la conoscenza scientifica in materia."
        },
        {
          "code" : "2.1.1.2",
          "display" : "Chimici e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche, test, esperimenti ed analisi qualitative e quantitative su sostanze naturali o di sintesi, ne individuano la composizione e le variazioni chimiche ed energetiche, individuano ed applicano metodi di indagine, formulano teorie e leggi sulla base delle osservazioni; migliorano le sostanze e ne sintetizzano di nuove; incrementano la conoscenza scientifica in materia, utilizzano e trasferiscono tale conoscenza nell’industria, nella medicina, nella farmacologia, ovvero in altri settori della produzione."
        },
        {
          "code" : "2.1.1.2.1",
          "display" : "Chimici e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità conducono ricerche, test, esperimenti ed analisi qualitative e quantitative su sostanze naturali o di sintesi, ne individuano la composizione e le variazioni chimiche ed energetiche, individuano ed applicano metodi di indagine, formulano teorie e leggi sulla base delle osservazioni; migliorano le sostanze e ne sintetizzano di nuove. L’esercizio della professione di Chimico è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.1.1.2.2",
          "display" : "Chimici informatori e divulgatori",
          "definition" : "Le professioni comprese in questa unità incrementano la conoscenza scientifica in materia, utilizzano e trasferiscono tale conoscenza nell’industria, nella medicina, nella farmacologia e in altri settori della produzione. L’esercizio della professione di Informatore scientifico del farmaco è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.1.1.3",
          "display" : "Matematici, statistici e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche su concetti e teorie fondamentali della matematica, della scienza attuariale e della statistica, incrementano la conoscenza scientifica in materia, applicano le relative teorie e tecniche per raccogliere, analizzare e sintetizzare informazioni, per definire modelli di interpretazione dei dati, per individuare soluzioni matematiche e statistiche da adottare nei vari settori della produzione di beni e servizi e della stessa ricerca scientifica."
        },
        {
          "code" : "2.1.1.3.1",
          "display" : "Matematici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali della matematica, incrementano la conoscenza scientifica in materia, applicano le relative teorie e tecniche per individuare soluzioni matematiche da adottare nei vari settori della produzione di beni e servizi e della stessa ricerca scientifica."
        },
        {
          "code" : "2.1.1.3.2",
          "display" : "Statistici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali della scienza attuariale e della statistica, incrementano la conoscenza scientifica in materia, applicano le relative teorie e tecniche per raccogliere, analizzare e sintetizzare informazioni, per definire modelli di interpretazione dei dati, per individuare soluzioni statistiche da adottare nei vari settori della produzione di beni e servizi e della stessa ricerca scientifica. L’esercizio della professione di Attuario è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.1.1.4",
          "display" : "Analisti e progettisti di software",
          "definition" : "Le professioni classificate in questa categoria incrementano la conoscenza scientifica nelle scienze dell'informazione e della telematica. Sviluppano, creano, modificano o ottimizzano software applicativi analizzando le esigenze degli utilizzatori; analizzano i problemi di elaborazione dei dati per diverse esigenze di calcolo e disegnano, individuano o ottimizzano appropriati sistemi di calcolo delle informazioni; si occupano dell’ideazione, della realizzazione, dell’integrazione e della verifica dei software impiegati in un sito o in un’applicazione web."
        },
        {
          "code" : "2.1.1.4.1",
          "display" : "Analisti e progettisti di software",
          "definition" : "Le professioni comprese in questa unità sviluppano, creano, modificano o ottimizzano software applicativi analizzando le esigenze degli utilizzatori; progettano, sviluppano e testano software di sistema, di rete, linguaggi e compilatori per diverse aree ed esigenze applicative."
        },
        {
          "code" : "2.1.1.4.2",
          "display" : "Analisti di sistema",
          "definition" : "Le professioni comprese in questa unità analizzano i problemi di elaborazione dei dati per diverse esigenze di calcolo e disegnano, individuano o ottimizzano appropriati sistemi di calcolo e di gestione delle informazioni."
        },
        {
          "code" : "2.1.1.4.3",
          "display" : "Analisti e progettisti di applicazioni web",
          "definition" : "Le professioni comprese in questa unità si occupano dell’ideazione, della realizzazione, dell’integrazione e della verifica dei software impiegati in un sito o in un’applicazione web. Progettano dal punto di vista funzionale siti e applicazioni web, scelgono le tecnologie più adatte in termini di costi, efficienza e affidabilità; programmano le funzionalità necessarie; eseguono test e simulazioni per valutare l'accessibilità, l'usabilità, la robustezza e la sicurezza delle soluzioni realizzate."
        },
        {
          "code" : "2.1.1.5",
          "display" : "Progettisti e amministratori di sistemi",
          "definition" : "Le professioni classificate in questa categoria incrementano la conoscenza scientifica nelle scienze dell'informazione e della telematica, individuano o ottimizzano appropriati sistemi di gestione delle informazioni; disegnano, coordinano ed implementano le misure di sicurezza dei sistemi informativi per regolare gli accessi ai dati e prevenire accessi non autorizzati; analizzano, progettano, testano, valutano e ottimizzano le prestazioni dei sistemi di rete e di telecomunicazione."
        },
        {
          "code" : "2.1.1.5.1",
          "display" : "Specialisti in reti e comunicazioni informatiche",
          "definition" : "Le professioni comprese in questa unità analizzano, progettano, testano, valutano e ottimizzano le prestazioni dei sistemi di rete e di telecomunicazione."
        },
        {
          "code" : "2.1.1.5.2",
          "display" : "Analisti e progettisti di basi dati",
          "definition" : "Le professioni comprese in questa unità analizzano, progettano, sviluppano e collaudano i sistemi di gestione di banche dati, garantendone e controllandone le prestazioni ottimali e la sicurezza. Definiscono e predispongono i sistemi di backup e le procedure per preservare la sicurezza e l'integrità dei dati."
        },
        {
          "code" : "2.1.1.5.3",
          "display" : "Amministratori di sistemi",
          "definition" : "Le professioni comprese in questa unità analizzano, progettano, sviluppano sistemi informatici, controllandone e garantendone le prestazioni ottimali e la sicurezza. Definiscono le modalità di configurazione, di mantenimento e di gestione di reti di computer, dei relativi ambienti di elaborazione e delle operazioni di disaster recovery; predispongono le procedure di monitoraggio delle prestazioni dei sistemi informatici e delle reti."
        },
        {
          "code" : "2.1.1.5.4",
          "display" : "Specialisti in sicurezza informatica",
          "definition" : "Le professioni comprese in questa unità disegnano, coordinano ed implementano le misure di sicurezza dei sistemi informativi per regolare gli accessi ai dati e prevenire accessi non autorizzati."
        },
        {
          "code" : "2.1.1.6",
          "display" : "Geologi, meteorologi, geofisici e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche su concetti e teorie fondamentali e incrementano la conoscenza scientifica sugli aspetti fisici della crosta e dell’atmosfera terrestre. Studiano le rocce, i minerali, i fossili, la composizione, la struttura e la storia della crosta terrestre; applicano conoscenze di chimica, fisica, biologia e matematica per spiegarne fenomeni e attività, contribuire ad individuare giacimenti di minerali, di gas, di petrolio e sorgenti sotterranee d’acqua. Studiano i movimenti tellurici, la distribuzione, la circolazione e le proprietà fisiche delle acque sotterranee e di superficie, la forma e l’intensità delle precipitazioni, il tasso di infiltrazione nel suolo, i loro movimenti attraverso la terra e il loro ritorno ai mari e nell’atmosfera; studiano i fenomeni atmosferici, elaborano ed interpretano dati per prevederli. Applicano tali conoscenze ai problemi di ingegneria civile."
        },
        {
          "code" : "2.1.1.6.1",
          "display" : "Geologi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali e incrementano la conoscenza scientifica sugli aspetti fisici della crosta terrestre, ne studiano le rocce, i minerali, la composizione e la struttura. L’esercizio della professione di Geologo è regolata dalle leggi dello Stato."
        },
        {
          "code" : "2.1.1.6.2",
          "display" : "Paleontologi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche finalizzate a ricostruire la storia biologica della terra attraverso l'analisi di materiale fossile."
        },
        {
          "code" : "2.1.1.6.3",
          "display" : "Geofisici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali e incrementano la conoscenza scientifica sugli aspetti fisici della crosta terrestre, applicano conoscenze di chimica, fisica, biologia e matematica per spiegarne fenomeni e attività, studiano i movimenti tellurici, contribuiscono ad individuare giacimenti di minerali, di gas, di petrolio e sorgenti sotterranee d’acqua."
        },
        {
          "code" : "2.1.1.6.4",
          "display" : "Meteorologi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali e incrementano la conoscenza scientifica sugli aspetti fisici dell’atmosfera terrestre, studiano i fenomeni atmosferici, elaborano ed interpretano dati per prevederli."
        },
        {
          "code" : "2.1.1.6.5",
          "display" : "Idrologi",
          "definition" : "Le professioni comprese in questa unità studiano la distribuzione, la circolazione e le proprietà fisiche delle acque sotterranee e di superficie, la forma e l’intensità delle precipitazioni, il tasso di infiltrazione nel suolo, i movimenti delle acque attraverso la terra e il loro ritorno ai mari e nell’atmosfera. Applicano tali conoscenze ai problemi di ingegneria civile."
        },
        {
          "code" : "2.2",
          "display" : "Ingegneri, architetti e professioni assimilate",
          "definition" : "Le professioni classificate in questo gruppo conducono ricerche ovvero applicano le conoscenze esistenti nel campo del design, della progettazione e della realizzazione di costruzioni civili ed industriali, della pianificazione e del recupero urbano; del design, della progettazione e della realizzazione di macchine, di beni, di mezzi di trasporto nonché dei sistemi di produzione di tali beni; dei sistemi di estrazione e di trasformazione di minerali, gas, petrolio e acqua. Sovrintendono e dirigono tali attività; studiano le proprietà tecnologiche dei materiali; eseguono indagini sulle caratteristiche e la conformazione del territorio producendo elaborazioni e rappresentazioni grafiche dello stesso."
        },
        {
          "code" : "2.2.1",
          "display" : "Ingegneri e professioni assimilate",
          "definition" : "Le professioni comprese in questa classe conducono ricerche ovvero applicano le conoscenze esistenti nel campo della pianificazione urbana; della progettazione, della realizzazione, della gestione e della manutenzione di costruzioni e di impianti civili ed industriali; di macchine, di apparati e di sistemi meccanici, elettrici ed elettronici, di mezzi di trasporto, di tecnologie rivolte al trattamento dell'informazione, degli impianti per la produzione di beni di consumo e per quella di prodotti chimici, farmaceutici ed alimentari, intermedi e finali; dei sistemi di estrazione e di trasformazione di minerali, di gas, di petrolio e di acqua. Sovrintendono e dirigono tali attività, conducono ricerche, studiano le proprietà tecnologiche dei materiali; eseguono indagini sulle caratteristiche e la conformazione del territorio, producendo elaborazioni e rappresentazioni grafiche dello stesso. L’esercizio della professione di Ingegnere è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.2.1.1",
          "display" : "Ingegneri energetici e meccanici",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche ovvero applicano le conoscenze esistenti nel campo della meccanica per disegnare, progettare e controllare funzionalmente, per produrre e manutenere strumenti, motori, macchine ed altre attrezzature meccaniche; mezzi di trasporto terrestri, marini, aerei ed aerospaziali, le parti meccaniche dei relativi sistemi di propulsione e di produzione di energia; apparati meccanici per il controllo, il rilascio e l’utilizzazione dell’energia nucleare e delle scorie radioattive. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.1.1",
          "display" : "Ingegneri meccanici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti nel campo della meccanica per disegnare, progettare e controllare funzionalmente, per produrre e manutenere strumenti, motori, macchine ed altre attrezzature meccaniche. Sovrintendono e dirigono tali attività, conducono ricerche e studi sulle caratteristiche tecnologiche dei materiali utilizzati e dei loro processi di produzione."
        },
        {
          "code" : "2.2.1.1.2",
          "display" : "Ingegneri navali",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti nel campo della meccanica per disegnare, progettare e controllare funzionalmente, per produrre e manutenere mezzi di trasporto marini e le parti meccaniche dei relativi sistemi di propulsione e di produzione di energia. Sovrintendono e dirigono tali attività, conducono ricerche e studi sulle caratteristiche tecnologiche dei materiali utilizzati e dei loro processi di produzione."
        },
        {
          "code" : "2.2.1.1.3",
          "display" : "Ingegneri aerospaziali e astronautici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti nel campo della meccanica per disegnare, progettare e controllare funzionalmente, per produrre e manutenere mezzi di trasporto aerei ed aerospaziali e le parti meccaniche dei relativi sistemi di propulsione e di produzione di energia. Sovrintendono e dirigono tali attività, conducono ricerche e studi sulle caratteristiche tecnologiche dei materiali utilizzati e dei loro processi di produzione."
        },
        {
          "code" : "2.2.1.1.4",
          "display" : "Ingegneri energetici e nucleari",
          "definition" : "Le professioni comprese in questa unità conducono ricerche e applicano le conoscenze esistenti per la produzione e l'utilizzo razionale dell'energia nei settori industriale e civile; studiano nuovi metodi di conversione dell'energia a partire dalle fonti primarie disponibili in natura, conducono ricerche su nuovi sistemi e vettori energetici e sulle problematiche del risparmio energetico e dell'impatto ambientale. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.2",
          "display" : "Ingegneri metallurgico-minerari",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche ovvero applicano in attività di produzione le conoscenze esistenti nel campo dell'estrazione di minerali, acqua, gas e petrolio; della ricerca e della produzione di nuove leghe o di nuove ceramiche; dello studio delle caratteristiche tecnologiche di particolari materiali, prodotti e processi. Conducono ricerche geologiche e topografiche per individuare cave, giacimenti minerari, di gas e di petrolio; programmano e definiscono le modalità del loro sfruttamento, studiano e progettano sistemi e attrezzature per l’estrazione e il primo trattamento dei minerali e per la sicurezza dei processi di produzione. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.2.1",
          "display" : "Ingegneri metallurgici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti nel campo della ricerca e della produzione di nuove leghe o di nuove ceramiche; applicano le conoscenze delle caratteristiche tecnologiche di particolari materiali, prodotti e processi. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.2.2",
          "display" : "Ingegneri minerari",
          "definition" : "Le professioni comprese in questa unità conducono ricerche geologiche e topografiche per individuare cave, giacimenti minerari, di gas e di petrolio; programmano e definiscono le modalità del loro sfruttamento, studiano e progettano sistemi e attrezzature per l’estrazione e il primo trattamento dei minerali e per la sicurezza dei processi di produzione. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.3",
          "display" : "Ingegneri elettrotecnici",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche, ovvero applicano le conoscenze esistenti per disegnare, progettare, controllare anche in modo automatico, produrre e manutenere sistemi, motori, apparati e attrezzature rivolte alla generazione, distribuzione ed uso di energia elettrica. Conducono ricerche sugli aspetti tecnologici di particolari materiali e processi; definiscono e progettano standard e procedure per garantire il funzionamento e la sicurezza dei sistemi di generazione e di distribuzione dell’energia elettrica, nonché dei sistemi e degli apparati da questa alimentati. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.3.0",
          "display" : "Ingegneri elettrotecnici e dell'automazione industriale",
          "definition" : "Le professioni comprese in questa unità applicano le conoscenze esistenti per disegnare, progettare, controllare anche in modo automatico, produrre e manutenere sistemi, motori, apparati e attrezzature rivolte alla generazione, distribuzione ed uso di energia elettrica. Conducono ricerche sugli aspetti tecnologici di particolari materiali e processi; definiscono e progettano standard e procedure per garantire il funzionamento e la sicurezza dei sistemi di generazione e di distribuzione dell’energia elettrica, nonché dei sistemi e degli apparati da questa alimentati. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.4",
          "display" : "Ingegneri elettronici e in telecomunicazioni",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche ovvero applicano le conoscenze esistenti in materia di elettronica, di proprietà elettroniche dei materiali e in materia di telecomunicazioni per disegnare, progettare, controllare funzionalmente sistemi, apparati, circuiti e componenti elettronici per usi commerciali, industriali o scientifici. Conducono ricerche, progettano e testano le componenti hardware di calcolatori, reti e periferiche di calcolatori ovvero di apparati e sistemi di telecomunicazioni. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.4.1",
          "display" : "Ingegneri elettronici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti in materia di elettronica, di proprietà elettroniche dei materiali per disegnare, progettare e controllare funzionalmente sistemi, apparati, circuiti e componenti elettronici per usi commerciali, industriali o scientifici. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.4.2",
          "display" : "Ingegneri progettisti di calcolatori e loro periferiche",
          "definition" : "Le professioni comprese in questa unità applicano le conoscenze esistenti in materia di proprietà elettroniche dei materiali per disegnare, progettare, controllare funzionalmente sistemi, apparati elettronici per usi commerciali, industriali o scientifici. Conducono ricerche, progettano e testano le componenti hardware, le reti e le periferiche di calcolatori. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.4.3",
          "display" : "Ingegneri in telecomunicazioni",
          "definition" : "Le professioni comprese in questa unità applicano le conoscenze esistenti in materia di telecomunicazioni per disegnare, progettare, controllare funzionalmente sistemi, apparati per usi commerciali, industriali o scientifici. Conducono ricerche, progettano e testano apparati, sistemi e reti di telecomunicazioni. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.5",
          "display" : "Ingegneri chimici, petroliferi e dei materiali",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche ovvero applicano le conoscenze esistenti nel campo della chimica per progettare e controllare funzionalmente, realizzare e manutenere impianti e sistemi per la produzione di sostanze chimiche, di derivati dal petrolio, farmaci, prodotti alimentari. Conducono ricerche e studi per migliorarne i sistemi di produzione e per ottimizzare la produzione e la raffinazione di petrolio e di gas. Conducono ricerche per lo sviluppo dei materiali conosciuti, per lo studio di possibili nuovi usi degli stessi, per la progettazione e lo sviluppo di macchinari e processi di produzione di materiali per prodotti con prestazioni particolari. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.5.1",
          "display" : "Ingegneri chimici e petroliferi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti nel campo della chimica per progettare e controllare funzionalmente, realizzare e manutenere impianti e sistemi per la produzione di sostanze chimiche, farmaceutiche, prodotti alimentari e derivati dal petrolio. Conducono ricerche e studi per migliorarne i sistemi di produzione e per ottimizzare la produzione e la raffinazione di petrolio e di gas. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.5.2",
          "display" : "Ingegneri dei materiali",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti in materia di studio e di sviluppo dei materiali conosciuti, di possibili nuovi usi degli stessi, di progettazione e sviluppo di macchinari e processi di produzione di materiali per prodotti con prestazioni particolari. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.6",
          "display" : "Ingegneri civili e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche ovvero applicano le conoscenze esistenti nel campo della pianificazione urbana e del territorio; della progettazione, della costruzione e della manutenzione di edifici, strade, ferrovie, aeroporti e porti, ponti, canali, dighe ed opere di presa, sistemi di irrigazione, oleodotti e gasdotti, per lo smaltimento dei rifiuti e di altre costruzioni civili e industriali; progettano soluzioni per prevenire, controllare o risanare gli impatti negativi dell'attività antropica sull'ambiente; si occupano di prevenzione e risanamento dei fenomeni di dissesto idrogeologico e instabilità dei versanti, di sistemazione e gestione dei bacini idrografici. Conducono ricerche sulle caratteristiche tecnologiche di particolari materiali e processi; definiscono e progettano standard e procedure per garantire la funzionalità e la sicurezza delle strutture; sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.6.1",
          "display" : "Ingegneri edili e ambientali",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti nel campo della pianificazione urbana e del territorio, della progettazione, della costruzione e della manutenzione di edifici, strade, ferrovie, aeroporti, ponti e sistemi per lo smaltimento dei rifiuti e di altre costruzioni civili e industriali. Definiscono e progettano standard e procedure per garantire la funzionalità e la sicurezza delle strutture. Progettano soluzioni per prevenire, controllare o risanare gli impatti negativi dell'attività antropica sull'ambiente; conducono valutazioni di impatto ambientale di progetti ed opere dell'ingegneria civile o di altre attività; si occupano di prevenzione e risanamento dei fenomeni di dissesto idrogeologico e instabilità dei versanti, di sistemazione e gestione dei bacini idrografici. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.6.2",
          "display" : "Ingegneri idraulici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti nel campo della progettazione, della costruzione e della manutenzione di porti, canali, dighe ed opere di presa, sistemi di irrigazione, oleodotti e gasdotti. Definiscono e progettano standard e procedure per garantire la funzionalità e la sicurezza delle strutture. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.7",
          "display" : "Ingegneri industriali e gestionali",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche ovvero applicano le conoscenze esistenti in materia di progettazione, sviluppo e valutazione di sistemi integrati per la gestione dei processi di produzione, ivi compresi il lavoro umano, i controlli di qualità, la logistica industriale, l’analisi dei costi e il coordinamento della produzione. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.7.0",
          "display" : "Ingegneri industriali e gestionali",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti in materia di progettazione, sviluppo e valutazione di sistemi integrati per la gestione dei processi di produzione industriale e nei servizi, ivi compresi il lavoro umano, i controlli di qualità, la logistica industriale, l’analisi dei costi e il coordinamento della produzione. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.8",
          "display" : "Ingegneri biomedici e bioingegneri",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche ovvero applicano le conoscenze esistenti in materia di sviluppo, progettazione e realizzazione di organi artificiali, protesi, strumentazioni per la diagnostica e la cura medica, sistemi informativi e sistemi per la gestione e la cura della salute umana. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.1.8.0",
          "display" : "Ingegneri biomedici e bioingegneri",
          "definition" : "Le professioni comprese in questa unità conducono ricerche e studi ovvero applicano le conoscenze esistenti in materia di sviluppo, progettazione e realizzazione di organi artificiali, protesi, strumentazioni per la diagnostica e la cura medica, sistemi informativi e sistemi per la gestione e la cura della salute umana. Applicano tecniche dell'ingegneria dei sistemi alla biomedicina per la realizzazione di protesi articolari e dispositivi di osteosintesi. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.2",
          "display" : "Architetti, pianificatori, paesaggisti e specialisti del recupero e della conservazione del territorio",
          "definition" : "Le professioni comprese in questa classe conducono ricerche ovvero applicano le conoscenze esistenti in materia di pianificazione, conservazione e recupero urbano e territoriale, di design, di progettazione, di realizzazione, di manutenzione di costruzioni civili, siti industriali e beni di consumo. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.2.1",
          "display" : "Architetti, pianificatori, paesaggisti e specialisti del recupero e della conservazione del territorio",
          "definition" : "Le professioni classificate in questa categoria conducono ricerche ovvero applicano le conoscenze esistenti in materia di design, di pianificazione, conservazione, restauro e recupero urbanistico e territoriale, della progettazione, della costruzione e della manutenzione di opere civili, e di siti industriali. Ne disegnano e progettano la forma, gli interni e i loro arredamenti; disegnano mezzi di trasporto e altri beni prodotti su scala industriale curandone gli aspetti funzionali, simbolici ed estetici; conducono ricerche sulle caratteristiche tecnologiche di particolari materiali e processi; definiscono e progettano standard e procedure per garantire la funzionalità e la sicurezza delle strutture. Sovrintendono e dirigono tali attività; possono collaborare con gli Ingegneri per progettazioni e realizzazioni che richiedono complesse soluzioni tecnologiche e di calcolo. L’esercizio delle professioni di Architetto, di Pianificatore territoriale, di Paesaggista e di Conservatore dei beni architettonici ed ambientali è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.2.2.1.1",
          "display" : "Architetti",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti in materia di design, pianificazione, conservazione e restauro, progettazione, costruzione e manutenzione di opere civili e di siti industriali. Ne disegnano e progettano la forma, gli interni e i loro arredamenti; disegnano mezzi di trasporto e altri beni prodotti su scala industriale curandone gli aspetti funzionali, simbolici ed estetici; conducono ricerche sulle caratteristiche tecnologiche di particolari materiali e processi; definiscono e progettano standard e procedure per garantire la funzionalità e la sicurezza delle strutture. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.2.1.2",
          "display" : "Pianificatori, paesaggisti e specialisti del recupero e della conservazione del territorio",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti in materia di pianificazione, conservazione e recupero urbanistico e territoriale. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.2.2",
          "display" : "Cartografi e fotogrammetristi",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche e applicano le conoscenze esistenti in materia di acquisizione, analisi ed elaborazione di dati geografici provenienti da indagini geodetiche, da fotografie aeree e da dati satellitari per produrre mappe e altri dati territoriali. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.2.2.2.0",
          "display" : "Cartografi e fotogrammetristi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti in materia di acquisizione, analisi ed elaborazione di dati geografici provenienti da indagini geodetiche, da fotografie aeree e da dati satellitari per produrre mappe e altri dati territoriali. Sovrintendono e dirigono tali attività."
        },
        {
          "code" : "2.3",
          "display" : "Specialisti nelle scienze della vita",
          "definition" : "Le professioni classificate in questo gruppo conducono ricerche, approfondiscono e perfezionano concetti, teorie e metodi di indagine nel campo della biologia, della zoologia, della botanica, della farmacologia, dell’agronomia ovvero applicano la conoscenza scientifica acquisita in tali ambiti nella produzione di beni o di servizi."
        },
        {
          "code" : "2.3.1",
          "display" : "Specialisti nelle scienze della vita",
          "definition" : "Le professioni comprese in questa classe contribuiscono ad ampliare la conoscenza scientifica del mondo vivente conducendo ricerche sistematiche e sperimentazioni nei diversi settori della biologia, della zoologia, della botanica, della fisiologia, della cura e dell’allevamento delle piante e degli animali, della lavorazione degli alimenti e dei prodotti biologici correlati, della ricerca farmacologia e delle sue applicazioni. Studiano le forme della vita, gli organi, i tessuti, le cellule, i microrganismi e gli effetti su di loro dei fattori ambientali, dei farmaci e di altre sostanze; i sistemi ecologici, le biodiversità e le relazioni e gli equilibri sottostanti. Applicano e rendono disponibili tali conoscenze nella produzione di beni e servizi; in agricoltura e nell'allevamento degli animali, nella produzione di farmaci per la cura della salute umana e animale; nella medicina."
        },
        {
          "code" : "2.3.1.1",
          "display" : "Biologi, botanici, zoologi e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche su concetti e teorie fondamentali nel campo della biologia, della genetica, della zoologia, della botanica e dell’ecologia, incrementano la conoscenza scientifica in materia e la applicano in attività di ricerca e nelle sperimentazioni di laboratorio. Studiano le basi della vita animale e vegetale; le sue origini, i sistemi di relazione, le modalità di sviluppo e di evoluzione; le composizioni, le reazioni e le attività chimiche che influenzano i processi vitali; la fisica degli organismi viventi e i fenomeni energetici correlati; i fattori sottostanti alla origine, allo sviluppo e alla trasmissione dei loro caratteri; ne studiano le strutture genetiche e le possibilità di modificarle. Analizzano le sostanze alimentari, ne individuano di nuove, ne determinano la composizione e gli elementi nutrizionali, studiano i fattori sottostanti al loro deterioramento. Studiano le forme della vita vegetale e animale, le origini, la genetica, i processi vitali, le malattie e gli stessi comportamenti animali; le interrelazioni fra gli organismi viventi e i fattori ambientali e antropici che ne influenzano la sopravvivenza. Applicano e rendono disponibili tali conoscenze nella medicina; nella produzione di beni e servizi; nell’agricoltura e nell’allevamento degli animali, nella produzione di farmaci per la cura della salute e di prodotti per l’alimentazione umana e animale."
        },
        {
          "code" : "2.3.1.1.1",
          "display" : "Biologi e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali nel campo della biologia e della genetica, incrementano la conoscenza scientifica in materia e la applicano in attività di ricerca e nelle sperimentazioni di laboratorio; studiano le basi della vita animale e vegetale, le sue origini, i sistemi di relazione, le modalità di sviluppo e di evoluzione, le strutture genetiche e le possibilità di modificarle. Applicano e rendono disponibili tali conoscenze nella produzione di beni e servizi. L’esercizio della professione di Biologo è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.3.1.1.2",
          "display" : "Biochimici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali nel campo della biologia e della genetica, incrementano la conoscenza scientifica in materia e la applicano in attività di ricerca e nelle sperimentazioni di laboratorio. Studiano le composizioni, le reazioni e le attività chimiche che influenzano i processi vitali, le strutture genetiche degli organismi viventi e le possibilità di modificarle. Applicano e rendono disponibili tali conoscenze nella produzione di beni e servizi."
        },
        {
          "code" : "2.3.1.1.3",
          "display" : "Biofisici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali nel campo della biologia e della genetica, incrementano la conoscenza scientifica in materia e la applicano in attività di ricerca e nelle sperimentazioni di laboratorio. Studiano la fisica degli organismi viventi e i fenomeni energetici correlati, ne studiano le strutture genetiche e le possibilità di modificarle. Applicano e rendono disponibili tali conoscenze nella produzione di beni e servizi."
        },
        {
          "code" : "2.3.1.1.4",
          "display" : "Biotecnologi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali nel campo della biologia, incrementano la conoscenza scientifica in materia e la applicano in attività di ricerca e nelle sperimentazioni di laboratorio. Utilizzano sistemi biologici e tecniche di ingegneria genetica per applicazioni in settori produttivi, quali quello agricolo, zootecnico, alimentare, chimico, medico, farmaceutico, ambientale. Analizzano le sostanze alimentari, ne individuano di nuove, ne determinano la composizione e gli elementi nutrizionali, ne certificano la salubrità, studiano i fattori sottostanti al loro deterioramento. Applicano e rendono disponibili tali conoscenze nella produzione di beni e servizi. L’esercizio della professione di Tecnologo Alimentare è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.3.1.1.5",
          "display" : "Botanici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali nel campo della botanica, incrementano la conoscenza scientifica in materia e la applicano in attività di ricerca e nelle sperimentazioni di laboratorio. Studiano le forme e le origini della vita vegetale, la genetica, i processi vitali, le malattie e le modalità di sviluppo e di evoluzione. Applicano e rendono disponibili tali conoscenze nella produzione di beni e servizi."
        },
        {
          "code" : "2.3.1.1.6",
          "display" : "Zoologi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali nel campo della zoologia, incrementano la conoscenza scientifica in materia e la applicano in attività di ricerca e nelle sperimentazioni di laboratorio. Studiano le forme della vita animale, le origini, la genetica, i processi vitali, le malattie e gli stessi comportamenti animali. Applicano e rendono disponibili tali conoscenze nella produzione di beni e servizi."
        },
        {
          "code" : "2.3.1.1.7",
          "display" : "Ecologi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali nel campo dell’ecologia, incrementano la conoscenza scientifica in materia e la applicano in attività di ricerca e nelle sperimentazioni di laboratorio. Studiano le interrelazioni fra gli organismi viventi e i fattori ambientali e antropici che ne influenzano la sopravvivenza. Applicano e rendono disponibili tali conoscenze nella produzione di beni e servizi."
        },
        {
          "code" : "2.3.1.2",
          "display" : "Farmacologi, batteriologi e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche su concetti e teorie fondamentali nel campo della farmacologia e degli effetti dei farmaci sugli organismi viventi. Conducono studi ed esperimenti sulla natura, sulle cause e sui processi delle malattie; sugli effetti dei farmaci e di altre sostanze naturali o di sintesi sui sistemi vitali; sulla crescita, sullo sviluppo, sulla struttura e su altre caratteristiche dei microrganismi, sulle loro relazioni con le malattie e sugli effetti delle sostanze antibiotiche sui loro processi vitali, sulla chimica e la tecnica farmaceutica. Applicano e rendono disponibili tali conoscenze nella medicina; nell’agricoltura e nell’allevamento degli animali, nella produzione di farmaci per la cura della salute umana, animale e vegetale."
        },
        {
          "code" : "2.3.1.2.1",
          "display" : "Farmacologi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali nel campo della farmacologia e degli effetti dei farmaci sugli organismi viventi. Conducono studi ed esperimenti sulla natura, sulle cause e sui processi delle malattie; sugli effetti dei farmaci e di altre sostanze naturali o di sintesi sui sistemi vitali. Applicano e rendono disponibili tali conoscenze nella medicina, nell’agricoltura e nell’allevamento degli animali, nella produzione di farmaci per la cura della salute umana, animale e vegetale."
        },
        {
          "code" : "2.3.1.2.2",
          "display" : "Microbiologi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti e teorie fondamentali nel campo della farmacologia e degli effetti dei farmaci sugli organismi viventi. Conducono studi ed esperimenti sulla crescita, sullo sviluppo, sulla struttura e su altre caratteristiche dei microrganismi, sulle loro relazioni con le malattie e sugli effetti delle sostanze antibiotiche sui loro processi vitali, sulla chimica e la tecnica farmaceutica. Applicano e rendono disponibili tali conoscenze nella medicina, nell’agricoltura e nell’allevamento degli animali, nella produzione di farmaci per la cura della salute umana, animale e vegetale."
        },
        {
          "code" : "2.3.1.3",
          "display" : "Agronomi e forestali",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche ovvero applicano le conoscenze esistenti nel campo della cura e dell’allevamento di animali e di vegetali. Studiano le modalità riproduttive, la genetica e le possibilità di miglioramento delle specie, i fattori di crescita e nutrizionali degli animali da allevamento, delle piante e delle colture; la composizione chimica, fisica, biologica e minerale dei suoli, individuando le colture più adattabili e a maggiore rendimento; ricercano e mettono a punto nuove pratiche e modalità colturali e di allevamento; studiano, identificano e controllano le malattie dei vegetali, ne individuano le modalità di trattamento sia chimico che biologico. Definiscono le modalità di gestione, di miglioramento, di protezione delle risorse floro-faunistiche naturali; della loro messa a produzione; di salvaguardia dell’idrologia, della qualità delle acque e della stabilità del suolo e di ripopolamento del loro habitat naturale."
        },
        {
          "code" : "2.3.1.3.0",
          "display" : "Agronomi e forestali",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti nel campo della cura e dell’allevamento di animali e di vegetali. Studiano le modalità riproduttive, la genetica e le possibilità di miglioramento delle specie, i fattori di crescita e nutrizionali degli animali da allevamento, delle piante e delle colture; la composizione chimica, fisica, biologica e minerale dei suoli, individuando le colture più adattabili e a maggiore rendimento; ricercano e mettono a punto nuove pratiche e modalità colturali e di allevamento; studiano, identificano e controllano le malattie dei vegetali, ne individuano le modalità di trattamento sia chimico che biologico. Definiscono le modalità di gestione, di miglioramento, di protezione delle risorse floro-faunistiche naturali; della loro messa a produzione; di salvaguardia dell’idrologia, della qualità delle acque e della stabilità del suolo e di ripopolamento del loro habitat naturale. L’esercizio delle professioni di Dottore Agronomo e di Dottore Forestale è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.3.1.4",
          "display" : "Veterinari",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche ovvero applicano le conoscenze esistenti nel campo della diagnosi e della cura delle malattie e delle disfunzioni degli animali. Esaminano gli animali per individuare sintomi di malattie e di disfunzioni, le diagnosticano, individuano i trattamenti farmacologici e chirurgici da somministrare, curano le ferite; controllano le condizioni di salute degli allevamenti; attivano controlli epidemiologici e vaccinano gli animali; informano su come averne cura e su come farli riprodurre. Verificano e controllano la qualità, la purezza e la sicurezza delle carni destinate all’alimentazione umana e quella degli alimenti somministrati agli animali stessi."
        },
        {
          "code" : "2.3.1.4.0",
          "display" : "Veterinari",
          "definition" : "Le professioni comprese in questa unità conducono ricerche ovvero applicano le conoscenze esistenti nel campo della diagnosi e della cura delle malattie e delle disfunzioni degli animali. Esaminano gli animali per individuare sintomi di malattie e di disfunzioni, le diagnosticano, individuano i trattamenti farmacologici e chirurgici da somministrare, curano le ferite; controllano le condizioni di salute degli allevamenti; attivano controlli epidemiologici e vaccinano gli animali; informano su come averne cura e su come farli riprodurre. Verificano e controllano la qualità, la purezza e la sicurezza delle carni destinate all’alimentazione umana e quella degli alimenti somministrati agli animali stessi. L’esercizio della professione di Medico veterinario è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.3.1.5",
          "display" : "Farmacisti",
          "definition" : "Le professioni comprese in questa categoria applicano la conoscenza farmacologica nella preparazione, nella distribuzione e nella vendita di medicamenti e di farmaci. Preparano o dirigono la preparazione di farmaci e di medicamenti prescritti da medici e veterinari seguendo le formulazioni stabilite, ovvero li distribuiscono in ospedali o in farmacie registrando i movimenti di farmaci pericolosi o di veleni. Identificano i principi attivi e determinano la purezza e l’azione dei farmaci; controllano le prescrizioni assicurandosi che non superino i dosaggi raccomandati; si accertano che gli utenti abbiano compreso le istruzioni di uso e li informano sulle possibili incompatibilità dei farmaci da assumere."
        },
        {
          "code" : "2.3.1.5.0",
          "display" : "Farmacisti",
          "definition" : "Le professioni comprese in questa unità applicano la conoscenza farmacologica nella preparazione, nella distribuzione e nella vendita di medicamenti e di farmaci. Preparano o dirigono la preparazione di farmaci e di medicamenti prescritti da medici e veterinari seguendo le formulazioni stabilite, ovvero li distribuiscono in ospedali o in farmacie registrando i movimenti di farmaci pericolosi o di veleni. Identificano i principi attivi e determinano la purezza e l’azione dei farmaci; controllano le prescrizioni assicurandosi che non superino i dosaggi raccomandati; si accertano che gli utenti abbiano compreso le istruzioni di uso e li informano sulle possibili incompatibilità dei farmaci da assumere. L’esercizio della professione di Farmacista è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.4",
          "display" : "Specialisti della salute",
          "definition" : "Le professioni classificate in questo gruppo contribuiscono ad ampliare e migliorare la conoscenza scientifica ovvero applicano le conoscenze disponibili nel campo della prevenzione, diagnosi, prognosi, cura delle malattie e del mantenimento della salute umana."
        },
        {
          "code" : "2.4.1",
          "display" : "Medici",
          "definition" : "Le professioni comprese in questa classe conducono ricerche finalizzate allo studio delle disfunzioni e delle malattie e al miglioramento della salute umana ovvero applicano le conoscenze scientifiche esistenti nel campo della prevenzione e della cura della salute umana; conducono e prescrivono esami clinici, curano lesioni; prescrivono e somministrano cure farmacologiche, chirurgiche e terapie non invasive; applicano metodi e trattamenti per la prevenzione. L’esercizio delle professioni di Medico Chirurgo e di Odontoiatra è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.4.1.1",
          "display" : "Medici generici",
          "definition" : "Le professioni comprese in questa categoria diagnosticano, trattano e curano le disfunzioni, le malattie e le lesioni più comuni e maggiormente diffuse nella popolazione; attuano misure per la diagnosi precoce di gravi patologie in pazienti a rischio; prescrivono farmaci e terapie non farmacologiche, esami clinici per le diagnosi; ricoveri ospedalieri e visite presso medici specialisti; seguono il decorso delle patologie e delle relative cure; sollecitano e attuano interventi di prevenzione presso i pazienti o presso le organizzazioni in cui operano."
        },
        {
          "code" : "2.4.1.1.0",
          "display" : "Medici generici",
          "definition" : "Le professioni comprese in questa unità diagnosticano, trattano e curano le disfunzioni, le malattie e le lesioni più comuni e maggiormente diffuse nella popolazione; attuano misure per la diagnosi precoce di gravi patologie in pazienti a rischio; prescrivono farmaci e terapie non farmacologiche, esami clinici per le diagnosi, ricoveri ospedalieri e visite presso medici specialisti; seguono il decorso delle patologie e delle relative cure; sollecitano e attuano interventi di prevenzione presso i pazienti o presso le organizzazioni in cui operano."
        },
        {
          "code" : "2.4.1.2",
          "display" : "Specialisti in terapie mediche",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della diagnosi e del trattamento specialistico non chirurgico delle lesioni, dei traumi, delle disfunzioni e delle patologie della pelle, del sangue, cardiovascolari, polmonari, endocrinologiche, allergologiche, geriatriche, pediatriche, oncologiche, neurologiche, psichiatriche, reumatologiche, gastrointestinali e dell'apparato urinario. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.2.0",
          "display" : "Specialisti in terapie mediche",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della diagnosi e del trattamento specialistico non chirurgico delle lesioni, dei traumi, delle disfunzioni e delle patologie della pelle, del sangue, cardiovascolari, polmonari, endocrinologiche, allergologiche, geriatriche, pediatriche, oncologiche, neurologiche, psichiatriche, reumatologiche, gastrointestinali e dell'apparato urinario. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.3",
          "display" : "Specialisti in terapie chirurgiche",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della diagnosi e del trattamento chirurgico specialistico delle lesioni, dei traumi, delle disfunzioni e delle patologie. Sono compresi in questa categoria gli specialisti del trattamento chirurgico delle patologie otorinolaringoiatriche, ortopediche, ginecologiche, urogenitali, oculistiche, dell'apparato digerente, del distretto toracico e di quello maxillo-facciale, del cuore e del sistema nervoso, nonchè gli specialisti che effettuano interventi chirurgici a fini estetici. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.3.0",
          "display" : "Specialisti in terapie chirurgiche",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della diagnosi e del trattamento chirurgico specialistico delle lesioni, dei traumi, delle disfunzioni e delle patologie. Sono compresi in questa categoria gli specialisti del trattamento chirurgico delle patologie otorinolaringoiatriche, ortopediche, ginecologiche, urogenitali, oculistiche, dell'apparato digerente, del distretto toracico e di quello maxillo-facciale, del cuore e del sistema nervoso, nonchè gli specialisti che effettuano interventi chirurgici a fini estetici. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.4",
          "display" : "Laboratoristi e patologi clinici",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo dell’analisi patologica, tossicologica, genetica, embriologica, ematologia, immunologica, istologica e citologica e nel campo del funzionamento in condizioni normali e fuori dalla norma degli organi, dei tessuti, delle cellule, delle ghiandole e dei sistemi ghiandolari umani. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.4.0",
          "display" : "Laboratoristi e patologi clinici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo dell’analisi patologica, tossicologica, genetica, embriologica, ematologica, immunologica, istologica e citologica e nel campo del funzionamento in condizioni normali e fuori dalla norma degli organi, dei tessuti, delle cellule, delle ghiandole e dei sistemi ghiandolari umani. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.5",
          "display" : "Dentisti e odontostomatologi",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche su teorie e metodi, ovvero applicano le conoscenze esistenti nel campo della diagnosi, del trattamento delle patologie, delle lesioni e delle malformazioni delle arcate dentarie e delle altre strutture della cavità orale; trattano le anomalie delle occlusioni dentali e delle altre strutture del cavo orale; trattano le patologie delle strutture nervose e degli altri tessuti dentali. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.5.0",
          "display" : "Dentisti e odontostomatologi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su teorie e metodi, ovvero applicano le conoscenze esistenti nel campo della diagnosi, del trattamento delle patologie, delle lesioni e delle malformazioni delle arcate dentarie e delle altre strutture della cavità orale; trattano le anomalie delle occlusioni dentali e delle altre strutture del cavo orale; trattano le patologie delle strutture nervose e degli altri tessuti dentali. Prescrivono farmaci, cure ed esami diagnostici"
        },
        {
          "code" : "2.4.1.6",
          "display" : "Specialisti in diagnostica per immagini e radioterapia",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della diagnosi delle patologie degli organi interni attraverso immagini e tracciati prodotti da ultrasuoni, campi magnetici, radiazioni o isotopi radioattivi e nel campo del trattamento radiologico o ultrasonico di alcune patologie. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.6.0",
          "display" : "Specialisti in diagnostica per immagini e radioterapia",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della diagnosi delle patologie degli organi interni attraverso immagini e tracciati prodotti da ultrasuoni, campi magnetici, radiazioni o isotopi radioattivi e nel campo del trattamento radiologico o ultrasonico di alcune patologie. Prescrivono farmaci, cure ed esami diagnostici"
        },
        {
          "code" : "2.4.1.7",
          "display" : "Specialisti in igiene, epidemiologia e sanità pubblica",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della prevenzione, della diagnosi e del trattamento delle patologie e delle disfunzioni derivanti da disordine alimentare, dall’esercizio di attività lavorative e sportive, e nel campo della individuazione e descrizione dei fattori sottostanti alla distribuzione e alla diffusione nella popolazione delle patologie, delle disabilità, delle disfunzioni e di altre condizioni di salute, nonché nel campo della definizione delle relative metodiche di controllo e prevenzione. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.7.1",
          "display" : "Dietologi e igienisti",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della prevenzione, della diagnosi e del trattamento delle patologie e delle disfunzioni derivanti da disordine alimentare, nonché nel campo della definizione delle relative metodiche di controllo e prevenzione. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.7.2",
          "display" : "Specialisti in medicina sociale e del lavoro",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della prevenzione, della diagnosi e del trattamento delle patologie e delle disfunzioni derivanti dall’esercizio di attività lavorative e sportive, nonché nel campo della definizione delle relative metodiche di controllo e prevenzione. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.7.3",
          "display" : "Epidemiologi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della individuazione e descrizione dei fattori sottostanti alla distribuzione e alla diffusione nella popolazione delle patologie, delle disabilità, delle disfunzioni e di altre condizioni di salute, nonché nel campo della definizione delle relative metodiche di controllo e prevenzione."
        },
        {
          "code" : "2.4.1.8",
          "display" : "Anestesisti e rianimatori",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della anestesiologia e della rianimazione per somministrare anestetici nel corso di interventi chirurgici o di altre procedure mediche; individuare le condizioni di sicurezza della loro somministrazione; riportare i pazienti sottoposti ai trattamenti in condizioni di veglia; intervenire con farmaci salvavita e tecniche e metodiche di rianimazione in situazioni di pericolo. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.4.1.8.0",
          "display" : "Anestesisti e rianimatori",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su teorie e metodi ovvero applicano le conoscenze esistenti nel campo della anestesiologia e della rianimazione per somministrare anestetici nel corso di interventi chirurgici o di altre procedure mediche; individuano le condizioni di sicurezza della somministrazione di anestetici; riportano i pazienti sottoposti ai trattamenti in condizioni di veglia; intervengono con farmaci salvavita e tecniche e metodiche di rianimazione in situazioni di pericolo. Prescrivono farmaci, cure ed esami diagnostici."
        },
        {
          "code" : "2.5",
          "display" : "Specialisti in scienze umane, sociali, artistiche e gestionali",
          "definition" : "Le professioni classificate in questo gruppo conducono ricerche su concetti e teorie fondamentali e incrementano la conoscenza scientifica, ovvero applicano le conoscenze esistenti in materia di gestione e di organizzazione dei sistemi sociali e produttivi; di applicazione della legge e dei principi giuridici; studiano i fenomeni sociali, psicosociali, economici e politici; il linguaggio, la letteratura, la storia, la filosofia; informano sugli avvenimenti; conservano il patrimonio artistico e documentale; ricercano nuove forme di conoscenza estetica attraverso le discipline artistiche; si occupano di ricerca teologica e di organizzazione e proselitismo religioso."
        },
        {
          "code" : "2.5.1",
          "display" : "Specialisti delle scienze gestionali, commerciali e bancarie",
          "definition" : "Le professioni comprese in questa classe conducono ricerche ovvero applicano le conoscenze esistenti in materia di gestione e controllo delle attività organizzative delle imprese e della pubblica amministrazione; di organizzazione del lavoro e gestione del personale; di gestione finanziaria e contabile delle imprese pubbliche e private; di approvvigionamento e commercializzazione dei beni e dei servizi; di comunicazione e rappresentazione esterna ed interna dell’immagine di imprese o organizzazioni."
        },
        {
          "code" : "2.5.1.1",
          "display" : "Specialisti della gestione e del controllo nella pubblica amministrazione",
          "definition" : "Le professioni comprese in questa categoria coordinano le attività degli uffici dell’amministrazione statale e locale, delle aziende autonome, delle Università, degli Enti di Ricerca e del Servizio Sanitario Nazionale, formulano proposte e pareri ai dirigenti da cui dipendono funzionalmente; curano l’attuazione dei progetti, delle attività amministrative e delle procedure loro affidate, coordinando le attività del personale subordinato; verificano, controllano e forniscono assistenza sulla corretta applicazione delle leggi e dei regolamenti dello Stato, sia da parte della popolazione interessata che da parte della stessa amministrazione pubblica. Coordinano localmente le attività degli uffici di pubblica sicurezza e di protezione civile."
        },
        {
          "code" : "2.5.1.1.1",
          "display" : "Specialisti della gestione nella Pubblica Amministrazione",
          "definition" : "Le professioni comprese in questa unità coordinano le attività degli uffici dell’amministrazione statale e locale, delle aziende autonome, delle Università, degli Enti di Ricerca e del Servizio Sanitario Nazionale, formulano proposte e pareri ai dirigenti da cui dipendono funzionalmente, curano l’attuazione dei progetti, delle attività amministrative e delle procedure loro affidate, coordinando le attività del personale subordinato."
        },
        {
          "code" : "2.5.1.1.2",
          "display" : "Specialisti del controllo nella Pubblica Amministrazione",
          "definition" : "Le professioni comprese in questa unità verificano, controllano e forniscono assistenza sulla corretta applicazione delle leggi e dei regolamenti dello Stato, sia da parte della popolazione interessata che da parte della stessa amministrazione pubblica."
        },
        {
          "code" : "2.5.1.1.3",
          "display" : "Specialisti in pubblica sicurezza",
          "definition" : "Le professioni comprese in questa unità coordinano localmente le attività degli uffici di pubblica sicurezza, di polizia tributaria e di protezione civile. Implementano strategie di prevenzione dei reati, di ricerca e denuncia delle evasioni e delle violazioni finanziarie, di vigilanza sull'adempimento delle disposizioni di interesse politico-economico, di polizia finanziaria e doganale, di mantenimento dell'ordine, della sicurezza pubblica e delle frontiere."
        },
        {
          "code" : "2.5.1.2",
          "display" : "Specialisti della gestione e del controllo nelle imprese private",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche, studi e valutazioni nel campo dell’organizzazione, della progettazione e definizione delle procedure e dei servizi amministrativi e dei sistemi di assicurazione della qualità necessari alla gestione delle attività di impresa, ovvero applicano le conoscenze in materia e le procedure esistenti per fornirli, implementarli e migliorarli; conducono studi sui costi di impresa per individuare modalità di controllo."
        },
        {
          "code" : "2.5.1.2.0",
          "display" : "Specialisti della gestione e del controllo nelle imprese private",
          "definition" : "Le professioni comprese in questa unità conducono ricerche, studi e valutazioni nel campo dell’organizzazione, della progettazione e definizione delle procedure e dei servizi amministrativi e dei sistemi di assicurazione della qualità necessari alla gestione delle attività di impresa, ovvero applicano le conoscenze in materia e le procedure esistenti per fornirli, implementarli e migliorarli; conducono studi sui costi di impresa per individuare modalità di controllo."
        },
        {
          "code" : "2.5.1.3",
          "display" : "Specialisti di gestione e sviluppo del personale e dell’organizzazione del lavoro",
          "definition" : "Le professioni comprese in questa categoria si occupano della selezione e del reclutamento del personale necessario, definiscono i criteri e i programmi di sviluppo delle carriere, dei compensi, degli investimenti in formazione; studiano e analizzano le modalità di organizzazione del lavoro, individuano i fabbisogni quantitativi e qualitativi di personale e di formazione."
        },
        {
          "code" : "2.5.1.3.1",
          "display" : "Specialisti in risorse umane",
          "definition" : "Le professioni comprese in questa unità si occupano della selezione e del reclutamento del personale necessario, definiscono i criteri e i programmi di sviluppo delle carriere, dei compensi e degli investimenti in formazione."
        },
        {
          "code" : "2.5.1.3.2",
          "display" : "Specialisti dell’organizzazione del lavoro",
          "definition" : "Le professioni comprese in questa unità analizzano e definiscono l'organizzazione del lavoro, individuano i fabbisogni quantitativi e qualitativi di personale, redigono organigrammi, procedure, job descriptions e istruzioni."
        },
        {
          "code" : "2.5.1.4",
          "display" : "Specialisti in contabilità e problemi finanziari",
          "definition" : "Le professioni comprese in questa categoria esaminano, analizzano, interpretano le informazioni contabili per formulare pareri, preparare indicazioni e proposte su questioni contabili, fiscali e finanziarie; per certificare la correttezza e la conformità delle scritture aziendali alle leggi e ai regolamenti, ovvero coordinano le attività di gestione e di produzione delle scritture contabili; individuano e definiscono gli obblighi fiscali di organizzazioni o persone; conducono transazioni finanziarie assicurando la conformità con le leggi e i regolamenti relativi, svolgono analisi quantitative su programmi e piani di investimento; determinano il grado di rischio nel fornire crediti a persone o organizzazioni; valutano, autorizzano e definiscono le modalità di corresponsione di prestiti e le condizioni della loro garanzia e restituzione."
        },
        {
          "code" : "2.5.1.4.1",
          "display" : "Specialisti in contabilità",
          "definition" : "Le professioni comprese in questa unità esaminano, analizzano, interpretano le informazioni contabili per formulare pareri, preparare indicazioni e proposte su questioni contabili, fiscali e finanziarie, per certificare la correttezza e la conformità delle scritture aziendali alle leggi e ai regolamenti, ovvero coordinano le attività di gestione e di produzione delle scritture contabili. L’esercizio della professione di Dottore Commercialista è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.5.1.4.2",
          "display" : "Fiscalisti e tributaristi",
          "definition" : "Le professioni comprese in questa unità esaminano, analizzano, interpretano informazioni per formulare pareri, preparare indicazioni e proposte su questioni fiscali, individuano e definiscono gli obblighi fiscali di organizzazioni o persone"
        },
        {
          "code" : "2.5.1.4.3",
          "display" : "Specialisti in attività finanziarie",
          "definition" : "Le professioni comprese in questa unità esaminano, analizzano, interpretano informazioni per formulare pareri, preparare indicazioni e proposte su questioni finanziarie, conducono transazioni finanziarie assicurando la conformità con le leggi e i regolamenti relativi, svolgono analisi quantitative su programmi e piani di investimento, determinano il grado di rischio nel fornire crediti a persone o a organizzazioni; valutano, autorizzano e definiscono le modalità di corresponsione di prestiti e le condizioni della loro garanzia e restituzione"
        },
        {
          "code" : "2.5.1.5",
          "display" : "Specialisti nei rapporti con il mercato",
          "definition" : "Le professioni comprese in questa categoria analizzano le condizioni di vendita i prezzi ed acquistano sul mercato merci, materie prime, attrezzature, per rivenderli al pubblico o per utilizzarli nelle attività dell’impresa; si occupano dell'implementazione delle strategie di vendita, dell'efficienza della rete distributiva e commerciale, del monitoraggio delle vendite e del gradimento sul mercato dei beni o dei servizi prodotti, sia pubblici che d'impresa; conducono ricerche sulle condizioni di mercato a diversi livelli territoriali per individuare le possibilità di penetrazione commerciale di prodotti e servizi; ne individuano le situazioni di competizione, i prezzi e le modalità di vendita e di distribuzione."
        },
        {
          "code" : "2.5.1.5.1",
          "display" : "Specialisti nell’acquisizione di beni e servizi",
          "definition" : "Le professioni comprese in questa unità analizzano le condizioni di vendita, i prezzi ed acquistano sul mercato materie prime, componenti, attrezzature e forniture di servizi per rivenderli al pubblico o per utilizzarli nelle attività dell’impresa."
        },
        {
          "code" : "2.5.1.5.2",
          "display" : "Specialisti nella commercializzazione di beni e servizi (escluso il settore ICT)",
          "definition" : "Le professioni comprese in questa unità si occupano dell'implementazione delle strategie di vendita, dell'efficienza della rete distributiva e commerciale, del monitoraggio delle vendite e del gradimento sul mercato dei beni o dei servizi prodotti, sia pubblici che d'impresa."
        },
        {
          "code" : "2.5.1.5.3",
          "display" : "Specialisti nella commercializzazione nel settore delle tecnologie dell’informazione e della comunicazione",
          "definition" : "Le professioni comprese in questa unità si occupano dell'implementazione delle strategie di vendita di beni e servizi nel settore delle tecnologie dell'informazione e della comunicazione, dell'efficienza della rete distributiva e commerciale, del monitoraggio delle vendite e del gradimento sul mercato dei beni o dei servizi prodotti, sia pubblici che d'impresa."
        },
        {
          "code" : "2.5.1.5.4",
          "display" : "Analisti di mercato",
          "definition" : "Le professioni comprese in questa unità conducono ricerche sulle condizioni di mercato a diversi livelli territoriali per individuare le possibilità di penetrazione commerciale di prodotti o servizi; ne individuano le situazioni di competizione, i prezzi e le modalità di vendita e di distribuzione."
        },
        {
          "code" : "2.5.1.6",
          "display" : "Specialisti nelle relazioni pubbliche, dell'immagine e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria promuovono le relazioni pibbliche e l'immagine di un’impresa o di un'organizzazione, scrivendo testi, selezionando e diffondendo materiale pubblicistico favorevole, organizzando e sponsorizzando eventi di particolare importanza e visibilità, attività benefiche a favore della popolazione e attività similari non direttamente collegate alla promozione pubblicitaria."
        },
        {
          "code" : "2.5.1.6.0",
          "display" : "Specialisti delle relazioni pubbliche, dell'immagine e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità promuovono le relazioni pubbliche e l'immagine di un’impresa o di un'organizzazione scrivendo testi, selezionando e diffondendo materiale pubblicistico favorevole, organizzando e sponsorizzando eventi di particolare importanza e visibilità, attività benefiche a favore della popolazione e attività similari non direttamente collegate alla promozione pubblicitaria."
        },
        {
          "code" : "2.5.2",
          "display" : "Specialisti in scienze giuridiche",
          "definition" : "Le professioni comprese in questa classe conducono ricerche e approfondiscono questioni legali, normative e regolamentari; forniscono consulenze in materia legale a persone ed organizzazioni; tutelano e garantiscono la pubblicità, la liceità e l’autenticità degli atti tra vivi; esercitano l’azione penale a tutela dei cittadini; giudicano e applicano la legge nel processo penale, civile e amministrativo."
        },
        {
          "code" : "2.5.2.1",
          "display" : "Procuratori legali ed avvocati",
          "definition" : "Le professioni comprese in questa categoria rappresentano e tutelano gli interessi di persone e organizzazioni nelle procedure legali e nei diversi gradi dei processi penali, civili e amministrativi; stilano documenti, contratti e forniscono consulenze legali in materia di transazioni e di atti fra vivi."
        },
        {
          "code" : "2.5.2.1.0",
          "display" : "Avvocati",
          "definition" : "Le professioni comprese in questa unità rappresentano e tutelano gli interessi di persone e organizzazioni nelle procedure legali e nei diversi gradi dei processi penali, civili e amministrativi; stilano documenti, contratti e forniscono consulenze legali in materia di transazioni e di atti fra persone in vita. L’esercizio della professione di Avvocato è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.5.2.2",
          "display" : "Esperti legali in imprese o enti pubblici",
          "definition" : "Le professioni comprese in questa categoria affrontano, gestendo e coordinando le attività di appositi uffici, gli aspetti legali propri delle attività di organizzazioni, imprese o della stessa Amministrazione Pubblica, rappresentandole e tutelandone – eventualmente – gli interessi nelle procedure legali, nei diversi gradi dei processi penali, civili ed amministrativi; stilando documenti, contratti e altri atti legali."
        },
        {
          "code" : "2.5.2.2.1",
          "display" : "Esperti legali in imprese",
          "definition" : "Le professioni comprese in questa unita affrontano, gestendo e coordinando le attività di appositi uffici, gli aspetti legali propri delle attività di imprese, rappresentandole e tutelandone eventualmente gli interessi nelle procedure legali, nei diversi gradi dei processi penali, civili ed amministrativi; stilando documenti, contratti e altri atti legali. L’esercizio della professione di Consulente in proprietà industriale è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.5.2.2.2",
          "display" : "Esperi legali in enti pubblici",
          "definition" : "Le professioni comprese in questa unità affrontano, gestendo e coordinando le attività di appositi uffici, gli aspetti legali propri delle attività di organizzazioni o della stessa Amministrazione Pubblica, rappresentandole e tutelandone eventualmente gli interessi nelle procedure legali, nei diversi gradi dei processi penali, civili ed amministrativi; stilando documenti, contratti e altri atti legali."
        },
        {
          "code" : "2.5.2.3",
          "display" : "Notai",
          "definition" : "Le professioni comprese in questa categoria ricevono e redigono gli atti tra vivi e di ultima volontà; attribuiscono loro pubblica fede; li conservano; ne rilasciano copia, estratti e certificazioni; accertano la volontà dei contraenti e la traducono in linguaggio giuridico, garantendo la legalità dell’atto così messo in essere; consigliano alle parti l’atto più idoneo a raggiungere gli obiettivi prefissati; verificano la legalità dei contenuti oggetto degli accordi e delle transazioni."
        },
        {
          "code" : "2.5.2.3.0",
          "display" : "Notai",
          "definition" : "Le professioni comprese in questa unità ricevono e redigono gli atti tra persone in vita e di ultima volontà; attribuiscono loro pubblica fede; li conservano; ne rilasciano copia, estratti e certificazioni; accertano la volontà dei contraenti e la traducono in linguaggio giuridico, garantendo la legalità dell’atto così messo in essere; consigliano alle parti l’atto più idoneo a raggiungere gli obiettivi prefissati; verificano la legalità dei contenuti oggetto degli accordi e delle transazioni. L’esercizio della professione di Notaio è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.5.2.4",
          "display" : "Magistrati",
          "definition" : "Le professioni comprese in questa categoria accertano le condizioni dell’azione penale e la esercitano; amministrano la giustizia penale, civile, amministrativa ed ecclesiastica nei diversi gradi del processo; controllano la liceità e la congruenza alle leggi e ai regolamenti della spesa pubblica; conducono arbitrati."
        },
        {
          "code" : "2.5.2.4.0",
          "display" : "Magistrati",
          "definition" : "Le professioni comprese in questa unità accertano le condizioni dell’azione penale e la esercitano; amministrano la giustizia penale, civile, amministrativa ed ecclesiastica nei diversi gradi del processo; controllano la liceità e la congruenza alle leggi e ai regolamenti della spesa pubblica; conducono arbitrati."
        },
        {
          "code" : "2.5.3",
          "display" : "Specialisti in scienze sociali",
          "definition" : "Le professioni comprese in questa classe conducono ricerche su concetti e teorie fondamentali e incrementano la conoscenza scientifica, ovvero applicano le conoscenze esistenti in materia di economia, scienza politica, sociologia, antropologia, psicologia, filosofia, storia ed altre scienze sociali per individuare soluzioni a problemi economici, sociali e politici, analizzare gli eventi del passato remoto o recente per ricostruire la storia delle nazioni e dei popoli, capirne la cultura materiale e simbolica, ricostruire e individuare i processi mentali di individui e gruppi e le loro patologie, fornire servizi ai cittadini."
        },
        {
          "code" : "2.5.3.1",
          "display" : "Specialisti in scienze economiche",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche su concetti, teorie e metodi per analizzare e comprendere il funzionamento del mercato dei beni e dei servizi; per individuare soluzioni ai problemi economici e programmare le politiche di sostegno e di regolazione dell’economia. Analizzano la strategia, la struttura e il ciclo di produzione di imprese o di organizzazioni per migliorarne le prestazioni e individuare le risposte più adeguate alle sollecitazioni provenienti dal sistema economico."
        },
        {
          "code" : "2.5.3.1.1",
          "display" : "Specialisti dei sistemi economici",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti, teorie e metodi per analizzare e comprendere il funzionamento del mercato dei beni e dei servizi, per individuare soluzioni ai problemi economici, programmare e supportare la realizzazione delle politiche di sostegno e di regolazione dell’economia."
        },
        {
          "code" : "2.5.3.1.2",
          "display" : "Specialisti dell'economia aziendale",
          "definition" : "Le professioni comprese in questa unità conducono ricerche su concetti, teorie e metodi per analizzare la strategia, la struttura e il ciclo di produzione di imprese o di organizzazioni per migliorarne le prestazioni e individuare le risposte più adeguate alle sollecitazioni provenienti dal sistema economico."
        },
        {
          "code" : "2.5.3.2",
          "display" : "Specialisti in scienze sociologiche e antropologiche",
          "definition" : "Le professioni comprese in questa categoria studiano e descrivono le strutture dei sistemi sociali, i gruppi sociali e le istituzioni che li costituiscono; progettano interventi nel campo delle politiche e dei servizi sociali; studiano l’origine e l’evoluzione del modo di vivere dei popoli, del loro agire collettivo e delle strutture sociali che li hanno caratterizzati; ricostruiscono la loro cultura materiale e la loro storia attraverso reperti provenienti da scavi o da altre metodologie di indagine archeologica. Studiano la natura e l’uso della superficie terrestre individuando le interrelazioni fra fenomeni fisici, naturali e antropici, il clima, la flora, la fauna e le implicazioni sulle attività umane e sull’organizzazione sociale, politica ed economica dei luoghi."
        },
        {
          "code" : "2.5.3.2.1",
          "display" : "Esperti nello studio, nella gestione e nel controllo dei fenomeni sociali",
          "definition" : "Le professioni comprese in questa unità studiano e descrivono le strutture dei sistemi sociali, le popolazioni, i gruppi sociali e le istituzioni che li costituiscono, progettano, dirigono e valutano interventi nel campo delle politiche e dei servizi sociali. La professione di Assistente sociale specialista è regolata dalle leggi dello Stato."
        },
        {
          "code" : "2.5.3.2.2",
          "display" : "Antropologi",
          "definition" : "Le professioni comprese in questa unità studiano i caratteri morfologici e le attitudini della specie umana nel corso dei processi evolutivi e del presente, l’origine e l’evoluzione della cultura, dei costumi e del modo di vita dei popoli, del loro agire collettivo e delle strutture sociali che li hanno caratterizzati."
        },
        {
          "code" : "2.5.3.2.3",
          "display" : "Geografi",
          "definition" : "Le professioni comprese in questa unità studiano la natura e l’uso della superficie terrestre individuando le interrelazioni fra fenomeni fisici, naturali e antropici, il clima, la flora, la fauna e le implicazioni sulle attività umane e sull’organizzazione sociale, politica ed economica dei luoghi."
        },
        {
          "code" : "2.5.3.2.4",
          "display" : "Archeologi",
          "definition" : "Le professioni comprese in questa unità ricostruiscono la cultura materiale e la storia dei popoli attraverso reperti provenienti da scavi o da altre metodologie di indagine archeologica."
        },
        {
          "code" : "2.5.3.3",
          "display" : "Specialisti in scienze psicologiche e psicoterapeutiche",
          "definition" : "Le professioni comprese in questa categoria studiano i processi mentali e i comportamenti di individui e di gruppi; diagnosticano e trattano disabilità cognitive, problemi e disordini mentali, comportamentali ed emotivi; intervengono per migliorarne il benessere psichico, promuoverne l’adattamento sociale, educativo e lavorativo; studiano gli assetti di imprese e organizzazioni e applicano i principi della psicologia per affrontare problemi di produttività del lavoro e gestione del personale, disegnare e programmare politiche di sviluppo delle carriere e della formazione della forza lavoro. L’esercizio della professione di Psicologo è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.5.3.3.1",
          "display" : "Psicologi clinici e psicoterapeuti",
          "definition" : "Le professioni comprese in questa unità studiano i processi mentali e i comportamenti di individui e di gruppi; diagnosticano e trattano disabilità cognitive, problemi e disordini mentali, comportamentali ed emotivi. L’esercizio della professione di Psicoterapeuta è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.5.3.3.2",
          "display" : "Psicologi dello sviluppo e dell’educazione",
          "definition" : "Le professioni comprese in questa unità studiano i processi mentali e i comportamenti di individui e di gruppi; intervengono per migliorarne il benessere psichico, promuoverne l’adattamento sociale, educativo e lavorativo."
        },
        {
          "code" : "2.5.3.3.3",
          "display" : "Psicologi del lavoro e delle organizzazioni",
          "definition" : "Le professioni comprese in questa unità professionale studiano i processi mentali e i comportamenti di individui e di gruppi; studiano gli assetti di imprese e organizzazioni e applicano i principi della psicologia per affrontare problemi di produttività del lavoro e gestione del personale, disegnare e programmare politiche di sviluppo delle carriere e della formazione della forza lavoro."
        },
        {
          "code" : "2.5.3.4",
          "display" : "Specialisti in scienze storiche, artistiche, politiche e filosofiche",
          "definition" : "Le professioni comprese in questa categoria studiano, descrivono e interpretano gli eventi del passato utilizzando fonti di varia natura, ricostruendo la storia di popoli e nazioni; l’origine, lo sviluppo, il funzionamento e le logiche dei sistemi e delle ideologie politiche; le relazioni diplomatiche, economiche e politiche fra gli Stati; i modi di costruzione delle decisioni politiche, le loro interrelazioni con l’opinione pubblica; l’attività dei governi e dei partiti, le ragioni e le conseguenze dei risultati elettorali; conducono ricerche nei campi dell’epistemologia, della metafisica, dell’etica, dell’estetica e della filosofia in generale; nei campi della storia dell’arte e della produzione estetica e applicano tali conoscenze per valutare, identificare e promuovere opere d’arte ed artisti."
        },
        {
          "code" : "2.5.3.4.1",
          "display" : "Storici",
          "definition" : "Le professioni comprese in questa unità studiano, descrivono e interpretano gli eventi del passato utilizzando fonti di varia natura, ricostruendo la storia di popoli e nazioni."
        },
        {
          "code" : "2.5.3.4.2",
          "display" : "Esperti d’arte",
          "definition" : "Le professioni comprese in questa unità conducono ricerche nel campo della storia dell’arte e della produzione estetica e applicano tali conoscenze per valutare, identificare e promuovere opere d’arte ed artisti."
        },
        {
          "code" : "2.5.3.4.3",
          "display" : "Specialisti in scienza politica",
          "definition" : "Le professioni comprese in questa unità studiano, descrivono e interpretano l’origine, lo sviluppo, il funzionamento e le logiche dei sistemi e delle ideologie politiche, le relazioni diplomatiche, economiche e politiche fra gli Stati, i modi di costruzione delle decisioni politiche, le loro interrelazioni con l’opinione pubblica, l’attività dei governi e dei partiti, le ragioni e le conseguenze dei risultati elettorali."
        },
        {
          "code" : "2.5.3.4.4",
          "display" : "Filosofi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche nel campo dell’epistemologia, della metafisica, dell’etica, dell’estetica e della filosofia in generale."
        },
        {
          "code" : "2.5.4",
          "display" : "Specialisti in discipline linguistiche, letterarie e documentali",
          "definition" : "Le professioni comprese in questa classe concepiscono e creano opere di scrittura letteraria e professionale; comunicano fatti di cronaca e informazioni di pubblica utilità e di settore; traducono e interpretano testi scritti, segni o discorsi da un'altra lingua; conducono ricerche sul linguaggio, sulle relazioni fra lingue antiche e moderne, sulle varietà linguistiche e sulla comparazione delle lingue, sulle interazioni fra linguistica e ICT; conservano documenti, libri, contenuti digitali, beni archeologici, storici, artistici e culturali."
        },
        {
          "code" : "2.5.4.1",
          "display" : "Scrittori e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria concepiscono, creano e rendono disponibili al pubblico opere di scrittura letteraria e professionale; scrivono soggetti e dialoghi per il cinema, la radio e la televisione, testi e libretti da musicare; redigono testi informativi, tecnico-operativi e pubblicitari di beni e servizi da diffondere a mezzo stampa, radiotelevisione e altri mezzi di comunicazione mediatica; scrivono manuali, guide, appendici tecniche, fogli, testi informativi e libretti di istruzione per servizi e beni di consumo, macchine e attrezzature."
        },
        {
          "code" : "2.5.4.1.1",
          "display" : "Scrittori e poeti",
          "definition" : "Le professioni comprese in questa unità concepiscono, creano e rendono disponibili al pubblico opere di scrittura letteraria e professionale."
        },
        {
          "code" : "2.5.4.1.2",
          "display" : "Dialoghisti e parolieri",
          "definition" : "Le professioni comprese in questa unità scrivono soggetti e dialoghi per il cinema, la radio e la televisione, testi e libretti da musicare."
        },
        {
          "code" : "2.5.4.1.3",
          "display" : "Redattori di testi per la pubblicità",
          "definition" : "Le professioni comprese in questa unità redigono testi informativi e pubblicitari di beni e servizi da diffondere a mezzo stampa, radiotelevisione e altri mezzi di comunicazione mediatica."
        },
        {
          "code" : "2.5.4.1.4",
          "display" : "Redattori di testi tecnici",
          "definition" : "Le professioni comprese in questa unità scrivono manuali, guide, appendici tecniche, fogli, testi informativi e libretti di istruzione per beni di consumo, macchine e attrezzature."
        },
        {
          "code" : "2.5.4.2",
          "display" : "Giornalisti",
          "definition" : "Le professioni comprese in questa categoria raccolgono, riportano e commentano notizie o vicende di cronaca da pubblicare su quotidiani, periodici, radio-televisione, siti Internet ed altri mezzi di comunicazione mediatica; intervistano altre persone su questioni di varia natura; scrivono editoriali ed esprimono opinioni su fatti ed avvenimenti, rivedono, selezionano e organizzano articoli ed altri materiali informativi per la pubblicazione, nel rispetto delle leggi sulla privacy."
        },
        {
          "code" : "2.5.4.2.0",
          "display" : "Giornalisti",
          "definition" : "Le professioni comprese in questa unità raccolgono, riportano e commentano notizie o vicende di cronaca da pubblicare su quotidiani, periodici, radio-televisione, siti Internet ed altri mezzi di comunicazione mediatica; intervistano altre persone su questioni di varia natura; scrivono editoriali ed esprimono opinioni su fatti ed avvenimenti; rivedono, selezionano e organizzano articoli ed altri materiali informativi per la pubblicazione, nel rispetto delle leggi sulla privacy. L’esercizio della professione di Giornalista è regolato dalle leggi dello Stato."
        },
        {
          "code" : "2.5.4.3",
          "display" : "Interpreti e traduttori a livello elevato",
          "definition" : "Le professioni comprese in questa categoria traducono testi da una lingua ad un’altra assicurando che venga mantenuto il corretto significato del testo originale, che il significato di testi legali, scientifici, tecno-operativi e istituzionali sia correttamente reso e che la fraseologia, la terminologia, lo spirito e lo stile dei testi scritti e orali sia trasmesso nel modo più adeguato; interpretano discorsi da una lingua ad un’altra in convegni, trattative o in altre occasioni assicurando che siano trasmessi il corretto significato e lo spirito del discorso originale."
        },
        {
          "code" : "2.5.4.3.0",
          "display" : "Interpreti e traduttori di livello elevato",
          "definition" : "Le professioni comprese in questa unità traducono testi da una lingua ad un’altra assicurando che venga mantenuto il corretto significato del testo originale, che il significato di testi legali, scientifici, tecno-operativi e istituzionali sia correttamente reso e che la fraseologia, la terminologia, lo spirito e lo stile dei testi scritti e orali sia trasmesso nel modo più adeguato; interpretano discorsi da una lingua ad un’altra in convegni, trattative o in altre occasioni assicurando che siano trasmessi il corretto significato e lo spirito del discorso originale."
        },
        {
          "code" : "2.5.4.4",
          "display" : "Linguisti, filologi e revisori di testi",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche e studi sull’origine, l’evoluzione e la struttura delle lingue, le relazioni fra lingue antiche dello stesso ceppo e lingue moderne, le grammatiche ed i vocaboli, le interazioni tra linguistica e ICT, ovvero applicano le conoscenze in materia linguistica per la revisione critica di testi scritti da pubblicare, audiovisivi e multimediali."
        },
        {
          "code" : "2.5.4.4.1",
          "display" : "Linguisti e filologi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche e studi sull’origine, l’evoluzione e la struttura delle lingue, le relazioni fra lingue antiche dello stesso ceppo e lingue moderne, le grammatiche ed i vocaboli, le interazioni fra linguistica e ICT."
        },
        {
          "code" : "2.5.4.4.2",
          "display" : "Revisori di testi",
          "definition" : "Le professioni comprese in questa unità applicano le conoscenze in materia linguistica per la revisione critica di testi scritti da pubblicare, audiovisivi e multimediali."
        },
        {
          "code" : "2.5.4.5",
          "display" : "Archivisti, bibliotecari, conservatori di musei e professioni assimilate",
          "definition" : "Le professioni comprese nella categoria conducono ricerche, acquisiscono, valutano e garantiscono la conservazione di archivi correnti, di deposito o storici di particolare interesse, di artefatti di interesse storico, culturale o artistico, di opere d’arte e di libri. Provvedono alla loro indicizzazione, classificazione e catalogazione; ne garantiscono la conservazione, l’accessibilità e la fruizione pubblica; li rendono disponibili su microfilm, supporti digitali o di altra natura; organizzano attività di promozione, mostre ed eventi."
        },
        {
          "code" : "2.5.4.5.1",
          "display" : "Archivisti",
          "definition" : "Le professioni comprese in questa unità conducono ricerche, acquisiscono, valutano e garantiscono la conservazione di archivi correnti, di deposito o storici di particolare interesse, ne garantiscono la conservazione, l’accessibilità e la fruizione pubblica, li rendono disponibili su microfilm, supporti digitali o di altra natura; organizzano attività di promozione, mostre ed eventi."
        },
        {
          "code" : "2.5.4.5.2",
          "display" : "Bibliotecari",
          "definition" : "Le professioni comprese in questa unità provvedono alla indicizzazione, classificazione e catalogazione di libri, ne garantiscono la conservazione, l’accessibilità e la fruizione pubblica; li rendono disponibili su microfilm, supporti digitali o di altra natura; organizzano attività di promozione, mostre ed eventi."
        },
        {
          "code" : "2.5.4.5.3",
          "display" : "Curatori e conservatori di musei",
          "definition" : "Le professioni comprese in questa unità conducono ricerche, acquisiscono, valutano e garantiscono la conservazione di artefatti di interesse storico, culturale o artistico e di opere d’arte; ne rendono disponibile la documentazione su microfilm, supporti digitali o di altra natura; organizzano attività di promozione, mostre ed eventi."
        },
        {
          "code" : "2.5.5",
          "display" : "Specialisti in discipline artistico-espressive",
          "definition" : "Le professioni comprese nella classe concepiscono, creano ed eseguono performance artistiche nel campo del disegno, della pittura, della scultura, della rappresentazione teatrale, cinematografica, radiotelevisiva o di altro tipo, della coreutica, della musica o del canto, ovvero applicano conoscenze e capacità artistiche per fornire servizi, restaurare opere d’arte, eseguire composizioni musicali vocali e strumentali."
        },
        {
          "code" : "2.5.5.1",
          "display" : "Pittori, scultori, disegnatori e restauratori di beni culturali",
          "definition" : "Le professioni classificate nella categoria conducono ricerche sui modi della conoscenza e della rappresentazione estetica, creano e realizzano opere d’arte dipingendo, disegnando e scolpendo con tecniche diverse, rappresentazioni originali della realtà ovvero utilizzano tecniche, conoscenze e capacità artistiche per fornire servizi e prodotti artistici commerciali, nuovi artefatti digitali o prodotti industriali e bozzetti per la pubblicità; per recuperare, restaurare e conservare beni culturali."
        },
        {
          "code" : "2.5.5.1.1",
          "display" : "Pittori e scultori",
          "definition" : "Le professioni comprese in questa unità conducono ricerche sui modi della conoscenza e della rappresentazione estetica, creano e realizzano opere d’arte dipingendo, disegnando e scolpendo con tecniche diverse, rappresentazioni originali della realtà."
        },
        {
          "code" : "2.5.5.1.2",
          "display" : "Disegnatori artistici e illustratori",
          "definition" : "Le professioni comprese in questa unità utilizzano tecniche, conoscenze e capacità artistiche per creare prodotti artistici a fini decorativi, illustrativi e commerciali."
        },
        {
          "code" : "2.5.5.1.3",
          "display" : "Disegnatori di moda",
          "definition" : "Le professioni classificate nell'unità producono, utilizzando varie tecniche di disegno artistico, schizzi, bozzetti, disegni di dettaglio ed elaborati grafici finalizzati alla produzione di abiti, lingerie, calzature e altri accessori di abbigliamento."
        },
        {
          "code" : "2.5.5.1.4",
          "display" : "Creatori artistici a fini commerciali (esclusa la moda)",
          "definition" : "Le professioni classificate nell'unità creano, utilizzando varie tecniche di espressione artistica, bozzetti, disegni di dettaglio, elaborati grafici anche digitali finalizzati alla progettazione di nuovi artefatti digitali o prodotti industriali, al restyling di prodotti già in commercio e alla comunicazione pubblicitaria."
        },
        {
          "code" : "2.5.5.1.5",
          "display" : "Restauratori di beni culturali",
          "definition" : "Le professioni comprese in questa unità utilizzano tecniche, conoscenze e capacità artistiche per recuperare, restaurare e conservare opere d’arte. L’esercizio della professione di restauratore di beni culturali è regolata dalle leggi dello Stato."
        },
        {
          "code" : "2.5.5.2",
          "display" : "Registi, direttori artistici, attori, sceneggiatori e scenografi",
          "definition" : "Le professioni classificate nella categoria concepiscono, programmano e dirigono opere radio-televisive, cinematografiche, teatrali, altri tipi di rappresentazioni pubbliche; stagioni e performance artistiche; interpretano personaggi e ruoli da rappresentare; narrano i soggetti considerando l’azione teatrale, cinematografica, televisiva e radiofonica; progettano e realizzano le scene."
        },
        {
          "code" : "2.5.5.2.1",
          "display" : "Registi",
          "definition" : "Le professioni comprese in questa unità concepiscono e dirigono opere radio-televisive, cinematografiche, teatrali, altri tipi di rappresentazioni pubbliche e performance artistiche"
        },
        {
          "code" : "2.5.5.2.2",
          "display" : "Attori",
          "definition" : "Le professioni comprese in questa unità interpretano personaggi e ruoli da rappresentare."
        },
        {
          "code" : "2.5.5.2.3",
          "display" : "Direttori artistici",
          "definition" : "Le professioni comprese in questa unità programmano, organizzano, indirizzano e curano rappresentazioni pubbliche, stagioni, rassegne, festival e performance artistiche, secondo determinati contenuti, scelte e linee artistico-culturali; indicano protagonisti, caratteristiche, tematiche e modalità di svolgimento."
        },
        {
          "code" : "2.5.5.2.4",
          "display" : "Sceneggiatori",
          "definition" : "Le professioni comprese in questa unità narrano i soggetti considerando l'azione teatrale, cinematografica, televisiva e radiofonica."
        },
        {
          "code" : "2.5.5.2.5",
          "display" : "Scenografi",
          "definition" : "Le professioni comprese in questa unità progettano e realizzano le scene di opere televisive, cinematografiche, teatrali e di altri tipi di rappresentazioni pubbliche."
        },
        {
          "code" : "2.5.5.3",
          "display" : "Coreografi e ballerini",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche sui modi della conoscenza e della rappresentazione estetica in ambito coreutico, concepiscono, creano o eseguono balletti da solisti o con partner, interpretando e rappresentando con la danza significati di narrazioni o di composizioni e brani musicali."
        },
        {
          "code" : "2.5.5.3.1",
          "display" : "Coreografi",
          "definition" : "Le professioni comprese in questa unità conducono ricerche sulle modalità della rappresentazione estetica in ambito coreutico; concepiscono e creano balletti."
        },
        {
          "code" : "2.5.5.3.2",
          "display" : "Ballerini",
          "definition" : "Le professioni comprese in questa unità eseguono balletti da solisti o con partner, interpretando con la danza significati di narrazioni o di composizioni e brani musicali."
        },
        {
          "code" : "2.5.5.4",
          "display" : "Compositori, musicisti e cantanti",
          "definition" : "Le professioni comprese in questa categoria conducono ricerche sui modi della conoscenza e della rappresentazione estetica in ambito musicale; concepiscono, creano e eseguono composizioni e brani musicali; dirigono orchestre e cori interpretando i brani da realizzare; interpretano ed eseguono partiture, brani e concerti utilizzando strumenti musicali di vario tipo da solisti, in orchestre o in gruppi musicali, ovvero applicano le conoscenze in campo musicale per adattare, arrangiare ed eseguire brani; concepiscono, interpretano ed eseguono brani e rappresentazioni canore da solisti, in coro, con partner o gruppi musicali in performance e rappresentazioni artistiche di vario tipo, anche attraverso i mezzi di comunicazione di massa."
        },
        {
          "code" : "2.5.5.4.1",
          "display" : "Compositori",
          "definition" : "Le professioni comprese in questa unità conducono ricerche sulle modalità della rappresentazione estetica in ambito musicale; concepiscono e creano composizioni e brani musicali."
        },
        {
          "code" : "2.5.5.4.2",
          "display" : "Direttori d'orchestra e coro",
          "definition" : "Le professioni comprese in questa unità conducono ricerche sulle modalità della rappresentazione estetica in ambito musicale; dirigono orchestre e cori interpretando i brani da realizzare; applicano le conoscenze in campo musicale per adattare e arrangiare brani."
        },
        {
          "code" : "2.5.5.4.3",
          "display" : "Strumentisti",
          "definition" : "Le professioni comprese in questa unità interpretano ed eseguono partiture, brani e concerti utilizzando strumenti musicali di vario tipo da solisti, in orchestre o in gruppi musicali; applicano le conoscenze in campo musicale per arrangiare ed eseguire brani."
        },
        {
          "code" : "2.5.5.4.4",
          "display" : "Cantanti",
          "definition" : "Le professioni comprese in questa unità conducono ricerche sulle modalità della rappresentazione estetica in ambito musicale; concepiscono, interpretano ed eseguono brani e rappresentazioni canore da solisti, in coro, con partner o gruppi musicali, in performance e rappresentazioni artistiche di vario tipo, anche attraverso i mezzi di comunicazione di massa."
        },
        {
          "code" : "2.5.5.5",
          "display" : "Artisti delle forme di cultura popolare, di varietà e acrobati",
          "definition" : "Le professioni comprese nella categoria eseguono performance artistiche, acrobatiche e ricreative per strada, nelle piazze, in varietà teatrali, musicali, nei locali pubblici e nei circhi."
        },
        {
          "code" : "2.5.5.5.1",
          "display" : "Artisti delle forme di cultura popolare",
          "definition" : "Le professioni comprese in questa unità eseguono performance artistiche, acrobatiche e ricreative per strada e nelle piazze."
        },
        {
          "code" : "2.5.5.5.2",
          "display" : "Artisti di varietà",
          "definition" : "Le professioni classificate nell'unità eseguono performance artistiche, acrobatiche e ricreative in varietà teatrali, musicali e nei locali pubblici."
        },
        {
          "code" : "2.5.5.5.3",
          "display" : "Acrobati e artisti circensi",
          "definition" : "Le professioni classificate nell'unità eseguono performance artistiche, acrobatiche e ricreative nei circhi."
        },
        {
          "code" : "2.5.6",
          "display" : "Specialisti in discipline religiose e teologiche",
          "definition" : "Le professioni comprese in questa classe conservano, tramandano e diffondono tradizioni, pratiche e credenze religiose, celebrano e amministrano riti, cerimonie ed eventi sacri."
        },
        {
          "code" : "2.5.6.1",
          "display" : "Specialisti in discipline religiose e teologiche",
          "definition" : "Le professioni comprese nella categoria conducono studi e ricerche in campo teologico, ovvero forniscono servizi religiosi e spirituali associati alla pratica di una fede religiosa; fungono da guida morale e spirituale ai praticanti; programmano, dirigono e coordinano le attività delle organizzazioni religiose e delle comunità dei credenti; promuovono e propagandano la fede e la dottrina religiosa."
        },
        {
          "code" : "2.5.6.1.0",
          "display" : "Specialisti in discipline religiose e teologiche",
          "definition" : "Le professioni comprese in questa unità conducono studi e ricerche in campo teologico, ovvero forniscono servizi religiosi e spirituali associati alla pratica di una fede religiosa; fungono da guida morale e spirituale ai praticanti; programmano, dirigono e coordinano le attività delle organizzazioni religiose e delle comunità dei credenti; promuovono e propagandano la fede e la dottrina religiosa."
        },
        {
          "code" : "2.6",
          "display" : "Specialisti della formazione e della ricerca",
          "definition" : "Le professioni classificate in questo gruppo conducono ricerche su concetti e teorie; incrementano la conoscenza in ambito scientifico; insegnano la teoria e la pratica di una o più discipline nei diversi livelli di istruzione; progettano i relativi curricula formativi; introducono, ricercano, adottano ed applicano metodi didattici; partecipano alla programmazione e all’organizzazione didattica e alla definizione dell’offerta formativa delle scuole e delle università."
        },
        {
          "code" : "2.6.1",
          "display" : "Docenti universitari (ordinari e associati)",
          "definition" : "Le professioni comprese in questa classe progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.1",
          "display" : "Docenti universitari in scienze matematiche e dell'informazione, fisiche, chimiche e della terra",
          "definition" : "Le professioni comprese in questa categoria progettano, dirigono e conducono ricerche finalizzate a migliorare, ad innovare e ad applicare nei settori produttivi la conoscenza scientifica negli ambiti disciplinari afferenti alle scienze matematiche e dell'informazione, alle scienze fisiche, chimiche e della terra; insegnano la teoria e la pratica di una o più discipline, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.1.1",
          "display" : "Docenti universitari in scienze matematiche e dell'informazione",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.1.2",
          "display" : "Docenti universitari in scienze fisiche",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.1.3",
          "display" : "Docenti universitari in scienze chimiche e farmaceutiche",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.1.4",
          "display" : "Docenti universitari in scienze della terra",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.2",
          "display" : "Docenti universitari in scienze della vita e della salute",
          "definition" : "Le professioni comprese in questa categoria progettano, dirigono e conducono ricerche finalizzate a migliorare, ad innovare e ad applicare nei settori produttivi la conoscenza scientifica negli ambiti disciplinari afferenti alla biologia, alla botanica, alla zoologia, alle scienze agrarie e veterinarie, alla medicina; insegnano la teoria e la pratica di una o più discipline, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.2.1",
          "display" : "Docenti universitari in scienze biologiche",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.2.2",
          "display" : "Docenti universitari in scienze agrarie, zootecniche e della produzione animale",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.2.3",
          "display" : "Docenti universitari in scienze mediche",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.3",
          "display" : "Docenti universitari in scienze ingegneristiche e dell'architettura",
          "definition" : "Le professioni comprese in questa categoria progettano, dirigono e conducono ricerche finalizzate a migliorare, ad innovare e ad applicare nei settori produttivi la conoscenza scientifica negli ambiti disciplinari afferenti all'ingegneria e all’architettura; insegnano la teoria e la pratica di una o più discipline, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.3.1",
          "display" : "Docenti universitari in scienze ingegneristiche civili e dell’architettura",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.3.2",
          "display" : "Docenti universitari in scienze ingegneristiche industriali e dell’informazione",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.4",
          "display" : "Docenti universitari in scienze dell'antichità, filologico-letterarie e storico-artistiche",
          "definition" : "Le professioni comprese in questa categoria progettano, dirigono e conducono ricerche finalizzate a migliorare, ad innovare e ad applicare nei settori produttivi la conoscenza scientifica negli ambiti disciplinari afferenti alle scienze dell'antichità, alle scienze filologico-letterarie e storico-artistiche; insegnano la teoria e la pratica di una o più discipline, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.4.0",
          "display" : "Docenti universitari in scienze dell'antichità, filologico-letterarie e storico-artistiche",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.5",
          "display" : "Docenti universitari in scienze storiche, filosofiche, pedagogiche e psicologiche",
          "definition" : "Le professioni comprese in questa categoria progettano, dirigono e conducono ricerche finalizzate a migliorare, ad innovare e ad applicare nei settori produttivi la conoscenza scientifica negli ambiti disciplinari afferenti alle scienze storiche, filosofiche, pedagogiche e psicologiche; insegnano la teoria e la pratica di una o più discipline, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.5.1",
          "display" : "Docenti universitari in scienze storiche e filosofiche",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.5.2",
          "display" : "Docenti universitari in scienze pedagogiche e psicologiche",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.6",
          "display" : "Docenti universitari in scienze economiche e statistiche",
          "definition" : "Le professioni comprese in questa categoria progettano, dirigono e conducono ricerche finalizzate a migliorare, ad innovare e ad applicare nei settori produttivi la conoscenza scientifica negli ambiti disciplinari afferenti alle scienze economiche e statistiche; insegnano la teoria e la pratica di una o più discipline, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.6.0",
          "display" : "Docenti universitari in scienze economiche e statistiche",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.7",
          "display" : "Docenti universitari in scienze giuridiche, politiche e sociali",
          "definition" : "Le professioni comprese in questa categoria progettano, dirigono e conducono ricerche finalizzate a migliorare, ad innovare e ad applicare nei settori produttivi la conoscenza scientifica negli ambiti disciplinari afferenti alle scienze giuridiche, politiche e sociali; insegnano la teoria e la pratica di una o più discipline, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.7.1",
          "display" : "Docenti universitari in scienze giuridiche",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.1.7.2",
          "display" : "Docenti universitari in scienze politiche e sociali",
          "definition" : "Le professioni comprese in questa unità progettano, dirigono e conducono ricerche finalizzate a migliorare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; insegnano la teoria e la pratica di una o più discipline di cui sono esperti, ne definiscono i curricula, preparano i corsi di studio, i materiali didattici e le attività di laboratorio, stimolano la discussione e la partecipazione degli studenti alle lezioni, somministrano prove ed esami, assegnano tesi e ne danno valutazioni; dirigono le attività di ricerca degli studenti dei corsi di specializzazione e di dottorato; partecipano alle decisioni sulle politiche dell’Università; pubblicano articoli e saggi scientifici, partecipano a convegni e conferenze."
        },
        {
          "code" : "2.6.2",
          "display" : "Ricercatori e tecnici laureati nell'università",
          "definition" : "Le professioni comprese nella classe supportano i docenti universitari nelle attività didattiche e conducono ricerche in ambito scientifico; sono responsabili dei laboratori e curano l’applicazione dei protocolli scientifici nelle attività di ricerca."
        },
        {
          "code" : "2.6.2.1",
          "display" : "Ricercatori e tecnici laureati nelle scienze matematiche e dell'informazione, fisiche, chimiche, della terra",
          "definition" : "Le professioni comprese in questa categoria collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nella categoria svolgono le attività previste nell’ambito delle scienze matematiche e dell’informazione, delle scienze fisiche, chimiche e della terra."
        },
        {
          "code" : "2.6.2.1.1",
          "display" : "Ricercatori e tecnici laureati nelle scienze matematiche e dell’informazione",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell'unità professionale svolgono le attività previste nell’ambito delle scienze matematiche e dell’informazione."
        },
        {
          "code" : "2.6.2.1.2",
          "display" : "Ricercatori e tecnici laureati nelle scienze fisiche",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze fisiche."
        },
        {
          "code" : "2.6.2.1.3",
          "display" : "Ricercatori e tecnici laureati nelle scienze chimiche e farmaceutiche",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze chimiche e farmaceutiche."
        },
        {
          "code" : "2.6.2.1.4",
          "display" : "Ricercatori e tecnici laureati nelle scienze della terra",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze della terra."
        },
        {
          "code" : "2.6.2.2",
          "display" : "Ricercatori e tecnici laureati nelle scienze della vita e della salute",
          "definition" : "Le professioni comprese in questa categoria collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nella categoria svolgono le attività previste nell’ambito delle scienze della vita e della salute."
        },
        {
          "code" : "2.6.2.2.1",
          "display" : "Ricercatori e tecnici laureati nelle scienze biologiche",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze biologiche."
        },
        {
          "code" : "2.6.2.2.2",
          "display" : "Ricercatori e tecnici laureati nelle scienze agrarie, zootecniche e della produzione animale",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze agrarie, zootecniche e della produzione animale."
        },
        {
          "code" : "2.6.2.2.3",
          "display" : "Ricercatori e tecnici laureati nelle scienze mediche",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze mediche."
        },
        {
          "code" : "2.6.2.3",
          "display" : "Ricercatori e tecnici laureati nelle scienze ingegneristiche e dell'architettura",
          "definition" : "Le professioni comprese in questa categoria collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nella categoria svolgono le attività previste nell’ambito delle scienze ingegneristiche e dell'architettura."
        },
        {
          "code" : "2.6.2.3.1",
          "display" : "Ricercatori e tecnici laureati nelle scienze ingegneristiche civili e dell’architettura",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze ingegneristiche civili e dell’architettura."
        },
        {
          "code" : "2.6.2.3.2",
          "display" : "Ricercatori e tecnici laureati nelle scienze ingegneristiche industriali e dell’informazione",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze ingegneristiche industriali e dell'informazione."
        },
        {
          "code" : "2.6.2.4",
          "display" : "Ricercatori e tecnici laureati nelle scienze dell'antichità, filologico-letterarie e storico-artistiche",
          "definition" : "Le professioni comprese in questa categoria collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nella categoria svolgono le attività previste nell’ambito delle scienze dell'antichità, filologiche-letterarie e storico-artistiche."
        },
        {
          "code" : "2.6.2.4.0",
          "display" : "Ricercatori e tecnici laureati nelle scienze dell'antichità, filologico-letterarie e storico-artistiche",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze dell'antichità, filologico-letterarie e storico-artistiche."
        },
        {
          "code" : "2.6.2.5",
          "display" : "Ricercatori e tecnici laureati nelle scienze storiche, filosofiche, pedagogiche e psicologiche",
          "definition" : "Le professioni comprese in questa categoria collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nella categoria svolgono le attività previste nell’ambito delle scienze storiche, filosofiche, pedagogiche e psicologiche."
        },
        {
          "code" : "2.6.2.5.1",
          "display" : "Ricercatori e tecnici laureati nelle scienze storiche e filosofiche",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze storiche e filosofiche."
        },
        {
          "code" : "2.6.2.5.2",
          "display" : "Ricercatori e tecnici laureati nelle scienze pedagogiche e psicologiche",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze pedagogiche e psicologiche."
        },
        {
          "code" : "2.6.2.6",
          "display" : "Ricercatori e tecnici laureati nelle scienze economiche e statistiche",
          "definition" : "Le professioni comprese in questa categoria collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nella categoria svolgono le attività previste nell’ambito delle scienze economiche e statistiche."
        },
        {
          "code" : "2.6.2.6.0",
          "display" : "Ricercatori e tecnici laureati nelle scienze economiche e statistiche",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze economiche e statistiche."
        },
        {
          "code" : "2.6.2.7",
          "display" : "Ricercatori e tecnici laureati nelle scienze giuridiche, politiche e sociali",
          "definition" : "Le professioni comprese in questa categoria collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nella categoria svolgono le attività previste nell’ambito delle scienze giuridiche, politiche e sociali."
        },
        {
          "code" : "2.6.2.7.1",
          "display" : "Ricercatori e tecnici laureati nelle scienze giuridiche",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze giuridiche."
        },
        {
          "code" : "2.6.2.7.2",
          "display" : "Ricercatori e tecnici laureati nelle scienze politiche e sociali",
          "definition" : "Le professioni comprese in questa unità collaborano con i docenti universitari e li coadiuvano nella progettazione e nella realizzazione delle attività didattiche e curricolari; seguono le attività di studio degli studenti; progettano e conducono in ambito accademico ricerche teoriche e sperimentali finalizzate ad ampliare e ad innovare la conoscenza scientifica o la sua applicazione in ambito produttivo; garantiscono il funzionamento dei laboratori e delle attrezzature scientifiche; definiscono e applicano protocolli scientifici nelle sperimentazioni di laboratorio e nelle attività di ricerca. In particolare le professioni comprese nell’unità professionale svolgono le attività previste nell’ambito delle scienze politiche e sociali."
        },
        {
          "code" : "2.6.3",
          "display" : "Professori di scuola secondaria, post-secondaria e professioni assimilate",
          "definition" : "Le professioni classificate in questa classe insegnano la teoria e la pratica di una o più discipline nei cicli di istruzione post-primaria, esclusa l’istruzione universitaria, definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti, somministrano prove ed esami e valutano l’apprendimento degli allievi, partecipano alle decisioni sull’organizzazione scolastica, la didattica e l’offerta educativa e formativa, gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.3.1",
          "display" : "Professori delle accademie, dei conservatori e delle istituzioni scolastiche assimilate",
          "definition" : "Le professioni comprese in questa categoria esercitano le attività previste dalla classe nell’insegnamento di discipline artistiche nei cicli di istruzione post-secondaria delle Accademie, dei Conservatori musicali e degli Istituti superiori per le industrie artistiche, finalizzate a preparare gli allievi all’esercizio di attività artistiche nel campo della belle arti, della musica, della danza e dell’arte drammatica."
        },
        {
          "code" : "2.6.3.1.1",
          "display" : "Professori di discipline artistiche nelle accademie di belle arti e nelle istituzioni scolastiche assimilate",
          "definition" : "Le professioni comprese in questa unità insegnano la teoria e la pratica delle discipline artistiche nelle accademie di belle arti e nelle istituzioni scolastiche assimilate preparando gli allievi all'esercizio di attività artistiche nel campo delle belle arti; definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti; somministrano prove ed esami e valutano l’apprendimento degli allievi."
        },
        {
          "code" : "2.6.3.1.2",
          "display" : "Professori di discipline musicali nei conservatori e nelle istituzioni scolastiche assimilate",
          "definition" : "Le professioni comprese in questa unità insegnano la teoria e la pratica delle discipline musicali nei conservatori e nelle istituzioni scolastiche assimilate preparando gli allievi all'esercizio di attività artistiche nel campo della musica; definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti, somministrano prove ed esami e valutano l’apprendimento degli allievi."
        },
        {
          "code" : "2.6.3.1.3",
          "display" : "Professori di arte drammatica e danza nelle accademie e nelle istituzioni scolastiche assimilate",
          "definition" : "Le professioni comprese in questa unità insegnano la teoria e la pratica dell’arte drammatica e danza nei cicli di istruzione post-primaria, esclusa l’istruzione universitaria, preparando gli allievi all'esercizio di attività artistiche nel campo della danza e dell'arte drammatica; definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti, somministrano prove ed esami e valutano l’apprendimento degli allievi."
        },
        {
          "code" : "2.6.3.2",
          "display" : "Professori di scuola secondaria superiore",
          "definition" : "Le professioni comprese in questa categoria insegnano la teoria e la pratica di una o più discipline nei licei, negli istituti tecnici, professionali, d’arte e negli istituti magistrali, al fine di preparare gli allievi all'acquisizione di un titolo di studio, alla prosecuzione degli studi ed all’esercizio di attività lavorative. Definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti, somministrano prove ed esami e valutano l’apprendimento degli allievi, partecipano alle decisioni sull’organizzazione scolastica, sulla didattica e sull’offerta educativa e formativa, gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.3.2.1",
          "display" : "Professori di scienze matematiche, fisiche e chimiche nella scuola secondaria superiore",
          "definition" : "Le professioni comprese in questa unità insegnano la teoria e la pratica delle scienze matematiche, fisiche e chimiche nei licei, negli istituti tecnici, professionali, d’arte e negli istituti magistrali, preparando gli allievi all'acquisizione di un titolo di studio, alla prosecuzione degli studi e all'esercizio di attività lavorative; definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti, somministrano prove ed esami e valutano l’apprendimento degli allievi; partecipano alle decisioni sull’organizzazione scolastica, la didattica e l’offerta educativa e formativa; gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.3.2.2",
          "display" : "Professori di scienze della vita e della salute nella scuola secondaria superiore",
          "definition" : "Le professioni comprese in questa unità insegnano la teoria e la pratica delle scienze della vita e della salute nei licei, negli istituti tecnici, professionali, d’arte e negli istituti magistrali, preparando gli allievi all'acquisizione di un titolo di studio, alla prosecuzione degli studi e all'esercizio di attività lavorative; definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi; organizzano corsi per gli adulti, somministrano prove ed esami e valutano l’apprendimento degli allievi; partecipano alle decisioni sull’organizzazione scolastica, la didattica e l’offerta educativa e formativa, gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.3.2.3",
          "display" : "Professori di discipline tecnico-ingegneristiche nella scuola secondaria superiore",
          "definition" : "Le professioni comprese in questa unità insegnano la teoria e la pratica delle discipline tecnico-ingegneristiche negli istituti tecnici, professionali preparando gli allievi all'acquisizione di un titolo di studio, alla prosecuzione degli studi e all'esercizio di attività lavorative; definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti; somministrano prove ed esami e valutano l’apprendimento degli allievi; partecipano alle decisioni sull’organizzazione scolastica, la didattica e l’offerta educativa e formativa, gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.3.2.4",
          "display" : "Professori di scienze dell'informazione nella scuola secondaria superiore",
          "definition" : "Le professioni comprese in questa unità insegnano la teoria e la pratica delle scienze dell'informazione nei licei, negli istituti tecnici, professionali, d’arte e negli istituti magistrali, preparando gli allievi all'acquisizione di un titolo di studio, alla prosecuzione degli studi e all'esercizio di attività lavorative; definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi; organizzano corsi per gli adulti, somministrano prove ed esami e valutano l’apprendimento degli allievi, partecipano alle decisioni sull’organizzazione scolastica, la didattica e l’offerta educativa e formativa; gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.3.2.5",
          "display" : "Professori di scienze letterarie, artistiche, storiche, filosofiche, pedagogiche e psicologiche nella scuola secondaria superiore",
          "definition" : "Le professioni comprese in questa unità insegnano la teoria e la pratica delle scienze letterarie, artistiche, storiche, filosofiche, pedagogiche e psicologiche nei licei, negli istituti tecnici, professionali, d’arte e negli istituti magistrali, preparando gli allievi all'acquisizione di un titolo di studio, alla prosecuzione degli studi e all'esercizio di attività lavorative; definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti, somministrano prove ed esami e valutano l’apprendimento degli allievi; partecipano alle decisioni sull’organizzazione scolastica, la didattica e l’offerta educativa e formativa, gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.3.2.6",
          "display" : "Professori di scienze giuridiche, economiche e sociali nella scuola secondaria superiore",
          "definition" : "Le professioni comprese in questa unità insegnano la teoria e la pratica delle scienze giuridiche e sociali nei licei, negli istituti tecnici, professionali, d’arte e negli istituti magistrali, preparando gli allievi all'acquisizione di un titolo di studio, alla prosecuzione degli studi e all'esercizio di attività lavorative; definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti; somministrano prove ed esami e valutano l’apprendimento degli allievi, partecipano alle decisioni sull’organizzazione scolastica, la didattica e l’offerta educativa e formativa, gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.3.3",
          "display" : "Professori di scuola secondaria inferiore",
          "definition" : "Le professioni comprese in questa categoria insegnano la teoria e la pratica di una o più discipline al fine di completare l’alfabetizzazione degli allievi iniziata col ciclo primario, nell'ambito dell'obbligo scolastico. Definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti, somministrano prove ed esami e valutano l’apprendimento degli allievi, partecipano alle decisioni sull’organizzazione scolastica, sulla didattica e sull’offerta educativa e formativa, gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.3.3.1",
          "display" : "Professori di discipline umanistiche nella scuola secondaria inferiore",
          "definition" : "Le professioni comprese in questa unità insegnano la teoria e la pratica delle discipline umanistiche nella scuola secondaria inferiore, al fine di completare l'alfabetizzazione degli allievi iniziata con il ciclo primario, nell'ambito dell'obbligo scolastico; definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti, somministrano prove ed esami e valutano l’apprendimento degli allievi; partecipano alle decisioni sull’organizzazione scolastica, la didattica e l’offerta educativa e formativa, gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.3.3.2",
          "display" : "Professori di discipline tecniche e scientifiche nella scuola secondaria inferiore",
          "definition" : "Le professioni comprese in questa unità insegnano la teoria e la pratica delle discipline tecniche e scientifiche nella scuola secondaria inferiore, al fine di completare l'alfabetizzazione degli allievi iniziata con il ciclo primario, nell'ambito dell'obbligo scolastico; definiscono i curricula, gestiscono corsi e danno lezioni in una o più classi, organizzano corsi per gli adulti, somministrano prove ed esami e valutano l’apprendimento degli allievi; partecipano alle decisioni sull’organizzazione scolastica, la didattica e l’offerta educativa e formativa, gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.4",
          "display" : "Professori di scuola primaria, pre–primaria e professioni assimilate",
          "definition" : "Le professioni comprese in questa classe svolgono e somministrano un’ampia serie di attività didattiche orientate a fornire livelli di alfabetizzazione degli allievi, in grado di assicurare i processi di inclusione richiesti dal sistema sociale ed il raccordo con i cicli di istruzione successivi. Progettano e programmano dette attività, somministrano prove ed esami e valutano l’apprendimento degli allievi, partecipano alle decisioni sull’organizzazione scolastica sulla didattica e sull’offerta educativa; gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti, coadiuvano il personale specializzato nell'accompagnamento e nel supporto a singoli allievi in situazione di difficoltà cognitiva."
        },
        {
          "code" : "2.6.4.1",
          "display" : "Professori di scuola primaria",
          "definition" : "Le professioni comprese in questa categoria organizzano, progettano e realizzano attività didattiche finalizzate all’insegnamento ai bambini della lettura e della scrittura; delle strutture di base del linguaggio orale e scritto; dell’aritmetica, dei protocolli e dei linguaggi scientifici, della proiezione e della rappresentazione spaziale e temporale degli oggetti, delle persone, delle culture umane; allo sviluppo delle capacità psicomotorie, sociali e logiche. Programmano tali attività, somministrano prove ed esami e valutano l’apprendimento degli allievi, partecipano alle decisioni sull’organizzazione scolastica, la didattica e l’offerta educativa e formativa, coinvolgono i genitori nel processo di apprendimento dei figli."
        },
        {
          "code" : "2.6.4.1.0",
          "display" : "Professori di scuola primaria",
          "definition" : "Le professioni comprese in questa unità organizzano, progettano e realizzano attività didattiche finalizzate all’insegnamento ai bambini della lettura e della scrittura, delle strutture di base del linguaggio orale e scritto, dell’aritmetica, dei protocolli e dei linguaggi scientifici, della proiezione e della rappresentazione spaziale e temporale degli oggetti, delle persone, delle culture umane, nonché finalizzate allo sviluppo delle capacità psicomotorie, sociali e logiche. Programmano tali attività, somministrano prove ed esami e valutano l’apprendimento degli allievi; partecipano alle decisioni sull’organizzazione scolastica, la didattica e l’offerta educativa e formativa; coinvolgono i genitori nel processo di apprendimento dei figli."
        },
        {
          "code" : "2.6.4.2",
          "display" : "Professori di scuola pre–primaria",
          "definition" : "Le professioni comprese in questa categoria organizzano, progettano e realizzano attività didattiche finalizzate, attraverso il gioco individuale o di gruppo, a promuovere lo sviluppo fisico, psichico, cognitivo e sociale nei bambini in età prescolare. Programmano tali attività, valutano l’apprendimento degli allievi, partecipano alle decisioni sull’organizzazione scolastica, sulla didattica e sull’offerta formativa, coinvolgono i genitori nel processo di apprendimento dei figli, sostengono i bambini disabili lungo il percorso scolastico."
        },
        {
          "code" : "2.6.4.2.0",
          "display" : "Professori di scuola pre-primaria",
          "definition" : "Le professioni comprese in questa unità organizzano, progettano e realizzano attività didattiche finalizzate, attraverso il gioco individuale o di gruppo, a promuovere lo sviluppo fisico, psichico, cognitivo e sociale nei bambini in età prescolare. Programmano tali attività, valutano l’apprendimento degli allievi, partecipano alle decisioni sull’organizzazione scolastica, sulla didattica e sull’offerta formativa; coinvolgono i genitori nel processo di apprendimento dei figli, sostengono i bambini disabili lungo il percorso scolastico."
        },
        {
          "code" : "2.6.5",
          "display" : "Altri specialisti dell'educazione e della formazione",
          "definition" : "Le professioni raccolte nella classe si occupano, a diversi livelli, della formazione e dell’istruzione di soggetti con disabilità fisiche, psichiche o con gravi difficoltà di apprendimento; della progettazione curricolare e didattica, della formazione professionale e dell’insegnamento di varie discipline in quei percorsi formativi; orientano giovani ed adulti nella scelta dei percorsi di istruzione, di collocamento sul mercato del lavoro e nell’inserimento sociale. Forniscono consulenza, assistenza e sostegno al personale docente e direttivo in materia di didattica e di programmi. Insegnano, con lezioni individuali o per piccoli gruppi, la teoria e la tecnica delle discipline artistico-figurative, della danza, del canto, della musica e della lingua italiana o straniera."
        },
        {
          "code" : "2.6.5.1",
          "display" : "Specialisti nell’educazione e nella formazione di soggetti diversamente abili",
          "definition" : "Le professioni comprese in questa categoria insegnano a bambini, giovani o adulti con difficoltà di apprendimento e disabilità fisiche e mentali. Progettano o modificano i curricula in relazione ai bisogni specifici dei soggetti, addestrano gli allievi all’uso di tecniche mirate o di supporti particolari all’apprendimento, li incoraggiano ad acquisire sicurezza in se stessi e a scoprire metodi e tecniche per compensare le limitazioni poste dalla disabilità; somministrano prove e valutano il grado di apprendimento degli allievi; partecipano alle decisioni sull’organizzazione scolastica, sulla didattica e sull’offerta educativa e formativa; gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti."
        },
        {
          "code" : "2.6.5.1.0",
          "display" : "Specialisti nell’educazione e nella formazione di soggetti diversamente abili",
          "definition" : "Le professioni comprese in questa unità insegnano a bambini, giovani o adulti con difficoltà di apprendimento e disabilità fisiche e mentali. Progettano o modificano i curricula in relazione ai bisogni specifici dei soggetti; addestrano gli allievi all’uso di tecniche mirate o di supporti particolari all’apprendimento, li incoraggiano ad acquisire sicurezza in se stessi e a scoprire metodi e tecniche per compensare le limitazioni poste dalla disabilità; somministrano prove e valutano il grado di apprendimento degli allievi; partecipano alle decisioni sull’organizzazione scolastica, sulla didattica e sull’offerta educativa e formativa; gestiscono le relazioni con le famiglie e gli altri soggetti rilevanti."
        },
        {
          "code" : "2.6.5.2",
          "display" : "Ispettori scolastici e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria garantiscono sul territorio la corretta realizzazione delle finalità del sistema dell’istruzione, così come attribuite alle singole istituzioni scolastiche. Elaborano progetti finalizzati alla realizzazione degli obiettivi di politica scolastica, informano su programmi, sussidi didattici e tecnologie educative; promuovono attività di aggiornamento dei dirigenti scolastici e del personale docente; forniscono consulenze e assistenza in materia di didattica, sperimentazione e ricerca educativa; conducono le ispezioni disposte dall’amministrazione scolastica."
        },
        {
          "code" : "2.6.5.2.0",
          "display" : "Ispettori scolastici e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità garantiscono sul territorio la corretta realizzazione delle finalità del sistema dell'istruzione, così come attribuite alle singole istituzioni scolastiche. Elaborano progetti finalizzati alla realizzazione degli obiettivi di politica scolastica, informano su programmi, sussidi didattici e tecnologie educative; promuovono attività di aggiornamento dei dirigenti scolastici e del personale docente; forniscono consulenze e assistenza in materia di didattica, sperimentazione e ricerca educativa; conducono le ispezioni disposte dall'amministrazione scolastica."
        },
        {
          "code" : "2.6.5.3",
          "display" : "Docenti ed esperti nella progettazione formativa e curricolare",
          "definition" : "Le professioni classificate nella categoria insegnano gli aspetti teorici delle discipline connesse alla pratica di diverse attività lavorative, all’uso di tecnologie e di attrezzature in centri per la formazione professionale; coordinano e progettano le attività didattiche e curricolari relative in centri di formazione dedicati o, direttamente, nelle imprese e nelle organizzazioni."
        },
        {
          "code" : "2.6.5.3.1",
          "display" : "Docenti della formazione e dell'aggiornamento professionale",
          "definition" : "Le professioni comprese in questa unità insegnano gli aspetti teorici delle discipline connesse alla pratica di diverse attività lavorative, all’uso di tecnologie e di attrezzature in centri per la formazione professionale e in imprese."
        },
        {
          "code" : "2.6.5.3.2",
          "display" : "Esperti della progettazione formativa e curricolare",
          "definition" : "Le professioni comprese in questa unità coordinano e progettano le attività didattiche e curricolari in centri di formazione dedicati o, direttamente, nelle imprese e nelle organizzazioni."
        },
        {
          "code" : "2.6.5.4",
          "display" : "Consiglieri dell’orientamento",
          "definition" : "Le professioni comprese in questa categoria valutano le capacità e le propensioni degli individui, li informano sulla struttura e le dinamiche del mercato del lavoro e dell'offerta educativa e formativa, li assistono nella individuazione dei percorsi più adeguati allo sviluppo e alla crescita personale, sociale, educativa e professionale."
        },
        {
          "code" : "2.6.5.4.0",
          "display" : "Consiglieri dell'orientamento",
          "definition" : "Le professioni comprese in questa unità valutano le capacità e le propensioni degli individui, li informano sulla struttura e le dinamiche del mercato del lavoro e dell'offerta educativa e formativa, li assistono nella individuazione dei percorsi più adeguati allo sviluppo e alla crescita personale, sociale, educativa e professionale."
        },
        {
          "code" : "2.6.5.5",
          "display" : "Insegnanti di discipline artistiche e letterarie",
          "definition" : "Le professioni comprese in questa categoria insegnano, al di fuori dei percorsi scolastici e formativi istituzionali, con lezioni individuali o per piccoli gruppi, la teoria e la pratica delle discipline artistico-figurative, della danza classica e moderna, del canto, degli strumenti musicali; insegnano a impostare la voce, la dizione e a comunicare in lingua straniera."
        },
        {
          "code" : "2.6.5.5.1",
          "display" : "Insegnanti di arti figurative",
          "definition" : "Le professioni comprese in questa unità insegnano, al di fuori dei percorsi scolastici e formativi istituzionali, con lezioni individuali o per piccoli gruppi, la teoria e la pratica di discipline artistico-figurative quali la pittura, la scultura, la fotografia e la grafica."
        },
        {
          "code" : "2.6.5.5.2",
          "display" : "Insegnanti di danza",
          "definition" : "Le professioni comprese in questa unità insegnano, al di fuori dei percorsi scolastici e formativi istituzionali, con lezioni individuali o per piccoli gruppi, la teoria e la pratica della danza classica e moderna."
        },
        {
          "code" : "2.6.5.5.3",
          "display" : "Insegnanti di canto",
          "definition" : "Le professioni comprese in questa unità insegnano, al di fuori dei percorsi scolastici e formativi istituzionali, con lezioni individuali o per piccoli gruppi, la teoria e la tecnica del canto."
        },
        {
          "code" : "2.6.5.5.4",
          "display" : "Insegnanti di strumenti musicali",
          "definition" : "Le professioni comprese in questa unità insegnano, al di fuori dei percorsi scolastici e formativi istituzionali, con lezioni individuali o per piccoli gruppi, la teoria e la tecnica per suonare uno strumento musicale."
        },
        {
          "code" : "2.6.5.5.5",
          "display" : "Insegnanti di lingue",
          "definition" : "Le professioni comprese in questa unità insegnano, al di fuori dei percorsi scolastici e formativi istituzionali, con lezioni individuali o per piccoli gruppi, la grammatica, la struttura, la dizione e la comunicazione della lingua italiana o straniera."
        }
      ]
    },
    {
      "code" : "3",
      "display" : "PROFESSIONI TECNICHE",
      "definition" : "Il terzo grande gruppo comprende le professioni che richiedono conoscenze tecnico-disciplinari per selezionare e applicare operativamente protocolli e procedure – definiti e predeterminati – in attività di produzione o servizio. I loro compiti consistono nel coadiuvare gli specialisti in ambito scientifico, sanitario, umanistico, economico e sociale, afferenti alle scienze quantitative fisiche, chimiche, ingegneristiche e naturali, alle scienze della vita e della salute, alle scienze gestionali e amministrative; nel supervisionare, controllare, pianificare e garantire il corretto funzionamento dei processi di produzione e nell'organizzare i relativi fattori produttivi; nel fornire servizi sociali, pubblici e di intrattenimento; nell’eseguire e supportare performance sportive. Il livello di conoscenza richiesto dalle professioni comprese in questo grande gruppo è acquisito attraverso il completamento di percorsi di istruzione secondaria, post-secondaria o universitaria di I livello, o percorsi di apprendimento, anche non formale, di pari complessità.",
      "concept" : [
        {
          "code" : "3.1",
          "display" : "Professioni tecniche in campo scientifico, ingegneristico e della produzione",
          "definition" : "Le professioni classificate in questo gruppo svolgono compiti connessi all'applicazione ed esecuzione di protocolli scientifici in attività e processi produttivi o di ricerca basati su metodi e concetti delle scienze quantitative, chimiche, ingegneristiche ed informatiche. Eseguono, eventualmente con la supervisione e il coordinamento di specialisti, le procedure di laboratorio, di elaborazione e di acquisizione di dati nelle attività di ricerca nel campo della fisica, della chimica, della geologia e della statistica; sviluppano applicativi informatici attraverso uso di linguaggi di programmazione, installano e riparano reti telematiche; eseguono disegni tecnici; sovrintendono ad attività produttive in ambito ingegneristico; guidano aeromobili e navi; operano con apparecchiature e macchine elettroniche ed ottiche, verificano l’applicazione delle misure di sicurezza degli ambienti, applicano procedure di controllo qualitativo della produzione."
        },
        {
          "code" : "3.1.1",
          "display" : "Tecnici delle scienze quantitative, fisiche e chimiche",
          "definition" : "Le professioni classificate in questa classe eseguono ed applicano procedure e metodi connessi alla ricerca nell’ambito delle scienze fisiche, geologiche, chimiche e statistiche, ovvero all’esercizio di attività produttive che richiedono la conoscenza di tali metodi e procedure; eseguono ed applicano protocolli nei processi di acquisizione del dato statistico e della sua elaborazione."
        },
        {
          "code" : "3.1.1.1",
          "display" : "Tecnici fisici e geologici",
          "definition" : "Le professioni classificate in questa categoria assistono gli specialisti nelle ricerche e nelle rilevazioni geologiche e geofisiche; nelle ricerche e nelle sperimentazioni di laboratorio nel campo della fisica, nella produzione di energia nucleare; controllano i relativi sistemi tecnici, apparati e impianti, garantendone il funzionamento e la sicurezza."
        },
        {
          "code" : "3.1.1.1.1",
          "display" : "Tecnici geologici",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nelle ricerche e nelle rilevazioni geologiche e geofisiche; controllano apparati, impianti e i relativi sistemi tecnici, garantendone il funzionamento e la sicurezza. L’esercizio della professione di Geologo junior è regolato dalle leggi dello Stato."
        },
        {
          "code" : "3.1.1.1.2",
          "display" : "Tecnici fisici e nucleari",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nelle ricerche e nelle sperimentazioni di laboratorio nel campo della fisica, nella produzione di energia nucleare; controllano apparati, impianti e i relativi sistemi tecnici, garantendone il funzionamento e la sicurezza."
        },
        {
          "code" : "3.1.1.2",
          "display" : "Tecnici chimici",
          "definition" : "Le professioni classificate in questa categoria assistono gli specialisti nelle analisi di materie solide, liquide e gassose condotte nell’ambito della ricerca chimica ovvero per attività di produzione, che richiedono l’applicazione delle procedure e dei protocolli della chimica, finalizzate allo sviluppo di nuovi prodotti o processi, al controllo della qualità della produzione; al controllo e mantenimento degli standard di qualità ambientale, di funzionamento e di sicurezza dei relativi sistemi tecnici, apparati e impianti."
        },
        {
          "code" : "3.1.1.2.0",
          "display" : "Tecnici chimici",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nelle analisi di materie solide, liquide e gassose condotte nell’ambito della ricerca chimica ovvero per attività di produzione, che richiedono l’applicazione delle procedure e dei protocolli della chimica, finalizzate allo sviluppo di nuovi prodotti o processi; assistono gli specialisti al controllo della qualità della produzione, al controllo e mantenimento degli standard di qualità ambientale, di funzionamento e di sicurezza degli apparati, impianti e dei relativi sistemi tecnici. L’esercizio delle professioni di Chimico junior e di Perito chimico è regolato dalle leggi dello Stato."
        },
        {
          "code" : "3.1.1.3",
          "display" : "Tecnici statistici",
          "definition" : "Le professioni classificate in questa categoria assistono gli specialisti nella ricerca sperimentale, nelle indagini e ricerche demografiche, epidemiologiche, sociali ed economiche; nel controllo e nell’applicazione delle procedure di ricerca e di acquisizione dei dati; nella gestione sul campo delle rilevazioni; nel controllo della qualità dei dati rilevati e nella elaborazione statistica degli stessi."
        },
        {
          "code" : "3.1.1.3.0",
          "display" : "Tecnici statistici",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nella ricerca sperimentale, nelle indagini e in altre ricerche demografiche, epidemiologiche ed economiche, nel controllo e nell’applicazione delle procedure di ricerca e di acquisizione dei dati, nella gestione sul campo delle rilevazioni, nel controllo della qualità dei dati rilevati e nella elaborazione statistica degli stessi. L’esercizio della professione di Attuario junior è regolato dalle leggi dello Stato."
        },
        {
          "code" : "3.1.2",
          "display" : "Tecnici informatici, telematici e delle telecomunicazioni",
          "definition" : "Le professioni classificate in questa classe assistono i progettisti di software e di sistemi ovvero sviluppano e scrivono programmi informatici; installano, configurano e gestiscono applicazioni software; controllano e assicurano il funzionamento ottimale di siti internet; gestiscono, controllano e manutengono basi di dati; installano, configurano, gestiscono e manutengono sistemi telematici; curano l'installazione, il montaggio, la messa in servizio e la manutenzione di reti informatiche, telefoniche, di impianti radiotelevisivi e satellitari; installano, tarano e utilizzano apparecchiature e sistemi elettronici per trasmettere programmi radio-televisivi."
        },
        {
          "code" : "3.1.2.1",
          "display" : "Tecnici programmatori",
          "definition" : "Le professioni classificate in questa categoria assistono i progettisti e analisti di software traducendo istruzioni e specifiche di controllo, di procedure o di soluzioni di problemi, in diagrammi logici di flusso per la programmazione in linguaggio informatico; sviluppando e scrivendo programmi per memorizzare, ricercare ed elaborare informazioni e dati."
        },
        {
          "code" : "3.1.2.1.0",
          "display" : "Tecnici programmatori",
          "definition" : "Le professioni classificate in questa unità assistono i progettisti e analisti di software traducendo istruzioni e specifiche di controllo, di procedure o di soluzioni di problemi, in diagrammi logici di flusso per la programmazione in linguaggio informatico; sviluppando e scrivendo programmi per memorizzare, ricercare ed elaborare informazioni e dati."
        },
        {
          "code" : "3.1.2.2",
          "display" : "Tecnici esperti in applicazioni",
          "definition" : "Le professioni classificate in questa categoria assistono i progettisti e analisti di software installando, configurando, gestendo e manutenendo applicazioni software."
        },
        {
          "code" : "3.1.2.2.0",
          "display" : "Tecnici esperti in applicazioni",
          "definition" : "Le professioni classificate in questa unità assistono i progettisti e analisti di software installando, configurando, gestendo e manutenendo applicazioni software."
        },
        {
          "code" : "3.1.2.3",
          "display" : "Tecnici web",
          "definition" : "Le professioni classificate in questa categoria assistono i progettisti e analisti di applicazioni web sviluppando, configurando, gestendo, manutenendo ed ottimizzando siti internet, intranet e server web."
        },
        {
          "code" : "3.1.2.3.0",
          "display" : "Tecnici web",
          "definition" : "Le professioni classificate in questa unità assistono i progettisti e analisti di applicazioni web sviluppando, configurando, gestendo, manutenendo ed ottimizzando siti internet, intranet e server web."
        },
        {
          "code" : "3.1.2.4",
          "display" : "Tecnici gestori di basi di dati",
          "definition" : "Le professioni classificate in questa categoria assistono gli analisti e progettisti di basi dati gestendo, controllando e manutenendo basi di dati e relativi sistemi di sicurezza."
        },
        {
          "code" : "3.1.2.4.0",
          "display" : "Tecnici gestori di basi di dati",
          "definition" : "Le professioni classificate in questa unità assistono gli analisti e progettisti di basi dati gestendo, controllando e manutenendo basi di dati e relativi sistemi di sicurezza."
        },
        {
          "code" : "3.1.2.5",
          "display" : "Tecnici gestori di reti e di sistemi telematici",
          "definition" : "Le professioni classificate in questa categoria assistono i progettisti e amministratori di sistemi installando, configurando, gestendo e manutenendo per gli aspetti software i sistemi telematici ed i relativi sistemi di sicurezza."
        },
        {
          "code" : "3.1.2.5.0",
          "display" : "Tecnici gestori di reti e di sistemi telematici",
          "definition" : "Le professioni classificate in questa unità assistono i progettisti e amministratori di sistemi installando, configurando, gestendo e manutenendo per gli aspetti software i sistemi telematici ed i relativi sistemi di sicurezza."
        },
        {
          "code" : "3.1.2.6",
          "display" : "Tecnici per la trasmissione radio-televisiva e per le telecomunicazioni",
          "definition" : "Le professioni comprese nella categoria tarano, utilizzano e manutengono apparecchiature e sistemi elettronici per trasmettere programmi radio-televisivi; curano l'installazione, il montaggio, la messa in servizio e la manutenzione delle componenti fisiche di reti informatiche, telefoniche, di impianti radiotelevisivi e satellitari e altre reti di sistemi di informazione elettronica per la trasmissione di dati e immagini."
        },
        {
          "code" : "3.1.2.6.1",
          "display" : "Tecnici per le telecomunicazioni",
          "definition" : "Le professioni classificate in questa unità curano l'installazione, il montaggio, la messa in servizio e la manutenzione delle componenti fisiche di reti informatiche, telefoniche, di impianti radiotelevisivi e satellitari e altre reti di sistemi di informazione elettronica per la trasmissione di dati e immagini."
        },
        {
          "code" : "3.1.2.6.2",
          "display" : "Tecnici delle trasmissioni radio-televisive",
          "definition" : "Le professioni classificate in questa unità installano, tarano e utilizzano apparecchiature e sistemi elettronici per trasmettere programmi radio-televisivi e controllano il livello e la qualità del suono e delle immagini durante le trasmissioni."
        },
        {
          "code" : "3.1.3",
          "display" : "Tecnici in campo ingegneristico",
          "definition" : "Le professioni classificate in questa classe assistono gli specialisti ovvero eseguono ed applicano procedure e metodi connessi alla ricerca, alla progettazione esecutiva e alla risoluzione operativa di problemi tecnici nel campo della meccanica, dell’estrazione dei minerali, dell’elettrotecnica, dell’elettronica, delle costruzioni civili; sono di supporto nella progettazione dei relativi sistemi tecnici, apparati ed impianti."
        },
        {
          "code" : "3.1.3.1",
          "display" : "Tecnici meccanici",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti nelle ricerche nel campo dell’ingegneria meccanica, ovvero applicano ed eseguono le procedure e le tecniche proprie per disegnare, modificare, sviluppare e verificare prodotti, macchine, attrezzature."
        },
        {
          "code" : "3.1.3.1.0",
          "display" : "Tecnici meccanici",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nelle ricerche nel campo dell'ingegneria meccanica, ovvero applicano ed eseguono le procedure e le tecniche proprie per disegnare, modificare, sviluppare e verificare prodotti, macchine, attrezzature. L’esercizio della professione di Perito meccanico è regolato dalle leggi dello Stato."
        },
        {
          "code" : "3.1.3.2",
          "display" : "Tecnici metallurgico-minerari e della ceramica",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti nella ricerca in materia di estrazione di minerali, acqua, gas e petrolio e di studio e di produzione di leghe o di ceramiche; ovvero applicano ed eseguono procedure e tecniche proprie nelle rilevazioni geologiche e topografiche di cave e giacimenti di minerali o di altri prodotti del sottosuolo, nella progettazione di sistemi e attrezzature di estrazione e di primo trattamento."
        },
        {
          "code" : "3.1.3.2.1",
          "display" : "Tecnici dei prodotti ceramici",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nella ricerca in materia di progettazione e produzione di ceramiche, sono di supporto nella progettazione di impianti, apparati e sistemi tecnici di produzione di ceramiche."
        },
        {
          "code" : "3.1.3.2.2",
          "display" : "Tecnici minerari",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nella ricerca in materia di estrazione di minerali, acqua, gas e petrolio ovvero applicano ed eseguono procedure e tecniche proprie nelle rilevazioni geologiche e topografiche di cave e giacimenti di minerali o di altri prodotti del sottosuolo, sono di supporto nella progettazione di sistemi e attrezzature di estrazione e di primo trattamento dei prodotti. L’esercizio della professione di Perito minerario è regolato dalle leggi dello Stato."
        },
        {
          "code" : "3.1.3.2.3",
          "display" : "Tecnici metallurgici",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nella ricerca in materia di estrazione di leghe; sono di supporto nella progettazione di impianti, apparati e sistemi tecnici di produzione di metalli e leghe."
        },
        {
          "code" : "3.1.3.3",
          "display" : "Elettrotecnici",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti nella ricerca nel campo dell’elettricità e della progettazione di macchine ed apparati elettrici, anche a natura automatica, ovvero applicano ed eseguono procedure e tecniche proprie per disegnare, installare, individuare problemi e modificare impianti, circuiti, macchine e apparecchiature elettrici ed elettromeccanici."
        },
        {
          "code" : "3.1.3.3.0",
          "display" : "Elettrotecnici",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nella ricerca nel campo dell’elettricità e della progettazione di macchine ed apparati elettrici, anche di natura automatica, ovvero applicano ed eseguono procedure e tecniche proprie per disegnare, installare, individuare problemi e modificare impianti, circuiti, macchine e apparecchiature elettrici ed elettromeccanici. L’esercizio della professione di Perito elettrotecnico è regolato dalle leggi dello Stato."
        },
        {
          "code" : "3.1.3.4",
          "display" : "Tecnici elettronici",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti nella ricerca in materia di elettronica, ovvero applicano ed eseguono procedure e tecniche proprie per disegnare, costruire, installare, individuarne problemi e modificare componenti, parti, apparati e circuiti elettronici singoli o inseriti in sistemi complessi."
        },
        {
          "code" : "3.1.3.4.0",
          "display" : "Tecnici elettronici",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nella ricerca in materia di elettronica, ovvero applicano ed eseguono procedure e tecniche proprie per disegnare, costruire, installare e modificare componenti, parti, apparati e circuiti elettronici singoli o inseriti in sistemi complessi e per individuare e risolvere problemi di funzionamento. L’esercizio della professione di Perito elettronico è regolato dalle leggi dello Stato."
        },
        {
          "code" : "3.1.3.5",
          "display" : "Tecnici delle costruzioni civili e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti nella ricerca nel campo dell’ingegneria civile e nella progettazione di edifici, strade, ferrovie, aeroporti e porti e di altre opere civili, ovvero applicano ed eseguono procedure e tecniche proprie per disegnare, progettare, sovrintendere alla costruzione e manutenere tali opere; per controllarne gli impianti, gli apparati e i relativi sistemi tecnici e garantirne il funzionamento e la sicurezza; per rilevare dati e disegnare le relative planimetrie, prospezioni e mappe."
        },
        {
          "code" : "3.1.3.5.0",
          "display" : "Tecnici delle costruzioni civili e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nella ricerca nel campo dell’ingegneria civile e nella progettazione di edifici, strade, ferrovie, aeroporti e porti e di altre opere civili, ovvero applicano ed eseguono procedure e tecniche proprie per disegnare, progettare, sovrintendere alla costruzione e manutenere tali opere, per controllarne gli impianti, gli apparati e i relativi sistemi tecnici e garantirne il funzionamento e la sicurezza. L’esercizio delle professioni di Geometra, Geometra laureato, Perito edile, Architetto junior e Pianificatore junior è regolato dalle leggi dello Stato."
        },
        {
          "code" : "3.1.3.6",
          "display" : "Tecnici del risparmio energetico e delle energie rinnovabili",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti della produzione di energie rinnovabili e dell’applicazione di tecniche di risparmio energetico ovvero applicano ed eseguono procedure e tecniche proprie per individuare nuovi metodi di conversione dell'energia a partire dalle fonti primarie disponibili in natura, per aumentare il risparmio energetico e ridurre l'impatto ambientale; verificano le condizioni e gli elementi necessari alla progettazione di impianti per la produzione di energie rinnovabili."
        },
        {
          "code" : "3.1.3.6.0",
          "display" : "Tecnici del risparmio energetico e delle energie rinnovabili",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti della produzione di energie rinnovabili e dell’applicazione di tecniche di risparmio energetico ovvero applicano ed eseguono procedure e tecniche proprie per individuare nuovi metodi di conversione dell'energia a partire dalle fonti primarie disponibili in natura, per aumentare il risparmio energetico e ridurre l'impatto ambientale; verificano le condizioni e gli elementi necessari alla progettazione di impianti per la produzione di energie rinnovabili."
        },
        {
          "code" : "3.1.3.7",
          "display" : "Disegnatori industriali e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti realizzando disegni dettagliati di elementi architettonici e strutturali di edifici e di altre opere civili, di macchine, congegni ed apparecchiature meccaniche, elettriche ed elettroniche; di prodotti industriali e di beni di consumo; dei motivi e degli elementi di decorazione da tessere o stampare su stoffa o altri manufatti tessili; della conformazione fisica e topografica del suolo o di altri oggetti, esseri o elementi naturali."
        },
        {
          "code" : "3.1.3.7.1",
          "display" : "Disegnatori tecnici",
          "definition" : "Le professioni comprese in questa unità applicano ed eseguono procedure e tecniche proprie per realizzare disegni dettagliati di elementi architettonici e strutturali di edifici e di altre opere civili, di macchine, congegni ed apparecchiature meccaniche, elettriche ed elettroniche, di prodotti industriali e di beni di consumo."
        },
        {
          "code" : "3.1.3.7.2",
          "display" : "Disegnatori tessili",
          "definition" : "Le professioni comprese in questa unità applicano ed eseguono procedure e tecniche proprie per realizzare disegni dettagliati dei motivi e degli elementi di decorazione da tessere o stampare su stoffa o altri manufatti tessili. L’esercizio della professione di Perito tessile è regolato dalle leggi dello Stato."
        },
        {
          "code" : "3.1.3.7.3",
          "display" : "Rilevatori e disegnatori di prospezioni",
          "definition" : "Le professioni comprese in questa unità applicano ed eseguono procedure e tecniche proprie per realizzare disegni dettagliati della conformazione fisica e topografica del suolo o di altri oggetti, esseri o elementi naturali."
        },
        {
          "code" : "3.1.4",
          "display" : "Tecnici della conduzione di impianti produttivi in continuo e dell'esercizio di reti idriche ed energetiche",
          "definition" : "Le professioni classificate in questa classe applicano procedure, regolamenti e tecnologie proprie per controllare, attraverso sistemi altamente automatizzati, organizzare e gestire il funzionamento e la sicurezza delle catene di montaggio automatiche, dei processi e dell'impiantistica di flusso per la produzione chimica, dei metalli, della carta, dell'energia termica ed elettrica, per il trattamento delle acque, per la distribuzione di energia elettrica, acqua e altri fluidi."
        },
        {
          "code" : "3.1.4.1",
          "display" : "Tecnici della conduzione di impianti produttivi in continuo",
          "definition" : "Le professioni classificate in questa categoria applicano procedure, regolamenti e tecnologie proprie per controllare, attraverso sistemi altamente automatizzati, organizzare e gestire il funzionamento e la sicurezza delle catene di montaggio automatiche, dei processi e dell'impiantistica di flusso per la produzione chimica, dei metalli, della carta e per il trattamento delle acque."
        },
        {
          "code" : "3.1.4.1.1",
          "display" : "Tecnici della conduzione e del controllo di impianti di produzione dei metalli",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per controllare, attraverso sistemi automatizzati, e gestire il funzionamento e la sicurezza dei processi dell'impiantistica per la produzione dei metalli."
        },
        {
          "code" : "3.1.4.1.2",
          "display" : "Tecnici della conduzione e del controllo di impianti chimici",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per controllare, attraverso sistemi automatizzati, e gestire il funzionamento e la sicurezza dei processi di lavorazione e dell'impiantistica chimica di flusso."
        },
        {
          "code" : "3.1.4.1.3",
          "display" : "Tecnici della conduzione e del controllo di impianti di produzione della carta",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per controllare, attraverso sistemi automatizzati, e gestire il funzionamento e la sicurezza dei processi di lavorazione e dell'impiantistica di flusso per la produzione della carta."
        },
        {
          "code" : "3.1.4.1.4",
          "display" : "Tecnici della conduzione e del controllo di impianti di trattamento delle acque",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per controllare, attraverso sistemi automatizzati, e gestire il funzionamento e la sicurezza dei processi per il trattamento di potabilizzazione e depurazione delle acque reflue."
        },
        {
          "code" : "3.1.4.1.5",
          "display" : "Tecnici della conduzione e del controllo di catene di montaggio automatiche",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per controllare, attraverso sistemi automatizzati, e gestire il funzionamento e la sicurezza delle catene di montaggio automatiche."
        },
        {
          "code" : "3.1.4.2",
          "display" : "Tecnici dell'esercizio di reti idriche ed energetiche",
          "definition" : "Le professioni classificate in questa categoria applicano procedure, regolamenti e tecnologie proprie per controllare, attraverso sistemi altamente automatizzati, organizzare e gestire il funzionamento e la sicurezza dei processi e dell'impiantistica di flusso per la produzione di energia termica ed elettrica, la distribuzione di energia elettrica, acqua e altri fluidi."
        },
        {
          "code" : "3.1.4.2.1",
          "display" : "Tecnici della produzione di energia termica ed elettrica",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per adeguare, modificare, sviluppare, controllare, verificare, operare e garantire il funzionamento corretto ed efficiente e la sicurezza di processi, fasi, sistemi e apparati per la produzione di energia elettrica e termica, anche da fonti rinnovabili; monitorano e gestiscono sistemi computerizzati di controllo e le relative apparecchiature in impianti per l'incenerimento e il trattamento di termodistruzione e termovalorizzazione dei rifiuti."
        },
        {
          "code" : "3.1.4.2.2",
          "display" : "Tecnici dell'esercizio di reti idriche e di altri fluidi",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per gestire, controllare, verificare, operare e garantire il funzionamento corretto ed efficiente e la sicurezza dell'esercizio di reti per il trasporto e la distribuzione di acqua e gas."
        },
        {
          "code" : "3.1.4.2.3",
          "display" : "Tecnici dell'esercizio di reti di distribuzione di energia elettrica",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per gestire, controllare, verificare, operare e garantire il funzionamento corretto ed efficiente e la sicurezza dell'esercizio di reti per il trasporto e la distribuzione di energia elettrica."
        },
        {
          "code" : "3.1.5",
          "display" : "Tecnici della gestione dei processi produttivi di beni e servizi",
          "definition" : "Le professioni classificate in questa classe applicano procedure, regolamenti e tecnologie proprie per gestire, organizzare, controllare, garantire l'efficienza, il corretto funzionamento e la sicurezza dei processi di produzione nelle miniere e cave, nei cantieri edili, nella manifattura, nell'industria alimentare e nei servizi."
        },
        {
          "code" : "3.1.5.1",
          "display" : "Tecnici di produzione in miniere e cave",
          "definition" : "Le professioni comprese in questa categoria applicano procedure, regolamenti e tecnologie proprie per gestire, organizzare, controllare e garantire l'efficienza, il corretto funzionamento e la sicurezza dei processi di produzione nelle miniere e nelle cave."
        },
        {
          "code" : "3.1.5.1.0",
          "display" : "Tecnici di produzione in miniere e cave",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per gestire, controllare, organizzare e garantire l'efficienza, il corretto funzionamento e la sicurezza dei processi di produzione nelle miniere e nelle cave."
        },
        {
          "code" : "3.1.5.2",
          "display" : "Tecnici della gestione di cantieri edili",
          "definition" : "Le professioni comprese in questa categoria applicano procedure, regolamenti e tecnologie proprie per gestire, controllare organizzare e garantire l'efficienza e la sicurezza dei processi di lavorazione nei cantieri edili."
        },
        {
          "code" : "3.1.5.2.0",
          "display" : "Tecnici della gestione di cantieri edili",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per gestire, controllare organizzare e garantire l'efficienza e la sicurezza dei processi di lavorazione nei cantieri edili."
        },
        {
          "code" : "3.1.5.3",
          "display" : "Tecnici della produzione manifatturiera",
          "definition" : "Le professioni comprese in questa categoria applicano procedure, regolamenti e tecnologie proprie per gestire, organizzare, controllare e garantire l'efficienza, il corretto funzionamento e la sicurezza dei processi di produzione manifatturiera; verificano la qualità dei beni prodotti."
        },
        {
          "code" : "3.1.5.3.0",
          "display" : "Tecnici della produzione manifatturiera",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per gestire, organizzare, controllare e garantire l'efficienza, il corretto funzionamento e la sicurezza dei processi di produzione manifatturiera; verificano la qualità dei beni prodotti."
        },
        {
          "code" : "3.1.5.4",
          "display" : "Tecnici della produzione e preparazione alimentare",
          "definition" : "Le professioni comprese in questa categoria applicano procedure, regolamenti e tecnologie proprie per gestire, organizzare, controllare e garantire l'efficienza, il corretto funzionamento e la sicurezza dei processi di produzione e preparazione alimentare; verificano la qualità dei beni prodotti."
        },
        {
          "code" : "3.1.5.4.1",
          "display" : "Tecnici della preparazione alimentare",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per gestire, organizzare, controllare e garantire l'efficienza, il corretto funzionamento e la sicurezza dei processi di preparazione alimentare; creano ricette, supervisionano, pianificano e organizzano la realizzazione dei piatti; verificano la qualità dei beni prodotti."
        },
        {
          "code" : "3.1.5.4.2",
          "display" : "Tecnici della produzione alimentare",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per gestire, organizzare, controllare e garantire l'efficienza, il corretto funzionamento e la sicurezza dei processi di produzione alimentare."
        },
        {
          "code" : "3.1.5.5",
          "display" : "Tecnici della produzione di servizi",
          "definition" : "Le professioni comprese in questa categoria applicano procedure, regolamenti e tecnologie proprie per gestire, organizzare, controllare e garantire l'efficienza e la corretta erogazione dei servizi; verificano la qualità dei servizi forniti."
        },
        {
          "code" : "3.1.5.5.0",
          "display" : "Tecnici della produzione di servizi",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per gestire, controllare, organizzare e garantire l'efficienza e la corretta erogazione dei servizi; verificano la qualità dei servizi offerti."
        },
        {
          "code" : "3.1.6",
          "display" : "Tecnici del trasporto aereo, navale e ferroviario",
          "definition" : "Le professioni comprese in questa classe comandano, pilotano e garantiscono la sicurezza del volo e della navigazione di aeromobili e di imbarcazioni, controllano il funzionamento delle apparecchiature meccaniche, elettriche ed elettroniche di bordo."
        },
        {
          "code" : "3.1.6.1",
          "display" : "Comandanti e ufficiali di bordo",
          "definition" : "Le professioni comprese in questa categoria comandano e sovrintendono alla navigazione in sicurezza di grandi imbarcazioni e navi dentro e fuori i porti, lungo fiumi navigabili, mari, oceani, laghi e baie; coordinano e sovrintendono alle attività dell’equipaggio, controllano e garantiscono il corretto funzionamento dei motori e delle altre apparecchiature di bordo; pilotano navi e imbarcazioni."
        },
        {
          "code" : "3.1.6.1.1",
          "display" : "Comandanti navali",
          "definition" : "Le professioni comprese in questa unità dirigono e sovrintendono la navigazione di grandi imbarcazioni e navi dentro e fuori i porti, lungo fiumi navigabili, mari, oceani, laghi e baie."
        },
        {
          "code" : "3.1.6.1.2",
          "display" : "Ufficiali e assistenti di bordo",
          "definition" : "Le professioni comprese in questa unità coordinano e sovrintendono alle attività dell’equipaggio di grandi imbarcazioni e navi, controllano e garantiscono il corretto funzionamento dei motori e delle altre apparecchiature di bordo. L’esercizio della professione di Perito navale è regolato dalle leggi dello Stato."
        },
        {
          "code" : "3.1.6.1.3",
          "display" : "Piloti navali",
          "definition" : "Le professioni comprese in questa unità pilotano navi e imbarcazioni; assistono il comandante fornendo suggerimenti sulla rotta e sulla determinazione delle manovre necessarie per seguirla."
        },
        {
          "code" : "3.1.6.2",
          "display" : "Comandanti e piloti di aereo",
          "definition" : "Le professioni comprese in questa categoria comandano, controllano le apparecchiature e le operazioni di volo a bordo e fuori bordo; sovrintendono alla navigazione, ne garantiscono la sicurezza e pilotano aeromobili da carico e per il trasporto di passeggeri; controllano, tarano, riparano e garantiscono il funzionamento dell’avionica a bordo, dei sistemi integrati di navigazione, di comunicazione, e di sicurezza; installano, tarano e fanno funzionare sistemi integrati di calcolo/comunicazione, simulatori, periferiche di acquisizione di dati, strumenti di misurazione e altre apparecchiature per lanciare e seguire da terra veicoli aerospaziali."
        },
        {
          "code" : "3.1.6.2.1",
          "display" : "Piloti e ufficiali di aeromobili",
          "definition" : "Le professioni comprese in questa unità comandano, controllano le apparecchiature e le operazioni di volo a bordo e fuori bordo; sovrintendono alla navigazione, ne garantiscono la sicurezza e pilotano aeromobili da carico e per il trasporto di passeggeri."
        },
        {
          "code" : "3.1.6.2.2",
          "display" : "Tecnici avionici",
          "definition" : "Le professioni comprese in questa unità controllano, tarano, riparano e garantiscono il funzionamento dell’avionica a bordo, dei sistemi integrati di navigazione, di comunicazione, e di sicurezza."
        },
        {
          "code" : "3.1.6.2.3",
          "display" : "Tecnici aerospaziali",
          "definition" : "Le professioni comprese in questa unità installano, tarano e fanno funzionare sistemi integrati di calcolo/comunicazione, simulatori, periferiche di acquisizione di dati, strumenti di misurazione e altre apparecchiature per lanciare e seguire da terra veicoli aerospaziali."
        },
        {
          "code" : "3.1.6.3",
          "display" : "Tecnici dell'aviazione civile",
          "definition" : "Le professioni comprese in questa categoria controllano e dirigono il traffico degli aeromobili e il loro movimento alle diverse altitudini e negli aeroporti, forniscono informazioni per le operazioni di atterraggio e di decollo, applicano le procedure stabilite per controllare, regolare e autorizzare i voli in ottemperanza delle garanzie di sicurezza; autorizzano il decollo e l’atterraggio degli aeromobili e ne assicurano la sicurezza; coordinano le attività del personale in pista; applicano le procedure aeroportuali di sicurezza, in conformità alle norme internazionali, rispetto al cui esercizio sono specificamente abilitati."
        },
        {
          "code" : "3.1.6.3.1",
          "display" : "Controllori di volo",
          "definition" : "Le professioni comprese in questa unità controllano e dirigono il traffico degli aeromobili e il loro movimento alle diverse altitudini e negli aeroporti; forniscono informazioni per le operazioni di atterraggio e di decollo; applicano le procedure stabilite per controllare, regolare e autorizzare i voli in ottemperanza delle garanzie di sicurezza."
        },
        {
          "code" : "3.1.6.3.2",
          "display" : "Tecnici del traffico aeroportuale",
          "definition" : "Le professioni comprese in questa unità autorizzano le operazioni a terra per il decollo e l’atterraggio degli aeromobili e ne assicurano la sicurezza; coordinano le attività del personale in pista; applicano le procedure aeroportuali di sicurezza, in conformità alle norme internazionali, rispetto al cui esercizio sono specificamente abilitati."
        },
        {
          "code" : "3.1.6.4",
          "display" : "Tecnici dell'organizzazione del traffico ferroviario",
          "definition" : "Le professioni comprese in questa categoria coordinano il movimento dei treni e il funzionamento generale dei servizi di stazione ferroviaria."
        },
        {
          "code" : "3.1.6.4.0",
          "display" : "Tecnici dell'organizzazione del traffico ferroviario",
          "definition" : "Le professioni comprese in questa unità coordinano il movimento dei treni e il funzionamento generale dei servizi di stazione ferroviaria."
        },
        {
          "code" : "3.1.6.5",
          "display" : "Tecnici dell'organizzazione del traffico portuale",
          "definition" : "Le professioni comprese in questa categoria coordinano le attività portuali, vigilando sul rispetto delle norme e dei regolamenti che disciplinano il lavoro in porto, la viabilità e l'accesso alle aree portuali; controllano il territorio portuale e il corretto utilizzo delle aree e dei beni demaniali."
        },
        {
          "code" : "3.1.6.5.0",
          "display" : "Tecnici dell'organizzazione del traffico portuale",
          "definition" : "Le professioni comprese in questa unità coordinano le attività portuali, vigilando sul rispetto delle norme e dei regolamenti che disciplinano il lavoro in porto, la viabilità e l'accesso alle aree portuali; controllano il territorio portuale e il corretto utilizzo delle aree e dei beni demaniali"
        },
        {
          "code" : "3.1.7",
          "display" : "Tecnici di apparecchiature ottiche e audio-video",
          "definition" : "Le professioni comprese in questa classe operano con fotocamere, strumenti di ripresa e di produzione video e sonora, con sistemi e apparecchiature per le comunicazioni radio e radiotelevisive, nonché su sistemi elettronici per la diagnostica e il trattamento terapeutico in medicina."
        },
        {
          "code" : "3.1.7.1",
          "display" : "Fotografi e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria riprendono persone, ambienti, oggetti, prodotti commerciali per fini artistici, documentali e pubblicitari; illustrano eventi o notizie, riproducono, seguendo protocolli scientifici, soggetti, dati e fenomeni oggetto di ricerca e di studio; sviluppano i negativi, operano azioni di fotoritocco e manipolazione delle immagini acquisite e stampano le fotografie realizzate."
        },
        {
          "code" : "3.1.7.1.0",
          "display" : "Fotografi e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità riprendono persone, ambienti, oggetti, prodotti commerciali per fini artistici, documentali e pubblicitari; illustrano eventi o notizie, riproducono, seguendo protocolli scientifici, soggetti, dati e fenomeni oggetto di ricerca e di studio; sviluppano i negativi, operano azioni di fotoritocco e manipolazione delle immagini acquisite e stampano le fotografie realizzate; controllano, manutengono e operano con apparecchi e sistemi elettronici e ottici."
        },
        {
          "code" : "3.1.7.2",
          "display" : "Operatori di apparecchi per la ripresa e la produzione audio-video",
          "definition" : "Le professioni comprese in questa categoria montano, tarano, usano e connettono apparecchiature per la ripresa e la diffusione audio e video; eseguono riprese televisive o cinematografiche; utilizzano apparati e sistemi per registrare, sincronizzare, miscelare, riprodurre musica, voci, suoni ed effetti sonori in manifestazioni sportive o ricreative di vario genere, in produzioni teatrali, radio-televisive e cinematografiche, negli studi di registrazione; montano, elaborano e modificano riprese televisive, cinematografiche e sonore."
        },
        {
          "code" : "3.1.7.2.1",
          "display" : "Tecnici degli apparati audio-video e della ripresa video-cinematografica",
          "definition" : "Le professioni comprese in questa unità montano, tarano, usano e connettono apparecchiature per la ripresa e la diffusione audio e video; eseguono riprese televisive o cinematografiche."
        },
        {
          "code" : "3.1.7.2.2",
          "display" : "Tecnici del suono",
          "definition" : "Le professioni comprese in questa unità utilizzano apparati e sistemi per registrare, sincronizzare, miscelare, riprodurre musica, voci, suoni ed effetti sonori in manifestazioni sportive o ricreative di vario genere, in produzioni teatrali, radio-televisive e cinematografiche, negli studi di registrazione."
        },
        {
          "code" : "3.1.7.2.3",
          "display" : "Tecnici del montaggio audio-video-cinematografico",
          "definition" : "Le professioni comprese in questa unità montano, elaborano e modificano riprese televisive, cinematografiche e sonore."
        },
        {
          "code" : "3.1.7.3",
          "display" : "Tecnici di apparati medicali e per la diagnostica medica",
          "definition" : "Le professioni comprese in questa categoria, controllano, manutengono e testano l'efficienza di apparati e sistemi dedicati a specifici trattamenti terapeutici ovvero di apparati e sistemi di diagnostica radiografica, sonografica e di acquisizione ed elaborazione di dati di varia natura."
        },
        {
          "code" : "3.1.7.3.0",
          "display" : "Tecnici di apparati medicali e per la diagnostica medica",
          "definition" : "Le professioni comprese in questa unità controllano, manutengono e testano l'efficienza di apparati e sistemi dedicati a specifici trattamenti terapeutici ovvero di apparati e sistemi di diagnostica radiografica, sonografica e di acquisizione ed elaborazione di dati di varia natura."
        },
        {
          "code" : "3.1.8",
          "display" : "Tecnici della sicurezza e della protezione ambientale",
          "definition" : "Le professioni comprese in questa classe assistono gli specialisti nella progettazione di sistemi ovvero applicano i regolamenti, le procedure e le tecnologie in materia di sicurezza degli impianti e di prevenzione degli incidenti sul lavoro, di controllo, sicurezza e qualità dei prodotti industriali, di controllo delle immissioni di sostanze inquinanti nell’ambiente, di raccolta e smaltimento dei rifiuti e bonifica dalle sostanze inquinanti."
        },
        {
          "code" : "3.1.8.1",
          "display" : "Tecnici della sicurezza di impianti",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti nelle ricerche e nella progettazione tecnologica in materia di sistemi di sicurezza, ovvero applicano ed eseguono procedure, regolamenti e tecnologie proprie per adeguare, modificare, sviluppare, controllare e verificare i sistemi di sicurezza degli impianti industriali."
        },
        {
          "code" : "3.1.8.1.0",
          "display" : "Tecnici della sicurezza degli impianti",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti nelle ricerche e nella progettazione tecnologica in materia di sistemi di sicurezza ovvero applicano ed eseguono procedure, regolamenti e tecnologie proprie per adeguare, modificare, sviluppare, controllare e verificare i sistemi di sicurezza degli impianti industriali."
        },
        {
          "code" : "3.1.8.2",
          "display" : "Tecnici della sicurezza sul lavoro",
          "definition" : "Le professioni comprese in questa categoria applicano ed eseguono procedure, regolamenti e tecnologie proprie per adeguare, modificare, sviluppare, controllare e verificare la sicurezza degli ambienti di lavoro e dei lavoratori, delle macchine e delle loro modalità di uso."
        },
        {
          "code" : "3.1.8.2.0",
          "display" : "Tecnici della sicurezza sul lavoro",
          "definition" : "Le professioni comprese in questa unità applicano ed eseguono procedure, regolamenti e tecnologie proprie per adeguare, modificare, sviluppare, controllare e verificare la sicurezza degli ambienti di lavoro e dei lavoratori, delle macchine e delle loro modalità di uso."
        },
        {
          "code" : "3.1.8.3",
          "display" : "Tecnici del controllo e della bonifica ambientale",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti nelle ricerche e nella progettazione, sviluppo e valutazione di sistemi per il controllo, la salvaguardia e la conservazione dell’ambiente, ovvero adattano, tarano e operano con strumentazioni, applicano procedure per controllare e rilevare informazioni sui vari tipi di inquinamento ambientale e sulle possibili cause; controllare e rilevare informazioni sullo stato di monumenti e di opere architettoniche, sulle caratteristiche e sullo stato degli ambienti naturali e storici, per salvaguardarli e conservarli nella loro funzionalità; applicano procedure, regolamenti e tecnologie proprie per controllare e garantire l'efficienza dei processi di raccolta, selezione, trattamento e smaltimento dei rifiuti; contribuiscono a valutare ed attuare programmi per la bonifica e il risanamento di aree inquinate."
        },
        {
          "code" : "3.1.8.3.1",
          "display" : "Tecnici del controllo ambientale",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti nelle ricerche e nella progettazione, sviluppo e valutazione di sistemi per il controllo, la salvaguardia e la conservazione dell’ambiente, ovvero adattano, tarano e operano con strumentazioni, applicano procedure per controllare e rilevare informazioni sui vari tipi di inquinamento ambientale e sulle possibili cause; controllano e rilevano informazioni sullo stato di monumenti e di opere architettoniche, sulle caratteristiche e sullo stato degli ambienti naturali e storici, per salvaguardarli e conservarli nella loro funzionalità."
        },
        {
          "code" : "3.1.8.3.2",
          "display" : "Tecnici della raccolta e trattamento dei rifiuti e della bonifica ambientale",
          "definition" : "Le professioni comprese in questa unità applicano procedure, regolamenti e tecnologie proprie per controllare e garantire l'efficienza dei processi di raccolta, selezione, trattamento e smaltimento dei rifiuti. Contribuiscono a valutare ed attuare programmi per la bonifica e il risanamento di aree inquinate."
        },
        {
          "code" : "3.2",
          "display" : "Professioni tecniche nelle scienze della salute e della vita",
          "definition" : "Le professioni classificate in questo gruppo, svolgono attività connesse alla applicazione ed all'esecuzione di protocolli terapeutici e scientifici relativi alla cura della salute umana ed alla produzione animale e vegetale. Pianificano, gestiscono e valutano gli interventi assistenziali infermieristici, garantiscono la corretta applicazione delle prescrizioni diagnostico-terapeutiche, assistono le partorienti e i neonati, eseguono procedure diagnostiche, preparano protesi, orientano a regimi sanitariamente corretti, verificano e controllano l’applicazione delle norme in materia di sicurezza sanitaria negli ambienti pubblici e di lavoro. Assistono i veterinari e gli agronomi nella cura e nella produzione animale e vegetale, applicano ed eseguono protocolli scientifici nei laboratori di analisi mediche e nei laboratori agronomici e veterinari."
        },
        {
          "code" : "3.2.1",
          "display" : "Tecnici della salute",
          "definition" : "Le professioni comprese in questa classe pianificano, gestiscono e valutano gli interventi assistenziali infermieristici, garantiscono la corretta applicazione delle prescrizioni diagnostico-terapeutiche, assistono le partorienti e i neonati, eseguono procedure diagnostiche, preparano protesi, orientano a regimi sanitariamente corretti, verificano e controllano l’applicazione delle norme in materia di sicurezza sanitaria negli ambienti pubblici e di lavoro, praticano cure derivate dalla medicina popolare e tradizionale."
        },
        {
          "code" : "3.2.1.1",
          "display" : "Professioni sanitarie infermieristiche ed ostetriche",
          "definition" : "Le professioni comprese in questa categoria svolgono, con autonomia professionale, attività dirette alla prevenzione, alla cura e salvaguardia della salute individuale e collettiva, espletando le funzioni individuate dalle norme istitutive dei relativi profili professionali nonché dagli specifici codici deontologici ed utilizzando metodologie di pianificazione per obiettivi dell'assistenza nell'età evolutiva, adulta e geriatrica. L’esercizio delle professioni di Infermiere, Infermiere pediatrico e Ostetrica è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.1.1",
          "display" : "Professioni sanitarie infermieristiche",
          "definition" : "Le professioni comprese in questa unità sono responsabili dell'assistenza generale infermieristica. L'assistenza infermieristica, preventiva, curativa, palliativa e riabilitativa è di natura tecnica, relazionale, educativa. Le principali funzioni sono la prevenzione delle malattie, l'assistenza dei malati e dei disabili di tutte le età e l'educazione sanitaria. Le professioni qui classificate partecipano all'identificazione dei bisogni di salute della persona e della collettività; identificano i bisogni di assistenza infermieristica della persona e della collettività e formulano i relativi obiettivi; pianificano, gestiscono e valutano l'intervento assistenziale infermieristico; garantiscono la corretta applicazione delle prescrizioni diagnostico-terapeutiche."
        },
        {
          "code" : "3.2.1.1.2",
          "display" : "Professioni sanitarie ostetriche",
          "definition" : "Le professioni comprese in questa unità assistono e consigliano la donna nel periodo della gravidanza, durante il parto e nel puerperio, conducono e portano a termine parti eutocici con propria responsabilità e prestano assistenza al neonato. Per quanto di loro competenza, partecipano ad interventi di educazione sanitaria e sessuale sia nell'ambito della famiglia che nella comunità; alla preparazione psicoprofilattica al parto; alla preparazione e all'assistenza ad interventi ginecologici; alla prevenzione e all'accertamento dei tumori della sfera genitale femminile; ai programmi di assistenza materna e neonatale; gestiscono, nel rispetto dell'etica professionale, come membri dell'équipe sanitaria, gli interventi assistenziali di loro competenza; sono in grado di individuare situazioni potenzialmente patologiche che richiedono l'intervento medico e di praticare, ove occorra, le relative misure di particolare emergenza."
        },
        {
          "code" : "3.2.1.2",
          "display" : "Professioni sanitarie riabilitative",
          "definition" : "Le professioni comprese in questa categoria applicano i protocolli e i principi medicali e sanitari per la riabilitazione, la cura e la prevenzione delle patologie, dei disordini e delle disabilità motorie, psicomotorie e del linguaggio, dei disturbi motori e sensoriali della vista, delle patologie neuropsichiatriche dell'età evolutiva, delle patologie psichiatriche, della terapia educativa finalizzata al reinserimento psicosociale di soggetti in difficoltà."
        },
        {
          "code" : "3.2.1.2.1",
          "display" : "Podologi",
          "definition" : "Le professioni comprese in questa unità trattano direttamente, nel rispetto della normativa vigente, dopo esame obiettivo del piede, con metodi incruenti, ortesici ed idromassoterapici, le callosità, le unghie ipertrofiche, deformi e incarnite, nonché il piede doloroso. Su prescrizione medica, prevengono e svolgono la medicazione delle ulcerazioni delle verruche del piede; individuano e segnalano al medico le sospette condizioni patologiche che richiedono un approfondimento diagnostico o un intervento terapeutico. L’esercizio della professione di Podologo è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.2.2",
          "display" : "Fisioterapisti",
          "definition" : "Le professioni comprese in questa unità svolgono, in via autonoma o in collaborazione con altre figure sanitarie, interventi di prevenzione, cura e riabilitazione nelle aree della motricità, delle funzioni corticali superiori, e di quelle viscerali conseguenti a eventi patologici a eziologia congenita od acquisita. In riferimento alla diagnosi ed alle prescrizioni del medico, nell'ambito delle loro competenze, elaborano, anche in equipe multidisciplinare, la definizione del programma di riabilitazione volto all'individuazione ed al superamento del bisogno di salute del disabile; praticano autonomamente attività terapeutica per la rieducazione funzionale delle disabilità motorie, psicomotorie e cognitive utilizzando terapie fisiche, manuali, massoterapiche e occupazionali; propongono l'adozione di protesi ed ausili, ne addestrano all'uso e ne verificano l'efficacia; verificano le rispondenze della metodologia riabilitativa attuata agli obiettivi di recupero funzionale. L’esercizio della professione di Fisioterapista è regolamentata dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.2.3",
          "display" : "Logopedisti",
          "definition" : "Le professioni comprese in questa unità svolgono attività nella prevenzione e nel trattamento riabilitativo delle patologie del linguaggio e della comunicazione in età evolutiva, adulta e geriatrica. L'attività è volta all'educazione e rieducazione di tutte le patologie che provocano disturbi della voce, della parola, del linguaggio orale e scritto e degli handicap comunicativi. Essi, in riferimento alla diagnosi ed alla prescrizione del medico, nell'ambito delle loro competenze, elaborano, anche in equipe multidisciplinare, il bilancio logopedico volto all'individuazione ed al superamento del bisogno di salute del disabile; praticano autonomamente attività terapeutica per la rieducazione funzionale delle disabilità comunicative e cognitive, utilizzando terapie logopediche di abilitazione e riabilitazione della comunicazione e del linguaggio, verbali e non verbali; propongono l'adozione di ausili, ne addestrano all'uso e ne verificano l'efficacia. L’esercizio della professione di Logopedista è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.2.4",
          "display" : "Ortottisti - assistenti di oftalmologia",
          "definition" : "Le professioni comprese in questa unità trattano, su prescrizione del medico, disturbi motori e sensoriali della visione ed effettuano le tecniche di semeiologia strumentale-oftalmologica. Sono responsabili dell'organizzazione, della pianificazione e della qualità degli atti professionali svolti nell'ambito delle loro mansioni. L’esercizio della professione di Ortottista-assistente di oftalmologia è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.2.5",
          "display" : "Terapisti della neuro e psicomotricità dell’età evolutiva",
          "definition" : "Le professioni comprese in questa unità svolgono, in collaborazione con l'equipe multiprofessionale di neuropsichiatria infantile e in collaborazione con le altre discipline dell'area pediatrica, interventi di prevenzione, terapia e riabilitazione delle malattie neuropsichiatriche infantili, nelle aree della neuro-psicomotricità, della neuropsicologia e della psicopatologia dello sviluppo. In riferimento alle diagnosi e alle prescrizioni mediche, nell'ambito delle specifiche competenze, adattano gli interventi terapeutici alle peculiari caratteristiche dei pazienti in età evolutiva con quadri clinici multiformi che si modificano nel tempo in relazione alle funzioni emergenti; attuano interventi terapeutici e riabilitativi nei disturbi percettivo-motori, neurocognitivi e nei disturbi di simbolizzazione e di interazione del bambino; attuano procedure rivolte all'inserimento dei soggetti portatori di disabilità e di handicap neuro-psicomotorio e cognitivo; svolgono attività terapeutica per le disabilità neuro-psicomotorie, psicomotorie e neuropsicologiche in età evolutiva utilizzando tecniche specifiche per fascia d'età e per singoli stadi di sviluppo; partecipano alla riabilitazione funzionale in tutte le patologie acute e croniche dell'infanzia; documentano le rispondenze della metodologia riabilitativa attuata secondo gli obiettivi di recupero funzionale e le caratteristiche proprie delle patologie che si modificano in rapporto allo sviluppo. L’esercizio della professione di Terapista della neuro e psicomotricità dell'età evolutiva è regolamentata dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.2.6",
          "display" : "Tecnici della riabilitazione psichiatrica",
          "definition" : "Le professioni comprese in questa unità svolgono, nell'ambito di un progetto terapeutico elaborato in un equipe multidisciplinare, interventi riabilitativi ed educativi sui soggetti con disabilità psichica. Collaborano alla valutazione della disabilità psichica e delle potenzialità del soggetto, all'identificazione degli obiettivi formativo-terapeuci e di riabilitazione psichiatrica nonché alla formulazione dello specifico programma di intervento mirato al recupero e allo sviluppo del soggetto in trattamento; attuano interventi volti all'abilitazione/riabilitazione dei soggetti alla cura di sè e alle relazioni interpersonali di varia complessità nonché, ove possibile, ad un'attività lavorativa; operano nel contesto della prevenzione primaria sul territorio, operano sulle famiglie e sul contesto sociale dei soggetti allo scopo di favorirne il reinserimento nella comunità; collaborano alla valutazione degli esiti del programma di abilitazione e riabilitazione nei singoli soggetti, in relazione agli obiettivi prefissati. L’esercizio della professione di Tecnico riabilitazione psichiatrica è regolamentata dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.2.7",
          "display" : "Educatori professionali",
          "definition" : "Le professioni comprese in questa unità attuano specifici progetti educativi e riabilitativi, nell'ambito di un progetto terapeutico elaborato da un'équipe multidisciplinare, volti a uno sviluppo equilibrato della personalità con obiettivi educativo/relazionali in un contesto di partecipazione e recupero alla vita quotidiana; curano il positivo inserimento o reinserimento psico-sociale dei soggetti in difficoltà. Programmano, gestiscono e verificano interventi educativi mirati al recupero e allo sviluppo delle potenzialità dei soggetti in difficoltà per il raggiungimento di livelli sempre più avanzati di autonomia; organizzano, gestiscono e verificano le loro attività professionali all'interno di servizi socio-sanitari e strutture socio-sanitarie-riabilitative e socio educative, in modo coordinato e integrato con altre figure professionali presenti nelle strutture, con il coinvolgimento diretto dei soggetti interessati e/o delle loro famiglie, dei gruppi, della collettività. L’esercizio della professione di Educatore professionale è regolamentata dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.2.8",
          "display" : "Terapisti occupazionali",
          "definition" : "Le professioni comprese in questa unità operano nell'ambito della prevenzione, cura e riabilitazione dei soggetti affetti da malattie e disordini fisici o psichici con disabilità temporanee o permanenti, utilizzando attività espressive, manuali-rappresentative, ludiche, della vita quotidiana. In riferimento alla diagnosi ed alle prescrizioni del medico, nell'ambito delle loro competenze ed in collaborazione con altre figure socio-sanitarie, effettuano una valutazione funzionale e psicologica del soggetto ed elaborano, anche in equipe multidisciplinare, la definizione del programma riabilitativo, volto all'individuazione ed al superamento dei bisogni del disabile ed al suo avviamento verso l'autonomia personale nell'ambiente di vita quotidiana e nel tessuto sociale; utilizzano attività sia individuali che di gruppo, promuovendo il recupero e l'uso ottimale di funzioni finalizzate al reinserimento, all'adattamento e all'integrazione dell'individuo nel proprio ambiente personale, domestico e sociale; partecipano alla scelta e all'ideazione di ortesi congiuntamente o in alternativa a specifici ausili; verificano le rispondenze tra la metodologia riabilitativa attuata e gli obiettivi di recupero funzionale e psicosociale. L’esercizio della professione di Terapista occupazionale è regolamentata dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.3",
          "display" : "Professioni tecnico sanitarie - area tecnico diagnostica",
          "definition" : "Le professioni comprese in questa categoria applicano i protocolli e i principi medicali e sanitari nella prevenzione, valutazione e riabilitazione del sistema uditivo, nelle attività diagnostiche e terapeutiche che utilizzano radiazioni ionizzanti, energie termiche, ultrasoniche e a risonanza magnetica, nelle patologie del sistema nervoso, nonchè nelle attività di ricerca biomedica e biotecnologica."
        },
        {
          "code" : "3.2.1.3.1",
          "display" : "Tecnici audiometristi",
          "definition" : "Le professioni comprese in questa unità svolgono la loro attività nella prevenzione, valutazione e riabilitazione delle patologie del sistema uditivo e vestibolare, nel rispetto delle attribuzioni e delle competenze diagnostico-terapeutiche del medico. L'attività è volta all'esecuzione di tutte le prove non invasive, psico-acustiche ed elettrofisiologiche di valutazione e misura del sistema uditivo e vestibolare ed alla riabilitazione dell'handicap conseguente a patologia dell'apparato uditivo e vestibolare. Operano, su prescrizione del medico, mediante atti professionali che implicano la piena responsabilità e la conseguente autonomia; collaborano con altre figure professionali ai programmi di prevenzione e di riabilitazione delle sordità utilizzando tecniche e metodologie strumentali e protesiche; svolgono la loro attività professionale in strutture sanitarie, pubbliche o private, in regime di dipendenza o libero-professionale. L’esercizio della professione di Tecnico audiometrista è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.3.2",
          "display" : "Tecnici sanitari di laboratorio biomedico",
          "definition" : "Le professioni comprese in questa unità svolgono attività di laboratorio di analisi e di ricerca relative ad analisi biomediche e biotecnologiche ed in particolare di biochimica, di microbiologia e virologia, di farmacotossicologia, di immunologia, di patologia clinica, di ematologia, di citologia e di istopatologia. Svolgono con autonomia tecnico professionale le loro prestazioni lavorative in diretta collaborazione con il personale laureato di laboratorio preposto alle diverse responsabilità operative di appartenenza; sono responsabili, nelle strutture di laboratorio, del corretto adempimento delle procedure analitiche e del loro operato, controllano e verificano il corretto funzionamento delle apparecchiature utilizzate, provvedono alla manutenzione ordinaria ed alla eventuale eliminazione di piccoli inconvenienti. L’esercizio della professione di Tecnico sanitario di laboratorio biomedico è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.3.3",
          "display" : "Tecnici sanitari di radiologia medica",
          "definition" : "Le professioni comprese in questa unità sono autorizzate ad espletare indagini e prestazioni radiologiche, nel rispetto delle norme di radioprotezione previste dall'Unione Europea. Sono abilitati a svolgere, in via autonoma, o in collaborazione con altre figure sanitarie, su prescrizione medica tutti gli interventi che richiedono l'uso di sorgenti di radiazioni ionizzanti, sia artificiali che naturali, di energie termiche, ultrasoniche, di risonanza magnetica nucleare nonchè gli interventi per la protezionistica fisica o dosimetrica; partecipano alla programmazione e organizzazione del lavoro nell'ambito della struttura in cui operano nel rispetto delle loro competenze; programmano e gestiscono l'erogazione di prestazioni polivalenti di loro competenza in collaborazione diretta con il medico radiodiagnosta, con il medico nucleare, con il medico radioterapista e con il fisico sanitario, secondo protocolli diagnostici e terapeutici preventivamente definiti dal responsabile della struttura; controllano il corretto funzionamento delle apparecchiature loro affidate, provvedendo alla eliminazione di inconvenienti di modesta entità e attuando programmi di verifica e controllo a garanzia della qualità secondo indicatori e standard predefiniti. L’esercizio della professione di Tecnico sanitario di radiologia medica è regolamentata dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.3.4",
          "display" : "Tecnici di neurofisiopatologia",
          "definition" : "Le professioni comprese in questa unità svolgono la loro attività nell'ambito della diagnosi delle patologie del sistema nervoso, applicando direttamente, su prescrizione medica, le metodiche diagnostiche specifiche in campo neurologico e neurochirurgico (elettroencefalografia, elettroneuromiografia, poligrafia, potenziali evocati, ultrasuoni). Applicano le metodiche più idonee per la registrazione dei fenomeni bioelettrici, con diretto intervento sul paziente e sulle apparecchiature ai fini della realizzazione di un programma di lavoro diagnostico-strumentale o di ricerca neurofisiologica predisposto in stretta collaborazione con il medico specialista; hanno dirette responsabilità nell'applicazione e nel risultato finale della metodica diagnostica utilizzata; impiegano metodiche diagnostico-strumentali per l'accertamento dell'attività elettrocerebrale ai fini clinici e/o medico-legali; provvedono alla predisposizione e controllo della strumentazione delle apparecchiature in dotazione. L’esercizio della professione di Tecnico di neurofisiopatologia è regolamentata dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.4",
          "display" : "Professioni tecnico sanitarie - area tecnico assistenziale",
          "definition" : "Le professioni comprese in questa categoria applicano i protocolli e i principi medicali e sanitari per la realizzazione, applicazione e addestramento all'uso di protesi dell'apparato locomotorio e uditivo; per l'assistenza nelle terapie basate su tecniche di circolazione extracorporea ed emodinamiche; per le attività di educazione all'igiene orale e alimentare."
        },
        {
          "code" : "3.2.1.4.1",
          "display" : "Tecnici ortopedici",
          "definition" : "Le professioni comprese in questa unità operano, su prescrizione medica e successivo collaudo, la costruzione e/o adattamento, applicazione e fornitura di protesi, ortesi e di ausili sostitutivi, correttivi e di sostegno dell'apparato locomotore, di natura funzionale ed estetica, di tipo meccanico o che utilizzano l'energia esterna o energia mista corporea ed esterna, mediante rilevamento diretto sul paziente di misure e modelli. Addestrano il disabile all'uso delle protesi e delle ortesi applicate; svolgono, in collaborazione con il medico, assistenza tecnica per la fornitura, la sostituzione e la riparazione delle protesi e delle ortesi applicate; collaborano con altre figure professionali al trattamento multidisciplinare previsto nel piano di riabilitazione. L’esercizio della professione di Tecnico ortopedico è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.4.2",
          "display" : "Tecnici audioprotesisti",
          "definition" : "Le professioni comprese in questa unità svolgono la loro attività nella fornitura, adattamento e controllo dei presidi protesici per la prevenzione e correzione dei deficit uditivi; operano su prescrizione del medico mediante atti professionali che implicano la piena responsabilità e la conseguente autonomia. L'attività è volta all'applicazione dei presidi protesici mediante il rilievo dell'impronta del condotto uditivo esterno, la costruzione e applicazione delle chiocciole o di altri sistemi di accoppiamento acustico e la somministrazione di prove di valutazione protesica. Collaborano con altre figure professionali ai programmi di prevenzione e di riabilitazione delle sordità mediante la fornitura di presidi protesici e l'addestramento al loro uso. L’esercizio della professione di Tecnico audioprotesista è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.4.3",
          "display" : "Igienisti dentali",
          "definition" : "Le professioni comprese in questa unità svolgono, su indicazione degli odontoiatri e dei medici chirurghi legittimati all'esercizio dell'odontoiatria, compiti relativi alla prevenzione delle affezioni orodentali. Svolgono attività di educazione sanitaria dentale e partecipano a progetti di prevenzione primaria nell'ambito del sistema sanitario pubblico; collaborano alla compilazione della cartella clinica odontostomatologica e si occupano della raccolta di dati tecnico-statistici; provvedono all'ablazione del tartaro e alla levigatura delle radici nonchè all'applicazione topica dei vari mezzi profilattici; provvedono all'istruzione sulle varie metodiche di igiene orale e sull'uso dei mezzi diagnostici idonei ad evidenziare placca batterica e patina dentale motivando l'esigenza dei controlli clinici periodici; indicano le norme di un'alimentazione razionale ai fini della tutela della salute dentale. L’esercizio della professione di Igienista dentale è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.4.4",
          "display" : "Tecnici della fisiopatologia cardiocircolatoria e della perfusione cardiovascolare",
          "definition" : "Le professioni comprese in questa unità provvedono alla conduzione e manutenzione delle apparecchiature relative alle tecniche di circolazione extracorporea ed alle tecniche di emodinamica. Le loro mansioni sono di natura tecnica; coadiuvano il personale medico negli ambienti idonei fornendo indicazioni essenziali o conducendo, sempre sotto indicazione medica, apparecchiature finalizzate alla diagnostica emodinamica o vicariati le funzioni cardiocircolatorie. Pianificano, gestiscono e valutano quanto necessario per il buon funzionamento delle apparecchiature di cui sono responsabili; garantiscono la corretta applicazione delle tecniche di supporto richieste. L’esercizio della professione di Tecnico della fisiopatologia cardiocircolatoria e della perfusione cardiovascolare è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.4.5",
          "display" : "Dietisti",
          "definition" : "Le professioni comprese in questa unità sono competenti nelle attività finalizzate alla corretta applicazione dell'alimentazione e della nutrizione ivi compresi gli aspetti educativi e di collaborazione all'attuazione delle politiche alimentari. Organizzano e coordinano le attività specifiche relative all'alimentazione in generale e alla dietetica in particolare; collaborano con gli organi preposti alla tutela dell'aspetto igienico sanitario del servizio di alimentazione; elaborano, formulano ed attuano le diete prescritte dal medico e ne controllano l'accettabilità da parte del paziente; collaborano con altre figure al trattamento multidisciplinare dei disturbi del comportamento alimentare; studiano ed elaborano la composizione di razioni alimentari atte a soddisfare i bisogni nutrizionali di gruppi di popolazione e pianificano l'organizzazione dei servizi di alimentazione di comunità di sani e di malati; svolgono attività didattico-educativa e di informazione finalizzate alla diffusione di principi di alimentazione corretta, tale da consentire il recupero e il mantenimento di un buono stato di salute del singolo, di collettività e di gruppi di popolazione. L'esercizio della professione di Dietista è regolamentata dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.5",
          "display" : "Professioni tecniche della prevenzione",
          "definition" : "Le professioni comprese in questa categoria applicano i protocolli e i principi medicali e sanitari nelle attività di educazione alla salute, di prevenzione, verifica e controllo dell'igiene e della sicurezza ambientale nei luoghi pubblici e di lavoro."
        },
        {
          "code" : "3.2.1.5.1",
          "display" : "Tecnici della prevenzione nell’ambiente e nei luoghi di lavoro",
          "definition" : "Le professioni comprese in questa unità sono responsabili, nell'ambito delle loro competenze, delle attività di prevenzione, verifica e controllo in materia di igiene e sicurezza ambientale nei luoghi di vita e di lavoro, di igiene degli alimenti e delle bevande, di igiene di sanità pubblica e veterinaria. Svolgono attività istruttoria, finalizzata al rilascio di autorizzazioni o di nulla osta tecnico-sanitari per attività soggette a controllo; istruiscono, determinano, contestano e notificano le irregolarità rilevate e formulano pareri nell'ambito delle loro competenze. Vigilano e controllano gli ambienti di vita e di lavoro, la rispondenza delle strutture e degli ambienti in relazione alle attività ad essi connesse, le condizioni di sicurezza degli impianti, la qualità degli alimenti e bevande destinati all'alimentazione, dalla produzione al consumo, i prodotti cosmetici, l'igiene e sanità veterinaria e valutano la necessità di procedere a successive indagini specialistiche. Collaborano con l'amministrazione giudiziaria per indagini sui reati contro il patrimonio ambientale, sulle condizioni di igiene e sicurezza nei luoghi di lavoro e sugli alimenti. Partecipano ad attività di studio, didattica e consulenza professionale nei servizi sanitari e nei luoghi dove è richiesta la loro competenza professionale. L’esercizio della professione di Tecnico della prevenzione nell'ambiente e nei luoghi di lavoro è regolamentata dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.5.2",
          "display" : "Assistenti sanitari",
          "definition" : "Le professioni comprese in questa unità sono addette alla prevenzione, alla promozione e all'educazione per la salute della persona, della famiglia e della collettività. Sulla base di dati epidemiologici e socio-culturali, individuano i bisogni di salute e le priorità di intervento preventivo, educativo e di recupero, i fattori biologici e sociali di rischio; progettano, programmano, attuano e valutano gli interventi di educazione alla salute in tutte le fasi della vita della persona; collaborano alla definizione delle metodologie di comunicazione, a programmi e campagne per la promozione e l'educazione sanitaria; concorrono alla formazione e all'aggiornamento degli operatori sanitari e scolastici per quanto concerne la metodologia dell'educazione sanitaria; intervengono nei programmi di pianificazione familiare e di educazione sanitaria, sessuale e socio-affettiva; attuano interventi specifici di sostegno alla famiglia; sorvegliano, per quanto di loro competenza, le condizioni igienico-sanitarie nelle famiglie, nelle scuole e nelle comunità assistite e controllano il rischio infettivo; collaborano, per quanto di loro competenza, agli interventi di promozione ed educazione alla salute nelle scuole; partecipano alle iniziative di valutazione e miglioramento alla qualità delle prestazioni dei servizi sanitari rilevando, in particolare, i livelli di gradimento da parte degli utenti. L’esercizio della professione di Assistente sanitario è regolamentata dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.6",
          "display" : "Altre professioni tecniche della salute",
          "definition" : "Le professioni comprese in questa categoria esaminano, con tecniche optometriche, le deficienze visive, confezionano, apprestano, riparano e vendono direttamente al pubblico, su prescrizione medica, occhiali e lenti protettive o correttive dei disturbi visivi; costruiscono, verificano e ottimizzano dispositivi odontoiatrici su misura seguendo le specifiche progettuali rilasciate dall'odontoiatra."
        },
        {
          "code" : "3.2.1.6.1",
          "display" : "Ottici e ottici optometristi",
          "definition" : "Le professioni comprese in questa unità esaminano, con tecniche optometriche, le deficienze visive, confezionano, apprestano, riparano e vendono direttamente al pubblico, su prescrizione medica, occhiali e lenti protettive o correttive dei disturbi visivi. L’esercizio della professione di Ottico è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.6.2",
          "display" : "Odontotecnici",
          "definition" : "Le professioni comprese in questa unità costruiscono, verificano e ottimizzano dispositivi odontoiatrici su misura seguendo le specifiche progettuali rilasciate dall'odontoiatra. L’esercizio della professione di Odontotecnico è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.1.7",
          "display" : "Tecnici della medicina popolare",
          "definition" : "Le professioni classificate in questa categoria trattano i disturbi del benessere umano, forniscono servizi riabilitativi e di cura utilizzando metodiche, trattamenti e sostanze tradizionalmente usati dalla medicina popolare e ritenuti efficaci nello stimolare, migliorare e preservare la salute e il benessere della persona."
        },
        {
          "code" : "3.2.1.7.0",
          "display" : "Tecnici della medicina popolare",
          "definition" : "Le professioni classificate in questa unità trattano i disturbi del benessere umano, forniscono servizi riabilitativi e di cura utilizzando metodiche, trattamenti e sostanze tradizionalmente usati dalla medicina popolare e ritenuti efficaci nello stimolare, migliorare e preservare la salute e il benessere della persona."
        },
        {
          "code" : "3.2.2",
          "display" : "Tecnici nelle scienze della vita",
          "definition" : "Le professioni comprese in questa classe assistono gli specialisti nelle attività di ricerca in materia ovvero applicano ed eseguono procedure e tecniche proprie nella cura e nella produzione di piante, di animali e nelle ricerche e nelle analisi biologiche e biochimiche."
        },
        {
          "code" : "3.2.2.1",
          "display" : "Tecnici agronomi e forestali",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti, ovvero eseguono procedure e tecniche proprie nella progettazione di sistemi agricoli, agroalimentari e zootecnici, nel miglioramento delle colture e delle relative condizioni di crescita e di difesa; l’individuazione delle colture più adattabili e più redditizie, l’individuazione e nel controllo delle malattie dei vegetali, la conservazione della biodiversità colturale; la progettazione di sistemi forestali; la gestione, il miglioramento e la protezione delle risorse ambientali e naturali, la loro messa a produzione; il mantenimento e la tutela della biodiversità florofaunistica. L’esercizio delle professioni di Agronomo junior, Forestale junior, Agrotecnico, Agrotecnico laureato, Perito agrario e Perito agrario laureato è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.2.1.1",
          "display" : "Tecnici agronomi",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti ovvero eseguono procedure e tecniche proprie nella progettazione di sistemi agricoli, agroalimentari e zootecnici, nel miglioramento delle colture e delle relative condizioni di crescita e di difesa, nell’individuazione delle colture più adattabili e più redditizie, nell’individuazione e nel controllo delle malattie dei vegetali, nella conservazione della biodiversità colturale."
        },
        {
          "code" : "3.2.2.1.2",
          "display" : "Tecnici forestali",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti nella progettazione di sistemi forestali, nella gestione, nel miglioramento e nella protezione delle risorse ambientali e naturali, nella loro messa a produzione e nel mantenimento e nella tutela della biodiversità florofaunistica."
        },
        {
          "code" : "3.2.2.2",
          "display" : "Zootecnici",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti ovvero eseguono procedure e tecniche proprie nell’allevamento degli animali, nella individuazione delle condizioni ambientali e nutrizionali ottimali per la produzione, nel miglioramento delle specie e nella riproduzione animale attraverso attività di inseminazione strumentale, di impianto embrionale e di sincronizzazione dei calori, nell’esecuzione delle terapie sotto il controllo e la guida del medico veterinario, nelle attività di difesa dell'ambiente e di conservazione della biodiversità animale e dei microrganismi."
        },
        {
          "code" : "3.2.2.2.0",
          "display" : "Zootecnici",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti ovvero eseguono procedure e tecniche proprie nell’allevamento degli animali, nella individuazione delle condizioni ambientali e nutrizionali ottimali per la produzione, nel miglioramento delle specie e nella riproduzione animale attraverso attività di inseminazione strumentale, di impianto embrionale e di sincronizzazione dei calori, nell’esecuzione delle terapie sotto il controllo e la guida del medico veterinario, nelle attività di difesa dell'ambiente e di conservazione della biodiversità animale e dei microrganismi. L’esercizio della professione di Zoonomo è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.2.3",
          "display" : "Tecnici biochimici e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti ovvero eseguono procedure e tecniche analitiche per condurre test ed analisi biochimiche, microbiologiche, virologiche, farmacologiche, ematologiche, immunologiche, citologiche e istopatologiche nel campo della diagnostica clinica e della ricerca medica; per condurre test ed analisi finalizzate alla diagnosi delle patologie animali e vegetali e alla ricerca in campo agronomico e zootecnico; per condurre test ed analisi sulla qualità dei prodotti destinati all’alimentazione umana e animale, per certificarne la qualità, la derivazione genetica e la tecnologia di produzione, per migliorare le filiere di trasformazione e di produzione alimentare; per rilevare, presso laboratori e cliniche, sintomi di malattia sugli animali domestici, prelevare campioni organici per le analisi, sterilizzare ambienti e attrezzi chirurgici, somministrare cure."
        },
        {
          "code" : "3.2.2.3.1",
          "display" : "Tecnici di laboratorio biochimico",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti conducendo test ed analisi finalizzate alla verifica e alla valutazione della composizione chimica, fisica e biologica di acque, prodotti naturali o industriali, alla diagnosi delle patologie animali e vegetali e alla ricerca in campo agronomico e zootecnico."
        },
        {
          "code" : "3.2.2.3.2",
          "display" : "Tecnici dei prodotti alimentari",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti conducendo test ed analisi sulla qualità dei prodotti destinati all’alimentazione umana e animale, per certificarne la qualità, la derivazione genetica e la tecnologia di produzione, per migliorare le filiere di trasformazione e di produzione alimentare. L’esercizio della professione di Biotecnologo agrario è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.2.2.3.3",
          "display" : "Tecnici di laboratorio veterinario",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti nel rilevare, presso laboratori e cliniche, sintomi di malattia sugli animali domestici, prelevare campioni organici per le analisi, sterilizzare ambienti e attrezzi chirurgici, somministrare cure."
        },
        {
          "code" : "3.3",
          "display" : "Professioni tecniche nell’organizzazione, amministrazione e nelle attività finanziarie e commerciali",
          "definition" : "Le professioni classificate in questo gruppo svolgono attività connesse all'applicazione di conoscenze in materia di gestione, amministrazione e organizzazione aziendale, di fornitura di servizi finanziari, bancari ed assicurativi; di acquisizione, vendita, commercializzazione e distribuzione di prodotti e servizi sul mercato. Curano gli aspetti organizzativo-gestionali delle imprese, tengono libri e scritture contabili e sociali."
        },
        {
          "code" : "3.3.1",
          "display" : "Tecnici dell’organizzazione e dell’amministrazione delle attività produttive",
          "definition" : "Le professioni comprese in questa classe assistono i responsabili degli uffici di imprese ed organizzazioni implementando e supportando le attività di comunicazione, documentazione e di coordinamento di una o più unità organizzative; analizzano il funzionamento dell'organizzazione in termini di efficacia ed efficienza dell'uso delle risorse, curano gli aspetti organizzativi e gestionali delle imprese; tengono i libri e le scritture contabili e sociali; implementano sistemi di controllo amministrativo delle attività di produzione; rilevano e trasferiscono informazioni; curano le attività di corrispondenza con partner e clienti esteri."
        },
        {
          "code" : "3.3.1.1",
          "display" : "Segretari amministrativi, archivisti, tecnici degli affari generali e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria forniscono servizi amministrativi di livello elevato eseguendo ricerche documentaristiche, preparando rapporti informativi, redigendo verbali di riunioni, gestendo richieste di informazioni, minutando corrispondenza, accogliendo visite, organizzando e schedulando incontri e conferenze; classificano e archiviano documenti ed altri supporti informativi e partecipano a ricerche sui materiali informativi disponibili."
        },
        {
          "code" : "3.3.1.1.1",
          "display" : "Segretari amministrativi e tecnici degli affari generali",
          "definition" : "Le professioni comprese in questa unità forniscono servizi amministrativi di livello elevato eseguendo ricerche documentaristiche, preparando rapporti informativi, redigendo verbali di riunioni, gestendo richieste di informazioni, minutando corrispondenza, accogliendo visite, organizzando e schedulando incontri e conferenze."
        },
        {
          "code" : "3.3.1.1.2",
          "display" : "Assistenti di archivio e di biblioteca",
          "definition" : "Le professioni comprese in questa unità forniscono servizi amministrativi di livello elevato classificando e archiviando documenti ed altri supporti informativi e partecipando a ricerche sui materiali informativi disponibili."
        },
        {
          "code" : "3.3.1.2",
          "display" : "Contabili e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti, ovvero applicano le procedure in materia di tenuta delle scritture contabili di società o di organizzazioni; analizzano, classificano e registrano le operazioni contabili e le poste di bilancio; interpretano e valutano i conti; redigono i bilanci, attendono a procedure ed adempimenti fiscali; redigono paghe, compensi e versamenti contributivi; gestiscono le operazioni in liquidità di imprese ed organizzazioni; adempiono a mandati di pagamento; evadono conti e fatture certificando e mantenendo scritture delle operazioni; curano l’amministrazione di edifici e di proprietà condominiali garantendo la manutenzione, il funzionamento dei servizi comuni e la sicurezza degli impianti e delle strutture."
        },
        {
          "code" : "3.3.1.2.1",
          "display" : "Contabili",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti ovvero applicano le procedure in materia di tenuta delle scritture contabili di società o di organizzazioni, analizzano, classificano e registrano le operazioni contabili e le poste di bilancio; interpretano e valutano i conti, redigono i bilanci, attendono a procedure ed adempimenti fiscali; redigono paghe, compensi e versamenti contributivi. L’esercizio delle professioni di Consulente del lavoro, Revisore legale, Esperto contabile e Ragioniere commercialista è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.3.1.2.2",
          "display" : "Economi e tesorieri",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti ovvero gestiscono le operazioni in liquidità di imprese ed organizzazioni; adempiono a mandati di pagamento, evadono conti e fatture certificando e mantenendo scritture delle operazioni."
        },
        {
          "code" : "3.3.1.2.3",
          "display" : "Amministratore di stabili e condomini",
          "definition" : "Le professioni comprese in questa unità curano l’amministrazione di edifici e di proprietà condominiali garantendo la manutenzione, il funzionamento dei servizi comuni e la sicurezza degli impianti e delle strutture."
        },
        {
          "code" : "3.3.1.3",
          "display" : "Tecnici del trasferimento e del trattamento delle informazioni",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti nella ricerca e nella acquisizione di informazioni, ovvero applicano le conoscenze e gli strumenti esistenti per rintracciare, localizzare e acquisire informazioni utili per specifiche esigenze di imprese o di organizzazioni e per analizzarle, organizzarle e confezionarle in maniera rilevante e significativa per il committente; per compiere ricerche bibliografiche e condurre interviste strutturate e semi strutturate con questionari e strumentazioni complesse in indagini e rilevazioni totali o campionarie disegnate su basi scientifiche."
        },
        {
          "code" : "3.3.1.3.1",
          "display" : "Tecnici dell'acquisizione delle informazioni",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti nella ricerca e nella acquisizione di informazioni, ovvero applicano le conoscenze e gli strumenti esistenti per rintracciare, localizzare e acquisire informazioni utili per specifiche esigenze di imprese o di organizzazioni e per analizzarle, organizzarle e confezionarle in maniera rilevante e significativa per il committente."
        },
        {
          "code" : "3.3.1.3.2",
          "display" : "Intervistatori e rilevatori professionali",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti nella ricerca e nella acquisizione di informazioni, ovvero conducono interviste strutturate e semi strutturate con questionari e strumentazioni complesse in indagini e rilevazioni totali o campionarie disegnate su basi scientifiche."
        },
        {
          "code" : "3.3.1.4",
          "display" : "Corrispondenti in lingue estere e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria forniscono servizi amministrativi collaborando con la direzione di un’impresa e di un’organizzazione nel mantenimento dei rapporti con l’estero, tenendo conversazioni telefoniche, utilizzando linguaggi tecnici o specifici, redigendo corrispondenza, documenti, verbali e prendendo appunti in lingua."
        },
        {
          "code" : "3.3.1.4.0",
          "display" : "Corrispondenti in lingue estere e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità forniscono servizi amministrativi collaborando con la direzione di un'impresa e di un’organizzazione nel mantenimento dei rapporti con l’estero, tenendo conversazioni telefoniche, utilizzando linguaggi tecnici o specifici, redigendo corrispondenza, documenti, verbali e prendendo appunti in lingua."
        },
        {
          "code" : "3.3.1.5",
          "display" : "Tecnici dell'organizzazione e della gestione dei fattori produttivi",
          "definition" : "Le professioni comprese in questa categoria applicano procedure e tecniche proprie per monitorare e ottimizzare i processi di produzione, la produttività del lavoro umano e degli impianti, la logistica e i costi di esercizio."
        },
        {
          "code" : "3.3.1.5.0",
          "display" : "Tecnici dell'organizzazione e della gestione dei fattori produttivi",
          "definition" : "Le professioni comprese in questa unità applicano procedure e tecniche proprie per monitorare e ottimizzare i processi di produzione, la produttività del lavoro umano e degli impianti, la logistica e i costi di esercizio."
        },
        {
          "code" : "3.3.2",
          "display" : "Tecnici delle attività finanziarie ed assicurative",
          "definition" : "Le professioni comprese in questa classe assistono gli specialisti nella gestione finanziaria di imprese, organizzazioni, banche ed assicurazioni; nell’erogazione al pubblico di servizi bancari e assicurativi; le famiglie nei loro investimenti finanziari; stimano e liquidano danni e calcolano rischi per le imprese assicurative e le banche; intermediano titoli e contratti."
        },
        {
          "code" : "3.3.2.1",
          "display" : "Tecnici della gestione finanziaria",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti nella rilevazione e nell’analisi dei dati finanziari e di investimento di imprese, organizzazioni o famiglie per individuare e valutare lo stato e i rischi delle relative esposizioni e per vendere adeguati prodotti finanziari. Mettono in relazione, anche attraverso attività di consulenza, banche o intermediari finanziari determinati con la potenziale clientela al fine della concessione di finanziamenti."
        },
        {
          "code" : "3.3.2.1.0",
          "display" : "Tecnici della gestione finanziaria",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti nella rilevazione e nell’analisi dei dati finanziari e di investimento di imprese, organizzazioni o famiglie per individuare e valutare lo stato e i rischi delle relative esposizioni e per vendere adeguati prodotti finanziari. Mettono in relazione, anche attraverso attività di consulenza, banche o intermediari finanziari determinati con la potenziale clientela al fine della concessione di finanziamenti. L’esercizio della professione di Promotore finanziario è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.3.2.2",
          "display" : "Tecnici del lavoro bancario",
          "definition" : "Le professioni comprese in questa categoria curano le attività amministrative bancarie in back ed in front office, fornendo ai clienti assistenza sui servizi bancari offerti; seguono le procedure per determinare i rischi connessi alla corresponsione di mutui e prestiti; individuano le condizioni ottimali per la loro restituzione."
        },
        {
          "code" : "3.3.2.2.0",
          "display" : "Tecnici del lavoro bancario",
          "definition" : "Le professioni comprese in questa unità curano le attività amministrative bancarie in back ed in front office, fornendo ai clienti assistenza sui servizi bancari offerti; seguono le procedure per determinare i rischi connessi alla corresponsione di mutui e prestiti; individuano le condizioni ottimali per la loro restituzione."
        },
        {
          "code" : "3.3.2.3",
          "display" : "Agenti assicurativi",
          "definition" : "Le professioni comprese in questa categoria forniscono ai clienti assistenza sui servizi assicurativi offerti; seguono le procedure per determinare il grado di rischio connesso alla sottoscrizione di polizze standard a determinati soggetti; sottoscrivono polizze per conto delle assicurazioni a favore di imprese, organizzazioni o persone."
        },
        {
          "code" : "3.3.2.3.0",
          "display" : "Agenti assicurativi",
          "definition" : "Le professioni comprese in questa unità forniscono ai clienti assistenza sui servizi assicurativi offerti; seguono le procedure per determinare il grado di rischio connesso alla sottoscrizione di polizze standard a determinati soggetti; sottoscrivono polizze per conto delle assicurazioni a favore di imprese, organizzazioni o persone."
        },
        {
          "code" : "3.3.2.4",
          "display" : "Periti, valutatori di rischio, liquidatori e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria raccolgono informazioni e dati per individuare responsabilità, stimare danni, per definire, secondo le procedure, l’ammontare dei pagamenti; istruiscono polizze non standard valutando, secondo procedura, i rischi connessi; liquidano le polizze verificando che le procedure di sottoscrizione della polizza, di stima dei danni o degli eventi, di valutazione delle condizioni contrattuali e dei corrispettivi da pagare siano state rispettate"
        },
        {
          "code" : "3.3.2.4.0",
          "display" : "Periti, valutatori di rischio e liquidatori",
          "definition" : "Le professioni comprese in questa unità raccolgono informazioni e dati per individuare responsabilità, stimare danni, per definire, secondo le procedure, l’ammontare dei pagamenti; istruiscono polizze non standard valutando, secondo procedura, i rischi connessi; liquidano le polizze verificando che le procedure di sottoscrizione della polizza, di stima dei danni o degli eventi, di valutazione delle condizioni contrattuali e dei corrispettivi da pagare siano state rispettate"
        },
        {
          "code" : "3.3.2.5",
          "display" : "Agenti di borsa e cambio, tecnici dell’intermediazione titoli e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria concludono in Borsa per conto di terzi o sul mercato operazioni di compravendita di titoli, divise o altri beni fungibili; intermediano l’acquisto e la cessione fra risparmiatori e speculatori; negoziano titoli pubblici e privati quotati ufficialmente nonché divise estere, accertandone il valore nel corso della negoziazione in Borsa; mettono in contatto, senza vincolo di mandato, i clienti con intermediari autorizzati alla erogazione di crediti per favorire la concessione di finanziamenti."
        },
        {
          "code" : "3.3.2.5.0",
          "display" : "Agenti di borsa e cambio, tecnici dell’intermediazione titoli e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità concludono in Borsa per conto di terzi o sul mercato operazioni di compravendita di titoli, divise o altri beni fungibili; intermediano l’acquisto e la cessione fra risparmiatori e speculatori; negoziano titoli pubblici e privati quotati ufficialmente nonché divise estere, accertandone il valore nel corso della negoziazione in Borsa; mettono in contatto, senza vincolo di mandato, i clienti con intermediari autorizzati alla erogazione di crediti per favorire la concessione di finanziamenti. L’esercizio della professione di Agente di cambio è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.3.2.6",
          "display" : "Tecnici della locazione finanziaria e dei contratti di scambio",
          "definition" : "Le professioni comprese nella categoria assistono gli specialisti nella redazione e nella definizione di contratti derivati finanziari e di credito ovvero applicano procedure standard per stipulare e seguire contratti di scambio di valute, valori mobiliari e beni eseguibili a scadenza dietro corresponsione di premi, di acquisto di crediti assumendo oneri di gestione, riscossione e contabilizzazione degli stessi; contratti di acquisto di beni mobili ed immobili e di concessione in uso degli stessi dietro corresponsione di locazioni finanziarie."
        },
        {
          "code" : "3.3.2.6.1",
          "display" : "Tecnici dei contratti di scambio, a premi e del recupero crediti",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti nella redazione e nella definizione di contratti, derivati finanziari e di credito ovvero applicano procedure standard per stipulare e seguire contratti di scambio di valute, valori mobiliari e beni eseguibili a scadenza dietro corresponsione di premi, di acquisto di crediti assumendo oneri di gestione, riscossione e contabilizzazione degli stessi."
        },
        {
          "code" : "3.3.2.6.2",
          "display" : "Tecnici della locazione finanziaria",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti nella redazione e nella definizione di contratti di acquisto di beni mobili ed immobili e di concessione in uso degli stessi dietro corresponsione di locazioni finanziarie."
        },
        {
          "code" : "3.3.3",
          "display" : "Tecnici dei rapporti con i mercati",
          "definition" : "Le professioni comprese in questa classe assistono gli specialisti negli acquisti di merci, materie prime e attrezzature e nelle relazioni col mercato, ovvero applicano procedure per approvvigionare imprese ed organizzazioni di quanto necessario alla loro attività e per gestire i relativi magazzini e la distribuzione interna. Stimano e valutano beni, li vendono al pubblico incanto; seguono le strategie di vendita delle imprese, l’efficienza della rete distributiva e commerciale; controllano le vendite dei beni e dei servizi commercializzati; assistono gli esperti nelle ricerche sul gradimento presso i consumatori, sulle condizioni di mercato e nel definire presso il pubblico un’immagine positiva e favorevole dell’impresa o dell’organizzazione per cui operano."
        },
        {
          "code" : "3.3.3.1",
          "display" : "Approvvigionatori e responsabili acquisti",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti negli acquisti sul mercato di beni, attrezzature, materie prime e forniture di servizi, ovvero attivano e seguono le procedure di valutazione dei prezzi di mercato, della qualità e delle caratteristiche delle merci da acquistare, di scelta dei fornitori e di acquisizione dei beni."
        },
        {
          "code" : "3.3.3.1.0",
          "display" : "Approvvigionatori e responsabili acquisti",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti negli acquisti sul mercato di beni, attrezzature, materie prime e forniture di servizi ovvero attivano e seguono le procedure di valutazione dei prezzi di mercato, della qualità e delle caratteristiche delle merci da acquistare, di scelta dei fornitori e di acquisizione dei beni."
        },
        {
          "code" : "3.3.3.2",
          "display" : "Responsabili di magazzino e della distribuzione interna",
          "definition" : "Le professioni comprese in questa categoria raccolgono, controllano e archiviano la documentazione sulle merci esistenti, in entrata e in uscita dal magazzino; controllano quantità e valore delle stesse; assicurano le scorte; soddisfano le richieste di spedizione e di distribuzione interna dei beni disponibili; organizzano ed effettuano inventari."
        },
        {
          "code" : "3.3.3.2.0",
          "display" : "Responsabili di magazzino e della distribuzione interna",
          "definition" : "Le professioni comprese in questa unità raccolgono, controllano e archiviano la documentazione sulle merci esistenti, in entrata e in uscita dal magazzino; controllano quantità e valore delle stesse; assicurano le scorte; soddisfano le richieste di spedizione e di distribuzione interna dei beni disponibili; organizzano ed effettuano inventari."
        },
        {
          "code" : "3.3.3.3",
          "display" : "Commissari, stimatori e aggiudicatori d'asta commerciali",
          "definition" : "Le professioni comprese in questa categoria definiscono sulla base di stime il prezzo minimo; illustrano le caratteristiche e vendono al pubblico incanto beni e oggetti di varia natura e provenienza; curano gli aspetti amministrativi della vendita e della aggiudicazione; valutano il valore commerciale e merceologico di oggetti e beni di varia natura e provenienza."
        },
        {
          "code" : "3.3.3.3.1",
          "display" : "Commissari e aggiudicatori d'asta",
          "definition" : "Le professioni comprese in questa unità definiscono, sulla base di stime, il prezzo minimo, illustrano le caratteristiche e vendono al pubblico incanto beni e oggetti di varia natura e provenienza; curano gli aspetti amministrativi della vendita e della aggiudicazione."
        },
        {
          "code" : "3.3.3.3.2",
          "display" : "Periti commerciali",
          "definition" : "Le professioni comprese in questa unità valutano il valore commerciale e merceologico di oggetti e beni di varia natura e provenienza."
        },
        {
          "code" : "3.3.3.4",
          "display" : "Tecnici della vendita e della distribuzione",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti nella implementazione delle strategie di vendita delle imprese, nel controllo della efficienza della rete distributiva e commerciale e nel monitoraggio delle vendite, ovvero applicano le procedure fissate per raccogliere informazioni sulle vendite e sulle attività di distribuzione, per analizzarle, organizzarle e presentarle in maniere rilevante e significativa a specialisti e responsabili del settore."
        },
        {
          "code" : "3.3.3.4.0",
          "display" : "Tecnici della vendita e della distribuzione",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti nella implementazione delle strategie di vendita delle imprese, nel controllo della efficienza della rete distributiva e commerciale e nel monitoraggio delle vendite, ovvero applicano le procedure fissate per raccogliere informazioni sulle vendite e sulle attività di distribuzione, per analizzarle, organizzarle e presentarle in maniera rilevante e significativa a specialisti e responsabili del settore."
        },
        {
          "code" : "3.3.3.5",
          "display" : "Tecnici del marketing",
          "definition" : "Le professioni comprese in questa categoria assistono gli specialisti nella definizione di strategie e di ricerche per rilevare il gradimento sul mercato dei beni e dei servizi commercializzati, le condizioni di mercato e le possibilità di penetrazione commerciale di prodotti o servizi; individuano situazioni di competizione, prezzi e tipologie di consumatori, ovvero applicano le procedure fissate per raccogliere informazioni in materia, analizzarle, organizzarle e presentarle in maniere rilevante e significativa a specialisti e responsabili del settore."
        },
        {
          "code" : "3.3.3.5.0",
          "display" : "Tecnici del marketing",
          "definition" : "Le professioni comprese in questa unità assistono gli specialisti nella definizione di strategie e di ricerche per rilevare il gradimento sul mercato dei beni e dei servizi commercializzati, le condizioni di mercato e le possibilità di penetrazione commerciale di prodotti o servizi, per individuare situazioni di competizione, prezzi e tipologie di consumatori, ovvero applicano le procedure fissate per raccogliere informazioni in materia, analizzarle, organizzarle e presentarle in maniera rilevante e significativa a specialisti e responsabili del settore."
        },
        {
          "code" : "3.3.3.6",
          "display" : "Tecnici della pubblicità e delle pubbliche relazioni",
          "definition" : "Le professioni classificate in questa categoria assistono gli specialisti nel promuovere le attività di mercato di un’impresa o di un’organizzazione e nella creazione presso il pubblico di un’immagine positiva della stessa, ovvero applicano e seguono procedure per programmare e attivare promozioni e campagne pubblicitarie di diverso genere e su vari mezzi; ricercano, selezionano, raccolgono e sistematizzano materiale informativo e pubblicitario favorevole; seguono procedure per organizzare e sponsorizzare eventi di particolare importanza e visibilità non direttamente collegati alla promozione pubblicitaria."
        },
        {
          "code" : "3.3.3.6.1",
          "display" : "Tecnici della pubblicità",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nel promuovere le attività di mercato di un’impresa o di un’organizzazione e nella creazione presso il pubblico di un’immagine positiva della stessa ovvero applicano e seguono procedure per programmare e attivare promozioni e campagne pubblicitarie di vario genere e su vari mezzi."
        },
        {
          "code" : "3.3.3.6.2",
          "display" : "Tecnici delle pubbliche relazioni",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti nel ricercare, selezionare, raccogliere e sistematizzare materiale informativo e pubblicitario favorevole; seguono procedure per organizzare e sponsorizzare eventi di particolare importanza e visibilità non direttamente collegati alla promozione pubblicitaria."
        },
        {
          "code" : "3.3.4",
          "display" : "Tecnici della distribuzione commerciale e professioni assimilate",
          "definition" : "Le professioni comprese in questa classe organizzano e gestiscono spedizioni di merci da esportare, da importare o per la distribuzione interna; controllano e seguono l’organizzazione commerciale delle imprese; agiscono in loro conto e le rappresentano presso i distributori all’ingrosso e al dettaglio; vendono pubblicità; valutano immobili e li vendono per conto terzi; agiscono in veste di acquirente-rivenditore; rappresentano artisti ed atleti."
        },
        {
          "code" : "3.3.4.1",
          "display" : "Spedizionieri e tecnici della distribuzione",
          "definition" : "Le professioni comprese in questa categoria movimentano merci su mare, terra e per via aerea per l’importazione, l’esportazione e la distribuzione interna; rappresentano i produttori e gli importatori presso le dogane; esercitano diritti e compiono atti in loro conto; assicurano il funzionamento dell’organizzazione commerciale dell’impresa garantendo l’evasione degli ordini e l’arrivo delle merci presso la distribuzione locale."
        },
        {
          "code" : "3.3.4.1.0",
          "display" : "Spedizionieri e tecnici dell'organizzazione commerciale",
          "definition" : "Le professioni classificate in questa unità assicurano il funzionamento dell’organizzazione commerciale dell’impresa garantendo l’evasione degli ordini e l’arrivo delle merci presso la distribuzione locale. L’esercizio della professione di Spedizioniere doganale è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.3.4.2",
          "display" : "Agenti di commercio",
          "definition" : "Le professioni comprese in questa categoria visitano per conto di imprese produttrici o distributrici negozi o aziende proponendo l'acquisto di prodotti o servizi per la vendita o la produzione, mostrano campioni, depliant informativi, cataloghi, materiale pubblicitario, illustrano le caratteristiche dei prodotti proposti, curano i rapporti con i clienti, raccolgono ordini, concordano i tempi di consegna e di pagamento, li trasmettono per l’accettazione e l’evasione al produttore o al distributore."
        },
        {
          "code" : "3.3.4.2.0",
          "display" : "Agenti di commercio",
          "definition" : "Le professioni classificate in questa unità visitano, per conto di imprese produttrici o distributrici, negozi o aziende, proponendo l'acquisto di prodotti o servizi per la vendita o la produzione; mostrano campioni, depliant informativi, cataloghi, materiale pubblicitario; illustrano le caratteristiche dei prodotti proposti; curano i rapporti con i clienti, raccolgono ordini, concordano i tempi di consegna e di pagamento, li trasmettono per l’accettazione e l’evasione al produttore o al distributore. L'esercizio delle professioni di Agente di commercio e Agente d'affari in mediazione è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.3.4.3",
          "display" : "Agenti concessionari",
          "definition" : "Le professioni comprese in questa categoria promuovono, organizzano, sono responsabili e, in genere, esclusivisti in un determinato territorio delle vendite di uno o più marchi e relativi prodotti che acquistano dal fabbricante per rivenderli successivamente in nome e per conto proprio."
        },
        {
          "code" : "3.3.4.3.0",
          "display" : "Agenti concessionari",
          "definition" : "Le professioni classificate in questa unità promuovono, organizzano, sono responsabili e, in genere, esclusivisti in un determinato territorio delle vendite di uno o più marchi e relativi prodotti che acquistano dal fabbricante per rivenderli successivamente in nome e per conto proprio."
        },
        {
          "code" : "3.3.4.4",
          "display" : "Agenti di pubblicità",
          "definition" : "Le professioni comprese in questa categoria visitano per conto di imprese pubblicitarie aziende ed organizzazioni proponendo l'acquisto di prodotti o servizi pubblicitari, ne illustrano le caratteristiche, mostrano campioni e depliant illustrativi, raccolgono ordini, concordano i tempi delle attività, li trasmettono per l’accettazione e l’evasione al produttore, curano i rapporti con i clienti."
        },
        {
          "code" : "3.3.4.4.0",
          "display" : "Agenti di pubblicità",
          "definition" : "Le professioni classificate in questa unità visitano, per conto di imprese pubblicitarie, aziende ed organizzazioni, proponendo l'acquisto di prodotti o servizi pubblicitari, ne illustrano le caratteristiche, mostrano campioni e depliant illustrativi, raccolgono ordini, concordano i tempi delle attività, li trasmettono per l’accettazione e l’evasione al produttore, curano i rapporti con i clienti."
        },
        {
          "code" : "3.3.4.5",
          "display" : "Agenti immobiliari",
          "definition" : "Le professioni comprese in questa categoria assistono persone o enti interessati informandosi sulle richieste o fornendo informazioni sulle quotazioni ovvero organizzano e intermediano per loro conto la vendita, l’acquisto o la locazione di edifici, appartamenti, terreni o immobili di altro tipo, mostrano, illustrandone le caratteristiche, gli immobili offerti, istruiscono le pratiche di base le promesse di acquisto e i contratti di locazione; valutano gli immobili fornendo stime sul valore reale, bancario, commerciale e di ammortamento."
        },
        {
          "code" : "3.3.4.5.0",
          "display" : "Agenti e periti immobiliari",
          "definition" : "Le professioni classificate in questa unità assistono persone o enti interessati informandosi sulle richieste o fornendo informazioni sulle quotazioni ovvero organizzano e intermediano per loro conto la vendita, l’acquisto o la locazione di edifici, appartamenti, terreni o immobili di altro tipo; mostrano, illustrandone le caratteristiche, gli immobili offerti, istruiscono le pratiche di base, le promesse di acquisto e i contratti di locazione; valutano gli immobili fornendo stime sul valore reale, bancario, commerciale e di ammortamento."
        },
        {
          "code" : "3.3.4.6",
          "display" : "Rappresentanti di commercio",
          "definition" : "Le professioni comprese in questa categoria concludono affari direttamente in nome e per conto dei produttori o dei distributori dei quali mantengono la piena rappresentanza in ordine agli impegni presi, visitano negozi o aziende proponendo l'acquisto di prodotti o servizi per la vendita o la produzione, mostrano campioni, depliant informativi, cataloghi, materiale pubblicitario, illustrano le caratteristiche dei prodotti proposti, curano i rapporti con i clienti."
        },
        {
          "code" : "3.3.4.6.0",
          "display" : "Rappresentanti di commercio",
          "definition" : "Le professioni classificate in questa unità concludono affari direttamente in nome e per conto dei produttori o dei distributori dei quali mantengono la piena rappresentanza in ordine agli impegni presi; visitano negozi o aziende proponendo l'acquisto di prodotti o servizi per la vendita o la produzione; mostrano campioni, depliant informativi, cataloghi, materiale pubblicitario, illustrano le caratteristiche dei prodotti proposti, curano i rapporti con i clienti."
        },
        {
          "code" : "3.3.4.7",
          "display" : "Agenti e rappresentanti di artisti ed atleti",
          "definition" : "Le professioni classificate in questa categoria rappresentano e promuovono artisti e atleti, curandone la visibilità."
        },
        {
          "code" : "3.3.4.7.0",
          "display" : "Agenti e rappresentanti di artisti ed atleti",
          "definition" : "Le professioni classificate in questa unità rappresentano e promuovono artisti e atleti, curandone la visibilità."
        },
        {
          "code" : "3.4",
          "display" : "Professioni tecniche nei servizi pubblici e alle persone",
          "definition" : "Le professioni classificate in questo gruppo organizzano flussi e attività turistiche e ricettive; addestrano ed esercitano discipline sportive, allenano atleti; forniscono servizi in campo artistico e ricreativo; erogano servizi sociali, di assistenza, di cura e di sicurezza alle persone e servizi pubblici su base amministrativa."
        },
        {
          "code" : "3.4.1",
          "display" : "Professioni tecniche delle attività turistiche, ricettive ed assimilate",
          "definition" : "Le professioni comprese in questa classe si occupano della ricettività dei flussi turistici, dell’organizzazione di fiere e convegni; vendono viaggi e soggiorni organizzati; intrattengono i turisti con manifestazioni e performance ricreative; li accompagnano nei viaggi garantendo la fornitura e il funzionamento dei servizi acquistati; li guidano in escursioni turistiche, naturalistiche e sportive."
        },
        {
          "code" : "3.4.1.1",
          "display" : "Tecnici delle attività ricettive e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria assistono gli specialisti, ovvero applicano conoscenze in materia di marketing turistico per valorizzare, commercializzare, integrare l’offerta turistica di un territorio o di un sistema territoriale; collaborano con i soggetti pubblici e privati per migliorare, caratterizzare sul piano ambientale, artistico, architettonico, enogastronomico e collocare l’offerta turistica nei circuiti organizzati e informali."
        },
        {
          "code" : "3.4.1.1.0",
          "display" : "Tecnici delle attività ricettive e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità assistono gli specialisti, ovvero applicano conoscenze in materia di marketing turistico per valorizzare, commercializzare, integrare l’offerta turistica di un territorio o di un sistema territoriale; collaborano con i soggetti pubblici e privati per migliorare, caratterizzare sul piano ambientale, artistico, architettonico, enogastronomico e collocare l’offerta turistica nei circuiti organizzati e informali."
        },
        {
          "code" : "3.4.1.2",
          "display" : "Tecnici dell’organizzazione di fiere, convegni ed eventi culturali",
          "definition" : "Le professioni comprese nella categoria forniscono servizi per l'organizzazione e la gestione di fiere, collocano gli spazi e gli ambienti espositivi disponibili, ne organizzano la fruizione da parte del pubblico e degli espositori; organizzano convegni, conferenze e ricevimenti garantendo accoglienza, socialità e servizi ai convenuti."
        },
        {
          "code" : "3.4.1.2.1",
          "display" : "Organizzatori di fiere, esposizioni ed eventi culturali",
          "definition" : "Le professioni classificate in questa unità forniscono servizi per l'organizzazione e la gestione di fiere; collocano gli spazi e gli ambienti espositivi disponibili, ne organizzano la fruizione da parte del pubblico e degli espositori."
        },
        {
          "code" : "3.4.1.2.2",
          "display" : "Organizzatori di convegni e ricevimenti",
          "definition" : "Le professioni classificate in questa unità organizzano convegni, conferenze e ricevimenti garantendo accoglienza, socialità e servizi ai convenuti."
        },
        {
          "code" : "3.4.1.3",
          "display" : "Animatori turistici e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria intrattengono gli ospiti di villaggi turistici, hotel ed altre strutture ricettive; progettano ed organizzano attività per il tempo libero, giochi, gare, feste, spettacoli, lezioni sulla pratica di danze, attività sportive e cura del corpo, artistiche e di artigianato."
        },
        {
          "code" : "3.4.1.3.0",
          "display" : "Animatori turistici e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità intrattengono gli ospiti di villaggi turistici, hotel ed altre strutture ricettive; progettano ed organizzano attività per il tempo libero, giochi, gare, feste, spettacoli, lezioni sulla pratica di danze, attività sportive e cura del corpo, attività artistiche e di artigianato."
        },
        {
          "code" : "3.4.1.4",
          "display" : "Agenti di viaggio",
          "definition" : "Le professioni comprese in questa categoria propongono, organizzano e vendono viaggi turistici, di affari o di altra natura e le eventuali sistemazioni alberghiere ai clienti interessati; propongono, consigliano, promuovono e scambiano sul mercato pacchetti turistici, programmano e organizzano attività turistiche per agenzie, uffici turistici, enti ed organizzazioni."
        },
        {
          "code" : "3.4.1.4.0",
          "display" : "Agenti di viaggio",
          "definition" : "Le professioni classificate in questa unità programmano e organizzano attività turistiche per agenzie, uffici turistici, enti, organizzazioni e clienti finali; propongono, consigliano, promuovono e scambiano sul mercato pacchetti turistici."
        },
        {
          "code" : "3.4.1.5",
          "display" : "Guide ed accompagnatori specializzati",
          "definition" : "Le professioni comprese in questa categoria accompagnano singoli o gruppi di turisti in scalate e ascensioni in montagna o in altri itinerari di particolare interesse naturalistico; organizzano le escursioni, consigliano percorsi indicandone le difficoltà e le condizioni migliori in cui seguirli; preparano le attrezzature necessarie; verificano l’adeguatezza di quelle degli escursionisti, li guidano e li aiutano in situazioni di difficoltà; forniscono il primo soccorso in caso di incidenti o malesseri, richiedono aiuto quando necessario e partecipano a spedizioni di soccorso; accompagnano i turisti nei viaggi organizzati garantendo assistenza e servizi ai partecipanti, nei percorsi turistici illustrando e descrivendo caratteristiche e particolarità di opere d’arte, di itinerari paesaggistici, architettonici e di luoghi di interesse storico-artistico."
        },
        {
          "code" : "3.4.1.5.1",
          "display" : "Guide ed accompagnatori naturalistici e sportivi",
          "definition" : "Le professioni classificate in questa unità accompagnano singoli o gruppi di turisti in scalate e ascensioni in montagna o in altri itinerari di particolare interesse naturalistico; organizzano le escursioni, consigliano percorsi indicandone le difficoltà e le condizioni migliori in cui seguirli; preparano le attrezzature necessarie; verificano l’adeguatezza di quelle degli escursionisti, li guidano e li aiutano in situazioni di difficoltà; forniscono il primo soccorso in caso di incidenti o malesseri, richiedono aiuto quando necessario e partecipano a spedizioni di soccorso. L'esercizio delle professioni di Guida alpina e Guida speleologica è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.4.1.5.2",
          "display" : "Guide turistiche",
          "definition" : "Le professioni classificate in questa unità accompagnano i turisti nei viaggi organizzati, garantendo assistenza e servizi ai partecipanti, illustrando e descrivendo caratteristiche e particolarità di opere d’arte, di itinerari paesaggistici, architettonici e di luoghi di interesse storico-artistico."
        },
        {
          "code" : "3.4.2",
          "display" : "Insegnanti nella formazione professionale, istruttori, allenatori, atleti e professioni assimilate",
          "definition" : "Le professioni comprese in questa classe si occupano della didattica nei percorsi di formazione professionale, somministrano lezioni e addestrano alla guida di automobili, aerei e barche, insegnano, con lezioni individuali o per piccoli gruppi, a praticare discipline artistico-figurative, organizzano eventi e strutture sportive, allenano atleti, fungono da arbitri e giudici in gare ed esercitano professionalmente attività sportive."
        },
        {
          "code" : "3.4.2.1",
          "display" : "Istruttori di guida",
          "definition" : "Le professioni classificate in questa categoria somministrano lezioni teoriche e pratiche - finalizzate in genere all’acquisizione di una patente, di un brevetto o di una abilitazione - sui princìpi e le tecniche di guida, il funzionamento delle parti, la strumentazione da utilizzare e conoscere, le regole da seguire ed i comportamenti da tenere nella guida di automobili, aerei e barche."
        },
        {
          "code" : "3.4.2.1.1",
          "display" : "Istruttori di volo",
          "definition" : "Le professioni classificate in questa unità preparano e somministrano lezioni teoriche e pratiche - finalizzate in genere all’acquisizione di una patente, di un brevetto o di una abilitazione - sui princìpi e le tecniche di guida, il funzionamento delle parti, la strumentazione da utilizzare e conoscere, le regole da seguire ed i comportamenti da tenere nella guida di aerei."
        },
        {
          "code" : "3.4.2.1.2",
          "display" : "Istruttori di guida automobilistica",
          "definition" : "Le professioni classificate in questa unità preparano e somministrano lezioni teoriche e pratiche -finalizzate all’acquisizione di una patente - sui princìpi e le tecniche di guida, il funzionamento delle parti, la strumentazione da utilizzare e conoscere, le regole da seguire ed i comportamenti da tenere nella guida di autoveicoli."
        },
        {
          "code" : "3.4.2.1.3",
          "display" : "Istruttori di nautica",
          "definition" : "Le professioni classificate in questa unità preparano e somministrano lezioni teoriche e pratiche -finalizzate in genere all’acquisizione di una patente, di un brevetto o di una abilitazione - sui princìpi e le tecniche di guida, il funzionamento delle parti, la strumentazione da utilizzare e conoscere, le regole da seguire ed i comportamenti da tenere nella guida di imbarcazioni a motore e a vela."
        },
        {
          "code" : "3.4.2.2",
          "display" : "Insegnanti nella formazione professionale",
          "definition" : "Le professioni classificate in questa categoria insegnano materie tecnico-pratiche e di laboratorio, la pratica di diverse attività lavorative, l’uso di tecnologie e di attrezzature nella formazione professionale."
        },
        {
          "code" : "3.4.2.2.0",
          "display" : "Insegnanti nella formazione professionale",
          "definition" : "Le professioni classificate in questa unità insegnano materie tecnico-pratiche e di laboratorio, la pratica di diverse attività lavorative, l’uso di tecnologie e di attrezzature nella formazione professionale."
        },
        {
          "code" : "3.4.2.3",
          "display" : "Istruttori di tecniche in campo artistico",
          "definition" : "Le professioni classificate in questa categoria insegnano la tecnica e, con lezioni individuali o per piccoli gruppi, addestrano a praticare discipline artistico-figurative."
        },
        {
          "code" : "3.4.2.3.0",
          "display" : "Istruttori di tecniche in campo artistico",
          "definition" : "Le professioni classificate in questa unità insegnano la tecnica e, con lezioni individuali o per piccoli gruppi, addestrano a praticare discipline artistico-figurative."
        },
        {
          "code" : "3.4.2.4",
          "display" : "Istruttori di discipline sportive non agonistiche",
          "definition" : "Le professioni classificate in questa categoria addestrano ad esercitare, in modo non agonistico, con lezioni individuali o di gruppo, la pratica di discipline sportive; ne insegnano le tecniche; verificano l’adeguatezza delle condizioni fisiche dell’allievo; lo preparano fisicamente; lo allenano e organizzano attività sportive comuni."
        },
        {
          "code" : "3.4.2.4.0",
          "display" : "Istruttori di discipline sportive non agonistiche",
          "definition" : "Le professioni classificate in questa unità addestrano ad esercitare, in modo non agonistico, con lezioni individuali o di gruppo, la pratica di discipline sportive; ne insegnano le tecniche; verificano l’adeguatezza delle condizioni fisiche dell’allievo; lo preparano fisicamente; lo allenano e organizzano attività sportive comuni. L'esercizio della professione di Maestro di sci è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.4.2.5",
          "display" : "Professioni organizzative nel campo dell'educazione fisica e dello sport",
          "definition" : "Le professioni comprese in questa categoria organizzano eventi e competizioni sportive; dirigono le attività sportive di palestre e di altre strutture; seguono le performance e la crescita sportiva di atleti per individuare e selezionare talenti."
        },
        {
          "code" : "3.4.2.5.1",
          "display" : "Organizzatori di eventi e di strutture sportive",
          "definition" : "Le professioni classificate in questa unità organizzano eventi e competizioni sportive; dirigono le attività sportive di palestre e di altre strutture."
        },
        {
          "code" : "3.4.2.5.2",
          "display" : "Osservatori sportivi",
          "definition" : "Le professioni classificate in questa unità seguono le performance e la crescita sportiva di atleti per individuare e selezionare talenti."
        },
        {
          "code" : "3.4.2.6",
          "display" : "Allenatori e tecnici di discipline sportive agonistiche",
          "definition" : "Le professioni comprese in questa categoria preparano e allenano atleti e squadre di atleti alle competizioni; ne curano la motivazione e la preparazione fisica; definiscono strategie di gara; insegnano e innovano tecniche di gioco; sovrintendono a competizioni atletiche o a eventi sportivi; rilevano infrazioni alle regole del gioco e decidono le penalità in accordo con i regolamenti."
        },
        {
          "code" : "3.4.2.6.1",
          "display" : "Allenatori e tecnici sportivi",
          "definition" : "Le professioni classificate in questa unità preparano e allenano atleti e squadre di atleti alle competizioni; ne curano la motivazione e la preparazione fisica; definiscono strategie di gara; insegnano e innovano tecniche di gioco."
        },
        {
          "code" : "3.4.2.6.2",
          "display" : "Arbitri e giudici di gara",
          "definition" : "Le professioni classificate in questa unità sovrintendono a competizioni atletiche o a eventi sportivi; rilevano infrazioni alle regole del gioco e decidono le penalità in accordo con i regolamenti."
        },
        {
          "code" : "3.4.2.7",
          "display" : "Atleti",
          "definition" : "Le professioni classificate in questa unità competono, da soli o in squadra, in gare o eventi sportivi, curano la preparazione atletica e l’addestramento personale e di squadra nelle discipline sportive prescelte."
        },
        {
          "code" : "3.4.2.7.0",
          "display" : "Atleti",
          "definition" : "Le professioni classificate in questa unità competono, da soli o in squadra, in gare o eventi sportivi, curano la preparazione atletica e l’addestramento personale e di squadra nelle discipline sportive prescelte."
        },
        {
          "code" : "3.4.3",
          "display" : "Tecnici dei servizi ricreativi",
          "definition" : "Le professioni comprese nella classe presentano, alla radio o alla televisione, informazioni, spettacoli e performance; presentano performance artistiche e ricreative in teatri e luoghi pubblici e manifestazioni di altro tipo; si occupano dell’implementazione dei palinsesti e dei programmi radiotelevisivi; intrattengono e divertono il pubblico."
        },
        {
          "code" : "3.4.3.1",
          "display" : "Annunciatori e presentatori della radio, della televisione e di altri spettacoli",
          "definition" : "Le professioni comprese in questa categoria leggono notizie diffondono informazioni, reportage giornalistici, presentano spettacoli e manifestazioni, annunciano programmi in radio e in televisione; presentano performance artistiche e ricreative nei teatri, negli stadi, in locali o altri luoghi pubblici."
        },
        {
          "code" : "3.4.3.1.1",
          "display" : "Annunciatori della radio e della televisione",
          "definition" : "Le professioni classificate in questa unità leggono notizie, diffondono informazioni, reportage giornalistici, presentano spettacoli e manifestazioni, annunciano programmi in radio e in televisione."
        },
        {
          "code" : "3.4.3.1.2",
          "display" : "Presentatori di performance artistiche e ricreative",
          "definition" : "Le professioni classificate in questa unità presentano performance artistiche e ricreative nei teatri, negli stadi, in locali o altri luoghi pubblici."
        },
        {
          "code" : "3.4.3.2",
          "display" : "Tecnici dell’organizzazione della produzione radiotelevisiva, cinematografica e teatrale",
          "definition" : "Le professioni classificate in questa categoria organizzano e seguono le attività connesse all'implementazione dei palinsesti e dei programmi radiotelevisivi ed alla produzione teatrale e cinematografica."
        },
        {
          "code" : "3.4.3.2.0",
          "display" : "Tecnici dell'organizzazione della produzione radiotelevisiva, cinematografica e teatrale",
          "definition" : "Le professioni classificate in questa unità organizzano e seguono le attività connesse all'implementazione dei palinsesti e dei programmi radiotelevisivi ed alla produzione teatrale e cinematografica."
        },
        {
          "code" : "3.4.3.3",
          "display" : "Intrattenitori",
          "definition" : "Le professioni classificate in questa categoria organizzano e curano le attività ricreative, di intrattenimento e divertimento del pubblico."
        },
        {
          "code" : "3.4.3.3.0",
          "display" : "Intrattenitori",
          "definition" : "Le professioni classificate in questa unità organizzano e curano le attività ricreative, di intrattenimento e divertimento del pubblico"
        },
        {
          "code" : "3.4.4",
          "display" : "Tecnici dei servizi culturali",
          "definition" : "Le professioni comprese in questa classe realizzano, utilizzando varie tecniche di disegno artistico, bozzetti, disegni di dettaglio, elaborati multimediali e animazioni finalizzati alla comunicazione e all'illustrazione pubblicitaria; realizzano scene per manifestazioni teatrali, produzioni cinematografiche e televisive, spettacoli musicali e altro; curano le esposizioni dei musei e le attività delle biblioteche; valutano oggetti d’arte, monete e francobolli; esaminano e valutano calligrafie; collaborano alle attività di prevenzione, manutenzione e restauro di beni culturali mobili e architettonici."
        },
        {
          "code" : "3.4.4.1",
          "display" : "Grafici, disegnatori e allestitori di scena",
          "definition" : "Le professioni comprese in questa categoria realizzano, utilizzando varie tecniche di disegno artistico, bozzetti, disegni di dettaglio, elaborati multimediali e animazioni finalizzati alla comunicazione e all'illustrazione pubblicitaria; realizzano scene per manifestazioni teatrali, produzioni cinematografiche e televisive, spettacoli musicali e altri tipi di performance artistiche."
        },
        {
          "code" : "3.4.4.1.1",
          "display" : "Grafici",
          "definition" : "Le professioni classificate in questa unità realizzano, utilizzando varie tecniche di disegno artistico, bozzetti, disegni di dettaglio, elaborati multimediali e animazioni finalizzati alla comunicazione o all'illustrazione pubblicitaria."
        },
        {
          "code" : "3.4.4.1.2",
          "display" : "Allestitori di scena",
          "definition" : "Le professioni classificate in questa unità realizzano scene per manifestazioni teatrali, produzioni cinematografiche e televisive, spettacoli musicali e altri tipi di performance artistiche."
        },
        {
          "code" : "3.4.4.2",
          "display" : "Tecnici dei musei, delle biblioteche e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria preparano, organizzano e sistemano modelli ed esemplari, quali fossili, utensili, oggetti di vario genere, manufatti artistici, per mostre e manifestazioni museali; catalogano oggetti ed opere d’arte; seguono e consigliano i lettori nell’uso dei cataloghi, delle basi di dati e degli indici con cui sono organizzate le biblioteche; li assistono nelle ricerche; catalogano e sistemano libri negli scaffali; li riparano; controllano la circolazione dei libri da e per la biblioteca."
        },
        {
          "code" : "3.4.4.2.1",
          "display" : "Tecnici dei musei",
          "definition" : "Le professioni classificate in questa unità preparano, organizzano e sistemano modelli ed esemplari, quali fossili, utensili, oggetti di vario genere, manufatti artistici, per mostre e manifestazioni museali; catalogano oggetti ed opere d’arte."
        },
        {
          "code" : "3.4.4.2.2",
          "display" : "Tecnici delle biblioteche",
          "definition" : "Le professioni classificate in questa unità seguono e consigliano i lettori nell’uso dei cataloghi, delle basi di dati e degli indici con cui sono organizzate le biblioteche; li assistono nelle ricerche; catalogano e sistemano libri negli scaffali, li riparano; controllano la circolazione dei libri da e per la biblioteca."
        },
        {
          "code" : "3.4.4.3",
          "display" : "Periti, stimatori d’arte e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria applicano conoscenze storico-artistiche sui materiali utilizzati, le tecniche costruttive, decorative e di finitura nella stima dell’autenticità e del valore commerciale di opere d’arte ed oggetti di antiquariato, di monete, cartamoneta, medaglie e francobolli; applicano conoscenze in materia di esame e valutazione della forma e del disegno dei caratteri per attribuire una scrittura e determinarne l'autenticità."
        },
        {
          "code" : "3.4.4.3.1",
          "display" : "Stimatori di opere d'arte",
          "definition" : "Le professioni classificate in questa unità applicano conoscenze storico-artistiche sui materiali utilizzati, le tecniche costruttive, decorative e di finitura per la stima dell’autenticità e del valore commerciale di opere d’arte ed oggetti di antiquariato."
        },
        {
          "code" : "3.4.4.3.2",
          "display" : "Periti filatelici e numismatici",
          "definition" : "Le professioni classificate in questa unità applicano conoscenze storico-artistiche sui materiali utilizzati, le tecniche costruttive, decorative e di finitura per la stima dell’autenticità e del valore commerciale di monete, cartamoneta, medaglie e francobolli."
        },
        {
          "code" : "3.4.4.3.3",
          "display" : "Periti calligrafi",
          "definition" : "Le professioni classificate in questa unità applicano conoscenze in materia di esame e valutazione della forma e del disegno dei caratteri per attribuire una scrittura e determinarne l'autenticità."
        },
        {
          "code" : "3.4.4.4",
          "display" : "Tecnici restauratori",
          "definition" : "Le professioni classificate in questa categoria assistono i restauratori nelle attività di prevenzione, manutenzione e restauro di beni culturali mobili e architettonici; collaborano alle attività di ricerca finalizzate alla ricostruzione storico-culturale e conservativa del bene, alla valutazione delle sue condizioni di degrado, alla raccolta dati e alla stesura del materiale documentale; curano, secondo le indicazioni metodologiche del restauratore, la preparazione dei materiali necessari per gli interventi."
        },
        {
          "code" : "3.4.4.4.0",
          "display" : "Tecnici del restauro",
          "definition" : "Le professioni classificate in questa unità assistono i restauratori nelle attività di prevenzione, manutenzione e restauro di beni culturali mobili e architettonici; collaborano alle attività di ricerca finalizzate alla ricostruzione storico-culturale e conservativa del bene, alla valutazione delle sue condizioni di degrado, alla raccolta dati e alla stesura del materiale documentale; curano, secondo le indicazioni metodologiche del restauratore, la preparazione dei materiali necessari per gli interventi. L’esercizio della professione di collaboratore restauratore di beni culturali è regolato dalle leggi dello Stato."
        },
        {
          "code" : "3.4.5",
          "display" : "Tecnici dei servizi sociali",
          "definition" : "Le professioni comprese in questa classe guidano persone e famiglie nella ricerca di soluzioni alle difficoltà sociali ed ai problemi di inserimento; curano in forma privata la sicurezza delle persone e delle imprese; si occupano del benessere e della cura estetica del corpo; si dedicano alla preghiera e alla diffusione degli insegnamenti della religione che professano."
        },
        {
          "code" : "3.4.5.1",
          "display" : "Assistenti sociali",
          "definition" : "Le professioni classificate in questa categoria assistono e guidano individui e famiglie con problemi sociali e lavorativi alla ricerca di soluzioni e per il raggiungimento degli obiettivi connessi; aiutano i soggetti con disabilità fisiche e mentali ad ottenere i trattamenti adeguati; attivano e certificano procedure finalizzate ad ottenere assistenza pubblica per individui e famiglie."
        },
        {
          "code" : "3.4.5.1.0",
          "display" : "Assistenti sociali",
          "definition" : "Le professioni classificate in questa unità assistono e guidano individui e famiglie con problemi sociali e lavorativi alla ricerca di soluzioni e per il raggiungimento degli obiettivi connessi; aiutano i soggetti con disabilità fisiche e mentali ad ottenere i trattamenti adeguati; attivano e certificano procedure finalizzate ad ottenere assistenza pubblica per individui e famiglie. L'esercizio della professione di Assistente sociale è regolamentato dalle leggi dello Stato."
        },
        {
          "code" : "3.4.5.2",
          "display" : "Tecnici del reinserimento e dell'integrazione sociale",
          "definition" : "Le professioni classificate in questa categoria forniscono servizi finalizzati a prevenire il disagio di adulti in difficoltà di inserimento sociale e lavorativo, a rimuovere l'emarginazione sociale di bambini e adolescenti, a riabilitare adulti e minori in prigione, in libertà vigilata e fuori dal carcere e a recuperare alla vita attiva adulti scoraggiati o ritirati dal lavoro"
        },
        {
          "code" : "3.4.5.2.0",
          "display" : "Tecnici del reinserimento e dell’integrazione sociale",
          "definition" : "Le professioni classificate in questa unità forniscono servizi finalizzati a prevenire il disagio di adulti in difficoltà di inserimento sociale e lavorativo, a rimuovere l'emarginazione sociale di bambini e adolescenti, a riabilitare adulti e minori in prigione, in libertà vigilata e fuori dal carcere e a recuperare alla vita attiva adulti scoraggiati o ritirati dal lavoro"
        },
        {
          "code" : "3.4.5.3",
          "display" : "Tecnici dei servizi per l'impiego",
          "definition" : "Le professioni classificate in questa categoria informano chi cerca lavoro sulle opportunità lavorative disponibili; raccolgono informazioni sulle capacità, sulla formazione, sugli interessi e sulle loro esperienze lavorative; li aiutano a formulare curricula e ad utilizzare gli strumenti disponibili per cercare lavoro; propongono le loro candidature ai soggetti che domandano lavoro; li collocano secondo le disposizioni di legge."
        },
        {
          "code" : "3.4.5.3.0",
          "display" : "Tecnici dei servizi per l'impiego",
          "definition" : "Le professioni classificate in questa unità informano chi cerca lavoro sulle opportunità lavorative disponibili; raccolgono informazioni sulle capacità, sulla formazione, sugli interessi e sulle loro esperienze lavorative; li aiutano a formulare curricula e ad utilizzare gli strumenti disponibili per cercare lavoro; propongono le loro candidature ai soggetti che domandano lavoro; li collocano secondo le disposizioni di legge."
        },
        {
          "code" : "3.4.5.4",
          "display" : "Tecnici dei servizi di sicurezza privati e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria organizzano servizi privati di protezione e di sicurezza a persone, imprese ed organizzazioni per prevenire furti, violenze, violazioni dei regolamenti; organizzano servizi di acquisizione di informazioni per prevenire e far fronte a comportamenti scorretti e illegittimi."
        },
        {
          "code" : "3.4.5.4.0",
          "display" : "Tecnici dei servizi di sicurezza privati e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità organizzano servizi privati di protezione e di sicurezza a persone, imprese ed organizzazioni per prevenire furti, violenze, violazioni dei regolamenti; organizzano servizi di acquisizione di informazioni per prevenire e far fronte a comportamenti scorretti e illegittimi."
        },
        {
          "code" : "3.4.5.5",
          "display" : "Tecnici delle attività religiose e di culto",
          "definition" : "Le professioni classificate in questa categoria attendono ad attività religiose, dedicano le loro vite alla contemplazione e alla meditazione, pregano e diffondono gli insegnamenti della religione che professano."
        },
        {
          "code" : "3.4.5.5.0",
          "display" : "Tecnici delle attività religiose e di culto",
          "definition" : "Le professioni classificate in questa unità attendono ad attività religiose, dedicano le loro vite alla contemplazione e alla meditazione, pregano e diffondono gli insegnamenti della religione che professano."
        },
        {
          "code" : "3.4.6",
          "display" : "Tecnici dei servizi pubblici e di sicurezza",
          "definition" : "Le professioni comprese in questa classe organizzano amministrativamente e curano l’applicazione delle decisioni della magistratura; collaborano con la magistratura e conducono indagini sulle attività criminali di persone o organizzazioni, organizzano i servizi di controllo del traffico e dei regolamenti urbani, organizzano le attività di controllo e di prevenzione degli incendi e di tutela del patrimonio ambientale, organizzano indagini e controlli sul rispetto della legislazione fiscale e tributaria, le attività delle dogane, verificano e valutano le richieste di concessioni di licenze, di certificazione e di rilascio di documenti pubblici e personali di fonte pubblica."
        },
        {
          "code" : "3.4.6.1",
          "display" : "Tecnici dei servizi giudiziari",
          "definition" : "Le professioni classificate in questa categoria curano gli aspetti amministrativi ed esecutivi delle decisioni delle corti di giustizia; organizzano il materiale documentario e probatorio e documentano lo svolgimento dei processi, riportando a verbale testimonianze, interventi delle parti e decisioni."
        },
        {
          "code" : "3.4.6.1.0",
          "display" : "Tecnici dei servizi giudiziari",
          "definition" : "Le professioni classificate in questa unità curano gli aspetti amministrativi ed esecutivi delle decisioni delle corti di giustizia; organizzano il materiale documentario e probatorio e documentano lo svolgimento dei processi, riportando a verbale testimonianze, interventi delle parti e decisioni."
        },
        {
          "code" : "3.4.6.2",
          "display" : "Ufficiali della polizia di stato",
          "definition" : "Le professioni classificate in questa categoria collaborano con la magistratura, conducendo indagini su notizie di crimini e su attività criminali, eseguendo mandati di arresto e di fermo; conducono indagini su crimini effettuati o presunti, organizzano attività di prevenzione e di sorveglianza finalizzate alla sicurezza dei cittadini."
        },
        {
          "code" : "3.4.6.2.0",
          "display" : "Ufficiali della Polizia di Stato",
          "definition" : "Le professioni classificate in questa unità collaborano con la magistratura, conducendo indagini su notizie di crimini e su attività criminali, eseguendo mandati di arresto e di fermo; conducono indagini su crimini effettuati o presunti, organizzano attività di prevenzione e di sorveglianza finalizzate alla sicurezza dei cittadini."
        },
        {
          "code" : "3.4.6.3",
          "display" : "Tecnici dei servizi di sicurezza dei vigili urbani, dei vigili del fuoco e del corpo forestale",
          "definition" : "Le professioni comprese in questa categoria organizzano e coordinano le attività finalizzate ad assicurare il rispetto delle norme e dei regolamenti cittadini, in particolare rispetto al traffico, al commercio, all’igiene pubblica e alla sicurezza dei cittadini in collaborazione con le forze dell’ordine; organizzano e coordinano le attività di prevenzione, controllo e spegnimento degli incendi, di salvataggio e sgombero delle persone anche in caso di calamità naturali o di incidenti di varia natura; organizzano e coordinano le attività di tutela del patrimonio forestale ed ambientale al fine del rispetto delle norme relative."
        },
        {
          "code" : "3.4.6.3.1",
          "display" : "Tecnici dei servizi di sicurezza dei vigili urbani",
          "definition" : "Le professioni classificate in questa unità organizzano e coordinano le attività finalizzate ad assicurare il rispetto delle norme e dei regolamenti cittadini, in particolare rispetto al traffico, al commercio, all’igiene pubblica e alla sicurezza dei cittadini in collaborazione con le forze dell’ordine."
        },
        {
          "code" : "3.4.6.3.2",
          "display" : "Tecnici dei servizi di sicurezza dei vigili del fuoco",
          "definition" : "Le professioni classificate in questa unità organizzano e coordinano le attività di prevenzione, controllo e spegnimento degli incendi, di salvataggio e sgombero delle persone anche in caso di calamità naturali o di incidenti di varia natura."
        },
        {
          "code" : "3.4.6.3.3",
          "display" : "Tecnici dei servizi di sicurezza del corpo forestale",
          "definition" : "Le professioni classificate in questa unità organizzano e coordinano le attività di tutela del patrimonio forestale ed ambientale al fine del rispetto delle norme relative."
        },
        {
          "code" : "3.4.6.4",
          "display" : "Ufficiali della guardia di finanza",
          "definition" : "Le professioni comprese in questa categoria coordinano e organizzano le attività di prevenzione, ricerca e denuncia delle evasione e delle violazioni finanziarie, di vigilanza sull’adempimento delle disposizioni di interesse politico-economico, di sorveglianza in mare per fini di polizia finanziaria, di collaborazione al mantenimento della sicurezza pubblica e alla difesa delle frontiere, delle attività di polizia doganale."
        },
        {
          "code" : "3.4.6.4.0",
          "display" : "Ufficiali della guardia di finanza",
          "definition" : "Le professioni classificate in questa unità coordinano e organizzano le attività di prevenzione, ricerca e denuncia delle evasioni e delle violazioni finanziarie, le attività di vigilanza sull’adempimento delle disposizioni di interesse politico-economico, di sorveglianza in mare per fini di polizia finanziaria, le attività di collaborazione al mantenimento della sicurezza pubblica e alla difesa delle frontiere, le attività di polizia doganale."
        },
        {
          "code" : "3.4.6.5",
          "display" : "Controllori fiscali",
          "definition" : "Le professioni comprese in questa categoria coordinano e organizzano la circolazione delle merci da e per il paese, organizzano i controlli sulle merci e le verifiche della corrispondenza alla documentazione presentata delle merci esportate e importate, sull’entrata o l’uscita dal paese di merci vietate o non autorizzate."
        },
        {
          "code" : "3.4.6.5.0",
          "display" : "Controllori fiscali",
          "definition" : "Le professioni classificate in questa unità coordinano e organizzano la circolazione delle merci da e per il Paese, organizzano i controlli sulle merci e le verifiche della corrispondenza alla documentazione presentata delle merci esportate e importate, organizzano i controlli sull’entrata o l’uscita dal Paese di merci vietate o non autorizzate."
        },
        {
          "code" : "3.4.6.6",
          "display" : "Tecnici dei servizi pubblici di concessioni licenze e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria esaminano le domande e verificano le condizioni di concessione di licenze per l’esercizio di attività imprenditoriali e commerciali, per la costruzione di edifici, case o di altre strutture; di rilascio di passaporti, documenti di identità e di altre certificazioni personali fatte dall’amministrazione pubblica."
        },
        {
          "code" : "3.4.6.6.1",
          "display" : "Tecnici dei servizi pubblici di concessioni licenze",
          "definition" : "Le professioni classificate in questa unità esaminano le domande e verificano le condizioni di concessione di licenze per l’esercizio di attività imprenditoriali e commerciali, per la costruzione di edifici, case o di altre strutture."
        },
        {
          "code" : "3.4.6.6.2",
          "display" : "Tecnici dei servizi pubblici per il rilascio di certificazioni e documentazioni personali",
          "definition" : "Le professioni classificate in questa unità esaminano le domande e verificano le condizioni per il rilascio di passaporti, documenti di identità e di altre certificazioni personali fatte dall’amministrazione pubblica."
        }
      ]
    },
    {
      "code" : "4",
      "display" : "PROFESSIONI ESECUTIVE NEL LAVORO d'UFFICIO",
      "definition" : "Il quarto grande gruppo comprende le professioni che svolgono il lavoro d'ufficio con funzioni non direttive. I loro compiti consistono nell'acquisire, trattare, archiviare e trasmettere informazioni secondo quanto disposto da norme o da regolamenti e nella verifica e corretta applicazione di procedure. Amministrano il personale, applicano procedure che comportano la circolazione di denaro; trascrivono e correggono documenti; effettuano calcoli e semplici rendicontazioni statistiche; forniscono al pubblico informazioni e servizi connessi alle attività dell’organizzazione o dell’impresa per cui operano. Tali attività richiedono in genere conoscenze di base assimilabili a quelle acquisite completando l'obbligo scolastico o un ciclo breve di istruzione secondaria superiore o, ancora, una qualifica professionale o esperienza lavorativa.",
      "concept" : [
        {
          "code" : "4.1",
          "display" : "Impiegati addetti alle funzioni di segreteria e alle macchine da ufficio",
          "definition" : "Le professioni classificate in questo gruppo, seguendo le procedure stabilite, eseguono una serie di compiti amministrativi e d'ufficio. Registrano, elaborano, selezionano, classificano e archiviano le informazioni; eseguono fotocopie e fax di documenti; preparano lettere e documenti di natura ordinaria; rispondono alle richieste telefoniche o telematiche direttamente o inoltrandole alla persona interessata; trascrivono dati su computer, correggono bozze e controllano dati."
        },
        {
          "code" : "4.1.1",
          "display" : "Impiegati addetti alla segreteria e agli affari generali",
          "definition" : "Le professioni classificate in questa classe eseguono una vasta gamma di compiti d'ufficio e di supporto amministrativo secondo le procedure stabilite. Preparano lettere e documenti di natura ordinaria seguendo indicazioni predefinite; gestiscono la posta in entrata e in uscita, gli appuntamenti dei superiori; rispondono alle richieste telefoniche o telematiche direttamente o inoltrandole alla persona interessata."
        },
        {
          "code" : "4.1.1.1",
          "display" : "Addetti a funzioni di segreteria",
          "definition" : "Le professioni classificate in questa categoria supportano le attività di un ufficio organizzando riunioni, viaggi di lavoro, appuntamenti e contatti, dattiloscrivendo e inoltrando disposizioni verbali e appunti, attivando ed eseguendo le procedure burocratiche necessarie al funzionamento delle attività e dei processi cui l’ufficio stesso è preposto e alla circolazione dell’informazione e della documentazione tra i vari uffici; predispongono la documentazione e svolgono compiti di supporto operativo necessarie alla attività degli uffici stampa e di relazione con il pubblico."
        },
        {
          "code" : "4.1.1.1.0",
          "display" : "Addetti a funzioni di segreteria",
          "definition" : "Le professioni classificate in questa unità supportano le attività di un ufficio organizzando riunioni, viaggi di lavoro, appuntamenti e contatti, dattiloscrivendo e inoltrando disposizioni verbali e appunti, attivando ed eseguendo le procedure burocratiche necessarie al funzionamento delle attività e dei processi cui l’ufficio stesso è preposto e alla circolazione dell’informazione e della documentazione tra i vari uffici; predispongono la documentazione e svolgono compiti di supporto operativo necessarie alla attività degli uffici stampa e di relazione con il pubblico."
        },
        {
          "code" : "4.1.1.2",
          "display" : "Addetti agli affari generali",
          "definition" : "Le professioni classificate in questa categoria attivano, eseguono e supportano singoli aspetti delle procedure di pianificazione, progettazione, amministrazione e gestione di un’impresa o di un’organizzazione svolgendo compiti di carattere non direttivo."
        },
        {
          "code" : "4.1.1.2.0",
          "display" : "Addetti agli affari generali",
          "definition" : "Le professioni classificate in questa unità attivano, eseguono e supportano singoli aspetti delle procedure di pianificazione, progettazione, amministrazione e gestione di un’impresa o di un’organizzazione svolgendo compiti di carattere non direttivo."
        },
        {
          "code" : "4.1.1.3",
          "display" : "Addetti al protocollo e allo smistamento di documenti",
          "definition" : "Le professioni classificate in questa categoria raccolgono, smistano, consegnano documenti e materiali in partenza o in arrivo da e per i vari uffici o settori organizzativi dell’impresa; eseguono atti amministrativi necessari ad attestare, attraverso la trascrizione delle operazioni in appositi registri e l'emissione di ricevute, la ricezione o la trasmissione di materiali o di documentazione da parte dell'organizzazione, dell’impresa o di un singolo ufficio."
        },
        {
          "code" : "4.1.1.3.0",
          "display" : "Addetti al protocollo e allo smistamento di documenti",
          "definition" : "Le professioni classificate in questa unità raccolgono e smistano documenti e materiali in partenza o in arrivo da e per i vari uffici o settori organizzativi dell’impresa; eseguono atti amministrativi necessari ad attestare, attraverso la trascrizione delle operazioni in appositi registri e l'emissione di ricevute, la ricezione o la trasmissione di materiali o di documentazione da parte dell'organizzazione, dell’impresa o di un singolo ufficio."
        },
        {
          "code" : "4.1.1.4",
          "display" : "Addetti alla gestione del personale",
          "definition" : "Le professioni classificate in questa categoria eseguono attività di supporto necessarie alla gestione del personale, inoltrano comunicazioni e ordini di servizio, eseguono le procedure di assunzione, licenziamento e di assegnazione acquisendo e inoltrando le dovute documentazioni."
        },
        {
          "code" : "4.1.1.4.0",
          "display" : "Addetti alla gestione del personale",
          "definition" : "Le professioni classificate in questa unità eseguono attività di supporto necessarie alla gestione del personale, inoltrano comunicazioni e ordini di servizio, eseguono le procedure di assunzione, licenziamento e di assegnazione acquisendo e inoltrando le dovute documentazioni."
        },
        {
          "code" : "4.1.2",
          "display" : "Impiegati addetti alle macchine d'ufficio",
          "definition" : "Le professioni classificate in questa classe, utilizzando computer o altre apparecchiature elettroniche ed elettromeccaniche, inseriscono e registrano dati o codici, eseguono operazioni di calcolo e di elaborazione; preparano, modificano, riproducono e trasmettono documenti; trascrivono manoscritti, minute, documenti o processi verbali; redigono verbali utilizzando appropriate tecniche di scrittura e macchine per stenografia-scrittura; trascrivono le informazioni registrate in stenografia e sui mezzi di registrazione del suono."
        },
        {
          "code" : "4.1.2.1",
          "display" : "Addetti alla videoscrittura, dattilografi, stenografi e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria utilizzano mezzi meccanici, elettromeccanici, elettronici o informatici e tecniche di scrittura appropriate per trascrivere manoscritti, minute e documenti o processi verbali prodotti lungo l’attività dell’impresa o dell’organizzazione, ovvero svolgono tali compiti come servizio per terze parti."
        },
        {
          "code" : "4.1.2.1.0",
          "display" : "Addetti alla videoscrittura, dattilografi, stenografi e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità utilizzano mezzi meccanici, elettromeccanici, elettronici o informatici e tecniche di scrittura appropriate per trascrivere manoscritti, minute e documenti o processi verbali prodotti lungo l’attività dell’impresa o dell’organizzazione, ovvero svolgono tali compiti come servizio per terze parti."
        },
        {
          "code" : "4.1.2.2",
          "display" : "Addetti all'immissione dati",
          "definition" : "Le professioni classificate in questa categoria inseriscono dati ed eseguono operazioni di calcolo e di elaborazione utilizzando calcolatrici elettromeccaniche, elettroniche o strumenti informatici di calcolo."
        },
        {
          "code" : "4.1.2.2.0",
          "display" : "Addetti all'immissione dati",
          "definition" : "Le professioni classificate in questa unità inseriscono dati ed eseguono operazioni di calcolo e di elaborazione utilizzando calcolatrici elettromeccaniche, elettroniche o strumenti informatici di calcolo."
        },
        {
          "code" : "4.1.2.3",
          "display" : "Addetti alle macchine per la riproduzione e l'invio di materiali e documenti",
          "definition" : "Le professioni classificate in questa unità riproducono documenti esistenti utilizzando fotocopiatrici, scanner, fax o programmi informatici e li trasmettono attraverso l'uso di strumenti di comunicazione telematica."
        },
        {
          "code" : "4.1.2.3.0",
          "display" : "Addetti alle macchine per la riproduzione e l'invio di materiali e documenti",
          "definition" : "Le professioni classificate in questa unità riproducono documenti esistenti utilizzando fotocopiatrici, scanner, fax o programmi informatici e li trasmettono attraverso l'uso di strumenti di comunicazione telematica."
        },
        {
          "code" : "4.2",
          "display" : "Impiegati addetti ai movimenti di denaro e all'assistenza clienti",
          "definition" : "Le professioni classificate in questo gruppo trattano con la clientela per eseguire operazioni di movimentazione di denaro e di titoli di diversa natura in banche, uffici postali, assicurazioni o agenzie di pegno; per fornire informazioni, assistenza e accoglienza."
        },
        {
          "code" : "4.2.1",
          "display" : "Impiegati addetti agli sportelli e ai movimenti di denaro",
          "definition" : "Le professioni classificate in questa classe incassano e movimentano presso sportelli il denaro dovuto per pagamenti di servizi e per il riscatto di titoli di credito; incassano e riscattano polizze assicurative, titoli finanziari, fatture, crediti e tasse; prestano somme di denaro su pegno."
        },
        {
          "code" : "4.2.1.1",
          "display" : "Addetti agli sportelli assicurativi, bancari e di altri intermediari finanziari",
          "definition" : "Le professioni classificate in questa categoria movimentano, per conto del pubblico, denaro in entrata e in uscita dalle casse delle banche o di altri istituti di intermediazione finanziaria, per varie finalità, seguendo le procedure previste e tenendo scrittura delle operazioni effettuate; incassano e riscattano e informano i clienti sulle procedure di sottoscrizione e sulle condizioni di applicazione di polizze assicurative."
        },
        {
          "code" : "4.2.1.1.0",
          "display" : "Addetti agli sportelli assicurativi, bancari e di altri intermediari finanziari",
          "definition" : "Le professioni classificate in questa unità movimentano, per conto del pubblico, denaro in entrata e in uscita dalle casse delle banche o di altri istituti di intermediazione finanziaria, per varie finalità, seguendo le procedure previste e tenendo scrittura delle operazioni effettuate; incassano e riscattano e informano i clienti sulle procedure di sottoscrizione e sulle condizioni di applicazione di polizze assicurative."
        },
        {
          "code" : "4.2.1.2",
          "display" : "Addetti agli sportelli dei servizi postali",
          "definition" : "Le professioni classificate in questa categoria raccolgono denaro in cambio di operazioni postali o servizi finanziari seguendo le procedure prestabilite e mantenendo scrittura delle operazioni eseguite."
        },
        {
          "code" : "4.2.1.2.0",
          "display" : "Addetti agli sportelli dei servizi postali",
          "definition" : "Le professioni classificate in questa unità raccolgono denaro in cambio di operazioni postali o servizi finanziari seguendo le procedure prestabilite e mantenendo scrittura delle operazioni eseguite."
        },
        {
          "code" : "4.2.1.3",
          "display" : "Addetti agli sportelli per l'esazione di imposte e contributi e al recupero crediti",
          "definition" : "Le professioni classificate in questa categoria riscuotono somme in denaro esercitando il diritto di riscossione di somme dovute all'organizzazione sulla base di contratti, forniture o atti amministrativi definiti, seguendo le procedure e mantenendo scrittura delle operazioni effettuate."
        },
        {
          "code" : "4.2.1.3.0",
          "display" : "Addetti agli sportelli per l'esazione di imposte e contributi e al recupero crediti",
          "definition" : "Le professioni classificate in questa unità riscuotono somme in denaro esercitando il diritto di riscossione di somme dovute all'organizzazione sulla base di contratti, forniture o atti amministrativi definiti, seguendo le procedure e mantenendo scrittura delle operazioni effettuate."
        },
        {
          "code" : "4.2.1.4",
          "display" : "Addetti agli sportelli delle agenzie di pegno e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria prestano somme di denaro in cambio di pegni su oggetti, assumono in custodia questi ultimi e provvedono alla loro riconsegna in caso di riscatto del prestito nei tempi previsti, alla loro vendita all’asta in caso di mancato riscatto; supportano i procedimenti di trascrizione delle ipoteche e di tenuta delle scritture relative."
        },
        {
          "code" : "4.2.1.4.0",
          "display" : "Addetti agli sportelli delle agenzie di pegno e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità prestano somme di denaro in cambio di pegni su oggetti, assumono in custodia questi ultimi e provvedono alla loro riconsegna in caso di riscatto del prestito nei tempi previsti, alla loro vendita all’asta in caso di mancato riscatto; supportano i procedimenti di trascrizione delle ipoteche e di tenuta delle scritture relative."
        },
        {
          "code" : "4.2.1.5",
          "display" : "Addetti alla vendita di biglietti",
          "definition" : "Le professioni comprese in questa unità rilasciano biglietti e titoli di accesso e di fruizione dei servizi offerti incassando corrispettivi in denaro."
        },
        {
          "code" : "4.2.1.5.0",
          "display" : "Addetti alla vendita di biglietti",
          "definition" : "Le professioni comprese in questa unità rilasciano biglietti e titoli di accesso e di fruizione dei servizi offerti incassando corrispettivi in denaro."
        },
        {
          "code" : "4.2.1.6",
          "display" : "Addetti agli sportelli delle agenzie di viaggio",
          "definition" : "Le professioni comprese in questa categoria consigliano i clienti sugli itinerari di viaggio e sulle attrattive dei luoghi da visitare, consegnando loro cartine e brochure illustrative; verificano la disponibilità dei posti presso le strutture ricettive ed effettuano prenotazioni rilasciando gli appositi voucher; espletano le procedure necessarie per ottenere i biglietti, le carte di imbarco ed altri titoli di viaggio."
        },
        {
          "code" : "4.2.1.6.0",
          "display" : "Addetti agli sportelli delle agenzie di viaggio",
          "definition" : "Le professioni comprese in questa unità consigliano i clienti sugli itinerari di viaggio e sulle attrattive dei luoghi da visitare, consegnando loro cartine e brochure illustrative; verificano la disponibilità dei posti presso le strutture ricettive ed effettuano prenotazioni rilasciando gli appositi voucher; espletano le procedure necessarie per ottenere i biglietti, le carte di imbarco ed altri titoli di viaggio."
        },
        {
          "code" : "4.2.2",
          "display" : "Impiegati addetti all'accoglienza e all'informazione della clientela",
          "definition" : "Le professioni classificate in questa classe ricevono il pubblico nel momento del contatto con l’impresa o l'organizzazione o in attività ricettive, assistendolo rispetto alle sue esigenze o richieste; forniscono informazioni direttamente o per telefono e indirizzano il pubblico agli uffici e al personale competente."
        },
        {
          "code" : "4.2.2.1",
          "display" : "Addetti all'accoglienza e all'informazione nelle imprese e negli enti pubblici",
          "definition" : "Le professioni classificate in questa categoria ricevono il pubblico nel momento del contatto con l’impresa o l'organizzazione, assistendolo nella corretta compilazione della modulistica necessaria ad avviare procedure amministrative o rispetto alle sue esigenze o richieste."
        },
        {
          "code" : "4.2.2.1.0",
          "display" : "Addetti all'accoglienza e all'informazione nelle imprese e negli enti pubblici",
          "definition" : "Le professioni classificate in questa unità ricevono il pubblico nel momento del contatto con l’impresa o l'organizzazione, assistendolo nella corretta compilazione della modulistica necessaria ad avviare procedure amministrative o rispetto alle sue esigenze o richieste."
        },
        {
          "code" : "4.2.2.2",
          "display" : "Addetti all'accoglienza nei servizi di alloggio e ristorazione",
          "definition" : "Le professioni classificate in questa categoria accolgono e registrano gli ospiti nelle strutture che forniscono servizi di alloggio; assegnano le camere e consegnano le relative chiavi; forniscono informazioni sui servizi offerti; gestiscono le prenotazioni e le pratiche di registrazione in arrivo e in partenza, tenendo traccia delle camere disponibili; eseguono le operazioni di check-out degli ospiti predisponendo la relativa documentazione. Accolgono i clienti nei ristoranti, gestiscono le prenotazioni dei tavoli."
        },
        {
          "code" : "4.2.2.2.0",
          "display" : "Addetti all'accoglienza nei servizi di alloggio e ristorazione",
          "definition" : "Le professioni classificate in questa unità accolgono e registrano gli ospiti nelle strutture che forniscono servizi di alloggio; assegnano le camere e consegnano le relative chiavi; forniscono informazioni sui servizi offerti; gestiscono le prenotazioni e le pratiche di registrazione in arrivo e in partenza, tenendo traccia delle camere disponibili; eseguono le operazioni di check-out degli ospiti predisponendo la relativa documentazione. Accolgono i clienti nei ristoranti, gestiscono le prenotazioni dei tavoli."
        },
        {
          "code" : "4.2.2.3",
          "display" : "Centralinisti",
          "definition" : "Le professioni classificate in questa categoria ricevono le chiamate dall'esterno e le smistano agli uffici o alle persone interessate dell’impresa o dell’organizzazione."
        },
        {
          "code" : "4.2.2.3.0",
          "display" : "Centralinisti",
          "definition" : "Le professioni classificate in questa unità ricevono le chiamate dall'esterno e le smistano agli uffici o alle persone interessate dell’impresa o dell’organizzazione."
        },
        {
          "code" : "4.2.2.4",
          "display" : "Addetti all'informazione nei Call Center (senza funzioni di vendita)",
          "definition" : "Le professioni classificate in questa categoria forniscono informazioni al pubblico sui prodotti o sui servizi offerti dall'azienda, prendono nota e smistano reclami sui servizi e sui prodotti forniti, indicano le procedure da seguire per ottenere assistenza, rimborsi o risarcimenti. Non eseguono funzioni di vendita."
        },
        {
          "code" : "4.2.2.4.0",
          "display" : "Addetti all'informazione nei Call Center (senza funzioni di vendita)",
          "definition" : "Le professioni classificate in questa unità, utilizzando il telefono o mezzi di comunicazione elettronici (ad esempio e-mail), forniscono informazioni al pubblico sui prodotti o sui servizi offerti dall'azienda, prendono nota e smistano reclami sui servizi e sui prodotti forniti, indicano le procedure da seguire per ottenere assistenza, rimborsi o risarcimenti. Non eseguono funzioni di vendita."
        },
        {
          "code" : "4.3",
          "display" : "Impiegati addetti alla gestione amministrativa, contabile e finanziaria",
          "definition" : "Le professioni classificate in questo gruppo supportano, raccogliendo, compilando ed elaborando la documentazione necessaria, le attività amministrative per l'approvvigionamento, lo stoccaggio e il trasporto di merci e materiali; le attività di gestione contabile, finanziaria e di programmazione di un'impresa o di un'organizzazione."
        },
        {
          "code" : "4.3.1",
          "display" : "Impiegati addetti alla gestione amministrativa della logistica",
          "definition" : "Le professioni classificate in questa classe supportano le attività amministrative per l’approvvigionamento, lo stoccaggio e il trasporto di merci e materiali; tengono nota dei beni prodotti e dei materiali necessari alla produzione; controllano e rilasciano la documentazione di viaggio per il trasporto delle merci ."
        },
        {
          "code" : "4.3.1.1",
          "display" : "Addetti alla gestione degli acquisti",
          "definition" : "Le professioni classificate in questa categoria supportano le attività amministrative per l’approvvigionamento di merci e materiali, eseguono riscontri fra le giacenze di magazzino e gli standard di deposito fissati, raccolgono i prezzi sul mercato delle merci e dei materiali di cui rifornirsi, seguono le procedure di acquisto e di consegna, raccolgono le richieste dei diversi uffici e settori dell’impresa o dell’organizzazione, distribuiscono, documentandone le consegne, merci e materiali secondo necessità e richieste."
        },
        {
          "code" : "4.3.1.1.0",
          "display" : "Addetti alla gestione degli acquisti",
          "definition" : "Le professioni classificate in questa unità supportano le attività amministrative per l’approvvigionamento di merci e materiali, eseguono riscontri fra le giacenze di magazzino e gli standard di deposito fissati, raccolgono i prezzi sul mercato delle merci e dei materiali di cui rifornirsi, seguono le procedure di acquisto e di consegna, raccolgono le richieste dei diversi uffici e settori dell’impresa o dell’organizzazione, distribuiscono, documentandone le consegne, merci e materiali secondo necessità e richieste."
        },
        {
          "code" : "4.3.1.2",
          "display" : "Addetti alla gestione dei magazzini e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria seguono le procedure relative alla tenuta dei magazzini e alla gestione dei depositi di merci e materiali, tengono scrittura delle operazioni di entrata e di uscita delle merci e dei materiali, verificano la corrispondenza tra consistenza fisica e contabile dei materiali e delle merci, supportano le attività di contabilità del magazzino, applicano le procedure di acquisizione e di consegna."
        },
        {
          "code" : "4.3.1.2.0",
          "display" : "Addetti alla gestione dei magazzini e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità seguono le procedure relative alla tenuta dei magazzini e alla gestione dei depositi di merci e materiali, tengono scrittura delle operazioni di entrata e di uscita delle merci e dei materiali, verificano la corrispondenza tra consistenza fisica e contabile dei materiali e delle merci, supportano le attività di contabilità del magazzino, applicano le procedure di acquisizione e di consegna."
        },
        {
          "code" : "4.3.1.3",
          "display" : "Addetti alla gestione amministrativa dei trasporti merci",
          "definition" : "Le professioni classificate in questa categoria sono addetti alla predisposizione ed al controllo delle pratiche amministrative relative ai trasporti di merci e materiali e alla loro organizzazione, predispongono la documentazione di accompagnamento, provvedono alle pratiche doganali di importazione, esportazione e sdoganamento delle merci, seguono le procedure verificando e controllando l’esistenza delle condizioni necessarie alla partenza e al viaggio dei convogli, anche ferroviari."
        },
        {
          "code" : "4.3.1.3.0",
          "display" : "Addetti alla gestione amministrativa dei trasporti merci",
          "definition" : "Le professioni classificate in questa unità sono addette alla predisposizione ed al controllo delle pratiche amministrative relative ai trasporti di merci e materiali e alla loro organizzazione, predispongono la documentazione di accompagnamento, provvedono alle pratiche doganali di importazione, esportazione e sdoganamento delle merci, seguono le procedure verificando e controllando l’esistenza delle condizioni necessarie alla partenza e al viaggio dei convogli, anche ferroviari."
        },
        {
          "code" : "4.3.2",
          "display" : "Impiegati addetti alla gestione economica, contabile e finanziaria",
          "definition" : "Le professioni classificate in questa classe svolgono attività di supporto alla tenuta della contabilità, alla gestione amministrativa del personale, alla programmazione e verifica di un’impresa o di un’organizzazione; raccolgono, organizzano e provvedono ad elaborazioni elementari di dati; incassano, tenendo scrittura delle operazioni effettuate, i corrispettivi in denaro per le forniture o i servizi resi dall’impresa o dall’organizzazione."
        },
        {
          "code" : "4.3.2.1",
          "display" : "Addetti alla contabilità",
          "definition" : "Le professioni classificate in questa categoria supportano, anche utilizzando appositi mezzi informatici, le operazioni di tenuta delle scritture contabili annotando le operazioni, compilando e archiviando la relativa documentazione, eseguendo calcoli e operazioni di verifica."
        },
        {
          "code" : "4.3.2.1.0",
          "display" : "Addetti alla contabilità",
          "definition" : "Le professioni classificate in questa unità supportano, anche utilizzando appositi mezzi informatici, le operazioni di tenuta delle scritture contabili annotando le operazioni, compilando e archiviando la relativa documentazione, eseguendo calcoli e operazioni di verifica."
        },
        {
          "code" : "4.3.2.2",
          "display" : "Addetti alle buste paga",
          "definition" : "Le professioni classificate in questa categoria eseguono attività finalizzate alla redazione delle buste paga, raccogliendo ed elaborando dati sulle presenze, le ore di lavoro e le assenze per ferie o per altri motivi e acquisendo la documentazione relativa."
        },
        {
          "code" : "4.3.2.2.0",
          "display" : "Addetti alle buste paga",
          "definition" : "Le professioni classificate in questa unità eseguono attività finalizzate alla redazione delle buste paga, raccogliendo ed elaborando dati sulle presenze, le ore di lavoro e le assenze per ferie o per altri motivi e acquisendo la documentazione relativa."
        },
        {
          "code" : "4.3.2.3",
          "display" : "Addetti alle operazioni finanziarie per conto dell'impresa o dell'organizzazione",
          "definition" : "Le professioni classificate in questa categoria svolgono attività di supporto alla gestione e al controllo delle attività finanziarie dell’impresa o dell'organizzazione, eseguono operazioni presso le banche, seguono le procedure per la gestione dei depositi bancari, per la richiesta di fidi o altri tipi di prestiti, per il pagamento dei tributi e l’incasso delle fatture."
        },
        {
          "code" : "4.3.2.3.0",
          "display" : "Addetti alle operazioni finanziarie per conto dell'impresa o dell'organizzazione",
          "definition" : "Le professioni classificate in questa unità svolgono attività di supporto alla gestione e al controllo delle attività finanziarie dell’impresa o dell'organizzazione, eseguono operazioni presso le banche, seguono le procedure per la gestione dei depositi bancari, per la richiesta di fidi o altri tipi di prestiti, per il pagamento dei tributi e l’incasso delle fatture."
        },
        {
          "code" : "4.3.2.4",
          "display" : "Addetti ai servizi statistici",
          "definition" : "Le professioni classificate in questa categoria reperiscono, rilevano, raccolgono, organizzano e provvedono ad elaborazioni elementari di dati e di altri materiali documentali necessari alle attività dell'ufficio, dell’impresa o dell'organizzazione, anche con l’uso di tecnologie informatiche."
        },
        {
          "code" : "4.3.2.4.0",
          "display" : "Addetti ai servizi statistici",
          "definition" : "Le professioni classificate in questa unità reperiscono, rilevano, raccolgono, organizzano e provvedono ad elaborazioni elementari di dati e di altri materiali documentali necessari alle attività dell'ufficio, dell’impresa o dell'organizzazione, anche con l’uso di tecnologie informatiche."
        },
        {
          "code" : "4.3.2.5",
          "display" : "Addetti agli uffici interni di cassa",
          "definition" : "Le professioni classificate in questa categoria incassano, tenendo scrittura delle operazioni effettuate e seguendo le procedure stabilite, i corrispettivi in denaro per le forniture o i servizi resi dall’impresa o dall’organizzazione e per il rilascio di titoli di accesso ai servizi offerti."
        },
        {
          "code" : "4.3.2.5.0",
          "display" : "Addetti agli uffici interni di cassa",
          "definition" : "Le professioni classificate in questa categoria incassano, tenendo scrittura delle operazioni effettuate e seguendo le procedure stabilite, i corrispettivi in denaro per le forniture o i servizi resi dall’impresa o dall’organizzazione."
        },
        {
          "code" : "4.4",
          "display" : "Impiegati addetti alla raccolta, controllo, conservazione e recapito della documentazione",
          "definition" : "Le professioni classificate in questo gruppo svolgono operazioni di controllo e verifica di conformità di documenti, atti o operazioni; provvedono, presso gli uffici postali, all'accusa, smistamento e recapito della posta; raccolgono, archiviano, conservano e diffondono, secondo criteri e procedure prestabilite, materiali documentari e libri."
        },
        {
          "code" : "4.4.1",
          "display" : "Impiegati addetti al controllo di documenti e allo smistamento e recapito della posta",
          "definition" : "Le professioni classificate in questa classe svolgono operazioni di controllo e verifica di conformità rispetto a procedure stabilite di atti, operazioni o documenti; provvedono allo smistamento e al recapito della posta."
        },
        {
          "code" : "4.4.1.1",
          "display" : "Personale addetto a compiti di controllo, verifica e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria svolgono operazioni di controllo e verifica di conformità degli atti, delle operazioni, delle acquisizioni e delle cessioni di merci, materiali e simili rispetto alle procedure codificate o a quanto preventivato."
        },
        {
          "code" : "4.4.1.1.0",
          "display" : "Personale addetto a compiti di controllo, verifica e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria svolgono operazioni di controllo e verifica di conformità degli atti, delle operazioni, delle acquisizioni e delle cessioni di merci, materiali e simili rispetto alle procedure codificate o a quanto preventivato."
        },
        {
          "code" : "4.4.1.2",
          "display" : "Addetti al controllo della documentazione di viaggio",
          "definition" : "Le professioni classificate in questa categoria controllano la completezza e la correttezza della documentazione e dei titoli di viaggio di merci e persone, nei trasporti aerei, marittimi, su gomma o ferroviari, intervenendo nel caso in cui siano rilevate non conformità."
        },
        {
          "code" : "4.4.1.2.0",
          "display" : "Addetti al controllo della documentazione di viaggio",
          "definition" : "Le professioni classificate in questa categoria controllano la completezza e la correttezza della documentazione e dei titoli di viaggio di merci e persone, nei trasporti aerei, marittimi, su gomma o ferroviari, intervenendo nel caso in cui siano rilevate non conformità."
        },
        {
          "code" : "4.4.1.3",
          "display" : "Addetti allo smistamento e al recapito della posta",
          "definition" : "Le professioni classificate in questa categoria provvedono, presso gli uffici postali, all’accusa e allo smistamento della posta e della documentazione in ingresso e al recapito della stessa ai destinatari."
        },
        {
          "code" : "4.4.1.3.0",
          "display" : "Addetti allo smistamento e al recapito della posta",
          "definition" : "Le professioni classificate in questa unità provvedono, presso gli uffici postali, all’accusa e allo smistamento della posta e della documentazione in ingresso e al recapito della stessa ai destinatari."
        },
        {
          "code" : "4.4.2",
          "display" : "Impiegati addetti all'archiviazione e conservazione della documentazione",
          "definition" : "Le professioni classificate in questa classe classificano, schedano, archiviano e conservano, seguendo criteri e procedure predefiniti, documenti, libri e materiali e li rendono disponibili al pubblico in archivi o biblioteche."
        },
        {
          "code" : "4.4.2.1",
          "display" : "Addetti ad archivi, schedari e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria classificano, schedano, archiviano e conservano documenti e materiali raccolti o ricevuti, seguendo criteri e procedure predefiniti che ne rendono possibile la reperibilità."
        },
        {
          "code" : "4.4.2.1.0",
          "display" : "Addetti ad archivi, schedari e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità classificano, schedano, archiviano e conservano documenti e materiali raccolti o ricevuti, seguendo criteri e procedure predefiniti che ne rendono possibile la reperibilità."
        },
        {
          "code" : "4.4.2.2",
          "display" : "Addetti a biblioteche e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria classificano, schedano, archiviano, conservano e rendono disponibili al pubblico in biblioteche materiali documentari e libri."
        },
        {
          "code" : "4.4.2.2.0",
          "display" : "Addetti a biblioteche e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità classificano, schedano, archiviano, conservano e rendono disponibili al pubblico in biblioteche materiali documentari e libri."
        }
      ]
    },
    {
      "code" : "5",
      "display" : "PROFESSIONI QUALIFICATE NELLE ATTIVITA’ COMMERCIALI E NEI SERVIZI",
      "definition" : "Il quinto grande gruppo classifica le professioni che assistono i clienti negli esercizi commerciali, forniscono servizi di ricezione e di ristorazione, servizi ricreativi e di supporto alle famiglie, di cura della persona; di mantenimento dell’ordine pubblico, di protezione delle persone e della proprietà. I loro compiti consistono nel gestire piccoli esercizi commerciali, ricettivi e di ristorazione e le relative attività; nell’assistere clienti e consumatori; nel trasmettere cognizioni pratiche per l’esercizio di hobby; nell’addestrare e custodire animali domestici; nel fornire servizi sociali e sanitari di base; nel gestire piccole palestre, cinema ed altri servizi ricreativi; nel fornire ausili nelle attività del tempo libero; servizi di igiene personale e di governo della casa, di compagnia e di assistenza della persona; supporto nello svolgimento di pratiche e di altri servizi legati al menage familiare; nel garantire l’ordine pubblico, la sicurezza delle persone e la tutela della proprietà. Tali attività richiedono in genere conoscenze di base assimilabili a quelle acquisite completando l'obbligo scolastico, o un ciclo breve di istruzione secondaria superiore o, ancora, una qualifica professionale o esperienza lavorativa.",
      "concept" : [
        {
          "code" : "5.1",
          "display" : "Professioni qualificate nelle attività commerciali",
          "definition" : "Le professioni comprese in questo gruppo gestiscono, nei mercati, a distanza, a domicilio o nei negozi, attività di vendita al pubblico, all’ingrosso o al minuto, di prodotti di vario genere; assistono e consigliano i clienti negli acquisti; forniscono informazioni e dimostrazioni sulle caratteristiche e sulle funzionalità dei prodotti venduti; smistano merci, incassano i corrispettivi dei prodotti venduti; allestiscono vetrine ed espositori, indossano capi, accessori di abbigliamento o merci di altra natura per sfilate di moda, campagne pubblicitarie o altri tipi di manifestazioni e attività pubblicitarie."
        },
        {
          "code" : "5.1.1",
          "display" : "Esercenti delle vendite",
          "definition" : "Le professioni comprese in questa classe definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di esercizi di vendita e di distribuzione di prodotti commerciali per il consumo o necessari alla produzione di altri beni; sono direttamente impegnati nelle attività di vendita assistendo, informando e consigliando i clienti sugli acquisti."
        },
        {
          "code" : "5.1.1.1",
          "display" : "Esercenti delle vendite all'ingrosso",
          "definition" : "Le professioni comprese in questa categoria definiscono, pianificano, implementano e gestiscono - direttamente e senza supporti alle decisioni e all'organizzazione imprenditoriali, anche non specialistici - le strategie e le politiche di vendita di esercizi commerciali all'ingrosso di piccole dimensioni; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e di vendita. Sono direttamente impegnati nelle attività di vendita assistendo, informando e consigliando i clienti sugli acquisti."
        },
        {
          "code" : "5.1.1.1.0",
          "display" : "Esercenti delle vendite all'ingrosso",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di esercizi commerciali all’ingrosso di piccole dimensioni; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e di vendita. Sono direttamente impegnati nelle attività di vendita assistendo, informando e consigliando i clienti sugli acquisti."
        },
        {
          "code" : "5.1.1.2",
          "display" : "Esercenti delle vendite al minuto",
          "definition" : "Le professioni comprese in questa categoria definiscono, pianificano, implementano e gestiscono – direttamente e senza supporti alle decisioni e all’organizzazione imprenditoriali, anche non specialistici – le strategie e le politiche di vendita di esercizi di piccole dimensioni per la vendita di prodotti e beni destinati al consumo finale, anche situati nei mercati o in posti fissi a loro assegnati; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e di vendita. Sono direttamente impegnati nelle attività di vendita assistendo, informando e consigliando i clienti sugli acquisti."
        },
        {
          "code" : "5.1.1.2.1",
          "display" : "Esercenti delle vendite al minuto in negozi",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di esercizi di piccole dimensioni per la vendita di prodotti e beni destinati al consumo finale; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e di vendita. Sono direttamente impegnati nelle attività di vendita assistendo, informando e consigliando i clienti sugli acquisti."
        },
        {
          "code" : "5.1.1.2.2",
          "display" : "Esercenti delle vendite al minuto nei mercati e in posti assegnati",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di esercizi di piccole dimensioni, nei mercati o in posti fissi a loro assegnati, per la vendita di prodotti e beni destinati al consumo finale; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e di vendita. Sono direttamente impegnati nelle attività di vendita assistendo, informando e consigliando i clienti sugli acquisti."
        },
        {
          "code" : "5.1.1.3",
          "display" : "Esercenti di distributori di carburanti ed assimilati",
          "definition" : "Le professioni comprese in questa categoria definiscono, pianificano, implementano e gestiscono – direttamente e senza supporti alle decisioni e all’organizzazione imprenditoriali, anche non specialistici – le strategie e le politiche di vendita di esercizi di piccole dimensioni per la distribuzione di carburanti e di prodotti simili destinati al consumo finale; valutano i risultati dell’attività; negoziano con i fornitori e i clienti; programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e di vendita. Sono direttamente impegnati nelle attività di vendita assistendo, informando e consigliando i clienti sugli acquisti."
        },
        {
          "code" : "5.1.1.3.0",
          "display" : "Esercenti di distributori di carburanti ed assimilati",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di esercizi di piccole dimensioni per la distribuzione di carburanti e di prodotti simili destinati al consumo finale; valutano i risultati dell’attività; negoziano con i fornitori e i clienti; programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e di vendita. Sono direttamente impegnati nelle attività di vendita assistendo, informando e consigliando i clienti sugli acquisti."
        },
        {
          "code" : "5.1.2",
          "display" : "Addetti alle vendite",
          "definition" : "Le professioni comprese in questa classe assistono, consigliano e informano i clienti sugli acquisti relativamente agli aspetti merceologici, di prezzo e legati al servizio reso; attendono all’organizzazione di base dell’attività come smistare merci, prender nota di quelle in entrata e in uscita dal negozio, incassare i corrispettivi delle vendite e mansioni organizzative simili."
        },
        {
          "code" : "5.1.2.1",
          "display" : "Commessi delle vendite all'ingrosso",
          "definition" : "Le professioni comprese in questa categoria assistono, consigliano e informano i clienti, negli esercizi di vendita riservata a produttori o altri rivenditori e distributori, sugli acquisti di prodotti e la fornitura di beni, relativamente agli aspetti merceologici e di prezzo."
        },
        {
          "code" : "5.1.2.1.0",
          "display" : "Commessi delle vendite all'ingrosso",
          "definition" : "Le professioni comprese in questa unità assistono, consigliano e informano i clienti, negli esercizi di vendita riservata a produttori o altri rivenditori e distributori, sugli acquisti di prodotti e la fornitura di beni, relativamente agli aspetti merceologici e di prezzo."
        },
        {
          "code" : "5.1.2.2",
          "display" : "Commessi delle vendite al minuto",
          "definition" : "Le professioni comprese in questa categoria assistono, consigliano e informano i clienti sugli acquisti di prodotti e la fornitura di beni, inclusa la fornitura di energia e i servizi di telefonia e assimilati. Possono svolgere compiti organizzativi di base dell’attività come smistare merci, prendere nota di quelle in entrata e in uscita dal negozio, incassare i corrispettivi delle vendite e mansioni organizzative simili."
        },
        {
          "code" : "5.1.2.2.0",
          "display" : "Commessi delle vendite al minuto",
          "definition" : "Le professioni comprese in questa unità assistono, consigliano e informano i clienti sugli acquisti di prodotti e la fornitura di beni, inclusa la fornitura di energia e i servizi di telefonia e assimilati. Possono svolgere compiti organizzativi di base dell’attività come smistare merci, prendere nota di quelle in entrata e in uscita dal negozio, incassare i corrispettivi delle vendite e mansioni organizzative simili."
        },
        {
          "code" : "5.1.2.3",
          "display" : "Addetti ad attività organizzative delle vendite",
          "definition" : "Le professioni comprese in questa categoria svolgono, negli esercizi di vendita, attività di coordinamento e di supporto organizzativo; supervisionano e istruiscono gli addetti alle vendite, stabiliscono la suddivisione degli incarichi, curano l'allestimento delle merci negli scaffali, provvedono alla raccolta degli ordini, si assicurano che i clienti ricevano un servizio adeguato."
        },
        {
          "code" : "5.1.2.3.0",
          "display" : "Addetti ad attività organizzative delle vendite",
          "definition" : "Le professioni comprese in questa unità svolgono, negli esercizi di vendita, attività di coordinamento e di supporto organizzativo; supervisionano e istruiscono gli addetti alle vendite, stabiliscono la suddivisione degli incarichi, curano l'allestimento delle merci negli scaffali, provvedono alla raccolta degli ordini, si assicurano che i clienti ricevano un servizio adeguato."
        },
        {
          "code" : "5.1.2.4",
          "display" : "Cassieri di esercizi commerciali",
          "definition" : "Le professioni comprese in questa categoria incassano il corrispettivo delle merci o dei servizi venduti all'ingrosso e al minuto, rilasciando apposita quietanza e mantenendo nota delle operazioni effettuate"
        },
        {
          "code" : "5.1.2.4.0",
          "display" : "Cassieri di esercizi commerciali",
          "definition" : "Le professioni comprese in questa unità incassano il corrispettivo delle merci o dei servizi venduti all’ingrosso e al minuto, rilasciando apposita quietanza e mantenendo nota delle operazioni effettuate"
        },
        {
          "code" : "5.1.2.5",
          "display" : "Venditori a domicilio, a distanza e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria vendono vari tipi di merci o di servizi porta a porta, direttamente presso il domicilio di potenziali clienti; sollecitano ordini di merci o di servizi telefonando a possibili clienti o raggiungendoli con appositi programmi televisivi."
        },
        {
          "code" : "5.1.2.5.1",
          "display" : "Venditori a domicilio",
          "definition" : "Le professioni comprese in questa unità vendono vari tipi di merci o di servizi porta a porta, direttamente presso il domicilio di potenziali clienti."
        },
        {
          "code" : "5.1.2.5.2",
          "display" : "Venditori a distanza",
          "definition" : "Le professioni comprese in questa unità sollecitano ordini di merci o di servizi contattando i possibili clienti attraverso telefono, canali internet o raggiungendoli con appositi programmi televisivi."
        },
        {
          "code" : "5.1.2.6",
          "display" : "Addetti ai distributori di carburanti ed assimilati",
          "definition" : "Le professioni comprese in questa categoria assistono i clienti sugli acquisti di carburanti e prodotti simili destinati al consumo finale. Possono svolgere compiti organizzativi di base dell’attività come smistare merci, prender nota di quelle in entrata e in uscita dall’esercizio, incassare i corrispettivi delle vendite e mansioni organizzative simili. Possono inoltre svolgere compiti semplici di supporto al mantenimento delle condizioni di efficienza degli autoveicoli dei clienti."
        },
        {
          "code" : "5.1.2.6.0",
          "display" : "Addetti ai distributori di carburanti ed assimilati",
          "definition" : "Le professioni comprese in questa unità assistono i clienti sugli acquisti di carburanti e prodotti simili destinati al consumo finale. Possono svolgere compiti organizzativi di base dell’attività come smistare merci, prender nota di quelle in entrata e in uscita dall’esercizio, incassare i corrispettivi delle vendite e mansioni organizzative simili. Possono inoltre svolgere compiti semplici di supporto al mantenimento delle condizioni di efficienza degli autoveicoli dei clienti."
        },
        {
          "code" : "5.1.3",
          "display" : "Altre professioni qualificate nelle attività commerciali",
          "definition" : "Le professioni comprese in questa classe promuovono e pubblicizzano merci, servizi e beni, in genere destinate al consumo finale, indossandole, allestendo vetrine e spazi espositivi, dimostrando o propagandando le loro caratteristiche e il loro funzionamento."
        },
        {
          "code" : "5.1.3.1",
          "display" : "Indossatori, modelli e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria posano per manifestazioni e produzioni artistiche o pubblicitarie, ovvero indossano e mostrano capi, accessori di abbigliamento ed altri prodotti in sfilate di moda o altre modalità di esposizione destinate a rivenditori o a consumatori."
        },
        {
          "code" : "5.1.3.1.0",
          "display" : "Indossatori, modelli e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità posano per manifestazioni e produzioni artistiche o pubblicitarie, ovvero indossano e mostrano capi, accessori di abbigliamento ed altri prodotti in sfilate di moda o altre modalità di esposizione destinate a rivenditori o a consumatori."
        },
        {
          "code" : "5.1.3.2",
          "display" : "Dimostratori e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria rispondono alle domande e mostrano ai clienti le caratteristiche, la convenienza e le modalità d’uso di prodotti e merci per invogliarne l’acquisto."
        },
        {
          "code" : "5.1.3.2.0",
          "display" : "Dimostratori e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità rispondono alle domande e mostrano ai clienti le caratteristiche, la convenienza e le modalità d’uso di prodotti e merci per invogliarne l’acquisto."
        },
        {
          "code" : "5.1.3.3",
          "display" : "Vetrinisti e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria allestiscono vetrine ed espositori di attività commerciali, stand di fiere e di altre manifestazioni o attività simili, per mostrare campioni significativi delle merci in vendita e delle loro caratteristiche e sollecitare l’attenzione di potenziali clienti."
        },
        {
          "code" : "5.1.3.3.0",
          "display" : "Vetrinisti e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità allestiscono vetrine ed espositori di attività commerciali, stand di fiere e di altre manifestazioni o attività simili, per mostrare campioni significativi delle merci in vendita e delle loro caratteristiche e per sollecitare l’attenzione di potenziali clienti."
        },
        {
          "code" : "5.1.3.4",
          "display" : "Addetti all'informazione e all'assistenza dei clienti",
          "definition" : "Le professioni comprese in questa categoria informano o assistono direttamente, all'interno degli esercizi commerciali, i distributori o i consumatori finali su merci, prodotti o servizi."
        },
        {
          "code" : "5.1.3.4.0",
          "display" : "Addetti all'informazione e all'assistenza dei clienti",
          "definition" : "Le professioni comprese in questa unità informano o assistono direttamente, all'interno degli esercizi commerciali, i distributori o i consumatori finali su merci, prodotti o servizi."
        },
        {
          "code" : "5.2",
          "display" : "Professioni qualificate nelle attività ricettive e della ristorazione",
          "definition" : "Le professioni comprese in questo gruppo gestiscono piccole attività ricettive e di ristorazione; accolgono, assistono, consigliano e informano gli avventori di alberghi, ristoranti e bar; cucinano e preparano cibi e bevande in questi e in altri esercizi pubblici simili e per la grande ristorazione; ricevono e assistono i clienti nei viaggi aerei, marittimi e terrestri e nelle manifestazioni congressuali e fieristiche."
        },
        {
          "code" : "5.2.1",
          "display" : "Esercenti nelle attività ricettive",
          "definition" : "Le professioni comprese in questa classe definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di esercizi di piccole dimensioni impiegati in attività ricettive; sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.2.1.1",
          "display" : "Esercenti nelle attività ricettive",
          "definition" : "Le professioni comprese nella categoria definiscono, pianificano, implementano e gestiscono – direttamente e senza supporti alle decisioni e all’organizzazione imprenditoriali, anche non specialistici – le strategie e le politiche di vendita di esercizi di piccole dimensioni impiegati in attività ricettive; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.2.1.1.0",
          "display" : "Esercenti nelle attività ricettive",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di esercizi di piccole dimensioni impiegati in attività ricettive; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.2.2",
          "display" : "Esercenti ed addetti nelle attività di ristorazione",
          "definition" : "Le professioni comprese in questa classe definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di ristoranti, bar, fast food, pizzerie ed altre attività di ristorazione di piccole dimensioni; accolgono, assistono, consigliano, informano e servono gli avventori; cucinano e preparano cibi e bevande su ordinazione diretta del cliente e per la grande ristorazione."
        },
        {
          "code" : "5.2.2.1",
          "display" : "Cuochi in alberghi e ristoranti",
          "definition" : "Le professioni comprese in questa categoria dirigono la preparazione o preparano direttamente su ordinazione del cliente cibi come antipasti, primi e secondi piatti, insalate e dessert a base di vegetali, di carni o di altri prodotti, curandone la presentazione, il condimento e la cottura. Predispongono menu giornalieri, ordinano gli alimenti e i prodotti necessari per la cucina, si occupano della loro conservazione e sovrintendono all’igiene dei luoghi e delle attrezzature per la preparazione."
        },
        {
          "code" : "5.2.2.1.0",
          "display" : "Cuochi in alberghi e ristoranti",
          "definition" : "Le professioni comprese in questa unità dirigono la preparazione o preparano direttamente su ordinazione del cliente cibi come antipasti, primi e secondi piatti, insalate e dessert a base di vegetali, di carni o di altri prodotti, curandone la presentazione, il condimento e la cottura. Predispongono menu giornalieri, ordinano gli alimenti e i prodotti necessari per la cucina, si occupano della loro conservazione e sovrintendono all’igiene dei luoghi e delle attrezzature per la preparazione."
        },
        {
          "code" : "5.2.2.2",
          "display" : "Addetti alla preparazione, alla cottura e alla distribuzione di cibi",
          "definition" : "Le professioni comprese in questa categoria cucinano grandi quantità di cibi per la ristorazione collettiva di scuole, ospedali, mense aziendali o altre istituzioni seguendo menu predefiniti; in esercizi con menu limitati, in fast food o in attività, anche ambulanti, che offrono cibi che richiedono tempi brevi di preparazione; provvedono a servire dai banconi vivande, alimenti e bevande agli avventori di mense, fast-food, tavole calde ed esercizi assimilati; confezionano cibi precotti o crudi a base di vegetali, carni o altri prodotti. Curano la conservazione degli alimenti e sovrintendono all’igiene dei luoghi e delle attrezzature."
        },
        {
          "code" : "5.2.2.2.1",
          "display" : "Addetti alla preparazione e alla cottura di cibi in imprese per la ristorazione collettiva",
          "definition" : "Le professioni comprese in questa unità cucinano grandi quantità di cibi per la ristorazione collettiva di scuole, ospedali, mense aziendali o altre istituzioni seguendo menu predefiniti. Curano la conservazione degli alimenti e sovrintendono all’igiene dei luoghi e delle attrezzature."
        },
        {
          "code" : "5.2.2.2.2",
          "display" : "Addetti alla preparazione, alla cottura e alla vendita di cibi in fast food, tavole calde, rosticcerie ed esercizi assimilati",
          "definition" : "Le professioni comprese in questa unità preparano e cucinano cibi per la ristorazione collettiva in esercizi con menu limitati, in fast food, tavole calde o in attività, anche ambulanti, che vendono cibi che richiedono tempi brevi di preparazione. Curano la conservazione degli alimenti e sovrintendono all’igiene dei luoghi e delle attrezzature."
        },
        {
          "code" : "5.2.2.2.3",
          "display" : "Addetti al banco nei servizi di ristorazione",
          "definition" : "Le professioni comprese in questa unità provvedono a servire dai banconi vivande, alimenti e bevande agli avventori di mense, fast-food, tavole calde ed esercizi assimilati; confezionano cibi precotti o crudi a base di vegetali, carni o altri prodotti; curano la conservazione degli alimenti e sovrintendono all’igiene dei luoghi e delle attrezzature."
        },
        {
          "code" : "5.2.2.3",
          "display" : "Camerieri e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria assistono i clienti degli esercizi pubblici nei loro bisogni e curano le loro richieste, ovvero li accolgono e li accompagnano al momento dell'arrivo e della partenza negli esercizi alberghieri, governano i piani e le stanze d’albergo; fanno accomodare e assistono i clienti ai tavoli nei ristoranti, prendono le ordinazioni e le sottopongono in cucina, consigliano e informano sui cibi, sui vini e sugli alcolici da abbinare e li servono secondo le regole, preparano e sottopongono il conto; sovrintendono e provvedono alla cura e all’igiene dei luoghi e delle attrezzature."
        },
        {
          "code" : "5.2.2.3.1",
          "display" : "Camerieri di albergo",
          "definition" : "Le professioni comprese in questa unità assistono i clienti degli esercizi alberghieri nei loro bisogni e curano le loro richieste, li accolgono e li accompagnano al momento dell'arrivo e della partenza; governano i piani e le stanze d’albergo; sovrintendono e provvedono alla cura e all’igiene dei luoghi e delle attrezzature."
        },
        {
          "code" : "5.2.2.3.2",
          "display" : "Camerieri di ristorante",
          "definition" : "Le professioni comprese in questa unità assistono i clienti degli esercizi pubblici nei loro bisogni, ovvero fanno accomodare e assistono i clienti ai tavoli nei ristoranti, prendono le ordinazioni e le sottopongono in cucina, consigliano e informano sui cibi, sui vini e sugli alcolici da abbinare e li servono secondo le regole; preparano e sottopongono il conto; sovrintendono e provvedono alla cura e all’igiene dei luoghi e delle attrezzature."
        },
        {
          "code" : "5.2.2.4",
          "display" : "Baristi e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria preparano e servono bevande e snack ai clienti direttamente o tramite camerieri nei bar, nei ristoranti e in altri esercizi pubblici; sovrintendono e provvedono alla cura e all’igiene dei luoghi e delle attrezzature."
        },
        {
          "code" : "5.2.2.4.0",
          "display" : "Baristi e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità preparano e servono bevande e snack ai clienti direttamente o tramite camerieri nei bar, nei ristoranti e in altri esercizi pubblici; sovrintendono e provvedono alla cura e all’igiene dei luoghi e delle attrezzature."
        },
        {
          "code" : "5.2.2.5",
          "display" : "Esercenti nelle attività di ristorazione",
          "definition" : "Le professioni comprese in questa categoria definiscono, pianificano, implementano e gestiscono – direttamente e senza supporti alle decisioni e all’organizzazione imprenditoriali, anche non specialistici – le strategie e le politiche di vendita di ristoranti, bar, fast food, pizzerie ed altre attività di ristorazione di piccole dimensioni, anche svolte nei mercati o in posti fissi assegnati; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.2.2.5.1",
          "display" : "Esercenti di ristoranti, fast food, pizzerie ed esercizi assimilati",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di ristoranti, bar, fast food, pizzerie ed altre attività di ristorazione di piccole dimensioni; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.2.2.5.2",
          "display" : "Esercenti di attività di ristorazione nei mercati e in posti assegnati",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di attività di ristorazione di piccole dimensioni svolte nei mercati o in posti fissi assegnati; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.2.3",
          "display" : "Assistenti di viaggio e professioni assimilate",
          "definition" : "Le professioni comprese in questa classe ricevono e assistono i clienti nei viaggi aerei, marittimi e terrestri e nelle manifestazioni congressuali e fieristiche; accompagnano i visitatori e i turisti nei giri panoramici e nelle visite nelle città."
        },
        {
          "code" : "5.2.3.1",
          "display" : "Hostess, steward e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria ricevono e assistono i clienti nei viaggi aerei; nei viaggi e nelle crociere marittime e terrestri e nelle manifestazioni congressuali e fieristiche."
        },
        {
          "code" : "5.2.3.1.1",
          "display" : "Assistenti di volo",
          "definition" : "Le professioni comprese in questa unità ricevono e assistono i clienti nei viaggi aerei, intervengono per garantire il rapido svolgimento delle azioni in situazioni di emergenza."
        },
        {
          "code" : "5.2.3.1.2",
          "display" : "Assistenti di viaggio e crociera",
          "definition" : "Le professioni comprese in questa unità ricevono e assistono i clienti nei viaggi e nelle crociere marittime e terrestri, intervengono per garantire il rapido svolgimento delle azioni in situazioni di emergenza."
        },
        {
          "code" : "5.2.3.1.3",
          "display" : "Assistenti congressuali e fieristici",
          "definition" : "Le professioni comprese in questa unità ricevono e assistono i clienti nelle manifestazioni congressuali e fieristiche, intervengono per garantire il rapido svolgimento delle azioni in situazioni di emergenza."
        },
        {
          "code" : "5.2.3.2",
          "display" : "Accompagnatori turistici",
          "definition" : "Le professioni comprese in questa categoria assistono e accompagnano visitatori e turisti nei giri panoramici e nelle visite a scorci, a quartieri e a luoghi suggestivi di città."
        },
        {
          "code" : "5.2.3.2.0",
          "display" : "Accompagnatori turistici",
          "definition" : "Le professioni comprese in questa unità assistono e accompagnano visitatori e turisti nei giri panoramici e nelle visite a scorci, a quartieri e a luoghi suggestivi di città."
        },
        {
          "code" : "5.3",
          "display" : "Professioni qualificate nei servizi sanitari e sociali",
          "definition" : "Le professioni comprese in questo gruppo svolgono attività di supporto nell’assistenza sanitaria alle persone e nelle attività di sorveglianza e tutela dell’igiene pubblica."
        },
        {
          "code" : "5.3.1",
          "display" : "Professioni qualificate nei servizi sanitari e sociali",
          "definition" : "Le professioni comprese in questa classe supportano il personale sanitario nella somministrazione di terapie e nella sorveglianza e nella tutela dell’igiene e della sicurezza sanitaria pubblica; effettuano assistenza fisico manuale svolgendo, nell'ambito delle proprie competenze, la prevenzione, la cura, la riabilitazione e il recupero funzionale mediante massoterapia, balneoterapia e idroterapia; svolgono interventi di assistenza finalizzati a soddisfare i bisogni primari dei pazienti; si occupano dello sviluppo psicologico, motorio, ludico e sanitario dei bambini."
        },
        {
          "code" : "5.3.1.1",
          "display" : "Professioni qualificate nei servizi sanitari e sociali",
          "definition" : "Le professioni comprese in questa categoria supportano il personale sanitario nella somministrazione di terapie e nella sorveglianza e nella tutela dell’igiene e della sicurezza sanitaria pubblica; effettuano assistenza fisico manuale svolgendo, nell'ambito delle proprie competenze, la prevenzione, la cura, la riabilitazione e il recupero funzionale mediante massoterapia, balneoterapia e idroterapia; svolgono interventi di assistenza finalizzati a soddisfare i bisogni primari dei pazienti; si occupano dello sviluppo psicologico, motorio, ludico e sanitario dei bambini."
        },
        {
          "code" : "5.3.1.1.0",
          "display" : "Professioni qualificate nei servizi sanitari e sociali",
          "definition" : "Le professioni comprese in questa unità supportano il personale sanitario nella somministrazione di terapie e nella sorveglianza e nella tutela dell’igiene e della sicurezza sanitaria pubblica; effettuano assistenza fisico manuale svolgendo, nell'ambito delle proprie competenze, la prevenzione, la cura, la riabilitazione e il recupero funzionale mediante massoterapia, balneoterapia e idroterapia; svolgono interventi di assistenza finalizzati a soddisfare i bisogni primari dei pazienti; si occupano dello sviluppo psicologico, motorio, ludico e sanitario dei bambini."
        },
        {
          "code" : "5.4",
          "display" : "Professioni qualificate nei servizi culturali, di sicurezza e alla persona",
          "definition" : "Le professioni comprese in questo gruppo trasferiscono in percorsi di formazione o di addestramento (non professionale) cognizioni pratiche per svolgere, nel tempo libero o per la produzione familiare,attività artigianali o espressive; erogano servizi per il tempo libero, la pulizia, l’igiene, la cura e la sicurezza delle persone e per la custodia e la vigilanza sulla proprietà; addestrano e custodiscono animali."
        },
        {
          "code" : "5.4.1",
          "display" : "Maestri di arti e mestieri",
          "definition" : "Le professioni comprese in questa classe trasferiscono in percorsi di formazione o di addestramento non professionale cognizioni pratiche per svolgere, nel tempo libero o per la produzione familiare, attività artigianali, espressive o di servizio e cura della persona."
        },
        {
          "code" : "5.4.1.1",
          "display" : "Maestri di arti e mestieri",
          "definition" : "Le professioni comprese in questa categoria trasferiscono, in percorsi di formazione o di addestramento non professionale, cognizioni pratiche per svolgere, nel tempo libero o per la produzione familiare, attività di tipo artigianale di riparazione e produzione di manufatti nel campo della sartoria, della maglieria e degli accessori d’abbigliamento, della decorazione, della ceramica, della legatoria, della bigiotteria e della gioielleria e di altre attività legate all’artigianato locale o etnico, oppure per esercitare nel tempo libero attività di tipo espressivo o di servizio e cura della persona nel campo dell’arredamento, dell’antiquariato, della cucina e del maquillage."
        },
        {
          "code" : "5.4.1.1.0",
          "display" : "Maestri di arti e mestieri",
          "definition" : "Le professioni comprese in questa unità trasferiscono, in percorsi di formazione o di addestramento non professionale, cognizioni pratiche per svolgere attività di tipo artigianale di riparazione e produzione di manufatti nel campo della sartoria, della maglieria e degli accessori d’abbigliamento, della decorazione, della ceramica, della legatoria, della bigiotteria e della gioielleria e di altre attività legate all’artigianato locale o etnico, oppure per esercitare nel tempo libero attività di tipo espressivo o di servizio e cura della persona nel campo dell’arredamento, dell’antiquariato, della cucina e del maquillage."
        },
        {
          "code" : "5.4.2",
          "display" : "Professioni qualificate nei servizi ricreativi, culturali ed assimilati",
          "definition" : "Le professioni comprese in questa classe definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di esercizi che offrono servizi ricreativi, culturali e sportivi per il tempo libero alle persone; sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori; assecondano le credenze delle persone sull’astrologia, sulla chiromanzia e sulla preveggenza in genere; accettano denaro su scommesse, puntate e giochi."
        },
        {
          "code" : "5.4.2.1",
          "display" : "Esercenti di cinema, teatri e attività sportive e ricreative",
          "definition" : "Le professioni comprese in questa categoria definiscono, pianificano, implementano e gestiscono – direttamente e senza supporti alle decisioni e all’organizzazione imprenditoriali, anche non specialistici – le strategie e le politiche di vendita di cinema e teatri; di locali notturni e discoteche; di attività ricreative; di palestre e di altri impianti sportivi; di sale scommesse di piccole dimensioni; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.4.2.1.1",
          "display" : "Esercenti di cinema e teatri",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di cinema e teatri di piccole dimensioni; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.4.2.1.2",
          "display" : "Esercenti di locali notturni",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di locali notturni e discoteche di piccole dimensioni; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.4.2.1.3",
          "display" : "Esercenti di attività ricreative",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di attività ricreative di piccole dimensioni; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.4.2.1.4",
          "display" : "Esercenti di attività sportive",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di palestre e di altri impianti sportivi di piccole dimensioni; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.4.2.1.5",
          "display" : "Esercenti di sale scommesse",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di sale scommesse di piccole dimensioni; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’accogliere, assistere, informare e consigliare gli avventori."
        },
        {
          "code" : "5.4.2.2",
          "display" : "Allibratori, croupiers e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria accettano puntate e scommesse in denaro su gare sportive, giochi d’azzardo esercitati in luoghi consentiti, ricevono puntate per il gioco del lotto e per giochi simili, pagano le somme dovute in caso di vincita."
        },
        {
          "code" : "5.4.2.2.1",
          "display" : "Allibratori",
          "definition" : "Le professioni comprese in questa unità accettano puntate e scommesse in denaro sui risultati delle corse negli ippodromi e nei cinodromi, registrandole su libri ufficiali; pagano le somme dovute in caso di vincita."
        },
        {
          "code" : "5.4.2.2.2",
          "display" : "Croupiers",
          "definition" : "Le professioni comprese in questa unità accettano puntate e scommesse in denaro su giochi d’azzardo esercitati in luoghi consentiti, pagano le somme dovute in caso di vincita."
        },
        {
          "code" : "5.4.2.2.3",
          "display" : "Ricevitori",
          "definition" : "Le professioni comprese in questa unità ricevono puntate per gare sportive, per il gioco del lotto e per giochi simili; pagano le somme dovute in caso di vincita."
        },
        {
          "code" : "5.4.2.3",
          "display" : "Astrologi, preveggenti, chiromanti e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria predicono il futuro alle persone, le informano sugli esiti delle loro azioni e dei loro comportamenti, danno indicazione per prevenire eventuali esiti negativi auspicando eventi positivi attraverso l’astrologia, la chiromanzia, la lettura della mano ed altre pratiche simili."
        },
        {
          "code" : "5.4.2.3.0",
          "display" : "Astrologi, preveggenti, chiromanti e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità predicono il futuro alle persone, le informano sugli esiti delle loro azioni e dei loro comportamenti, danno indicazioni per prevenire eventuali esiti negativi auspicando eventi positivi attraverso l’astrologia, la chiromanzia, la lettura della mano ed altre pratiche simili."
        },
        {
          "code" : "5.4.3",
          "display" : "Operatori della cura estetica",
          "definition" : "Le professioni comprese in questa classe forniscono servizi di cura estetica e cosmetica della persona; eseguono trattamenti termali e massaggi per tonificare il corpo e migliorare il benessere."
        },
        {
          "code" : "5.4.3.1",
          "display" : "Acconciatori",
          "definition" : "Le professioni comprese in questa categoria forniscono servizi di cura estetica e cosmetica della persona, massaggiano, trattano il cuoio capelluto e applicano parrucche, tagliano, spuntano, lavano e danno forma a capelli e barbe."
        },
        {
          "code" : "5.4.3.1.0",
          "display" : "Acconciatori",
          "definition" : "Le professioni comprese in questa unità forniscono servizi di cura estetica e cosmetica della persona, massaggiano, trattano il cuoio capelluto e applicano parrucche, tagliano, spuntano, lavano e danno forma a capelli e barbe."
        },
        {
          "code" : "5.4.3.2",
          "display" : "Estetisti e truccatori",
          "definition" : "Le professioni comprese in questa categoria applicano trucchi, eliminano peli superflui, forniscono servizi di manicure e di pedicure, eseguono trattamenti e massaggi cosmetici sul corpo per migliorarne l’aspetto estetico."
        },
        {
          "code" : "5.4.3.2.0",
          "display" : "Estetisti e truccatori",
          "definition" : "Le professioni comprese in questa unità applicano trucchi, eliminano peli superflui, forniscono servizi di manicure e di pedicure, eseguono trattamenti e massaggi cosmetici sul corpo per migliorarne l’aspetto estetico."
        },
        {
          "code" : "5.4.3.3",
          "display" : "Massaggiatori ed operatori termali",
          "definition" : "Le professioni comprese in questa categoria eseguono trattamenti termali (fanghi, inalazioni, ecc.) e massaggi per tonificare il corpo e migliorare il benessere della persona."
        },
        {
          "code" : "5.4.3.3.0",
          "display" : "Massaggiatori ed operatori termali",
          "definition" : "Le professioni comprese in questa unità eseguono trattamenti termali (fanghi, inalazioni, ecc.) e massaggi per tonificare il corpo e migliorare il benessere della persona."
        },
        {
          "code" : "5.4.4",
          "display" : "Professioni qualificate nei servizi personali ed assimilati",
          "definition" : "Le professioni comprese in questa classe erogano servizi di cura della persona, di compagnia e di aiuto domestico alle famiglie, di assistenza a domicilio e nelle istituzioni alle persone che necessitano di aiuto."
        },
        {
          "code" : "5.4.4.1",
          "display" : "Personale di compagnia e personale qualificato di servizio alle famiglie",
          "definition" : "Le professioni comprese in questa categoria offrono alle famiglie servizi qualificati di assistenza domestica, di compagnia alle persone, di supervisione e governo della casa e delle attività familiari, e servizi simili."
        },
        {
          "code" : "5.4.4.1.0",
          "display" : "Personale di compagnia e personale qualificato di servizio alle famiglie",
          "definition" : "Le professioni comprese in questa unità offrono alle famiglie servizi qualificati di assistenza domestica, di compagnia alle persone, di supervisione e governo della casa e delle attività familiari, e servizi simili."
        },
        {
          "code" : "5.4.4.2",
          "display" : "Addetti alla sorveglianza di bambini e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria sorvegliano le attività ludiche dei bambini e li assistono nei loro bisogni presso le famiglie o nelle istituzioni, li intrattengono facendoli giocare, li accompagnano e li riprendono nei luoghi delle attività quotidiane."
        },
        {
          "code" : "5.4.4.2.0",
          "display" : "Addetti alla sorveglianza di bambini e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità sorvegliano le attività ludiche dei bambini e li assistono nei loro bisogni presso le famiglie o nelle istituzioni, li intrattengono facendoli giocare, li accompagnano e li riprendono nei luoghi delle attività quotidiane."
        },
        {
          "code" : "5.4.4.3",
          "display" : "Addetti all'assistenza personale",
          "definition" : "Le professioni comprese in questa unità assistono, nelle istituzioni o a domicilio, le persone anziane, in convalescenza, disabili, in condizione transitoria o permanente di non autosufficienza o con problemi affettivi, le aiutano a svolgere le normali attività quotidiane, a curarsi e a mantenere livelli accettabili di qualità della vita."
        },
        {
          "code" : "5.4.4.3.0",
          "display" : "Addetti all'assistenza personale",
          "definition" : "Le professioni comprese in questa unità assistono, nelle istituzioni o a domicilio, le persone anziane, in convalescenza, disabili, in condizione transitoria o permanente di non autosufficienza o con problemi affettivi, le aiutano a svolgere le normali attività quotidiane, a curarsi e a mantenere livelli accettabili di qualità della vita."
        },
        {
          "code" : "5.4.5",
          "display" : "Addestratori e custodi di animali",
          "definition" : "Le professioni comprese in questa classe domano e addestrano animali; allevano e custodiscono animali domestici non da produzione."
        },
        {
          "code" : "5.4.5.1",
          "display" : "Addestratori di animali",
          "definition" : "Le professioni comprese in questa categoria domano e addestrano gli animali per farli partecipare a competizioni sportive e a mostre, per far loro eseguire determinati compiti e prestazioni, per garantire sicurezza al padrone e alle sue proprietà, obbedienza ai comandi e assistenza a persone disabili, li abituano al contatto, alla voce umana e li condizionano a rispondere a comandi prestabiliti."
        },
        {
          "code" : "5.4.5.1.0",
          "display" : "Addestratori di animali",
          "definition" : "Le professioni comprese in questa unità domano e addestrano gli animali per farli partecipare a competizioni sportive e a mostre, per far loro eseguire determinati compiti e prestazioni, per garantire sicurezza al padrone e alle sue proprietà, obbedienza ai comandi e assistenza a persone disabili, li abituano al contatto, alla voce umana e li condizionano a rispondere a comandi prestabiliti."
        },
        {
          "code" : "5.4.5.2",
          "display" : "Custodi e allevatori di animali domestici e da esposizione",
          "definition" : "Le professioni comprese in questa categoria allevano, custodiscono, alimentano, assistono, curano e mantengono in forma animali domestici non da produzione, presso canili, zoo, ricoveri, acquari ed altri ambienti."
        },
        {
          "code" : "5.4.5.2.0",
          "display" : "Custodi e allevatori di animali domestici e da esposizione",
          "definition" : "Le professioni comprese in questa unità allevano, custodiscono, alimentano, assistono, curano, puliscono e mantengono in forma animali domestici non da produzione, presso canili, zoo, ricoveri, acquari ed altri ambienti."
        },
        {
          "code" : "5.4.6",
          "display" : "Esercenti e addetti di agenzie per il disbrigo di pratiche e professioni assimilate",
          "definition" : "Le professioni comprese in questa classe definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di esercizi che erogano servizi di supporto per il disbrigo di pratiche amministrative; sono direttamente impegnati nell’attività lavorativa propria dell’esercizio."
        },
        {
          "code" : "5.4.6.1",
          "display" : "Esercenti di agenzie per il disbrigo di pratiche e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria definiscono, pianificano, implementano e gestiscono - direttamente e senza supporti alle decisioni e all’organizzazione imprenditoriali, anche non specialistici - le strategie e le politiche di agenzie per il disbrigo di pratiche di piccole dimensioni, valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’attività lavorativa propria dell’esercizio."
        },
        {
          "code" : "5.4.6.1.0",
          "display" : "Esercenti di agenzie per il disbrigo di pratiche e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di agenzie per il disbrigo di pratiche di piccole dimensioni; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’attività lavorativa propria dell’esercizio."
        },
        {
          "code" : "5.4.6.2",
          "display" : "Addetti di agenzie per il disbrigo di pratiche e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria assistono le persone e le famiglie nel disbrigo di pratiche amministrative, curano ricerche documentali per i clienti, li informano e li guidano nelle procedure di attestazione, di certificazione, di ricorso e di stipula di accordi con terze parti."
        },
        {
          "code" : "5.4.6.2.0",
          "display" : "Addetti di agenzie per il disbrigo di pratiche e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità assistono le persone e le famiglie nel disbrigo di pratiche amministrative, curano ricerche documentali per i clienti, li informano e li guidano nelle procedure di attestazione, di certificazione, di ricorso e di stipula di accordi con terze parti."
        },
        {
          "code" : "5.4.7",
          "display" : "Esercenti e addetti di agenzie di pompe funebri",
          "definition" : "Le professioni comprese in questa classe definiscono, pianificano, implementano e gestiscono le strategie e le politiche di vendita di esercizi che erogano servizi funebri per le famiglie; sono direttamente impegnati nell’attività lavorativa propria dell’esercizio."
        },
        {
          "code" : "5.4.7.1",
          "display" : "Esercenti di agenzie di pompe funebri",
          "definition" : "Le professioni comprese nella categoria definiscono, pianificano, implementano e gestiscono - direttamente e senza supporti alle decisioni e all’organizzazione imprenditoriali, anche non specialistici - le strategie e le politiche di agenzie di onoranze funebri di piccole dimensioni, valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’attività lavorativa propria dell’esercizio."
        },
        {
          "code" : "5.4.7.1.0",
          "display" : "Esercenti di agenzie di pompe funebri",
          "definition" : "Le professioni comprese in questa unità definiscono, pianificano, implementano e gestiscono le strategie e le politiche di agenzie di onoranze funebri di piccole dimensioni; valutano i risultati dell’attività; negoziano con i fornitori e i clienti, programmano e controllano l’uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell’attività lavorativa propria dell’esercizio."
        },
        {
          "code" : "5.4.7.2",
          "display" : "Addetti alle agenzie di pompe funebri",
          "definition" : "Le professioni comprese in questa categoria preparano i corpi dei deceduti per il funerale, dispongono la bara nella camera ardente o nella cappella prima del rito funebre; sistemano i fiori o le luci attorno alla bara; guidano od accompagnano i partecipanti al funerale; chiudono la bara e sbrigano le procedure di tumulazione."
        },
        {
          "code" : "5.4.7.2.0",
          "display" : "Addetti alle agenzie di pompe funebri",
          "definition" : "Le professioni comprese in questa unità preparano i corpi dei deceduti per il funerale, dispongono la bara nella camera ardente o nella cappella prima del rito funebre; sistemano i fiori o le luci attorno alla bara; guidano o accompagnano i partecipanti al funerale; chiudono la bara e sbrigano le procedure di tumulazione."
        },
        {
          "code" : "5.4.8",
          "display" : "Professioni qualificate nei servizi di sicurezza, vigilanza e custodia",
          "definition" : "Le professioni comprese in questa classe assicurano il rispetto delle norme e dei regolamenti cittadini e vigilano sul demanio comunale; fanno rispettare le leggi, proteggono le persone e la proprietà e prevengono e reprimono reati; controllano e prevengono incendi; sorvegliano i detenuti negli istituti di pena e di riabilitazione; offrono servizi privati di sicurezza; curano la sicurezza dei bagnanti in piscina e su spiaggia; offrono servizi di custodia e di parcheggio per autovetture."
        },
        {
          "code" : "5.4.8.1",
          "display" : "Personale di guardiania territoriale",
          "definition" : "Le professioni comprese in questa categoria tutelano l’integrità del demanio comunale e controllano l’applicazione sul territorio delle norme e dei regolamenti che lo tutelano."
        },
        {
          "code" : "5.4.8.1.0",
          "display" : "Personale di guardiania territoriale",
          "definition" : "Le professioni comprese in questa unità tutelano l’integrità del demanio comunale e controllano l’applicazione sul territorio delle norme e dei regolamenti che lo tutelano."
        },
        {
          "code" : "5.4.8.2",
          "display" : "Vigili urbani",
          "definition" : "Le professioni comprese in questa categoria assicurano il rispetto delle norme e dei regolamenti cittadini, regolano il traffico, pattugliano le strade, prevengono o sanzionano infrazioni, controllano l’esercizio del commercio, visitano mercati, negozi e locali pubblici controllando l'igiene e la provenienza delle merci vendute, forniscono informazioni sulla città, collaborano con le forze dell’ordine nella tutela della sicurezza dei cittadini."
        },
        {
          "code" : "5.4.8.2.0",
          "display" : "Vigili urbani",
          "definition" : "Le professioni comprese in questa unità assicurano il rispetto delle norme e dei regolamenti cittadini, regolano il traffico, pattugliano le strade, prevengono o sanzionano infrazioni, controllano l’esercizio del commercio, visitano mercati, negozi e locali pubblici controllando l'igiene e la provenienza delle merci vendute, forniscono informazioni sulla città, collaborano con le forze dell’ordine nella tutela della sicurezza dei cittadini."
        },
        {
          "code" : "5.4.8.3",
          "display" : "Agenti della polizia di stato e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria fanno rispettare le leggi, proteggono le persone e la proprietà, prevengono e reprimono reati, perlustrano il territorio intervenendo in caso di reati, incidenti e situazioni di pericolo o di emergenza, scortano persone, mezzi di trasporto, valori, svolgono attività investigative su attività criminali e notizie di reato; prevengono, ricercano e denunciano evasioni e violazioni finanziarie, vigilano sull’adempimento delle disposizioni di interesse politico-economico, pattugliano il mare per fini di polizia finanziaria, collaborano nella difesa delle frontiere e svolgono attività di polizia doganale; tutelano l'ambiente, il paesaggio e l'ecosistema, intervengono nelle situazioni di emergenza, nelle catastrofi naturali occupandosi dei soccorsi e di protezione civile, intervengono a difesa del suolo, sorvegliano i parchi nazionali e le riserve naturali dello Stato, controllano il commercio internazionale delle specie animali e vegetali in estinzione, reprimono le frodi in campo agroalimentare e forestale, svolgono compiti di polizia venatoria e di controllo sulla pesca nelle acque interne."
        },
        {
          "code" : "5.4.8.3.1",
          "display" : "Agenti della Polizia di Stato",
          "definition" : "Le professioni comprese in questa unità fanno rispettare le leggi, proteggono le persone e la proprietà, prevengono e reprimono reati, perlustrano il territorio intervenendo in caso di reati, incidenti e situazioni di pericolo o di emergenza; scortano persone, mezzi di trasporto, valori, svolgono attività investigative su attività criminali e notizie di reato."
        },
        {
          "code" : "5.4.8.3.2",
          "display" : "Agenti della Guardia di Finanza",
          "definition" : "Le professioni comprese in questa unità prevengono, ricercano e denunciano evasioni e violazioni finanziarie; vigilano sull’adempimento delle disposizioni di interesse politico-economico, pattugliano il mare per fini di polizia finanziaria, collaborano nella difesa delle frontiere e svolgono attività di polizia doganale."
        },
        {
          "code" : "5.4.8.3.3",
          "display" : "Agenti del Corpo Forestale",
          "definition" : "Le professioni comprese in questa unità tutelano l'ambiente, il paesaggio e l'ecosistema, intervengono nelle situazioni di emergenza, nelle catastrofi naturali occupandosi dei soccorsi e di protezione civile, intervengono a difesa del suolo, sorvegliano i parchi nazionali e le riserve naturali dello Stato, controllano il commercio internazionale delle specie animali e vegetali in estinzione, reprimono le frodi in campo agroalimentare e forestale, svolgono compiti di polizia venatoria e di controllo sulla pesca nelle acque interne."
        },
        {
          "code" : "5.4.8.4",
          "display" : "Vigili del fuoco e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria prevengono, controllano ed estinguono gli incendi, intervengono nelle situazioni di emergenza quando sono in pericolo la vita, la proprietà o l'ambiente, intervengono in caso di calamità naturali, incidenti, verificano la rispondenza di impianti ed attrezzature alle norme antincendio e di sicurezza; esercitano la vigilanza antincendio in boschi, impianti e locali pubblici."
        },
        {
          "code" : "5.4.8.4.1",
          "display" : "Vigili del fuoco",
          "definition" : "Le professioni comprese in questa unità prevengono, controllano ed estinguono gli incendi; intervengono nelle situazioni di emergenza quando sono in pericolo la vita, la proprietà o l'ambiente; intervengono in caso di calamità naturali, incidenti; verificano la rispondenza di impianti ed attrezzature alle norme antincendio e di sicurezza."
        },
        {
          "code" : "5.4.8.4.2",
          "display" : "Personale delle squadre antincendio",
          "definition" : "Le professioni comprese in questa unità esercitano la vigilanza antincendio in boschi, impianti e locali pubblici."
        },
        {
          "code" : "5.4.8.5",
          "display" : "Agenti di istituti di pena e rieducazione",
          "definition" : "Le professioni comprese in questa categoria sorvegliano i detenuti all’interno degli istituti di pena e di rieducazione, durante il trasferimento tra gli istituti di pena, tra questi e il tribunale o altri luoghi, in conformità con i regolamenti e con le procedure stabilite."
        },
        {
          "code" : "5.4.8.5.0",
          "display" : "Agenti di istituti di pena e rieducazione",
          "definition" : "Le professioni comprese in questa unità sorvegliano i detenuti all’interno degli istituti di pena e di rieducazione, durante il trasferimento tra gli istituti di pena, tra questi e il tribunale o altri luoghi, in conformità con i regolamenti e con le procedure stabilite."
        },
        {
          "code" : "5.4.8.6",
          "display" : "Guardie private di sicurezza",
          "definition" : "Le professioni comprese in questa categoria tutelano la proprietà privata e la sicurezza di persone, organizzazioni o imprese; vigilano sulla integrità delle persone e dei beni protetti; prevengono intrusioni ed usi non autorizzati negli edifici."
        },
        {
          "code" : "5.4.8.6.0",
          "display" : "Guardie private di sicurezza",
          "definition" : "Le professioni comprese in questa unità tutelano la proprietà privata e la sicurezza di persone, organizzazioni o imprese; vigilano sulla integrità delle persone e dei beni protetti; prevengono intrusioni ed usi non autorizzati negli edifici."
        },
        {
          "code" : "5.4.8.7",
          "display" : "Bagnini e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria curano la sicurezza dei bagnanti in piscina e su spiaggia, controllano le condizioni del mare e suggeriscono ai bagnanti i comportamenti più opportuni; controllano le persone nell'acqua e intervengono in caso di pericolo o rischio di annegamento; somministrano i primi soccorsi in caso di incidente in acqua. La professione di bagnino può essere regolata da normativa pubblica."
        },
        {
          "code" : "5.4.8.7.0",
          "display" : "Bagnini e professioni assimilate",
          "definition" : "Le professioni comprese in questa unità curano la sicurezza dei bagnanti in piscina e su spiaggia, controllano le condizioni del mare e suggeriscono ai bagnanti i comportamenti più opportuni; controllano le persone nell'acqua e intervengono in caso di pericolo o rischio di annegamento; somministrano i primi soccorsi in caso di incidente in acqua."
        },
        {
          "code" : "5.4.8.8",
          "display" : "Esercenti di garage ed autorimesse",
          "definition" : "Le professioni comprese in questa categoria definiscono, pianificano, implementano e gestiscono – direttamente e senza supporti alle decisioni e all’organizzazione imprenditoriali, anche non specialistici – le strategie e le politiche di conduzione di garage, autorimesse e parcheggi all'aperto; valutano i risultati dell'attività; negoziano con i fornitori e i clienti, programmano e controllano l'uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell'attività lavorativa propria dell'esercizio."
        },
        {
          "code" : "5.4.8.8.0",
          "display" : "Esercenti di garage ed autorimesse",
          "definition" : "Le professioni comprese in questa categoria definiscono, pianificano, implementano e gestiscono le strategie e le politiche di conduzione di garage, autorimesse e parcheggi all'aperto; valutano i risultati dell'attività; negoziano con i fornitori e i clienti, programmano e controllano l'uso efficiente delle risorse; reclutano personale e definiscono i processi di innovazione organizzativa e gestionale. Sono direttamente impegnati nell'attività lavorativa propria dell'esercizio."
        }
      ]
    },
    {
      "code" : "6",
      "display" : "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI",
      "definition" : "Il sesto grande gruppo comprende le professioni che utilizzano l'esperienza e applicano la conoscenza tecnico-pratica dei materiali, degli utensili e dei processi per estrarre o lavorare minerali; per costruire, riparare o manutenere manufatti, oggetti e macchine; per la produzione agricola, venatoria e della pesca; per lavorare e trasformare prodotti alimentari e agricoli destinati al consumo. I loro compiti consistono nell’estrarre materie prime; nel costruire edifici ed altre strutture; nel realizzare, riparare e manutenere vari prodotti anche di artigianato; nel coltivare piante, nell’allevare e nel cacciare animali; nel conservare e nel mettere a produzione le foreste, il mare e le acque interne; nel realizzare prodotti alimentari ed anche nel vendere i beni prodotti ai clienti o nel collocarli sui mercati. Tali attività richiedono in genere conoscenze di base assimilabili a quelle acquisite completando l'obbligo scolastico, o un ciclo breve di istruzione secondaria superiore o, ancora, una qualifica professionale o esperienza lavorativa. Le professioni classificate in questo grande gruppo, esercitate in forma autonoma, possono saltuariamente richiedere la definizione delle scelte relative alla produzione e commercializzazione dei beni o servizi e il coordinamento delle attività di lavoro.",
      "concept" : [
        {
          "code" : "6.1",
          "display" : "Artigiani e operai specializzati dell’ industria estrattiva, dell’edilizia e della manutenzione degli edifici",
          "definition" : "Le professioni comprese in questo gruppo si occupano, utilizzando strumenti, macchine e tecniche diverse, dell’estrazione e della lavorazione di pietre e minerali, della costruzione, della rifinitura e della manutenzione di edifici e di opere pubbliche, nonché del mantenimento del decoro architettonico, della pulizia e dell’igiene delle stesse."
        },
        {
          "code" : "6.1.1",
          "display" : "Brillatori, tagliatori di pietre, coltivatori di saline e professioni assimilate",
          "definition" : "Le professioni comprese in questa classe utilizzano esplosivi per estrarre minerali e pietre in cave e miniere, eseguono lavorazioni sui prodotti estratti, si occupano delle diverse operazioni connesse alla coltivazione delle saline, mettono in sicurezza e attrezzano i siti."
        },
        {
          "code" : "6.1.1.1",
          "display" : "Brillatori (addetti alle esplosioni)",
          "definition" : "Le professioni comprese in questa categoria preparano e innescano esplosivi, ne determinano la quantità e li posizionano nei modi più adeguati a far esplodere la roccia necessaria per creare tunnel e gallerie, ovvero per ricavare i minerali in cave e miniere. Curano le norme di sicurezza legate all'esercizio della loro attività e la stessa conservazione in sicurezza degli esplosivi e degli apparati detonanti."
        },
        {
          "code" : "6.1.1.1.0",
          "display" : "Brillatori e artificieri in cave e miniere",
          "definition" : "Le professioni comprese in questa unità preparano e innescano esplosivi, ne determinano la quantità e li posizionano nei modi più adeguati a far esplodere la roccia necessaria per creare tunnel e gallerie, ovvero per ricavare i minerali in cave e miniere. Curano le norme di sicurezza legate all'esercizio della loro attività e la stessa conservazione in sicurezza degli esplosivi e degli apparati detonanti."
        },
        {
          "code" : "6.1.1.2",
          "display" : "Tagliatori di pietre, scalpellini e marmisti",
          "definition" : "Le professioni comprese in questa categoria eseguono operazioni di prima, seconda lavorazione e finitura di pietre, marmi, ardesie, alabastro ed affini; tagliano, squadrano e sgrossano il materiale in cava, ovvero lo preparano per l’uso e gli danno la forma voluta modellandolo a scalpello, tagliandolo, fresandolo o molandolo, lucidano o bocciardano le singole parti del prodotto; progettano come realizzarle, le montano o le riparano."
        },
        {
          "code" : "6.1.1.2.0",
          "display" : "Tagliatori e levigatori di pietre, scalpellini e marmisti",
          "definition" : "Le professioni comprese in questa unità eseguono operazioni di prima, seconda lavorazione e finitura di pietre, marmi, ardesie, alabastro ed affini; tagliano, squadrano e sgrossano il materiale in cava, ovvero lo preparano per l’uso e gli danno la forma voluta modellandolo a scalpello, tagliandolo, fresandolo o molandolo, lucidano o bocciardano le singole parti del prodotto; progettano come realizzare le parti del prodotto, le montano o le riparano."
        },
        {
          "code" : "6.1.1.3",
          "display" : "Coltivatori di saline",
          "definition" : "Le professioni comprese in questa categoria si occupano delle diverse operazioni connesse all’alimentazione con acqua marina delle saline, procedono alle fasi della loro coltivazione, raccolgono e raffinano il sale prodotto."
        },
        {
          "code" : "6.1.1.3.0",
          "display" : "Coltivatori di saline",
          "definition" : "Le professioni comprese in questa unità si occupano delle diverse operazioni connesse all’alimentazione con acqua marina delle saline, procedono alle fasi della loro coltivazione, raccolgono e raffinano il sale prodotto."
        },
        {
          "code" : "6.1.2",
          "display" : "Artigiani ed operai specializzati addetti alle costruzioni e al mantenimento di strutture edili",
          "definition" : "Le professioni comprese in questa classe si occupano dell’edificazione in muratura o in cemento armato di manufatti edili di vario genere e dimensione, della messa in sicurezza delle strutture e dei cantieri, della costruzione di forme di colata, provvedono ad attrezzare i cantieri, ad armare gallerie, a pavimentare strade, a montare strutture prefabbricate."
        },
        {
          "code" : "6.1.2.1",
          "display" : "Muratori in pietra, mattoni, refrattari",
          "definition" : "Le professioni comprese in questa categoria costruiscono strutture edili in muratura, interpretano e traducono operativamente i disegni e le indicazioni del progettista; scelgono e predispongono gli impasti e le malte adatte ai materiali utilizzati e al tipo di muratura da edificare, sagomano e posano in opera pietre e mattoni e materiali refrattari."
        },
        {
          "code" : "6.1.2.1.0",
          "display" : "Muratori in pietra e mattoni",
          "definition" : "Le professioni comprese in questa unità costruiscono strutture edili in muratura, interpretano e traducono operativamente i disegni e le indicazioni del progettista; scelgono e predispongono gli impasti e le malte adatte ai materiali utilizzati e al tipo di muratura da edificare, sagomano e posano in opera pietre, mattoni e materiali refrattari."
        },
        {
          "code" : "6.1.2.2",
          "display" : "Muratori in cemento armato",
          "definition" : "Le professioni comprese in questa categoria costruiscono strutture edili in cemento armato armando e predisponendo la ferratura delle forme di colata; montano e smontano i casseri e le strutture in cui colare gli impasti; preparano le miscele di sabbie, pietrisco e cemento più adatte, preparano e colano gli impasti di calcestruzzo edificando le strutture progettate."
        },
        {
          "code" : "6.1.2.2.1",
          "display" : "Casseronisti/Cassonisti",
          "definition" : "Le professioni comprese in questa unità armano e predispongono la ferratura delle forme di colata; montano e smontano i casseri e le strutture in cui colare gli impasti."
        },
        {
          "code" : "6.1.2.2.2",
          "display" : "Muratori e formatori in calcestruzzo",
          "definition" : "Le professioni comprese in questa unità preparano le miscele di sabbie, pietrisco e cemento più adatte e colano gli impasti di calcestruzzo edificando le strutture progettate."
        },
        {
          "code" : "6.1.2.3",
          "display" : "Carpentieri e falegnami nell'edilizia (esclusi i parchettisti)",
          "definition" : "Le professioni comprese in questa categoria costruiscono, montano e manutengono i manufatti in legno che fanno da base o da supporto alle operazioni di costruzione di opere edili, quali le armature e le puntellature volte a sorreggere strutture e a contenere le colate in calcestruzzo e cemento o le controforme per particolari murature e colate."
        },
        {
          "code" : "6.1.2.3.0",
          "display" : "Carpentieri e falegnami edili",
          "definition" : "Le professioni comprese in questa unità costruiscono, montano e manutengono i manufatti in legno che fanno da base o da supporto alle operazioni di costruzione di opere edili, quali le armature e le puntellature volte a sorreggere strutture e a contenere le colate in calcestruzzo e cemento o le controforme per particolari murature e colate."
        },
        {
          "code" : "6.1.2.4",
          "display" : "Ponteggiatori",
          "definition" : "Le professioni comprese in questa categoria costruiscono ed installano ponteggi in ferro o in legno per consentire l’accesso alle strutture di edifici in costruzione, l’innalzamento delle strutture murarie e la tinteggiatura, pulizia o manutenzione delle stesse."
        },
        {
          "code" : "6.1.2.4.0",
          "display" : "Ponteggiatori",
          "definition" : "Le professioni comprese in questa unità costruiscono ed installano ponteggi in ferro o in legno per consentire l’accesso alle strutture di edifici in costruzione, l’innalzamento delle strutture murarie e la tinteggiatura, pulizia o manutenzione delle stesse."
        },
        {
          "code" : "6.1.2.5",
          "display" : "Armatori di gallerie, addetti all'armamento ferroviario e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria costruiscono e rinforzano con strutture di sostegno gallerie, cunicoli e piccoli tunnel di comunicazione; preparano le massicciate, posizionano le traversine, posano i binari, montano e manutengono ferrovie e altre strade ferrate."
        },
        {
          "code" : "6.1.2.5.1",
          "display" : "Armatori di gallerie e pozzi",
          "definition" : "Le professioni comprese in questa unità costruiscono e rinforzano con strutture di sostegno gallerie, cunicoli e piccoli tunnel di comunicazione."
        },
        {
          "code" : "6.1.2.5.2",
          "display" : "Armatori di ferrovie",
          "definition" : "Le professioni comprese in questa unità preparano le massicciate, posizionano le traversine, posano i binari, montano e manutengono ferrovie e altre strade ferrate"
        },
        {
          "code" : "6.1.2.6",
          "display" : "Pavimentatori stradali e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria pavimentano strade e altre superfici utilizzando tecniche e materiali diversi; preparano impasti bituminosi per gli asfalti, li posano preparando il substrato, ne verificano l’adesione e li comprimono per raggiungere la giusta compattezza e resistenza alle sollecitazioni; le lastricano con colate di cemento, posando lastre di materiali diversi, selci, ciottoli o altri materiali resistenti all’attrito."
        },
        {
          "code" : "6.1.2.6.1",
          "display" : "Asfaltisti",
          "definition" : "Le professioni comprese in questa unità pavimentano strade e altre superfici utilizzando tecniche e materiali diversi ovvero preparano impasti bituminosi per gli asfalti, li posano preparando il substrato, ne verificano l’adesione e li comprimono per raggiungere la giusta compattezza e resistenza alle sollecitazioni."
        },
        {
          "code" : "6.1.2.6.2",
          "display" : "Lastricatori e pavimentatori stradali",
          "definition" : "Le professioni comprese in questa unità lastricano strade e altre superfici con colate di cemento, posando lastre di materiali diversi, selci, ciottoli o altri materiali resistenti all’attrito."
        },
        {
          "code" : "6.1.2.7",
          "display" : "Montatori di manufatti prefabbricati e di preformati",
          "definition" : "Le professioni comprese in questa categoria edificano manufatti montando e assemblando, su adeguati basamenti e supporti, parti prefabbricate o preformate in cemento armato o in altri materiali usati in edilizia, le saldano fra loro rendendo agibili per gli usi previsti le strutture così costruite."
        },
        {
          "code" : "6.1.2.7.0",
          "display" : "Montatori di manufatti prefabbricati e di preformati",
          "definition" : "Le professioni comprese in questa unità edificano manufatti montando e assemblando, su adeguati basamenti e supporti, parti prefabbricate o preformate in cemento armato o in altri materiali usati in edilizia, le saldano fra loro rendendo agibili per gli usi previsti le strutture così costruite."
        },
        {
          "code" : "6.1.3",
          "display" : "Artigiani ed operai specializzati addetti alle rifiniture delle costruzioni",
          "definition" : "Le professioni comprese in questa classe si occupano della rifinitura delle costruzioni dopo la loro edificazione, posano tetti, pavimenti, intonaci, sistemi di coibentazione, installano impianti idraulici ed elettrici, infissi, vetri e serramenta."
        },
        {
          "code" : "6.1.3.1",
          "display" : "Copritetti e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria si occupano della sistemazione definitiva dei tetti e della relativa manutenzione, rivestono i solai con asfalto, bitume, tegole, legno o altri materiali; installano grondaie e pluviali, ed eseguono lavori di impermeabilizzazione e coibentazione."
        },
        {
          "code" : "6.1.3.1.0",
          "display" : "Copritetti e impermeabilizzatori di solai",
          "definition" : "Le professioni comprese in questa unità si occupano della sistemazione definitiva dei tetti e della relativa manutenzione; rivestono i solai con asfalto, bitume, tegole, legno o altri materiali; installano grondaie e pluviali ed eseguono lavori di impermeabilizzazione e coibentazione."
        },
        {
          "code" : "6.1.3.2",
          "display" : "Pavimentatori e posatori di rivestimenti",
          "definition" : "Le professioni comprese in questa categoria si occupano della rifinitura delle pareti e dei piani di calpestio degli edifici posando e riparando pavimenti e parquet in legno o in altri materiali sintetici, in mosaico, marmo, pietra, ceramica, cotto, vetrocemento o in altri materiali duri; ne eliminano le imperfezioni di posa arrotandoli, lucidandoli e curandone la manutenzione; rivestono le pareti applicando maioliche, marmi, pietre, ceramiche o altri materiali duri da rifinitura e ornamento."
        },
        {
          "code" : "6.1.3.2.1",
          "display" : "Posatori di pavimenti",
          "definition" : "Le professioni comprese in questa unità si occupano della posatura e della riparazione di pavimenti in mosaico, marmo, pietra, ceramica, cotto, vetrocemento o in altri materiali duri."
        },
        {
          "code" : "6.1.3.2.2",
          "display" : "Rifinitori di pavimenti",
          "definition" : "Le professioni comprese in questa unità eliminano le imperfezioni di posa dai pavimenti in mosaico, marmo, pietra, ceramica, cotto, vetrocemento o in altri materiali duri, arrotandoli, lucidandoli e curandone la manutenzione."
        },
        {
          "code" : "6.1.3.2.3",
          "display" : "Piastrellisti e rivestimentisti in pietra e materiali assimilati",
          "definition" : "Le professioni comprese in questa unità rivestono le pareti applicando maioliche, marmi, pietre, ceramiche o altri materiali duri da rifinitura e ornamento"
        },
        {
          "code" : "6.1.3.2.4",
          "display" : "Parchettisti e posatori di pavimenti e rivestimenti sintetici e in legno",
          "definition" : "Le professioni comprese in questa unità posano, lamano, rifiniscono e lucidano pavimenti e parquet in legno o in altri materiali sintetici."
        },
        {
          "code" : "6.1.3.3",
          "display" : "Intonacatori",
          "definition" : "Le professioni comprese in questa categoria preparano le malte, i gessi o altri materiali da rinzaffo e intonacatura, li stendono in uno o più strati sulle pareti grezze del fabbricato rifinendole per agevolarne la pittura o l'applicazione di rivestimenti di altro tipo."
        },
        {
          "code" : "6.1.3.3.0",
          "display" : "Intonacatori",
          "definition" : "Le professioni comprese in questa unità preparano le malte, i gessi o altri materiali da rinzaffo e intonacatura, li stendono in uno o più strati sulle pareti grezze del fabbricato rifinendole per agevolarne la pittura o l'applicazione di rivestimenti di altro tipo."
        },
        {
          "code" : "6.1.3.4",
          "display" : "Installatori di impianti di isolamento e insonorizzazione",
          "definition" : "Le professioni comprese in questa categoria provvedono alla scelta e alla installazione di barriere fisiche, quali pannelli, schiume e resine dotate di proprietà coibentanti e fonoassorbenti, contenute all'interno di opere murarie o a vista, per ridurre gli scambi energetici fra l’interno e l’esterno degli edifici e/o per attenuare la rumorosità ambientale."
        },
        {
          "code" : "6.1.3.4.0",
          "display" : "Installatori di impianti di isolamento e insonorizzazione",
          "definition" : "Le professioni comprese in questa unità provvedono alla scelta e alla installazione di barriere fisiche, quali pannelli, schiume e resine dotate di proprietà coibentanti e fonoassorbenti, contenute all'interno di opere murarie o a vista, per ridurre gli scambi energetici fra l’interno e l’esterno degli edifici e/o per attenuare la rumorosità ambientale."
        },
        {
          "code" : "6.1.3.5",
          "display" : "Vetrai",
          "definition" : "Le professioni comprese in questa categoria provvedono alla scelta, al taglio, alla lavorazione, alla sostituzione e alla installazione di vetri e specchi su porte, finestre, lucernai, vetrine, espositori, facciate di edifici, pareti interne, soffitti, ripiani garantendo la sicurezza delle installazioni, la loro tenuta statica e le condizioni per resistere agli agenti atmosferici e alle sollecitazioni standard per gli usi individuati."
        },
        {
          "code" : "6.1.3.5.0",
          "display" : "Vetrai",
          "definition" : "Le professioni comprese in questa unità provvedono alla scelta, al taglio, alla lavorazione, alla sostituzione e alla installazione di vetri e specchi su porte, finestre, lucernai, vetrine, espositori, facciate di edifici, pareti interne, soffitti, ripiani, garantendo la sicurezza delle installazioni, la loro tenuta statica e le condizioni per resistere agli agenti atmosferici e alle sollecitazioni standard per gli usi individuati."
        },
        {
          "code" : "6.1.3.6",
          "display" : "Idraulici e posatori di tubazioni idrauliche e di gas",
          "definition" : "Le professioni comprese in questa categoria si occupano della costruzione, della messa in opera secondo le norme e della manutenzione degli impianti idraulici e termici nei manufatti edilizi; installano, riparano e manutengono le tubazioni di scarico delle acque reflue e di adduzione di gas e di acqua potabile o sanitaria, calda o fredda, ai servizi di abitazioni o di altre costruzioni civili, ne definiscono e ne regolano la portata considerando le pressioni disponibili e le pendenze da superare, utilizzano i materiali prescritti dalle norme; installano, riparano e manutengono gli impianti di riscaldamento e di condizionamento degli edifici utilizzando le tubature di alimentazione, le superfici e i sistemi radianti, i supporti, le coibentazioni e le apparecchiature prescritti dalle norme."
        },
        {
          "code" : "6.1.3.6.1",
          "display" : "Idraulici nelle costruzioni civili",
          "definition" : "Le professioni comprese in questa unità si occupano della costruzione, della messa in opera secondo le norme e della manutenzione degli impianti idraulici nei manufatti edilizi ovvero installano, riparano e manutengono le tubazioni di scarico delle acque reflue e di adduzione di gas e di acqua potabile o sanitaria, calda o fredda, ai servizi di abitazioni o di altre costruzioni civili, ne definiscono e ne regolano la portata considerando le pressioni disponibili e le pendenze da superare, utilizzano i materiali prescritti dalle norme."
        },
        {
          "code" : "6.1.3.6.2",
          "display" : "Installatori di impianti termici nelle costruzioni civili",
          "definition" : "Le professioni comprese in questa unità installano, riparano e manutengono gli impianti di riscaldamento e di condizionamento degli edifici utilizzando le tubature di alimentazione, le superfici e i sistemi radianti, i supporti, le coibentazioni e le apparecchiature prescritti dalle norme."
        },
        {
          "code" : "6.1.3.7",
          "display" : "Elettricisti nelle costruzioni civili e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria si occupano della installazione, della riparazione e della manutenzione, secondo norma, degli impianti elettrici di edifici adibiti ad usi civili o provvedono all’adattamento di impianti elettrici già esistenti installando linee, interruttori e prese adatti all’assorbimento di energia delle singole apparecchiature previste, sistemi di illuminazione, apparati di sicurezza, linee telefoniche, televisive e di trasmissione dati."
        },
        {
          "code" : "6.1.3.7.0",
          "display" : "Elettricisti ed installatori di impianti elettrici nelle costruzioni civili",
          "definition" : "Le professioni comprese in questa unità si occupano della installazione, della riparazione e della manutenzione, secondo norma, degli impianti elettrici di edifici adibiti ad usi civili o provvedono all’adattamento di impianti elettrici già esistenti installando linee, interruttori e prese adatti all’assorbimento di energia delle singole apparecchiature previste, sistemi di illuminazione, apparati di sicurezza, linee telefoniche, televisive e di trasmissione dati."
        },
        {
          "code" : "6.1.3.8",
          "display" : "Installatori di infissi e serramenta",
          "definition" : "Le professioni comprese in questa categoria installano, riparano e manutengono infissi, avvolgibili, serrande ed altra serramenteria all’ interno o all’esterno degli edifici."
        },
        {
          "code" : "6.1.3.8.0",
          "display" : "Installatori di infissi e serramenti",
          "definition" : "Le professioni comprese in questa unità installano, riparano e manutengono infissi, avvolgibili, serrande ed altra serramenteria all’interno o all’esterno degli edifici."
        },
        {
          "code" : "6.1.4",
          "display" : "Artigiani ed operai specializzati addetti alla pitturazione ed alla pulizia degli esterni degli edifici ed assimilati",
          "definition" : "Le professioni comprese in questa classe provvedono alla finitura delle costruzioni dopo le opere di edificazione e rifinitura, provvedono a dipingere e a decorare le pareti, alla loro manutenzione, a dipingere insegne, cartelli, pannelli ed oggetti simili, a mantenere pulite le facciate degli edifici."
        },
        {
          "code" : "6.1.4.1",
          "display" : "Pittori, stuccatori, laccatori e decoratori",
          "definition" : "Le professioni comprese in questa categoria si occupano della finitura di pareti, superfici o di altri elementi di costruzioni e manufatti edili; pitturano e decorano pareti, impianti, edifici, ponti ed altri manufatti edili; applicano stucchi ornamentali e realizzano decorazioni a stucco; tracciano e realizzano segnaletiche orizzontali di strade o di altre strutture; dipingono insegne, cartelli ed indicazioni."
        },
        {
          "code" : "6.1.4.1.1",
          "display" : "Pittori edili",
          "definition" : "Le professioni comprese in questa unità si occupano della finitura di pareti, superfici o di altri elementi di costruzioni e manufatti edili pitturando pareti, impianti, edifici, ponti ed altri manufatti edili; dipingono insegne, cartelli e indicazioni; tracciano e realizzano segnaletiche orizzontali di strade o di altre strutture."
        },
        {
          "code" : "6.1.4.1.2",
          "display" : "Decoratori e stuccatori edili",
          "definition" : "Le professioni comprese in questa unità si occupano della decorazione di pareti, superfici o di altri elementi di costruzioni e manufatti edili; applicano stucchi ornamentali e realizzano decorazioni a stucco."
        },
        {
          "code" : "6.1.4.2",
          "display" : "Pulitori di facciate",
          "definition" : "Le professioni comprese in questa categoria provvedono alla rimozione dalle facciate degli edifici o di altri manufatti edili di patine e sedimenti depositati nel tempo da agenti atmosferici o di altro tipo, utilizzando tecniche di intervento fisico (scrostatura manuale, lavaggio, acqua o sabbia in pressione, vapore) o chimico (solventi, acidi o altri agenti) e all’eventuale applicazione di materiali protettivi."
        },
        {
          "code" : "6.1.4.2.0",
          "display" : "Pulitori di facciate",
          "definition" : "Le professioni comprese in questa unità provvedono alla rimozione dalle facciate degli edifici o di altri manufatti edili di patine e sedimenti depositati nel tempo da agenti atmosferici o di altro tipo, utilizzando tecniche di intervento fisico (scrostatura manuale, lavaggio, acqua o sabbia in pressione, vapore) o chimico (solventi, acidi o altri agenti) e all’eventuale applicazione di materiali protettivi."
        },
        {
          "code" : "6.1.5",
          "display" : "Artigiani ed operai specializzati addetti alla pulizia ed all’igiene degli edifici",
          "definition" : "Le professioni comprese in questa classe provvedono alle operazioni di pulizia e igenizzazione degli edifici, eseguono interventi di disinfestazione e operazioni di costruzione, riparazione e manutenzione degli impianti fognari."
        },
        {
          "code" : "6.1.5.1",
          "display" : "Operai addetti ai servizi di igiene e pulizia",
          "definition" : "Le professioni comprese in questa categoria svolgono attività di igienizzazione su vasta scala degli ambienti interni ed esterni di edifici e di altri manufatti edili, in genere con l'ausilio di macchinari, tecniche e materiali specifici; ne eseguono la pulizia straordinaria; la disinfezione e la disinfestazione da parassiti, roditori o da altri animali."
        },
        {
          "code" : "6.1.5.1.0",
          "display" : "Operai addetti ai servizi di igiene e pulizia",
          "definition" : "Le professioni comprese in questa unità svolgono attività di igienizzazione su vasta scala degli ambienti interni ed esterni di edifici e di altri manufatti edili, in genere con l'ausilio di macchinari, tecniche e materiali specifici; ne eseguono la pulizia straordinaria; la disinfezione e la disinfestazione da parassiti, roditori o da altri animali."
        },
        {
          "code" : "6.1.5.2",
          "display" : "Operai addetti alla manutenzione degli impianti fognari e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria svolgono costruiscono, riparano e si occupano della manutenzione degli impianti fognari di edifici civili o di altri manufatti edili."
        },
        {
          "code" : "6.1.5.2.0",
          "display" : "Operai addetti alla manutenzione degli impianti fognari",
          "definition" : "Le professioni comprese in questa unità costruiscono, riparano e si occupano della manutenzione degli impianti fognari di edifici civili o di altri manufatti edili."
        },
        {
          "code" : "6.2",
          "display" : "Artigiani ed operai metalmeccanici specializzati e installatori e manutentori di attrezzature elettriche ed elettroniche",
          "definition" : "Le professioni comprese in questo gruppo si occupano della lavorazione del metallo, della fusione, della trasformazione in lingotti e lamiere, delle successive lavorazioni nelle parti che costituiranno il prodotto finito, costruiscono, riparano e manutengono macchine o parti di macchine meccaniche, elettriche ed elettroniche."
        },
        {
          "code" : "6.2.1",
          "display" : "Fonditori, saldatori, lattonieri, calderai, montatori di carpenteria metallica e professioni assimilate",
          "definition" : "Le professioni comprese in questa classe si occupano della lavorazione di base dei metalli, li fondono e realizzano le forme per la colata; tagliano e saldano parti in metallo, costruiscono, formano e riparano oggetti e parti in lamiera, montano carpenteria e cavi metallici, costruiscono, manutengono e riparano manufatti metallici subacquei."
        },
        {
          "code" : "6.2.1.1",
          "display" : "Fonditori e animisti di fonderia",
          "definition" : "Le professioni comprese in questa categoria si occupano della prima lavorazione dei metalli; fondono i metalli utilizzando appositi forni e crogioli; predispongono le forme entro cui colare il metallo fuso, colano, raffreddano ed estraggono il manufatto così realizzato."
        },
        {
          "code" : "6.2.1.1.1",
          "display" : "Fonditori",
          "definition" : "Le professioni comprese in questa unità si occupano della prima lavorazione dei metalli ovvero fondono i metalli utilizzando appositi forni e crogioli."
        },
        {
          "code" : "6.2.1.1.2",
          "display" : "Formatori e animisti",
          "definition" : "Le professioni comprese in questa unità si occupano della prima lavorazione dei metalli ovvero predispongono le forme entro cui colare il metallo fuso, colano, raffreddano ed estraggono il manufatto così realizzato."
        },
        {
          "code" : "6.2.1.2",
          "display" : "Saldatori e tagliatori a fiamma",
          "definition" : "Le professioni comprese in questa categoria eseguono, con cannelli a combustione controllata di gas, saldature di parti in metallo, tagliando parti di spessore e dimensioni diverse."
        },
        {
          "code" : "6.2.1.2.0",
          "display" : "Saldatori e tagliatori a fiamma",
          "definition" : "Le professioni comprese in questa unità eseguono, con cannelli a combustione controllata di gas, saldature di parti in metallo, tagliando parti di spessore e dimensioni diverse."
        },
        {
          "code" : "6.2.1.3",
          "display" : "Lattonieri e calderai, compresi i tracciatori",
          "definition" : "Le professioni comprese in questa categoria si occupano della lavorazione della lamiera sottile ovvero creano manualmente manufatti e oggetti di lattoneria, di forma anche complessa, asportando e deformando, a freddo o a caldo, la lamiera; incidono o tracciano le linee che delimitano il materiale da asportare e i punti dove intervenire per formare, con lavorazioni successive, il manufatto progettato."
        },
        {
          "code" : "6.2.1.3.1",
          "display" : "Lattonieri e calderai",
          "definition" : "Le professioni comprese in questa unità si occupano della lavorazione della lamiera sottile ovvero creano manualmente manufatti e oggetti di lattoneria, di forma anche complessa, asportando e deformando, a freddo o a caldo, la lamiera."
        },
        {
          "code" : "6.2.1.3.2",
          "display" : "Tracciatori",
          "definition" : "Le professioni comprese in questa unità si occupano della lavorazione della lamiera sottile ovvero incidono o tracciano le linee che delimitano il materiale da asportare e i punti dove intervenire per formare, con lavorazioni successive, il manufatto progettato."
        },
        {
          "code" : "6.2.1.4",
          "display" : "Montatori di carpenteria metallica",
          "definition" : "Le professioni comprese in questa categoria si occupano, in officina o in cantiere della costruzione e dell’assemblaggio di elementi e giunti metallici di strutture portanti, di tubi e di condotte in campo civile, navale, aeronautico e ferroviario."
        },
        {
          "code" : "6.2.1.4.0",
          "display" : "Carpentieri e montatori di carpenteria metallica",
          "definition" : "Le professioni comprese in questa unità si occupano, in officina o in cantiere, della costruzione e dell’assemblaggio di elementi e giunti metallici di strutture portanti, di tubi e di condotte in campo civile, navale, aeronautico e ferroviario."
        },
        {
          "code" : "6.2.1.5",
          "display" : "Attrezzatori e montatori di cavi metallici per uso industriale e di trasporto",
          "definition" : "Le professioni comprese in questa categoria predispongono, posano e montano cavi metallici di sostegno di strutture fisse (ponti sospesi) o semoventi per il trasporto di merci o passeggeri (ascensori, impianti di sollevamento, funivia, ponti levatoi, etc.)."
        },
        {
          "code" : "6.2.1.5.0",
          "display" : "Attrezzatori e montatori di cavi metallici per uso industriale e di trasporto",
          "definition" : "Le professioni comprese in questa unità predispongono, posano e montano cavi metallici di sostegno di strutture fisse (ponti sospesi) o semoventi per il trasporto di merci o passeggeri (ascensori, impianti di sollevamento, funivia, ponti levatoi, etc.)."
        },
        {
          "code" : "6.2.1.6",
          "display" : "Sommozzatori e lavoratori subacquei",
          "definition" : "Le professioni comprese in questa categoria costruiscono, montano, riparano o manutengono strutture e manufatti (metallici) posati al di sotto della superficie del mare."
        },
        {
          "code" : "6.2.1.6.0",
          "display" : "Sommozzatori e lavoratori subacquei",
          "definition" : "Le professioni comprese in questa unità costruiscono, montano, riparano o manutengono strutture e manufatti metallici posati al di sotto della superficie del mare"
        },
        {
          "code" : "6.2.1.7",
          "display" : "Specialisti di saldatura elettrica ed a norme ASME",
          "definition" : "Le professioni comprese in questa categoria si occupano della saldatura elettrica di parti in metallo con strumenti o tecnologie diverse, in officina o in cantiere."
        },
        {
          "code" : "6.2.1.7.0",
          "display" : "Saldatori elettrici e a norme ASME",
          "definition" : "Le professioni comprese in questa unità si occupano della saldatura elettrica di parti in metallo con strumenti o tecnologie diverse, in officina o in cantiere."
        },
        {
          "code" : "6.2.1.8",
          "display" : "Lastroferratori",
          "definition" : "Le professioni comprese in questa categoria lavorano lamiere non sottili ovvero riparano carrozzerie e scocche e le costruiscono artigianalmente; tagliano, piegano e lavorano lamiere, per asportazione e deformazione, per costruire stampi o altri manufatti."
        },
        {
          "code" : "6.2.1.8.1",
          "display" : "Carrozzieri",
          "definition" : "Le professioni comprese in questa unità lavorano lamiere non sottili ovvero riparano carrozzerie e scocche e le costruiscono artigianalmente."
        },
        {
          "code" : "6.2.1.8.2",
          "display" : "Stampatori e piegatori di lamiere",
          "definition" : "Le professioni comprese in questa unità lavorano lamiere non sottili ovvero tagliano, piegano e lavorano lamiere, per asportazione e deformazione, per costruire stampi o altri manufatti."
        },
        {
          "code" : "6.2.2",
          "display" : "Fabbri ferrai costruttori di utensili ed assimilati",
          "definition" : "Le professioni comprese in questa classe costruiscono manufatti, utensili, ed eseguono lavori di precisione utilizzando blocchi e profilati grezzi di metallo che lavorano a caldo o a freddo manualmente o con l’ausilio di macchine non automatiche o semi-automatiche."
        },
        {
          "code" : "6.2.2.1",
          "display" : "Fabbri, lingottai e operatori di presse per forgiare",
          "definition" : "Le professioni comprese in questa categoria lavorano manualmente, anche con l’ausilio di macchine non automatiche o semi-automatiche, lingotti, lamiere e profilati in metallo ovvero realizzano sia singoli manufatti in ferro, bronzo, alluminio, metallo, ottone che manufatti composti da più parti che assemblano; trasformano e modellano a caldo, nei manufatti progettati, lingotti o profilati metallici."
        },
        {
          "code" : "6.2.2.1.1",
          "display" : "Fabbri",
          "definition" : "Le professioni comprese in questa unità lavorano manualmente, anche con l’ausilio di macchine non automatiche o semi-automatiche, lingotti, lamiere e profilati in metallo ovvero realizzano sia singoli manufatti in ferro, bronzo, alluminio, metallo, ottone che manufatti composti da più parti che assemblano."
        },
        {
          "code" : "6.2.2.1.2",
          "display" : "Fucinatori e forgiatori",
          "definition" : "Le professioni comprese in questa unità lavorano manualmente, anche con l’ausilio di macchine non automatiche o semi-automatiche, lingotti, lamiere e profilati in metallo ovvero trasformano e modellano a caldo, nei manufatti progettati, lingotti o profilati metallici."
        },
        {
          "code" : "6.2.2.2",
          "display" : "Costruttori di utensili modellatori e tracciatori meccanici",
          "definition" : "Le professioni comprese in questa categoria costruiscono, manualmente o con l’ausilio di macchine non automatiche o semi-automatiche, utensili e attrezzi, tracciano e modellano i blocchi di metallo per realizzare l’utensile o il manufatto progettato."
        },
        {
          "code" : "6.2.2.2.0",
          "display" : "Costruttori di utensili, modellatori e tracciatori meccanici",
          "definition" : "Le professioni comprese in questa unità costruiscono, manualmente o con l’ausilio di macchine non automatiche o semi-automatiche, utensili e attrezzi, tracciano e modellano i blocchi di metallo per realizzare l’utensile o il manufatto progettato."
        },
        {
          "code" : "6.2.2.3",
          "display" : "Attrezzisti di macchine utensili e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria provvedono alla preparazione di macchine utensili di precisione e alla realizzazione, con tali macchine, del primo pezzo o di manufatti non in serie ovvero provvedono ad attrezzare e a tarare torni, presse, fresatrici con gli utensili necessari al tipo di lavorazione da eseguire; rifiniscono, manualmente o con l’impiego di tali macchine utensili, le superfici, piane o curve, di manufatti in metallo, eseguendo la rettifica di precisione di superfici curve per eliminare imperfezioni o deformazioni delle stesse, portandole alle dimensioni previste; provvedono all’aggiustamento e alla correzione manuale degli utensili da utilizzare ed eventualmente degli stessi manufatti realizzati."
        },
        {
          "code" : "6.2.2.3.1",
          "display" : "Attrezzisti di macchine utensili",
          "definition" : "Le professioni comprese in questa unità provvedono alla preparazione di macchine utensili di precisione e alla realizzazione, con tali macchine, del primo pezzo o di manufatti non in serie ovvero provvedono ad attrezzare e a tarare torni, presse, fresatrici con gli utensili necessari al tipo di lavorazione da eseguire; rifiniscono, manualmente o con l’impiego di tali macchine utensili, le superfici, piane o curve, di manufatti in metallo, eseguendo la rettifica di precisione di superfici curve per eliminare imperfezioni o deformazioni delle stesse, portandole alle dimensioni previste."
        },
        {
          "code" : "6.2.2.3.2",
          "display" : "Aggiustatori meccanici",
          "definition" : "Le professioni comprese in questa unità provvedono all’aggiustamento e alla correzione manuale degli utensili da utilizzare ed eventualmente degli stessi manufatti realizzati."
        },
        {
          "code" : "6.2.3",
          "display" : "Meccanici artigianali, montatori, riparatori e manutentori di macchine fisse e mobili (esclusi gli addetti alle linee di montaggio industriale)",
          "definition" : "Le professioni comprese in questa classe costruiscono artigianalmente, riparano, montano, manutengono e collaudano veicoli e i loro motori, macchinari industriali, macchine frigorifere e apparecchi termici e idraulici."
        },
        {
          "code" : "6.2.3.1",
          "display" : "Meccanici artigianali, riparatori e manutentori di automobili e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria provvedono alla manutenzione dei veicoli a motore e non e di altri congegni meccanici non di uso industriale ovvero identificano e rimuovono le cause di malfunzionamento, riparando i guasti o sostituendo i componenti danneggiati dei motori, dei loro sistemi di alimentazione e di raffreddamento, degli apparati di trasmissione e di guida di veicoli a motore terrestri e di motocicli; riparano e sostituiscono pneumatici equilibrandoli e tarando l’assetto di guida dei veicoli; riparano biciclette e veicoli non a motore e le loro parti."
        },
        {
          "code" : "6.2.3.1.1",
          "display" : "Meccanici motoristi e riparatori di veicoli a motore",
          "definition" : "Le professioni comprese in questa unità provvedono alla manutenzione dei veicoli a motore ovvero identificano e rimuovono le cause di malfunzionamento, riparando i guasti o sostituendo i componenti danneggiati dei motori, dei loro sistemi di alimentazione e di raffreddamento, degli apparati di trasmissione e di guida di veicoli a motore terrestri e di motocicli."
        },
        {
          "code" : "6.2.3.1.2",
          "display" : "Gommisti",
          "definition" : "Le professioni comprese in questa unità riparano e sostituiscono pneumatici, equilibrandoli e tarando l’assetto di guida dei veicoli."
        },
        {
          "code" : "6.2.3.1.3",
          "display" : "Meccanici di biciclette e veicoli assimilati",
          "definition" : "Le professioni comprese in questa unità riparano biciclette e veicoli non a motore e le loro parti."
        },
        {
          "code" : "6.2.3.2",
          "display" : "Meccanici e riparatori di motori di aerei",
          "definition" : "Le professioni comprese in questa categoria svolgono attività sistematiche di controllo e manutenzione delle parti meccaniche e dei motori degli aeromobili, ne diagnosticano i malfunzionamenti, ne identificano e prevengono eventuali cause, definiscono le modalità di intervento nel rispetto delle normative internazionali, sostituiscono le parti non funzionanti con pezzi di ricambio o intervengono con specifiche tecnologie e attrezzature per il loro ripristino."
        },
        {
          "code" : "6.2.3.2.0",
          "display" : "Meccanici, riparatori e manutentori di aerei",
          "definition" : "Le professioni comprese in questa unità svolgono attività sistematiche di controllo e manutenzione delle parti meccaniche e dei motori degli aeromobili, ne diagnosticano i malfunzionamenti, ne identificano e prevengono eventuali cause, definiscono le modalità di intervento nel rispetto delle normative internazionali, sostituiscono le parti non funzionanti con pezzi di ricambio o intervengono con specifiche tecnologie e attrezzature per il loro ripristino."
        },
        {
          "code" : "6.2.3.3",
          "display" : "Meccanici e montatori di macchinari industriali ed assimilati",
          "definition" : "Le professioni comprese in questa categoria si occupano della manutenzione e dell’installazione di macchinari ed impianti industriali ovvero costruiscono artigianalmente, manutengono e riparano, in officina o sugli impianti stessi, macchinari e impianti industriali o le loro parti; montano i loro componenti nei luoghi di installazione partendo da progetti, istruzioni o da altre rappresentazioni, verificano la corrispondenza del contesto ai requisiti richiesti, modificano o adattano eventualmente le parti da montare e collaudano le macchine o gli impianti così realizzati."
        },
        {
          "code" : "6.2.3.3.1",
          "display" : "Riparatori e manutentori di macchinari e impianti industriali",
          "definition" : "Le professioni comprese in questa unità costruiscono artigianalmente, manutengono e riparano, in officina o sugli impianti stessi, macchinari, impianti industriali o le loro parti."
        },
        {
          "code" : "6.2.3.3.2",
          "display" : "Installatori e montatori di macchinari e impianti industriali",
          "definition" : "Le professioni comprese in questa unità montano i componenti di macchinari e impianti industriali nei luoghi di installazione partendo da progetti, istruzioni o da altre rappresentazioni, verificano la corrispondenza del contesto ai requisiti richiesti, modificano o adattano eventualmente le parti da montare e collaudano le macchine o gli impianti così realizzati."
        },
        {
          "code" : "6.2.3.4",
          "display" : "Frigoristi",
          "definition" : "Le professioni comprese in questa categoria installano, manutengono e riparano macchine e impianti frigoriferi ad uso industriale o le loro parti, impianti e sistemi di refrigerazione e di condizionamento e i relativi componenti a bordo di navi o di altri mezzi di trasporto marittimo."
        },
        {
          "code" : "6.2.3.4.1",
          "display" : "Frigoristi industriali",
          "definition" : "Le professioni comprese in questa unità installano, manutengono e riparano macchine e impianti frigoriferi ad uso industriale o le loro parti."
        },
        {
          "code" : "6.2.3.4.2",
          "display" : "Frigoristi navali",
          "definition" : "Le professioni comprese in questa unità installano, manutengono e riparano impianti e sistemi di refrigerazione e di condizionamento e i relativi componenti a bordo di navi o di altri mezzi di trasporto marittimo."
        },
        {
          "code" : "6.2.3.5",
          "display" : "Meccanici e montatori di apparecchi industriali termici, idraulici e di condizionamento",
          "definition" : "Le professioni comprese in questa categoria riparano e manutengono in ambito industriale gli impianti e gli apparecchi di riscaldamento e di condizionamento dell’aria, dell’acqua o di altri fluidi; installano e montano le loro parti, verificano i contesti dove impianti e apparati opereranno, individuando gli adattamenti e le installazioni più adeguate, collaudano e verificano le condizioni di operatività dei sistemi installati."
        },
        {
          "code" : "6.2.3.5.1",
          "display" : "Riparatori e manutentori di apparecchi e impianti termoidraulici industriali",
          "definition" : "Le professioni comprese in questa unità riparano e manutengono in ambito industriale gli impianti e gli apparecchi di riscaldamento e di condizionamento dell’aria, dell’acqua o di altri fluidi."
        },
        {
          "code" : "6.2.3.5.2",
          "display" : "Installatori e montatori di apparecchi e impianti termoidraulici industriali",
          "definition" : "Le professioni comprese in questa unità installano e montano in ambito industriale gli impianti e gli apparecchi di riscaldamento e di condizionamento dell’aria, dell’acqua o di altri fluidi e le loro parti, verificano i contesti dove impianti e apparati opereranno individuando gli adattamenti e le installazioni più adeguate; collaudano e verificano le condizioni di operatività dei sistemi installati."
        },
        {
          "code" : "6.2.3.6",
          "display" : "Meccanici collaudatori",
          "definition" : "Le professioni comprese in questa categoria svolgono collaudano e verificando l'effettivo rispetto degli standard fisici e di prestazione progettati di motori, macchine e alti apparati meccanici, attraverso operazioni di misura – manuali o supportate da tecnologie ed attrezzature particolari – sul complesso dell’apparato o sulle sue singole parti, siano esse fisse o in movimento."
        },
        {
          "code" : "6.2.3.6.0",
          "display" : "Meccanici collaudatori",
          "definition" : "Le professioni comprese in questa unità collaudano e verificano l'effettivo rispetto degli standard fisici e di prestazione progettati di motori, macchine e alti apparati meccanici, attraverso operazioni di misura -manuali o supportate da tecnologie ed attrezzature particolari- sul complesso dell’apparato o sulle sue singole parti, siano esse fisse o in movimento."
        },
        {
          "code" : "6.2.3.7",
          "display" : "Verniciatori artigianali ed industriali",
          "definition" : "Le professioni comprese in questa categoria preparano, scegliendo e operando i trattamenti preliminari, superfici metalliche e le verniciano utilizzando tecnologie e attrezzature prevalentemente manuali."
        },
        {
          "code" : "6.2.3.7.0",
          "display" : "Verniciatori artigianali ed industriali",
          "definition" : "Le professioni comprese in questa unità preparano, scegliendo e operando i trattamenti preliminari, superfici metalliche e le verniciano utilizzando tecnologie e attrezzature prevalentemente manuali."
        },
        {
          "code" : "6.2.3.8",
          "display" : "Meccanici e attrezzisti navali",
          "definition" : "Le professioni comprese in questa categoria provvedono alla manutenzione e alla riparazione delle macchine di bordo ovvero riparano, adattano o realizzano, con le macchine utensili disponibili a bordo, parti o pezzi di ricambio dei diversi apparati meccanici; identificano e rimuovono le cause di malfunzionamento, riparando i guasti o sostituendo i componenti danneggiati dei motori, degli apparati di trasmissione del moto e di guida della nave."
        },
        {
          "code" : "6.2.3.8.1",
          "display" : "Attrezzisti navali",
          "definition" : "Le professioni comprese in questa unità provvedono alla manutenzione e alla riparazione delle macchine di bordo ovvero riparano, adattano o realizzano, con le macchine utensili disponibili a bordo, parti o pezzi di ricambio dei diversi apparati meccanici."
        },
        {
          "code" : "6.2.3.8.2",
          "display" : "Meccanici e motoristi navali",
          "definition" : "Le professioni comprese in questa unità provvedono alla manutenzione e alla riparazione delle macchine di bordo ovvero identificano e rimuovono le cause di malfunzionamento, riparando i guasti o sostituendo i componenti danneggiati dei motori, degli apparati di trasmissione del moto e di guida della nave."
        },
        {
          "code" : "6.2.4",
          "display" : "Artigiani e operai specializzati dell’installazione e della manutenzione di attrezzature elettriche ed elettroniche",
          "definition" : "Le professioni comprese in questa classe svolgono attività connesse alla installazione, manutenzione, montaggio e riparazione di apparati e apparecchiature elettriche, elettromeccaniche ed elettroniche, di elettrodotti e altre grandi linee elettriche, di apparecchiature informatiche."
        },
        {
          "code" : "6.2.4.1",
          "display" : "Installatori e riparatori di apparati elettrici ed elettromeccanici",
          "definition" : "Le professioni comprese in questa categoria, considerando disegni o altre rappresentazioni schematiche installano, riparano, sostituiscono parti e testano apparati di distribuzione, trasformazione ed utilizzo dell'energia elettrica, ovvero installano, riparano e verificano impianti elettrici industriali o specifici per particolari apparati, cabine e trasformatori elettrici; riparano elettrodomestici o altri apparati e apparecchi elettrici; costruiscono -manualmente o con l’ausilio di attrezzature semi-automatiche- montano, riparano e testano avvolgimenti per bobine, rotori e statori di apparati di trasformazione dell’energia elettrica; installano, riparano e manutengono apparati di produzione e conservazione dell’energia elettrica e i relativi sistemi di controllo e misura; installano, riparano e manutengono gli impianti e gli apparati elettrici degli autoveicoli."
        },
        {
          "code" : "6.2.4.1.1",
          "display" : "Installatori e riparatori di impianti elettrici industriali",
          "definition" : "Le professioni comprese in questa unità, considerando disegni o altre rappresentazioni schematiche installano, riparano e verificano impianti elettrici industriali o specifici per particolari apparati, cabine e trasformatori elettrici."
        },
        {
          "code" : "6.2.4.1.2",
          "display" : "Riparatori di apparecchi elettrici e di elettrodomestici",
          "definition" : "Le professioni comprese in questa unità riparano elettrodomestici o altri apparati e apparecchi elettrici."
        },
        {
          "code" : "6.2.4.1.3",
          "display" : "Elettromeccanici",
          "definition" : "Le professioni comprese in questa unità costruiscono, manualmente o con l’ausilio di attrezzature semi-automatiche, montano, riparano e testano avvolgimenti per bobine, rotori e statori di apparati di trasformazione dell’energia elettrica."
        },
        {
          "code" : "6.2.4.1.4",
          "display" : "Installatori e riparatori di apparati di produzione e conservazione dell'energia elettrica",
          "definition" : "Le professioni comprese in questa unità professionale installano, riparano e manutengono apparati di produzione e conservazione dell’energia elettrica e i relativi sistemi di controllo e misura."
        },
        {
          "code" : "6.2.4.1.5",
          "display" : "Elettrauto",
          "definition" : "Le professioni comprese in questa unità installano, riparano e manutengono gli impianti e gli apparati elettrici ed elettronici degli autoveicoli."
        },
        {
          "code" : "6.2.4.2",
          "display" : "Manutentori e riparatori di apparati elettronici industriali e di misura",
          "definition" : "Le professioni comprese in questa categoria, considerando disegni o altre rappresentazioni schematiche riparano, sostituiscono parti e testano grandi apparati elettronici e strumenti elettronici di misura, agendo in laboratorio o direttamente sui luoghi in cui sono installati."
        },
        {
          "code" : "6.2.4.2.0",
          "display" : "Manutentori e riparatori di apparati elettronici industriali",
          "definition" : "Le professioni comprese in questa unità, considerando disegni o altre rappresentazioni schematiche, riparano, sostituiscono parti e testano grandi apparati elettronici e strumenti elettronici di misura, agendo in laboratorio o direttamente sui luoghi in cui sono installati."
        },
        {
          "code" : "6.2.4.3",
          "display" : "Riparatori di apparecchi radio, televisivi e assimilati",
          "definition" : "Le professioni comprese in questa categoria, considerando disegni o altre rappresentazioni schematiche, riparano, sostituiscono parti e testano apparecchi di ricezione radio-televisiva, agendo in laboratorio o direttamente sui luoghi in cui sono installati."
        },
        {
          "code" : "6.2.4.3.0",
          "display" : "Riparatori di apparecchi radio televisivi",
          "definition" : "Le professioni comprese in questa unità, considerando disegni o altre rappresentazioni schematiche, riparano, sostituiscono parti e testano apparecchi di ricezione radio-televisiva, agendo in laboratorio o direttamente sui luoghi in cui sono installati."
        },
        {
          "code" : "6.2.4.4",
          "display" : "Installatori e riparatori di apparati di telecomunicazione",
          "definition" : "Le professioni comprese in questa categoria considerando disegni o altre rappresentazioni schematiche, installano, riparano, sostituiscono parti e testano apparati telefonici e di telecomunicazione, agendo in laboratorio, in centrali di commutazione, lungo le reti fisiche o direttamente sui luoghi in cui sono installati."
        },
        {
          "code" : "6.2.4.4.0",
          "display" : "Installatori e riparatori di apparati di telecomunicazione",
          "definition" : "Le professioni comprese in questa unità, considerando disegni o altre rappresentazioni schematiche, installano, riparano, sostituiscono parti e testano apparati telefonici e di telecomunicazione, agendo in laboratorio, in centrali di commutazione, lungo le reti fisiche o direttamente sui luoghi in cui sono installati."
        },
        {
          "code" : "6.2.4.5",
          "display" : "Installatori di linee elettriche, riparatori e cavisti",
          "definition" : "Le professioni comprese in questa categoria posano, riparano e manutengono i cavi di elettrodotti e di altre linee aeree e sotterranee di distribuzione di energia elettrica ad alta ed a bassa tensione, ne curano la posa su isolatori o in sedi protette, la loro giunzione fisica e le connessioni con gli apparati di produzione, trasformazione ed utilizzo dell’energia trasportata."
        },
        {
          "code" : "6.2.4.5.0",
          "display" : "Installatori, manutentori e riparatori di linee elettriche, cavisti",
          "definition" : "Le professioni comprese in questa unità posano, riparano e manutengono i cavi di elettrodotti e di altre linee aeree e sotterranee di distribuzione di energia elettrica ad alta e a bassa tensione, ne curano la posa su isolatori o in sedi protette, la loro giunzione fisica e le connessioni con gli apparati di produzione, trasformazione ed utilizzo dell’energia trasportata."
        },
        {
          "code" : "6.2.4.6",
          "display" : "Installatori, manutentori e riparatori di apparecchiature informatiche",
          "definition" : "Le professioni comprese in questa categoria installano, riparano e testano apparecchiature informatiche; installano, manutengono e sostituiscono parti di personal computer e delle loro componenti periferiche."
        },
        {
          "code" : "6.2.4.6.0",
          "display" : "Installatori, manutentori e riparatori di apparecchiature informatiche",
          "definition" : "Le professioni comprese in questa unità installano, riparano e testano apparecchiature informatiche; installano, manutengono e sostituiscono parti di personal computer e delle loro componenti periferiche."
        },
        {
          "code" : "6.3",
          "display" : "Artigiani ed operai specializzati della meccanica di precisione, dell'artigianato artistico, della stampa ed assimilati",
          "definition" : "Le professioni comprese in questo gruppo costruiscono, riparano e tarano strumenti o manufatti di elevata precisione; modellano, realizzano e decorano oggetti in terracotta, vetro, ceramica, legno, tessuto, cuoio e materiali simili; riproducono a stampa su supporti o con tecniche diversi scritti, disegni, od altro materiale documentario."
        },
        {
          "code" : "6.3.1",
          "display" : "Artigiani ed operai specializzati della meccanica di precisione su metalli e materiali assimilati",
          "definition" : "Le professioni comprese in questa classe costruiscono, riparano e tarano strumenti di precisione; protesi per ripristinare funzioni e ridurre disabilità fisiche nell’uomo; strumenti musicali; strumenti ottici, orologi e gioielli."
        },
        {
          "code" : "6.3.1.1",
          "display" : "Meccanici di precisione",
          "definition" : "Le professioni comprese in questa categoria costruiscono, riparano e tarano strumenti e manufatti di precisione ovvero realizzano, anche con l’ausilio di macchine utensili semiautomatiche, montano, controllano e mettono a punto, riparano e sostituiscono parti di manufatti e di strumenti di precisione;"
        },
        {
          "code" : "6.3.1.1.0",
          "display" : "Meccanici di precisione",
          "definition" : "Le professioni comprese in questa unità costruiscono, riparano e tarano strumenti e manufatti di precisione ovvero realizzano, anche con l’ausilio di macchine utensili semiautomatiche, montano, controllano e mettono a punto, riparano e sostituiscono parti di manufatti e di strumenti di precisione."
        },
        {
          "code" : "6.3.1.2",
          "display" : "Meccanici e riparatori di protesi (dentali ed ortopediche)",
          "definition" : "Le professioni comprese in questa categoria realizzano e riparano protesi, ortesi, tutori ortopedici e simili per il ripristino delle funzionalità e la riduzione delle disabilità fisiche nell’uomo rispettando standard medicali e sottoponendo gli apparecchi realizzati a collaudo tecnico."
        },
        {
          "code" : "6.3.1.2.0",
          "display" : "Meccanici e riparatori di protesi, di ortesi, di tutori ortopedici e assimilati",
          "definition" : "Le professioni comprese in questa unità realizzano e riparano protesi, ortesi, tutori ortopedici e simili per il ripristino delle funzionalità e la riduzione delle disabilità fisiche nell’uomo, rispettando standard medicali e sottoponendo gli apparecchi realizzati a collaudo tecnico."
        },
        {
          "code" : "6.3.1.3",
          "display" : "Artigiani ed operai addetti alla costruzione, al montaggio e all'accordatura di strumenti musicali",
          "definition" : "Le professioni comprese in questa categoria accordano strumenti nei laboratori e nei luoghi in cui sono collocati, utilizzando l’apposita strumentazione di paragone e intonandoli anche secondo il tipo di musica da suonare e i gusti dello strumentista; costruiscono artigianalmente, riparano, restaurano e si occupano della manutenzione di strumenti musicali e delle loro parti non elettroniche."
        },
        {
          "code" : "6.3.1.3.1",
          "display" : "Accordatori di strumenti musicali",
          "definition" : "Le professioni comprese in questa unità accordano strumenti nei laboratori e nei luoghi in cui sono collocati, utilizzando l’apposita strumentazione di paragone e intonandoli anche secondo il tipo di musica da suonare e i gusti dello strumentista."
        },
        {
          "code" : "6.3.1.3.2",
          "display" : "Addetti alla costruzione e riparazione di strumenti musicali",
          "definition" : "Le professioni comprese in questa unità costruiscono artigianalmente, riparano, restaurano e si occupano della manutenzione di strumenti musicali e delle loro parti non elettroniche."
        },
        {
          "code" : "6.3.1.4",
          "display" : "Addetti alla costruzione e riparazione di orologi",
          "definition" : "Le professioni comprese in questa categoria costruiscono, riparano e manutengono orologi di vario tipo e dimensione."
        },
        {
          "code" : "6.3.1.4.0",
          "display" : "Addetti alla costruzione e riparazione di orologi",
          "definition" : "Le professioni comprese in questa unità costruiscono, riparano e manutengono orologi di vario tipo e dimensione."
        },
        {
          "code" : "6.3.1.5",
          "display" : "Costruttori di strumenti ottici e lenti",
          "definition" : "Le professioni comprese in questa categoria lavorano il vetro o altri materiali adatti allo scopo per attribuirvi le proprietà richieste dalle lenti, ovvero rifiniscono e formano le lenti così realizzate anche per montarle su occhiali; costruiscono, montano, tarano e riparano apparecchiature ottiche per fini scientifici."
        },
        {
          "code" : "6.3.1.5.1",
          "display" : "Addetti alla produzione di lenti e occhiali",
          "definition" : "Le professioni comprese in questa unità lavorano il vetro o altri materiali adatti allo scopo per attribuirvi le proprietà richieste dalle lenti, ovvero rifiniscono e formano le lenti così realizzate anche per montarle su occhiali."
        },
        {
          "code" : "6.3.1.5.2",
          "display" : "Addetti alla produzione di apparecchi ottici",
          "definition" : "Le professioni comprese in questa unità lavorano il vetro o altri materiali adatti allo scopo per attribuirvi le proprietà richieste dalle lenti ovvero costruiscono, montano, tarano e riparano apparecchiature ottiche per fini scientifici."
        },
        {
          "code" : "6.3.1.6",
          "display" : "Orafi, gioiellieri e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria lavorano, anche artigianalmente, metalli, pietre preziose e materiali simili per produrre oggetti ornamentali ovvero costruiscono artigianalmente e riparano gioielli ed articoli di oreficeria; fondono, trafilano, formano, saldano, puliscono e levigano oro e altri metalli preziosi; tagliano, sfaccettano e levigano pietre preziose secondo modelli adatti ad amplificarne brillantezza e luce; costruiscono artigianalmente articoli di bigiotteria, rosari e articoli simili."
        },
        {
          "code" : "6.3.1.6.1",
          "display" : "Orafi",
          "definition" : "Le professioni comprese in questa unità lavorano, anche artigianalmente, metalli, pietre preziose e materiali simili per produrre oggetti ornamentali ovvero fondono, trafilano, formano, saldano, puliscono e levigano oro e altri metalli preziosi, costruendo artigianalmente e riparando gioielli ed altri articoli di oreficeria."
        },
        {
          "code" : "6.3.1.6.2",
          "display" : "Addetti alla lavorazione di pietre preziose e dure",
          "definition" : "Le professioni comprese in questa unità lavorano, anche artigianalmente, pietre preziose e materiali simili per produrre oggetti ornamentali ovvero tagliano, sfaccettano e levigano pietre preziose secondo modelli adatti ad amplificarne brillantezza e luce."
        },
        {
          "code" : "6.3.1.6.3",
          "display" : "Addetti alla lavorazione di bigiotteria",
          "definition" : "Le professioni comprese in questa unità costruiscono artigianalmente articoli di bigiotteria, rosari e articoli simili."
        },
        {
          "code" : "6.3.2",
          "display" : "Vasai, soffiatori e formatori di vetrerie e professioni assimilate",
          "definition" : "Le professioni comprese in questa classe lavorano e decorano la terracotta, la ceramica e il vetro per realizzare oggetti e manufatti artigianali."
        },
        {
          "code" : "6.3.2.1",
          "display" : "Vasai e professioni assimilate (prodotti in ceramica ed abrasivi)",
          "definition" : "Le professioni comprese in questa categoria realizzano oggetti e manufatti utilizzando come materia prima impasti di terre e altri supporti inorganici lavorati e formati con stampi, torni o altre tecniche e successivamente sottoposti a varie tipologie di trattamenti termici ovvero lavorano e realizzano oggetti in terracotta, in maiolica, paste refrattarie e abrasive; oggetti e manufatti in ceramica e porcellana."
        },
        {
          "code" : "6.3.2.1.1",
          "display" : "Vasai e terracottai",
          "definition" : "Le professioni comprese in questa unità realizzano oggetti e manufatti utilizzando come materia prima impasti di terre e altri supporti inorganici lavorati e formati con stampi, torni o altre tecniche e successivamente sottoposti a varie tipologie di trattamenti termici ovvero lavorano e realizzano oggetti in terracotta, in maiolica, paste refrattarie e abrasive."
        },
        {
          "code" : "6.3.2.1.2",
          "display" : "Ceramisti",
          "definition" : "Le professioni comprese in questa unità realizzano oggetti e manufatti in ceramica e porcellana."
        },
        {
          "code" : "6.3.2.2",
          "display" : "Soffiatori, modellatori, tagliatori, molatori e levigatori di vetro",
          "definition" : "Le professioni comprese in questa categoria lavorano il vetro per produrre oggetti e manufatti di varia natura ovvero fondono e modellano per soffiatura il vetro realizzando oggetti e manufatti di artigianato artistico; tagliano, molano e levigano a freddo e temperano il vetro con l’ausilio di macchine semiautomatiche realizzando vetrerie e manufatti in vetro di vario genere ed uso."
        },
        {
          "code" : "6.3.2.2.1",
          "display" : "Soffiatori e modellatori del vetro",
          "definition" : "Le professioni comprese in questa unità lavorano il vetro per produrre oggetti e manufatti di varia natura ovvero fondono e modellano per soffiatura il vetro, realizzando oggetti e manufatti di artigianato artistico."
        },
        {
          "code" : "6.3.2.2.2",
          "display" : "Tagliatori, molatori e levigatori del vetro",
          "definition" : "Le professioni comprese in questa unità tagliano, molano e levigano a freddo e temperano il vetro con l’ausilio di macchine semiautomatiche, realizzando vetrerie e manufatti in vetro di vario genere ed uso."
        },
        {
          "code" : "6.3.2.3",
          "display" : "Incisori ed acquafortisti su vetro",
          "definition" : "Le professioni comprese in questa categoria incidono il vetro con mezzi meccanici e chimici per realizzare oggetti e manufatti per fini decorativi."
        },
        {
          "code" : "6.3.2.3.0",
          "display" : "Incisori ed acquafortisti su vetro",
          "definition" : "Le professioni comprese in questa unità incidono il vetro con mezzi meccanici e chimici per realizzare oggetti e manufatti per fini decorativi."
        },
        {
          "code" : "6.3.2.4",
          "display" : "Pittori e decoratori su vetro e ceramica",
          "definition" : "Le professioni comprese in questa categoria decorano, argentano, dorano, laccano, smaltano e ritoccano manufatti finiti in vetro e ceramica."
        },
        {
          "code" : "6.3.2.4.0",
          "display" : "Pittori e decoratori su vetro e ceramica",
          "definition" : "Le professioni comprese in questa unità decorano, argentano, dorano, laccano, smaltano e ritoccano manufatti finiti in vetro e ceramica."
        },
        {
          "code" : "6.3.3",
          "display" : "Artigiani delle lavorazioni artistiche del legno, del tessuto e del cuoio e dei materiali assimilati",
          "definition" : "Le professioni comprese in questa classe realizzano manualmente o con macchine semiautomatiche oggetti di artigianato artistico in legno e paste derivate, in tessuto e in cuoio."
        },
        {
          "code" : "6.3.3.1",
          "display" : "Artigiani delle lavorazioni artistiche del legno e di materiali assimilati",
          "definition" : "Le professioni comprese in questa categoria lavorano artigianalmente il legno e i suoi derivati, ovvero intarsiano, incidono e intagliano il legno per realizzare oggetti e manufatti ornamentali o per decorare e impreziosire mobili, porte o altri prodotti in legno; riparano e restaurano mobili e oggetti ornamentali di particolare rifinitura, utilizzando legni pregiati; realizzano, rifiniscono e riparano oggetti e manufatti in cartapesta."
        },
        {
          "code" : "6.3.3.1.1",
          "display" : "Cartapestai",
          "definition" : "Le professioni comprese in questa unità lavorano artigianalmente realizzando, rifinendo e riparando oggetti e manufatti in cartapesta."
        },
        {
          "code" : "6.3.3.1.2",
          "display" : "Incisori e intarsiatori su legno",
          "definition" : "Le professioni comprese in questa unità lavorano artigianalmente il legno e i suoi derivati, ovvero intarsiano, incidono e intagliano il legno per realizzare oggetti e manufatti ornamentali o per decorare e impreziosire mobili, porte o altri prodotti in legno; riparano e restaurano mobili e oggetti ornamentali di particolare rifinitura, utilizzando legni pregiati."
        },
        {
          "code" : "6.3.3.2",
          "display" : "Artigiani delle lavorazioni artistiche a mano di tessili, cuoio e simili",
          "definition" : "Le professioni comprese in questa categoria lavorano artigianalmente tessuto e cuoio, ovvero realizzano manufatti e oggetti di artigianato artistico in tessuto, maglia o in altre fibre tessili; in cuoio, in pelle o materiali simili."
        },
        {
          "code" : "6.3.3.2.1",
          "display" : "Artigiani di prodotti tessili artistici lavorati a mano",
          "definition" : "Le professioni comprese in questa unità lavorano artigianalmente il tessuto ovvero realizzano manufatti e oggetti di artigianato artistico in tessuto, maglia o in altre fibre tessili."
        },
        {
          "code" : "6.3.3.2.2",
          "display" : "Artigiani di prodotti artistici in pelle e cuoio lavorati a mano",
          "definition" : "Le professioni comprese in questa unità lavorano artigianalmente realizzando manufatti e oggetti di artigianato artistico in cuoio, in pelle o materiali simili."
        },
        {
          "code" : "6.3.4",
          "display" : "Artigiani ed operai specializzati delle attività poligrafiche",
          "definition" : "Le professioni comprese in questa classe riproducono a stampa su supporti diversi scritti, disegni o immagini, compongono le pagine e le stampano per impressione con macchine manuali o automatiche per grandi tirature; eseguono riproduzioni per incisione fisica o chimica di lastre metalliche, tessuti, pietre; affastellano, piegano, rilegano e rifilano il materiale stampato, utilizzano tecniche fotografiche e fitochimiche per realizzare le matrici di stampa."
        },
        {
          "code" : "6.3.4.1",
          "display" : "Operatori delle attività poligrafiche di pre-stampa",
          "definition" : "Le professioni comprese in questa categoria si occupano della disposizione manuale con caratteri mobili, meccanica o digitale del testo, delle immagini e di altri segni da riprodurre sul supporto da stampare, definendo dimensioni delle immagini e dei caratteri, spaziature e crenature, allineamenti, interlinee e quant’altro necessario a disporre il tutto in modo ordinato, leggibile e ben organizzato allo sguardo o al tatto."
        },
        {
          "code" : "6.3.4.1.0",
          "display" : "Operatori delle attività poligrafiche di pre-stampa",
          "definition" : "Le professioni comprese in questa unità si occupano della disposizione manuale con caratteri mobili, meccanica o digitale del testo, delle immagini e di altri segni da riprodurre sul supporto da stampare, definendo dimensioni delle immagini e dei caratteri, spaziature e crenature, allineamenti, interlinee e quant’altro necessario a disporre il tutto in modo ordinato, leggibile e ben organizzato allo sguardo o al tatto."
        },
        {
          "code" : "6.3.4.2",
          "display" : "Stampatori offset e alla rotativa",
          "definition" : "Le professioni comprese in questa categoria stampano testi, disegni, immagini ed altro materiale con macchine offset o di altro tipo basate sull’impressione di superfici curve, curano il posizionamento delle matrici, regolano l'inchiostratura, la successione dei supporti da stampare o la continuità della bobina di carta."
        },
        {
          "code" : "6.3.4.2.0",
          "display" : "Stampatori offset e alla rotativa",
          "definition" : "Le professioni comprese in questa unità stampano testi, disegni, immagini ed altro materiale con macchine offset o di altro tipo basate sull’impressione di superfici curve, curano il posizionamento delle matrici, regolano l'inchiostratura, la successione dei supporti da stampare o la continuità della bobina di carta."
        },
        {
          "code" : "6.3.4.3",
          "display" : "Zincografi, stereotipisti ed elettrotipisti",
          "definition" : "Le professioni comprese in questa categoria generano la matrice di stampa utilizzando tecniche di incisione chimica, per calco o fusione del bassorilievo tipografico o per deposito elettrolitico o galvanoplastico."
        },
        {
          "code" : "6.3.4.3.0",
          "display" : "Zincografi, stereotipisti ed elettrotipisti",
          "definition" : "Le professioni comprese in questa unità generano la matrice di stampa utilizzando tecniche di incisione chimica, per calco o fusione del bassorilievo tipografico o per deposito elettrolitico o galvanoplastico."
        },
        {
          "code" : "6.3.4.4",
          "display" : "Artigiani incisori, acquafortisti, serigrafisti e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria applicano tecniche di incisione manuale e chimica per generare tipi diversi di matrici da stampa, ovvero incidono su lastre metalliche protette da vernici asportando rispettivamente le immagini positive e negative con soluzioni chimiche; riportano gli oggetti da riprodurre su seta trattata con soluzioni fotosensibili, su pietre calcaree o su lastre di metallo poroso fissando, in positivo, sul supporto sostanze grasse idrorepellenti e lipofile."
        },
        {
          "code" : "6.3.4.4.1",
          "display" : "Artigiani acquafortisti",
          "definition" : "Le professioni comprese in questa unità applicano tecniche di incisione chimica per generare tipi diversi di matrici da stampa, ovvero incidono su lastre metalliche protette da vernici asportando rispettivamente le immagini positive e negative con soluzioni chimiche."
        },
        {
          "code" : "6.3.4.4.2",
          "display" : "Litografi, serigrafisti e incisori tipografici",
          "definition" : "Le professioni comprese in questa unità applicano tecniche di incisione manuale e chimica per generare tipi diversi di matrici da stampa, ovvero riportano gli oggetti da riprodurre su seta trattata con soluzioni fotosensibili, su pietre calcaree o su lastre di metallo poroso fissando, in positivo, sul supporto sostanze grasse idrorepellenti e lipofile."
        },
        {
          "code" : "6.3.4.5",
          "display" : "Rilegatori e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria assemblano, cuciono, incollano e rifilano i singoli fogli di carta stampata in blocchi e libri applicando copertine o altri tipi di rifiniture."
        },
        {
          "code" : "6.3.4.5.0",
          "display" : "Rilegatori e rifinitori post stampa",
          "definition" : "Le professioni comprese in questa unità assemblano, cuciono, incollano e rifilano i singoli fogli di carta stampata in blocchi e libri applicando copertine o altri tipi di rifiniture."
        },
        {
          "code" : "6.4",
          "display" : "Agricoltori e operai specializzati dell’agricoltura, delle foreste, della zootecnia, della pesca e della caccia",
          "definition" : "Le professioni comprese in questo gruppo coltivano piante e allevano animali pianificando ed eseguendo le operazioni necessarie a rendere produttivi campi, orti, serre e gli stessi allevamenti, curano manutengono e rendono produttivi boschi e foreste, pescano in alto mare, nelle zone costiere e nelle acque interne, allevano pesci e cacciano selvaggina."
        },
        {
          "code" : "6.4.1",
          "display" : "Agricoltori e operai agricoli specializzati",
          "definition" : "Le professioni comprese in questa classe pianificano ed eseguono tutte le operazioni necessarie a coltivare prodotti agricoli destinate al consumo alimentare e non, rendendo produttive colture in pieno campo, coltivazioni legnose, vivai, serre ed orti stabili."
        },
        {
          "code" : "6.4.1.1",
          "display" : "Agricoltori e operai agricoli specializzati di colture in pieno campo",
          "definition" : "Le professioni classificate in questa categoria curano e mettono a produzione colture in pieno campo di cereali, verdure, tabacco, girasole, piante medicinali, fieno ed altre produzioni alimentari o destinate alla trasformazione e alla produzione industriale."
        },
        {
          "code" : "6.4.1.1.0",
          "display" : "Agricoltori e operai agricoli specializzati di colture in pieno campo",
          "definition" : "Le professioni comprese in questa unità curano e mettono a produzione colture in pieno campo di cereali, verdure, tabacco, girasole, piante medicinali, fieno ed altre produzioni alimentari o destinate alla trasformazione e alla produzione industriale."
        },
        {
          "code" : "6.4.1.2",
          "display" : "Agricoltori e operai agricoli specializzati di coltivazioni legnose agrarie (vite, olivo, agrumi e alberi da frutta)",
          "definition" : "Le professioni classificate in questa categoria curano e mettono a produzione viti, alberi da frutta e da legno, olivi ed altre produzioni legnose destinate all’alimentazione o alla trasformazione e alla produzione industriale."
        },
        {
          "code" : "6.4.1.2.0",
          "display" : "Agricoltori e operai agricoli specializzati di coltivazioni legnose agrarie",
          "definition" : "Le professioni comprese in questa unità curano e mettono a produzione viti, alberi da frutta e da legno, olivi ed altre produzioni legnose destinate all’alimentazione o alla trasformazione e alla produzione industriale."
        },
        {
          "code" : "6.4.1.3",
          "display" : "Agricoltori e operai agricoli specializzati di giardini e vivai, di coltivazioni di fiori e piante ornamentali, di ortive protette o di orti stabili",
          "definition" : "Le professioni classificate in questa categoria producono in serre e in tutte le stagioni fiori, piante ornamentali e simili, allevano e selezionano in vivai piante destinate alle coltivazioni agricole; curano l'allestimento di aree verdi, coltivando piante ornamentali e sistemando le aiuole in parchi e giardini; coltivano in serre e in orti stabili o protetti ortaggi e prodotti agricoli fuori stagione destinati al consumo alimentare."
        },
        {
          "code" : "6.4.1.3.1",
          "display" : "Agricoltori e operai agricoli specializzati di giardini e vivai, di coltivazioni di fiori e piante ornamentali",
          "definition" : "Le professioni comprese in questa unità producono in serre e in tutte le stagioni fiori, piante ornamentali e simili, allevano e selezionano in vivai piante destinate alle coltivazioni agricole; curano l'allestimento di aree verdi, coltivando piante ornamentali e sistemando le aiuole in parchi e giardini."
        },
        {
          "code" : "6.4.1.3.2",
          "display" : "Agricoltori e operai agricoli specializzati di coltivazioni ortive in serra, di ortive protette o di orti stabili",
          "definition" : "Le professioni comprese in questa unità coltivano in serre e in orti stabili o protetti ortaggi e prodotti agricoli fuori stagione destinati al consumo alimentare."
        },
        {
          "code" : "6.4.1.4",
          "display" : "Agricoltori e operai agricoli specializzati di colture miste",
          "definition" : "Le professioni classificate in questa categoria curano e mettono a produzione in modo non specialistico o univoco più tipologie di colture (in pieno campo, legnose, vivaistiche, terricole, ortive)."
        },
        {
          "code" : "6.4.1.4.0",
          "display" : "Agricoltori e operai agricoli specializzati di colture miste",
          "definition" : "Le professioni comprese in questa unità curano e mettono a produzione in modo non specialistico o univoco più tipologie di colture (in pieno campo, legnose, vivaistiche, terricole e ortive)."
        },
        {
          "code" : "6.4.2",
          "display" : "Allevatori e operai specializzati della zootecnia",
          "definition" : "Le professioni comprese in questa classe si occupano della cura, della alimentazione e della custodia di animali da allevamento per produrre carne o altri prodotti destinati al consumo alimentare o alla trasformazione e produzione industriale."
        },
        {
          "code" : "6.4.2.1",
          "display" : "Allevatori e operai specializzati degli allevamenti di bovini ed equini",
          "definition" : "Le professioni comprese in questa categoria allevano, per produrre carne, latte o altri prodotti, bovini ed equini mantenendoli in salute, alimentandoli in stalla o al pascolo, custodendoli, programmandone la riproduzione e assistendoli nei parti, occupandosi della manutenzione degli ambienti connessi all’attività produttiva e delle operazioni di mungitura e di trasformazione e conservazione del latte."
        },
        {
          "code" : "6.4.2.1.0",
          "display" : "Allevatori e operai specializzati degli allevamenti di bovini ed equini",
          "definition" : "Le professioni comprese in questa unità allevano, per produrre carne, latte o altri prodotti, bovini ed equini mantenendoli in salute, alimentandoli in stalla o al pascolo, custodendoli, programmandone la riproduzione e assistendoli nei parti, occupandosi della manutenzione degli ambienti connessi all’attività produttiva e delle operazioni di mungitura e di trasformazione e conservazione del latte."
        },
        {
          "code" : "6.4.2.2",
          "display" : "Allevatori e operai specializzati degli allevamenti di ovini e caprini",
          "definition" : "Le professioni comprese in questa categoria allevano, per produrre carne, latte o altri prodotti, ovini e caprini mantenendoli in salute, alimentandoli in stalla o al pascolo, custodendoli, programmandone la riproduzione e assistendoli nei parti, occupandosi della manutenzione degli ambienti connessi all’attività produttiva e delle operazioni di mungitura e di trasformazione e conservazione del latte."
        },
        {
          "code" : "6.4.2.2.0",
          "display" : "Allevatori e operai specializzati degli allevamenti di ovini e caprini",
          "definition" : "Le professioni comprese in questa unità allevano, per produrre carne, latte o altri prodotti, ovini e caprini mantenendoli in salute, alimentandoli in stalla o al pascolo, custodendoli, programmandone la riproduzione e assistendoli nei parti, occupandosi della manutenzione degli ambienti connessi all’attività produttiva e delle operazioni di mungitura e di trasformazione e conservazione del latte."
        },
        {
          "code" : "6.4.2.3",
          "display" : "Allevatori e operai specializzati degli allevamenti di suini",
          "definition" : "Le professioni comprese in questa categoria allevano, per produrre carne o altri prodotti, suini mantenendoli in salute, alimentandoli in stalla o al pascolo, custodendoli, programmandone la riproduzione e assistendoli nei parti, occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.2.3.0",
          "display" : "Allevatori e operai specializzati degli allevamenti di suini",
          "definition" : "Le professioni comprese in questa unità allevano, per produrre carne o altri prodotti, suini mantenendoli in salute, alimentandoli in stalla o al pascolo, custodendoli, programmandone la riproduzione e assistendoli nei parti, occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.2.4",
          "display" : "Allevatori e operai specializzati degli allevamenti avicoli",
          "definition" : "Le professioni comprese in questa categoria allevano, per produrre carne, uova o altri prodotti, avicoli mantenendoli in salute, alimentandoli in luoghi di stabulazione o sull’aia, custodendoli, programmandone la riproduzione e incubando le uova, occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.2.4.0",
          "display" : "Allevatori e operai specializzati degli allevamenti avicoli",
          "definition" : "Le professioni comprese in questa unità allevano, per produrre carne, uova o altri prodotti, avicoli mantenendoli in salute, alimentandoli in luoghi di stabulazione o sull’aia, custodendoli, programmandone la riproduzione e incubando le uova, occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.2.5",
          "display" : "Allevatori e operai specializzati degli allevamenti misti",
          "definition" : "Le professioni comprese in questa categoria allevano, per produrre carne, latte uova o altri prodotti, bestiame misto mantenendolo in salute, alimentandolo nei luoghi di stabulazione o sull’aia, custodendolo, programmandone la riproduzione e assistendoli nei parti o incubando le uova, occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.2.5.0",
          "display" : "Allevatore di bestiame misto",
          "definition" : "Le professioni comprese in questa unità allevano, per produrre carne, latte uova o altri prodotti, bestiame misto mantenendolo in salute, alimentandolo nei luoghi di stabulazione o sull’aia, custodendolo, programmandone la riproduzione e assistendoli nei parti o incubando le uova, occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.2.6",
          "display" : "Allevatori e operai specializzati degli allevamenti di insetti",
          "definition" : "Le professioni comprese in questa categoria allevano insetti per produrre bozzoli da seta, miele o altri prodotti, custodendoli e occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.2.6.0",
          "display" : "Allevatori e operai specializzati degli allevamenti di insetti",
          "definition" : "Le professioni comprese in questa unità allevano insetti per produrre bozzoli da seta, miele o altri prodotti, custodendoli e occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.2.9",
          "display" : "Altri allevatori e operai specializzati della zootecnia",
          "definition" : "Le professioni comprese in questa categoria allevano animali da selvaggina, da pelliccia e altri animali mantenendoli in salute, alimentandoli nei luoghi di stabulazione o sull’aia, custodendoli, programmandone la riproduzione, occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.2.9.0",
          "display" : "Altri allevatori e operai specializzati della zootecnia",
          "definition" : "Le professioni comprese in questa unità allevano animali da selvaggina, da pelliccia e altri animali mantenendoli in salute, alimentandoli nei luoghi di stabulazione o sull’aia, custodendoli, programmandone la riproduzione, occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.3",
          "display" : "Allevatori e agricoltori",
          "definition" : "Le professioni comprese in questa classe curano e mettono a produzione in modo non specialistico o univoco una o più tipologie di coltura e di allevamento."
        },
        {
          "code" : "6.4.3.1",
          "display" : "Allevatori e agricoltori",
          "definition" : "Le professioni comprese in questa categoria curano e mettono a produzione in modo non specialistico o univoco una o più tipologie colturali e di allevamento, seminano, coltivano, raccolgono prodotti agricoli, allevano vari tipi di animali mantenendoli in salute, alimentandoli nei luoghi di stabulazione, custodendoli, programmandone la riproduzione e occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.3.1.0",
          "display" : "Allevatori e agricoltori",
          "definition" : "Le professioni comprese in questa unità curano e mettono a produzione in modo non specialistico o univoco una o più tipologie colturali e di allevamento, seminano, coltivano, raccolgono prodotti agricoli, allevano vari tipi di animali mantenendoli in salute, alimentandoli nei luoghi di stabulazione, custodendoli, programmandone la riproduzione e occupandosi della manutenzione degli ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.4",
          "display" : "Operai forestali specializzati",
          "definition" : "Le professioni comprese in questa classe curano, manutengono, conservano e rendono produttivi macchie, boschi e foreste."
        },
        {
          "code" : "6.4.4.1",
          "display" : "Lavoratori forestali specializzati",
          "definition" : "Le professioni comprese in questa categoria curano, conservano e rendono produttive risorse forestali abbattendo o sfoltendo e cimando alberi e arbusti per manutenere il bosco, produrre legna da ardere e legname per l’industria, eseguendo stoccaggi e prime lavorazioni; ripopolando di alberi, piante e animali selvatici gli ecosistemi boschivi; raccogliendo cortecce, sugheri e resine pregiate."
        },
        {
          "code" : "6.4.4.1.1",
          "display" : "Abbattitori di alberi e rimboschitori",
          "definition" : "Le professioni comprese in questa unità curano, conservano e rendono produttive risorse forestali abbattendo o sfoltendo e cimando alberi e arbusti per manutenere il bosco, produrre legna da ardere e legname per l’industria, eseguendo stoccaggi e prime lavorazioni, ripopolando di alberi, piante e animali selvatici gli ecosistemi boschivi."
        },
        {
          "code" : "6.4.4.1.2",
          "display" : "Sugherai e raccoglitori di resine",
          "definition" : "Le professioni comprese in questa unità curano, conservano e rendono produttive risorse forestali raccogliendo cortecce, sugheri e resine pregiate."
        },
        {
          "code" : "6.4.5",
          "display" : "Pescatori e cacciatori",
          "definition" : "Le professioni comprese in questa classe allevano specie ittiche, le cacciano e le pescano in alto mare, nelle zone costiere e nelle acque interne; cacciano, catturano o abbattono selvaggina da carne e da pelliccia."
        },
        {
          "code" : "6.4.5.1",
          "display" : "Acquacoltori e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria allevano diverse specie ittiche, curandole, mantenendole in salute, alimentandole in bacini interni, marini o lacustri, programmandone la riproduzione, occupandosi della manutenzione, della pulizia e dell’igiene dei luoghi di allevamento e di altri ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.5.1.0",
          "display" : "Acquacoltori",
          "definition" : "Le professioni comprese in questa unità allevano diverse specie ittiche, curandole, mantenendole in salute, alimentandole in bacini interni, marini o lacustri, programmandone la riproduzione, occupandosi della manutenzione, della pulizia e dell’igiene dei luoghi di allevamento e di altri ambienti connessi all’attività produttiva."
        },
        {
          "code" : "6.4.5.2",
          "display" : "Pescatori della pesca costiera ed in acque interne",
          "definition" : "Le professioni comprese in questa categoria si occupano della pesca costiera e in acque interne, svolgono tutte le operazioni relative alla ricerca, l’abbattimento e la cattura di specie ittiche o comunque acquatiche, quali crostacei, molluschi, spugne, telline, destinati all’alimentazione o alla trasformazione industriale."
        },
        {
          "code" : "6.4.5.2.0",
          "display" : "Pescatori della pesca costiera e in acque interne",
          "definition" : "Le professioni comprese in questa unità si occupano della pesca costiera e in acque interne, svolgono tutte le operazioni relative alla ricerca, l’abbattimento e la cattura di specie ittiche o comunque acquatiche, quali crostacei, molluschi, spugne, telline, destinati all’alimentazione o alla trasformazione industriale."
        },
        {
          "code" : "6.4.5.3",
          "display" : "Pescatori d'alto mare",
          "definition" : "Le professioni comprese in questa categoria ricercano, abbattono e catturano in alto mare pesci, molluschi, crostacei, spugne ed altri prodotti acquatici destinati all’alimentazione o alla trasformazione industriale."
        },
        {
          "code" : "6.4.5.3.0",
          "display" : "Pescatori d'alto mare",
          "definition" : "Le professioni comprese in questa unità ricercano, abbattono e catturano in alto mare pesci, molluschi, crostacei, spugne ed altri prodotti acquatici destinati all’alimentazione o alla trasformazione industriale."
        },
        {
          "code" : "6.4.5.4",
          "display" : "Cacciatori",
          "definition" : "Le professioni comprese in questa categoria ricercano, catturano e abbattono selvaggina da carne o da pelliccia nel suo ambiente naturale."
        },
        {
          "code" : "6.4.5.4.0",
          "display" : "Cacciatori",
          "definition" : "Le professioni comprese in questa unità ricercano, catturano e abbattono selvaggina da carne o da pelliccia nel suo ambiente naturale."
        },
        {
          "code" : "6.5",
          "display" : "Artigiani e operai specializzati delle lavorazioni alimentari, del legno, del tessile, dell'abbigliamento, delle pelli, del cuoio e dell'industria dello spettacolo",
          "definition" : "Le professioni comprese in questo gruppo lavorano e trasformano prodotti alimentari e agricoli destinati al consumo, lavorano il legno e costruiscono mobili ed altri manufatti dello stesso materiale; filano e tessono fibre, realizzano capi di abbigliamento in tessuto, pelle e pelliccia, conciano pelli e cuoio e realizzano calzature, complementi di abbigliamento, accessori e altri oggetti in questi e in materiali simili; si occupano della realizzazione e della costruzione delle scene e delle ambientazioni di spettacoli teatrali, di riprese cinematografiche e spettacoli simili."
        },
        {
          "code" : "6.5.1",
          "display" : "Artigiani ed operai specializzati delle lavorazioni alimentari",
          "definition" : "Le professioni comprese in questa classe lavorano artigianalmente carni, pesce, prodotti agricoli e loro derivati per produrre alimenti e bevande destinati al consumo; abbattono animali, tagliano e confezionano carne e pesce freschi e conservati, producono pane e paste, dolciumi, latte, prodotti caseari, li classificano secondo parametri definiti, lavorano e preparano il tabacco."
        },
        {
          "code" : "6.5.1.1",
          "display" : "Macellai, pesciaioli e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria lavorano o conservano carne o pesce freschi da destinare al consumo ovvero macellano gli animali, si occupano della scuoiatura, della pulitura, della sezionatura, del taglio, della pezzatura e dell’eventuale confezionamento e conservazione della carne fresca; tritano, speziano, salano, insaccano e conservano carni suine o di altri animali; puliscono, pezzano, salano, marinano prodotti ittici freschi; lavorano in cottura, affumicatura o con altre tecniche di conservazione carni e pesce da conservare."
        },
        {
          "code" : "6.5.1.1.1",
          "display" : "Macellai e abbattitori di animali",
          "definition" : "Le professioni comprese in questa unità lavorano o conservano carne fresca da destinare al consumo ovvero macellano gli animali, si occupano della scuoiatura, della pulitura, della sezionatura, del taglio, della pezzatura e dell’eventuale confezionamento e conservazione della carne fresca."
        },
        {
          "code" : "6.5.1.1.2",
          "display" : "Norcini",
          "definition" : "Le professioni comprese in questa unità lavorano o conservano carne fresca da destinare al consumo ovvero tritano, speziano, salano, insaccano e conservano carni suine o di altri animali"
        },
        {
          "code" : "6.5.1.1.3",
          "display" : "Pesciaioli",
          "definition" : "Le professioni comprese in questa unità lavorano o conservano pesce fresco ovvero puliscono, pezzano, salano, marinano prodotti ittici freschi."
        },
        {
          "code" : "6.5.1.1.4",
          "display" : "Addetti alla conservazione di carni e pesci",
          "definition" : "Le professioni comprese in questa unità lavorano in cottura, affumicatura o con altre tecniche di conservazione carni e pesce da conservare."
        },
        {
          "code" : "6.5.1.2",
          "display" : "Panettieri e pastai artigianali",
          "definition" : "Le professioni comprese in questa categoria lavorano le farine in prodotti alimentari per produrre pane e paste alimentari ovvero impastano artigianalmente uno o più tipi di farina con o senza lievito e danno all’impasto la forma e la dimensione del pane da infornare e destinare al consumo; impastano uno o più tipi di farine per produrre paste artigianali alimentari fresche ed essiccate, lavorate o meno con uova, anche ripiene, trafilate o lavorate con altre tecniche."
        },
        {
          "code" : "6.5.1.2.1",
          "display" : "Panettieri",
          "definition" : "Le professioni comprese in questa unità lavorano le farine in prodotti alimentari per produrre pane ovvero impastano artigianalmente uno o più tipi di farina con o senza lievito e danno all’impasto la forma e la dimensione del pane da infornare e destinare al consumo."
        },
        {
          "code" : "6.5.1.2.2",
          "display" : "Pastai",
          "definition" : "Le professioni comprese in questa unità impastano uno o più tipi di farine per produrre paste artigianali alimentari fresche ed essiccate, lavorate o meno con uova, anche ripiene, trafilate o lavorate con altre tecniche."
        },
        {
          "code" : "6.5.1.3",
          "display" : "Pasticcieri, gelatai e conservieri artigianali",
          "definition" : "Le professioni comprese in questa categoria producono artigianalmente dolciumi ed altri alimenti, ovvero preparano e cuociono impasti dolci lievitati, creme, lavorano e montano panna, burro, uova e grassi vegetali, lavorano lo zucchero, grassi e polveri di cacao per produrre cioccolato; preparano miscele aromatiche e addensanti per realizzare creme gelato, gelati a base di frutta e granite aromatizzate; gelatinizzano e candiscono frutta ed altri prodotti vegetali, li lavorano e cuociono per produrre marmellate e conserve."
        },
        {
          "code" : "6.5.1.3.1",
          "display" : "Pasticcieri e cioccolatai",
          "definition" : "Le professioni comprese in questa unità producono artigianalmente dolciumi e alimenti dolci, ovvero preparano e cuociono impasti dolci lievitati e creme; lavorano e montano panna, burro, uova e grassi vegetali; lavorano lo zucchero, grassi e polveri di cacao per produrre cioccolato."
        },
        {
          "code" : "6.5.1.3.2",
          "display" : "Gelatai",
          "definition" : "Le professioni comprese in questa unità preparano miscele aromatiche e addensanti per realizzare creme gelato, gelati a base di frutta e granite aromatizzate."
        },
        {
          "code" : "6.5.1.3.3",
          "display" : "Conservieri",
          "definition" : "Le professioni comprese in questa unità gelatinizzano e candiscono frutta ed altri prodotti vegetali, li lavorano e cuociono per produrre marmellate e conserve."
        },
        {
          "code" : "6.5.1.4",
          "display" : "Degustatori e classificatori di prodotti alimentari e di bevande",
          "definition" : "Le professioni comprese in questa categoria selezionano, classificano e valutano le caratteristiche organolettiche di prodotti alimentari e bevande, utilizzando i propri sensi e giudicando secondo standard predefiniti."
        },
        {
          "code" : "6.5.1.4.0",
          "display" : "Degustatori e classificatori di prodotti alimentari e bevande",
          "definition" : "Le professioni comprese in questa unità selezionano, classificano e riconoscono le caratteristiche organolettiche di prodotti alimentari e bevande, utilizzando i propri sensi e giudicando secondo standard predefiniti."
        },
        {
          "code" : "6.5.1.5",
          "display" : "Artigiani ed operai specializzati delle lavorazioni artigianali casearie",
          "definition" : "Le professioni comprese in questa categoria lavorano e trasformano latte di varia provenienza per produrre panna, burro, formaggi freschi e stagionati ed altri prodotti caseari."
        },
        {
          "code" : "6.5.1.5.0",
          "display" : "Artigiani ed operai specializzati delle lavorazioni artigianali casearie",
          "definition" : "Le professioni comprese in questa unità lavorano e trasformano latte di varia provenienza per produrre panna, burro, formaggi freschi e stagionati ed altri prodotti caseari."
        },
        {
          "code" : "6.5.1.6",
          "display" : "Operai della preparazione e della lavorazione delle foglie di tabacco",
          "definition" : "Le professioni comprese in questa categoria scelgono, essiccano, lavorano e trattano, sottoponendole a vari tipi di concia, le foglie di tabacco per produrre sigari, tabacco da masticare e miscele triturate da annusare o fumare in pipe o sigarette."
        },
        {
          "code" : "6.5.1.6.0",
          "display" : "Operai specializzati della preparazione e della lavorazione delle foglie di tabacco",
          "definition" : "Le professioni comprese in questa unità scelgono, essiccano, lavorano e trattano, sottoponendole a vari tipi di concia, le foglie di tabacco per produrre sigari, tabacco da masticare e miscele triturate da annusare o fumare in pipe o sigarette."
        },
        {
          "code" : "6.5.2",
          "display" : "Attrezzisti, operai e artigiani del trattamento del legno ed assimilati",
          "definition" : "Le professioni comprese in questa classe si occupano della stagionatura e della prima lavorazione del legno, della realizzazione di mobili e manufatti in questo materiale e della lavorazione e produzione di oggetti in paglia, rafia, vimini, saggina e materiali simili."
        },
        {
          "code" : "6.5.2.1",
          "display" : "Artigiani ed operai specializzati del trattamento del legno (curvature a vapore, stagionatura artificiale, trattamenti chimici)",
          "definition" : "Le professioni comprese in questa categoria provvedono al primo trattamento del legno ovvero tagliano e pezzano i tronchi tenendo conto dell'uso e del valore del materiale che si intende ottenere, provvedono alla stagionatura, naturale o in forno, del materiale ricavato e ad eventuali trattamenti chimici dello stesso; curvano e sagomano assi e tavole secondo standard predefiniti."
        },
        {
          "code" : "6.5.2.1.1",
          "display" : "Stagionatori ed operai specializzati del primo trattamento del legno",
          "definition" : "Le professioni comprese in questa unità provvedono al primo trattamento del legno ovvero tagliano e pezzano i tronchi tenendo conto dell'uso e del valore del materiale che si intende ottenere, provvedono alla stagionatura, naturale o in forno, del materiale ricavato e ad eventuali trattamenti chimici dello stesso."
        },
        {
          "code" : "6.5.2.1.2",
          "display" : "Curvatori, sagomatori ed operai specializzati della prima lavorazione del legno",
          "definition" : "Le professioni comprese in questa unità curvano e sagomano assi e tavole secondo standard predefiniti."
        },
        {
          "code" : "6.5.2.2",
          "display" : "Falegnami ed attrezzisti di macchine per la lavorazione del legno",
          "definition" : "Le professioni comprese in questa categoria lavorano artigianalmente il legno realizzando infissi, mobili o altri manufatti, ovvero si occupano della sgrossatura e della prima trasformazione delle assi in legno con l’ausilio di macchine utensili manuali o semi automatiche (seghe a nastro e circolari, piallatrici, levigatrici, frese a pantografo); realizzano e riparano infissi, porte finestre e altri serramenti in legno, casse, botti, doghe bauli, carrozze, scheletri, sostegni e simili manufatti di carpenteria in legno; montano e smontano mobili e componenti di arredamento su misura e componibili, in legno ed altri materiali."
        },
        {
          "code" : "6.5.2.2.1",
          "display" : "Attrezzisti di falegnameria",
          "definition" : "Le professioni comprese in questa unità lavorano artigianalmente il legno realizzando infissi, mobili o altri manufatti, ovvero si occupano della sgrossatura e della prima trasformazione delle assi in legno con l’ausilio di macchine utensili manuali o semi automatiche (seghe a nastro e circolari, piallatrici, levigatrici, frese a pantografo)."
        },
        {
          "code" : "6.5.2.2.2",
          "display" : "Falegnami",
          "definition" : "Le professioni comprese in questa unità lavorano artigianalmente il legno realizzando infissi, mobili o altri manufatti, ovvero realizzano e riparano infissi, porte finestre e altri serramenti in legno, casse, botti, doghe, bauli, carrozze, scheletri, sostegni e simili manufatti di carpenteria in legno."
        },
        {
          "code" : "6.5.2.2.3",
          "display" : "Montatori di mobili",
          "definition" : "Le professioni comprese in questa unità montano e smontano mobili e componenti di arredamento su misura e componibili, in legno ed altri materiali"
        },
        {
          "code" : "6.5.2.3",
          "display" : "Impagliatori, cestai, spazzolai, sugherai e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria producono oggetti e manufatti lavorando artigianalmente fibre e materiali da intreccio, canne, sugheri e spugne ovvero trattano vimine, paglia e crine vegetale per realizzare cappelli, cesti, canestri, pennelli, spazzole ed altri oggetti simili; intrecciano fibre di vario genere per produrre corde e reti; lavorano giunchi e canne per realizzare mobili, complementi di arredo o altri tipologie di prodotto; trattano e lavorano il sughero e le spugne per produrre diverse tipologie di oggetti e di complementi ornamentali."
        },
        {
          "code" : "6.5.2.3.1",
          "display" : "Impagliatori e lavoranti in vimini e setole",
          "definition" : "Le professioni comprese in questa unità trattano vimine, paglia e crine vegetale per realizzare cappelli, cesti, canestri, pennelli, spazzole ed altri oggetti simili."
        },
        {
          "code" : "6.5.2.3.2",
          "display" : "Cordai e intrecciatori di fibre",
          "definition" : "Le professioni comprese in questa unità intrecciano fibre di vario genere per produrre corde e reti."
        },
        {
          "code" : "6.5.2.3.3",
          "display" : "Lavoranti in giunco e canna",
          "definition" : "Le professioni comprese in questa unità lavorano giunchi e canne per realizzare mobili, complementi di arredo o altri tipologie di prodotto."
        },
        {
          "code" : "6.5.2.3.4",
          "display" : "Lavoranti in sughero e spugna",
          "definition" : "Le professioni comprese in questa unità trattano e lavorano il sughero e le spugne per produrre diverse tipologie di oggetti e di complementi ornamentali"
        },
        {
          "code" : "6.5.3",
          "display" : "Artigiani ed operai specializzati del tessile e dell'abbigliamento",
          "definition" : "Le professioni comprese in questa classe preparano e tessono fibre di vario genere, confezionano artigianalmente capi e complementi di abbigliamento in tessuti, in pelle e pelliccia, biancheria intima e per la casa; realizzano tende, drappeggi, divani, poltrone e materassi; lavano e puliscono a secco articoli di abbigliamento e di arredamento per le famiglie."
        },
        {
          "code" : "6.5.3.1",
          "display" : "Preparatori di fibre",
          "definition" : "Le professioni comprese in questa categoria provvedono alla prima lavorazione e al primo trattamento, anche chimico, delle fibre vegetali e non, producendo filati di vario genere per la tessitura o altre lavorazioni."
        },
        {
          "code" : "6.5.3.1.0",
          "display" : "Preparatori di fibre",
          "definition" : "Le professioni comprese in questa unità provvedono alla prima lavorazione e al primo trattamento, anche chimico, delle fibre vegetali e non, producendo filati di vario genere per la tessitura o altre lavorazioni."
        },
        {
          "code" : "6.5.3.2",
          "display" : "Tessitori e maglieristi a mano e su telai manuali",
          "definition" : "Le professioni comprese in questa categoria provvedono artigianalmente a tessere filati e maglie e al loro successivo trattamento ovvero realizzano e rifiniscono tessuti, arazzi, tappeti o manufatti simili a mano o con l’ausilio di macchine semiautomatiche; confezionano e rifiniscono artigianalmente capi di maglieria; colorano i tessuti artigianalmente e li sottopongono ad eventuali trattamenti chimici."
        },
        {
          "code" : "6.5.3.2.1",
          "display" : "Tessitori",
          "definition" : "Le professioni comprese in questa unità provvedono artigianalmente a tessere filati e maglie, realizzando e rifinendo tessuti, arazzi, tappeti o manufatti simili a mano o con l’ausilio di macchine semiautomatiche."
        },
        {
          "code" : "6.5.3.2.2",
          "display" : "Maglieristi",
          "definition" : "Le professioni comprese in questa unità confezionano e rifiniscono artigianalmente capi di maglieria."
        },
        {
          "code" : "6.5.3.2.3",
          "display" : "Tintori e addetti al trattamento chimico dei tessuti",
          "definition" : "Le professioni comprese in questa unità colorano i tessuti artigianalmente e li sottopongono ad eventuali trattamenti chimici."
        },
        {
          "code" : "6.5.3.3",
          "display" : "Sarti e tagliatori artigianali, modellisti e cappellai",
          "definition" : "Le professioni comprese in questa categoria realizzano artigianalmente capi e complementi di abbigliamento ovvero riportano su cartamodello i disegni del capo da realizzare dimensionandoli alle misure del cliente o a misure standard; tagliano e confezionano il capo di abbigliamento per intero o nelle sue parti in sartorie semiartigianali; disegnano, tagliano e confezionano l’intero capo su misura del cliente; realizzano cappelli in tessuto, lana o feltro."
        },
        {
          "code" : "6.5.3.3.1",
          "display" : "Modellisti di capi di abbigliamento",
          "definition" : "Le professioni comprese in questa unità riportano su cartamodello i disegni del capo di abbigliamento da realizzare dimensionandoli alle misure del cliente o a misure standard."
        },
        {
          "code" : "6.5.3.3.2",
          "display" : "Tagliatori di capi di abbigliamento",
          "definition" : "Le professioni comprese in questa unità tagliano il capo di abbigliamento per intero o nelle sue parti in sartorie semiartigianali."
        },
        {
          "code" : "6.5.3.3.3",
          "display" : "Confezionatori di capi di abbigliamento",
          "definition" : "Le professioni comprese in questa unità confezionano il capo di abbigliamento per intero o nelle sue parti in sartorie semiartigianali."
        },
        {
          "code" : "6.5.3.3.4",
          "display" : "Sarti",
          "definition" : "Le professioni comprese in questa unità disegnano, tagliano e confezionano l’intero capo di abbigliamento su misura del cliente."
        },
        {
          "code" : "6.5.3.3.5",
          "display" : "Cappellai",
          "definition" : "Le professioni comprese in questa unità realizzano cappelli in tessuto, lana o feltro."
        },
        {
          "code" : "6.5.3.4",
          "display" : "Pellicciai, modellatori di pellicceria e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria realizzano artigianalmente capi e complementi di abbigliamento in pelle o pelliccia ovvero riportano su cartamodello i disegni del capo da realizzare dimensionandoli alle misure del cliente o a misure standard; tagliano e confezionano il capo o il complemento di abbigliamento per intero o nelle sue parti in laboratori semiartigianali; disegnano, tagliano e confezionano l’intero capo su misura del cliente."
        },
        {
          "code" : "6.5.3.4.1",
          "display" : "Modellisti di pellicceria e di capi in pelle",
          "definition" : "Le professioni comprese in questa unità riportano su cartamodello i disegni del capo da realizzare in pelle o pelliccia dimensionandoli alle misure del cliente o a misure standard."
        },
        {
          "code" : "6.5.3.4.2",
          "display" : "Tagliatori di pellicceria e di capi in pelle",
          "definition" : "Le professioni comprese in questa unità tagliano il capo o il complemento di abbigliamento in pelle o pelliccia per intero o nelle sue parti in laboratori semiartigianali."
        },
        {
          "code" : "6.5.3.4.3",
          "display" : "Confezionatori di pellicceria e di capi in pelle",
          "definition" : "Le professioni comprese in questa unità confezionano il capo o il complemento di abbigliamento in pelle o pelliccia per intero o nelle sue parti in laboratori semiartigianali."
        },
        {
          "code" : "6.5.3.4.4",
          "display" : "Pellicciai e sarti in pelle",
          "definition" : "Le professioni comprese in questa unità disegnano, tagliano e confezionano l’intero capo in pelle o pelliccia su misura del cliente."
        },
        {
          "code" : "6.5.3.5",
          "display" : "Biancheristi, ricamatori a mano e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria realizzano artigianalmente capi di biancheria e relative rifiniture ovvero tagliano, cuciono, confezionano, rifiniscono e guarniscono capi di abbigliamento intimo; confezionano biancheria per la casa; realizzano merletti, ricami anche con fili d’oro e argento, fiocchi, nastri, decorazioni con pajettes e grani colorati; producono bottoni di forma e materiali diversi."
        },
        {
          "code" : "6.5.3.5.1",
          "display" : "Confezionatori e rifinitori di biancheria intima",
          "definition" : "Le professioni comprese in questa unità realizzano artigianalmente capi di biancheria e relative rifiniture ovvero tagliano, cuciono, confezionano, rifiniscono e guarniscono capi di abbigliamento intimo."
        },
        {
          "code" : "6.5.3.5.2",
          "display" : "Confezionatori e rifinitori di biancheria per la casa",
          "definition" : "Le professioni comprese in questa unità realizzano artigianalmente biancheria per la casa."
        },
        {
          "code" : "6.5.3.5.3",
          "display" : "Merlettai e ricamatrici a mano",
          "definition" : "Le professioni comprese in questa unità realizzano merletti, ricami, anche con fili d’oro e d'argento, fiocchi, nastri, decorazioni con pajettes e grani colorati."
        },
        {
          "code" : "6.5.3.5.4",
          "display" : "Bottonai",
          "definition" : "Le professioni comprese in questa unità producono bottoni di forma e materiali diversi."
        },
        {
          "code" : "6.5.3.6",
          "display" : "Tappezzieri e materassai",
          "definition" : "Le professioni comprese in questa categoria realizzano ornamenti in tessuto o pelle per interni, poltrone, divani, pouf e oggetti simili in laboratori o industrie semiartigianali secondo standard e linee definite ovvero tagliano, confezionano, montano, riparano e restaurano tende, drappeggi e imbottiture su pareti, porte e finestre, realizzano piccoli complementi di arredo in tessuto; trasferiscono su dime e sagome i disegni degli scheletri, delle imbottiture e dei rivestimenti di poltrone, divani, pouf e simili, dimensionandoli ai manufatti da realizzare; ne realizzano gli scheletri e le imbottiture, ne tagliano i rivestimenti e li confezionano per intero o in parti inserendo le imbottiture; li riparano e li restaurano, su misura e ordinazione del cliente; realizzano materassi e altri manufatti simili, curano il rifacimento di materassi in uso attraverso la cardatura della lana, l'inserimento di molle o altri interventi di manutenzione."
        },
        {
          "code" : "6.5.3.6.1",
          "display" : "Confezionatori di tende e drappeggi",
          "definition" : "Le professioni comprese in questa unità realizzano ornamenti in tessuto o pelle per interni ovvero tagliano, confezionano, montano, riparano e restaurano tende, drappeggi e imbottiture su pareti, porte e finestre; realizzano piccoli complementi di arredo in tessuto."
        },
        {
          "code" : "6.5.3.6.2",
          "display" : "Modellisti di poltrone e divani",
          "definition" : "Le professioni comprese in questa unità trasferiscono su dime e sagome i disegni degli scheletri, delle imbottiture e dei rivestimenti di poltrone, divani, pouf e simili, dimensionandoli ai manufatti da realizzare."
        },
        {
          "code" : "6.5.3.6.3",
          "display" : "Tagliatori di imbottiture e rivestimenti di poltrone e divani",
          "definition" : "Le professioni comprese in questa unità realizzano gli scheletri e le imbottiture di poltrone, divani, pouf e simili, e ne tagliano i rivestimenti in laboratori o industrie semiartigianali secondo standard e linee definite."
        },
        {
          "code" : "6.5.3.6.4",
          "display" : "Confezionatori di poltrone e divani",
          "definition" : "Le professioni comprese in questa unità inseriscono le imbottiture e confezionano per intero o in parti poltrone, divani, pouf e simili, in laboratori o industrie semiartigianali secondo standard e linee definite."
        },
        {
          "code" : "6.5.3.6.5",
          "display" : "Tappezzieri di poltrone, divani e assimilati",
          "definition" : "Le professioni comprese in questa unità riparano e restaurano, in laboratori artigianali, su misura e ordinazione del cliente, poltrone, divani, pouf e oggetti simili."
        },
        {
          "code" : "6.5.3.6.6",
          "display" : "Materassai",
          "definition" : "Le professioni comprese in questa unità realizzano materassi e altri manufatti simili; curano il rifacimento di materassi in uso attraverso la cardatura della lana, l'inserimento di molle o altri interventi di manutenzione."
        },
        {
          "code" : "6.5.3.7",
          "display" : "Artigiani e addetti alle tintolavanderie",
          "definition" : "Le professioni comprese in questa categoria lavano, puliscono a secco e stirano per le famiglie, articoli di abbigliamento, renna, pelle, pellicce, lenzuola, tende, biancheria fine, stuoie e tappeti, modificano o ripristinano il loro colore, identificano le macchie sui tessuti e applicano soluzioni chimiche per rimuoverle."
        },
        {
          "code" : "6.5.3.7.0",
          "display" : "Artigiani e addetti alle tintolavanderie",
          "definition" : "Le professioni comprese in questa unità lavano, puliscono a secco e stirano per le famiglie, articoli di abbigliamento, renna, pelle, pellicce, lenzuola, tende, biancheria fine, stuoie e tappeti; modificano o ripristinano il loro colore, identificano le macchie sui tessuti e applicano soluzioni chimiche per rimuoverle."
        },
        {
          "code" : "6.5.4",
          "display" : "Artigiani ed operai specializzati della lavorazione del cuoio, delle pelli e delle calzature ed assimilati",
          "definition" : "Le professioni comprese in questa classe si occupano della prima lavorazione del cuoio, delle pelli e delle pellicce, producono artigianalmente calzature e altri oggetti in pelle, pelliccia e cuoio."
        },
        {
          "code" : "6.5.4.1",
          "display" : "Conciatori di pelli e di pellicce",
          "definition" : "Le professioni comprese in questa categoria si occupano della prima lavorazione e rifinitura del cuoio, delle pelli e delle pellicce, raschiano, sottopongono a concia, nappano, scamosciano, rifilano e portano a diverso grado di rifinitura i materiali della pelle animale in modo da renderli utilizzabili per confezionare capi e complementi di abbigliamento, accessori di varia utilità, calzature, rivestimenti e altri manufatti in cuoio e pelle."
        },
        {
          "code" : "6.5.4.1.0",
          "display" : "Conciatori di pelli e di pellicce",
          "definition" : "Le professioni comprese in questa unità si occupano della prima lavorazione e rifinitura del cuoio, delle pelli e delle pellicce, raschiano, sottopongono a concia, nappano, scamosciano, rifilano e portano a diverso grado di rifinitura i materiali della pelle animale in modo da renderli utilizzabili per confezionare capi e complementi di abbigliamento, accessori di varia utilità, calzature, rivestimenti e altri manufatti in cuoio e pelle."
        },
        {
          "code" : "6.5.4.2",
          "display" : "Artigiani ed operai specializzati delle calzature ed assimilati",
          "definition" : "Le professioni comprese in questa categoria realizzano artigianalmente prodotti in cuoio, pelle e materiali simili ovvero trasferiscono su dime e sagome i disegni di calzature dimensionandoli ai prodotti da realizzare; tagliano, cuciono, confezionano, rifiniscono e guarniscono calzature, per intero o in parti, secondo modelli e misure standard, in laboratori semi artigianali; riparano, tagliano, cuciono, confezionano, rifiniscono e guarniscono calzature su misura del cliente in laboratori artigianali; realizzano selle, finimenti e altri oggetti in cuoio."
        },
        {
          "code" : "6.5.4.2.1",
          "display" : "Modellisti di calzature",
          "definition" : "Le professioni comprese in questa unità realizzano artigianalmente prodotti in cuoio, pelle e materiali simili, trasferendo su dime e sagome i disegni di calzature e dimensionandoli ai prodotti da realizzare."
        },
        {
          "code" : "6.5.4.2.2",
          "display" : "Tagliatori di calzature",
          "definition" : "Le professioni comprese in questa unità realizzano prodotti in cuoio, pelle e materiali simili, tagliando calzature, per intero o in parti, secondo modelli e misure standard, in laboratori semi artigianali."
        },
        {
          "code" : "6.5.4.2.3",
          "display" : "Confezionatori di calzature",
          "definition" : "Le professioni comprese in questa unità realizzano prodotti in cuoio, pelle e materiali simili, cucendo, confezionando, rifinendo e guarnendo calzature, per intero o in parti, secondo modelli e misure standard, in laboratori semi artigianali."
        },
        {
          "code" : "6.5.4.2.4",
          "display" : "Calzolai, sellai e cuoiai",
          "definition" : "Le professioni comprese in questa unità riparano, tagliano, cuciono, confezionano, rifiniscono e guarniscono calzature su misura del cliente in laboratori artigianali; realizzano artigianalmente selle, finimenti e altri oggetti in cuoio."
        },
        {
          "code" : "6.5.4.3",
          "display" : "Valigiai, borsettieri e professioni assimilate (anche su articoli di similpelle e stoffa)",
          "definition" : "Le professioni comprese in questa categoria realizzano artigianalmente accessori da viaggio e complementi di abbigliamento in pelle o in materiali simili ovvero trasferiscono su dime e sagome i disegni dimensionandoli agli oggetti da realizzare; tagliano, cuciono, rifiniscono e guarniscono valigie ed accessori simili per intero o in parti, secondo misure standard in laboratori semiartigianali; riparano, tagliano, cuciono, rifiniscono e guarniscono valigie ed accessori simili su misura o ordinazione del cliente in laboratori artigianali."
        },
        {
          "code" : "6.5.4.3.1",
          "display" : "Modellisti di pelletteria",
          "definition" : "Le professioni comprese in questa unità realizzano artigianalmente accessori da viaggio e complementi di abbigliamento in pelle o in materiali simili trasferendo su dime e sagome i disegni e dimensionandoli agli oggetti da realizzare."
        },
        {
          "code" : "6.5.4.3.2",
          "display" : "Tagliatori di pelletteria",
          "definition" : "Le professioni comprese in questa unità tagliano valigie ed accessori simili per intero o in parti, secondo misure standard in laboratori semiartigianali"
        },
        {
          "code" : "6.5.4.3.3",
          "display" : "Confezionatori di pelletteria",
          "definition" : "Le professioni comprese in questa unità cuciono, rifiniscono e guarniscono valigie ed accessori simili per intero o in parti, secondo misure standard in laboratori semiartigianali."
        },
        {
          "code" : "6.5.4.3.4",
          "display" : "Pellettieri",
          "definition" : "Le professioni comprese in questa unità riparano, tagliano, cuciono, rifiniscono e guarniscono valigie ed accessori simili su misura o ordinazione del cliente in laboratori artigianali."
        },
        {
          "code" : "6.5.5",
          "display" : "Artigiani ed operai specializzati dell’industria dello spettacolo",
          "definition" : "Le professioni comprese in questa classe realizzano e predispongono le scene, le ambientazioni, i meccanismi che le supportano e le fanno funzionare, di spettacoli teatrali, di riprese cinematografiche e spettacoli simili."
        },
        {
          "code" : "6.5.5.1",
          "display" : "Macchinisti ed attrezzisti di scena",
          "definition" : "Le professioni comprese in questa categoria realizzano, predispongono e alternano le scene e le ambientazioni necessarie allo svolgimento di uno spettacolo o di una ripresa cinematografica, televisiva o di spettacoli simili ovvero si occupano dell’attrezzeria e delle macchine di scena a disposizione di registi, attori e macchinisti, la fanno funzionare, realizzano montano, modificano scene e ambientazioni avvalendosi di pedane mobili, pannelli, botole, carri e macchine simili."
        },
        {
          "code" : "6.5.5.1.0",
          "display" : "Macchinisti ed attrezzisti di scena",
          "definition" : "Le professioni comprese in questa unità realizzano, predispongono e alternano le scene e le ambientazioni necessarie allo svolgimento di uno spettacolo o di una ripresa cinematografica, televisiva o di spettacoli simili ovvero si occupano dell’attrezzeria e delle macchine di scena a disposizione di registi, attori e macchinisti, la fanno funzionare, realizzano, montano e modificano scene e ambientazioni avvalendosi di pedane mobili, pannelli, botole, carri e macchine simili."
        }
      ]
    },
    {
      "code" : "7",
      "display" : "CONDUTTORI DI IMPIANTI, OPERAI DI MACCHINARI FISSI E MOBILI E CONDUCENTI DI VEICOLI",
      "definition" : "Il settimo grande gruppo comprende le professioni che conducono e controllano il corretto funzionamento di macchine industriali e di impianti automatizzati o robotizzati di lavorazione; alimentano impianti di assemblaggio e di lavorazione in serie di prodotti; guidano veicoli, macchinari mobili o di sollevamento. I loro compiti consistono nel far funzionare e nel controllare impianti e macchinari industriali fissi per l’estrazione di materie prime, per la loro trasformazione e per la produzione di beni; nell’assemblare parti e componenti di prodotti; nella guida di veicoli e di macchinari mobili. Tali attività richiedono in genere conoscenze di base assimilabili a quelle acquisite completando l'obbligo scolastico, o una qualifica professionale o esperienza lavorativa.",
      "concept" : [
        {
          "code" : "7.1",
          "display" : "Conduttori di impianti industriali",
          "definition" : "Le professioni comprese in questo gruppo comportano la conduzione di impianti o macchinari industriali automatizzati che operano lungo l’intero processo produttivo o su singole fasi dello stesso nelle attività di estrazione e di trattamento dei minerali, di trasformazione e lavorazione dei metalli, del vetro, della ceramica, del legno e della carta e di produzione di derivati della chimica e del petrolio."
        },
        {
          "code" : "7.1.1",
          "display" : "Conduttori di impianti e macchinari per l'estrazione e il primo trattamento dei minerali",
          "definition" : "Le professioni comprese in questa classe conducono impianti per l’estrazione e la prima lavorazione di minerali ed altri prodotti del sottosuolo, quali petrolio e gas naturali."
        },
        {
          "code" : "7.1.1.1",
          "display" : "Conduttori di macchinari in miniere e cave",
          "definition" : "Le professioni comprese in questa categoria conducono macchinari per asportare, scavare, tagliare, tracciare, sollevare e trasportare minerali, pietra e marmo da miniere e cave a cielo aperto."
        },
        {
          "code" : "7.1.1.1.0",
          "display" : "Conduttori di macchinari in miniere e cave",
          "definition" : "Le professioni comprese in questa unità conducono macchinari per asportare, scavare, tagliare, tracciare, sollevare e trasportare minerali, pietra e marmo da miniere e cave a cielo aperto; rinforzano, puntellano e mettono in sicurezza opere murarie, scavi, ambienti di miniere e di cave, condotti, gallerie e posti di snodo tra gallerie; sono addetti alla manutenzione dei macchinari utilizzati."
        },
        {
          "code" : "7.1.1.2",
          "display" : "Conduttori di impianti per il primo trattamento di minerali e di pietre",
          "definition" : "Le professioni comprese in questa categoria conducono macchine per separare, frantumare, depurare, vagliare, agglomerare e in generale per le operazioni di primo trattamento di minerali e pietra in impianti associati a miniere e cave a cielo aperto."
        },
        {
          "code" : "7.1.1.2.0",
          "display" : "Conduttori di impianti per il primo trattamento di minerali e di pietre",
          "definition" : "Le professioni comprese in questa unità conducono macchine per separare, frantumare, depurare, vagliare, agglomerare e in generale per le operazioni di primo trattamento di minerali e pietra in impianti associati a miniere e cave a cielo aperto."
        },
        {
          "code" : "7.1.1.3",
          "display" : "Trivellatori e sondatori di pozzi petroliferi, di gas naturale, operatori di prospezione e professioni assimilate",
          "definition" : "Le professioni comprese in questa categoria conducono macchine per trivellare e attrezzare all’uso pozzi minerari e per l’estrazione di petrolio, gas naturale e acqua; per sondare il sottosuolo, prelevarne campioni ed effettuare prospezioni geologiche."
        },
        {
          "code" : "7.1.1.3.1",
          "display" : "Trivellatori di pozzi",
          "definition" : "Le professioni comprese in questa unità conducono macchine per trivellare e attrezzare all’uso pozzi minerari e per l’estrazione di petrolio, gas naturale e acqua."
        },
        {
          "code" : "7.1.1.3.2",
          "display" : "Conduttori di sonde e perforatrici da prospezione",
          "definition" : "Le professioni comprese in questa unità conducono macchine per sondare il sottosuolo, prelevarne campioni per le analisi di laboratorio ed effettuare prospezioni geologiche."
        },
        {
          "code" : "7.1.2",
          "display" : "Operatori di impianti per la trasformazione e lavorazione a caldo dei metalli",
          "definition" : "Le professioni comprese in questa classe conducono impianti e macchinari per la produzione e la lavorazione dei metalli; conducono altiforni e forni di prima e seconda fusione, laminatoi, impianti di trafilazione, estrusione e trattamento termico dei metalli ferrosi e non."
        },
        {
          "code" : "7.1.2.1",
          "display" : "Fonditori, operatori di altoforno, di convertitori e di forni di raffinazione (siderurgia)",
          "definition" : "Le professioni comprese in questa categoria conducono macchine e impianti di caricamento e di posizionamento dei minerali e dei rottami nei forni ed altoforni, conducono questi ultimi; conducono gli impianti siderurgici di colata in lingotti, lastre e barre e taglio della ghisa, del ferro e dell’acciaio prodotti."
        },
        {
          "code" : "7.1.2.1.1",
          "display" : "Operatori di altoforno",
          "definition" : "Le professioni comprese in questa unità conducono macchine e impianti di caricamento e di posizionamento dei minerali e dei rottami nei forni e negli altoforni; conducono gli altoforni."
        },
        {
          "code" : "7.1.2.1.2",
          "display" : "Operatori di colata",
          "definition" : "Le professioni comprese in questa unità conducono gli impianti siderurgici di colata in lingotti, lastre, barre e gli impianti di taglio della ghisa, del ferro e dell’acciaio prodotti."
        },
        {
          "code" : "7.1.2.2",
          "display" : "Operatori di forni di seconda fusione, colatori di metalli e leghe e operatori di laminatoi",
          "definition" : "Le professioni comprese in questa categoria conducono macchine e impianti di caricamento del metallo in forni di seconda fusione e conducono questi ultimi; conducono treni ed impianti di laminazione a freddo e a caldo delle colate di ferro e acciaio."
        },
        {
          "code" : "7.1.2.2.1",
          "display" : "Operatori di forni di seconda fusione",
          "definition" : "Le professioni comprese in questa unità conducono macchine e impianti di caricamento del metallo in forni di seconda fusione e conducono questi ultimi."
        },
        {
          "code" : "7.1.2.2.2",
          "display" : "Operatori di laminatoi",
          "definition" : "Le professioni comprese in questa unità conducono treni ed impianti di laminazione a freddo e a caldo delle colate di ferro e acciaio."
        },
        {
          "code" : "7.1.2.3",
          "display" : "Operatori di impianti per il trattamento termico dei metalli",
          "definition" : "Le professioni comprese in questa categoria conducono macchine e impianti, basati su tecnologie diverse, per la tempera, la ricottura e per altri trattamenti termici di metalli e leghe metalliche."
        },
        {
          "code" : "7.1.2.3.0",
          "display" : "Operatori di impianti per il trattamento termico dei metalli",
          "definition" : "Le professioni comprese in questa unità conducono macchine e impianti, basati su tecnologie diverse, per la tempera, la ricottura e per altri trattamenti termici di metalli e leghe metalliche."
        },
        {
          "code" : "7.1.2.4",
          "display" : "Trafilatori ed estrusori di metalli",
          "definition" : "Le professioni comprese in questa categoria conducono macchine e impianti per la produzione a mezzo di deformazione plastica di semilavorati e prodotti finiti in metallo ovvero di macchine e di impianti per la trafilatura di corpi piatti, pieni e cavi e di fili; per l’estrusione diretta e inversa di metalli duttili e la profilatura a caldo o a freddo di metalli ferrosi e non."
        },
        {
          "code" : "7.1.2.4.1",
          "display" : "Conduttori di macchine per la trafila di metalli",
          "definition" : "Le professioni comprese in questa unità conducono macchine e impianti per la produzione, a mezzo di deformazione plastica, di semilavorati e prodotti finiti in metallo ovvero di macchine e di impianti per la trafilatura di corpi piatti, pieni e cavi e di fili."
        },
        {
          "code" : "7.1.2.4.2",
          "display" : "Conduttori di macchine per l’estrusione e la profilatura di metalli",
          "definition" : "Le professioni comprese in questa unità conducono macchine e impianti per l’estrusione diretta e inversa di metalli duttili e la profilatura a caldo o a freddo di metalli ferrosi e non."
        },
        {
          "code" : "7.1.2.5",
          "display" : "Operatori di impianti per la produzione e la raffinazione di metalli non ferrosi",
          "definition" : "Le professioni classificate in questa categoria conducono macchine e impianti per la produzione e la raffinazione di metalli non ferrosi ovvero conducono impianti e macchinari per la riduzione, la alligazione e la raffinazione termica dei minerali e dei metalli non ferrosi nonché per la loro riduzione e raffinazione per elettrolisi e per lisciviazione."
        },
        {
          "code" : "7.1.2.5.1",
          "display" : "Operatori di impianti termici per la produzione di metalli non ferrosi",
          "definition" : "Le professioni comprese in questa unità conducono macchine e impianti per la produzione e la raffinazione di metalli non ferrosi ovvero conducono impianti e macchinari per la riduzione, l'alligazione e la raffinazione termica dei minerali e dei metalli non ferrosi."
        },
        {
          "code" : "7.1.2.5.2",
          "display" : "Operatori di impianti elettrochimici per la produzione di metalli non ferrosi",
          "definition" : "Le professioni comprese in questa unità conducono macchine e impianti per la produzione e la raffinazione di metalli non ferrosi ovvero conducono impianti e macchinari per la loro riduzione e raffinazione per elettrolisi e per lisciviazione."
        },
        {
          "code" : "7.1.3",
          "display" : "Conduttori di forni ed altri impianti per la lavorazione del vetro, della ceramica e di materiali assimilati",
          "definition" : "Le professioni comprese in questa classe conducono impianti e macchinari per la lavorazione di materiali inerti a base di sabbie terre ed argille, impianti e forni per la produzione e la lavorazione del vetro, della ceramica e di materiali simili e di laterizi."
        },
        {
          "code" : "7.1.3.1",
          "display" : "Conduttori di impianti per dosare, miscelare ed impastare materiali per la produzione del vetro, della ceramica e dei laterizi",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per dosare, miscelare e impastare sabbie, minerali, vetro di recupero, terre e argille per la produzione del vetro, di manufatti in terracotta, in ceramica e in laterizio."
        },
        {
          "code" : "7.1.3.1.0",
          "display" : "Conduttori di impianti per dosare, miscelare ed impastare materiali per la produzione del vetro, della ceramica e dei laterizi",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per dosare, miscelare e impastare sabbie, minerali, vetro di recupero, terre e argille per la produzione del vetro, di manufatti in terracotta, in ceramica e in laterizio."
        },
        {
          "code" : "7.1.3.2",
          "display" : "Conduttori di forni e di altri impianti per la lavorazione del vetro",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la produzione e la lavorazione del vetro ovvero impianti e macchinari di caricamento nei forni e fusione di sabbie, di minerali e vetro di recupero necessari alla produzione; impianti e macchinari per la produzione di lastre, per la trafilatura, l’estrusione, il taglio, lo stampaggio, il trattamento termico e la rifinitura del vetro e degli oggetti in vetro prodotti in serie."
        },
        {
          "code" : "7.1.3.2.1",
          "display" : "Conduttori di forni per la produzione del vetro",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la produzione del vetro ovvero impianti e macchinari di caricamento nei forni e fusione di sabbie, di minerali e vetro di recupero necessari alla produzione."
        },
        {
          "code" : "7.1.3.2.2",
          "display" : "Conduttori di impianti per la lavorazione del vetro",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la produzione di lastre, per la trafilatura, l’estrusione, il taglio, lo stampaggio, il trattamento termico e la rifinitura del vetro e degli oggetti in vetro prodotti in serie."
        },
        {
          "code" : "7.1.3.3",
          "display" : "Conduttori di impianti per la formatura di articoli in ceramica e terracotta",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la produzione e la lavorazione di manufatti in ceramica e terracotta ovvero impianti e macchinari per formare, stampare e comprimere i manufatti da realizzare; per essiccare, cuocere e sottoporre ad ulteriori trattamenti termici tali manufatti."
        },
        {
          "code" : "7.1.3.3.1",
          "display" : "Conduttori di impianti per la formatura di articoli in ceramica e terracotta",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la produzione e la lavorazione di manufatti in ceramica e terracotta ovvero impianti e macchinari per formare, stampare e comprimere i manufatti da realizzare."
        },
        {
          "code" : "7.1.3.3.2",
          "display" : "Conduttori di forni per la produzione di articoli in ceramica e terracotta",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la produzione e la lavorazione in serie di manufatti in ceramica e terracotta ovvero per essiccare, cuocere e sottoporre ad ulteriori trattamenti termici tali manufatti."
        },
        {
          "code" : "7.1.3.4",
          "display" : "Conduttori di forni e di altri impianti per la produzione di laterizi, tegole e assimilati",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la produzione e la lavorazione di laterizi e di materiali affini per l’edilizia, ovvero impianti e macchinari per formare, stampare e comprimere i manufatti da realizzare; per essiccare, cuocere e sottoporre ad ulteriori trattamenti termici tali manufatti."
        },
        {
          "code" : "7.1.3.4.1",
          "display" : "Conduttori di impianti per la formatura di laterizi",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la produzione e la lavorazione di laterizi e di materiali affini per l’edilizia, ovvero impianti e macchinari per formare, stampare e comprimere i manufatti da realizzare."
        },
        {
          "code" : "7.1.3.4.2",
          "display" : "Conduttori di forni per la produzione di laterizi",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la produzione e la lavorazione in serie di laterizi e di materiali affini per l’edilizia, ovvero per essiccare, cuocere e sottoporre ad ulteriori trattamenti termici tali manufatti."
        },
        {
          "code" : "7.1.4",
          "display" : "Conduttori di impianti per la trasformazione del legno e la fabbricazione della carta",
          "definition" : "Le professioni comprese in questa classe conducono impianti e macchinari per la produzione di semilavorati in legno e materiali derivati, per la preparazione di paste di cellulosa o derivati dal legno ad uso delle cartiere e per la produzione della carta."
        },
        {
          "code" : "7.1.4.1",
          "display" : "Conduttori di impianti per la fabbricazione in serie di pannelli in legno (compensati, truciolati ed assimilati)",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la produzione in serie di pannelli semilavorati in legno, trucioli e segatura di legno destinati alla produzione industriale; assemblano, impiallacciano e incollano strati incrociati di varie essenze in pannelli compensati o multistrato di vario spessore e qualità; impastano, stendono e pressano trucioli in legno, segature, colle e resine in pannelli di diverso spessore e caratteristiche fisiche."
        },
        {
          "code" : "7.1.4.1.0",
          "display" : "Conduttori di impianti per la fabbricazione in serie di pannelli in legno",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la produzione in serie di pannelli semilavorati in legno, trucioli e segatura di legno destinati alla produzione industriale; assemblano, impiallacciano e incollano strati incrociati di varie essenze in pannelli compensati o multistrato di vario spessore e qualità; impastano, stendono e pressano trucioli in legno, segature, colle e resine in pannelli di diverso spessore e caratteristiche fisiche."
        },
        {
          "code" : "7.1.4.2",
          "display" : "Operatori di impianti per la preparazione della pasta di legno e di altri materiali per cartiera",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la trasformazione di materiali a base di cellulosa in paste di legno e materie prime simili per cartiera; caricano legno, stracci ed altri materiali a base di cellulosa negli impianti di preparazione delle miscele, conducono gli impianti e i reattori chimici per la loro trasformazione in paste di cellulosa e per i trattamenti di affinamento di queste ultime."
        },
        {
          "code" : "7.1.4.2.0",
          "display" : "Operatori di impianti per la preparazione della pasta di legno e di altri materiali per cartiera",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la trasformazione di materiali a base di cellulosa in paste di legno e materie prime simili per cartiera; caricano legno, stracci ed altri materiali a base di cellulosa negli impianti di preparazione delle miscele; conducono gli impianti e i reattori chimici per la loro trasformazione in paste di cellulosa e per i trattamenti di affinamento di queste ultime."
        },
        {
          "code" : "7.1.4.3",
          "display" : "Operatori di impianti per la fabbricazione della carta",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la trasformazione delle paste di cellulosa in carta, per darle la consistenza fisica richiesta e stenderla e trasformarla in carta, per sbiancare quest’ultima, lisciarla, patinarla o filigranarla, avvolgere i fogli in bobine o confezionarli in risme di diversa dimensione."
        },
        {
          "code" : "7.1.4.3.0",
          "display" : "Operatori di impianti per la fabbricazione della carta",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la trasformazione delle paste di cellulosa in carta, per dare loro la consistenza fisica richiesta e stenderle e trasformarle in carta, per sbiancare quest’ultima, lisciarla, patinarla o filigranarla, nonché per avvolgere i fogli in bobine o confezionarli in risme di diversa dimensione."
        },
        {
          "code" : "7.1.5",
          "display" : "Operatori di macchinari e di impianti per la raffinazione del gas e dei prodotti petroliferi, per la chimica di base e la chimica fine e per la fabbricazione di prodotti derivati dalla chimica",
          "definition" : "Le professioni comprese in questa classe conducono impianti e macchinari per la lavorazione dei prodotti petroliferi, per la loro stazzatura e per l’imbottigliamento dei gas derivati dal processo di raffinazione; conducono impianti e macchinari per le fasi di lavorazioni della chimica di base e della chimica fine; conducono e controllano impianti e macchinari per la fabbricazione di prodotti derivati dalla chimica; conducono reattori ed altri impianti e macchinari per la produzione di materie intermedie derivate dalla produzione chimica primaria e secondaria; operano nel rispetto delle disposizioni atte a garantire la sicurezza e la qualità del prodotto e del ciclo produttivo."
        },
        {
          "code" : "7.1.5.1",
          "display" : "Conduttori di impianti per la raffinazione dei prodotti petroliferi",
          "definition" : "Le professioni comprese in questa categoria conducono distillatori, reattori ed altri impianti e macchinari per la lavorazione dei prodotti petroliferi ovvero provvedono alla loro raffinazione alimentando e conducendo distillatori e reattori e stoccando i prodotti derivati; conducono impianti e macchine per la loro stazzatura e per l’imbottigliamento dei gas derivati dal processo di raffinazione."
        },
        {
          "code" : "7.1.5.1.1",
          "display" : "Conduttori di impianti per la raffinazione del gas e dei prodotti petroliferi",
          "definition" : "Le professioni comprese in questa unità conducono distillatori, reattori ed altri impianti e macchinari per la lavorazione dei prodotti petroliferi ovvero provvedono alla loro raffinazione alimentando e conducendo distillatori e reattori e stoccando i prodotti derivati."
        },
        {
          "code" : "7.1.5.1.2",
          "display" : "Conduttori di impianti per la stazzatura di prodotti petroliferi",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchine per la stazzatura e l’imbottigliamento dei gas derivati dal processo di raffinazione dei prodotti petroliferi."
        },
        {
          "code" : "7.1.5.2",
          "display" : "Operatori di macchinari e di impianti per la chimica di base e la chimica fine",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchine per filtrare, depurare liquidi e gas, per separare fanghi e altre componenti solide da fluidi, per separare liquidi e gas di diverse densità per successive lavorazioni e produzioni; conducono distillatori per la produzione di sostanze chimiche di base provvedendo anche all'alimentazione degli impianti e allo stoccaggio delle sostanze prodotte; provvedono alla conduzione e al controllo di reattori e di altri impianti chimici effettuando analisi strumentali standard e agendo attraverso quadri di manovra che riportano in tempo reale lo stato dei parametri fisici e chimici essenziali e che consentono l'azionamento di valvole, pompe, generatori di calore ed altri dispositivi di gestione dei processi chimici e delle condizioni energetiche in cui avvengono."
        },
        {
          "code" : "7.1.5.2.0",
          "display" : "Operatori di macchinari e di impianti per la chimica di base e la chimica fine",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchine per filtrare, depurare liquidi e gas, per separare fanghi e altre componenti solide da fluidi, per separare liquidi e gas di diverse densità per successive lavorazioni e produzioni; conducono distillatori per la produzione di sostanze chimiche di base provvedendo anche all'alimentazione degli impianti e allo stoccaggio delle sostanze prodotte; provvedono alla conduzione e al controllo di reattori e di altri impianti chimici effettuando analisi strumentali standard e agendo attraverso quadri di manovra che riportano in tempo reale lo stato dei parametri fisici e chimici essenziali e che consentono l'azionamento di valvole, pompe, generatori di calore ed altri dispositivi di gestione dei processi chimici e delle condizioni energetiche in cui avvengono."
        },
        {
          "code" : "7.1.5.3",
          "display" : "Operatori di macchinari per la fabbricazione di prodotti derivati dalla chimica",
          "definition" : "Le professioni classificate in questa categoria conducono e controllano impianti e macchinari per la produzione dei farmaci, dei prodotti cosmetici, dei detergenti e dei tensioattivi e dei loro principi attivi, delle miscele con eccipienti, del loro dosaggio e del relativo confezionamento per il consumo finale; conducono impianti e macchinari per la produzione delle miscele e preparati esplosivi, dei loro dosaggi in cariche, per il confezionamento di munizioni, detonatori, candelotti o altri tipi di esplosivi per usi industriali e non; conducono reattori ed altri impianti e macchinari per la produzione di materie intermedie derivate dalla produzione chimica primaria quali soluzioni chimiche decolorate, gas, coke e altri derivati dalla lavorazione del carbone, fertilizzanti, fibre sintetiche derivate dalla lavorazione o estrusione di polimeri, materie e sostanze radioattive e prodotti simili; conducono impianti e macchinari per la fabbricazione di prodotti derivati dalla produzione chimica secondaria quali candele, linoleum, gas alogeni, vernici, adesivi, colle, resine."
        },
        {
          "code" : "7.1.5.3.1",
          "display" : "Operatori di macchinari per la produzione di farmaci",
          "definition" : "Le professioni comprese in questa unità conducono e controllano impianti e macchinari per la fabbricazione di prodotti della chimica fine e delle specialità ovvero conducono e controllano impianti e macchinari per la produzione dei farmaci e dei loro principi attivi, delle miscele con eccipienti, del loro dosaggio e del relativo confezionamento per il consumo finale."
        },
        {
          "code" : "7.1.5.3.2",
          "display" : "Operatori di macchinari per la produzione di prodotti derivati dalla chimica (farmaci esclusi)",
          "definition" : "Le professioni comprese in questa unità conducono e controllano impianti e macchinari per la fabbricazione di prodotti derivati dalla chimica (farmaci esclusi) ovvero conducono e controllano impianti e macchinari per la fabbricazione di prodotti cosmetici, detergenti e tensioattivi, delle miscele con eccipienti, del loro dosaggio e del relativo confezionamento per il consumo finale; per la produzione delle miscele e dei preparati esplosivi, dei loro dosaggi in cariche, per il confezionamento di munizioni, detonatori, candelotti o altri tipi di esplosivi per usi industriali e non; per la fabbricazione di prodotti derivati dalla produzione chimica secondaria quali candele, linoleum, gas alogeni, vernici, adesivi, colle e resine; per la produzione di materie intermedie derivate dalla produzione chimica primaria quali soluzioni chimiche decolorate, gas, coke, altri derivati dalla lavorazione del carbone, fertilizzanti, fibre sintetiche derivate dalla lavorazione o estrusione di polimeri, materie e sostanze radioattive e prodotti simili."
        },
        {
          "code" : "7.1.6",
          "display" : "Conduttori di impianti per la produzione di energia termica e di vapore, per il recupero dei rifiuti e per il trattamento e la distribuzione delle acque",
          "definition" : "Le professioni comprese in questa classe conducono impianti e macchinari per la produzione di energia termica e di vapore, impianti di trattamento dei rifiuti e per il recupero e il riciclaggio degli stessi e impianti per il trattamento e la distribuzione delle acque."
        },
        {
          "code" : "7.1.6.1",
          "display" : "Conduttori di caldaie a vapore e di motori termici in impianti industriali",
          "definition" : "Le professioni comprese in questa categoria conducono e controllano impianti e macchinari per la produzione di energia termica e di vapore, nonché motori termici a combustione interna asserviti ad impianti industriali."
        },
        {
          "code" : "7.1.6.1.0",
          "display" : "Conduttori di caldaie a vapore e di motori termici in impianti industriali",
          "definition" : "Le professioni comprese in questa unità conducono e controllano impianti e macchinari per la produzione di energia termica e di vapore, nonché motori termici a combustione interna asserviti ad impianti industriali."
        },
        {
          "code" : "7.1.6.2",
          "display" : "Operatori di impianti di recupero e riciclaggio dei rifiuti e di trattamento e distribuzione delle acque",
          "definition" : "Le professioni comprese in questa categoria conducono e controllano impianti per il recupero e il riciclaggio dei rifiuti e per il trattamento e la distribuzione delle acque."
        },
        {
          "code" : "7.1.6.2.1",
          "display" : "Operatori di impianti di recupero e riciclaggio dei rifiuti",
          "definition" : "Le professioni comprese in questa unità conducono e controllano impianti per il recupero e il riciclaggio dei rifiuti."
        },
        {
          "code" : "7.1.6.2.2",
          "display" : "Operatori di impianti per la depurazione, la potabilizzazione e la distribuzione delle acque",
          "definition" : "Le professioni comprese in questa unità conducono e controllano impianti per il trattamento e la distribuzione delle acque."
        },
        {
          "code" : "7.1.7",
          "display" : "Operatori di catene di montaggio automatizzate e di robot industriali",
          "definition" : "Le professioni comprese in questa classe conducono catene di montaggio automatizzate, impianti composti da più stazioni in sequenza, in ognuna delle quali viene eseguita una singola lavorazione su un pezzo che passa poi automaticamente alla stazione successiva, robot industriali che eseguono una o più operazioni complesse dopo opportuna programmazione; sorvegliano la regolarità del processo e intervengono in caso di malfunzionamento."
        },
        {
          "code" : "7.1.7.1",
          "display" : "Operatori di catene di montaggio automatizzate",
          "definition" : "Le professioni comprese in questa categoria conducono e controllano l’attività di catene di montaggio automatizzate e di robot industriali, provvedono al loro avviamento e operano sui meccanismi di funzionamento in relazione alle esigenze produttive programmate."
        },
        {
          "code" : "7.1.7.1.0",
          "display" : "Operatori di catene di montaggio automatizzate",
          "definition" : "Le professioni comprese in questa unità conducono e controllano l’attività di catene di montaggio automatizzate e di robot industriali, provvedono al loro avviamento e operano sui meccanismi di funzionamento in relazione alle esigenze produttive programmate."
        },
        {
          "code" : "7.1.8",
          "display" : "Conduttori di impianti per la trasformazione dei minerali",
          "definition" : "Le professioni comprese in questa classe conducono impianti e macchinari per separare, impastare e trattare termicamente minerali o sostanze chimiche, per trasformarli o decomporli in materie prime per successive lavorazioni e produzioni."
        },
        {
          "code" : "7.1.8.1",
          "display" : "Conduttori di mulini e impastatrici",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per macinare, separare, granulare ed impastare minerali o sostanze chimiche per successive trasformazioni e lavorazioni."
        },
        {
          "code" : "7.1.8.1.0",
          "display" : "Conduttori di mulini e impastatrici",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per macinare, separare, granulare ed impastare minerali o sostanze chimiche per successive trasformazioni e lavorazioni."
        },
        {
          "code" : "7.1.8.2",
          "display" : "Conduttori di forni e di analoghi impianti per il trattamento termico dei minerali",
          "definition" : "Le professioni comprese in questa categoria conducono forni ed altri impianti per il trattamento termico dei minerali per trasformarli mediante processi termici di ossidazione, disidratazione, riduzione e decomposizione in materie prime per successive lavorazioni e produzioni."
        },
        {
          "code" : "7.1.8.2.0",
          "display" : "Conduttori di forni e di impianti per il trattamento termico dei minerali",
          "definition" : "Le professioni comprese in questa unità conducono forni ed altri impianti per il trattamento termico dei minerali per trasformarli mediante processi termici di ossidazione, disidratazione, riduzione e decomposizione in materie prime per successive lavorazioni e produzioni."
        },
        {
          "code" : "7.2",
          "display" : "Operai semiqualificati di macchinari fissi per la lavorazione in serie e operai addetti al montaggio",
          "definition" : "Le professioni comprese in questo gruppo conducono macchine automatiche e semiautomatiche per la produzione in serie di semilavorati o prodotti finiti, selezionano le operazioni da eseguire, caricano in macchina o nell’impianto le materie prime da lavorare e sorvegliano il processo di lavorazione in serie di metalli e prodotti minerali, di prodotti fotografici, di articoli in gomma e plastica, di articoli in legno e carta e di articoli dell'industria tessile e delle confezioni, assemblano parti per realizzare prodotti finiti, conducono macchine per il confezionamento della produzione."
        },
        {
          "code" : "7.2.1",
          "display" : "Operai addetti a macchine automatiche e semiautomatiche per lavorazioni metalliche e per prodotti minerali",
          "definition" : "Le professioni comprese in questa classe conducono e controllano, intervenendo in caso di malfunzionamento, l’attività di macchine utensili automatiche e semiautomatiche per la lavorazione per asportazione e deformazione dei metalli, nonché di macchine e impianti per la produzione di manufatti in cemento a base di altri prodotti minerali."
        },
        {
          "code" : "7.2.1.1",
          "display" : "Operai addetti a macchine utensili automatiche e semiautomatiche industriali",
          "definition" : "Le professioni comprese in questa categoria conducono e supportano il funzionamento di macchine utensili industriali automatiche, semiautomatiche e a controllo numerico e dei relativi centri di produzione per lavorazioni per asportazione e deformazione di semilavorati in metallo (fresatrici, torni, trapani, alesatrici, rettificatici, piallatici, presse…)."
        },
        {
          "code" : "7.2.1.1.0",
          "display" : "Conduttori di macchine utensili automatiche e semiautomatiche industriali",
          "definition" : "Le professioni comprese in questa unità conducono e supportano il funzionamento di macchine utensili industriali automatiche, semiautomatiche e a controllo numerico e dei relativi centri di produzione per la lavorazione, l'asportazione e la deformazione di semilavorati in metallo (fresatrici, torni, trapani, alesatrici, rettificatici, piallatici, presse,...)."
        },
        {
          "code" : "7.2.1.2",
          "display" : "Operai addetti a macchinari per la produzione di manufatti in cemento e assimilati",
          "definition" : "Le professioni comprese in questa categoria conducono e sorvegliano impianti e macchinari per la produzione di manufatti in cemento e in materiali simili, conducono e sorvegliano impianti e macchine per produrre e miscelare i componenti, impastarli e colarli, di formatura, pressatura e rifinitura dei manufatti prodotti."
        },
        {
          "code" : "7.2.1.2.0",
          "display" : "Conduttori di macchinari per la produzione di manufatti in cemento e assimilati",
          "definition" : "Le professioni comprese in questa unità conducono e sorvegliano impianti e macchinari per la produzione di manufatti in cemento e in materiali simili; conducono e sorvegliano impianti e macchine per produrre e miscelare i componenti, impastarli e colarli, nonché per la formatura, la pressatura e la rifinitura dei manufatti prodotti."
        },
        {
          "code" : "7.2.1.3",
          "display" : "Conduttori di macchinari per la produzione di abrasivi e manufatti abrasivi minerali",
          "definition" : "Le professioni comprese in questa categoria conducono e sorvegliano impianti e macchinari per la produzione di manufatti in minerali abrasivi e simili conducono e sorvegliano impianti e macchine per produrre le sabbie, miscelarle e impastarli, di formatura, pressatura e rifinitura dei manufatti prodotti."
        },
        {
          "code" : "7.2.1.3.0",
          "display" : "Conduttori di macchinari per la produzione di abrasivi e manufatti abrasivi minerali",
          "definition" : "Le professioni comprese in questa unità conducono e sorvegliano impianti e macchinari per la produzione di manufatti in minerali abrasivi e simili; conducono e sorvegliano impianti e macchine per produrre le sabbie, miscelarle e impastarle, per la formatura, la pressatura e la rifinitura dei manufatti prodotti."
        },
        {
          "code" : "7.2.2",
          "display" : "Operai dei rivestimenti metallici, della galvanoplastica e per la fabbricazione di prodotti fotografici",
          "definition" : "Le professioni comprese in questa classe provvedono alla conduzione di impianti e macchinari per la rifinitura elettrochimica dei prodotti in metallo e per la fabbricazione di emulsioni e prodotti fotografici."
        },
        {
          "code" : "7.2.2.1",
          "display" : "Finitori, operai dei rivestimenti metallici, della galvanoplastica e assimilati",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per il trattamento, il rivestimento, la rifinitura, la placcatura chimica ed elettrochimica di metalli e oggetti in metallo."
        },
        {
          "code" : "7.2.2.1.0",
          "display" : "Finitori di metalli e conduttori di impianti per finire, rivestire, placcare metalli e oggetti in metallo",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per il trattamento, il rivestimento, la rifinitura, la placcatura chimica ed elettrochimica di metalli e oggetti in metallo."
        },
        {
          "code" : "7.2.2.2",
          "display" : "Operai addetti a macchinari per la fabbricazione di prodotti fotografici (film, pellicole e assimilati)",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la produzione di emulsioni fotografiche e la fabbricazione di supporti fotosensibili (pellicole e carte fotografiche, pellicole radiografiche, cinematografiche …)"
        },
        {
          "code" : "7.2.2.2.0",
          "display" : "Conduttori di macchinari per la fabbricazione di prodotti fotografici e assimilati",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la produzione di emulsioni fotografiche e la fabbricazione di supporti fotosensibili (pellicole e carte fotografiche, pellicole radiografiche, cinematografiche,...)"
        },
        {
          "code" : "7.2.3",
          "display" : "Conduttori di macchinari per la fabbricazione di articoli in gomma e materie plastiche",
          "definition" : "Le professioni comprese in questa classe conducono e controllano impianti e macchinari per la fabbricazione in serie di pneumatici e articoli in gomma e in plastica, sorvegliano la regolarità dei processi di lavorazione e intervengono nei casi di malfunzionamento."
        },
        {
          "code" : "7.2.3.1",
          "display" : "Conduttori di macchinari per la confezione e vulcanizzazione dei pneumatici",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la fabbricazione dei pneumatici, per i processi di vulcanizzazione della gomma, di cucitura, armatura, budellatura dei pneumatici e per la loro ricostruzione."
        },
        {
          "code" : "7.2.3.1.0",
          "display" : "Conduttori di macchinari per la confezione e vulcanizzazione dei pneumatici",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la fabbricazione dei pneumatici, per i processi di vulcanizzazione della gomma, di cucitura, di armatura, di budellatura dei pneumatici e per la loro ricostruzione."
        },
        {
          "code" : "7.2.3.2",
          "display" : "Conduttori di macchinari per la fabbricazione di altri articoli in gomma",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la lavorazione della gomma e la fabbricazione di prodotti in gomma, diversi dai pneumatici, destinati al consumo finale o alla produzione industriale."
        },
        {
          "code" : "7.2.3.2.0",
          "display" : "Conduttori di macchinari per la fabbricazione di altri articoli in gomma",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la lavorazione della gomma e la fabbricazione di prodotti in gomma, diversi dai pneumatici, destinati al consumo finale o alla produzione industriale."
        },
        {
          "code" : "7.2.3.3",
          "display" : "Conduttori di macchinari per la fabbricazione di articoli in plastica e assimilati",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la lavorazione della plastica e la fabbricazione di prodotti in plastica destinati al consumo finale o alla produzione industriale."
        },
        {
          "code" : "7.2.3.3.0",
          "display" : "Conduttori di macchinari per la fabbricazione di articoli in plastica e assimilati",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la lavorazione della plastica e la fabbricazione di prodotti in plastica destinati al consumo finale o alla produzione industriale."
        },
        {
          "code" : "7.2.4",
          "display" : "Operai addetti a macchinari in impianti per la produzione in serie di articoli in legno",
          "definition" : "Le professioni comprese in questa classe conducono e controllano impianti e macchinari per la fabbricazione in serie di mobili e articoli in legno, sorvegliano la regolarità dei processi di lavorazione e intervengono in caso di malfunzionamento degli impianti e dei macchinari."
        },
        {
          "code" : "7.2.4.1",
          "display" : "Operai addetti a macchinari in impianti per la produzione in serie di mobili e di articoli in legno",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la produzione in serie di mobili e di articoli in legno e simili, conducono e sorvegliano i macchinari per tagliare, sagomare, intagliare, perforare, piallare, tornire e levigare il legno e pannelli in legno o materiali simili, sorvegliano la regolarità dei processi di lavorazione e intervengono in caso di malfunzionamento degli impianti e dei macchinari."
        },
        {
          "code" : "7.2.4.1.0",
          "display" : "Addetti a macchinari per la produzione in serie di mobili e di articoli in legno",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la produzione in serie di mobili e di articoli in legno e simili, conducono e sorvegliano i macchinari per tagliare, sagomare, intagliare, perforare, piallare, tornire e levigare il legno e i pannelli in legno o i materiali simili; sorvegliano la regolarità dei processi di lavorazione e intervengono in caso di malfunzionamento degli impianti e dei macchinari."
        },
        {
          "code" : "7.2.5",
          "display" : "Conduttori di macchinari per tipografia e stampa su carta e cartone",
          "definition" : "Le professioni comprese in questa classe conducono e controllano impianti e macchinari per la stampa e fabbricazione in serie di articoli in carta e cartone e per la rilegatura di libri e articoli simili, sorvegliano la regolarità dei processi di lavorazione e intervengono in caso di malfunzionamento."
        },
        {
          "code" : "7.2.5.1",
          "display" : "Conduttori di macchinari per tipografia e stampa su carta e cartone",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la stampa in serie e in continuo di carta e cartone, diversamente lavorati, destinati alla confezione di prodotti industriali e alla realizzazione di articoli e prodotti per il consumo finale e la produzione industriale, curano le prove colore e verificano la correttezza del processo di stampa"
        },
        {
          "code" : "7.2.5.1.0",
          "display" : "Conduttori di macchinari per tipografia e stampa su carta e cartone",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la stampa in serie e in continuo di carta e cartone, diversamente lavorati, destinati alla confezione di prodotti industriali e alla realizzazione di articoli e prodotti per il consumo finale e la produzione industriale; curano le prove colore e verificano la correttezza del processo di stampa."
        },
        {
          "code" : "7.2.5.2",
          "display" : "Conduttori di macchinari per la fabbricazione di prodotti in carta e cartone",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la fabbricazione in serie di prodotti in carta e cartone, diversamente lavorati, destinati alla confezione di prodotti industriali e alla produzione di altri articoli per il consumo finale e la produzione industriale."
        },
        {
          "code" : "7.2.5.2.0",
          "display" : "Conduttori di macchinari per la fabbricazione di prodotti in carta e cartone",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la fabbricazione in serie di prodotti in carta e cartone, diversamente lavorati, destinati alla confezione di prodotti industriali e alla produzione di altri articoli per il consumo finale e la produzione industriale."
        },
        {
          "code" : "7.2.5.3",
          "display" : "Conduttori di macchinari per rilegatura di libri e assimilati",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per rilegare in serie libri, riviste e articoli simili."
        },
        {
          "code" : "7.2.5.3.0",
          "display" : "Conduttori di macchinari per rilegatura di libri e assimilati",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per rilegare in serie libri, riviste e articoli simili."
        },
        {
          "code" : "7.2.6",
          "display" : "Operai addetti a macchinari dell'industria tessile, delle confezioni ed assimilati",
          "definition" : "Le professioni comprese in questa classe conducono impianti e macchinari automatici per la filatura e la bobinatura di fibre naturali e sintetiche, per la fabbricazione in serie di tessuti, maglie, capi di abbigliamento, per il trattamento chimico e fisico dei tessuti, la stampa e la produzione di altri articoli in filato, tessuto e simili; sorvegliano la regolarità dei processo di produzione e intervengono nei casi di malfunzionamento."
        },
        {
          "code" : "7.2.6.1",
          "display" : "Operai addetti a macchinari per la filatura e la bobinatura",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari automatici per la filatura e la sbobinatura in continuo di fibre naturali e sintetiche."
        },
        {
          "code" : "7.2.6.1.0",
          "display" : "Addetti a macchinari per la filatura e la bobinatura",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari automatici per la filatura e la bobinatura in continuo di fibre naturali e sintetiche."
        },
        {
          "code" : "7.2.6.2",
          "display" : "Operai addetti a telai meccanici per la tessitura e la maglieria",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari automatici per la tessitura in continuo di filati e di maglie."
        },
        {
          "code" : "7.2.6.2.0",
          "display" : "Addetti a telai meccanici e a macchinari per la tessitura e la maglieria",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari automatici per la tessitura in continuo di filati e di maglie."
        },
        {
          "code" : "7.2.6.3",
          "display" : "Operai addetti a macchinari industriali per confezioni di abbigliamento in stoffa e assimilati",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari automatici per la produzione in serie di capi e complementi di abbigliamento e di articoli simili, sorvegliano e conducono macchine per tagliare, assemblare e cucire i tessuti secondo misure e modelli predefiniti."
        },
        {
          "code" : "7.2.6.3.0",
          "display" : "Operai addetti a macchinari industriali per confezioni di abbigliamento in stoffa e assimilati",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari automatici per la produzione in serie di capi e complementi di abbigliamento e di articoli simili, sorvegliano e conducono macchine per tagliare, assemblare e cucire i tessuti secondo misure e modelli predefiniti."
        },
        {
          "code" : "7.2.6.4",
          "display" : "Operai addetti a macchinari per il trattamento di filati e tessuti industriali",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari automatici per il trattamento chimico e fisico, il carbonissaggio, il degodronaggio, la brovatura, il decatissaggio, la follatura, la tintura, il candeggio, il lavaggio, la stiratura l’apprettatura e trattamenti simili di filati e di tessuti industriali."
        },
        {
          "code" : "7.2.6.4.0",
          "display" : "Addetti ai macchinari per il trattamento di pulitura a secco, candeggio e tintura di filati e tessuti industriali",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari automatici per il trattamento chimico e fisico, il carbonissaggio, il degodronaggio, la brovatura, il decatissaggio, la follatura, la tintura, il lavaggio, il candeggio, la stiratura, l’apprettatura e trattamenti simili di filati e di tessuti industriali."
        },
        {
          "code" : "7.2.6.5",
          "display" : "Operai addetti a macchinari per la stampa dei tessuti",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari automatici per la stampa in continuo dei tessuti, curano le prove colore, verificano la correttezza del processo di stampa."
        },
        {
          "code" : "7.2.6.5.0",
          "display" : "Addetti a macchinari per la stampa dei tessuti",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari automatici per la stampa in continuo dei tessuti, curano le prove colore, verificano la correttezza del processo di stampa."
        },
        {
          "code" : "7.2.6.6",
          "display" : "Addetti a macchinari industriali per la preparazione e produzione in serie di articoli in pelli e pellicce",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari automatici per la lavorazione di pelli e di pellicce e per la produzione in serie di articoli in questi materiali; sorvegliano e conducono macchine per tagliare, assemblare, incollare e cucire i materiali secondo misure e modelli predefiniti."
        },
        {
          "code" : "7.2.6.6.1",
          "display" : "Addetti a macchinari industriali per la preparazione di pelli e pellicce",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari automatici per la lavorazione di pelli e di pellicce."
        },
        {
          "code" : "7.2.6.6.2",
          "display" : "Addetti a macchinari per la produzione in serie di articoli in pelle e pelliccia",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la produzione in serie di articoli e accessori in pelle e pelliccia; sorvegliano e conducono macchine per tagliare, assemblare, incollare e cucire i materiali secondo misure e modelli predefiniti."
        },
        {
          "code" : "7.2.6.7",
          "display" : "Addetti a macchinari per la produzione in serie di calzature",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari automatici per la produzione in serie di calzature, sorvegliano e conducono macchine per tagliare, assemblare, incollare e cucire i materiali secondo misure e modelli predefiniti."
        },
        {
          "code" : "7.2.6.7.0",
          "display" : "Addetti a macchinari per la produzione in serie di calzature",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari automatici per la produzione in serie di calzature; sorvegliano e conducono macchine per tagliare, assemblare, incollare e cucire i materiali secondo misure e modelli predefiniti."
        },
        {
          "code" : "7.2.6.9",
          "display" : "Altri operai addetti a macchinari dell'industria tessile, delle confezioni ed assimilati",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari automatici per la produzione e confezione in serie di materiali e di articoli per l’abbigliamento e di accessori diversi dai capi di vestiario ovvero conducono impianti e macchinari per la produzione in serie di passamaneria, feltreria e simili; sorvegliano e conducono macchine per tagliare, assemblare, incollare e cucire i materiali secondo misure e modelli predefiniti."
        },
        {
          "code" : "7.2.6.9.0",
          "display" : "Altri operai addetti a macchinari dell'industria tessile e delle confezioni ed assimilati",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari automatici per la produzione e confezione in serie di materiali e di articoli per l’abbigliamento e di accessori diversi dai capi di vestiario ovvero conducono impianti e macchinari per la produzione in serie di passamaneria, feltreria e simili; sorvegliano e conducono macchine per tagliare, assemblare, incollare e cucire i materiali secondo misure e modelli predefiniti."
        },
        {
          "code" : "7.2.7",
          "display" : "Operai addetti all'assemblaggio di prodotti industriali",
          "definition" : "Le professioni comprese in questa classe montano, con l’ausilio di utensili manuali o semiautomatici e lungo una catena di assemblaggio, componenti di macchine, di apparati elettrici elettronici e per le telecomunicazioni, di articoli in metallo, legno, cartone, tessuto o in altri materiali o di loro parti."
        },
        {
          "code" : "7.2.7.1",
          "display" : "Assemblatori in serie di parti di macchine",
          "definition" : "Le professioni comprese in questa categoria montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, componenti di macchine o di parti di macchine."
        },
        {
          "code" : "7.2.7.1.0",
          "display" : "Assemblatori in serie di parti di macchine",
          "definition" : "Le professioni comprese in questa unità montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, componenti di macchine o parti di macchine."
        },
        {
          "code" : "7.2.7.2",
          "display" : "Assemblatori e cablatori di apparecchiature elettriche",
          "definition" : "Le professioni comprese in questa categoria montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, e cablano componenti di apparati e di apparecchiature elettriche o di loro parti."
        },
        {
          "code" : "7.2.7.2.0",
          "display" : "Assemblatori e cablatori di apparecchiature elettriche",
          "definition" : "Le professioni comprese in questa unità montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, e cablano componenti di apparati e di apparecchiature elettriche o di loro parti."
        },
        {
          "code" : "7.2.7.3",
          "display" : "Assemblatori e cablatori di apparecchiature elettroniche e di telecomunicazioni",
          "definition" : "Le professioni comprese in questa categoria montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, e cablano componenti di apparecchiature elettroniche e di telecomunicazione e di loro parti."
        },
        {
          "code" : "7.2.7.3.0",
          "display" : "Assemblatori e cablatori di apparecchiature elettroniche e di telecomunicazioni",
          "definition" : "Le professioni comprese in questa unità montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, e cablano componenti di apparecchiature elettroniche e di telecomunicazione e di loro parti."
        },
        {
          "code" : "7.2.7.4",
          "display" : "Assemblatori in serie di articoli vari in metallo, in gomma e in materie plastiche",
          "definition" : "Le professioni comprese in questa categoria montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, componenti di articoli in metallo, gomma e materie plastiche o di loro parti."
        },
        {
          "code" : "7.2.7.4.0",
          "display" : "Assemblatori in serie di articoli in metallo, in gomma e in materie plastiche",
          "definition" : "Le professioni comprese in questa unità montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, componenti di articoli in metallo, gomma e materie plastiche o di loro parti."
        },
        {
          "code" : "7.2.7.5",
          "display" : "Assemblatori in serie di articoli in legno e in materiali assimilati",
          "definition" : "Le professioni comprese in questa categoria montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, componenti di articoli in legno e materiali simili."
        },
        {
          "code" : "7.2.7.5.0",
          "display" : "Assemblatori in serie di articoli in legno e in materiali assimilati",
          "definition" : "Le professioni comprese in questa unità montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, componenti di articoli in legno e materiali simili."
        },
        {
          "code" : "7.2.7.6",
          "display" : "Assemblatori in serie di articoli in cartone, in tessuto e materie assimilate",
          "definition" : "Le professioni comprese in questa categoria montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, componenti di articoli in cartone, tessuto e materiali simili."
        },
        {
          "code" : "7.2.7.6.0",
          "display" : "Assemblatori in serie di articoli in cartone, in tessuto e materie assimilate",
          "definition" : "Le professioni comprese in questa unità montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, componenti di articoli in cartone, tessuto e materiali simili."
        },
        {
          "code" : "7.2.7.9",
          "display" : "Altri operai addetti all’assemblaggio ed alla produzione in serie di articoli industriali",
          "definition" : "Le professioni comprese in questa categoria montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, pezzi di articoli composti da materiali e apparati di diversa natura e funzione."
        },
        {
          "code" : "7.2.7.9.0",
          "display" : "Assemblatori in serie di articoli industriali compositi",
          "definition" : "Le professioni comprese in questa unità montano, in catene o linee semiautomatiche di assemblaggio e con l’ausilio di utensili manuali o semiautomatici, pezzi di articoli composti da materiali e apparati di diversa natura e funzione."
        },
        {
          "code" : "7.2.8",
          "display" : "Operai addetti a macchine confezionatrici di prodotti industriali",
          "definition" : "Le professioni comprese in questa classe conducono impianti e macchine per il confezionamento automatico di prodotti industriali di varia natura e dimensione."
        },
        {
          "code" : "7.2.8.1",
          "display" : "Operai addetti a macchine confezionatrici di prodotti industriali",
          "definition" : "Le professioni comprese in questa categoria conducono e sono addetti a impianti e macchinari per il confezionamento, l’imbottigliamento, l’inscatolamento, l’invasatura, l’imballo e simili di prodotti industriali."
        },
        {
          "code" : "7.2.8.1.0",
          "display" : "Addetti a macchine confezionatrici e al confezionamento di prodotti industriali",
          "definition" : "Le professioni comprese in questa unità conducono e sono addetti a impianti e macchinari per il confezionamento, l’imbottigliamento, l’inscatolamento, l’invasatura, l’imballo e simili di prodotti industriali."
        },
        {
          "code" : "7.3",
          "display" : "Operatori di macchinari fissi in agricoltura e nella industria alimentare",
          "definition" : "Le professioni comprese in questo gruppo conducono impianti automatici e semiautomatici e macchinari fissi per la prima trasformazione dei prodotti agricoli e per la produzione alimentare."
        },
        {
          "code" : "7.3.1",
          "display" : "Operai addetti a macchinari fissi nell'agricoltura e nella prima trasformazione dei prodotti agricoli",
          "definition" : "Le professioni comprese in questa classe conducono impianti e macchinari per la prima trasformazione dei prodotti agricoli e di allevamento, di impianti e macchinari di frantoio e per la refrigerazione, igienizzazione e primo trattamento del latte."
        },
        {
          "code" : "7.3.1.1",
          "display" : "Operai addetti agli impianti fissi in agricoltura e nell’allevamento",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari fissi per il primo trattamento e la prima lavorazione dei prodotti agricoli e di allevamento ovvero conducono impianti e macchinari fissi per la pulitura, vagliatura, essiccazione, insilaggio e conservazione dei prodotti agricoli freschi; conducono impianti e macchinari fissi di pulizia e di tenuta igienica dei luoghi e di alimentazione degli animali in allevamento, di raccolta, lavaggio, pulizia, stoccaggio e operazioni simili di prodotti di allevamento diversi dal latte."
        },
        {
          "code" : "7.3.1.1.0",
          "display" : "Addetti agli impianti fissi in agricoltura e nell'allevamento",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari fissi per il primo trattamento e la prima lavorazione dei prodotti agricoli e di allevamento ovvero conducono impianti e macchinari fissi per la pulitura, vagliatura, essiccazione, insilaggio e conservazione dei prodotti agricoli freschi; conducono impianti e macchinari fissi di pulizia e di tenuta igienica dei luoghi di alimentazione degli animali in allevamento, di raccolta, lavaggio, pulizia, stoccaggio e operazioni simili di prodotti di allevamento diversi dal latte."
        },
        {
          "code" : "7.3.1.2",
          "display" : "Operai addetti agli impianti per la trasformazione delle olive",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari da frantoio la trasformazione delle olive e delle sanse in oli."
        },
        {
          "code" : "7.3.1.2.0",
          "display" : "Addetti agli impianti per la trasformazione delle olive",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari da frantoio per la trasformazione delle olive e delle sanse in olii."
        },
        {
          "code" : "7.3.1.3",
          "display" : "Operai addetti alla refrigerazione, trattamento igienico e prima trasformazione del latte",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la refrigerazione, l’igienizzazione, il primo trattamento del latte e la prima trasformazione del latte."
        },
        {
          "code" : "7.3.1.3.0",
          "display" : "Addetti alla refrigerazione, trattamento igienico e prima trasformazione del latte",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la refrigerazione, l’igienizzazione, il primo trattamento del latte e la prima trasformazione del latte."
        },
        {
          "code" : "7.3.2",
          "display" : "Operai addetti a macchinari fissi per l'industria alimentare",
          "definition" : "Le professioni comprese in questa classe conducono impianti e macchinari fissi per la produzione, la lavorazione e la conservazione dei prodotti alimentari, della carne e del pesce, di prodotti lattiero-caseari, dei cereali e delle spezie, della frutta e delle verdure, dello zucchero, del the, del caffé, del cacao e della cioccolata, del tabacco, di liquori, vini e bevande, di pasticceria e prodotti da forno."
        },
        {
          "code" : "7.3.2.1",
          "display" : "Conduttori di macchinari per la lavorazione e la conservazione della carne e del pesce",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la lavorazione e la conservazione della carne e del pesce, per tagliare, tritare e impastare carne e pesce, per essiccarli, salarli, affumicarli, insaccarli, cuocerli, inscatolarli e confezionarli in prodotti destinati al consumo alimentare."
        },
        {
          "code" : "7.3.2.1.0",
          "display" : "Conduttori di macchinari per la lavorazione e la conservazione della carne e del pesce",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la lavorazione e la conservazione della carne e del pesce, per tagliare, tritare e impastare carne e pesce, per essiccarli, salarli, affumicarli, insaccarli, cuocerli, inscatolarli e confezionarli in prodotti destinati al consumo alimentare."
        },
        {
          "code" : "7.3.2.2",
          "display" : "Conduttori di apparecchi per la lavorazione industriale di prodotti lattiero–caseari",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari per la lavorazione industriale di prodotti lattiero-caseari, per centrifugare, pastorizzare, concentrare il latte, fermentarlo, cagliarlo, per produrre burro, panna, latticini, formaggi freschi, per stagionare formaggi e per lavorazioni e produzioni simili."
        },
        {
          "code" : "7.3.2.2.0",
          "display" : "Conduttori di apparecchi per la lavorazione industriale di prodotti lattiero – caseari",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari per la lavorazione industriale di prodotti lattiero-caseari, per centrifugare, pastorizzare, concentrare il latte, fermentarlo, cagliarlo, per produrre burro, panna, latticini, formaggi freschi, per stagionare formaggi e per lavorazioni e produzioni simili."
        },
        {
          "code" : "7.3.2.3",
          "display" : "Conduttori di macchinari industriali per la lavorazione dei cereali e delle spezie e per prodotti a base di cereali (pasta e assimilati)",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari industriali per la lavorazione dei cereali e delle spezie e dei loro derivati ovvero conducono impianti e macchine per la molitura dei cereali, l’abburattamento e la selezione delle farine; per la pulitura, la selezione e la lavorazione delle spezie; per la lavorazione e la produzione industriale di paste alimentari fresche e essiccate."
        },
        {
          "code" : "7.3.2.3.1",
          "display" : "Conduttori di macchinari industriali per la lavorazione dei cereali",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la lavorazione dei cereali ovvero per la molitura dei cereali, l’abburattamento e la selezione delle farine."
        },
        {
          "code" : "7.3.2.3.2",
          "display" : "Conduttori di macchinari industriali per la lavorazione delle spezie",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la pulitura, la selezione e la lavorazione delle spezie."
        },
        {
          "code" : "7.3.2.3.3",
          "display" : "Conduttori di macchinari industriali per la lavorazione di prodotti a base di cereali",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la lavorazione e la produzione industriale di paste alimentari fresche e essiccate."
        },
        {
          "code" : "7.3.2.4",
          "display" : "Conduttori di macchinari per il trattamento e la conservazione della frutta, delle mandorle, delle verdure, dei legumi e del riso",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari industriali per il trattamento e la conservazione di prodotti agricoli freschi destinati al consumo, ovvero impianti e macchinari per la pulizia, la calibratura, e la selezione di prodotti ortofrutticoli; per la conservazione di frutta e verdura fresca e la loro lavorazione in prodotti conservati; per la vagliatura, pulitura, selezione, lavorazione e conservazione dei legumi e del riso; per la lavorazione dei semi e la successiva produzione di oli."
        },
        {
          "code" : "7.3.2.4.1",
          "display" : "Conduttori di macchinari per la cernita e la calibratura di prodotti ortofrutticoli",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per il trattamento e la conservazione di prodotti agricoli freschi destinati al consumo, ovvero per la pulizia, la calibratura e la selezione di prodotti ortofrutticoli."
        },
        {
          "code" : "7.3.2.4.2",
          "display" : "Conduttori di macchinari per la conservazione di frutta e verdura",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per il trattamento e la conservazione di prodotti agricoli freschi destinati al consumo, ovvero per la conservazione di frutta e verdura fresca e la loro lavorazione in prodotti conservati."
        },
        {
          "code" : "7.3.2.4.3",
          "display" : "Conduttori di macchinari per la conservazione di legumi e riso",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per il trattamento e la conservazione di prodotti agricoli freschi destinati al consumo, ovvero per la vagliatura, pulitura, selezione, lavorazione e conservazione dei legumi e del riso."
        },
        {
          "code" : "7.3.2.4.4",
          "display" : "Conduttori di macchinari per la produzione di oli di semi",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per il trattamento e la conservazione di prodotti agricoli freschi destinati al consumo, ovvero per la lavorazione dei semi e la successiva produzione di olii."
        },
        {
          "code" : "7.3.2.5",
          "display" : "Conduttori di macchinari per la produzione e la raffinazione dello zucchero",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari industriali per la lavorazione della materia prima (canna o barbabietola da zucchero) e la produzione e la raffinazione dello zucchero."
        },
        {
          "code" : "7.3.2.5.0",
          "display" : "Conduttori di macchinari per la produzione e la raffinazione dello zucchero",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la lavorazione della materia prima (canna o barbabietola da zucchero) e la produzione e la raffinazione dello zucchero."
        },
        {
          "code" : "7.3.2.6",
          "display" : "Conduttori di macchinari per la preparazione e la produzione del the, del caffè, del cacao e della cioccolata",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari industriali per la preparazione e la produzione del the, del caffé, del cacao e della cioccolata, ovvero conducono impianti e macchinari per l’essiccazione, il trattamento, la miscelazione, la torrefazione e la molitura dei chicchi di caffé, dei semi di cacao e delle foglie di the; impianti e macchinari per la produzione, raffinazione e tempera della cioccolata e prodotti industriali a base di cioccolata."
        },
        {
          "code" : "7.3.2.6.1",
          "display" : "Conduttori di macchinari per la preparazione e la produzione del the, del caffè e del cacao",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la preparazione e la produzione del the, del caffè e del cacao, ovvero per l’essiccazione, il trattamento, la miscelazione, la torrefazione e la molitura dei chicchi di caffè, dei semi di cacao e delle foglie di the."
        },
        {
          "code" : "7.3.2.6.2",
          "display" : "Conduttori di macchinari per la preparazione e la produzione della cioccolata",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la preparazione e la produzione della cioccolata, ovvero per la produzione, raffinazione e tempera della cioccolata e prodotti industriali a base di cioccolata."
        },
        {
          "code" : "7.3.2.7",
          "display" : "Conduttori di macchinari per la lavorazione dei prodotti del tabacco",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari industriali per la lavorazione del tabacco, per essiccarlo, trinciarlo, conciarlo, miscelarlo e confezionarlo in sigari, sigarette, tavolette e polvere."
        },
        {
          "code" : "7.3.2.7.0",
          "display" : "Conduttori di macchinari per la lavorazione dei prodotti del tabacco",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la lavorazione del tabacco, per essiccarlo, trinciarlo, conciarlo miscelarlo e confezionarlo in sigari, sigarette, tavolette e polvere."
        },
        {
          "code" : "7.3.2.8",
          "display" : "Vinificatori industriali, birrai ed operai addetti a macchinari per la preparazione di liquori e bevande analcoliche e gassate",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari industriali per la produzione di vino, birra, liquori e bevande, ovvero impianti e macchinari per la vinificazione delle uve e la produzione e l’invecchiamento e la conservazione del vino; per la fermentazione dei cereali, la preparazione dei mosti e per la preparazione, la lavorazione, l’invecchiamento e la conservazione della birra; per la distillazione di vinacce, di cereali e di puree di frutta o di altri vegetali fermentati, per l’infusione di erbe e semi aromatici in alcool e la lavorazione, la produzione, l’invecchiamento e la conservazione di liquori, distillati e bevande alcoliche; per la lavorazione di frutta, ortaggi ed altri prodotti naturali o aromatici e per la produzione e la conservazione di bevande analcoliche e gassate."
        },
        {
          "code" : "7.3.2.8.1",
          "display" : "Addetti a macchinari industriali per la vinificazione",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la produzione del vino, ovvero per la vinificazione delle uve, la produzione, l’invecchiamento e la conservazione del vino."
        },
        {
          "code" : "7.3.2.8.2",
          "display" : "Addetti a macchinari industriali per la produzione di birra",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la produzione della birra, ovvero per la fermentazione dei cereali, la preparazione dei mosti e per la preparazione, la lavorazione, l’invecchiamento e la conservazione della birra."
        },
        {
          "code" : "7.3.2.8.3",
          "display" : "Addetti a macchinari industriali per la produzione di liquori, di distillati e di bevande alcoliche",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la distillazione di vinacce, di cereali e di puree di frutta o di altri vegetali fermentati, per l’infusione di erbe e semi aromatici in alcool e la lavorazione, la produzione, l’invecchiamento e la conservazione di liquori, distillati e bevande alcoliche."
        },
        {
          "code" : "7.3.2.8.4",
          "display" : "Addetti a macchinari industriali per la produzione di bevande analcoliche e gassate",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la lavorazione di frutta, ortaggi ed altri prodotti naturali o aromatici e per la produzione e la conservazione di bevande analcoliche e gassate."
        },
        {
          "code" : "7.3.2.9",
          "display" : "Conduttori di macchinari per la produzione di pasticceria e prodotti da forno",
          "definition" : "Le professioni comprese in questa categoria conducono impianti e macchinari industriali per la produzione di pasticceria e di prodotti da forno, per miscelare e impastare farine e altri composti, farcire, modellare, essiccare, cuocere."
        },
        {
          "code" : "7.3.2.9.0",
          "display" : "Conduttori di macchinari per la produzione di pasticceria e prodotti da forno",
          "definition" : "Le professioni comprese in questa unità conducono impianti e macchinari industriali per la produzione di pasticceria e di prodotti da forno, per miscelare e impastare farine e altri composti e per farcire, modellare, essiccare e cuocere."
        },
        {
          "code" : "7.4",
          "display" : "Conduttori di veicoli, di macchinari mobili e di sollevamento",
          "definition" : "Le professioni comprese in questo gruppo guidano mezzi di trasporto terrestri e supportano le attività connesse comprese quelle relative al trasporto marino, guidano locomotive e manovrano i dispositivi dei veicoli su rotaia, veicoli a motore e a trazione animale, macchine per la movimentazione e il sollevamento di materiali."
        },
        {
          "code" : "7.4.1",
          "display" : "Conduttori di convogli ferroviari e altri manovratori di veicoli su rotaie e di impianti a fune",
          "definition" : "Le professioni comprese in questa classe conducono locomotori ferroviari; controllano e azionano i dispositivi di frenatura e i dispositivi di segnalazione ferroviaria; manovrano e conducono altri mezzi rotabili di supporto alle attività di sorveglianza, di mantenimento in sicurezza del traffico ferroviario e di manutenzione del materiale rotabile; controllano e azionano i dispositivi di movimentazione e frenatura dei convogli funiviari e teleferici."
        },
        {
          "code" : "7.4.1.1",
          "display" : "Conduttori di convogli ferroviari",
          "definition" : "Le professioni comprese in questa categoria conducono locomotori ferroviari con propulsori diesel, elettrici o a vapore per il trasporto su rotaia di persone e merci."
        },
        {
          "code" : "7.4.1.1.0",
          "display" : "Conduttori di convogli ferroviari",
          "definition" : "Le professioni comprese in questa unità conducono convogli ferroviari con propulsori diesel, elettrici o a vapore per il trasporto su rotaia di persone e merci."
        },
        {
          "code" : "7.4.1.2",
          "display" : "Operatori di verifica, circolazione e formazione treni",
          "definition" : "Le professioni comprese in questa categoria controllano e azionano i dispositivi di frenatura dei convogli ferroviari in relazione alla loro composizione, i dispositivi di segnalazione dello stato del percorso ferroviario e del convoglio e di scambio; verificano e manutengono i dispositivi di sicurezza; eseguono la composizione e la scomposizione dei treni all'interno delle stazioni; manovrano e conducono altri mezzi rotabili e di trazione di supporto alle attività di sorveglianza, di mantenimento in sicurezza del traffico ferroviario e di manutenzione del materiale rotabile."
        },
        {
          "code" : "7.4.1.2.0",
          "display" : "Operatori di verifica, circolazione e formazione treni",
          "definition" : "Le professioni comprese in questa unità controllano e azionano i dispositivi di frenatura dei convogli ferroviari in relazione alla loro composizione, i dispositivi di segnalazione dello stato del percorso ferroviario e del convoglio e di scambio; verificano e manutengono i dispositivi di sicurezza; eseguono la composizione e la scomposizione dei treni all'interno delle stazioni; manovrano e conducono altri mezzi rotabili e di trazione di supporto alle attività di sorveglianza, di mantenimento in sicurezza del traffico ferroviario e di manutenzione del materiale rotabile."
        },
        {
          "code" : "7.4.1.3",
          "display" : "Manovratori di impianti a fune",
          "definition" : "Le professioni comprese in questa categoria controllano e azionano i dispositivi di movimentazione e frenatura dei convogli funiviari e teleferici, in condizioni di sicurezza rispetto alle condizioni atmosferiche, alle portate massime e alle segnalazioni dei dispositivi di controllo."
        },
        {
          "code" : "7.4.1.3.0",
          "display" : "Manovratori di impianti a fune",
          "definition" : "Le professioni comprese in questa unità controllano e azionano i dispositivi di movimentazione e frenatura dei convogli funiviari e teleferici, in condizioni di sicurezza rispetto alle condizioni atmosferiche, alle portate massime e alle segnalazioni dei dispositivi di controllo."
        },
        {
          "code" : "7.4.2",
          "display" : "Conduttori di veicoli a motore e a trazione animale",
          "definition" : "Le professioni comprese in questa classe conducono veicoli per trasporto su gomma o su rotaia cittdina di persone e merci; guidano motocicli, autoveicoli, furgoni, autobus, tram, filobus, autotreni e mezzi pesanti per il trasporto merci, veicoli a trazione animale."
        },
        {
          "code" : "7.4.2.1",
          "display" : "Autisti di taxi, conduttori di automobili, furgoni e altri veicoli",
          "definition" : "Le professioni comprese in questa categoria conducono motocicli, autoveicoli, furgoni, navette, autoambulanze e altri veicoli leggeri per il trasporto di merci o persone, dotati di motore a combustione interna o ad energia elettrica, ne effettuano il carico, lo scarico ed il rifornimento, facilitano la salita e la discesa dei passeggeri, gestiscono le relazioni economiche ed informative con gli stessi, agendo nel rispetto delle caratteristiche meccaniche del mezzo, delle condizioni viarie e delle norme applicabili."
        },
        {
          "code" : "7.4.2.1.0",
          "display" : "Autisti di taxi, conduttori di automobili, furgoni e altri veicoli",
          "definition" : "Le professioni comprese in questa unità conducono motocicli, autoveicoli, furgoni, navette, autoambulanze e altri veicoli leggeri per il trasporto di merci o persone, dotati di motore a combustione interna o ad energia elettrica, ne effettuano il carico, lo scarico ed il rifornimento, facilitano la salita e la discesa dei passeggeri, gestiscono le relazioni economiche ed informative con gli stessi, agendo nel rispetto delle caratteristiche meccaniche del mezzo, delle condizioni viarie e delle norme applicabili."
        },
        {
          "code" : "7.4.2.2",
          "display" : "Conduttori di autobus, di tram e di filobus",
          "definition" : "Le professioni comprese in questa categoria guidano autobus, tram, filobus ed altri mezzi dotati di motore a combustione interna o ad energia elettrica, facilitano la salita e la discesa dei passeggeri, gestiscono le relazioni informative con gli stessi, nel rispetto degli itinerari, delle disposizione di corsa, delle condizioni viarie e delle norme di sicurezza applicabili."
        },
        {
          "code" : "7.4.2.2.0",
          "display" : "Conduttori di autobus, di tram e di filobus",
          "definition" : "Le professioni comprese in questa unità guidano autobus, tram, filobus ed altri mezzi dotati di motore a combustione interna o ad energia elettrica, facilitano la salita e la discesa dei passeggeri, gestiscono le relazioni informative con gli stessi, nel rispetto degli itinerari, delle disposizione di corsa, delle condizioni viarie e delle norme di sicurezza applicabili."
        },
        {
          "code" : "7.4.2.3",
          "display" : "Conduttori di mezzi pesanti e camion",
          "definition" : "Le professioni comprese in questa categoria guidano autotreni e mezzi pesanti per il trasporto di merci, sovrintendono alle operazioni di carico e di scarico, provvedendo al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni viarie e delle norme applicabili."
        },
        {
          "code" : "7.4.2.3.0",
          "display" : "Conduttori di mezzi pesanti e camion",
          "definition" : "Le professioni comprese in questa unità guidano autotreni e mezzi pesanti per il trasporto di merci, sovrintendono alle operazioni di carico e di scarico, provvedendo al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni viarie e delle norme applicabili."
        },
        {
          "code" : "7.4.2.4",
          "display" : "Conduttori di veicoli a trazione animale",
          "definition" : "Le professioni comprese in questa categoria guidano veicoli a trazione animale, ne effettuano il carico e lo scarico, curano le condizioni dell'animale al traino, agendo nel rispetto delle caratteristiche dell’animale, del mezzo, delle condizioni viarie e delle norme applicabili."
        },
        {
          "code" : "7.4.2.4.0",
          "display" : "Conduttori di veicoli a trazione animale",
          "definition" : "Le professioni comprese in questa unità guidano veicoli a trazione animale, ne effettuano il carico e lo scarico, curano le condizioni dell'animale al traino, agendo nel rispetto delle caratteristiche dell’animale, del mezzo, delle condizioni viarie e delle norme applicabili."
        },
        {
          "code" : "7.4.3",
          "display" : "Conduttori di macchine agricole",
          "definition" : "Le professioni comprese in questa classe conducono macchine mobili utilizzate nelle diverse fasi della produzione agricola e delle lavorazioni forestali."
        },
        {
          "code" : "7.4.3.1",
          "display" : "Conduttori di trattori agricoli",
          "definition" : "Le professioni comprese in questa categoria guidano trattori agricoli e macchine agricole per la semina, l’aratura e la concimazione dei terreni, agganciano e sganciano le motrici da carrelli e attrezzi, provvedendo al rifornimento e agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno e delle norme applicabili."
        },
        {
          "code" : "7.4.3.1.0",
          "display" : "Conduttori di trattori agricoli",
          "definition" : "Le professioni comprese in questa unità guidano trattori agricoli e macchine agricole per la semina, l’aratura e la concimazione dei terreni, agganciano e sganciano le motrici da carrelli e attrezzi, provvedendo al rifornimento e agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno e delle norme applicabili."
        },
        {
          "code" : "7.4.3.2",
          "display" : "Conduttori di macchine raccoglitrici, mietitrici, trinciatrici e pressatrici agricole",
          "definition" : "Le professioni comprese in questa categoria guidano macchine agricole per mietere, trinciare, raccogliere prodotti agricoli, pressare e imballare fieno e paglia, ne curano l'efficienza, ne dirigono e controllano l'azione durante il lavoro sul terreno, provvedono al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno, del tipo di raccolto e delle norme applicabili."
        },
        {
          "code" : "7.4.3.2.1",
          "display" : "Conduttori di macchine raccoglitrici, trinciatrici e pressatrici agricole",
          "definition" : "Le professioni comprese in questa unità guidano macchine agricole per mietere, trinciare, pressare e imballare fieno e paglia, ne curano l'efficienza, ne dirigono e controllano l'azione durante il lavoro sul terreno; provvedono al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno e delle norme applicabili."
        },
        {
          "code" : "7.4.3.2.2",
          "display" : "Conduttori di mietitrebbiatrici",
          "definition" : "Le professioni comprese in questa unità guidano macchine mietitrebbiatrici, ne curano l'efficienza, ne dirigono e controllano l'azione durante il lavoro sul terreno, provvedono al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno, del tipo di raccolto e delle norme applicabili."
        },
        {
          "code" : "7.4.3.2.3",
          "display" : "Conduttori di macchine per la raccolta di prodotti agricoli (barbabietole, patate, frutta, uva e ortive)",
          "definition" : "Le professioni comprese in questa unità guidano macchine per la raccolta di prodotti agricoli (barbabietole, patate, frutta, uva e ortive), curano l'efficienza delle attrezzature, ne dirigono e controllano l'azione durante il lavoro sul terreno, provvedono al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno, del tipo di raccolto e delle norme applicabili."
        },
        {
          "code" : "7.4.3.3",
          "display" : "Conduttori di macchine forestali",
          "definition" : "Le professioni comprese in questa categoria guidano macchine per disboscare, tagliare, segare, estirpare o eseguire altre lavorazioni forestali, curano l'efficienza delle attrezzature, ne dirigono e controllano l'azione durante il lavoro sul terreno, provvedono al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno, dei materiali da trattare e delle norme applicabili."
        },
        {
          "code" : "7.4.3.3.0",
          "display" : "Conduttori di macchine forestali",
          "definition" : "Le professioni comprese in questa unità guidano macchine per disboscare, tagliare, segare, estirpare o eseguire altre lavorazioni forestali, curano l'efficienza delle attrezzature, ne dirigono e controllano l'azione durante il lavoro sul terreno, provvedono al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno, dei materiali da trattare e delle norme applicabili."
        },
        {
          "code" : "7.4.4",
          "display" : "Conduttori di macchine per movimento terra, di macchine di sollevamento e di maneggio dei materiali",
          "definition" : "Le professioni comprese in questa classe conducono macchine per il movimento terra e simili, per la perforazione nelle costruzioni e di macchinari fissi e semoventi per il sollevamento e la movimentazione di materiali."
        },
        {
          "code" : "7.4.4.1",
          "display" : "Conduttori di macchinari per il movimento terra",
          "definition" : "Le professioni comprese in questa categoria manovrano macchine per il movimento terra e simili, ne curano l'efficienza delle attrezzature, ne dirigono e controllano l'azione durante il lavoro, provvedono al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno, del tipo di scavo o di sterro da svolgere e delle norme applicabili."
        },
        {
          "code" : "7.4.4.1.0",
          "display" : "Conduttori di macchinari per il movimento terra",
          "definition" : "Le professioni comprese in questa unità manovrano macchine per il movimento terra e simili, ne curano l'efficienza delle attrezzature, ne dirigono e controllano l'azione durante il lavoro, provvedono al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno, del tipo di scavo o di sterro da svolgere e delle norme applicabili."
        },
        {
          "code" : "7.4.4.2",
          "display" : "Conduttori di macchinari mobili per la perforazione nelle costruzioni",
          "definition" : "Le professioni comprese in questa categoria manovrano macchine per la perforazione nel settore delle costruzioni, ne curano l'efficienza, ne effettuano il posizionamento, ne dirigono e controllano l'azione durante il lavoro, provvedono al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno e dei materiali da perforare, del tipo di lavoro da svolgere e delle norme applicabili."
        },
        {
          "code" : "7.4.4.2.1",
          "display" : "Conduttori di macchinari mobili per la perforazione in edilizia",
          "definition" : "Le professioni comprese in questa unità manovrano macchine per la perforazione in edilizia e lavorazioni simili, ne curano l'efficienza, ne effettuano il posizionamento, ne dirigono e controllano l'azione durante il lavoro, provvedono al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni del terreno, del tipo di lavoro da svolgere e delle norme applicabili."
        },
        {
          "code" : "7.4.4.2.2",
          "display" : "Conduttori di macchinari mobili per la perforazione di gallerie",
          "definition" : "Le professioni comprese in questa unità manovrano macchine per la perforazione di gallerie, ne curano l'efficienza, ne effettuano il posizionamento, ne dirigono e controllano l'azione durante il lavoro, provvedono al rifornimento, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni dei materiali da perforare, del tipo di lavoro da svolgere e delle norme applicabili."
        },
        {
          "code" : "7.4.4.3",
          "display" : "Conduttori di gru e di apparecchi di sollevamento",
          "definition" : "Le professioni comprese in questa categoria manovrano macchine, fisse, mobili o semoventi, per il sollevamento di materiali, ne curano l'efficienza, effettuano il posizionamento, ne dirigono e controllano l'azione durante il lavoro, effettuano le operazioni di aggancio e sgancio delle masse da sollevare, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni atmosferiche e di contesto, della natura del carico e delle norme applicabili."
        },
        {
          "code" : "7.4.4.3.0",
          "display" : "Conduttori di gru e di apparecchi di sollevamento",
          "definition" : "Le professioni comprese in questa unità manovrano macchine fisse, mobili o semoventi, per il sollevamento di materiali, ne curano l'efficienza, effettuano il posizionamento, ne dirigono e controllano l'azione durante il lavoro, effettuano le operazioni di aggancio e sgancio delle masse da sollevare, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni atmosferiche e di contesto, della natura del carico e delle norme applicabili."
        },
        {
          "code" : "7.4.4.4",
          "display" : "Conduttori di carrelli elevatori",
          "definition" : "Le professioni comprese in questa categoria manovrano carrelli elevatori per il sollevamento e lo spostamento di merci e di grandi masse, ne curano l'efficienza, ne dirigono e controllano l'azione durante il lavoro, effettuano le operazioni di carico e scarico delle masse sollevate, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni atmosferiche e di contesto, della natura del carico e delle norme applicabili."
        },
        {
          "code" : "7.4.4.4.0",
          "display" : "Conduttori di carrelli elevatori",
          "definition" : "Le professioni comprese in questa unità manovrano carrelli elevatori per il sollevamento e lo spostamento di merci e di grandi masse, ne curano l'efficienza, ne dirigono e controllano l'azione durante il lavoro, effettuano le operazioni di carico e scarico delle masse sollevate, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni atmosferiche e di contesto, della natura del carico e delle norme applicabili."
        },
        {
          "code" : "7.4.5",
          "display" : "Marinai di coperta e operai assimilati",
          "definition" : "Le professioni comprese in questa classe conducono macchine e motori navali, barche e battelli; supportano le operazioni di trasporto marittimo."
        },
        {
          "code" : "7.4.5.1",
          "display" : "Marinai di coperta",
          "definition" : "Le professioni comprese in questa categoria eseguono le manovre di bordo utilizzando le attrezzature fisse e semoventi di sollevamento e piazzamento in stiva o su ponte di merci e container; operano sulle saracinesche e le pompe dedicate al carico e scarico dei carichi liquidi; assicurano il carico a mezzo di corde e tiranti; effettuano operazioni di fardaggio, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni atmosferiche e di contesto, della natura del carico e delle norme applicabili; mantengono pulite e in efficienza le attrezzature di bordo, ormeggiano, eseguono segnalazioni e curano i rifornimenti."
        },
        {
          "code" : "7.4.5.1.0",
          "display" : "Marinai di coperta",
          "definition" : "Le professioni comprese in questa unità eseguono le manovre di bordo utilizzando le attrezzature fisse e semoventi di sollevamento e piazzamento in stiva o su ponte di merci e container; operano sulle saracinesche e le pompe dedicate al carico e scarico dei carichi liquidi; assicurano il carico a mezzo di corde e tiranti; effettuano operazioni di fardaggio, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni atmosferiche e di contesto, della natura del carico e delle norme applicabili; mantengono pulite e in efficienza le attrezzature di bordo, ormeggiano, eseguono segnalazioni e curano i rifornimenti."
        },
        {
          "code" : "7.4.5.2",
          "display" : "Conduttori di caldaie ed altre attrezzature navali",
          "definition" : "Le professioni comprese in questa categoria conducono caldaie e turbine a vapore su navi, garantendone l’alimentazione in funzione dell'energia richiesta; controllando le condizioni di temperatura e pressione; curano l'utilizzo e mantengono in efficienza gli altri mezzi meccanici di bordo."
        },
        {
          "code" : "7.4.5.2.0",
          "display" : "Conduttori di caldaie ed altre attrezzature navali",
          "definition" : "Le professioni comprese in questa unità conducono caldaie e turbine a vapore su navi, garantendone l’alimentazione in funzione dell'energia richiesta; controllando le condizioni di temperatura e pressione; curano l'utilizzo e mantengono in efficienza gli altri mezzi meccanici di bordo."
        },
        {
          "code" : "7.4.5.3",
          "display" : "Conduttori di barche e battelli a motore",
          "definition" : "Le professioni comprese in questa categoria guidano barche e battelli con motore a combustione interna, ne effettuano il carico, lo scarico ed il rifornimento, facilitano la salita e la discesa degli eventuali passeggeri, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni atmosferiche e di contesto, della natura del carico e delle norme applicabili."
        },
        {
          "code" : "7.4.5.3.0",
          "display" : "Conduttori di barche e battelli a motore",
          "definition" : "Le professioni comprese in questa unità guidano barche e battelli con motore a combustione interna, ne effettuano il carico, lo scarico ed il rifornimento, facilitano la salita e la discesa degli eventuali passeggeri, agendo nel rispetto delle caratteristiche meccaniche, delle condizioni atmosferiche e di contesto, della natura del carico e delle norme applicabili."
        }
      ]
    },
    {
      "code" : "8",
      "display" : "PROFESSIONI NON QUALIFICATE",
      "definition" : "l'ottavo grande gruppo comprende le professioni che richiedono lo svolgimento di attività semplici e ripetitive, per le quali non è necessario il completamento di un particolare percorso di istruzione e che possono comportare l’impiego di utensili manuali, l’uso della forza fisica e una limitata autonomia di giudizio e di iniziativa nell’esecuzione dei compiti. Tali professioni svolgono lavori di manovalanza e di supporto esecutivo nelle attività di ufficio, nei servizi alla produzione, nei servizi di istruzione e sanitari; compiti di portierato, di pulizia degli ambienti; svolgono attività ambulanti e lavori manuali non qualificati nell'agricoltura, nell’edilizia e nella produzione industriale.",
      "concept" : [
        {
          "code" : "8.1",
          "display" : "Professioni non qualificate nel commercio e nei servizi",
          "definition" : "Le professioni comprese in questo gruppo esercitano il commercio ambulante; svolgono attività manuali non qualificate nei servizi alla produzione, supportando con attività manuale il lavoro d'ufficio, svolgendo attività di facchinaggio, di pulizia di alberghi, ristoranti e aree pubbliche, eseguendo compiti non qualificati in strutture scolastiche e sanitarie e servizi di custodia di edifici, attrezzature e beni."
        },
        {
          "code" : "8.1.1",
          "display" : "Venditori ambulanti",
          "definition" : "Le professioni classificate in questa classe svolgono attività ambulanti di vendita di prodotti alimentari, di manufatti e di servizi."
        },
        {
          "code" : "8.1.1.1",
          "display" : "Venditori ambulanti di beni",
          "definition" : "Le professioni classificate in questa categoria commerciano prodotti alimentari, manufatti, biglietti della lotteria, oggetti e articoli di varia natura per strada o in luoghi pubblici in postazioni non fisse."
        },
        {
          "code" : "8.1.1.1.0",
          "display" : "Venditori ambulanti di beni",
          "definition" : "Le professioni classificate in questa unità commerciano generi alimentari non destinati all'immediato consumo, manufatti, biglietti della lotteria, oggetti e articoli di varia natura, per strada o in luoghi pubblici in postazioni non fisse."
        },
        {
          "code" : "8.1.1.2",
          "display" : "Venditori ambulanti di servizi",
          "definition" : "Le professioni classificate in questa categoria offrono servizi di vario genere, esercitano piccoli mestieri di strada, lustrano e riparano scarpe, affilano lame, riparano ombrelli ed altri oggetti per strada, porta a porta o in luoghi pubblici in postazioni non fisse."
        },
        {
          "code" : "8.1.1.2.0",
          "display" : "Venditori ambulanti di servizi",
          "definition" : "Le professioni classificate in questa unità offrono servizi di vario genere, esercitano piccoli mestieri di strada, lustrano e riparano scarpe, affilano lame, riparano ombrelli ed altri oggetti per strada, porta a porta o in luoghi pubblici in postazioni non fisse."
        },
        {
          "code" : "8.1.2",
          "display" : "Personale non qualificato di ufficio",
          "definition" : "Le professioni classificate in questa classe supportano, con attività manuali e compiti esecutivi, il lavoro di ufficio, assicurano le procedure di accoglienza e di accompagnamento di clienti e visitatori, ricevono e distribuiscono documenti e materiali dentro e fuori l’organizzazione, provvedono ad effettuare letture di contatori e a raccogliere denaro e monete da distributori automatici o da altri ricevitori."
        },
        {
          "code" : "8.1.2.1",
          "display" : "Uscieri e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria eseguono le procedure di accoglienza di clienti o visitatori presso gli uffici di imprese o organizzazioni, li registrano e li indirizzano verso uffici o impiegati, fornendo loro indicazioni su come arrivarci; ricevono e distribuiscono documenti, materiali e pacchi fra gli uffici o all’esterno; notificano ufficialmente documenti a persone, imprese, organizzazioni o istituzioni accusandone ricevuta."
        },
        {
          "code" : "8.1.2.1.0",
          "display" : "Uscieri e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità accolgono clienti o visitatori presso imprese o organizzazioni, indirizzandoli verso gli uffici di destinazione, fornendo loro indicazioni su come arrivarci; ricevono e distribuiscono documenti, materiali e pacchi fra gli uffici o all’esterno; notificano ufficialmente documenti a persone, imprese, organizzazioni o istituzioni accusandone ricevuta."
        },
        {
          "code" : "8.1.2.2",
          "display" : "Lettori di contatori, collettori di monete e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria provvedono alla lettura dei consumi registrati da contatori presso abitazioni, imprese, organizzazioni o istituzioni trasferendo l’informazione agli uffici competenti; raccolgono monete e denaro da distributori automatici di merci, da parchimetri, biglietterie automatiche e simili o da altri ricevitori; ricaricano di merci o altro materiale i distributori automatici, provvedendo alla loro piccola manutenzione"
        },
        {
          "code" : "8.1.2.2.0",
          "display" : "Lettori di contatori, collettori di monete e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità provvedono alla lettura dei consumi registrati da contatori presso abitazioni, imprese, organizzazioni o istituzioni trasferendo l’informazione agli uffici competenti; raccolgono monete e denaro da distributori automatici di merci, da parchimetri, biglietterie automatiche e simili o da altri ricevitori; ricaricano di merci o altro materiale i distributori automatici, provvedendo alla loro piccola manutenzione."
        },
        {
          "code" : "8.1.3",
          "display" : "Personale non qualificato addetto allo spostamento e alla consegna merci",
          "definition" : "Le professioni classificate nella classe svolgono attività manuali di facchinaggio e di spostamento delle merci di ausilio nelle attività dei magazzini e nelle attività di consegna delle merci e materiali."
        },
        {
          "code" : "8.1.3.1",
          "display" : "Facchini, addetti allo spostamento merci ed assimilati",
          "definition" : "Le professioni classificate in questa categoria provvedono alle operazioni di carico, scarico e movimentazione delle merci all’interno di aeroporti, stazioni ferroviarie, porti, imprese, organizzazioni e per le stesse famiglie; raccolgono e trasportano i bagagli dei viaggiatori e dei clienti di alberghi e di altre strutture ricettive."
        },
        {
          "code" : "8.1.3.1.0",
          "display" : "Facchini, addetti allo spostamento merci ed assimilati",
          "definition" : "Le professioni classificate in questa unità provvedono alle operazioni di carico, scarico e movimentazione delle merci all’interno di aeroporti, stazioni ferroviarie, porti, imprese, organizzazioni e per le stesse famiglie; raccolgono e trasportano i bagagli dei viaggiatori e dei clienti di alberghi e di altre strutture ricettive."
        },
        {
          "code" : "8.1.3.2",
          "display" : "Personale non qualificato addetto all'imballaggio e al magazzino",
          "definition" : "Le professioni classificate in questa categoria supportano le attività dei magazzini imballando e disimballando merci, etichettandole, consegnandole ai clienti o ai commessi, ricevendole dai fornitori e spostandole all’interno del magazzino."
        },
        {
          "code" : "8.1.3.2.0",
          "display" : "Personale non qualificato addetto all'imballaggio e al magazzino",
          "definition" : "Le professioni classificate in questa unità supportano le attività dei magazzini imballando e disimballando merci, etichettandole, consegnandole ai clienti o ai commessi, ricevendole dai fornitori e spostandole all’interno del magazzino."
        },
        {
          "code" : "8.1.3.3",
          "display" : "Addetti alle consegne",
          "definition" : "Le professioni classificate in questa categoria ritirano e consegnano, nelle zone urbane ed extraurbane assegnate, pacchi, documenti e materiali su chiamata diretta."
        },
        {
          "code" : "8.1.3.3.0",
          "display" : "Addetti alle consegne",
          "definition" : "Le professioni classificate in questa unità ritirano e consegnano, nelle zone urbane ed extraurbane assegnate, pacchi, documenti e materiali su chiamata diretta."
        },
        {
          "code" : "8.1.4",
          "display" : "Personale non qualificato nei servizi di pulizia di uffici, alberghi, navi, ristoranti, aree pubbliche e veicoli",
          "definition" : "Le professioni classificate in questa classe curano la pulizia e l'ordine negli esercizi di alloggio e ristorazione, nelle navi, negli uffici, nei negozi e nelle strade; lavano automobili o altri veicoli."
        },
        {
          "code" : "8.1.4.1",
          "display" : "Personale non qualificato addetto alla pulizia nei servizi di alloggio e nelle navi",
          "definition" : "Le professioni classificate in questa categoria cura il riordino e la pulizia delle camere, dei bagni, delle cucine e degli ambienti comuni; provvede alla sostituzione delle lenzuola, degli asciugamani e di altri accessori a disposizione dei clienti."
        },
        {
          "code" : "8.1.4.1.0",
          "display" : "Personale non qualificato addetto alla pulizia nei servizi di alloggio e nelle navi",
          "definition" : "Le professioni classificate in questa unità curano il riordino e la pulizia delle camere, dei bagni, delle cucine e degli ambienti comuni negli alberghi o altri servizi di alloggio e nelle navi; provvedono alla sostituzione delle lenzuola, degli asciugamani e di altri accessori a disposizione dei clienti."
        },
        {
          "code" : "8.1.4.2",
          "display" : "Personale non qualificato nei servizi di ristorazione",
          "definition" : "Le professioni classificate in questa categoria svolgono attività di supporto in cucina, a cuochi e camerieri, lavando le stoviglie, il pentolame, mantenendo pulite le attrezzature, predisponendo gli ingredienti da lavorare e verificandone la disponibilità in dispensa."
        },
        {
          "code" : "8.1.4.2.0",
          "display" : "Personale non qualificato nei servizi di ristorazione",
          "definition" : "Le professioni classificate in questa unità svolgono attività di supporto in cucina, a cuochi e camerieri, lavando le stoviglie, il pentolame, mantenendo pulite le attrezzature, predisponendo gli ingredienti da lavorare e verificandone la disponibilità in dispensa."
        },
        {
          "code" : "8.1.4.3",
          "display" : "Personale non qualificato addetto ai servizi di pulizia di uffici ed esercizi commerciali",
          "definition" : "Le professioni classificate in questa categoria mantengono puliti e in ordine gli ambienti di imprese, organizzazioni, enti pubblici ed esercizi commerciali."
        },
        {
          "code" : "8.1.4.3.0",
          "display" : "Personale non qualificato addetto ai servizi di pulizia di uffici ed esercizi commerciali",
          "definition" : "Le professioni classificate in questa unità mantengono puliti e in ordine gli ambienti di imprese, organizzazioni, enti pubblici ed esercizi commerciali."
        },
        {
          "code" : "8.1.4.4",
          "display" : "Addetti al lavaggio veicoli",
          "definition" : "Le professioni classificate in questa categoria lavano a mano vetri e parti esterne di automobili o altri veicoli; utilizzano aspirapolveri, strumenti di pulitura a secco o detergenti per rimuovere polvere o macchie dalle tappezzerie interne."
        },
        {
          "code" : "8.1.4.4.0",
          "display" : "Addetti al lavaggio veicoli",
          "definition" : "Le professioni classificate in questa unità lavano a mano vetri e parti esterne di automobili o altri veicoli; utilizzano aspirapolveri, strumenti di pulitura a secco o detergenti per rimuovere polvere o macchie dalle tappezzerie interne."
        },
        {
          "code" : "8.1.4.5",
          "display" : "Operatori ecologici e altri raccoglitori e separatori di rifiuti",
          "definition" : "Le professioni classificate in questa categoria provvedono alla raccolta dei rifiuti nelle strade, negli edifici, nelle industrie e nei luoghi pubblici e al loro caricamento sui mezzi di trasporto presso i luoghi di smaltimento, si occupano della raccolta dagli appositi contenitori dei materiali riciclabili e del loro caricamento su mezzi di trasporto."
        },
        {
          "code" : "8.1.4.5.0",
          "display" : "Operatori ecologici e altri raccoglitori e separatori di rifiuti",
          "definition" : "Le professioni classificate in questa unità provvedono alla raccolta dei rifiuti nelle strade, negli edifici, nelle industrie e nei luoghi pubblici e al loro caricamento sui mezzi di trasporto presso i luoghi di smaltimento, si occupano della raccolta dagli appositi contenitori dei materiali riciclabili e del loro caricamento su mezzi di trasporto."
        },
        {
          "code" : "8.1.5",
          "display" : "Personale non qualificato nei servizi di istruzione e sanitari",
          "definition" : "Le professioni classificate in questa classe svolgono compiti e attività manuali non qualificate in strutture scolastiche o sanitarie, sorvegliano e puliscono gli ambienti, eseguono piccole commissioni, trasportano e accudiscono gli ammalati."
        },
        {
          "code" : "8.1.5.1",
          "display" : "Bidelli e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria sorvegliano e mantengono pulite strutture e ambienti scolastici, accolgono e indirizzano i visitatori, consegnano e smistano comunicazioni agli insegnanti, sbrigano piccole commissioni."
        },
        {
          "code" : "8.1.5.1.0",
          "display" : "Bidelli e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità sorvegliano e mantengono pulite strutture e ambienti scolastici, accolgono e indirizzano i visitatori, consegnano e smistano comunicazioni agli insegnanti, sbrigano piccole commissioni."
        },
        {
          "code" : "8.1.5.2",
          "display" : "Portantini e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria trasportano ammalati o utenti all’interno di strutture sanitarie, di ricovero e di lunga degenza per anziani o disabili, si occupano della pulizia degli ambienti e dell’igiene personale degli utenti impossibilitati."
        },
        {
          "code" : "8.1.5.2.0",
          "display" : "Portantini e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità trasportano ammalati o utenti all’interno di strutture sanitarie, di ricovero e di lunga degenza per anziani o disabili; si occupano della pulizia degli ambienti."
        },
        {
          "code" : "8.1.6",
          "display" : "Personale non qualificato addetto ai servizi di custodia di edifici, attrezzature e beni",
          "definition" : "Le professioni classificate in questa classe custodiscono edifici, impianti, attrezzature, merci e beni; vigilano sugli accessi e prevengono l’ingresso di persone indesiderate, svolgono attività di portierato presso condomini privati; sorvegliano gli oggetti lasciati in custodia."
        },
        {
          "code" : "8.1.6.1",
          "display" : "Personale non qualificato addetto ai servizi di custodia di edifici, attrezzature e beni",
          "definition" : "Le professioni classificate in questa classe custodiscono edifici, impianti, attrezzature, merci e beni; vigilano sugli accessi e prevengono l’ingresso di persone indesiderate; svolgono attività di portierato presso condomini privati; sorvegliano gli oggetti lasciati in custodia."
        },
        {
          "code" : "8.1.6.1.1",
          "display" : "Personale non qualificato addetto ai servizi di custodia di edifici",
          "definition" : "Le professioni classificate in questa unità custodiscono edifici, vigilano sugli accessi, prevengono l’ingresso di persone indesiderate, garantiscono il rispetto dei regolamenti segnalando eventuali trasgressioni; svolgono attività di portierato presso condomini privati."
        },
        {
          "code" : "8.1.6.1.2",
          "display" : "Personale non qualificato addetto ai servizi di custodia di impianti",
          "definition" : "Le professioni classificate in questa unità custodiscono impianti, vigilano sugli accessi, garantiscono il rispetto dei regolamenti, prevengono danni o manomissioni segnalando eventuali trasgressioni o situazioni anomale."
        },
        {
          "code" : "8.1.6.1.3",
          "display" : "Personale non qualificato addetto ai servizi di custodia di attrezzature e beni",
          "definition" : "Le professioni classificate in questa unità sorvegliano attrezzature, merci e oggetti lasciati in custodia, prevengono furti o danneggiamenti dei beni segnalando eventuali situazioni anomale."
        },
        {
          "code" : "8.2",
          "display" : "Professioni non qualificate nelle attività domestiche, ricreative e culturali",
          "definition" : "Le professioni comprese in questo gruppo svolgono attività non qualificate nei servizi ricreativi e culturali e nei servizi domestici."
        },
        {
          "code" : "8.2.1",
          "display" : "Personale non qualificato nei servizi ricreativi e culturali",
          "definition" : "Le professioni classificate in questa classe svolgono attività non qualificate di accoglienza, accompagnamento e assistenza dei clienti nella fruizione di servizi ricreativi e culturali."
        },
        {
          "code" : "8.2.1.1",
          "display" : "Personale non qualificato nei servizi ricreativi e culturali",
          "definition" : "Le professioni classificate in questa categoria svolgono attività non qualificate di accoglienza, accompagnamento e assistenza dei clienti nella fruizione di servizi ricreativi e culturali."
        },
        {
          "code" : "8.2.1.1.0",
          "display" : "Personale non qualificato nei servizi ricreativi e culturali",
          "definition" : "Le professioni classificate in questa unità svolgono attività non qualificate di accoglienza, accompagnamento e assistenza dei clienti nella fruizione di servizi ricreativi e culturali, assicurano il corretto uso di attrezzature, mezzi e locali; sorvegliano luoghi e attrezzature garantendo il rispetto dei regolamenti e segnalando eventuali trasgressioni."
        },
        {
          "code" : "8.2.2",
          "display" : "Personale non qualificato addetto ai servizi domestici",
          "definition" : "Le professioni classificate in questa classe mantengono in ordine e puliti gli ambienti domestici, svolgono piccoli lavori di manutenzione della casa; puliscono, smacchiano, lavano e stirano a mano presso le famiglie capi di abbigliamento, di biancheria, tende, materassi, lane e oggetti e materiali simili; fanno la spesa giornaliera, cucinano e servono i pasti."
        },
        {
          "code" : "8.2.2.1",
          "display" : "Collaboratori domestici e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria mantengono in ordine e puliti gli ambienti domestici, svolgono piccoli lavori di manutenzione della casa; puliscono, smacchiano, lavano e stirano a mano presso le famiglie capi di abbigliamento, di biancheria, tende, materassi, lane e oggetti e materiali simili; fanno la spesa giornaliera, cucinano e servono i pasti."
        },
        {
          "code" : "8.2.2.1.0",
          "display" : "Collaboratori domestici e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità mantengono in ordine e puliti gli ambienti domestici, svolgono piccoli lavori di manutenzione della casa; puliscono, smacchiano, lavano e stirano a mano presso le famiglie capi di abbigliamento, di biancheria, tende, materassi, lane e oggetti e materiali simili; fanno la spesa giornaliera, cucinano e servono i pasti."
        },
        {
          "code" : "8.3",
          "display" : "Professioni non qualificate nell'agricoltura, nella manutenzione del verde, nell'allevamento, nella silvicoltura e nella pesca",
          "definition" : "Le professioni classificate in questo gruppo svolgono compiti semplici e routinari per la coltivazione agricola, la manutenzione del verde, l'allevamento, la silvicoltura e la pesca."
        },
        {
          "code" : "8.3.1",
          "display" : "Personale non qualificato nell'agricoltura e nella manutenzione del verde",
          "definition" : "Le professioni classificate in questa classe svolgono compiti semplici e routinari per la coltivazione agricola e per la manutenzione parchi, giardini e delle aree verdi."
        },
        {
          "code" : "8.3.1.1",
          "display" : "Braccianti agricoli",
          "definition" : "Le professioni classificate in questa categoria eseguono lavori manuali non qualificati in agricoltura, vangano il terreno, mantengono pulite le colture, le diserbano manualmente dalle piante infestanti, spostano attrezzi, sementi e prodotti agricoli, caricano e scaricano i mezzi che li trasportano, provvedono a raccogliere i prodotti delle colture, portano acqua e cibo sui campi."
        },
        {
          "code" : "8.3.1.1.0",
          "display" : "Braccianti agricoli",
          "definition" : "Le professioni classificate in questa unità eseguono lavori manuali non qualificati in agricoltura, vangano il terreno, mantengono pulite le colture, le diserbano manualmente dalle piante infestanti, spostano attrezzi, sementi e prodotti agricoli, caricano e scaricano i mezzi che li trasportano, provvedono a raccogliere i prodotti delle colture, portano acqua e cibo sui campi."
        },
        {
          "code" : "8.3.1.2",
          "display" : "Personale non qualificato addetto alla manutenzione del verde",
          "definition" : "Le professioni classificate in questa categoria eseguono lavori manuali non qualificati nella cura di piante, fiori o alberi in parchi pubblici o giardini privati; vangano e irrigano il terreno, mantengono pulite le aiuole, le diserbano manualmente dalle piante infestanti, spostano attrezzi, caricano e scaricano i mezzi che li trasportano."
        },
        {
          "code" : "8.3.1.2.0",
          "display" : "Personale non qualificato addetto alla manutenzione del verde",
          "definition" : "Le professioni classificate in questa unità eseguono lavori manuali non qualificati nella cura di piante, fiori o alberi in parchi pubblici o giardini privati; vangano e irrigano il terreno, mantengono pulite le aiuole, le diserbano manualmente dalle piante infestanti, spostano attrezzi, caricano e scaricano i mezzi che li trasportano."
        },
        {
          "code" : "8.3.2",
          "display" : "Personale non qualificato addetto alle foreste, alla cura degli animali, alla pesca e alla caccia",
          "definition" : "Le professioni classificate in questa classe svolgono compiti semplici e routinari per la cura e l'accompagnamento degli animali, per il mantenimento delle foreste e per la pesca e la caccia."
        },
        {
          "code" : "8.3.2.1",
          "display" : "Personale forestale non qualificato",
          "definition" : "Le professioni classificate in questa categoria svolgono attività manuali non qualificate di scavo del terreno nelle operazioni di rimboschimento e di disboscamento, di pulizia del sottobosco, di taglio della legna, di ripulitura dei tronchi dai rami, di carico del legname sui mezzi di trasporto, di scarico e di stivatura dello stesso."
        },
        {
          "code" : "8.3.2.1.0",
          "display" : "Personale forestale non qualificato",
          "definition" : "Le professioni classificate in questa unità svolgono attività manuali non qualificate di scavo del terreno nelle operazioni di rimboschimento e di disboscamento, di pulizia del sottobosco, di taglio della legna, di ripulitura dei tronchi dai rami, di carico del legname sui mezzi di trasporto, di scarico e di stivatura dello stesso."
        },
        {
          "code" : "8.3.2.2",
          "display" : "Personale non qualificato addetto alla cura degli animali",
          "definition" : "Le professioni classificate in questa categoria svolgono attività manuali non qualificate di cura degli animali, mantengono puliti i luoghi di allevamento, alimentano manualmente le mangiatoie, accompagnano al pascolo il bestiame, lo custodiscono nei luoghi di ricovero, raccolgono manualmente e conservano i prodotti dell’allevamento."
        },
        {
          "code" : "8.3.2.2.0",
          "display" : "Personale non qualificato addetto alla cura degli animali",
          "definition" : "Le professioni classificate in questa unità svolgono attività manuali non qualificate di cura degli animali, mantengono puliti i luoghi di allevamento, alimentano manualmente le mangiatoie, accompagnano al pascolo il bestiame, lo custodiscono nei luoghi di ricovero, raccolgono manualmente e conservano i prodotti dell’allevamento."
        },
        {
          "code" : "8.3.2.3",
          "display" : "Personale non qualificato addetto alla pesca ed alla caccia",
          "definition" : "Le professioni classificate in questa categoria svolgono attività manuali non qualificate di supporto alla pesca in acque interne, costiere o in alto mare e alle attività di ricerca, cattura e abbattimento di selvaggina, stendono e ritirano reti, vagliano e selezionano il pescato, abbattono pesci di grandi dimensioni, fungono da battitori nella caccia, tengono e curano i cani, raccolgono e preparano la selvaggina."
        },
        {
          "code" : "8.3.2.3.0",
          "display" : "Personale non qualificato addetto alla pesca ed alla caccia",
          "definition" : "Le professioni classificate in questa unità svolgono attività manuali non qualificate di supporto alla pesca in acque interne, costiere o in alto mare e alle attività di ricerca, cattura e abbattimento di selvaggina; stendono e ritirano reti, vagliano e selezionano il pescato, abbattono pesci di grandi dimensioni; fungono da battitori nella caccia, tengono e curano i cani, raccolgono e preparano la selvaggina."
        },
        {
          "code" : "8.4",
          "display" : "Professioni non qualificate nella manifattura, nell'estrazione di minerali e nelle costruzioni",
          "definition" : "Le professioni classificate in questo gruppo svolgono compiti semplici e routinari di supporto alle attività manufatturiere, all'estrazione di minerali e alle costruzioni."
        },
        {
          "code" : "8.4.1",
          "display" : "Personale non qualificato delle miniere e delle cave",
          "definition" : "Le professioni classificate in questa classe svolgono compiti semplici e routinari di supporto alle attività di miniere e cave"
        },
        {
          "code" : "8.4.1.1",
          "display" : "Manovali ed altro personale non qualificato delle miniere e delle cave",
          "definition" : "Le professioni classificate in questa categoria svolgono compiti semplici e routinari di supporto alle attività di miniere e cave, caricano e scaricano materiali e attrezzature, li movimentano manualmente, puliscono e lubrificano macchine e attrezzature da estrazione, mantengono sgombra da impedimenti l’area di lavoro."
        },
        {
          "code" : "8.4.1.1.0",
          "display" : "Manovali ed altro personale non qualificato delle miniere e delle cave",
          "definition" : "Le professioni classificate in questa unità svolgono compiti semplici e routinari di supporto alle attività di miniere e cave, caricano e scaricano materiali e attrezzature, li movimentano manualmente, puliscono e lubrificano macchine e attrezzature da estrazione, mantengono sgombra da impedimenti l’area di lavoro."
        },
        {
          "code" : "8.4.2",
          "display" : "Personale non qualificato delle costruzioni e professioni assimilate",
          "definition" : "Le professioni classificate in questa classe svolgono compiti semplici e routinari di supporto alle attività di edilizia civile per la costruzione di edifici, strade, dighe e di altre opere pubbliche."
        },
        {
          "code" : "8.4.2.1",
          "display" : "Manovali e personale non qualificato dell’edilizia civile e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria svolgono lavori manuali non qualificati nell’edilizia civile, caricano e scaricano materiali e attrezzature, li movimentano manualmente, puliscono e preparano i cantieri, porgono le attrezzature e il materiale da costruzione, mantengono sgombra da impedimenti l’area di lavoro, rimuovono macerie e residui."
        },
        {
          "code" : "8.4.2.1.0",
          "display" : "Manovali e personale non qualificato dell’edilizia civile e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità svolgono lavori manuali non qualificati nell’edilizia civile, caricano e scaricano materiali e attrezzature, li movimentano manualmente, puliscono e preparano i cantieri, porgono le attrezzature e il materiale da costruzione, mantengono sgombra da impedimenti l’area di lavoro, rimuovono macerie e residui."
        },
        {
          "code" : "8.4.2.2",
          "display" : "Manovali e personale non qualificato della costruzione e manutenzione di strade, dighe e altre opere pubbliche",
          "definition" : "Le professioni classificate in questa categoria svolgono lavori manuali non qualificati nei cantieri stradali e autostradali, nei lavori di costruzione di dighe, gallerie o di altre grandi opere; caricano e scaricano materiali e attrezzature, li movimentano manualmente, puliscono e preparano i cantieri, scavano e puntellano trincee, porgono attrezzature e materiali da costruzione, mantengono sgombra da impedimenti l’area di lavoro, rimuovono macerie e residui."
        },
        {
          "code" : "8.4.2.2.0",
          "display" : "Manovali e personale non qualificato della costruzione e manutenzione di strade, dighe e altre opere pubbliche",
          "definition" : "Le professioni classificate in questa unità svolgono lavori manuali non qualificati nei cantieri stradali e autostradali, nei lavori di costruzione di dighe, gallerie o di altre grandi opere; caricano e scaricano materiali e attrezzature, li movimentano manualmente, puliscono e preparano i cantieri, scavano e puntellano trincee, porgono attrezzature e materiali da costruzione, mantengono sgombra da impedimenti l’area di lavoro, rimuovono macerie e residui."
        },
        {
          "code" : "8.4.3",
          "display" : "Personale non qualificato nella manifattura",
          "definition" : "Le professioni classificate in questa classe svolgono compiti semplici e di routine di supporto alle attività manifatturiere."
        },
        {
          "code" : "8.4.3.1",
          "display" : "Personale non qualificato delle attività industriali e professioni assimilate",
          "definition" : "Le professioni classificate in questa categoria svolgono lavori manuali non qualificati presso le imprese industriali, porgono utensili e materiali, aiutano a sostenere parti da montare o da lavorare, mantengono in ordine, puliti e lubrificati gli utensili e le attrezzature, sgombra e pulita l'area di lavoro, scaricano e caricano, imballano manualmente materiali e prodotti, smontano e demoliscono oggetti, macchine e attrezzature."
        },
        {
          "code" : "8.4.3.1.0",
          "display" : "Personale non qualificato delle attività industriali e professioni assimilate",
          "definition" : "Le professioni classificate in questa unità svolgono lavori manuali non qualificati presso le imprese industriali, porgono utensili e materiali, aiutano a sostenere parti da montare o da lavorare, mantengono in ordine, puliti e lubrificati gli utensili e le attrezzature, sgombra e pulita l'area di lavoro, scaricano e caricano, imballano manualmente materiali e prodotti, smontano e demoliscono oggetti, macchine e attrezzature."
        }
      ]
    },
    {
      "code" : "9",
      "display" : "FORZE ARMATE",
      "definition" : "Il nono grande gruppo comprende le professioni svolte nell'ambito delle Forze armate (Esercito, Marina, Aeronautica e Carabinieri). Garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra.",
      "concept" : [
        {
          "code" : "9.1",
          "display" : "Ufficiali delle forze armate",
          "definition" : "Le professioni classificate in questo gruppo garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questo gruppo i membri delle Forze Armate con il grado uguale o superiore a quello di Sottotenente (o guardiamarina nel caso della marina militare)."
        },
        {
          "code" : "9.1.1",
          "display" : "Ufficiali delle forze armate",
          "definition" : "Le professioni di questa classe garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questa classe i membri delle Forze Armate con il grado uguale o superiore a quello di Sottotenente (o guardiamarina nel caso della marina militare)"
        },
        {
          "code" : "9.1.1.1",
          "display" : "Ufficiali delle forze armate",
          "definition" : "Le professioni di questa categoria garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questa categoria i membri delle Forze Armate con il grado uguale o superiore a quello di Sottotenente (o Guardiamarina nel caso della marina militare)"
        },
        {
          "code" : "9.1.1.1.0",
          "display" : "Ufficiali delle forze armate",
          "definition" : "Le professioni di questa unità garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questa unità i membri delle Forze Armate con il grado uguale o superiore a quello di Sottotenente (o Guardiamarina nel caso della marina militare)"
        },
        {
          "code" : "9.2",
          "display" : "Sergenti, sovraintendenti e marescialli delle forze armate",
          "definition" : "Le professioni classificate in questo gruppo garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questo gruppo i membri delle Forze Armate con il grado compreso fra Sergente (o Vicebrigadiere nel caso dell'arma dei carabinieri) e Primo Maresciallo Luogotenente ( o M.A.s. UPS Luogotenente nel caso dell'arma dei carabinieri)."
        },
        {
          "code" : "9.2.1",
          "display" : "Sergenti, sovraintendenti e marescialli delle forze armate",
          "definition" : "Le professioni di questa classe garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questa classe i membri delle Forze Armate con il grado compreso fra Sergente (o Vicebrigadiere nel caso dell'arma dei carabinieri) e Primo Maresciallo Luogotenente ( o M.A.s. UPS Luogotenente nel caso dell'arma dei carabinieri)."
        },
        {
          "code" : "9.2.1.1",
          "display" : "Sergenti, sovraintendenti e marescialli delle forze armate",
          "definition" : "Le professioni di questa categoria garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questa categoria i membri delle Forze Armate con il grado compreso fra Sergente (o Vicebrigadiere nel caso dell'arma dei carabinieri) e Primo Maresciallo Luogotenente (o M.A.s. UPS Luogotenente nel caso dell'arma dei carabinieri)."
        },
        {
          "code" : "9.2.1.1.0",
          "display" : "Sergenti, sovraintendenti e marescialli delle forze armate",
          "definition" : "Le professioni di questa unità garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questa unità i membri delle Forze Armate con il grado compreso fra Sergente (o Vicebrigadiere nel caso dell'arma dei carabinieri) e Primo Maresciallo Luogotenente (o M.A.s. UPS Luogotenente nel caso dell'arma dei carabinieri)."
        },
        {
          "code" : "9.3",
          "display" : "Truppa delle forze armate",
          "definition" : "Le professioni classificate in questo gruppo garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questo gruppo i membri delle Forze Armate con grado uguale o inferiore a Caporalmaggiore Capo Scelto (nel caso dell'esercito), Sottocapo di 1° Classe Scelto ( per la marina militare), 1° Aviere Capo Scelto (nel caso dell'Aeronautica Militare) e Appuntato Scelto (per l'arma dei carabinieri)."
        },
        {
          "code" : "9.3.1",
          "display" : "Truppa delle forze armate",
          "definition" : "Le professioni di questa classe garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questa classe i membri delle Forze Armate con grado uguale o inferiore a Caporalmaggiore Capo Scelto (nel caso dell'esercito), Sottocapo di 1° Classe Scelto ( per la marina militare), 1° Aviere Capo Scelto (nel caso dell'Aeronautica Militare) e Appuntato Scelto (per l'arma dei carabinieri)."
        },
        {
          "code" : "9.3.1.1",
          "display" : "Truppa delle forze armate",
          "definition" : "Le professioni di questa categoria garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questa categoria i membri delle Forze Armate con grado uguale o inferiore a Caporalmaggiore Capo Scelto (nel caso dell'esercito), Sottocapo di 1° Classe Scelto ( per la marina militare), 1° Aviere Capo Scelto (nel caso dell'Aeronautica Militare) e Appuntato Scelto (per l'arma dei carabinieri)."
        },
        {
          "code" : "9.3.1.1.0",
          "display" : "Truppa delle forze armate",
          "definition" : "Le professioni di questa unità garantiscono l'integrità territoriale e politica della nazione e la sua sicurezza in tempo di pace e di guerra. Sono compresi in questa unità i membri delle Forze Armate con grado uguale o inferiore a Caporalmaggiore Capo Scelto (nel caso dell'esercito), Sottocapo di 1° Classe Scelto ( per la marina militare), 1° Aviere Capo Scelto (nel caso dell'Aeronautica Militare) e Appuntato Scelto (per l'arma dei carabinieri)."
        }
      ]
    }
  ]
}

```
