# ISTAT - Classificazione dei titoli di studio italiani - HL7 FHIR Implementation Guide Laboratory Report v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISTAT - Classificazione dei titoli di studio italiani**

## CodeSystem: ISTAT - Classificazione dei titoli di studio italiani 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/lab-report/CodeSystem/istat-ctsi03 | *Version*:0.2.0 |
| Active as of 2025-11-18 | *Computable Name*:CsIstatTitoliStudio |

 
ISTAT - Classificazione dei titoli di studio italiani 

 This Code system is referenced in the content logical definition of the following value sets: 

* [VsIstatTitoloStudio](ValueSet-istat-titoloStudio.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "istat-ctsi03",
  "url" : "http://hl7.it/fhir/lab-report/CodeSystem/istat-ctsi03",
  "version" : "0.2.0",
  "name" : "CsIstatTitoliStudio",
  "title" : "ISTAT - Classificazione dei titoli di studio italiani",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-18T15:38:51+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    },
    {
      "name" : "HL7 Italia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.it"
        }
      ]
    }
  ],
  "description" : "ISTAT - Classificazione dei titoli di studio italiani",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT",
          "display" : "Italy"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "10000000",
      "display" : "LICENZA ELEMENTARE"
    },
    {
      "code" : "20000000",
      "display" : "LICENZA MEDIA"
    },
    {
      "code" : "30000000",
      "display" : "TITOLO DI ISTRUZIONE SECONDARIA SUPERIORE (SCOLASTICA ED EXTRA-SCOLASTICA) CHE NON PERMETTE L'ACCESSO ALL'UNIVERSITÀ (qualifica di istituto professionale, licenza di maestro d'arte, abilitazione all'insegnamento nella scuola materna, diploma di danzatore, diploma di conservatorio)"
    },
    {
      "code" : "30100000",
      "display" : "DIPLOMA DI QUALIFICA DI ISTITUTO PROFESSIONALE"
    },
    {
      "code" : "30101000",
      "display" : "Diploma di qualifica di istituto professionale agrario"
    },
    {
      "code" : "30101001",
      "display" : "Allevatore zootecnico"
    },
    {
      "code" : "30101002",
      "display" : "Assistente di azienda agraria"
    },
    {
      "code" : "30101003",
      "display" : "Esperto conserviere"
    },
    {
      "code" : "30101004",
      "display" : "Esperto agricolo"
    },
    {
      "code" : "30101005",
      "display" : "Esperto agrumicoltore"
    },
    {
      "code" : "30101006",
      "display" : "Esperto casaro"
    },
    {
      "code" : "30101007",
      "display" : "Esperto coltivatore"
    },
    {
      "code" : "30101008",
      "display" : "Esperto floricoltore giardiniere"
    },
    {
      "code" : "30101009",
      "display" : "Esperto forestale e apicoltore"
    },
    {
      "code" : "30101010",
      "display" : "Esperto frutticoltore"
    },
    {
      "code" : "30101011",
      "display" : "Esperto olivicoltore"
    },
    {
      "code" : "30101012",
      "display" : "Esperto orticoltore"
    },
    {
      "code" : "30101013",
      "display" : "Esperto tabacchicoltore tecnologo"
    },
    {
      "code" : "30101014",
      "display" : "Esperto viticoltore cantiniere"
    },
    {
      "code" : "30101015",
      "display" : "Meccanico operatore agricolo"
    },
    {
      "code" : "30101016",
      "display" : "Operatore agricolo"
    },
    {
      "code" : "30101017",
      "display" : "Operatore agro industriale"
    },
    {
      "code" : "30101018",
      "display" : "Operatore agro ambientale"
    },
    {
      "code" : "30101019",
      "display" : "Operatore agri turistico"
    },
    {
      "code" : "30101020",
      "display" : "Cantiniere"
    },
    {
      "code" : "30101021",
      "display" : "Analista agricolo"
    },
    {
      "code" : "30101022",
      "display" : "Avifauna"
    },
    {
      "code" : "30101023",
      "display" : "Esperto in produzioni alimentari"
    },
    {
      "code" : "30101024",
      "display" : "Floricoltore"
    },
    {
      "code" : "30101025",
      "display" : "Ortofrutticoltore"
    },
    {
      "code" : "30101026",
      "display" : "Viticoltore"
    },
    {
      "code" : "30101027",
      "display" : "Vivaista"
    },
    {
      "code" : "30101999",
      "display" : "Altre qualifiche di istituto professionale agrario"
    },
    {
      "code" : "30102000",
      "display" : "Diploma di qualifica di istituto professionale per l'industria e l'artigianato"
    },
    {
      "code" : "30102001",
      "display" : "Addetto manutenzione di elaboratori elettronici"
    },
    {
      "code" : "30102002",
      "display" : "Aggiustatore meccanico"
    },
    {
      "code" : "30102003",
      "display" : "Aiuto scenografo"
    },
    {
      "code" : "30102004",
      "display" : "Animatore"
    },
    {
      "code" : "30102005",
      "display" : "Assistente di tessitura"
    },
    {
      "code" : "30102006",
      "display" : "Assistente edile"
    },
    {
      "code" : "30102007",
      "display" : "Carrozziere d'automezzi"
    },
    {
      "code" : "30102008",
      "display" : "Carrozziere e verniciatore a spruzzo"
    },
    {
      "code" : "30102009",
      "display" : "Ceramista industriale"
    },
    {
      "code" : "30102010",
      "display" : "Chimico cermista"
    },
    {
      "code" : "30102011",
      "display" : "Confezionista industriale"
    },
    {
      "code" : "30102012",
      "display" : "Conduttore caldaie"
    },
    {
      "code" : "30102013",
      "display" : "Congegnatore meccanico"
    },
    {
      "code" : "30102014",
      "display" : "Disegnatore edile"
    },
    {
      "code" : "30102015",
      "display" : "Disegnatore meccanico"
    },
    {
      "code" : "30102016",
      "display" : "Disegnatore meccanico con elaboratore"
    },
    {
      "code" : "30102017",
      "display" : "Disegnatore navale"
    },
    {
      "code" : "30102018",
      "display" : "Disegnatore tecnico del marmo"
    },
    {
      "code" : "30102019",
      "display" : "Ebanista mobiliere"
    },
    {
      "code" : "30102020",
      "display" : "Elettrauto"
    },
    {
      "code" : "30102021",
      "display" : "Elettricista di bordo"
    },
    {
      "code" : "30102022",
      "display" : "Elettricista installatore elettromeccanico"
    },
    {
      "code" : "30102023",
      "display" : "Elettronico industriale"
    },
    {
      "code" : "30102024",
      "display" : "Elettronico per telecomunicazione"
    },
    {
      "code" : "30102025",
      "display" : "Fofografo di scena e reporter"
    },
    {
      "code" : "30102026",
      "display" : "Fotografo generico"
    },
    {
      "code" : "30102027",
      "display" : "Fotoincisore"
    },
    {
      "code" : "30102028",
      "display" : "Fotolitografo"
    },
    {
      "code" : "30102029",
      "display" : "Istallatore di impianti idro termali sanitari e riscaldamento"
    },
    {
      "code" : "30102030",
      "display" : "Istallatore di impianti idraulici e termici"
    },
    {
      "code" : "30102031",
      "display" : "Istallatore di apparecchiature elettriche ed elettroniche"
    },
    {
      "code" : "30102032",
      "display" : "Litoimpressore"
    },
    {
      "code" : "30102033",
      "display" : "Liutaio"
    },
    {
      "code" : "30102034",
      "display" : "Massiofisioterapista"
    },
    {
      "code" : "30102035",
      "display" : "Meccanico fresatore"
    },
    {
      "code" : "30102036",
      "display" : "Meccanico impianti a gas"
    },
    {
      "code" : "30102037",
      "display" : "Meccanico magliere"
    },
    {
      "code" : "30102038",
      "display" : "Meccanico orologiaio"
    },
    {
      "code" : "30102039",
      "display" : "Meccanico riparatore autoveicoli"
    },
    {
      "code" : "30102040",
      "display" : "Meccanico tornitore"
    },
    {
      "code" : "30102041",
      "display" : "Modellista di fonderia"
    },
    {
      "code" : "30102042",
      "display" : "Montatore d'auto"
    },
    {
      "code" : "30102043",
      "display" : "Montatore riparatore apparecchi radio tv"
    },
    {
      "code" : "30102044",
      "display" : "Montatore riparatore impianti telefonici"
    },
    {
      "code" : "30102045",
      "display" : "Muratore"
    },
    {
      "code" : "30102046",
      "display" : "Operatore meccanico odontotecnico"
    },
    {
      "code" : "30102047",
      "display" : "Operatore macchine utensili"
    },
    {
      "code" : "30102048",
      "display" : "Operatore chimico"
    },
    {
      "code" : "30102049",
      "display" : "Operatore e cameramen"
    },
    {
      "code" : "30102050",
      "display" : "Operatore della moda"
    },
    {
      "code" : "30102051",
      "display" : "Operatore chimico biologico"
    },
    {
      "code" : "30102052",
      "display" : "Operatore edile"
    },
    {
      "code" : "30102053",
      "display" : "Operatore elettrico"
    },
    {
      "code" : "30102054",
      "display" : "Operatore elettronico"
    },
    {
      "code" : "30102055",
      "display" : "Operatore meccanico"
    },
    {
      "code" : "30102056",
      "display" : "Operatore meccanico orafo"
    },
    {
      "code" : "30102057",
      "display" : "Operatore meccanico ottico"
    },
    {
      "code" : "30102058",
      "display" : "Preparatore analista laboratorio chimico biologico"
    },
    {
      "code" : "30102059",
      "display" : "Programmatore"
    },
    {
      "code" : "30102060",
      "display" : "Segretario produzione edizione"
    },
    {
      "code" : "30102061",
      "display" : "Siderurgico"
    },
    {
      "code" : "30102062",
      "display" : "Tipocompositore"
    },
    {
      "code" : "30102063",
      "display" : "Tipoimpressore"
    },
    {
      "code" : "30102064",
      "display" : "Tornitore"
    },
    {
      "code" : "30102065",
      "display" : "Elettricista addetto impianti siderurgici"
    },
    {
      "code" : "30102066",
      "display" : "Assistente di filatura"
    },
    {
      "code" : "30102067",
      "display" : "Operatore della comunicazione audiovisiva"
    },
    {
      "code" : "30102068",
      "display" : "Operatore delle telecomunicazioni"
    },
    {
      "code" : "30102069",
      "display" : "Operatore termico"
    },
    {
      "code" : "30102070",
      "display" : "Operatore industria mobile e arredamento"
    },
    {
      "code" : "30102071",
      "display" : "Operatore dell'artigianato del marmo"
    },
    {
      "code" : "30102072",
      "display" : "Operatore dell'industrie ceramiche"
    },
    {
      "code" : "30102073",
      "display" : "Operatore per l'industria grafica"
    },
    {
      "code" : "30102074",
      "display" : "Operatore fotografico"
    },
    {
      "code" : "30102075",
      "display" : "Meccanico addetto alle macchine utensili a controllo numerico"
    },
    {
      "code" : "30102076",
      "display" : "Operatore dell'industria del marmo"
    },
    {
      "code" : "30102077",
      "display" : "Operatore dell'industria dolciaria"
    },
    {
      "code" : "30102078",
      "display" : "Operatore dell'industria molitoria"
    },
    {
      "code" : "30102079",
      "display" : "Apparecchiatore elettronico"
    },
    {
      "code" : "30102080",
      "display" : "Tecnico di sistemi digitali per procedure automatizzate"
    },
    {
      "code" : "30102081",
      "display" : "Meccanico addetto ai circuiti fluidodinamici"
    },
    {
      "code" : "30102082",
      "display" : "Meccanico armaiolo"
    },
    {
      "code" : "30102083",
      "display" : "Meccanico siderurgico"
    },
    {
      "code" : "30102084",
      "display" : "Meccanico strumentista"
    },
    {
      "code" : "30102085",
      "display" : "Arredatore e tecnico espositore"
    },
    {
      "code" : "30102086",
      "display" : "Decoratore procellana e ceramica"
    },
    {
      "code" : "30102087",
      "display" : "Disegnatore animatore"
    },
    {
      "code" : "30102088",
      "display" : "Disegnatore scenografo"
    },
    {
      "code" : "30102089",
      "display" : "Fonico"
    },
    {
      "code" : "30102090",
      "display" : "Fotoriproduttore"
    },
    {
      "code" : "30102091",
      "display" : "Addetto conservazione distribuzione prodotti alimentari"
    },
    {
      "code" : "30102092",
      "display" : "Specialista del marmo in architettura"
    },
    {
      "code" : "30102093",
      "display" : "Addetta agli uffici per l'architettura e l'arredamento"
    },
    {
      "code" : "30102094",
      "display" : "Disegnatrice grafico pubblicitaria"
    },
    {
      "code" : "30102095",
      "display" : "Figurinista"
    },
    {
      "code" : "30102096",
      "display" : "Modellista confezionista"
    },
    {
      "code" : "30102097",
      "display" : "Operatore grafico pubblicitario"
    },
    {
      "code" : "30102098",
      "display" : "Biancherista"
    },
    {
      "code" : "30102099",
      "display" : "Conduttore di macchine agricole"
    },
    {
      "code" : "30102100",
      "display" : "Galvanotecnico"
    },
    {
      "code" : "30102101",
      "display" : "Ferraiolo"
    },
    {
      "code" : "30102102",
      "display" : "Tracciatore di sala"
    },
    {
      "code" : "30102103",
      "display" : "Legatore di libri"
    },
    {
      "code" : "30102104",
      "display" : "Linotipista"
    },
    {
      "code" : "30102999",
      "display" : "Altre qualifiche di istituto professionale per l'industria e l'artigianato"
    },
    {
      "code" : "30103000",
      "display" : "Diploma di qualifica di istituto professionale marinaro"
    },
    {
      "code" : "30103001",
      "display" : "Frigorista di bordo"
    },
    {
      "code" : "30103002",
      "display" : "Meccanico navale"
    },
    {
      "code" : "30103003",
      "display" : "Padrone marittimo traffico e pesca"
    },
    {
      "code" : "30103004",
      "display" : "Radiotelegrafista di bordo"
    },
    {
      "code" : "30103005",
      "display" : "Operatore del mare"
    },
    {
      "code" : "30103006",
      "display" : "Operatote termico ad indirizzo marittimo"
    },
    {
      "code" : "30103007",
      "display" : "Addetto ai servizi alberghieri di cucina di bordo"
    },
    {
      "code" : "30103008",
      "display" : "Addetto ai servizi sala e bar di bordo"
    },
    {
      "code" : "30103009",
      "display" : "Tracciatore navale"
    },
    {
      "code" : "30103999",
      "display" : "Altre qualifiche di istituto professionale marinaro"
    },
    {
      "code" : "40102006",
      "display" : "Tecnico industrie chimiche"
    },
    {
      "code" : "40102007",
      "display" : "Tecnico delle industrie elettriche elettroniche"
    },
    {
      "code" : "40102008",
      "display" : "Tecnico industrie grafiche"
    },
    {
      "code" : "40102009",
      "display" : "Tecnico industrie meccaniche"
    },
    {
      "code" : "40102010",
      "display" : "Tecnico industrie meccaniche autoveicoli"
    },
    {
      "code" : "40102011",
      "display" : "Tecnico lavorazioni ceramiche"
    },
    {
      "code" : "40102012",
      "display" : "Tecnico industria mobile e arredamento"
    },
    {
      "code" : "40102013",
      "display" : "Tecnico laboratorio chimico biologico"
    },
    {
      "code" : "40102014",
      "display" : "Tecnico di radiologia medica"
    },
    {
      "code" : "40102015",
      "display" : "Tecnico dei sistemi energetici"
    },
    {
      "code" : "40102016",
      "display" : "Tecnico abbigliamento e moda"
    },
    {
      "code" : "40102017",
      "display" : "Tecnico gestione aziendale"
    },
    {
      "code" : "40102018",
      "display" : "Tecnico servizi ristorazione e servizi turistici"
    },
    {
      "code" : "40102019",
      "display" : "Tecnico servizi sociali"
    },
    {
      "code" : "40102020",
      "display" : "Tecnico produz. immagini fotografiche"
    },
    {
      "code" : "40102021",
      "display" : "Tecnico dell'edilizia"
    },
    {
      "code" : "40102022",
      "display" : "Tecnico di liuteria"
    },
    {
      "code" : "40102023",
      "display" : "Tecnico dell'industria audiovisiva"
    },
    {
      "code" : "40102024",
      "display" : "Tecnico dell'industria orafa"
    },
    {
      "code" : "40102025",
      "display" : "Tecnico del marmo"
    },
    {
      "code" : "40102999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo professionale per l'industria e l'artigianato"
    },
    {
      "code" : "40103000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo professionale marinaro"
    },
    {
      "code" : "40103001",
      "display" : "Tecnico della pesca, cultura ittica e ambiente marino"
    },
    {
      "code" : "40103002",
      "display" : "Tecnico dei sistemi energetici"
    },
    {
      "code" : "40103003",
      "display" : "Tecnico abbigliamento e moda"
    },
    {
      "code" : "40103004",
      "display" : "Tecnico delle industrie elettriche ed elettroniche"
    },
    {
      "code" : "40103999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo professionale marinaro"
    },
    {
      "code" : "40104000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo professionale per il commercio"
    },
    {
      "code" : "40104001",
      "display" : "Analista contabile"
    },
    {
      "code" : "40104002",
      "display" : "Operatore commerciale"
    },
    {
      "code" : "40104003",
      "display" : "Operatore commerciale prodotti alimentari"
    },
    {
      "code" : "40104004",
      "display" : "Operatore turistico"
    },
    {
      "code" : "40104005",
      "display" : "Segretario amministrazione"
    },
    {
      "code" : "40104006",
      "display" : "Dirigenti di comunità"
    },
    {
      "code" : "40104007",
      "display" : "Agrotecnico"
    },
    {
      "code" : "40104008",
      "display" : "Tecnico gestione aziendale"
    },
    {
      "code" : "40104009",
      "display" : "Tecnico industrie meccaniche"
    },
    {
      "code" : "40104010",
      "display" : "Tecnico abbigliamento e moda"
    },
    {
      "code" : "40104011",
      "display" : "Tecnico servizi ristorazione e servizi turistici"
    },
    {
      "code" : "40104012",
      "display" : "Odontotecnico"
    },
    {
      "code" : "40104013",
      "display" : "Tecnico chimico e biologico"
    },
    {
      "code" : "40104014",
      "display" : "Tecnico della grafica pubblicitaria"
    },
    {
      "code" : "40104999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo professionale per il commercio"
    },
    {
      "code" : "40105000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo professionale alberghiero"
    },
    {
      "code" : "40105001",
      "display" : "Tecnico servizi ristorazione e servizi turistici"
    },
    {
      "code" : "40105002",
      "display" : "Agrotecnico"
    },
    {
      "code" : "40105003",
      "display" : "Tecnico gestione aziendale"
    },
    {
      "code" : "40105004",
      "display" : "Tecnico industrie meccaniche"
    },
    {
      "code" : "40105005",
      "display" : "Tecnico abbigliamento e moda"
    },
    {
      "code" : "40105006",
      "display" : "Dirigenti di comunità"
    },
    {
      "code" : "40105007",
      "display" : "Tecnico dell'arte bianca"
    },
    {
      "code" : "40105999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo professionale alberghiero"
    },
    {
      "code" : "40106000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo professionale femminile/per i servizi sociali"
    },
    {
      "code" : "40106001",
      "display" : "Assist. comunità infantile"
    },
    {
      "code" : "40106002",
      "display" : "Disegnatrice stilista moda"
    },
    {
      "code" : "40106003",
      "display" : "Dirigenti di comunità"
    },
    {
      "code" : "40201006",
      "display" : "Valorizzazione produzione animale"
    },
    {
      "code" : "40201007",
      "display" : "Vivaismo colture produttive"
    },
    {
      "code" : "40201008",
      "display" : "Produzioni biologiche e risorse naturali"
    },
    {
      "code" : "40201999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo tecnico agrario"
    },
    {
      "code" : "40202000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo tecnico industriale"
    },
    {
      "code" : "40202001",
      "display" : "Arti fotografiche"
    },
    {
      "code" : "40202002",
      "display" : "Chimica conciara"
    },
    {
      "code" : "40202003",
      "display" : "Chimica industriale"
    },
    {
      "code" : "40202004",
      "display" : "Chimica nucleare"
    },
    {
      "code" : "40202005",
      "display" : "Confezione industriale"
    },
    {
      "code" : "40202006",
      "display" : "Costruzioni aeronautiche"
    },
    {
      "code" : "40202007",
      "display" : "Cronometria"
    },
    {
      "code" : "40202008",
      "display" : "Disegni di tessuti"
    },
    {
      "code" : "40202009",
      "display" : "Edilizia"
    },
    {
      "code" : "40202010",
      "display" : "Elettronica industriale"
    },
    {
      "code" : "40202011",
      "display" : "Eletttrotecnica"
    },
    {
      "code" : "40202012",
      "display" : "Energia nucleare"
    },
    {
      "code" : "40202013",
      "display" : "Fisica industriale"
    },
    {
      "code" : "40202014",
      "display" : "Industria cartaria"
    },
    {
      "code" : "40202015",
      "display" : "Industria cerealicola"
    },
    {
      "code" : "40202016",
      "display" : "Industria metalmeccanica"
    },
    {
      "code" : "40202017",
      "display" : "Industria meccanica"
    },
    {
      "code" : "40202018",
      "display" : "Industria mineraria"
    },
    {
      "code" : "40202019",
      "display" : "Industria navalmeccanica"
    },
    {
      "code" : "40202020",
      "display" : "Industria ottica"
    },
    {
      "code" : "40202021",
      "display" : "Industria tessile"
    },
    {
      "code" : "40202022",
      "display" : "Industria tintoria"
    },
    {
      "code" : "40202023",
      "display" : "Informatica"
    },
    {
      "code" : "40202024",
      "display" : "Maglieria"
    },
    {
      "code" : "40202025",
      "display" : "Materie plastiche"
    },
    {
      "code" : "40202026",
      "display" : "Meccanica"
    },
    {
      "code" : "40202027",
      "display" : "Meccanica di precisione"
    },
    {
      "code" : "40202028",
      "display" : "Metallurgia"
    },
    {
      "code" : "40202029",
      "display" : "Tecnologie alimentari"
    },
    {
      "code" : "40202030",
      "display" : "Elettronica e telecomunicazioni"
    },
    {
      "code" : "40202031",
      "display" : "Termotenica"
    },
    {
      "code" : "40202032",
      "display" : "Chimico biologico"
    },
    {
      "code" : "40202033",
      "display" : "Elettrotecnica ed automazione"
    },
    {
      "code" : "40202034",
      "display" : "Tessile"
    },
    {
      "code" : "40202035",
      "display" : "Arte della grafica pubblicitaria"
    },
    {
      "code" : "40202036",
      "display" : "Agro-industriale"
    },
    {
      "code" : "40202037",
      "display" : "Navigazione aerea"
    },
    {
      "code" : "40202038",
      "display" : "Assistenza navigazione aerea"
    },
    {
      "code" : "40202039",
      "display" : "Arti grafiche"
    },
    {
      "code" : "40202040",
      "display" : "Economico aziendale amministrativo"
    },
    {
      "code" : "40202041",
      "display" : "Geometri"
    },
    {
      "code" : "40202042",
      "display" : "Linguistico"
    },
    {
      "code" : "40202043",
      "display" : "Scientifico"
    },
    {
      "code" : "40202044",
      "display" : "Tecnologico meccanico"
    },
    {
      "code" : "40202045",
      "display" : "Biologico sanitario"
    },
    {
      "code" : "40202046",
      "display" : "Ambiente"
    },
    {
      "code" : "40202047",
      "display" : "Area sistema moda"
    },
    {
      "code" : "40202048",
      "display" : "Tecnico  per l'abbigliamento"
    },
    {
      "code" : "40202999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo tecnico industriale"
    },
    {
      "code" : "40203000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo tecnico nautico"
    },
    {
      "code" : "40203001",
      "display" : "Capitani"
    },
    {
      "code" : "40203002",
      "display" : "Macchinisti"
    },
    {
      "code" : "40203003",
      "display" : "Costruttori navali"
    },
    {
      "code" : "40203004",
      "display" : "Amministrativo"
    },
    {
      "code" : "40203005",
      "display" : "Mercantile"
    },
    {
      "code" : "40203006",
      "display" : "Geometri"
    },
    {
      "code" : "40203007",
      "display" : "Imprenditore marittimo"
    },
    {
      "code" : "40203008",
      "display" : "Trasporti marittimi"
    },
    {
      "code" : "40203009",
      "display" : "Tecnico  del mare"
    },
    {
      "code" : "40203999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo tecnico nautico"
    },
    {
      "code" : "40204000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo tecnico aereonautico"
    },
    {
      "code" : "40204001",
      "display" : "Navigazione aerea"
    },
    {
      "code" : "40204002",
      "display" : "Assistenza navigazione aerea"
    },
    {
      "code" : "40204999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo tecnico aeronautico"
    },
    {
      "code" : "40205000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo tecnico commerciale"
    },
    {
      "code" : "40205001",
      "display" : "Amministrativo"
    },
    {
      "code" : "40205002",
      "display" : "Mercantile"
    },
    {
      "code" : "40205003",
      "display" : "Programmatori"
    },
    {
      "code" : "40205004",
      "display" : "Commercio con l'estero"
    },
    {
      "code" : "40205005",
      "display" : "Amministrazione industriale"
    },
    {
      "code" : "40205006",
      "display" : "Mercantile per l'amministrazione Industriale"
    },
    {
      "code" : "40205007",
      "display" : "Arte della grafica pubblicitaria"
    },
    {
      "code" : "40205008",
      "display" : "Biologico chimico"
    },
    {
      "code" : "40205009",
      "display" : "Costruzioni"
    },
    {
      "code" : "40205010",
      "display" : "Economico aziendale amministrativo"
    },
    {
      "code" : "40205011",
      "display" : "Elettrotecnica ed automazione"
    },
    {
      "code" : "40205012",
      "display" : "Geometri"
    },
    {
      "code" : "40205013",
      "display" : "Giuridico economico aziendale"
    },
    {
      "code" : "40205014",
      "display" : "Informatico elettronico"
    },
    {
      "code" : "40205015",
      "display" : "Linguistico"
    },
    {
      "code" : "40205016",
      "display" : "Matematico scientifico"
    },
    {
      "code" : "40205017",
      "display" : "Periti aziendali corrispondenti in lingue estere"
    },
    {
      "code" : "40205018",
      "display" : "Scientifico"
    },
    {
      "code" : "40205019",
      "display" : "Dirigenti di comunità"
    },
    {
      "code" : "40205020",
      "display" : "Edile"
    },
    {
      "code" : "40205021",
      "display" : "Turismo"
    },
    {
      "code" : "40205022",
      "display" : "Psico- socio-pedagogico"
    },
    {
      "code" : "40205023",
      "display" : "Tecnologie telematiche multimediali"
    },
    {
      "code" : "40205999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo tecnico commerciale"
    },
    {
      "code" : "40206000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo tecnico per geometri"
    },
    {
      "code" : "40206001",
      "display" : "Geometri"
    },
    {
      "code" : "40206002",
      "display" : "Amministrativo"
    },
    {
      "code" : "40206003",
      "display" : "Costruzioni"
    },
    {
      "code" : "40206004",
      "display" : "Giuridico economico aziendale"
    },
    {
      "code" : "40206005",
      "display" : "Programmatori"
    },
    {
      "code" : "40206006",
      "display" : "Edile"
    },
    {
      "code" : "40206999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo tecnico per geometri"
    },
    {
      "code" : "40207000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo tecnico per il turismo"
    },
    {
      "code" : "40207001",
      "display" : "Turismo"
    },
    {
      "code" : "40207002",
      "display" : "Linguistico"
    },
    {
      "code" : "40207003",
      "display" : "Economico aziendale turistico"
    },
    {
      "code" : "40207999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo tecnico per il turismo"
    },
    {
      "code" : "40208000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo perito aziendale e corrispondente in lingue estere"
    },
    {
      "code" : "40208001",
      "display" : "Linguistico aziendale turistico"
    },
    {
      "code" : "40208999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo perito aziendale e corrispondente in lingue estere"
    },
    {
      "code" : "40209000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo tecnico femminile"
    },
    {
      "code" : "40209001",
      "display" : "Indirizzo generale"
    },
    {
      "code" : "40209002",
      "display" : "Econome dietiste"
    },
    {
      "code" : "40209003",
      "display" : "Dirigenti di comunità"
    },
    {
      "code" : "40209004",
      "display" : "Tecnico dei servizi sociali"
    },
    {
      "code" : "40209005",
      "display" : "Linguistico"
    },
    {
      "code" : "40209006",
      "display" : "Periti aziendali corrispondenti in lingue estere"
    },
    {
      "code" : "40209007",
      "display" : "Biologico chimico"
    },
    {
      "code" : "40209008",
      "display" : "Scientifico"
    },
    {
      "code" : "40209009",
      "display" : "Psico- socio-pedagogico"
    },
    {
      "code" : "40209010",
      "display" : "Giuridico economico aziendale"
    },
    {
      "code" : "40209011",
      "display" : "Nuove opportunità integrate"
    },
    {
      "code" : "40209012",
      "display" : "Salute"
    },
    {
      "code" : "40209999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo tecnico femminile e per attività sociali"
    },
    {
      "code" : "40300000",
      "display" : "ISTRUZIONE MAGISTRALE"
    },
    {
      "code" : "40301000",
      "display" : "Diploma di istruzione secondaria superiore di Scuola magistrale"
    },
    {
      "code" : "40301001",
      "display" : "Assistente comunità infantile"
    },
    {
      "code" : "40301002",
      "display" : "Tecnico servizi sociali"
    },
    {
      "code" : "30104000",
      "display" : "Diploma di qualifica di istituto professionale per il commercio"
    },
    {
      "code" : "30104001",
      "display" : "Accompagnatore turistico"
    },
    {
      "code" : "30104002",
      "display" : "Addetto uffici assicurativi"
    },
    {
      "code" : "30104003",
      "display" : "Addetto uffici turistici"
    },
    {
      "code" : "30104004",
      "display" : "Addetto conservazione distribuzione prodotti alimentari"
    },
    {
      "code" : "30104005",
      "display" : "Addetto contabilità azienda"
    },
    {
      "code" : "30104006",
      "display" : "Addetto segreteria azienda"
    },
    {
      "code" : "30104007",
      "display" : "Addetto aziende spedizione trasporto"
    },
    {
      "code" : "30104008",
      "display" : "Applicati servizi amm.vi"
    },
    {
      "code" : "30104009",
      "display" : "Centralinista telefonico"
    },
    {
      "code" : "30104010",
      "display" : "Operatore ai servizi di cucina"
    },
    {
      "code" : "30104011",
      "display" : "Operatore ai servizi di sala bar"
    },
    {
      "code" : "30104012",
      "display" : "Operatore ai servizi di segreteria ricevimento"
    },
    {
      "code" : "30104013",
      "display" : "Operatore alla gestione aziendale"
    },
    {
      "code" : "30104014",
      "display" : "Operatore dell'impresa turistica"
    },
    {
      "code" : "30104015",
      "display" : "Stenodattilografo"
    },
    {
      "code" : "30104999",
      "display" : "Altre qualifiche di istituto professionale per il commercio"
    },
    {
      "code" : "30105000",
      "display" : "Diploma di qualifica di istituto professionale alberghiero"
    },
    {
      "code" : "30105001",
      "display" : "Addetto ai servizi alberghieri di cucina"
    },
    {
      "code" : "30105002",
      "display" : "Addetto servizi alberghieri sala e bar"
    },
    {
      "code" : "30105003",
      "display" : "Addetto alla portineria d'albergo"
    },
    {
      "code" : "30105004",
      "display" : "Addetto segreteria amministrazione d'albergo"
    },
    {
      "code" : "30105005",
      "display" : "Operatore servizi ristorazione (cucina)"
    },
    {
      "code" : "30105006",
      "display" : "Operatore servizi ristorazione (sala bar)"
    },
    {
      "code" : "30105007",
      "display" : "Operatore dei servizi di ricevimento"
    },
    {
      "code" : "30105999",
      "display" : "Altre qualifiche di istituto professionale alberghiero"
    },
    {
      "code" : "30106000",
      "display" : "Diploma di qualifica di istituto professionale femminile/per i servizi sociali"
    },
    {
      "code" : "30106001",
      "display" : "Addetta agli uffici del settore pubblicitario"
    },
    {
      "code" : "30106002",
      "display" : "Addetta agli uffici per l'architettura e l'arredamento"
    },
    {
      "code" : "30106003",
      "display" : "Addetta ai servizi ausiliari di alberghi e pensioni"
    },
    {
      "code" : "30106004",
      "display" : "Addetta ai servizi di assistenza familiare e sociale"
    },
    {
      "code" : "30106005",
      "display" : "Addetta alla vendita e alla vetrina"
    },
    {
      "code" : "30106006",
      "display" : "Assistente per l'infanzia"
    },
    {
      "code" : "30106007",
      "display" : "Cosmetista estetista"
    },
    {
      "code" : "30106008",
      "display" : "Disegnatrice grafico pubblicitaria"
    },
    {
      "code" : "30106009",
      "display" : "Figurinista"
    },
    {
      "code" : "30106010",
      "display" : "Maglierista"
    },
    {
      "code" : "30106011",
      "display" : "Preparatrice di laboratorio chimico biologico"
    },
    {
      "code" : "30106012",
      "display" : "Sarta per donna e bambini"
    },
    {
      "code" : "30106013",
      "display" : "Operatore dei servizi sociali"
    },
    {
      "code" : "30106014",
      "display" : "Modellista confezionista"
    },
    {
      "code" : "30106015",
      "display" : "Operatore grafico pubblicitario"
    },
    {
      "code" : "30106999",
      "display" : "Altre qualifiche di istituto professionale femminile"
    },
    {
      "code" : "30301000",
      "display" : "DIPLOMA DI ABILITAZIONE ALL'INSEGNAMENTO NELLA SCUOLA MATERNA"
    },
    {
      "code" : "30600000",
      "display" : "ISTRUZIONE ARTISTICA"
    },
    {
      "code" : "30601000",
      "display" : "LICENZA DI MAESTRO D'ARTE"
    },
    {
      "code" : "30601001",
      "display" : "Arte dei metalli"
    },
    {
      "code" : "30601002",
      "display" : "Arte dei metalli ed orificeria"
    },
    {
      "code" : "30601003",
      "display" : "Arte dei rivestimenti ceramici edilizi"
    },
    {
      "code" : "30601004",
      "display" : "Arte dell'alabastro"
    },
    {
      "code" : "30601005",
      "display" : "Arte della ceramica"
    },
    {
      "code" : "30601006",
      "display" : "Arte grafica pubblicitaria e fotografia"
    },
    {
      "code" : "30601007",
      "display" : "Arte della porcellana"
    },
    {
      "code" : "30601008",
      "display" : "Arte dell'arredamento"
    },
    {
      "code" : "30601009",
      "display" : "Arte della stampa"
    },
    {
      "code" : "30601010",
      "display" : "Arte del corallo"
    },
    {
      "code" : "30601011",
      "display" : "Arte del gres"
    },
    {
      "code" : "30601012",
      "display" : "Arte del legno"
    },
    {
      "code" : "30601013",
      "display" : "Arte del legno e restauro del mobile antico"
    },
    {
      "code" : "30601014",
      "display" : "Arte del merletto e ricamo"
    },
    {
      "code" : "30601015",
      "display" : "Arte del mobile"
    },
    {
      "code" : "30601016",
      "display" : "Arte del mosaico"
    },
    {
      "code" : "30601017",
      "display" : "Arte del tessuto"
    },
    {
      "code" : "30601018",
      "display" : "Arte del vetro"
    },
    {
      "code" : "30601019",
      "display" : "Arte del vetro e cristallo"
    },
    {
      "code" : "30601020",
      "display" : "Arte delle pietre dure"
    },
    {
      "code" : "30601021",
      "display" : "Arte pubblicitaria"
    },
    {
      "code" : "30601022",
      "display" : "Arti grafiche"
    },
    {
      "code" : "30601023",
      "display" : "Calcografia"
    },
    {
      "code" : "30601024",
      "display" : "Comunicazioni visive"
    },
    {
      "code" : "30601025",
      "display" : "Decorazione pittorica"
    },
    {
      "code" : "30601026",
      "display" : "Decorazione plastica"
    },
    {
      "code" : "30601027",
      "display" : "Design per ambiente"
    },
    {
      "code" : "30601028",
      "display" : "Disegnatori d'architettura"
    },
    {
      "code" : "30601029",
      "display" : "Disegnatori architettura e arredamento"
    },
    {
      "code" : "30601030",
      "display" : "Disegno animato"
    },
    {
      "code" : "30601031",
      "display" : "Arte della Fotografia"
    },
    {
      "code" : "30601032",
      "display" : "Litografia"
    },
    {
      "code" : "30601033",
      "display" : "Arte della Moda e costume"
    },
    {
      "code" : "30601034",
      "display" : "Oreficeria"
    },
    {
      "code" : "30601035",
      "display" : "Restauro ceramico"
    },
    {
      "code" : "30601036",
      "display" : "Rilegatura artistica e restauro del libro"
    },
    {
      "code" : "30601037",
      "display" : "Scenotecnica"
    },
    {
      "code" : "30601038",
      "display" : "Tecnologia ceramica"
    },
    {
      "code" : "30601039",
      "display" : "Xilografia"
    },
    {
      "code" : "30601040",
      "display" : "Operatore di liuteria"
    },
    {
      "code" : "30601999",
      "display" : "Altre licenze di maestro d'arte"
    },
    {
      "code" : "30606000",
      "display" : "DIPLOMA DI CONSERVATORIO MUSICALE"
    },
    {
      "code" : "30606001",
      "display" : "Arpa"
    },
    {
      "code" : "30606002",
      "display" : "Basso tuba"
    },
    {
      "code" : "30606003",
      "display" : "Biblioteconomia e bibliografia musicale"
    },
    {
      "code" : "30606004",
      "display" : "Canto"
    },
    {
      "code" : "30606005",
      "display" : "Chitarra"
    },
    {
      "code" : "30606006",
      "display" : "Clarinetto"
    },
    {
      "code" : "30606007",
      "display" : "Clavicembalo, clavicordo e fortepiano"
    },
    {
      "code" : "30606008",
      "display" : "Composizione"
    },
    {
      "code" : "30606009",
      "display" : "Contrabbasso"
    },
    {
      "code" : "30606010",
      "display" : "Corno"
    },
    {
      "code" : "30606011",
      "display" : "Didattica della Musica"
    },
    {
      "code" : "30606012",
      "display" : "Direzione d'Orchestra"
    },
    {
      "code" : "30606013",
      "display" : "Fagotto"
    },
    {
      "code" : "30606014",
      "display" : "Fisarmonica"
    },
    {
      "code" : "30606015",
      "display" : "Flauto"
    },
    {
      "code" : "30606016",
      "display" : "Flauto dolce"
    },
    {
      "code" : "30606017",
      "display" : "Jazz"
    },
    {
      "code" : "30606018",
      "display" : "Lettura della partitura"
    },
    {
      "code" : "30606019",
      "display" : "Lied ed oratorio"
    },
    {
      "code" : "30606020",
      "display" : "Liuto"
    },
    {
      "code" : "30606021",
      "display" : "Maestro sostituto collaboratore"
    },
    {
      "code" : "30606022",
      "display" : "Mandolino"
    },
    {
      "code" : "30606023",
      "display" : "Musica corale e direzione coro"
    },
    {
      "code" : "30606024",
      "display" : "Musica da camera"
    },
    {
      "code" : "30606025",
      "display" : "Musica elettronica"
    },
    {
      "code" : "30606026",
      "display" : "Musica vocale da camera"
    },
    {
      "code" : "30606027",
      "display" : "Musicologia"
    },
    {
      "code" : "30606028",
      "display" : "Oboe"
    },
    {
      "code" : "30606029",
      "display" : "Organo e composizione organistica"
    },
    {
      "code" : "30606030",
      "display" : "Pianoforte"
    },
    {
      "code" : "30606031",
      "display" : "Prepolifonia"
    },
    {
      "code" : "30606032",
      "display" : "Saxofono"
    },
    {
      "code" : "30606033",
      "display" : "Strumentazione per banda"
    },
    {
      "code" : "30606034",
      "display" : "Strumenti a percussione"
    },
    {
      "code" : "30606035",
      "display" : "Teoria della musica"
    },
    {
      "code" : "30606036",
      "display" : "Tromba e trombone"
    },
    {
      "code" : "30606037",
      "display" : "Viola"
    },
    {
      "code" : "30606038",
      "display" : "Viola da gamba"
    },
    {
      "code" : "30606039",
      "display" : "Violino"
    },
    {
      "code" : "30606040",
      "display" : "Violoncello"
    },
    {
      "code" : "30606999",
      "display" : "Altri diplomi di Conservatorio e Istituto musicale pareggiato"
    },
    {
      "code" : "30607000",
      "display" : "DIPLOMA DI DANZATORE"
    },
    {
      "code" : "30999999",
      "display" : "Altri titoli di istruzione secondaria superiore (scolastica ed extra-scolastica) che non permettono l'accesso all'università"
    },
    {
      "code" : "40000000",
      "display" : "DIPLOMA DI ISTRUZIONE SECONDARIA SUPERIORE  CHE PERMETTE L'ACCESSO ALL'UNIVERSITA'"
    },
    {
      "code" : "40100000",
      "display" : "DIPLOMA DI ISTRUZIONE SECONDARIA SUPERIORE AD INDIRIZZO PROFESSIONALE"
    },
    {
      "code" : "40101000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo professionale agrario"
    },
    {
      "code" : "40101001",
      "display" : "Agrotecnico"
    },
    {
      "code" : "40101002",
      "display" : "Tecnico chimico e biologo"
    },
    {
      "code" : "40101003",
      "display" : "Tecnico gestione aziendale"
    },
    {
      "code" : "40101004",
      "display" : "Tecnico servizi ristorazione e servizi turistici"
    },
    {
      "code" : "40101999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo professionale agrario"
    },
    {
      "code" : "40102000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo professionale per l'industria e l'artigianato"
    },
    {
      "code" : "40102001",
      "display" : "Chimico industrie ceramiche"
    },
    {
      "code" : "40102002",
      "display" : "Odontotecnico"
    },
    {
      "code" : "40102003",
      "display" : "Ottico"
    },
    {
      "code" : "40102004",
      "display" : "Tecnica della grafica pubblicitaria"
    },
    {
      "code" : "40102005",
      "display" : "Tecnico cinema televisione"
    },
    {
      "code" : "40106004",
      "display" : "Tecnico dei sistemi energetici"
    },
    {
      "code" : "40106005",
      "display" : "Tecnico abbigliamento e moda"
    },
    {
      "code" : "40106006",
      "display" : "Tecnico delle industrie elettriche ed elettroniche"
    },
    {
      "code" : "40106007",
      "display" : "Tecnico gestione aziendale"
    },
    {
      "code" : "40106008",
      "display" : "Tecnico servizi ristorazione e servizi turistici"
    },
    {
      "code" : "40106009",
      "display" : "Tecnico servizi sociali"
    },
    {
      "code" : "40106010",
      "display" : "Tecnico chimico e biologico"
    },
    {
      "code" : "40106011",
      "display" : "Tecnico della grafica pubblicitaria"
    },
    {
      "code" : "40106999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo professionale femminile"
    },
    {
      "code" : "40107000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo professionale cinematografia e televisione"
    },
    {
      "code" : "40108000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo professionale per l'industria edile"
    },
    {
      "code" : "40108001",
      "display" : "Tecnica della grafica pubblicitaria"
    },
    {
      "code" : "40108002",
      "display" : "Tecnico dei sistemi energetici"
    },
    {
      "code" : "40108003",
      "display" : "Tecnico delle industrie elettriche ed elettroniche"
    },
    {
      "code" : "40108999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo professionale edile"
    },
    {
      "code" : "40200000",
      "display" : "DIPLOMA DI ISTRUZIONE SECONDARIA SUPERIORE AD INDIRIZZO TECNICO"
    },
    {
      "code" : "40201000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo tecnico agrario"
    },
    {
      "code" : "40201001",
      "display" : "Indirizzo generale"
    },
    {
      "code" : "40201002",
      "display" : "Viticoltura ed enologia"
    },
    {
      "code" : "40201003",
      "display" : "Cerere Unitario-Moduli vari"
    },
    {
      "code" : "40201004",
      "display" : "Progetto Brocca"
    },
    {
      "code" : "40201005",
      "display" : "Agro ambientale, industriale, territoriale"
    },
    {
      "code" : "50604003",
      "display" : "Progettazione e tecnologia ceramica"
    },
    {
      "code" : "50604999",
      "display" : "Altri diplomi di istituto superiore di industrie artistiche"
    },
    {
      "code" : "50605000",
      "display" : "Diploma di Accademia nazionale di arte drammatica"
    },
    {
      "code" : "50605001",
      "display" : "Recitazione teatrale"
    },
    {
      "code" : "50605002",
      "display" : "Regia teatrale"
    },
    {
      "code" : "50605003",
      "display" : "Pedagogia e didattica del teatro"
    },
    {
      "code" : "50605999",
      "display" : "Altri diplomi di Accademia nazionale di arte drammatica"
    },
    {
      "code" : "50606000",
      "display" : "Diploma di Conservatorio musicale e Istituto musicale pareggiato"
    },
    {
      "code" : "50606001",
      "display" : "Arpa"
    },
    {
      "code" : "50606002",
      "display" : "Basso tuba"
    },
    {
      "code" : "50606003",
      "display" : "Biblioteconomia e bibliografia musicale"
    },
    {
      "code" : "50606004",
      "display" : "Canto"
    },
    {
      "code" : "50606005",
      "display" : "Chitarra"
    },
    {
      "code" : "50606006",
      "display" : "Clarinetto"
    },
    {
      "code" : "50606007",
      "display" : "Clavicembalo, clavicordo e fortepiano"
    },
    {
      "code" : "50606008",
      "display" : "Composizione"
    },
    {
      "code" : "50606009",
      "display" : "Contrabbasso"
    },
    {
      "code" : "50606010",
      "display" : "Corno"
    },
    {
      "code" : "50606011",
      "display" : "Didattica della Musica"
    },
    {
      "code" : "50606012",
      "display" : "Direzione d'Orchestra"
    },
    {
      "code" : "50606013",
      "display" : "Fagotto"
    },
    {
      "code" : "50606014",
      "display" : "Fisarmonica"
    },
    {
      "code" : "50606015",
      "display" : "Flauto"
    },
    {
      "code" : "50606016",
      "display" : "Flauto dolce"
    },
    {
      "code" : "50606017",
      "display" : "Jazz"
    },
    {
      "code" : "50606018",
      "display" : "Lettura della partitura - Scuola sperimentale"
    },
    {
      "code" : "50606019",
      "display" : "Lied ed oratorio"
    },
    {
      "code" : "50606020",
      "display" : "Liuto"
    },
    {
      "code" : "50606021",
      "display" : "Maestro sostituto collaboratore"
    },
    {
      "code" : "50606022",
      "display" : "Mandolino"
    },
    {
      "code" : "50606023",
      "display" : "Musica corale e direzione coro"
    },
    {
      "code" : "50606024",
      "display" : "Musica da camera - Scuola sperimentale"
    },
    {
      "code" : "50606025",
      "display" : "Musica elettronica"
    },
    {
      "code" : "50606026",
      "display" : "Musica vocale da camera"
    },
    {
      "code" : "50606027",
      "display" : "Musicologia"
    },
    {
      "code" : "50606028",
      "display" : "Oboe"
    },
    {
      "code" : "50606029",
      "display" : "Organo e composizione organistica"
    },
    {
      "code" : "50606030",
      "display" : "Pianoforte"
    },
    {
      "code" : "50606031",
      "display" : "Prepolifonia"
    },
    {
      "code" : "50606032",
      "display" : "Saxofono"
    },
    {
      "code" : "50606033",
      "display" : "Strumentazione per banda"
    },
    {
      "code" : "50606034",
      "display" : "Strumenti a percussione"
    },
    {
      "code" : "50606035",
      "display" : "Teoria della musica"
    },
    {
      "code" : "50606036",
      "display" : "Tromba e trombone"
    },
    {
      "code" : "50606037",
      "display" : "Viola"
    },
    {
      "code" : "50606038",
      "display" : "Viola da gamba"
    },
    {
      "code" : "50606039",
      "display" : "Violino"
    },
    {
      "code" : "50606040",
      "display" : "Violoncello"
    },
    {
      "code" : "50606041",
      "display" : "Discipline musicali"
    },
    {
      "code" : "50606999",
      "display" : "Altri diplomi di Conservatorio e Istituto musicale pareggiato"
    },
    {
      "code" : "50607000",
      "display" : "Diploma di perfezionamento accademia di danza"
    },
    {
      "code" : "50607001",
      "display" : "Insegnante di danza"
    },
    {
      "code" : "50607002",
      "display" : "Solista di danza"
    },
    {
      "code" : "50607003",
      "display" : "Compositore di danza"
    },
    {
      "code" : "50607999",
      "display" : "Altri diplomi di Accademia di danza"
    },
    {
      "code" : "50700000",
      "display" : "DIPLOMA DI SCUOLA SUPERIORE PER INTERPRETE E TRADUTTORE"
    },
    {
      "code" : "50700001",
      "display" : "Diploma di interprete e traduttore"
    },
    {
      "code" : "50700002",
      "display" : "Diploma di interprete"
    },
    {
      "code" : "50700003",
      "display" : "Diploma di traduttore"
    },
    {
      "code" : "50700999",
      "display" : "Altri diplomi di scuola per interprete e treduttore"
    },
    {
      "code" : "50800000",
      "display" : "DIPLOMA DI SCUOLA DI ARCHIVISTICA PALEOGRAFIA E DIPLOMATICA"
    },
    {
      "code" : "50999999",
      "display" : "Altri diplomi terziari extra-universitari"
    },
    {
      "code" : "60000000",
      "display" : "DIPLOMA UNIVERSITARIO"
    },
    {
      "code" : "60001000",
      "display" : "Gruppo scientifico"
    },
    {
      "code" : "60001001",
      "display" : "Matematica"
    },
    {
      "code" : "60001002",
      "display" : "Metodologie fisiche"
    },
    {
      "code" : "60001003",
      "display" : "Scienza dei materiali"
    },
    {
      "code" : "60001004",
      "display" : "Informatica"
    },
    {
      "code" : "60001005",
      "display" : "Ottica tecnica"
    },
    {
      "code" : "60001006",
      "display" : "Gestione dei rischi naturali"
    },
    {
      "code" : "60001007",
      "display" : "Scienza dei media e della comunicazione"
    },
    {
      "code" : "60001008",
      "display" : "Informatica"
    },
    {
      "code" : "60001999",
      "display" : "Altri diplomi del gruppo scientifico"
    },
    {
      "code" : "60002000",
      "display" : "Gruppo chimico farmaceutico"
    },
    {
      "code" : "60002001",
      "display" : "Chimica"
    },
    {
      "code" : "60002002",
      "display" : "Scienze e tecniche cartarie"
    },
    {
      "code" : "60002003",
      "display" : "Tecniche erboristiche"
    },
    {
      "code" : "60002004",
      "display" : "Controllo di qualità nel settore industriale farmaceutico"
    },
    {
      "code" : "60002005",
      "display" : "Informazione scientifica sul farmaco"
    },
    {
      "code" : "60002006",
      "display" : "Tecnologie farmaceutiche"
    },
    {
      "code" : "60002007",
      "display" : "Analisi chimico biologiche"
    },
    {
      "code" : "60002008",
      "display" : "Erboristeria"
    },
    {
      "code" : "60002009",
      "display" : "Scienze e tecniche cartarie"
    },
    {
      "code" : "60002999",
      "display" : "Altri diplomi del gruppo chimico farmaceutico"
    },
    {
      "code" : "60003000",
      "display" : "Gruppo geo-biologico"
    },
    {
      "code" : "60003001",
      "display" : "Valutazione e controllo ambientale"
    },
    {
      "code" : "60003002",
      "display" : "Tecnico dello sviluppo ecocompatibile"
    },
    {
      "code" : "60003003",
      "display" : "Geologo"
    },
    {
      "code" : "60003004",
      "display" : "Biotecnologie"
    },
    {
      "code" : "60003005",
      "display" : "Biologia"
    },
    {
      "code" : "60003006",
      "display" : "Geologo \"Tecnico del monitoraggio geoambientale\""
    },
    {
      "code" : "60003007",
      "display" : "Operatore tecnico ambientale"
    },
    {
      "code" : "60003008",
      "display" : "Scienze ambientali"
    },
    {
      "code" : "60003009",
      "display" : "Prospettore geologico"
    },
    {
      "code" : "60003010",
      "display" : "Biotecnologie industriali"
    },
    {
      "code" : "60003011",
      "display" : "Geologia per la protezione dell'ambiente"
    },
    {
      "code" : "60003012",
      "display" : "Geologia e sismologia"
    },
    {
      "code" : "60003013",
      "display" : "Tecnici in biologia del mare"
    },
    {
      "code" : "60003999",
      "display" : "Altri diplomi del gruppo geo biologico"
    },
    {
      "code" : "60004000",
      "display" : "Gruppo medico"
    },
    {
      "code" : "60004001",
      "display" : "Dietologia e dietetica applicata"
    },
    {
      "code" : "60004002",
      "display" : "Fisioterapista"
    },
    {
      "code" : "60004003",
      "display" : "Igienista dentale"
    },
    {
      "code" : "60004004",
      "display" : "Logopedia"
    },
    {
      "code" : "60004005",
      "display" : "Ortottista ed assistente in oftalmologia"
    },
    {
      "code" : "60004006",
      "display" : "Ostetrica/o"
    },
    {
      "code" : "60004007",
      "display" : "Podologo"
    },
    {
      "code" : "60004008",
      "display" : "Riabilitazione psichiatrica e psicosociale"
    },
    {
      "code" : "60004009",
      "display" : "Scienze infermieristiche"
    },
    {
      "code" : "60004010",
      "display" : "Tecnico di neurofisiopatologia"
    },
    {
      "code" : "60004011",
      "display" : "Tecnico di audiometria ed audioprotesi"
    },
    {
      "code" : "60004012",
      "display" : "Tecnico di laboratorio biomedico"
    },
    {
      "code" : "60004013",
      "display" : "Tecnico sanitario di radiologia medica"
    },
    {
      "code" : "60004014",
      "display" : "Terapista della riabilitazione della neuro e psicomotricità dell'età evolutiva"
    },
    {
      "code" : "60004015",
      "display" : "Terapista della riabilitazione"
    },
    {
      "code" : "60004016",
      "display" : "Tecnico ortopedico"
    },
    {
      "code" : "60004017",
      "display" : "Tecnico audiometrista"
    },
    {
      "code" : "60004018",
      "display" : "Tecnico audioprotesista"
    },
    {
      "code" : "60004019",
      "display" : "Dietista"
    },
    {
      "code" : "60004020",
      "display" : "Tecnico sanitario di laboratorio biomedico"
    },
    {
      "code" : "60004021",
      "display" : "Informatori medico scientifici"
    },
    {
      "code" : "60004022",
      "display" : "Infermiere"
    },
    {
      "code" : "60004023",
      "display" : "Logopedista"
    },
    {
      "code" : "60004024",
      "display" : "Tecnici in biotecnologie"
    },
    {
      "code" : "60004025",
      "display" : "Terapista della neuro e psicomotricità dell'età evolutiva"
    },
    {
      "code" : "60004026",
      "display" : "Tecnico di igiene ambientale e del lavoro"
    },
    {
      "code" : "60004027",
      "display" : "Tecnico dell'educazione e della riabilitazione psichiatrica e psicosociale"
    },
    {
      "code" : "60004028",
      "display" : "Disegno anatomico"
    },
    {
      "code" : "60004029",
      "display" : "Tecnico sanitario per la prevenzione ambientale e dei luoghi lavorativi"
    },
    {
      "code" : "60004030",
      "display" : "Assistenza nefrologica e tecniche dialitiche"
    },
    {
      "code" : "60004031",
      "display" : "Assistenza sociale psichiatrica"
    },
    {
      "code" : "60004032",
      "display" : "Dietologia e dietetica applicata"
    },
    {
      "code" : "60004033",
      "display" : "Dirigenti dell'assistenza infermieristica"
    },
    {
      "code" : "60004034",
      "display" : "Dirigenti e docenti di scienze infermieristiche"
    },
    {
      "code" : "60004035",
      "display" : "Discipline infermieristiche"
    },
    {
      "code" : "60004036",
      "display" : "Disegno anatomico"
    },
    {
      "code" : "60004037",
      "display" : "Educazione sanitaria"
    },
    {
      "code" : "60004038",
      "display" : "Fisica sanitaria"
    },
    {
      "code" : "60004039",
      "display" : "Giornalismo medico scientifico"
    },
    {
      "code" : "60004040",
      "display" : "Igienisti dentali"
    },
    {
      "code" : "60004041",
      "display" : "Neurofisiopatologia"
    },
    {
      "code" : "60004042",
      "display" : "Ortottista assistente in oftalmologia"
    },
    {
      "code" : "60004043",
      "display" : "Strumentisti di sala operatoria"
    },
    {
      "code" : "60004044",
      "display" : "Tecnici con funzioni ispettive per la tutela della salute nei luoghi di lavoro"
    },
    {
      "code" : "60004045",
      "display" : "Tecnici cosmetici"
    },
    {
      "code" : "60004046",
      "display" : "Tecnici della riabilitazione"
    },
    {
      "code" : "60004047",
      "display" : "Tecnici della riabilitazione psichiatrica e psicosociale"
    },
    {
      "code" : "60004048",
      "display" : "Tecnici dermoestetisti"
    },
    {
      "code" : "60004049",
      "display" : "Tecnici di anatomia patologica e citoistologia"
    },
    {
      "code" : "60004050",
      "display" : "Tecnici di anestesia e rianimazione"
    },
    {
      "code" : "60004051",
      "display" : "Tecnici di audiometria e protesizzazione acustica"
    },
    {
      "code" : "60004052",
      "display" : "Tecnici di colpocitologia"
    },
    {
      "code" : "60004053",
      "display" : "Tecnici di fisiopatologia cardiocircolatoria"
    },
    {
      "code" : "60004054",
      "display" : "Tecnici di logopedia e foniatria"
    },
    {
      "code" : "60004055",
      "display" : "Tecnici di neurofisiopatologia"
    },
    {
      "code" : "60004056",
      "display" : "Tecnici di radiologia medica"
    },
    {
      "code" : "60004057",
      "display" : "Tecnici di terapia intensiva chirurgica"
    },
    {
      "code" : "60004058",
      "display" : "Tecnici in biotecnologie"
    },
    {
      "code" : "60004059",
      "display" : "Tecnici ortodermisti"
    },
    {
      "code" : "60004060",
      "display" : "Tecnico di audiometria"
    },
    {
      "code" : "60004061",
      "display" : "Tecnico di igiene ambientale e del lavoro"
    },
    {
      "code" : "60004062",
      "display" : "Tecnico di laboratorio biomedico"
    },
    {
      "code" : "60004063",
      "display" : "Terapia enterostomale per infermieri professionali"
    },
    {
      "code" : "60004064",
      "display" : "Terapia fisica e riabilitativa"
    },
    {
      "code" : "60004065",
      "display" : "Terapisti della riabilitazione"
    },
    {
      "code" : "60004066",
      "display" : "Terapia della riabilitazione e terapia occupazionale"
    },
    {
      "code" : "60004067",
      "display" : "Terapisti della riabilitazione della neuro e psicomotricità dell'età evolutiva"
    },
    {
      "code" : "60004068",
      "display" : "Terapisti della riabilitazione specializzati in chinesiterapia"
    },
    {
      "code" : "60004069",
      "display" : "Scuola di ostetricia"
    },
    {
      "code" : "60004070",
      "display" : "Scuola Infermieri"
    },
    {
      "code" : "60004071",
      "display" : "Tecnico di dietologia e dietetica applicata"
    },
    {
      "code" : "60004072",
      "display" : "Tecnici di logopedia"
    },
    {
      "code" : "60004073",
      "display" : "Terapisti della riabilitazione dell'apparato motore"
    },
    {
      "code" : "60004074",
      "display" : "Audioprotesisti"
    },
    {
      "code" : "60004999",
      "display" : "Altri diplomi del gruppo medico"
    },
    {
      "code" : "60005000",
      "display" : "Gruppo ingegneria"
    },
    {
      "code" : "60005001",
      "display" : "Edilizia"
    },
    {
      "code" : "60005002",
      "display" : "Ingegneria aerospaziale"
    },
    {
      "code" : "60005003",
      "display" : "Ingegneria biomedica"
    },
    {
      "code" : "60005004",
      "display" : "Ingegneria chimica"
    },
    {
      "code" : "60005005",
      "display" : "Ingegneria dell'ambiente e delle risorse"
    },
    {
      "code" : "60005006",
      "display" : "Ingegneria dell'automazione"
    },
    {
      "code" : "60005007",
      "display" : "Ingegneria delle infrastrutture"
    },
    {
      "code" : "60005008",
      "display" : "Ingegneria delle telecomunicazioni"
    },
    {
      "code" : "60005009",
      "display" : "Ingegneria elettrica"
    },
    {
      "code" : "60005010",
      "display" : "Ingegneria elettronica"
    },
    {
      "code" : "60005011",
      "display" : "Ingegneria energetica"
    },
    {
      "code" : "60005012",
      "display" : "Ingegneria informatica"
    },
    {
      "code" : "60005013",
      "display" : "Ingegneria informatica e automatica"
    },
    {
      "code" : "60005014",
      "display" : "Ingegneria logistica e della produzione"
    },
    {
      "code" : "60005015",
      "display" : "Ingegneria meccanica"
    },
    {
      "code" : "60005016",
      "display" : "Sistemi informativi territoriali"
    },
    {
      "code" : "60005017",
      "display" : "Produzione industriale (DU europeo)"
    },
    {
      "code" : "60005018",
      "display" : "Ingegneria edile"
    },
    {
      "code" : "60005019",
      "display" : "Ingegneria delle strutture"
    },
    {
      "code" : "60005020",
      "display" : "Ingegneria meccanica"
    },
    {
      "code" : "60005021",
      "display" : "Ingegneria dei materiali"
    },
    {
      "code" : "60005022",
      "display" : "Ingegneria delle materie plastiche"
    },
    {
      "code" : "60005023",
      "display" : "Ingegneria industriale"
    },
    {
      "code" : "60005024",
      "display" : "Tecnologie industriali e dei materiali"
    },
    {
      "code" : "60005025",
      "display" : "Ingegneria per l'ambiente e il territorio"
    },
    {
      "code" : "60005026",
      "display" : "Ingegneria dell'autoveicolo"
    },
    {
      "code" : "60005027",
      "display" : "Matematica per le scienze dell'ingegneria"
    },
    {
      "code" : "60005028",
      "display" : "Ingegneria civile"
    },
    {
      "code" : "60005029",
      "display" : "Progettazione per la nautica da diporto"
    },
    {
      "code" : "60005030",
      "display" : "Strumentazione industriale"
    },
    {
      "code" : "60005031",
      "display" : "Tecnologia ceramica"
    },
    {
      "code" : "60005032",
      "display" : "Topografia applicata"
    },
    {
      "code" : "60005033",
      "display" : "Esperti della produzione industriale"
    },
    {
      "code" : "60005034",
      "display" : "Tecniche per la protezione ambientale e per la sicurezza nei luoghi di lavoro"
    },
    {
      "code" : "60005035",
      "display" : "Topografo esperto"
    },
    {
      "code" : "60005036",
      "display" : "Tecnico superiore di elettronica"
    },
    {
      "code" : "60005037",
      "display" : "Programmatori ed analisti"
    },
    {
      "code" : "60005038",
      "display" : "Tecnologia protezione ambiente e sicurezza"
    },
    {
      "code" : "60005039",
      "display" : "Impianti tecnici e frigoriferi"
    },
    {
      "code" : "60005040",
      "display" : "Tecnologie tessili"
    },
    {
      "code" : "60005041",
      "display" : "Telecomunicazioni"
    },
    {
      "code" : "60005042",
      "display" : "Tecnici per il risparmio energetico"
    },
    {
      "code" : "60005043",
      "display" : "Scienza ed ingegneria dei materiali"
    },
    {
      "code" : "60005999",
      "display" : "Altri diplomi del gruppo ingegneria"
    },
    {
      "code" : "60006000",
      "display" : "Gruppo architettura"
    },
    {
      "code" : "60006001",
      "display" : "Disegno industriale"
    },
    {
      "code" : "60006002",
      "display" : "Tecniche e arti della stampa"
    },
    {
      "code" : "60006003",
      "display" : "Realizzazione, riqualificazione e gestione degli spazi verdi"
    },
    {
      "code" : "60006004",
      "display" : "Materiali per la manutenzione del costruito antico e moderno"
    },
    {
      "code" : "60006005",
      "display" : "Rilevamento e rappresentazione dei beni architettonici"
    },
    {
      "code" : "60006006",
      "display" : "Scienze e arti della stampa"
    },
    {
      "code" : "60006999",
      "display" : "Altri diplomi del gruppo architettura"
    },
    {
      "code" : "60007000",
      "display" : "Gruppo agrario"
    },
    {
      "code" : "60007001",
      "display" : "Gestione tecnica e amministrativa in agricoltura"
    },
    {
      "code" : "60007002",
      "display" : "Igiene e sanità animale"
    },
    {
      "code" : "60007003",
      "display" : "Produzioni agrarie tropicali e subtropicali"
    },
    {
      "code" : "60007004",
      "display" : "Produzioni animali"
    },
    {
      "code" : "60007005",
      "display" : "Produzioni vegetali"
    },
    {
      "code" : "60007006",
      "display" : "Tecniche forestali"
    },
    {
      "code" : "60007007",
      "display" : "Tecniche forestali e tecnologie del legno"
    },
    {
      "code" : "60007008",
      "display" : "Tecnologie alimentari"
    },
    {
      "code" : "60007009",
      "display" : "Biotecnologie agro industriali"
    },
    {
      "code" : "60007010",
      "display" : "Viticoltura ed enologia"
    },
    {
      "code" : "60007011",
      "display" : "Tecnologie agroalimentari"
    },
    {
      "code" : "60007012",
      "display" : "Gestione delle imprese della pesca"
    },
    {
      "code" : "60007013",
      "display" : "Agriturismo"
    },
    {
      "code" : "60007014",
      "display" : "Agrometeorologia"
    },
    {
      "code" : "60007015",
      "display" : "Tecnica enologica"
    },
    {
      "code" : "60007016",
      "display" : "Tecniche di laboratorio per le industrie agro alimentari"
    },
    {
      "code" : "60007017",
      "display" : "Tecnologie della produzione della carne"
    },
    {
      "code" : "60007018",
      "display" : "Tecnica faunistica"
    },
    {
      "code" : "60007019",
      "display" : "Maricoltura, pesca e trasformazione pesca"
    },
    {
      "code" : "60007999",
      "display" : "Altri diplomi del gruppo agrario"
    },
    {
      "code" : "60008000",
      "display" : "Gruppo economico-statistico"
    },
    {
      "code" : "60008001",
      "display" : "Amministrazione aziendale"
    },
    {
      "code" : "60008002",
      "display" : "Commercio estero"
    },
    {
      "code" : "60008003",
      "display" : "Economia delle amministrazioni pubbliche"
    },
    {
      "code" : "60008004",
      "display" : "Economia delle imprese cooperative e delle organizzazioni nonprofit"
    },
    {
      "code" : "60008005",
      "display" : "Economia e amministrazione delle imprese"
    },
    {
      "code" : "60008006",
      "display" : "Economia e amministrazione delle imprese alimentari"
    },
    {
      "code" : "60008007",
      "display" : "Economia e gestione dei servizi turistici"
    },
    {
      "code" : "60008008",
      "display" : "Gestione delle amministrazioni pubbliche"
    },
    {
      "code" : "60008009",
      "display" : "Gestione delle imprese alimentari"
    },
    {
      "code" : "60008010",
      "display" : "Marketing e comunicazione d'azienda"
    },
    {
      "code" : "60008011",
      "display" : "Statistica"
    },
    {
      "code" : "60008012",
      "display" : "Statistica e informatica per la gestione delle imprese"
    },
    {
      "code" : "60008013",
      "display" : "Statistica e informatica per le amministrazioni pubbliche"
    },
    {
      "code" : "60008014",
      "display" : "Scienze assicurative"
    },
    {
      "code" : "60008015",
      "display" : "Economia applicata"
    },
    {
      "code" : "60008016",
      "display" : "Metodi quantitativi per l'economia"
    },
    {
      "code" : "60008017",
      "display" : "Moneta e finanza"
    },
    {
      "code" : "60008018",
      "display" : "Economia e gestione dei servizi ambientali"
    },
    {
      "code" : "60008019",
      "display" : "Operatore del turismo culturale"
    },
    {
      "code" : "60008020",
      "display" : "Statistica (corso biennale)"
    },
    {
      "code" : "60008021",
      "display" : "Economia ed ingegneria della qualità"
    },
    {
      "code" : "60008022",
      "display" : "Banca e finanza"
    },
    {
      "code" : "60008023",
      "display" : "Economia dell'ambiente"
    },
    {
      "code" : "60008024",
      "display" : "Amministrazione"
    },
    {
      "code" : "60008025",
      "display" : "Economia e amministrazione dell'azienda pubblica"
    },
    {
      "code" : "60008026",
      "display" : "Economia e amministrazione delle imprese agricole"
    },
    {
      "code" : "60008027",
      "display" : "Economia e gestione delle arti e delle attività culturali"
    },
    {
      "code" : "60008028",
      "display" : "Operatore turistico"
    },
    {
      "code" : "60008029",
      "display" : "Tecniche finanziarie e assicurative"
    },
    {
      "code" : "60008030",
      "display" : "Economia, gestione e tutela dell'ambiente"
    },
    {
      "code" : "60008031",
      "display" : "Scienze bancarie"
    },
    {
      "code" : "60008032",
      "display" : "Economia del sistema agro alimentare e dell'ambiente"
    },
    {
      "code" : "60008033",
      "display" : "Esperti in lingue nel settore del commercio estero"
    },
    {
      "code" : "60008034",
      "display" : "Operatori economici dei servizi turistici"
    },
    {
      "code" : "60008035",
      "display" : "Operatori economici nel sistema turistico"
    },
    {
      "code" : "60008036",
      "display" : "Scienze turistiche"
    },
    {
      "code" : "60008037",
      "display" : "Amministrazione e controllo aziendale"
    },
    {
      "code" : "60008038",
      "display" : "Economia e merceologia alimentare"
    },
    {
      "code" : "60008039",
      "display" : "Studi turistici"
    },
    {
      "code" : "60008040",
      "display" : "Operatori turistici"
    },
    {
      "code" : "60008041",
      "display" : "Esperti di statistica informatica"
    },
    {
      "code" : "60008042",
      "display" : "Tecnici dell'amministrazione aziendale"
    },
    {
      "code" : "60008999",
      "display" : "Altri diplomi del gruppo economico statistico"
    },
    {
      "code" : "60009000",
      "display" : "Gruppo politico-sociale"
    },
    {
      "code" : "60009001",
      "display" : "Giornalismo"
    },
    {
      "code" : "60009002",
      "display" : "Servizio sociale"
    },
    {
      "code" : "60009003",
      "display" : "Tecnica pubblicitaria"
    },
    {
      "code" : "60009004",
      "display" : "Operatore della sicurezza e del controllo sociale"
    },
    {
      "code" : "60009005",
      "display" : "Tecnico audiovisivo e multimediale"
    },
    {
      "code" : "60009006",
      "display" : "Scienze organizzative e gestionali"
    },
    {
      "code" : "60009007",
      "display" : "Tecnologo della comunicazione audiovisiva e multimediale"
    },
    {
      "code" : "60009008",
      "display" : "Relazioni pubbliche"
    },
    {
      "code" : "60009009",
      "display" : "Coordinamento delle attività di protezione civile"
    },
    {
      "code" : "60009010",
      "display" : "Assistenti sociali"
    },
    {
      "code" : "60009011",
      "display" : "Scienze politiche e sociali"
    },
    {
      "code" : "60009012",
      "display" : "Scuola servizio sociale"
    },
    {
      "code" : "60009013",
      "display" : "Tecnica pubblicitaria"
    },
    {
      "code" : "60009014",
      "display" : "Relazioni pubbliche"
    },
    {
      "code" : "60009999",
      "display" : "Altri diplomi del gruppo politico sociale"
    },
    {
      "code" : "60010000",
      "display" : "Gruppo giuridico"
    },
    {
      "code" : "60010001",
      "display" : "Consulente del lavoro"
    },
    {
      "code" : "60010002",
      "display" : "Operatore giudiziario"
    },
    {
      "code" : "60010003",
      "display" : "Operatore giuridico d'impresa"
    },
    {
      "code" : "60010004",
      "display" : "Operatore della pubblica amministrazione"
    },
    {
      "code" : "60010005",
      "display" : "Relazioni industriali"
    },
    {
      "code" : "60010006",
      "display" : "Scienze strategiche"
    },
    {
      "code" : "60010007",
      "display" : "Scienze criminologiche applicate"
    },
    {
      "code" : "60010008",
      "display" : "Operatore immobiliare"
    },
    {
      "code" : "60010009",
      "display" : "Consulenti del lavoro"
    },
    {
      "code" : "60010010",
      "display" : "Pubblica amministrazione e governo locale"
    },
    {
      "code" : "60010999",
      "display" : "Altri diplomi del gruppo giuridico"
    },
    {
      "code" : "60011000",
      "display" : "Gruppo letterario"
    },
    {
      "code" : "60011001",
      "display" : "Archivisti paleografi"
    },
    {
      "code" : "60011002",
      "display" : "Bibliotecari"
    },
    {
      "code" : "60011003",
      "display" : "Conservatori di manoscritti"
    },
    {
      "code" : "60011004",
      "display" : "Operatori/conservatori dei beni culturali"
    },
    {
      "code" : "60011005",
      "display" : "Operatore di costume e moda"
    },
    {
      "code" : "60011006",
      "display" : "Paleografia e filologia musicale"
    },
    {
      "code" : "60011007",
      "display" : "Storia e didattica della musica"
    },
    {
      "code" : "60011008",
      "display" : "Consulenza grafologica"
    },
    {
      "code" : "60011009",
      "display" : "Tecnico per la diagnostica applicata al restauro e conservazione dei beni culturali"
    },
    {
      "code" : "60011010",
      "display" : "Operatore dei beni culturali"
    },
    {
      "code" : "60011011",
      "display" : "Operatore didattico dei beni culturali"
    },
    {
      "code" : "60011012",
      "display" : "Tecniche artistiche e dello spettacolo"
    },
    {
      "code" : "60011013",
      "display" : "Metodologie e tecniche di restauro dei beni librari e documentari"
    },
    {
      "code" : "60011014",
      "display" : "Beni culturali per operatori turistici"
    },
    {
      "code" : "60011015",
      "display" : "Archivisti"
    },
    {
      "code" : "60011016",
      "display" : "Costume e moda"
    },
    {
      "code" : "60011017",
      "display" : "Operatori tecnico scientifici per i beni culturali e ambientali"
    },
    {
      "code" : "60011018",
      "display" : "Studi grafologici"
    },
    {
      "code" : "60011999",
      "display" : "Altri diplomi del gruppo letterario"
    },
    {
      "code" : "60012000",
      "display" : "Gruppo linguistico"
    },
    {
      "code" : "60012001",
      "display" : "Traduttori e interpreti"
    },
    {
      "code" : "60012002",
      "display" : "Traduttore ed interprete e corrispondente in lingue estere"
    },
    {
      "code" : "60012003",
      "display" : "Esperto linguistico d'impresa"
    },
    {
      "code" : "60012004",
      "display" : "Lingue straniere con specializzazione turistico culturale"
    },
    {
      "code" : "60012999",
      "display" : "Altri diplomi del gruppo linguistico"
    },
    {
      "code" : "60013000",
      "display" : "Gruppo insegnamento"
    },
    {
      "code" : "60013001",
      "display" : "Insegnamento della lingua italiana a stranieri"
    },
    {
      "code" : "60013002",
      "display" : "Abilitazione alla vigilanza nelle scuole elementari"
    },
    {
      "code" : "60013003",
      "display" : "Educatore nelle comunità infantili"
    },
    {
      "code" : "60013004",
      "display" : "Tecnico di laboratorio della formazione"
    },
    {
      "code" : "60013005",
      "display" : "Educatore e divulgatore ambientale"
    },
    {
      "code" : "60013006",
      "display" : "Educatori professionali"
    },
    {
      "code" : "60013007",
      "display" : "Educatori di comunità"
    },
    {
      "code" : "60013008",
      "display" : "Educatori professionali"
    },
    {
      "code" : "60013009",
      "display" : "Educatori di comunità"
    },
    {
      "code" : "60013999",
      "display" : "Altri diplomi del gruppo insegnamento"
    },
    {
      "code" : "60014000",
      "display" : "Gruppo psicologico"
    },
    {
      "code" : "60014001",
      "display" : "Assistenti educativi di prima infanzia"
    },
    {
      "code" : "60014999",
      "display" : "Altri diplomi del gruppo psicologico"
    },
    {
      "code" : "60015000",
      "display" : "Gruppo educazione fisica"
    },
    {
      "code" : "60015001",
      "display" : "Educazione fisica"
    },
    {
      "code" : "60015002",
      "display" : "Attività motorie"
    },
    {
      "code" : "60015999",
      "display" : "Altri diplomi del gruppo educazione fisica"
    },
    {
      "code" : "60999999",
      "display" : "Altri diplomi universitari"
    },
    {
      "code" : "70000000",
      "display" : "LAUREA - Vecchio o nuovo ordinamento (corsi di durata compresa tra i 2 e i 6 anni)"
    },
    {
      "code" : "71000000",
      "display" : "LAUREA DI PRIMO LIVELLO - Nuovo ordinamento (corsi di 3 anni)"
    },
    {
      "code" : "71001000",
      "display" : "Gruppo scientifico"
    },
    {
      "code" : "71001001",
      "display" : "Scienze matematiche"
    },
    {
      "code" : "71001002",
      "display" : "Scienze e tecnologie fisiche"
    },
    {
      "code" : "71001003",
      "display" : "Scienze e tecnologie informatiche"
    },
    {
      "code" : "71001999",
      "display" : "Altre lauree di primo livello del guppo scientifico"
    },
    {
      "code" : "71002000",
      "display" : "Gruppo chimico farmaceutico"
    },
    {
      "code" : "71002001",
      "display" : "Scienze e tecnologie chimiche"
    },
    {
      "code" : "71002002",
      "display" : "Scienze e tecnologie farmaceutiche"
    },
    {
      "code" : "71002990",
      "display" : "Altre lauree di primo livello del guppo chimico farmaceutico"
    },
    {
      "code" : "71003000",
      "display" : "Gruppo geo-biologico"
    },
    {
      "code" : "71003001",
      "display" : "Biotecnologie"
    },
    {
      "code" : "71003002",
      "display" : "Scienze biologiche"
    },
    {
      "code" : "71003003",
      "display" : "Scienze della terra"
    },
    {
      "code" : "71003004",
      "display" : "Scienze e tecnologie per l'ambiente e la natura"
    },
    {
      "code" : "71003005",
      "display" : "Scienze geografiche"
    },
    {
      "code" : "71003990",
      "display" : "Altre lauree di primo livello del guppo geo biologico"
    },
    {
      "code" : "71004000",
      "display" : "Gruppo medico"
    },
    {
      "code" : "71004001",
      "display" : "Professioni sanitarie infermieristiche e professione sanitaria ostestrica"
    },
    {
      "code" : "71004002",
      "display" : "Professioni sanitarie della riabilitazione"
    },
    {
      "code" : "71004003",
      "display" : "Professioni sanitarie tecniche"
    },
    {
      "code" : "71004004",
      "display" : "Professioni sanitarie della prevenzione"
    },
    {
      "code" : "71004999",
      "display" : "Altre lauree di primo livello del guppo medico"
    },
    {
      "code" : "71005000",
      "display" : "Gruppo ingegneria"
    },
    {
      "code" : "71005001",
      "display" : "Ingegneria civile e ambientale"
    },
    {
      "code" : "71005002",
      "display" : "Ingegneria dell'informazione"
    },
    {
      "code" : "71005003",
      "display" : "Ingegneria industriale"
    },
    {
      "code" : "71005999",
      "display" : "Altre lauree di primo livello del guppo ingegneria"
    },
    {
      "code" : "71006000",
      "display" : "Gruppo architettura"
    },
    {
      "code" : "71006001",
      "display" : "Scienze dell'architettura e dell'ingegneria edile"
    },
    {
      "code" : "71011000",
      "display" : "Gruppo letterario"
    },
    {
      "code" : "71011001",
      "display" : "Lettere"
    },
    {
      "code" : "71011002",
      "display" : "Scienze dei beni culturali"
    },
    {
      "code" : "71011003",
      "display" : "Scienze e tecnologie delle arti figurative, della musica, dello spettacolo e della moda"
    },
    {
      "code" : "71011004",
      "display" : "Filosofia"
    },
    {
      "code" : "71011005",
      "display" : "Scienze storiche"
    },
    {
      "code" : "71011006",
      "display" : "Tecnologie per la conservazione e il restauro dei beni culturali"
    },
    {
      "code" : "71011999",
      "display" : "Altre lauree di primo livello del guppo letterario"
    },
    {
      "code" : "71012000",
      "display" : "Gruppo linguistico"
    },
    {
      "code" : "71012001",
      "display" : "Scienze della mediazione linguistica"
    },
    {
      "code" : "71012002",
      "display" : "Lingue e culture moderne"
    },
    {
      "code" : "71012999",
      "display" : "Altre lauree di primo livello del guppo linguistico"
    },
    {
      "code" : "71013000",
      "display" : "Gruppo insegnamento"
    },
    {
      "code" : "71013001",
      "display" : "Scienze dell'educazione e della formazione"
    },
    {
      "code" : "71013999",
      "display" : "Altre lauree di primo livello del guppo insegnamento"
    },
    {
      "code" : "71014000",
      "display" : "Gruppo psicologico"
    },
    {
      "code" : "71014001",
      "display" : "Scienze e tecniche psicologiche"
    },
    {
      "code" : "71014999",
      "display" : "Altre lauree di primo livello del guppo psicologico"
    },
    {
      "code" : "71015000",
      "display" : "Gruppo educazione fisica"
    },
    {
      "code" : "71015001",
      "display" : "Scienze delle attività motorie e sportive"
    },
    {
      "code" : "71015999",
      "display" : "Altre lauree di primo livello del guppo educazione fisica"
    },
    {
      "code" : "71016000",
      "display" : "Gruppo difesa e sicurezza"
    },
    {
      "code" : "71016001",
      "display" : "Scienze della difesa e della sicurezza"
    },
    {
      "code" : "71016999",
      "display" : "Altre lauree di primo livello del guppo difesa e sicurezza"
    },
    {
      "code" : "71999999",
      "display" : "Altre lauree di primo livello"
    },
    {
      "code" : "72000000",
      "display" : "DIPLOMA DI LAUREA - Vecchio ordinamento (corsi di 4/6 anni)"
    },
    {
      "code" : "72001000",
      "display" : "Gruppo scientifico"
    },
    {
      "code" : "72001001",
      "display" : "Matematica"
    },
    {
      "code" : "72001002",
      "display" : "Fisica"
    },
    {
      "code" : "72001003",
      "display" : "Astronomia"
    },
    {
      "code" : "72001004",
      "display" : "Scienza dei materiali"
    },
    {
      "code" : "72001005",
      "display" : "Discipline nautiche"
    },
    {
      "code" : "72001006",
      "display" : "Informatica"
    },
    {
      "code" : "72001007",
      "display" : "Scienze dell'informazione"
    },
    {
      "code" : "72001008",
      "display" : "Scienze nautiche"
    },
    {
      "code" : "72001998",
      "display" : "Matematica e Fisica"
    },
    {
      "code" : "72001999",
      "display" : "Altri diplomi di laurea del gruppo scientifico"
    },
    {
      "code" : "72002000",
      "display" : "Gruppo chimico farmaceutico"
    },
    {
      "code" : "72002001",
      "display" : "Chimica"
    },
    {
      "code" : "72002002",
      "display" : "Chimica industriale"
    },
    {
      "code" : "72002003",
      "display" : "Farmacia"
    },
    {
      "code" : "72002004",
      "display" : "Chimica e tecnologia farmaceutiche"
    },
    {
      "code" : "72002005",
      "display" : "Biotecnologie farmaceutiche"
    },
    {
      "code" : "72002999",
      "display" : "Altri diplomi di laurea del gruppo chimico farmaceutico"
    },
    {
      "code" : "72003000",
      "display" : "Gruppo geo-biologico"
    },
    {
      "code" : "72003001",
      "display" : "Scienze geologiche"
    },
    {
      "code" : "72003002",
      "display" : "Scienze naturali"
    },
    {
      "code" : "72003003",
      "display" : "Scienze biologiche"
    },
    {
      "code" : "72003004",
      "display" : "Scienze ambientali"
    },
    {
      "code" : "72003005",
      "display" : "Biotecnologie"
    },
    {
      "code" : "72003006",
      "display" : "Biotecnologie industriali"
    },
    {
      "code" : "72003007",
      "display" : "Biotecnologie veterinarie"
    },
    {
      "code" : "72003008",
      "display" : "Biotecnologie mediche"
    },
    {
      "code" : "72003009",
      "display" : "Biotecnologie agrarie vegetali"
    },
    {
      "code" : "72003999",
      "display" : "Altri diplomi di laurea del gruppo geo biologico"
    },
    {
      "code" : "72004000",
      "display" : "Gruppo medico"
    },
    {
      "code" : "72004001",
      "display" : "Medicina e chirurgia"
    },
    {
      "code" : "72004002",
      "display" : "Odontoiatria e protesi dentaria"
    },
    {
      "code" : "72004003",
      "display" : "Scienze della programmazione sanitaria"
    },
    {
      "code" : "72004999",
      "display" : "Altri diplomi di laurea del gruppo medico"
    },
    {
      "code" : "72005000",
      "display" : "Gruppo ingegneria"
    },
    {
      "code" : "72005002",
      "display" : "Ingegneria mineraria"
    },
    {
      "code" : "72005003",
      "display" : "Ingegneria meccanica"
    },
    {
      "code" : "72005004",
      "display" : "Ingegneria elettrotecnica"
    },
    {
      "code" : "72005005",
      "display" : "Ingegneria elettronica"
    },
    {
      "code" : "72005006",
      "display" : "Ingegneria nucleare"
    },
    {
      "code" : "72005007",
      "display" : "Ingegneria chimica"
    },
    {
      "code" : "72005008",
      "display" : "Ingegneria navale e meccanica"
    },
    {
      "code" : "72005009",
      "display" : "Ingegneria aerospaziale"
    },
    {
      "code" : "72005010",
      "display" : "Ingegneria civile"
    },
    {
      "code" : "72005011",
      "display" : "Ingegneria delle tecnologie industriali"
    },
    {
      "code" : "72005012",
      "display" : "Ingegneria civile per la difesa del suolo e pianificazione territoriale"
    },
    {
      "code" : "72005013",
      "display" : "Ingegneria forestale"
    },
    {
      "code" : "72005014",
      "display" : "Ingegneria dei materiali"
    },
    {
      "code" : "72005015",
      "display" : "Ingegneria informatica"
    },
    {
      "code" : "72005016",
      "display" : "Ingegneria elettrica"
    },
    {
      "code" : "72005017",
      "display" : "Ingegneria delle telecomunicazioni"
    },
    {
      "code" : "72005018",
      "display" : "Ingegneria gestionale"
    },
    {
      "code" : "72005019",
      "display" : "Ingegneria per l'ambiente e il territorio"
    },
    {
      "code" : "72005020",
      "display" : "Ingegneria edile"
    },
    {
      "code" : "72005021",
      "display" : "Ingegneria navale"
    },
    {
      "code" : "72005022",
      "display" : "Ingegneria biomedica"
    },
    {
      "code" : "72005023",
      "display" : "Ingegneria delle comunicazioni"
    },
    {
      "code" : "72005024",
      "display" : "Ingegneria industriale"
    },
    {
      "code" : "72005026",
      "display" : "Ingegneria aeronautica"
    },
    {
      "code" : "72005027",
      "display" : "Ingegneria civile difesa suolo"
    },
    {
      "code" : "72005029",
      "display" : "Ingegneria medica"
    },
    {
      "code" : "72005030",
      "display" : "Ingegneria dell'autoveicolo"
    },
    {
      "code" : "72005031",
      "display" : "Scienze matematiche per l'ingegneria"
    },
    {
      "code" : "72005032",
      "display" : "Ingegneria edile architettura"
    },
    {
      "code" : "72005999",
      "display" : "Altri diplomi di laurea del gruppo ingegneria"
    },
    {
      "code" : "72006000",
      "display" : "Gruppo architettura"
    },
    {
      "code" : "72006001",
      "display" : "Architettura"
    },
    {
      "code" : "72006002",
      "display" : "Urbanistica"
    },
    {
      "code" : "72006003",
      "display" : "Disegno industriale"
    },
    {
      "code" : "72006004",
      "display" : "Pianificazione territoriale ed urbanistica"
    },
    {
      "code" : "72006005",
      "display" : "Storia e conservazione dei beni architettonici e ambientali"
    },
    {
      "code" : "72006006",
      "display" : "Pianificazione territoriale, urbanistica ed ambientale"
    },
    {
      "code" : "72006007",
      "display" : "Arti visive"
    },
    {
      "code" : "72006008",
      "display" : "Cultura e tecnica del teatro"
    },
    {
      "code" : "72006999",
      "display" : "Altri diplomi di laurea del gruppo architettura"
    },
    {
      "code" : "72007000",
      "display" : "Gruppo agrario"
    },
    {
      "code" : "72007001",
      "display" : "Scienze agrarie"
    },
    {
      "code" : "72007002",
      "display" : "Scienze forestali"
    },
    {
      "code" : "72007003",
      "display" : "Scienze forestali ed ambientali"
    },
    {
      "code" : "72007004",
      "display" : "Medicina veterinaria"
    },
    {
      "code" : "72007005",
      "display" : "Scienze della produzione animale"
    },
    {
      "code" : "72007006",
      "display" : "Scienze delle preparazioni alimentari"
    },
    {
      "code" : "72007007",
      "display" : "Scienze agrarie tropicali e sub tropicali"
    },
    {
      "code" : "72007008",
      "display" : "Scienze e tecnologie alimentari"
    },
    {
      "code" : "72007009",
      "display" : "Scienze e tecnologie agrarie"
    },
    {
      "code" : "72007010",
      "display" : "Biotecnologie agro industriali"
    },
    {
      "code" : "72007011",
      "display" : "Scienze e tecnologie delle produzioni animali"
    },
    {
      "code" : "72007012",
      "display" : "Agricoltura tropicale e subtropicale"
    },
    {
      "code" : "72007999",
      "display" : "Altri diplomi di laurea del gruppo agrario"
    },
    {
      "code" : "72008000",
      "display" : "Gruppo economico-statistico"
    },
    {
      "code" : "72008001",
      "display" : "Economia e commercio"
    },
    {
      "code" : "72008002",
      "display" : "Scienze economiche"
    },
    {
      "code" : "72008003",
      "display" : "Scienze economiche e bancarie"
    },
    {
      "code" : "72008004",
      "display" : "Scienze statistiche e demografiche"
    },
    {
      "code" : "72008005",
      "display" : "Scienze statistiche demografiche e sociali"
    },
    {
      "code" : "72008006",
      "display" : "Scienze statistiche ed attuariali"
    },
    {
      "code" : "72008007",
      "display" : "Scienze statistiche ed economiche"
    },
    {
      "code" : "72008008",
      "display" : "Economia aziendale"
    },
    {
      "code" : "72008009",
      "display" : "Economia bancaria"
    },
    {
      "code" : "72008010",
      "display" : "Economia politica"
    },
    {
      "code" : "72008011",
      "display" : "Economia delle istituzioni e dei mercati finanziari"
    },
    {
      "code" : "72008012",
      "display" : "Economia delle amministrazioni pubbliche e delle istituzioni internazionali"
    },
    {
      "code" : "72008013",
      "display" : "Economia e legislazione per l'impresa"
    },
    {
      "code" : "72008014",
      "display" : "Economia del turismo"
    },
    {
      "code" : "72008015",
      "display" : "Statistica e informatica per l'azienda"
    },
    {
      "code" : "72008016",
      "display" : "Scienze economiche e sociali"
    },
    {
      "code" : "72008017",
      "display" : "Discipline economiche e sociali"
    },
    {
      "code" : "72008018",
      "display" : "Commercio internazionale e mercati valutari"
    },
    {
      "code" : "72008019",
      "display" : "Economia marittima e dei trasporti"
    },
    {
      "code" : "72008020",
      "display" : "Economia bancaria, finanziaria e assicurativa"
    },
    {
      "code" : "72008021",
      "display" : "Economia ambientale"
    },
    {
      "code" : "72008022",
      "display" : "Economia assicurativa e previdenziale"
    },
    {
      "code" : "72008023",
      "display" : "Statistica"
    },
    {
      "code" : "72008024",
      "display" : "Economia del commercio internazionale e dei mercati valutari"
    },
    {
      "code" : "72008025",
      "display" : "Economia bancaria e assicurativa"
    },
    {
      "code" : "72008026",
      "display" : "Economia e finanza"
    },
    {
      "code" : "72008027",
      "display" : "Economia industriale"
    },
    {
      "code" : "72008028",
      "display" : "Economia e gestione dei servizi"
    },
    {
      "code" : "72008029",
      "display" : "Economia per le arti, la cultura e la comunicazione"
    },
    {
      "code" : "72008030",
      "display" : "Scienze economiche, statistiche e sociali"
    },
    {
      "code" : "72008031",
      "display" : "Scienze turistiche"
    },
    {
      "code" : "72008032",
      "display" : "Marketing"
    },
    {
      "code" : "72008996",
      "display" : "Scienze coloniali"
    },
    {
      "code" : "72008997",
      "display" : "Scienze bancarie e assicurative"
    },
    {
      "code" : "72008998",
      "display" : "Scienze economiche e marittime"
    },
    {
      "code" : "72008999",
      "display" : "Altri diplomi di laurea del gruppo economico statistico"
    },
    {
      "code" : "72009000",
      "display" : "Gruppo politico-sociale"
    },
    {
      "code" : "72009001",
      "display" : "Scienze politiche"
    },
    {
      "code" : "72009002",
      "display" : "Sociologia"
    },
    {
      "code" : "72009003",
      "display" : "Scienze internazionali e diplomatiche"
    },
    {
      "code" : "72009004",
      "display" : "Scienze della comunicazione"
    },
    {
      "code" : "72009005",
      "display" : "Relazioni pubbliche"
    },
    {
      "code" : "72009006",
      "display" : "Politica del territorio"
    },
    {
      "code" : "72009007",
      "display" : "Servizio sociale"
    },
    {
      "code" : "72009996",
      "display" : "Scienze politiche per l'Oriente"
    },
    {
      "code" : "72009997",
      "display" : "Scienze politiche per l'Europa occidentale"
    },
    {
      "code" : "72009998",
      "display" : "Scienze politiche per l'Europa orientale"
    },
    {
      "code" : "72009999",
      "display" : "Altri diplomi di laurea del gruppo politico sociale"
    },
    {
      "code" : "72010000",
      "display" : "Gruppo giuridico"
    },
    {
      "code" : "72010001",
      "display" : "Giurisprudenza"
    },
    {
      "code" : "72010002",
      "display" : "Scienze dell'amministrazione"
    },
    {
      "code" : "72010003",
      "display" : "Scienze strategiche"
    },
    {
      "code" : "72010999",
      "display" : "Altri diplomi di laurea del gruppo giuridico"
    },
    {
      "code" : "72011000",
      "display" : "Gruppo letterario"
    },
    {
      "code" : "72011001",
      "display" : "Lettere"
    },
    {
      "code" : "72011002",
      "display" : "Materie letterarie"
    },
    {
      "code" : "72011003",
      "display" : "Filosofia"
    },
    {
      "code" : "72011004",
      "display" : "Geografia"
    },
    {
      "code" : "72011005",
      "display" : "Discipline dell'arte, della musica e dello spettacolo"
    },
    {
      "code" : "72011006",
      "display" : "Storia"
    },
    {
      "code" : "72011007",
      "display" : "Conservazione dei beni culturali"
    },
    {
      "code" : "72011008",
      "display" : "Studi islamici"
    },
    {
      "code" : "72011009",
      "display" : "Filologia e storia dell'Europa orientale"
    },
    {
      "code" : "72011010",
      "display" : "Musicologia"
    },
    {
      "code" : "72011011",
      "display" : "Studi comparatistici"
    },
    {
      "code" : "72011012",
      "display" : "Storia e conservazione dei beni culturali"
    },
    {
      "code" : "72011013",
      "display" : "Scienze della cultura"
    },
    {
      "code" : "72011014",
      "display" : "Filologie, storia e cultura dei Paesi islamici"
    },
    {
      "code" : "72011015",
      "display" : "Lingue e culture dell'Europa orientale"
    },
    {
      "code" : "72011016",
      "display" : "Archivisti paleografi"
    },
    {
      "code" : "72011017",
      "display" : "Bibliotecari"
    },
    {
      "code" : "72011018",
      "display" : "Conservatore di manoscritti"
    },
    {
      "code" : "72011998",
      "display" : "Storia e filosofia"
    },
    {
      "code" : "72011997",
      "display" : "Teologia (Università Gregoriana)"
    },
    {
      "code" : "72011999",
      "display" : "Altri diplomi di laurea del gruppo letterario"
    },
    {
      "code" : "72012000",
      "display" : "Gruppo linguistico"
    },
    {
      "code" : "72012001",
      "display" : "Lingue e letterature straniere moderne"
    },
    {
      "code" : "72012002",
      "display" : "Lingue e letterature straniere"
    },
    {
      "code" : "72012003",
      "display" : "Lingue e civiltà orientali"
    },
    {
      "code" : "72012004",
      "display" : "Lingue e letterature orientali"
    },
    {
      "code" : "72012005",
      "display" : "Traduzione ed interpretazione"
    },
    {
      "code" : "72012006",
      "display" : "Interprete"
    },
    {
      "code" : "72012007",
      "display" : "Traduttore"
    },
    {
      "code" : "72012008",
      "display" : "Lingue e culture europee"
    },
    {
      "code" : "72012009",
      "display" : "Lingue e letterature dell'Europa orientale"
    },
    {
      "code" : "72012010",
      "display" : "Lingua e cultura italiana"
    },
    {
      "code" : "72012011",
      "display" : "Comunicazione internazionale"
    },
    {
      "code" : "72012012",
      "display" : "Scienze e tecniche dell'interculturalità"
    },
    {
      "code" : "72012013",
      "display" : "Lingue culture ed istituzioni dei paesi del mediterraneo"
    },
    {
      "code" : "72012994",
      "display" : "Lingue, letterature e istituzioni dell'Europa occidentale"
    },
    {
      "code" : "72012995",
      "display" : "Lingue, letterature e istituzioni dell'Europa orientale"
    },
    {
      "code" : "72012996",
      "display" : "Lingue e letterature slave"
    },
    {
      "code" : "72012997",
      "display" : "Lingue e letterature straniere (europee)"
    },
    {
      "code" : "72012998",
      "display" : "Lingue e letterature europee"
    },
    {
      "code" : "72012999",
      "display" : "Altri diplomi di laurea del gruppo linguistico"
    },
    {
      "code" : "72013000",
      "display" : "Gruppo insegnamento"
    },
    {
      "code" : "72013001",
      "display" : "Pedagogia"
    },
    {
      "code" : "72013002",
      "display" : "Scienze dell'educazione"
    },
    {
      "code" : "72013003",
      "display" : "Scienze della formazione primaria"
    },
    {
      "code" : "72013999",
      "display" : "Altri diplomi di laurea del gruppo insegnamento"
    },
    {
      "code" : "72014000",
      "display" : "Gruppo psicologico"
    },
    {
      "code" : "72014001",
      "display" : "Psicologia"
    },
    {
      "code" : "72014999",
      "display" : "Altri diplomi di laurea del gruppo psicologico"
    },
    {
      "code" : "72015000",
      "display" : "Gruppo educazione fisica"
    },
    {
      "code" : "72015001",
      "display" : "Scienze motorie"
    },
    {
      "code" : "72015999",
      "display" : "Altri diplomi di laurea del gruppo educazione fisica"
    },
    {
      "code" : "72999999",
      "display" : "Altri diplomi di laurea  (vecchio ordinamento)"
    },
    {
      "code" : "73000000",
      "display" : "LAUREA SPECIALISTICA A CICLO UNICO - Nuovo ordinamento (corsi di 5/6 anni)"
    },
    {
      "code" : "73002000",
      "display" : "Gruppo chimico farmaceutico"
    },
    {
      "code" : "73002001",
      "display" : "Farmacia e farmacia industriale"
    },
    {
      "code" : "73002999",
      "display" : "Altre lauree specialistiche del gruppo chimico farmaceutico"
    },
    {
      "code" : "73004000",
      "display" : "Gruppo medico"
    },
    {
      "code" : "73004001",
      "display" : "Medicina e chirurgia"
    },
    {
      "code" : "73004002",
      "display" : "Odontoiatria e protesi dentaria"
    },
    {
      "code" : "73004999",
      "display" : "Altre lauree specialistiche del gruppo medico"
    },
    {
      "code" : "73006000",
      "display" : "Gruppo architettura"
    },
    {
      "code" : "73006001",
      "display" : "Architettura e ingegneria edile"
    },
    {
      "code" : "73006999",
      "display" : "Altre lauree specialistiche del gruppo architettura"
    },
    {
      "code" : "73007000",
      "display" : "Gruppo agrario"
    },
    {
      "code" : "73007001",
      "display" : "Medicina veterinaria"
    },
    {
      "code" : "73007999",
      "display" : "Altre lauree specialistiche del gruppo agrario"
    },
    {
      "code" : "73999999",
      "display" : "Altre lauree specialistiche a ciclo unico"
    },
    {
      "code" : "74000000",
      "display" : "LAUREA SPECIALISTICA - Nuovo ordinamento (corsi di secondo livello di 2 anni)"
    },
    {
      "code" : "74001000",
      "display" : "Gruppo scientifico"
    },
    {
      "code" : "74001001",
      "display" : "Fisica"
    },
    {
      "code" : "74001002",
      "display" : "Informatica"
    },
    {
      "code" : "74001003",
      "display" : "Informatica per le discipline umanistiche"
    },
    {
      "code" : "74001999",
      "display" : "Altri diplomi di laurea del gruppo scientifico"
    },
    {
      "code" : "74002000",
      "display" : "Gruppo chimico farmaceutico"
    },
    {
      "code" : "74002001",
      "display" : "Scienze chimiche"
    },
    {
      "code" : "74002002",
      "display" : "Scienze e tecnologie della chimica industriale"
    },
    {
      "code" : "74002999",
      "display" : "Altri diplomi del gruppo chimico farmaceutico"
    },
    {
      "code" : "74003000",
      "display" : "Gruppo geo-biologico"
    },
    {
      "code" : "74003001",
      "display" : "Biologia"
    },
    {
      "code" : "74003002",
      "display" : "Biotecnologie industriali"
    },
    {
      "code" : "74003003",
      "display" : "Scienze e tecnologie per l'ambiente e il territorio"
    },
    {
      "code" : "74003004",
      "display" : "Scienze geologiche"
    },
    {
      "code" : "74003999",
      "display" : "Altri diplomi di laurea del gruppo geo biologico"
    },
    {
      "code" : "74004000",
      "display" : "Gruppo medico"
    },
    {
      "code" : "74004001",
      "display" : "Scienze della nutrizione umana"
    },
    {
      "code" : "74004999",
      "display" : "Altre lauree di primo livello del guppo medico"
    },
    {
      "code" : "74005000",
      "display" : "Gruppo ingegneria"
    },
    {
      "code" : "74005001",
      "display" : "Ingegneria dell'automazione"
    },
    {
      "code" : "74005002",
      "display" : "Ingegneria delle telecomunicazioni"
    },
    {
      "code" : "74005003",
      "display" : "Ingegneria elettronica"
    },
    {
      "code" : "74005004",
      "display" : "ingegneria gestionale"
    },
    {
      "code" : "74005005",
      "display" : "Ingegneria informatica"
    },
    {
      "code" : "74005006",
      "display" : "Ingegneria per l'ambiente e il territorio"
    },
    {
      "code" : "74005007",
      "display" : "Ingegneria civile"
    },
    {
      "code" : "74005008",
      "display" : "Ingegneria elettrica"
    },
    {
      "code" : "74005009",
      "display" : "Ingegneria energetica e nucleare"
    },
    {
      "code" : "40301999",
      "display" : "Altri diplomi di istruzione secondaria superiore di scuola magistrale"
    },
    {
      "code" : "40302000",
      "display" : "Diploma di istruzione secondaria superiore di Istituto magistrale"
    },
    {
      "code" : "40302001",
      "display" : "Magistrale"
    },
    {
      "code" : "40302002",
      "display" : "Biologico chimico"
    },
    {
      "code" : "40302003",
      "display" : "Linguistico"
    },
    {
      "code" : "40302004",
      "display" : "Psico-socio-pedagogico"
    },
    {
      "code" : "40302005",
      "display" : "Classico"
    },
    {
      "code" : "40302006",
      "display" : "Scientifico"
    },
    {
      "code" : "40302007",
      "display" : "Dirigenti di comunità"
    },
    {
      "code" : "40302008",
      "display" : "Liceo sociale"
    },
    {
      "code" : "40302009",
      "display" : "Pedagogico musicale"
    },
    {
      "code" : "40302010",
      "display" : "Socio-ambientale"
    },
    {
      "code" : "40302011",
      "display" : "Scienze umane"
    },
    {
      "code" : "40302012",
      "display" : "Scienze delle formazione"
    },
    {
      "code" : "40302999",
      "display" : "Altri diplomi di istruzione secondaria superiore di istituto magistrale"
    },
    {
      "code" : "40500000",
      "display" : "DIPLOMA DI ISTRUZIONE SECONDARIA SUPERIORE LICEALE"
    },
    {
      "code" : "40501000",
      "display" : "Diploma di istruzione secondaria superiore di Liceo scientifico"
    },
    {
      "code" : "40501001",
      "display" : "Scientifico"
    },
    {
      "code" : "40501002",
      "display" : "Artistico"
    },
    {
      "code" : "40501003",
      "display" : "Biologico chimico"
    },
    {
      "code" : "40501004",
      "display" : "Classico"
    },
    {
      "code" : "40501005",
      "display" : "Amministrativo"
    },
    {
      "code" : "40501006",
      "display" : "Giuridico economico aziendale"
    },
    {
      "code" : "40501007",
      "display" : "Matematico"
    },
    {
      "code" : "40501008",
      "display" : "Linguistico"
    },
    {
      "code" : "40501009",
      "display" : "Magistrale"
    },
    {
      "code" : "40501010",
      "display" : "Psico-socio-pedagogico"
    },
    {
      "code" : "40501011",
      "display" : "Turismo"
    },
    {
      "code" : "40501012",
      "display" : "Informatico-telematico"
    },
    {
      "code" : "40501013",
      "display" : "Scientifico ambientale"
    },
    {
      "code" : "40501014",
      "display" : "Scientifico-economico"
    },
    {
      "code" : "40501015",
      "display" : "Scientifico tecnologico"
    },
    {
      "code" : "40501016",
      "display" : "Liceo della comunicazione"
    },
    {
      "code" : "40501999",
      "display" : "Altri diplomi di istruzione secondaria superiore di liceo scientifico"
    },
    {
      "code" : "40502000",
      "display" : "Diploma di istruzione secondaria superiore di Liceo classico"
    },
    {
      "code" : "40502001",
      "display" : "Classico"
    },
    {
      "code" : "40502002",
      "display" : "Architettura e arredo"
    },
    {
      "code" : "40502003",
      "display" : "Arte e restauro"
    },
    {
      "code" : "40502004",
      "display" : "Artistico"
    },
    {
      "code" : "40502005",
      "display" : "Conservazione, catalogazione beni culturali"
    },
    {
      "code" : "40502006",
      "display" : "Giuridico economico aziendale"
    },
    {
      "code" : "40502007",
      "display" : "Linguistico"
    },
    {
      "code" : "40502008",
      "display" : "Magistrale"
    },
    {
      "code" : "40502009",
      "display" : "Psico-socio-pedagogico"
    },
    {
      "code" : "40502010",
      "display" : "Scientifico"
    },
    {
      "code" : "40502011",
      "display" : "Matematico"
    },
    {
      "code" : "40502999",
      "display" : "Altri diplomi di istruzione secondaria superiore di liceo classico"
    },
    {
      "code" : "40503000",
      "display" : "Diploma di istruzione secondaria superiore di Liceo linguistico"
    },
    {
      "code" : "40503001",
      "display" : "Linguistico"
    },
    {
      "code" : "40503002",
      "display" : "Informatica e comunicazione"
    },
    {
      "code" : "40503003",
      "display" : "Artistico"
    },
    {
      "code" : "40503004",
      "display" : "Classico"
    },
    {
      "code" : "40503005",
      "display" : "Giuridico economico aziendale"
    },
    {
      "code" : "40503006",
      "display" : "Magistrale"
    },
    {
      "code" : "40503007",
      "display" : "Psico-socio-pedagogico"
    },
    {
      "code" : "40503008",
      "display" : "Scientifico-linguistico"
    },
    {
      "code" : "40503999",
      "display" : "Altri diplomi di istruzione secondaria superiore di liceo linguistico"
    },
    {
      "code" : "40600000",
      "display" : "ISTRUZIONE ARTISTICA"
    },
    {
      "code" : "40601000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo d'arte applicata"
    },
    {
      "code" : "40601001",
      "display" : "Arte dei metalli"
    },
    {
      "code" : "40601002",
      "display" : "Arte dei metalli ed orificeria"
    },
    {
      "code" : "40601003",
      "display" : "Arte dei rivestimenti ceramici edilizi"
    },
    {
      "code" : "40601004",
      "display" : "Arte dell'alabastro"
    },
    {
      "code" : "40601005",
      "display" : "Arte della ceramica"
    },
    {
      "code" : "40601006",
      "display" : "Arte grafica pubblicitaria e fotografia"
    },
    {
      "code" : "40601007",
      "display" : "Arte della porcellana"
    },
    {
      "code" : "40601008",
      "display" : "Arte dell'arredamento"
    },
    {
      "code" : "40601009",
      "display" : "Arte della stampa"
    },
    {
      "code" : "40601010",
      "display" : "Arte del corallo"
    },
    {
      "code" : "40601011",
      "display" : "Arte del gres"
    },
    {
      "code" : "40601012",
      "display" : "Arte del legno"
    },
    {
      "code" : "40601013",
      "display" : "Arte del legno e restauro del mobile antico"
    },
    {
      "code" : "40601014",
      "display" : "Arte del merletto e ricamo"
    },
    {
      "code" : "40601015",
      "display" : "Arte del mobile"
    },
    {
      "code" : "40601016",
      "display" : "Arte del mosaico"
    },
    {
      "code" : "40601017",
      "display" : "Arte del tessuto"
    },
    {
      "code" : "40601018",
      "display" : "Arte del vetro"
    },
    {
      "code" : "40601019",
      "display" : "Arte del vetro e cristallo"
    },
    {
      "code" : "40601020",
      "display" : "Arte delle pietre dure"
    },
    {
      "code" : "40601021",
      "display" : "Arte e restauro"
    },
    {
      "code" : "40601022",
      "display" : "Arte pubblicitaria"
    },
    {
      "code" : "40601023",
      "display" : "Arti grafiche"
    },
    {
      "code" : "40601024",
      "display" : "Calcografia"
    },
    {
      "code" : "40601025",
      "display" : "Comunicazioni visive"
    },
    {
      "code" : "40601026",
      "display" : "Decorazione pittorica"
    },
    {
      "code" : "40601027",
      "display" : "Decorazione plastica"
    },
    {
      "code" : "40601028",
      "display" : "Design per ambiente"
    },
    {
      "code" : "40601029",
      "display" : "Disegnatori d'architettura"
    },
    {
      "code" : "40601030",
      "display" : "Disegnatori architettura e arredamento"
    },
    {
      "code" : "40601031",
      "display" : "Disegno animato"
    },
    {
      "code" : "40601032",
      "display" : "Disegno industriale"
    },
    {
      "code" : "40601033",
      "display" : "Fotografia artistica"
    },
    {
      "code" : "40601034",
      "display" : "Litografia"
    },
    {
      "code" : "40601035",
      "display" : "Moda e costume"
    },
    {
      "code" : "40601036",
      "display" : "Oreficeria"
    },
    {
      "code" : "40601037",
      "display" : "Progetto design"
    },
    {
      "code" : "40601038",
      "display" : "Restauro ceramico"
    },
    {
      "code" : "40601039",
      "display" : "Rilegatura artistica e restauro del libro"
    },
    {
      "code" : "40601040",
      "display" : "Rilievo e catalogazione"
    },
    {
      "code" : "40601041",
      "display" : "Scenotecnica"
    },
    {
      "code" : "40601042",
      "display" : "Tecnologia ceramica"
    },
    {
      "code" : "40601043",
      "display" : "Xilografia"
    },
    {
      "code" : "40601044",
      "display" : "Tecnico dell'industria audiovisiva"
    },
    {
      "code" : "40601999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo d'arte applicata"
    },
    {
      "code" : "40602000",
      "display" : "Diploma di istruzione secondaria superiore ad indirizzo artistico"
    },
    {
      "code" : "40602001",
      "display" : "Sezione accademia"
    },
    {
      "code" : "40602002",
      "display" : "Sezione architettura"
    },
    {
      "code" : "40602003",
      "display" : "Indirizzo artistico musicale"
    },
    {
      "code" : "40602004",
      "display" : "Archeologico"
    },
    {
      "code" : "40602005",
      "display" : "Architettura e arredo"
    },
    {
      "code" : "40602006",
      "display" : "Arti visive"
    },
    {
      "code" : "40602007",
      "display" : "Conservazione e restauro"
    },
    {
      "code" : "40602008",
      "display" : "Artistico"
    },
    {
      "code" : "40602009",
      "display" : "Conservazione, catalogazione beni culturali"
    },
    {
      "code" : "40602010",
      "display" : "Figurativo"
    },
    {
      "code" : "40602011",
      "display" : "Grafica"
    },
    {
      "code" : "40602012",
      "display" : "Pittura e decorazione pittorica"
    },
    {
      "code" : "40602013",
      "display" : "Scultura e decorazione plastica"
    },
    {
      "code" : "40602014",
      "display" : "Artistico musicale"
    },
    {
      "code" : "40602015",
      "display" : "Composizione e progettazione"
    },
    {
      "code" : "40602016",
      "display" : "Coreutico"
    },
    {
      "code" : "40602017",
      "display" : "Arte del vetro e del cristallo"
    },
    {
      "code" : "40602018",
      "display" : "Arte e spettacolo"
    },
    {
      "code" : "40602999",
      "display" : "Altri diplomi di istruzione secondaria superiore ad indirizzo artistico"
    },
    {
      "code" : "40999999",
      "display" : "Altri diplomi di istruzione secondaria superiore che permettono l'accesso all'università"
    },
    {
      "code" : "50000000",
      "display" : "DIPLOMA TERZIARIO EXTRA-UNIVERSITARIO"
    },
    {
      "code" : "50600000",
      "display" : "ISTRUZIONE ARTISTICA"
    },
    {
      "code" : "50603000",
      "display" : "Diploma di Accademia di belle arti"
    },
    {
      "code" : "50603001",
      "display" : "Scultura"
    },
    {
      "code" : "50603002",
      "display" : "Pittura"
    },
    {
      "code" : "50603003",
      "display" : "Scenografia"
    },
    {
      "code" : "50603004",
      "display" : "Decorazione"
    },
    {
      "code" : "50603005",
      "display" : "Arti visive e discipline dello spettacolo"
    },
    {
      "code" : "50603999",
      "display" : "Altri diplomi di accademia di belle arti"
    },
    {
      "code" : "50604000",
      "display" : "Diploma di Istituto superiore di industrie artistiche"
    },
    {
      "code" : "50604001",
      "display" : "Disegno industriale"
    },
    {
      "code" : "50604002",
      "display" : "Progettazione grafica"
    },
    {
      "code" : "71006002",
      "display" : "Urbanistica e scienze della pianificazione territoriale e ambientale"
    },
    {
      "code" : "71006003",
      "display" : "Disegno industriale"
    },
    {
      "code" : "71006999",
      "display" : "Altre lauree di primo livello del guppo architettura"
    },
    {
      "code" : "71007000",
      "display" : "Gruppo agrario"
    },
    {
      "code" : "71007001",
      "display" : "Scienze e tecnologie agrarie, agroalimentari e forestali"
    },
    {
      "code" : "71007002",
      "display" : "Scienze e tecnologie zootecniche e delle produzioni animali"
    },
    {
      "code" : "71007999",
      "display" : "Altre lauree di primo livello del guppo agrario"
    },
    {
      "code" : "71008000",
      "display" : "Gruppo economico-statistico"
    },
    {
      "code" : "71008001",
      "display" : "Scienze dell'economia e della gestione aziendale"
    },
    {
      "code" : "71008002",
      "display" : "Scienze economiche"
    },
    {
      "code" : "71008003",
      "display" : "Scienze statistiche"
    },
    {
      "code" : "71008999",
      "display" : "Altre lauree di primo livello del guppo economico statistico"
    },
    {
      "code" : "71009000",
      "display" : "Gruppo politico-sociale"
    },
    {
      "code" : "71009001",
      "display" : "Scienze del servizio sociale"
    },
    {
      "code" : "71009002",
      "display" : "Scienze della comunicazione"
    },
    {
      "code" : "71009003",
      "display" : "Scienze politiche e delle relazioni internazionali"
    },
    {
      "code" : "71009004",
      "display" : "Scienze dell'amministrazione"
    },
    {
      "code" : "71009005",
      "display" : "Scienze sociali per la cooperazione, lo sviluppo e la pace"
    },
    {
      "code" : "71009006",
      "display" : "Scienze sociologiche"
    },
    {
      "code" : "71009007",
      "display" : "Scienze del turismo"
    },
    {
      "code" : "71009999",
      "display" : "Altre lauree di primo livello del guppo politico sociale"
    },
    {
      "code" : "71010000",
      "display" : "Gruppo giuridico"
    },
    {
      "code" : "71010001",
      "display" : "Scienze dei servizi giuridici"
    },
    {
      "code" : "71010002",
      "display" : "Scienze giuridiche"
    },
    {
      "code" : "71010999",
      "display" : "Altre lauree di primo livello del guppo giuridico"
    },
    {
      "code" : "74005010",
      "display" : "Ingegneria meccanica"
    },
    {
      "code" : "74005999",
      "display" : "Altre lauree specialistiche del gruppo ingegneria"
    },
    {
      "code" : "74006000",
      "display" : "Gruppo architettura"
    },
    {
      "code" : "74006001",
      "display" : "Architettura e ingegneria edile"
    },
    {
      "code" : "74006999",
      "display" : "Altre lauree specialistiche del gruppo architettura"
    },
    {
      "code" : "74007000",
      "display" : "Gruppo agrario"
    },
    {
      "code" : "74007001",
      "display" : "Scienze e gestione della risorse rurali e forestali"
    },
    {
      "code" : "74007002",
      "display" : "Scienze e tecnologie agrarie"
    },
    {
      "code" : "74007003",
      "display" : "Scienze e tecnologie agrozootecniche"
    },
    {
      "code" : "74007999",
      "display" : "Altre lauree specialistiche del gruppo agrario"
    },
    {
      "code" : "74008000",
      "display" : "Gruppo economico-statistico"
    },
    {
      "code" : "74008001",
      "display" : "Scienze dell'ecomomia"
    },
    {
      "code" : "74008002",
      "display" : "Scienze ecomomico-aziendali"
    },
    {
      "code" : "74008003",
      "display" : "Statistica economica, finanziaria e attuariale"
    },
    {
      "code" : "74008999",
      "display" : "Altre lauree specialistiche del gruppo economico-statistico"
    },
    {
      "code" : "74009000",
      "display" : "Gruppo politico-sociale"
    },
    {
      "code" : "74009001",
      "display" : "Tecniche e metodi per la società dell'informazione"
    },
    {
      "code" : "74009002",
      "display" : "Scienze dei beni culturali"
    },
    {
      "code" : "74009003",
      "display" : "Metodi per l'analisi valutativa dei sistemi complessi"
    },
    {
      "code" : "74009004",
      "display" : "Programmazione e gestione delle politiche e dei servizi sociali"
    },
    {
      "code" : "74009005",
      "display" : "Scienze della comunicazione sociale e istituzionale"
    },
    {
      "code" : "74009006",
      "display" : "Scienze delle pubbliche amministrazioni"
    },
    {
      "code" : "74009007",
      "display" : "Sociologia"
    },
    {
      "code" : "74009008",
      "display" : "Studi europei"
    },
    {
      "code" : "74009999",
      "display" : "Altri diplomi di laurea del gruppo politico sociale"
    },
    {
      "code" : "74011000",
      "display" : "Gruppo letterario"
    },
    {
      "code" : "74011001",
      "display" : "Archeologia"
    },
    {
      "code" : "74011002",
      "display" : "Archivistica e biblioteconomia"
    },
    {
      "code" : "74011003",
      "display" : "Filologia e letterature dell'antichità"
    },
    {
      "code" : "74011004",
      "display" : "Filologia moderna"
    },
    {
      "code" : "74011005",
      "display" : "Filosofia teoretica, morale, politica ed estetica"
    },
    {
      "code" : "74011006",
      "display" : "Musicologia e beni musicali"
    },
    {
      "code" : "74011007",
      "display" : "Scienze dello spettacolo e della produzione multimediale"
    },
    {
      "code" : "74011008",
      "display" : "Storia antica"
    },
    {
      "code" : "74011009",
      "display" : "Storia contemporanea"
    },
    {
      "code" : "74011010",
      "display" : "Storia dell'arte"
    },
    {
      "code" : "74011011",
      "display" : "Storia della filosofia"
    },
    {
      "code" : "74011012",
      "display" : "Storia medievale"
    },
    {
      "code" : "74011999",
      "display" : "Altri diplomi di laurea del gruppo letterario"
    },
    {
      "code" : "74012000",
      "display" : "Gruppo linguistico"
    },
    {
      "code" : "74012001",
      "display" : "Traduzione letteraria e traduzione tecnico-scientifica"
    },
    {
      "code" : "74012002",
      "display" : "Interpretariato di conferenza"
    },
    {
      "code" : "74012003",
      "display" : "Lingue e letterature moderne euroamericane"
    },
    {
      "code" : "74012004",
      "display" : "Linguistica"
    },
    {
      "code" : "74012999",
      "display" : "Altri diplomi di laurea del gruppo linguistico"
    },
    {
      "code" : "74013000",
      "display" : "Gruppo insegnamento"
    },
    {
      "code" : "74013001",
      "display" : "Programmazione e gestione dei servizi educativi e formativi"
    },
    {
      "code" : "74013002",
      "display" : "Scienze dell'educazione degli adulti e della formazione continua"
    },
    {
      "code" : "74013003",
      "display" : "Scienze pedagogiche"
    },
    {
      "code" : "74013999",
      "display" : "Altri diplomi di laurea del gruppo insegnamento"
    },
    {
      "code" : "74014000",
      "display" : "Gruppo psicologico"
    },
    {
      "code" : "74014001",
      "display" : "Psicologia"
    },
    {
      "code" : "74014999",
      "display" : "Altri diplomi di laurea del gruppo psicologico"
    },
    {
      "code" : "74016000",
      "display" : "Gruppo difesa e sicurezza"
    },
    {
      "code" : "74016001",
      "display" : "Scienze della difesa e della sicurezza"
    },
    {
      "code" : "74016999",
      "display" : "Altri diplomi di laurea del gruppo difesa e sicurezza"
    },
    {
      "code" : "74999999",
      "display" : "Altre lauree specialistiche"
    },
    {
      "code" : "80000000",
      "display" : "TITOLO DI STUDIO POST-LAUREA"
    },
    {
      "code" : "81000000",
      "display" : "MASTER UNIVERSITARIO DI PRIMO LIVELLO"
    },
    {
      "code" : "82000000",
      "display" : "MASTER UNIVERSITARIO DI SECONDO LIVELLO"
    },
    {
      "code" : "83000000",
      "display" : "DIPLOMA DI SPECIALIZZAZIONE"
    },
    {
      "code" : "90000000",
      "display" : "TITOLO DI DOTTORE DI RICERCA"
    }
  ]
}

```
