# Home - CDA to FHIR Maps v0.1.0

* [**Table of Contents**](toc.md)
* **Home**

CDA to FHIR Maps, published by HL7 Italy. This guide is not an authorized publication; it is the continuous build for version 0.1.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/hl7-it/cda2fhir/](https://github.com/hl7-it/cda2fhir/) and changes regularly. See the [Directory of published versions](http://hl7.it/fhir/cda2fhir/history.html)

Plain Language Summary goes here

## Home

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/cda2fhir/ImplementationGuide/hl7.fhir.it.cda2fhir | *Version*:0.1.0 |
| Draft as of 2025-10-01 | *Computable Name*:HL7ItCda2FhirMapIG |

* [Scopo](#scopo)
* [Definizione delle Mappe di trasformazione](#definizione-delle-mappe-di-trasformazione)
* [Funzionalità delle Mappe di trasformazione](#funzionalità-delle-mappe-di-trasformazione)
* [Autori e contributori](#autori-e-contributori)

### Scopo

Questa guida all'implementazione fornisce le mappe per trasformare i documenti da CDA a FHIR utilizzando il [FHIR Mapping Language (FML)](https://www.hl7.org/fhir/mapping-language.html).

Le mappe possono essere riutilizzate all'interno di altre mappe, infatti, è definita la trasformazione dei datatypes del CDA nei corrispettivi FHIR, la trasformazione dei campi del header di un documento CDA2 in risorse FHIR e infine, la mappa dei campi del body del documento specifico.

### Definizione delle Mappe di trasformazione

Le mappe elencate nella tabella seguente sono disponibili come [FHIR Structure Maps](https://www.hl7.org/fhir/structuremap.html).

I documenti previsti per la trasformata includono i documenti del nucleo minimo per l'attuazione del FSE (Fascicolo Sanitario Elettronico).

| | |
| :--- | :--- |
| Tipo di dati | [Trasformata del tipo di dato](StructureMap-cda2fhirDataTypes.md) |
| Documenti | [Header CDA in Bundle](StructureMap-cda2fhirHeader.md) |
|   | [Referto di Laboratorio in Bundle](StructureMap-cda2fhirLabReport.md) |
|   | [Referto di Radiologia in Bundle](StructureMap-cda2fhirRadReport.md) |
|   | [Lettera di Dimissione Ospedaliera in Bundle](StructureMap-cda2fhirLdo.md) |
|   | [Referto di Specialistica Ambulatoriale in Bundle](StructureMap-cda2fhirAmbReport.md) |
|   | [Certificato Vaccinale e Singola Vaccinazione in Bundle](StructureMap-cda2fhirVaccination.md) |
|   | [Verbale di Pronto Soccorso in Bundle](StructureMap-cda2fhirEdReport.md) |
|   | [Profilo Sanitario Sintetico (PSS) in Bundle](StructureMap-cda2fhirPs.md) |

### Funzionalità delle Mappe di trasformazione

L'architettura del FSE nazionale prevede la progettazione di un Gateway FHIR che rappresenta il punto di governo dell’intera piattaforma in quanto avrà il compito di verificare che i dati clinici, prodotti dai sistemi delle strutture sanitarie, rispettino le regole sintattiche e semantiche, di data quality e di privacy previste dall’affinity domain. Dopo la validazione, il Gateway ha il compito di tradurli nel formato HL7 FHIR.

Le mappe rappresentano lo strumento tramite il quale il Gateway può generare una Bundle a partire da un documento CDA, abilitando il processo di trasformazione.

| |
| :--- |
| ![](Trasformazione.png)Figura 1 - Logica di Trasformazione in FHIR |

### Autori e contributori

| | | | |
| :--- | :--- | :--- | :--- |
| Autore | Ilenia Centonze | EY Advisory spa | ilenia.centonze@it.ey.com |
| Autore | Maria Teresa De Pippo | EY Advisory spa | maria.teresa.de.pippo@it.ey.com |
| Autore | Xhuliana Haxhi | EY Advisory spa | Xhuliana.haxhi@it.ey.com |
| Autore | Orgest Kuqi | EY Advisory spa | orgest.kuqi@it.ey.com |
| Autore | Marta Oliverio | EY Advisory spa | marta.oliverio@it.ey.com |
| Autore | Davide Spanu | EY Advisory spa | davide.spanu@it.ey.com |
| Autore | Eleny Mulugeta Teklehaimanot | EY Advisory spa | eleny.mulugeta.teklehaimanot@it.ey.com |
| Autore | Augusto Ruggeri | EY Advisory spa | augusto.ruggeri@it.ey.com |
| Contributore | Giorgio Cangioli | Hl7 Italia | giorgio.cangioli@gmail.com |
| Contributore | Leonardo Alcaro | Hl7 Italia | leonardo.alcaro@teamdigitale.governo.it |
| Contributore | Mario Sicuranza | HL7 Italia | mario.sicuranza@icar.cnr.it |

 IG © 2023+ [HL7 Italy](http://hl7.it). Package hl7.fhir.it.cda2fhir#0.1.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

