# Downloads - CDA to FHIR Maps v0.1.0

* [**Table of Contents**](toc.md)
* **Downloads**

CDA to FHIR Maps, published by HL7 Italy. This guide is not an authorized publication; it is the continuous build for version 0.1.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/hl7-it/cda2fhir/](https://github.com/hl7-it/cda2fhir/) and changes regularly. See the [Directory of published versions](http://hl7.it/fhir/cda2fhir/history.html)

## Downloads

* [Full IG](#full-ig)
* [NPM Package and Definitions](#npm-package-and-definitions)
* [Examples](#examples)

### Full IG

Download the entire implementation guide [here](full-ig.zip).

### NPM Package and Definitions

The following file contains all the value sets, profiles, extensions, list of pages and urls in the IG, etc. defined as part of this Implementation Guide:

* [NPM Package](package.tgz)

In addition there are format specific definition files:

* [XML](definitions.xml.zip)
* [JSON](definitions.json.zip)
* [TTL](definitions.ttl.zip)

These files should be the first choice whenever generating any implementation artifacts since they contain all of the rules about what makes these profiles valid. Implementers will still need to be familiar with the content of the specification and profiles that apply in order to make a conformant implementation. See the overview on [validating FHIR profiles and resources](http://hl7.org/fhir/R4/validation.html).

There are also specific packages for the R4 and R4B FHIR specifications:

#### R4-specific NPM Package and Definitions

* [R4 NPM Package](package.r4.tgz)

#### R4B-specific NPM Package and Definitions

* [R4B NPM Package](package.r4b.tgz)

### Examples

All of the examples that are used in this Implementation Guide are available for download:

* [XML](examples.xml.zip)
* [JSON](examples.json.zip)
* [TTL](examples.ttl.zip)

 IG © 2023+ [HL7 Italy](http://hl7.it). Package hl7.fhir.it.cda2fhir#0.1.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

