# Artifacts Summary - CDA to FHIR Maps v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

CDA to FHIR Maps, published by HL7 Italy. This guide is not an authorized publication; it is the continuous build for version 0.1.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/hl7-it/cda2fhir/](https://github.com/hl7-it/cda2fhir/) and changes regularly. See the [Directory of published versions](http://hl7.it/fhir/cda2fhir/history.html)

## Artifacts Summary

Contents:

*  [StructureMaps Condivise](#1) 
*  [StructureMaps Indipendenti](#2) 
*  [Structures: Resource Profiles](#3) 
*  [Structures: Extension Definitions](#4) 

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### StructureMaps Condivise 

Mappe condivise per la trasformazione da CDA-FHIR.

| | |
| :--- | :--- |
| [CDA to FHIR - Data Types](StructureMap-cda2fhirDataTypes.md) | Mappa di trasformazione dei dataTypes di CDA a FHIR |
| [CDA to FHIR - Header](StructureMap-cda2fhirHeader.md) | Mappa di trasformazione dell'header generico |

### StructureMaps Indipendenti 

Mappe per la trasformazione da CDA a FHIR Bundle per tutte le tipologie documentali.

| | |
| :--- | :--- |
| [CDA to FHIR - AMB](StructureMap-cda2fhirAmbReport.md) | Mappa di trasformazione del documento CDA2 Referto di Specialistica Ambulatoriale in FHIR Bundle |
| [CDA to FHIR - LAB](StructureMap-cda2fhirLabReport.md) | Mappa di trasformazione del documento CDA2 Referto di Medicina di laboratorio in FHIR Bundle |
| [CDA to FHIR - LDO](StructureMap-cda2fhirLdo.md) | Mappa di trasformazione del documento Lettera di dimissione Ospedaliera in FHIR Bundle |
| [CDA to FHIR - PRESCRIZIONE FARMACEUTICA](StructureMap-cda2fhirMedPrescription.md) | Mappa di trasformazione del documento CDA2 di Prescrizione Farmaceutica in FHIR Bundle |
| [CDA to FHIR - PRESCRIZIONE SPECIALISTICA](StructureMap-cda2fhirSpecPrescription.md) | Mappa di trasformazione del documento CDA2 di Prescrizione Farmaceutica in FHIR Bundle |
| [CDA to FHIR - PSS](StructureMap-cda2fhirPs.md) | Mappa di trasformazione del documento CDA2 Profilo Sanitario Sintetico (PSS) in FHIR Bundle |
| [CDA to FHIR - RAD](StructureMap-cda2fhirRadReport.md) | Mappa di trasformazione del documento CDA2 Lettera di dimissione Ospedaliera in FHIR Bundle |
| [CDA to FHIR - VAC](StructureMap-cda2fhirVaccination.md) | Mappa di trasformazione del documento CDA2 Singola Vaccinazione e Certificato Vaccinale in FHIR Bundle |
| [CDA to FHIR - VPS](StructureMap-cda2fhirEdReport.md) | Mappa di trasformazione del documento CDA2 Verbale di Pronto Soccorso in FHIR Bundle |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| |
| :--- |
| [StructureMapProfile](StructureDefinition-StructureMapProfile.md) |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| |
| :--- |
| [reference](StructureDefinition-references-C.md) |

 IG © 2023+ [HL7 Italy](http://hl7.it). Package hl7.fhir.it.cda2fhir#0.1.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

