# CDA to FHIR - PRESCRIZIONE FARMACEUTICA - CDA to FHIR Maps v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CDA to FHIR - PRESCRIZIONE FARMACEUTICA**

CDA to FHIR Maps, published by HL7 Italy. This guide is not an authorized publication; it is the continuous build for version 0.1.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/hl7-it/cda2fhir/](https://github.com/hl7-it/cda2fhir/) and changes regularly. See the [Directory of published versions](http://hl7.it/fhir/cda2fhir/history.html)

*  [Narrative Content](#) 
*  [XML](StructureMap-cda2fhirMedPrescription.xml.md) 
*  [JSON](StructureMap-cda2fhirMedPrescription.json.md) 
*  [TTL](StructureMap-cda2fhirMedPrescription.ttl.md) 

## StructureMap: CDA to FHIR - PRESCRIZIONE FARMACEUTICA 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/cda2fhir/StructureMap/cda2fhirMedPrescription | *Version*:0.1.0 |
| Draft as of 2025-10-01 | *Computable Name*:cda2fhirMedPrescription |

```
map "http://hl7.it/fhir/cda2fhir/StructureMap/cda2fhirMedPrescription" = "cda2fhirMedPrescription"

uses "http://hl7.org/fhir/cda/StructureDefinition/ClinicalDocument" alias ClinicalDocument as source
uses "http://hl7.org/fhir/cda/StructureDefinition/AssignedAuthor" alias AssignedAuthor as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/AssignedEntity" alias AssignedEntity as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/AssociatedEntity" alias AssociatedEntity as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/CustodianOrganization" alias CustodianOrganization as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/OrganizationPartOf" alias OrganizationPartOf as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/Organization" alias rapresentedOrganization as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/Section" alias Section as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/PatientRole" alias PatientRole as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/AD" alias AD as source
uses "http://hl7.org/fhir/StructureDefinition/Bundle" alias Bundle as target
uses "http://hl7.org/fhir/StructureDefinition/Composition" alias Composition as produced
uses "http://hl7.org/fhir/StructureDefinition/Patient" alias Patient as produced
uses "http://hl7.org/fhir/StructureDefinition/Encounter" alias Encounter as produced
uses "http://hl7.org/fhir/StructureDefinition/Person" alias Patient as produced
uses "http://hl7.org/fhir/StructureDefinition/Practitioner" alias Practitioner as produced
uses "http://hl7.org/fhir/StructureDefinition/Organization" alias Organization as produced
uses "http://hl7.org/fhir/cda/StructureDefinition/Act" alias Act as produced
uses "http://hl7.org/fhir/cda/StructureDefinition/IVL-PQ" alias IVL_PQ as source
uses "http://hl7.org/fhir/cda/StructureDefinition/PQ" alias PQ as source
uses "http://hl7.org/fhir/StructureDefinition/SimpleQuantity" alias SimpleQuantity as target

imports "http://hl7.it/fhir/cda2fhir/StructureMap/cda2fhirDataTypes"
imports "http://hl7.it/fhir/cda2fhir/StructureMap/cda2fhirHeader"

group CdaToBundle(source cda : ClinicalDocument, target bundle : Bundle) {
  cda ->  bundle.entry as e,  e.request = create('BackboneElement') as request,  request.method = 'POST',  e.resource = create('Composition') as composition,  composition.id = uuid() as uuid1,  e.fullUrl = append('https://example/Composition/', uuid1),  request.url = 'Composition',  bundle.entry as e2,  e2.request = create('BackboneElement') as requestPAT,  requestPAT.method = 'PUT',  e2.resource = create('Patient') as patient,  patient.id = uuid() as uuid2,  e2.fullUrl = append('https://example/Patient/', uuid2),  bundle.entry as e3,  e3.request = create('BackboneElement') as request,  request.method = 'POST',  e3.resource = create('Encounter') as encounter,  encounter.id = uuid() as uuid3,  e3.fullUrl = append('https://example/Encounter/', uuid3),  request.url = 'Encounter',  bundle.entry as e5,  e5.request = create('BackboneElement') as request,  request.method = 'POST',  e5.resource = create('DocumentReference') as DocumentReference,  DocumentReference.id = uuid() as uuid5,  e5.fullUrl = append('https://example/DocumentReference/', uuid5),  request.url = 'DocumentReference' then {
    cda then ClinicalDocumentToBundle(cda, patient, composition, encounter, bundle, DocumentReference) "cdatobundle";
    cda.recordTarget as recordTarget then {
      recordTarget.patientRole as patient then {
        patient.id as id -> patient.identifier as identifier then {
          id.root as r -> identifier.system = translate(r, 'http://hl7.org/fhir/ConceptMap/special-oid2uri', 'uri') "root1";
          id.extension as ext -> identifier.value = ext;
          id.assigningAuthorityName as s ->  identifier.assigner as a,  a.display = s;
        } "record";
        patient.id as id where (root = '2.16.840.1.113883.2.9.4.3.2') or (root = '2.16.840.1.113883.2.9.4.3.7') or (root = '2.16.840.1.113883.2.9.4.3.3') or (root = '2.16.840.1.113883.2.9.4.3.17') or (root = '2.16.840.1.113883.2.9.4.3.18') or (root = '2.16.840.1.113883.2.9.2.10.4.1.1') or (root = '2.16.840.1.113883.2.9.2.20.4.1.1') or (root = '2.16.840.1.113883.2.9.2.30.4.1.1') or (root = '2.16.840.1.113883.2.9.2.41.4.1.1') or (root = '2.16.840.1.113883.2.9.2.42.4.1.1') or (root = '2.16.840.1.113883.2.9.2.50.4.1.1') or (root = '2.16.840.1.113883.2.9.2.60.4.1.1') or (root = '2.16.840.1.113883.2.9.2.70.4.1.1') or (root = '2.16.840.1.113883.2.9.2.80.4.1.1') or (root = '2.16.840.1.113883.2.9.2.90.4.1.1') or (root = '2.16.840.1.113883.2.9.2.100.4.1.1') or (root = '2.16.840.1.113883.2.9.2.110.4.1.1') or (root = '2.16.840.1.113883.2.9.2.120.4.1.1') or (root = '2.16.840.1.113883.2.9.2.130.4.1.1') or (root = '2.16.840.1.113883.2.9.2.140.4.1.1') or (root = '2.16.840.1.113883.2.9.2.150.4.1.1') or (root = '2.16.840.1.113883.2.9.2.160.4.1.1') or (root = '2.16.840.1.113883.2.9.2.170.4.1.1') or (root = '2.16.840.1.113883.2.9.2.180.4.1.1') or (root = '2.16.840.1.113883.2.9.2.190.4.1.1') or (root = '2.16.840.1.113883.2.9.2.200.4.1.1') or (root = '2.16.840.1.113883.2.9.2.10.4.1') or (root = '2.16.840.1.113883.2.9.2.20.4.1') or (root = '2.16.840.1.113883.2.9.2.30.4.1') or (root = '2.16.840.1.113883.2.9.2.41.4.1') or (root = '2.16.840.1.113883.2.9.2.42.4.1') or (root = '2.16.840.1.113883.2.9.2.50.4.1') or (root = '2.16.840.1.113883.2.9.2.60.4.1') or (root = '2.16.840.1.113883.2.9.2.70.4.1') or (root = '2.16.840.1.113883.2.9.2.80.4.1') or (root = '2.16.840.1.113883.2.9.2.90.4.1') or (root = '2.16.840.1.113883.2.9.2.100.4.1') or (root = '2.16.840.1.113883.2.9.2.110.4.1') or (root = '2.16.840.1.113883.2.9.2.120.4.1') or (root = '2.16.840.1.113883.2.9.2.130.4.1') or (root = '2.16.840.1.113883.2.9.2.140.4.1') or (root = '2.16.840.1.113883.2.9.2.150.4.1') or (root = '2.16.840.1.113883.2.9.2.160.4.1') or (root = '2.16.840.1.113883.2.9.2.170.4.1') or (root = '2.16.840.1.113883.2.9.2.180.4.1') or (root = '2.16.840.1.113883.2.9.2.190.4.1') or (root = '2.16.840.1.113883.2.9.2.200.4.1') or (root = '2.16.840.1.113883.2.9.4.3.15') then {
          id.extension as ext -> requestPAT.url = append('Patient?identifier=', ext) "UUID";
        } "ext";
      } "recPat";
    } "patient";
  } "ClinicalDocumentToBody";
}

group ClinicalDocumentToBundle(source cda : ClinicalDocument, target patient : Patient, target composition : Composition, target encounter : Encounter, target bundle : Bundle, target DocumentReference : DocumentReference) {
  cda -> bundle.id = uuid() "id";
  cda.id -> bundle.identifier "identifier";
  cda -> bundle.type = 'transaction' "type";
  cda -> bundle.timestamp = (timestamp.now()) "date";
  cda then ClinicalDocumentComposition(cda, composition, patient, encounter, bundle, DocumentReference) "composition";
  cda.component as component then {
    component.structuredBody as body then {
      body ->  bundle.entry as e1,  e1.request = create('BackboneElement') as request,  request.method = 'POST',  e1.resource = create('Coverage') as coverage,  coverage.id = uuid() as uuid1,  e1.fullUrl = append('https://example/Coverage/', uuid1),  request.url = 'Coverage' then {
        body ->  bundle.entry as e2,  e2.request = create('BackboneElement') as request,  request.method = 'POST',  e2.resource = create('MedicationRequest') as medRq,  medRq.id = uuid() as uuid1,  e2.fullUrl = append('https://example/MedicationRequest/', uuid1),  request.url = 'MedicationRequest' then {
          body.component as component then {
            // discretizzi il primo livello di component
            component.section as srcSection then {
              srcSection.code where (code = '57827-8') -> composition.section as tgtSection then ClinicalDocumentSectionEsenzioni(cda, srcSection, patient, tgtSection, bundle, encounter, coverage) "esenz";
              srcSection.code where (code = '57828-6') -> composition.section as tgtSection then ClinicalDocumentSectionPrescrizioneFarmaceutica(cda, srcSection, patient, tgtSection, bundle, encounter, coverage, medRq) "prescfarm";
              srcSection.code where (code = '48767-8') -> composition.section as tgtSection then ClinicalDocumentSectionAnnotazioni(cda, srcSection, patient, tgtSection, bundle, encounter, medRq) "annot";
              srcSection.code where (code = '51851-4') -> composition.section as tgtSection then ClinicalDocumentSectionMessaggioRegionale(cda, srcSection, patient, tgtSection, bundle, encounter, medRq) "messregg";
              srcSection.code where (code = '8716-3') -> composition.section as tgtSection then ClinicalDocumentSectionParametriVitali(cda, srcSection, patient, tgtSection, bundle, encounter) "paramvit";
              srcSection.code where (code = '48765-2') -> composition.section as tgtSection then ClinicalDocumentSectionAllergieaiFarmaci(cda, srcSection, patient, tgtSection, bundle, encounter) "allergfarm";
              srcSection.code where (code = '47420-5') -> composition.section as tgtSection then ClinicalDocumentSectionStatoClinicoPaziente(cda, srcSection, patient, tgtSection, bundle, encounter) "statclinpaz";
            } "cov";
          };
        } "medreq";
      } "coverage";
    } "body";
  };
}

group ClinicalDocumentSectionEsenzioni(source cda : ClinicalDocument, source src : Section, target patient : Patient, target tgt, target bundle : Bundle, target enc : Encounter, target coverage : Coverage) {
  src.title as t -> tgt.title = (t.dataString);
  src.code -> tgt.code;
  src.text as cdaText ->  tgt.entry = create('Reference') as reference,  reference.reference = ('https://example/Coverage/' + %coverage.id),  tgt.text as fhirText then {
    cdaText -> fhirText.status = 'generated' "narrativeStatus";
    cdaText as t -> fhirText.div = t "narrativeText";
    src.entry as srcse then {
      srcse.act as srcsec then {
        srcsec.code -> coverage.type;
        srcsec.code as srctxt then {
          srctxt -> coverage.type as typetxt then {
            srctxt.originalText as ref then {
              ref.reference as t then {
                t.value as l -> typetxt.text = l "reference";
              } "tcf";
            } "rfde";
          } "reftxt";
        } "origtxt";
        srcsec where coverage.status.exists().not() then {
          srcsec -> coverage.status = 'active' "status";
        } "statuscode";
        srcsec ->  coverage.beneficiary = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
        srcsec ->  coverage.payor = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
      } "cdaText";
    } "secact";
  } "cff";
}

group ClinicalDocumentSectionPrescrizioneFarmaceutica(source cda : ClinicalDocument, source src : Section, target patient : Patient, target tgt, target bundle : Bundle, target enc : Encounter, target coverage : Coverage, target medRq : MedicationRequest) {
  src.title as t -> tgt.title = (t.dataString);
  src.code -> tgt.code;
  src.text as cdaText ->  tgt.entry = create('Reference') as reference,  reference.reference = ('https://example/MedicationRequest/' + %medRq.id),  tgt.text as fhirText then {
    src.id -> medRq.identifier;
    cdaText -> fhirText.status = 'generated' "narrativeStatus";
    cdaText as t -> fhirText.div = t "narrativeText";
    cdaText ->  medRq.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
    cdaText ->  medRq.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %enc.id) "reference";
    cdaText -> medRq.status = 'active' "status";
    cdaText -> medRq.intent = 'order' "intent";
    src.entry as srcent then {
      srcent.substanceAdministration as subAdm then {
        subAdm.effectiveTime : IVL_TS as eff -> medRq.dosageInstruction = create('Dosage') as dosage then {
          subAdm -> dosage.timing = create('Timing') as tim then {
            subAdm -> tim.repeat as repeat then {
              eff -> repeat.bounds = create('Period') as period then IVLTSPeriod(eff, period) "boundsperiod";
              eff.width as width then {
                width.value as v -> repeat.duration = v;
                width.unit as u -> repeat.durationUnit = u;
              };
            } "repeat";
          } "timing";
        } "dosage";
        subAdm.effectiveTime as eff -> medRq.dosageInstruction = create('Dosage') as dosage then {
          subAdm -> dosage.timing = create('Timing') as tim then {
            eff where eff.low.exists().not() and eff.high.exists().not() then {
              eff.value as v -> tim.event = create('dateTime') as event then TSDateTime(v, event) "evnt";
            } "effct1";
          } "timing1";
        } "dosage1";
        subAdm.effectiveTime : PIVL_TS as effp -> medRq.dosageInstruction = create('Dosage') as dosage then {
          effp -> dosage.timing = create('Timing') as timing then {
            effp -> timing then periodTiming(effp, timing) "cod";
            effp where effp.phase.exists() then {
              effp.phase as phase -> timing.repeat as r then {
                phase.low -> r.bounds = create('Period') as period then {
                  phase.low -> period.start "lo";
                };
                phase.width as wid then {
                  wid.value as v -> r.duration = v "vals";
                  wid.unit as u -> r.durationUnit = u;
                } "dur";
              } "rep";
            } "phase";
          } "timing";
        } "eff";
        subAdm.effectiveTime : EIVL_TS as effe -> medRq.dosageInstruction = create('Dosage') as dosage then {
          effe -> dosage.timing = create('Timing') as timing then {
            effe -> timing.repeat as r then {
              effe.event -> r.when;
              effe.offset as offset then {
                offset.low as v then {
                  v.value as o -> r.offset = o "barabar";
                } "offs";
              } "poi";
            } "lkj";
          } "ghj";
        } "eff";
        subAdm.doseQuantity as doseQuant -> medRq.dosageInstruction = create('Dosage') as dosage then {
          doseQuant.originalText as ot then {
            ot.reference -> dosage.text;
          } "ot";
          doseQuant -> dosage.doseAndRate as dosageRate then {
            doseQuant -> dosageRate.dose = create('Range') as d then {
              doseQuant -> d.low = create('SimpleQuantity') as l then {
                doseQuant.low as lo -> l.value = (lo.value);
                doseQuant.low as lo -> l.unit = (lo.unit);
              } "low";
              doseQuant -> d.high = create('SimpleQuantity') as h then {
                doseQuant.high as hi -> h.value = (hi.value);
                doseQuant.high as hi -> h.unit = (hi.unit);
              } "low";
            } "d";
          } "dosageRate";
        } "doseQuant";
        subAdm ->  bundle.entry as e1,  e1.request = create('BackboneElement') as request,  request.method = 'POST',  e1.resource = create('Medication') as medication,  medication.id = uuid() as uuid1,  e1.fullUrl = append('https://example/Medication/', uuid1),  request.url = 'Medication',  medRq.medication = create('Reference') as reference,  reference.reference = ('https://example/Medication/' + %medication.id) then {
          subAdm.consumable as cons then {
            cons.manufacturedProduct as manuprod then {
              manuprod.manufacturedLabeledDrug as manudrug then {
                manudrug.code -> medication.code;
                manudrug -> medication.identifier as medid then {
                  manudrug.name -> medid.value;
                } "idmedname";
                manudrug.code as srctxt then {
                  srctxt -> medication.code as typetxt then {
                    srctxt.originalText as ref then {
                      ref.reference as reference then {
                        reference.value as l -> typetxt.text = l "reference";
                      } "tcf";
                    } "tcfg";
                  } "reftxtd";
                } "origtxtd";
              } "manudrug";
              manuprod.manufacturedMaterial as manufact then {
                manufact.code -> medication.code;
                manufact.code as srctxt then {
                  srctxt -> medication.code as typetxt then {
                    srctxt.originalText as ref then {
                      ref.reference as reference then {
                        reference.value as l -> typetxt.text = l "reference";
                      } "tcf";
                    } "tcfg";
                  } "reftxt";
                } "origtxt";
                manufact.ingredient as ingredient -> medication.ingredient as ing then {
                  ingredient.quantity as quantity -> ing.strength = create('Ratio') as strength then EmedRTOPQPQRatio(quantity, strength) "strength";
                  manufact ->  ing.item = create('CodeableConcept') as ingcode,  ingcode.text = (%manufact.name.other) "ingredientCode";
                } "ingr";
                manufact.formCode -> medication.form;
                manufact -> medication.identifier as medid "transl";
              } "manuFact";
            } "manumat";
          } "cons";
          subAdm.entryRelationship as entryrel1 then {
            entryrel1.supply as sup -> medRq.dispenseRequest as dispreq then {
              sup -> dispreq.quantity = create('SimpleQuantity') as quantity then {
                sup.quantity as q -> quantity.value = (q.value);
              } "quantity";
            };
          } "entry1";
          subAdm.entryRelationship as entryrel2 where (typeCode = 'REFR') then {
            subAdm ->  medRq.insurance = create('Reference') as reference,  reference.reference = ('https://example/Coverage/' + %coverage.id) then {
              entryrel2.act as act2 -> coverage.costToBeneficiary as cost then {
                act2 -> cost.value = create('SimpleQuantity') as val then {
                  act2 -> val.value = '0' "bnm";
                } "beneficmoney";
                act2 -> cost.exception as except then {
                  act2.code -> except.type;
                } "exept";
              } "act2";
            } "Cover";
          } "entry2";
          subAdm.entryRelationship as entryrel3 where (typeCode = 'RSON') then {
            entryrel3.observation as obs3 where (classCode = 'OBS') then {
              obs3.code -> medRq.reasonCode;
              obs3.text as text then {
                text -> medRq.reasonCode as ce then {
                  // text.reference as reference-> ce.text=reference;
                  text.reference as reference then {
                    reference.value as l -> ce.text = l "reference";
                  } "tcf";
                } "originltext";
              } "txt";
            } "obs3";
          } "entry2";
          subAdm.entryRelationship as entryrel4 where (typeCode = 'SUBJ') then {
            entryrel4.observation as obs3 -> medRq.substitution as sub then {
              obs3.code as Code -> sub.allowed = create('CodeableConcept') as allowed then CECodeableConcept(Code, allowed);
              obs3.entryRelationship as entry then {
                entry.observation as obs4 then {
                  obs4.code -> sub.reason;
                } "obs4";
              } "entry";
            } "obs";
          } "code";
          subAdm.entryRelationship as entryrel2 where (typeCode = 'SUBJ') then {
            entryrel2.act as act2 where (classCode = 'ACT') then {
              act2.text as text -> medRq.note as note then {
                text.reference as t then {
                  t.value as l -> note.text = l "reference";
                } "tcx";
              } "reference";
            } "obs3";
          } "entry2";
        } "subsadm";
      } "subadm";
    } "hnjh";
  } "xxx";
}

// ------------Sezione Annotazioni-----------------------------------------------------------------------------------------------------------------------------------------
group ClinicalDocumentSectionAnnotazioni(source cda : ClinicalDocument, source src : Section, target patient : Patient, target tgt, target bundle : Bundle, target enc : Encounter, target medRq : MedicationRequest) {
  src.title as t -> tgt.title = (t.dataString);
  src.code -> tgt.code;
  src.text as cdaText ->  tgt.entry = create('Reference') as reference,  reference.reference = ('https://example/MedicationRequest/' + %medRq.id),  tgt.text as fhirText then {
    cdaText -> fhirText.status = 'generated' "narrativeStatus";
    cdaText as t -> fhirText.div = t "narrativeText";
    src.entry as entry then {
      entry.act as act then {
        act.text as text -> medRq.note as note then {
          text.reference as t then {
            t.value as l -> note.text = l "reference";
          } "tcx";
        } "reference";
      };
    };
  } "entry";
}

// ------------Sezione Messaggio Regionale-----------------------------------------------------------------------------------------------------------------------------------------
group ClinicalDocumentSectionMessaggioRegionale(source cda : ClinicalDocument, source src : Section, target patient : Patient, target tgt, target bundle : Bundle, target enc : Encounter, target medRq : MedicationRequest) {
  src.title as t -> tgt.title = (t.dataString);
  src.code -> tgt.code;
  src.text as cdaText ->  tgt.entry = create('Reference') as reference,  reference.reference = ('https://example/MedicationRequest/' + %medRq.id) then {
    cdaText as text -> medRq.note as note then {
      text as t -> note.text = t "reference";
    } "nota";
  } "entry";
}

// ------------Sezione Parametri Vitali-----------------------------------------------------------------------------------------------------------------------------------------
group ClinicalDocumentSectionParametriVitali(source cda : ClinicalDocument, source src : Section, target patient : Patient, target tgt, target bundle : Bundle, target enc : Encounter) {
  src.title as t -> tgt.title = (t.dataString);
  src.code -> tgt.code;
  src.text as cdaText ->  bundle.entry as e8,  e8.request = create('BackboneElement') as request,  request.method = 'POST',  e8.resource = create('Observation') as Observation,  Observation.id = uuid() as uuid8,  e8.fullUrl = append('https://example/Observation/', uuid8),  request.url = 'Observation',  tgt.entry = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %Observation.id) then {
    src ->  Observation.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
    src ->  Observation.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %enc.id) "reference";
    src.code -> Observation.code;
    src where Observation.statusCode.exists().not() then {
      src -> Observation.status = 'final' "status";
    } "statuscode";
    cdaText -> Observation.note as note then {
      cdaText as t -> note.text = t "reference";
    } "reference";
  } "nota";
}

// ------------Sezione Allergie_Intolleranze-----------------------------------------------------------------------------------------------------------------------------------------
group ClinicalDocumentSectionAllergieaiFarmaci(source cda : ClinicalDocument, source src : Section, target patient : Patient, target tgt, target bundle : Bundle, target enc : Encounter) {
  src.title as t -> tgt.title = (t.dataString);
  src.code -> tgt.code;
  src ->  bundle.entry as e9,  e9.request = create('BackboneElement') as request,  request.method = 'POST',  e9.resource = create('AllergyIntolerance') as allergyIntolerance,  allergyIntolerance.id = uuid() as uuid9,  e9.fullUrl = append('https://example/AllergyIntolerance/', uuid9),  request.url = 'AllergyIntolerance',  tgt.entry = create('Reference') as reference,  reference.reference = ('https://example/AllergyIntolerance/' + %allergyIntolerance.id) then {
    src ->  allergyIntolerance.patient = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
    src -> allergyIntolerance.clinicalStatus = create('CodeableConcept') as status then {
      src -> status.text = 'string' "text";
      src -> status.coding = create('Coding') as coding then {
        src -> coding.code = 'active' "active";
        src -> coding.system = 'http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical' "system";
      } "coding";
    } "allergy";
    src.text as cdaText -> allergyIntolerance.note as note then {
      cdaText as t -> note.text = t "reference";
    } "reference";
  } "nota";
}

// ------------Sezione Stato Clinico del Paziente----------------------------------------------------------------------------------------------------------------------------------------
group ClinicalDocumentSectionStatoClinicoPaziente(source cda : ClinicalDocument, source src : Section, target patient : Patient, target tgt, target bundle : Bundle, target enc : Encounter) {
  src.title as t -> tgt.title = (t.dataString);
  src.code -> tgt.code;
  src.text as cdaText ->  bundle.entry as e7,  e7.request = create('BackboneElement') as request,  request.method = 'POST',  e7.resource = create('Observation') as Observation,  Observation.id = uuid() as uuid7,  e7.fullUrl = append('https://example/Observation/', uuid7),  request.url = 'Observation',  tgt.entry = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %Observation.id) then {
    src ->  Observation.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
    src ->  Observation.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %enc.id) "reference";
    src.code -> Observation.code;
    src where Observation.statusCode.exists().not() then {
      src -> Observation.status = 'final' "status";
    } "statuscode";
    cdaText -> Observation.note as note then {
      cdaText as t -> note.text = t "reference";
    } "reference";
  } "nota";
}

group periodTiming(source effectiveTime : PIVL_TS, target timing : Timing) {
  effectiveTime -> timing.repeat as r then {
    effectiveTime.period as p -> r.period = (p.value);
    effectiveTime.period as p -> r.periodUnit = (p.unit);
  } "repeat";
}

group EmedRTOPQPQRatio(source src : RTO_PQ_PQ, target tgt : Ratio) {
  src.numerator as numerator -> tgt.numerator as targetNumerator then EmedPQQuantity(numerator, targetNumerator);
  src.denominator as denominator -> tgt.denominator as targetDenominator then EmedPQQuantity(denominator, targetDenominator);
}

group EmedPQQuantity(source src : PQ, target tgt : Quantity) {
  src.value as value -> tgt.value = value;
  src.unit as unit -> tgt.code = unit;
  src.unit as unit -> tgt.system = ('http://fhir.ch/ig/ch-emed/ValueSet/UnitCode'.resolve().compose.include.where(concept.where(code = %unit)).system);
  src.unit as unit -> tgt.unit = ('http://fhir.ch/ig/ch-emed/ValueSet/UnitCode'.resolve().compose.include.concept.where(code = %unit).display);
}


```

 IG © 2023+ [HL7 Italy](http://hl7.it). Package hl7.fhir.it.cda2fhir#0.1.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

