# CDA to FHIR - AMB - CDA to FHIR Maps v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CDA to FHIR - AMB**

CDA to FHIR Maps, published by HL7 Italy. This guide is not an authorized publication; it is the continuous build for version 0.1.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/hl7-it/cda2fhir/](https://github.com/hl7-it/cda2fhir/) and changes regularly. See the [Directory of published versions](http://hl7.it/fhir/cda2fhir/history.html)

*  [Narrative Content](#) 
*  [XML](StructureMap-cda2fhirAmbReport.xml.md) 
*  [JSON](StructureMap-cda2fhirAmbReport.json.md) 
*  [TTL](StructureMap-cda2fhirAmbReport.ttl.md) 

## StructureMap: CDA to FHIR - AMB 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/cda2fhir/StructureMap/cda2fhirAmbReport | *Version*:0.1.0 |
| Draft as of 2025-10-01 | *Computable Name*:cda2fhirAmbReport |

```
map "http://hl7.it/fhir/cda2fhir/StructureMap/cda2fhirAmbReport" = "cda2fhirAmbReport"

uses "http://hl7.org/fhir/cda/StructureDefinition/ClinicalDocument" alias ClinicalDocument as source
uses "http://hl7.org/fhir/cda/StructureDefinition/AssignedAuthor" alias AssignedAuthor as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/AssignedEntity" alias AssignedEntity as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/AssociatedEntity" alias AssociatedEntity as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/CustodianOrganization" alias CustodianOrganization as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/OrganizationPartOf" alias OrganizationPartOf as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/Organization" alias rapresentedOrganization as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/Section" alias Section as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/PatientRole" alias PatientRole as queried
uses "http://hl7.org/fhir/cda/StructureDefinition/AD" alias AD as source
uses "http://hl7.org/fhir/StructureDefinition/Bundle" alias Bundle as target
uses "http://hl7.org/fhir/StructureDefinition/Composition" alias Composition as produced
uses "http://hl7.org/fhir/StructureDefinition/Patient" alias Patient as produced
uses "http://hl7.org/fhir/StructureDefinition/Encounter" alias Encounter as produced
uses "http://hl7.org/fhir/StructureDefinition/Person" alias Patient as produced
uses "http://hl7.org/fhir/StructureDefinition/List" alias List as produced
uses "http://hl7.org/fhir/StructureDefinition/Practitioner" alias Practitioner as produced
uses "http://hl7.org/fhir/StructureDefinition/Organization" alias Organization as produced
uses "http://hl7.org/fhir/cda/StructureDefinition/Act" alias Act as produced
uses "http://hl7.org/fhir/cda/StructureDefinition/IVL-PQ" alias IVL_PQ as source
uses "http://hl7.org/fhir/cda/StructureDefinition/PQ" alias PQ as source
uses "http://hl7.org/fhir/StructureDefinition/SimpleQuantity" alias SimpleQuantity as target

imports "http://hl7.it/fhir/cda2fhir/StructureMap/cda2fhirDataTypes"
imports "http://hl7.it/fhir/cda2fhir/StructureMap/cda2fhirHeader"

group CdaToBundle(source cda : ClinicalDocument, target bundle : Bundle) {
  cda ->  bundle.entry as e,  e.request = create('BackboneElement') as request,  request.method = 'POST',  e.resource = create('Composition') as composition,  composition.id = uuid() as uuid1,  e.fullUrl = append('https://example/Composition/', uuid1),  request.url = 'Composition',  bundle.entry as e2,  e2.request = create('BackboneElement') as requestPAT,  requestPAT.method = 'PUT',  e2.resource = create('Patient') as patient,  patient.id = uuid() as uuid2,  e2.fullUrl = append('https://example/Patient/', uuid2),  bundle.entry as e3,  e3.request = create('BackboneElement') as request,  request.method = 'POST',  e3.resource = create('Encounter') as encounter,  encounter.id = uuid() as uuid3,  e3.fullUrl = append('https://example/Encounter/', uuid3),  request.url = 'Encounter',  bundle.entry as e4,  e4.request = create('BackboneElement') as request,  request.method = 'POST',  e4.resource = create('DocumentReference') as DocumentReference,  DocumentReference.id = uuid() as uuid4,  e4.fullUrl = append('https://example/DocumentReference/', uuid4),  request.url = 'DocumentReference' then {
    cda then ClinicalDocumentToBundle(cda, patient, composition, encounter, bundle, DocumentReference) "cdatobundle";
    cda.recordTarget as recordTarget then {
      recordTarget.patientRole as patient then {
        patient.id as id -> patient.identifier as identifier then {
          id.root as r -> identifier.system = translate(r, 'http://hl7.org/fhir/ConceptMap/special-oid2uri', 'uri') "root1";
          id.extension as ext1 -> identifier.value = ext1 "value";
          id.assigningAuthorityName as s ->  identifier.assigner as a,  a.display = s;
        } "idfr";
        patient.id as id where (root = '2.16.840.1.113883.2.9.4.3.2') or (root = '2.16.840.1.113883.2.9.4.3.7') or (root = '2.16.840.1.113883.2.9.4.3.3') or (root = '2.16.840.1.113883.2.9.4.3.17') or (root = '2.16.840.1.113883.2.9.4.3.18') or (root = '2.16.840.1.113883.2.9.2.10.4.1.1') or (root = '2.16.840.1.113883.2.9.2.20.4.1.1') or (root = '2.16.840.1.113883.2.9.2.30.4.1.1') or (root = '2.16.840.1.113883.2.9.2.41.4.1.1') or (root = '2.16.840.1.113883.2.9.2.42.4.1.1') or (root = '2.16.840.1.113883.2.9.2.50.4.1.1') or (root = '2.16.840.1.113883.2.9.2.60.4.1.1') or (root = '2.16.840.1.113883.2.9.2.70.4.1.1') or (root = '2.16.840.1.113883.2.9.2.80.4.1.1') or (root = '2.16.840.1.113883.2.9.2.90.4.1.1') or (root = '2.16.840.1.113883.2.9.2.100.4.1.1') or (root = '2.16.840.1.113883.2.9.2.110.4.1.1') or (root = '2.16.840.1.113883.2.9.2.120.4.1.1') or (root = '2.16.840.1.113883.2.9.2.130.4.1.1') or (root = '2.16.840.1.113883.2.9.2.140.4.1.1') or (root = '2.16.840.1.113883.2.9.2.150.4.1.1') or (root = '2.16.840.1.113883.2.9.2.160.4.1.1') or (root = '2.16.840.1.113883.2.9.2.170.4.1.1') or (root = '2.16.840.1.113883.2.9.2.180.4.1.1') or (root = '2.16.840.1.113883.2.9.2.190.4.1.1') or (root = '2.16.840.1.113883.2.9.2.200.4.1.1') or (root = '2.16.840.1.113883.2.9.2.10.4.1') or (root = '2.16.840.1.113883.2.9.2.20.4.1') or (root = '2.16.840.1.113883.2.9.2.30.4.1') or (root = '2.16.840.1.113883.2.9.2.41.4.1') or (root = '2.16.840.1.113883.2.9.2.42.4.1') or (root = '2.16.840.1.113883.2.9.2.50.4.1') or (root = '2.16.840.1.113883.2.9.2.60.4.1') or (root = '2.16.840.1.113883.2.9.2.70.4.1') or (root = '2.16.840.1.113883.2.9.2.80.4.1') or (root = '2.16.840.1.113883.2.9.2.90.4.1') or (root = '2.16.840.1.113883.2.9.2.100.4.1') or (root = '2.16.840.1.113883.2.9.2.110.4.1') or (root = '2.16.840.1.113883.2.9.2.120.4.1') or (root = '2.16.840.1.113883.2.9.2.130.4.1') or (root = '2.16.840.1.113883.2.9.2.140.4.1') or (root = '2.16.840.1.113883.2.9.2.150.4.1') or (root = '2.16.840.1.113883.2.9.2.160.4.1') or (root = '2.16.840.1.113883.2.9.2.170.4.1') or (root = '2.16.840.1.113883.2.9.2.180.4.1') or (root = '2.16.840.1.113883.2.9.2.190.4.1') or (root = '2.16.840.1.113883.2.9.2.200.4.1') or (root = '2.16.840.1.113883.2.9.4.3.15') then {
          id.extension as ext -> requestPAT.url = append('Patient?identifier=', ext) "UUID";
        } "record";
      } "recPat";
    } "patient";
  } "ClinicalDocumentToBody";
}

group ClinicalDocumentToBundle(source cda : ClinicalDocument, target patient : Patient, target composition : Composition, target encounter : Encounter, target bundle : Bundle, target DocumentReference : DocumentReference) {
  cda -> bundle.id = uuid() "id";
  cda.id -> bundle.identifier "identifier";
  cda -> bundle.type = 'transaction' "type";
  cda -> bundle.timestamp = (timestamp.now()) "date";
  cda then ClinicalDocumentComposition(cda, composition, patient, encounter, bundle, DocumentReference) "composition";
  cda ->  bundle.entry as e,  e.request = create('BackboneElement') as request,  request.method = 'POST',  e.resource = create('DiagnosticReport') as diagnosticReport,  diagnosticReport.id = uuid() as uuid1,  e.fullUrl = append('https://example/DiagnosticReport/', uuid1),  request.url = 'DiagnosticReport' then {
    cda.code -> diagnosticReport.code "diagnosticCode";
    cda -> diagnosticReport.status = 'registered' "stats";
    cda.component as component then {
      component.structuredBody as body then {
        body.component as component then {
          component.section as srcSection then {
            srcSection.code -> composition.section as tgtSection then ClinicalDocumentSection(cda, srcSection, patient, tgtSection, bundle, encounter, diagnosticReport);
          };
        };
      } "body";
    };
  } "diagnostic";
}

group ClinicalDocumentSection(source cda : ClinicalDocument, source src : Section, target patient : Patient, target tgt, target bundle : Bundle, target enc : Encounter, target dReport : DiagnosticReport) {
  src.title as t -> tgt.title = (t.dataString);
  src.code -> tgt.code;
  src ->  tgt.entry = create('Reference') as reference,  reference.reference = ('https://example/DiagnosticReport/' + %dReport.id) "reference";
  src.entry as entry then {
    src.text as cdaText -> tgt.text as fhirText then {
      cdaText -> fhirText.status = 'generated' "narrativeStatus";
      cdaText as t -> fhirText.div = t "narrativeText";
    } "cdaText";
    entry then DiagnosticReportFunction(src, entry, dReport, bundle, enc, patient) "dreport";
  };
  src where src.entry.exists().not() then DiagnosticReportFunction(src, cda, dReport, bundle, enc, patient) "narrative";
  src.component as component then {
    component.section as sec -> tgt.section as tgtSection then ClinicalDocumentSection(cda, sec, patient, tgtSection, bundle, enc, dReport);
  };
}

group DiagnosticReportFunction(source section : section, source src : entry, target dReport : DiagnosticReport, target bundle : Bundle, target encounter : Encounter, target patient : Patient) {
  src.observation as observation then {
    section where code.code = '29299-5' ->  bundle.entry as e1,  e1.request = create('BackboneElement') as request,  request.method = 'POST',  e1.resource = create('Observation') as obs1,  obs1.id = uuid() as uuid1,  e1.fullUrl = append('https://example/Observation/', uuid1),  request.url = 'Observation',  dReport.result = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obs1.id) then Observation(observation, patient, encounter, obs1, bundle) "QuesitoDiagnostico";
    section where code.code = '11329-0' ->  bundle.entry as e2,  e2.request = create('BackboneElement') as request,  request.method = 'POST',  e2.resource = create('Observation') as obs2,  obs2.id = uuid() as uuid2,  e2.fullUrl = append('https://example/Observation/', uuid2),  request.url = 'Observation',  dReport.result = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obs2.id) then {
      section ->  obs2.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
      section ->  obs2.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
      section -> obs2.status = 'final' "STatusobse";
      section.code -> obs2.code;
      observation.statusCode as s then {
        s.code as cos -> obs2.status = translate(cos, '#OBSstatus', 'code') "codeS";
      } "status";
      section.component as component then {
        component.section as section then {
          section.code where code = '10160-0' then {
            section.entry as entry then {
                                          entry.substanceAdministration as subAdmin ->  bundle.entry as e11,  e11.request = create('BackboneElement') as request,  request.method = 'POST',  e11.resource = create('MedicationStatement') as medicationstatement,  medicationstatement.id = uuid() as uuid11,  e11.fullUrl = append('https://example/MedicationStatement/', uuid11),  request.url = 'MedicationStatement',  obs2.partOf = create('Reference') as reference,  reference.reference = ('https://example/MedicationStatement/' + %medicationstatement.id) then MedicationStatement(subAdmin, medicationstatement, patient, encounter, bundle) "creat";
            };
          } "sectionCode";
          section.code where code = '48765-2' then {
            section ->  bundle.entry as e4,  e4.request = create('BackboneElement') as request,  request.method = 'POST',  e4.resource = create('List') as list1,  list1.id = uuid() as uuid4,  e4.fullUrl = append('https://example/List/', uuid4),  request.url = 'List',  obs2.focus = create('Reference') as reference,  reference.reference = ('https://example/List/' + %list1.id) then {
              section ->  list1.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
              section -> list1.status = 'current' "listatus";
              section -> list1.mode = 'working' "lstmod";
              section ->  list1.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
              section -> list1.entry as entryList1 then {
                section.entry as entry then {
                  entry.act as act1 ->  bundle.entry as e5,  e5.request = create('BackboneElement') as request,  request.method = 'POST',  e5.resource = create('AllergyIntolerance') as allergy,  allergy.id = uuid() as uuid5,  e5.fullUrl = append('https://example/AllergyIntolerance/', uuid5),  request.url = 'AllergyIntolerance',  entryList1.item = create('Reference') as reference,  reference.reference = ('https://example/AllergyIntolerance/' + %allergy.id) then allergyFunction(act1, allergy, patient, encounter) "allergy";
                } "entryAll";
              } "entryList";
            } "section";
          } "conditionAllergie";
        };
      } "subSection";
      section.entry as entry then {
        entry.observation ->  bundle.entry as e3,  e3.request = create('BackboneElement') as request,  request.method = 'POST',  e3.resource = create('Condition') as condition,  condition.id = uuid() as uuid3,  e3.fullUrl = append('https://example/Condition/', uuid3),  request.url = 'Condition',  obs2.focus = create('Reference') as reference,  reference.reference = ('https://example/Condition/' + %condition.id) then ConditionFunction(observation, condition, patient, encounter, bundle) "condition";
        entry.organizer as organizer then {
          section ->  bundle.entry as e11,  e11.request = create('BackboneElement') as request,  request.method = 'POST',  e11.resource = create('List') as list11,  list11.id = uuid() as uuid11,  e11.fullUrl = append('https://example/List/', uuid11),  request.url = 'List',  obs2.focus = create('Reference') as reference,  reference.reference = ('https://example/List/' + %list11.id) then {
            section ->  list11.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
            section -> list11.status = 'current' "liststat";
            section -> list11.mode = 'working' "listmd";
            section ->  list11.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
            organizer -> list11.entry as entryList2 then {
              organizer ->  bundle.entry as e12,  e12.request = create('BackboneElement') as request,  request.method = 'POST',  e12.resource = create('FamilyMemberHistory') as familyMember,  familyMember.id = uuid() as uuid12,  e12.fullUrl = append('https://example/FamilyMemberHistory/', uuid12),  request.url = 'FamilyMemberHistory',  entryList2.item = create('Reference') as reference,  reference.reference = ('https://example/FamilyMemberHistory/' + %familyMember.id) then FamilyMemberFunction(organizer, familyMember, patient) "family";
            } "org";
          } "List";
        };
      };
    } "StoriaClinica1";
    section where code.code = '30954-2' ->  bundle.entry as e4,  e4.request = create('BackboneElement') as request,  request.method = 'POST',  e4.resource = create('Observation') as obs4,  obs4.id = uuid() as uuid4,  e4.fullUrl = append('https://example/Observation/', uuid4),  request.url = 'Observation',  dReport.result = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obs4.id) then Observation(observation, patient, encounter, obs4, bundle) "PrecedentiEsamiEseguiti";
    section where code.code = '29548-5' ->  bundle.entry as e5,  e5.request = create('BackboneElement') as request,  request.method = 'POST',  e5.resource = create('Observation') as obs5,  obs5.id = uuid() as uuid5,  e5.fullUrl = append('https://example/Observation/', uuid5),  request.url = 'Observation',  dReport.result = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obs5.id) then Observation(observation, patient, encounter, obs5, bundle) "Diagnosi";
  } "entryObs";
  src.act as act then {
    section where code.code = '62387-6' ->  dReport.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) then {
      act.code -> encounter.type "type";
      act.effectiveTime as effectiveTime -> encounter.period as period then {
        effectiveTime -> period.start = create('dateTime') as start then TSDateTime(effectiveTime, start) "val";
      } "period";
      act ->  bundle.entry as e10,  e10.request = create('BackboneElement') as request,  request.method = 'POST',  e10.resource = create('Procedure') as procedureRes,  procedureRes.id = uuid() as uuid10,  e10.fullUrl = append('https://example/Procedure/', uuid10),  request.url = 'Procedure',  encounter.reasonReference = create('Reference') as reference,  reference.reference = ('https://example/Procedure/' + %procedureRes.id) then {
        act ->  procedureRes.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
        act ->  procedureRes.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
        act.statusCode -> procedureRes.status "status1";
        act where statusCode.exists().not() -> procedureRes.status = 'unknown' "status2";
        act.entryRelationship as entryRel then {
          entryRel.procedure as proc ->  bundle.entry as e9,  e9.request = create('BackboneElement') as request,  request.method = 'POST',  e9.resource = create('Procedure') as procedure2,  procedure2.id = uuid() as uuid9,  e9.fullUrl = append('https://example/Procedure/', uuid9),  request.url = 'Procedure',  procedureRes.partOf = create('Reference') as reference,  reference.reference = ('https://example/Procedure/' + %procedure2.id) then Procedure(proc, patient, encounter, procedure2, bundle) "procedurePrestazioni";
          entryRel.substanceAdministration as subAdmin ->  bundle.entry as e8,  e8.request = create('BackboneElement') as request,  request.method = 'POST',  e8.resource = create('MedicationAdministration') as medAdmin,  medAdmin.id = uuid() as uuid8,  e8.fullUrl = append('https://example/MedicationAdministration/', uuid8),  request.url = 'MedicationAdministration',  procedureRes.partOf = create('Reference') as reference,  reference.reference = ('https://example/MedicationAdministration/' + %medAdmin.id) then MedicationAdministration(subAdmin, patient, encounter, medAdmin, bundle) "farmacPrestazioni";
          entryRel.observation as entryRobs ->  bundle.entry as e7,  e7.request = create('BackboneElement') as request,  request.method = 'POST',  e7.resource = create('Observation') as obs7,  obs7.id = uuid() as uuid7,  e7.fullUrl = append('https://example/Observation/', uuid7),  request.url = 'Observation',  procedureRes.partOf = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obs7.id) then ObservationPrest(entryRobs, patient, encounter, obs7, bundle) "osservazioniPrestazioni";
          entryRel.act as act2 ->  bundle.entry as e6,  e6.request = create('BackboneElement') as request,  request.method = 'POST',  e6.resource = create('Procedure') as procedure3,  procedure3.id = uuid() as uuid6,  e6.fullUrl = append('https://example/Procedure/', uuid6),  request.url = 'Procedure',  procedureRes.partOf = create('Reference') as reference,  reference.reference = ('https://example/Procedure/' + %procedure3.id) then Procedure(act2, patient, encounter, procedure3, bundle) "procedureGenerichePrestazioni";
        } "Relationship";
      } "proceduraMadre";
    } "Prestazioni";
    section where code.code = '80615-8' ->  bundle.entry as e12,  e12.request = create('BackboneElement') as request,  request.method = 'POST',  e12.resource = create('Observation') as obs12,  obs12.id = uuid() as uuid12,  e12.fullUrl = append('https://example/Observation/', uuid12),  request.url = 'Observation',  dReport.result = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obs12.id) then Observation(act, patient, encounter, obs12, bundle) "Followup";
  } "entryAct";
  // src.substanceAdministration
  src.substanceAdministration as substanceadmin then {
    section where code.code = '93341-6' ->  bundle.entry as e6,  e6.request = create('BackboneElement') as request,  request.method = 'POST',  e6.resource = create('MedicationRequest') as medre1,  medre1.id = uuid() as uuid6,  e6.fullUrl = append('https://example/MedicationRequest/', uuid6),  request.url = 'MedicationRequest',  dReport.basedOn = create('Reference') as reference,  reference.reference = ('https://example/MedicationRequest/' + %medre1.id) then MedicationRequest(substanceadmin, patient, encounter, medre1, bundle) "TerapiaFarmacologicaConsigliata";
  } "substanceadmin";
  section where section.entry.exists().not() then {
    section where (code.code = '48765-2') ->  bundle.entry as e2,  e2.request = create('BackboneElement') as request,  request.method = 'POST',  e2.resource = create('Observation') as obs1,  obs1.id = uuid() as uuid2,  e2.fullUrl = append('https://example/Observation/', uuid2),  request.url = 'Observation',  dReport.result = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obs1.id) then {
      section ->  obs1.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
      section ->  obs1.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
      section -> obs1.status = 'final' "STatusobse";
      section.code -> obs1.code;
      section.statusCode as s then {
        s.code as cos -> obs1.status = translate(cos, '#OBSstatus', 'code') "codeS";
      } "status";
      section.text as text ->  bundle.entry as e5,  e5.request = create('BackboneElement') as request,  request.method = 'POST',  e5.resource = create('AllergyIntolerance') as allergy,  allergy.id = uuid() as uuid5,  e5.fullUrl = append('https://example/AllergyIntolerance/', uuid5),  request.url = 'AllergyIntolerance',  obs1.focus = create('Reference') as reference,  reference.reference = ('https://example/AllergyIntolerance/' + %allergy.id) then {
        section ->  allergy.patient = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
        section ->  allergy.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
        section -> allergy.clinicalStatus as clinicalStatus then {
          section -> clinicalStatus.coding = create('Coding') as coding then {
            section -> coding.code = 'active' "code";
            section -> coding.system = 'http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical' "system";
          } "coding";
        } "status";
        text -> allergy.note as note then {
          text as t -> note.text = create('string') as textNote then EDstring(t, textNote) "note";
        } "narrative";
      } "allergytext";
    } "allergyAct";
    section where (code.code = '93341-6') then {
      section.text as text ->  bundle.entry as e13,  e13.request = create('BackboneElement') as request,  request.method = 'POST',  e13.resource = create('MedicationRequest') as obs13,  obs13.id = uuid() as uuid13,  e13.fullUrl = append('https://example/MedicationRequest/', uuid13),  request.url = 'MedicationRequest',  dReport.basedOn = create('Reference') as reference,  reference.reference = ('https://example/MedicationRequest/' + %obs13.id) then {
        section ->  obs13.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
        section ->  obs13.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
        section -> obs13.intent = 'order' "intent";
        section where statusCode.exists().not() -> obs13.status = 'unknown' "st";
        text -> obs13.note as note then {
          text as t -> note.text = create('string') as textNote then EDstring(t, textNote) "note";
        } "note";
        section -> obs13.medication = create('CodeableConcept') as code then {
          section -> code.text = 'string' "string";
        } "code";
      } "txtsec";
    } "MedicationRequest";
    section where (code.code = '55110-1').not() and (code.code = '93341-6').not() and (code.code = '48765-2').not() then {
      section.text as text ->  bundle.entry as e13,  e13.request = create('BackboneElement') as request,  request.method = 'POST',  e13.resource = create('Observation') as obs13,  obs13.id = uuid() as uuid13,  e13.fullUrl = append('https://example/Observation/', uuid13),  request.url = 'Observation',  dReport.result = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obs13.id) then {
        section ->  obs13.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
        section ->  obs13.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
        section -> obs13.status = 'preliminary' "obsst";
        section.code -> obs13.code "obscde";
        section -> obs13.status = 'final' "statusS";
        text -> obs13.note as note then {
          text as t -> note.text = create('string') as textNote then EDstring(t, textNote) "note";
        } "narrative";
      } "txtsec";
    } "NonConclusion";
    section where (code.code = '55110-1') then {
      section.text as t -> dReport.conclusion = create('string') as textConclusion then EDstring(t, textConclusion) "conc";
    } "conclusion";
  } "whereCond";
}

group Observation(source cda : observation, target patient : Patient, target encounter : Encounter, target ob : Observation, target bundle : Bundle) {
  cda ->  ob.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
  cda ->  ob.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
  cda.code -> ob.code;
  cda -> ob.status = 'final' "Stats";
  // value datatype
  cda.value : INT as int -> ob.value = (int.value);
  cda.value : ST as st ->  ob.value = create('string'),  ob.value = (st.dataString);
  cda.value : BL as boolean -> ob.value = (boolean.value) "boolean";
  cda.value : CE as val then {
    val -> ob.value = create('CodeableConcept') as ce then {
      val.originalText as originalText then {
        originalText.reference as reference -> ce.text = (reference.value);
      };
      val -> ce.coding as coding then {
        val.code as code -> coding.code = cast(code, 'string');
        val.codeSystem as system -> coding.system = translate(system, 'http://hl7.org/fhir/ConceptMap/special-oid2uri', 'uri');
        val.displayName as display -> coding.display = cast(display, 'string');
      } "code";
      val.translation as translation -> ce.coding as coding then {
        translation.code as code -> coding.code = cast(code, 'string');
        translation.codeSystem as system -> coding.system = translate(system, 'http://hl7.org/fhir/ConceptMap/special-oid2uri', 'uri');
        translation.displayName as display -> coding.display = cast(display, 'string');
        translation.qualifier as qualifier then {
          qualifier.value as value -> ce.coding as coding then {
            value.code as code -> coding.code = cast(code, 'string');
            value.codeSystem as system -> coding.system = translate(system, 'http://hl7.org/fhir/ConceptMap/special-oid2uri', 'uri');
            value.displayName as display -> coding.display = cast(display, 'string');
          };
        };
      };
    } "coding";
  } "val";
  cda.value : CD as val then {
    val -> ob.value = create('CodeableConcept') as ce then {
      val.originalText as originalText then {
        originalText.reference as reference -> ce.text = (reference.value);
      };
      val -> ce.coding as coding then {
        val.code as code -> coding.code = cast(code, 'string');
        val.codeSystem as system -> coding.system = translate(system, 'http://hl7.org/fhir/ConceptMap/special-oid2uri', 'uri');
        val.displayName as display -> coding.display = cast(display, 'string');
      } "code";
      val.translation as translation -> ce.coding as coding then {
        translation.code as code -> coding.code = cast(code, 'string');
        translation.codeSystem as system -> coding.system = translate(system, 'http://hl7.org/fhir/ConceptMap/special-oid2uri', 'uri');
        translation.displayName as display -> coding.display = cast(display, 'string');
        translation.qualifier as qualifier then {
          qualifier.value as value -> ce.coding as coding then {
            value.code as code -> coding.code = cast(code, 'string');
            value.codeSystem as system -> coding.system = translate(system, 'http://hl7.org/fhir/ConceptMap/special-oid2uri', 'uri');
            value.displayName as display -> coding.display = cast(display, 'string');
          };
        };
      };
    } "coding";
  } "val";
  cda.value : PQ as val then {
    val -> ob.value = create('Quantity') as quantity then {
      val.value as value -> quantity.value = value;
      val.unit as unit -> quantity.unit = unit;
    } "quantity";
  } "valueQuantity";
  cda.effectiveTime as effectiveTime where (value.exists()) -> ob.effective = create('dateTime') as value then TSDateTime(effectiveTime, value) "value1";
  cda.effectiveTime as effectiveTime where (low.exists()) -> ob.effective = create('Period') as value then IVLTSPeriod(effectiveTime, value) "valuePeriod";
  cda.text as text -> ob.note as note then {
    text.reference as reference -> note.text = (reference.value) "text";
  } "note";
  cda.statusCode as s then {
    s.code as cos -> ob.status = translate(cos, '#OBSstatus', 'code') "codeS";
  } "status";
}

group ConditionFunction(source src : cdaElement, target tgt : Condition, target patient : patient, target encounter : encounter, target bundle : Bundle) {
  src.code -> tgt.category;
  src ->  tgt.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
  src ->  tgt.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
  src.statusCode as stscode -> tgt.verificationStatus as verifstatus then {
    stscode as codeS -> verifstatus.coding = create('Coding') as coding then {
      codeS.code -> coding.code = 'confirmed';
      codeS -> coding.system = 'http://terminology.hl7.org/CodeSystem/condition-ver-status' "system";
      codeS -> coding.display = cast('Confirmed', 'string') "display";
    } "coding";
  } "verifstatus";
  src.effectiveTime as effectiveTime -> tgt.onset = create('Period') as value then IVLTSPeriod(effectiveTime, value) "valuePeriod";
  src.value -> tgt.code;
  src.entryRelationship as entryRelationship then {
    entryRelationship.observation as obsentry then {
      obsentry.code where code = '89261-2' then {
        obsentry ->  tgt.evidence as evidence,  bundle.entry as e1,  e1.request = create('BackboneElement') as request,  request.method = 'POST',  e1.resource = create('Observation') as obsy,  obsy.id = uuid() as uuid1,  e1.fullUrl = append('https://example/Observation/', uuid1),  request.url = 'Observation',  evidence.detail = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obsy.id) then Observation(obsentry, patient, encounter, obsy, bundle) "observation";
      } "observation";
      obsentry.code where code = '33999-4' then {
        obsentry.value as value -> tgt.clinicalStatus as clinicalstatus then {
          value as val -> clinicalstatus.coding = create('Coding') as coding then {
            val where (code = 'LA9041-0') -> coding.code = 'resolved' "code";
            val where (code = 'LA18632-2') -> coding.code = 'inactive' "code";
            val where (code = 'LA16666-2') -> coding.code = 'active' "code";
            val -> coding.system = 'http://terminology.hl7.org/CodeSystem/condition-clinical' "system";
            val.displayName as display -> coding.display = cast(display, 'string') "display";
          } "coding";
          obsentry.text as text then {
            text.reference as reference -> clinicalstatus.text = (reference.value) "text";
          };
        } "clinicalstatus";
      } "clinicalStatus2";
    } "EntryRelObsevation";
  } "entryR";
}

group Procedure(source src : procedure, target patient : Patient, target encounter : Encounter, target tgt : Procedure, target bundle : Bundle) {
  src ->  tgt.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
  src ->  tgt.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
  src.statusCode -> tgt.status "status1";
  src where statusCode.exists().not() -> tgt.status = 'unknown' "status2";
  src.id -> tgt.identifier;
  src.code -> tgt.code;
  src.effectiveTime as effectiveTime where (value.exists()) -> tgt.performed = create('dateTime') as value then TSDateTime(effectiveTime, value) "value1";
  src.effectiveTime as effectiveTime where (low.exists()) -> tgt.performed = create('Period') as value then IVLTSPeriod(effectiveTime, value) "valuePeriod";
  src.methodCode as methodCode -> tgt.extension as ext1 then ITMethodExt(methodCode, ext1);
  src.participant as participant then {
    participant.participantRole as participantRole -> tgt.performer as performer then {
      participantRole.playingDevice as device ->  bundle.entry as e2,  e2.request = create('BackboneElement') as request,  request.method = 'POST',  e2.resource = create('Device') as deviceRes,  deviceRes.id = uuid() as uuid2,  e2.fullUrl = append('https://example/Device/', uuid2),  request.url = 'Device',  performer.actor = create('Reference') as reference,  reference.reference = ('https://example/Device/' + %deviceRes.id) then {
        device.manufacturerModelName as manufacturerModelName then {
          manufacturerModelName.displayName as displayName -> deviceRes.manufacturer = cast(displayName, 'string') "manuf";
        } "manufacturer";
        device.code -> deviceRes.type;
      } "device";
    };
  };
  src.entryRelationship as entryR then {
    entryR.observation as observation ->  bundle.entry as e3,  e3.request = create('BackboneElement') as request,  request.method = 'POST',  e3.resource = create('Observation') as obs1,  obs1.id = uuid() as uuid3,  e3.fullUrl = append('https://example/Observation/', uuid3),  request.url = 'Observation',  tgt.partOf = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obs1.id) then Observation(observation, patient, encounter, obs1, bundle) "Parametri";
    entryR.act as act then {
      act.text as text -> tgt.note as note then {
        text.reference as reference -> note.text = (reference.value) "text";
      } "note";
    };
  } "entryRelProcedure";
}

group ITMethodExt(source src, target ext) {
  src -> ext.url = 'http://hl7.org/fhir/StructureDefinition/procedure-method' "url";
  src -> ext.value = create('CodeableConcept') as value then CECodeableConcept(src, value) "value";
}

group MedicationAdministration(source src : substanceAdministration, target patient : Patient, target encounter : Encounter, target tgt : MedicationAdministration, target bundle : Bundle) {
  src ->  tgt.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
  src ->  tgt.context = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
  src.statusCode -> tgt.status "status1";
  src where statusCode.exists().not() -> tgt.status = 'unknown' "status2";
  src.id -> tgt.identifier;
  src.effectiveTime as effectiveTime where (value.exists()) -> tgt.effective = create('dateTime') as value then TSDateTime(effectiveTime, value) "value1";
  src.effectiveTime as effectiveTime where (low.exists()) -> tgt.effective = create('Period') as value then IVLTSPeriod(effectiveTime, value) "valuePeriod";
  src -> tgt.dosage as dosage then {
    src.routeCode -> dosage.route "route";
    src.repeatNumber as repeatNumber -> dosage.rate = create('SimpleQuantity') as value then PQQuantity(repeatNumber, value) "repQ";
    src.approachSiteCode -> dosage.site "site";
    src.targetSiteCode -> dosage.site "site";
  } "dosage";
  src.consumable as consumable ->  bundle.entry as e1,  e1.request = create('BackboneElement') as request,  request.method = 'POST',  e1.resource = create('Medication') as medication,  medication.id = uuid() as uuid1,  e1.fullUrl = append('https://example/Medication/', uuid1),  request.url = 'Medication',  tgt.medication = create('Reference') as medref,  medref.reference = ('https://example/Medication/' + %medication.id) then Medication(src, medication, patient, bundle) "medication";
  src.participant as participant then {
    participant.participantRole as participantRole -> tgt.performer as performer then {
      participantRole.device as device ->  bundle.entry as e2,  e2.request = create('BackboneElement') as request,  request.method = 'POST',  e2.resource = create('Device') as deviceRes,  deviceRes.id = uuid() as uuid2,  e2.fullUrl = append('https://example/Device/', uuid2),  request.url = 'Device',  performer.actor = create('Reference') as reference,  reference.reference = ('https://example/Device/' + %deviceRes.id) then {
        device.ManufacturerModelName as ManufacturerModelName then {
          ManufacturerModelName.code -> deviceRes.manufacturer "manuf";
        } "manufacturer";
      };
    };
  };
  src.entryRelationship as entryR then {
    entryR.observation as observation ->  bundle.entry as e3,  e3.request = create('BackboneElement') as request,  request.method = 'POST',  e3.resource = create('Observation') as obs1,  obs1.id = uuid() as uuid3,  e3.fullUrl = append('https://example/Observation/', uuid3),  request.url = 'Observation',  tgt.partOf = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obs1.id) then Observation(observation, patient, encounter, obs1, bundle) "Parametri";
    entryR.act as act then {
      act.text as text -> tgt.note as note then {
        text.reference as reference -> note.text = (reference.value) "text";
      } "note";
    };
  } "entryRelMedication";
  src where (src.doseQuantity.exists() or src.rateQuantity.exists()) ->  bundle.entry as e1,  e1.request = create('BackboneElement') as request,  request.method = 'POST',  e1.resource = create('MedicationRequest') as medicationRq,  medicationRq.id = uuid() as uuid1,  e1.fullUrl = append('https://example/MedicationRequest/', uuid1),  request.url = 'MedicationRequest',  tgt.request = create('Reference') as reference,  reference.reference = ('https://example/MedicationRequest/' + %medicationRq.id) then MedicationRequest(src, patient, encounter, medicationRq, bundle) "medRequ";
  src.text as text -> tgt.note as note then {
    text -> note.text "text";
  } "note";
}

group ObservationPrest(source src : observation, target patient : Patient, target encounter : Encounter, target tgt : Observation, target bundle : Bundle) {
  src ->  tgt.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
  src ->  tgt.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
  src.statusCode as s then {
    s.code as cos -> tgt.status = translate(cos, '#OBSstatus', 'code') "codeS";
  } "status";
  src.id -> tgt.identifier;
  src.code -> tgt.code;
  src.effectiveTime as effectiveTime where (value.exists()) -> tgt.perfomed = create('dateTime') as value then TSDateTime(effectiveTime, value) "value1";
  src.effectiveTime as effectiveTime where (low.exists()) -> tgt.perfomed = create('Period') as value then IVLTSPeriod(effectiveTime, value) "valuePeriod";
  src.methodCode -> tgt.method;
  src.participant as participant then {
    participant.participantRole as participantRole then {
      participantRole.device as device ->  bundle.entry as e2,  e2.request = create('BackboneElement') as request,  request.method = 'POST',  e2.resource = create('Device') as deviceRes,  deviceRes.id = uuid() as uuid2,  e2.fullUrl = append('https://example/Device/', uuid2),  request.url = 'Device',  tgt.device = create('Reference') as reference,  reference.reference = ('https://example/Device/' + %deviceRes.id) then {
        device.ManufacturerModelName as ManufacturerModelName then {
          ManufacturerModelName.code -> deviceRes.manufacturer "manuf";
        } "manufacturer";
      };
    };
  };
  src.entryRelationship as entryR then {
    entryR.observation as observation ->  bundle.entry as e3,  e3.request = create('BackboneElement') as request,  request.method = 'POST',  e3.resource = create('Observation') as obs1,  obs1.id = uuid() as uuid3,  e3.fullUrl = append('https://example/Observation/', uuid3),  request.url = 'Observation',  tgt.hasMember = create('Reference') as reference,  reference.reference = ('https://example/Observation/' + %obs1.id) then Observation(observation, patient, encounter, obs1, bundle) "Parametri";
    entryR.act as act then {
      act.text as text -> tgt.note as note then {
        text.reference as reference -> note.text = (reference.value) "text";
      } "note";
    };
  } "entryRelOsservazioni";
}

group MedicationRequest(source src : substanceAdministration, target patient : Patient, target encounter : Encounter, target tgt : MedicationRequest, target bundle : Bundle) {
  // default  + mandatory
  src ->  tgt.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
  src ->  tgt.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
  src -> tgt.intent = 'order' "intent";
  src where statusCode.exists().not() -> tgt.status = 'unknown' "st";
  src.statusCode as sc then {
    sc.code as cos -> tgt.status = translate(cos, '#MedicationStatusMap', 'code') "codeS";
  } "status";
  src.text as txt -> tgt.note as note then {
    txt.reference as reference -> note.text = (reference.value) "text";
  } "note";
  src.effectiveTime : IVL_TS as eff -> tgt.dosageInstruction = create('Dosage') as dosage then {
    eff -> dosage.timing = create('Timing') as timing then {
      eff -> timing.repeat as rep then {
        eff as eff where (value.exists()) -> rep.bounds = create('dateTime') as value then TSDateTime(eff, value) "value1";
        eff as eff where (low.exists()) -> rep.bounds = create('Period') as value then IVLTSPeriod(eff, value) "valuePeriod";
      } "rep";
    } "timing";
  } "period";
  src.effectiveTime : EIVL_TS as effe -> tgt.dosageInstruction = create('Dosage') as dosage then {
    effe -> dosage.timing = create('Timing') as timing then {
      effe -> timing.repeat as rep then {
        effe.eventCode as ev -> rep.when = (ev.code);
      } "rep";
    } "timing";
  } "period";
  src.effectiveTime : IVL_TS as eff ->  tgt.dosageInstruction = create('Dosage') as dosage,  dosage.timing = create('Timing') as timing,  timing.event = (eff.value) "tim";
  src.effectiveTime : PIVL_TS as eff -> tgt.dosageInstruction = create('Dosage') as dosage then {
    eff -> dosage.timing = create('Timing') as timing then periodTiming(eff, timing) "cod";
  } "eff";
  src where (src.doseQuantity.exists() or src.rateQuantity.exists()) then {
    src -> tgt.dosageInstruction = create('Dosage') as dosageInstruction then {
      src.doseQuantity as doseQuant then {
        doseQuant.originalText as ot then {
          ot.reference -> dosageInstruction.text;
        } "ot";
        doseQuant -> dosageInstruction.doseAndRate as dosageRate then {
          doseQuant -> dosageRate.dose = create('Range') as d then {
            doseQuant -> d.low = create('SimpleQuantity') as l then {
              doseQuant.low as lo -> l.value = (lo.value);
              doseQuant.low as lo -> l.unit = (lo.unit);
            } "low";
            doseQuant -> d.high = create('SimpleQuantity') as h then {
              doseQuant.high as hi -> h.value = (hi.value);
              doseQuant.high as hi -> h.unit = (hi.unit);
            } "low";
          } "d";
        } "dosageRate";
      };
      src.rateQuantity as rateQuantity then {
        rateQuantity.originalText as ot then {
          ot.reference -> dosageInstruction.text;
        } "ot";
        rateQuantity -> dosageInstruction.doseAndRate as dosageRate then {
          rateQuantity -> dosageRate.rate = create('Range') as d then {
            rateQuantity -> d.low = create('SimpleQuantity') as l then {
              rateQuantity.low as lo -> l.value = (lo.value);
              rateQuantity.low as lo -> l.unit = (lo.unit);
            } "low";
            rateQuantity -> d.high = create('SimpleQuantity') as h then {
              rateQuantity.high as hi -> h.value = (hi.value);
              rateQuantity.high as hi -> h.unit = (hi.unit);
            } "high";
          } "r";
        } "dosageRate";
      } "rate";
      src.routeCode -> dosageInstruction.route "route";
      src.approachSiteCode -> dosageInstruction.site "site";
      src.targetSiteCode -> dosageInstruction.site "site";
    } "dosageIn";
  } "condition";
  src.consumable as consumable ->  bundle.entry as e1,  e1.request = create('BackboneElement') as request,  request.method = 'POST',  e1.resource = create('Medication') as medication,  medication.id = uuid() as uuid1,  e1.fullUrl = append('https://example/Medication/', uuid1),  request.url = 'Medication',  tgt.medication = create('Reference') as medref,  medref.reference = ('https://example/Medication/' + %medication.id) then Medication(src, medication, patient, bundle) "medication";
  src.entryRelationship as entryRelationship then {
    entryRelationship.supply as supply -> tgt.dispenseRequest as dispenseRequest then {
      supply.quantity as quantityCDA -> dispenseRequest.quantity as quantityFHIR then {
        quantityCDA -> quantityFHIR.value = (quantityCDA.value) "value";
      };
    };
  } "entryR";
  src.participant as participant then {
    participant then Practitioner(participant, tgt, bundle) "function";
    participant.effectiveTime -> tgt.authoredOn "autor";
  } "Partecipant";
}

group periodTiming(source effectiveTime : PIVL_TS, target timing : Timing) {
  effectiveTime -> timing.repeat as r then {
    effectiveTime.period as p -> r.period = (p.value);
    effectiveTime.period as p -> r.periodUnit = (p.unit);
  } "repeat";
}

group Medication(source src : cda, target tgt : Medication, target patient : Patient, target bundle : Bundle) {
  src.consumable as consumable then {
    consumable.manufacturedProduct as manufacturedProduct then {
      manufacturedProduct.manufacturedMaterial as manufacturedMaterial then {
        manufacturedMaterial.code -> tgt.code "CE";
        src.administrationUnitCode -> tgt.form "form";
      } "material";
    } "product";
  };
  src.entryRelationship as entryR then {
    entryR.observation as observation then {
      observation.code where displayName = 'Grammatura' -> tgt.ingredient as ingredient then {
        src.consumable as consumable then {
          consumable.manufacturedProduct as manufacturedProduct then {
            manufacturedProduct.manufacturedMaterial as manufacturedMaterial then {
              manufacturedMaterial.code as code -> ingredient.item = create('CodeableConcept') as value then CECodeableConcept(code, value) "CE";
            } "material";
          } "product";
        };
        observation.value as value -> ingredient.strength as strength then {
          value -> strength.numerator as numerator then {
            value -> numerator.value = (value.value) "valueN";
          } "numerator";
          value -> strength.denominator as denominator then {
            value -> denominator.value = 1 "valueD";
          } "denominator";
        } "strenght";
      } "ingredient";
      observation.code where displayName = 'Quantità nella Confezione' then {
        observation.value as value -> tgt.amount as amount then {
          value -> amount.numerator as numerator then {
            value -> numerator.value = (value.value) "valueN";
          } "numerator";
          value -> amount.denominator as denominator then {
            value -> denominator.value = 1 "valueD";
          } "denominator";
        } "amount";
      } "quantita";
    } "obs";
  } "entryR";
}

group MedicationStatement(source src : subAdmin, target tgt : MedicationStatement, target patient : Patient, target encounter : Encounter, target bundle : Bundle) {
  src ->  tgt.subject = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
  src.statusCode -> tgt.status;
  src where statusCode.exists().not() -> tgt.status = 'unknown' "notpresent";
  src.consumable as consumable then {
    consumable.manufacturedProduct as manufacturedProduct then {
      manufacturedProduct.manufacturedMaterial as manufacturedMaterial then {
        manufacturedMaterial.code as code -> tgt.medication = create('CodeableConcept') as ce then CECodeableConcept(code, ce) "CE";
      } "material";
    } "product";
  };
}

group FamilyMemberFunction(source src : organizer, target tgt : FamilyMemberHistory, target patient : patient) {
  src ->  tgt.patient = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "patReference";
  src.statusCode -> tgt.status;
  src.effectiveTime as effectiveTime -> tgt.date = create('date') as value then TSDateTime(effectiveTime, value) "date";
  src.subject as subject then {
    subject.relatedSubject as relatedSubject then {
      relatedSubject.code -> tgt.relationship "relationshipCode";
      relatedSubject.subject as subject -> tgt.sex as sex then {
        subject.administrativeGenderCode as administrativeGenderCode -> sex.coding as coding then {
          administrativeGenderCode.code as sexCode -> coding.code = translate(sexCode, '#cm-v3-administrative-gender', 'code') "gender";
          administrativeGenderCode -> coding.system = 'http://hl7.org/fhir/administrative-gender' "system";
        } "coding";
      };
    } "relatedSub";
  } "relationship";
  src.component as component -> tgt.condition as condition then {
    component.observation as observation then {
      observation.code -> condition.code;
      observation.text as text -> tgt.note as note then {
        text.reference as reference -> note.text = (reference.value) "value";
      } "reference";
      observation.statusCode -> tgt.status;
      // observation.effectiveTime as effectiveTime -> condition.onset = create('Period') as value then IVLTSPeriod(effectiveTime, value) "valuePeriod";
      observation where observation.effectiveTime.exists() then {
        observation.effectiveTime as effectiveTime -> tgt.condition = create('BackboneElement') as condition then {
          observation.code -> condition.code;
          observation.value -> condition.outcome "codeable";
          effectiveTime -> condition.onset = create('Period') as period then {
            effectiveTime -> period.start = create('dateTime') as start then TSDateTime(effectiveTime, start) "val";
          } "efft";
        } "effttemp";
      } "cont";
      observation.value -> condition.outcome "codeable";
      observation.entryRelationship as entryR then {
        entryR.observation as obs then {
          obs where (code.code = '35267-4') then {
            obs.value as value -> condition.onset = create('Age') as Age then {
              value.value as valueAge -> Age.value = valueAge "age";
              value.unit as unit -> Age.code = unit;
              value.unit as unit -> Age.unit = unit;
              value -> Age.system = 'http://unitsofmeasure.org' "system";
            };
          } "insorgenza";
          obs where (code.code = '39016-1') then {
            obs.value as value -> tgt.deceased = create('Age') as Age then {
              value.value as valueAge -> Age.value = valueAge "age";
              value.unit as unit -> Age.code = unit;
              value.unit as unit -> Age.unit = unit;
              value -> Age.system = 'http://unitsofmeasure.org' "system";
            };
          } "death";
        } "obser";
      } "EntryRel";
    };
  };
}

group allergyFunction(source src : cdaElement, target tgt : AllergyIntolerance, target patient : patient, target encounter : encounter) {
  src ->  tgt.patient = create('Reference') as reference,  reference.reference = ('https://example/Patient/' + %patient.id) "reference";
  src ->  tgt.encounter = create('Reference') as reference,  reference.reference = ('https://example/Encounter/' + %encounter.id) "reference";
  src.entryRelationship as entryRelationship1 then {
    entryRelationship1.observation as observation1 then {
      observation1.effectiveTime as effectiveTime -> tgt.onset = create('Period') as value then IVLTSPeriod(effectiveTime, value) "valuePeriod";
      observation1.value as code then {
        code.code as code1 -> tgt.type = translate(code1, '#AllergyTypeMap', 'code') "type";
        code.code as code1 -> tgt.category = translate(code1, '#AllergyCategoryMap', 'code') "category";
      } "code";
      observation1.participant as participant -> tgt.reaction as reaction then {
        observation1.entryRelationship as entryRelationship2 where (typeCode = 'MFST') then {
          entryRelationship2.observation as observation2 then {
            observation2.value -> reaction.manifestation "manifestation";
            observation2.effectiveTime as effectiveTime then {
              effectiveTime.low as low -> reaction.onset = create('dateTime') as value then TSDateTime(low, value) "valuePeriodLow";
            } "low";
          } "observ2";
        } "entryR2";
        participant.participantRole as participantRole then {
          participantRole.playingEntity as playingEntity then {
            playingEntity.code -> reaction.substance "reaction";
          };
        };
      };
      observation1.entryRelationship as entryRelationship2 where (typeCode = 'MFST') then {
        entryRelationship2.observation as observation2 where observation1.participant.exists().not() -> tgt.reaction as reaction then {
          observation2.value -> reaction.manifestation "manifestation";
          observation2.effectiveTime as effectiveTime then {
            effectiveTime.low as low -> reaction.onset = create('dateTime') as value then TSDateTime(low, value) "valuePeriodLow";
          } "low";
        } "observ2";
      } "entryR2";
      observation1.entryRelationship as entryRelationship3 where (typeCode = 'SUBJ') then {
        entryRelationship3.observation as observation3 then {
          observation3.value as value then {
            value.code as c -> tgt.criticality = translate(c, '#CricalityMap', 'code') "value";
          } "criticality";
        } "observ3";
        entryRelationship3.act as act -> tgt.note as note then {
          act.text as text then {
            text.reference as reference -> note.text = (reference.value);
          } "note";
        };
      } "entryR3";
      observation1.entryRelationship as entryRelationship4 where (typeCode = 'REFR') then {
        entryRelationship4.observation as observation4 then {
          observation4.value as value -> tgt.clinicalStatus as clinicalStatus then {
            value as valu -> clinicalStatus.coding = create('Coding') as coding then {
              valu where (code = 'LA9041-0') -> coding.code = 'resolved' "code";
              valu where (code = 'LA18632-2') -> coding.code = 'inactive' "code";
              valu where (code = 'LA16666-2') -> coding.code = 'active' "code";
              valu -> coding.system = 'http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical' "system";
              valu.displayName as display -> coding.display = cast(display, 'string') "display";
            } "coding";
          } "clinicalStatus";
        } "observ4";
      } "entryR4";
    };
  } "entryrelationship";
}

group Practitioner(source src : participant, target tgt : MedicationRequest, target bundle : Bundle) {
  src ->  bundle.entry as e22,  e22.request = create('BackboneElement') as request,  request.method = 'PUT',  e22.resource = create('Practitioner') as practitioner1 then {
    src.participantRole as practr then {
      practr.id as id -> practitioner1.identifier as identifier then {
        id.root as r -> identifier.system = translate(r, 'http://hl7.org/fhir/ConceptMap/special-oid2uri', 'uri') "root1";
        id.extension as ext -> identifier.value = ext "ext";
        id.assigningAuthorityName as s ->  identifier.assigner as a,  a.display = s;
        id.root as r then {
          id.extension as ext ->  practitioner1.id = (r + '-' + ext) as uuid22,  e22.fullUrl = append('https://example/Practitioner/', uuid22),  tgt.requester = create('Reference') as reference,  reference.reference = ('https://example/Practitioner/' + %practitioner1.id) "id";
        } "r";
      } "identifier";
      practr.id as id where (root = '2.16.840.1.113883.2.9.4.3.2') then {
        id.extension as ext -> request.url = append('Practitioner?identifier=', ext) "UUID";
      } "2";
      practr.id as id where (root != '2.16.840.1.113883.2.9.4.3.2') then {
        id.extension as ext -> request.url = append('Practitioner?identifier=', ext) "UUID";
      } "diverso";
      practr -> practitioner1.meta as meta then {
        practr -> meta.tag = create('Coding') as coding then {
          practr -> coding.system = 'http://algoritmodiscoring' "system";
          practr -> coding.code = 'ClinicalDocument/body/TerapiaFarmacologicaConsigliata/participant' "code";
        } "coding";
      } "meta";
      practr.addr -> practitioner1.address;
      practr.telecom -> practitioner1.telecom;
      practr.playingEntity as plentity then {
        plentity.name -> practitioner1.name;
        plentity.birthTime as birthTime then {
          birthTime.value as date -> practitioner1.birthDate = truncate(date, 10);
        } "birth";
      } "partname";
    } "resurceCreation";
  } "practitionerCreate";
}


```

 IG © 2023+ [HL7 Italy](http://hl7.it). Package hl7.fhir.it.cda2fhir#0.1.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

