# reference - CDA to FHIR Maps v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **reference**

CDA to FHIR Maps, published by HL7 Italy. This guide is not an authorized publication; it is the continuous build for version 0.1.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/hl7-it/cda2fhir/](https://github.com/hl7-it/cda2fhir/) and changes regularly. See the [Directory of published versions](http://hl7.it/fhir/cda2fhir/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-references-C-definitions.md) 
*  [Mappings](StructureDefinition-references-C-mappings.md) 
*  [XML](StructureDefinition-references-C.profile.xml.md) 
*  [JSON](StructureDefinition-references-C.profile.json.md) 
*  [TTL](StructureDefinition-references-C.profile.ttl.md) 

## Extension: reference 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/cda2fhir/StructureDefinition/references-C | *Version*:0.1.0 |
| Draft as of 2025-10-01 | *Computable Name*:ReferencesC |

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [StructureMapProfile](StructureDefinition-StructureMapProfile.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.cda2fhir|current/StructureDefinition/references-C)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type base64Binary, boolean, canonical, code, date, dateTime, decimal, id, instant, integer, markdown, oid, positiveInt, string, time, unsignedInt, uri, url, uuid, Address, Age, Annotation, Attachment, CodeableConcept, Coding, ContactPoint, Count, Distance, Duration, HumanName, Identifier, Money, Period, Quantity, Range, Ratio, Reference, SampledData, Signature, Timing, ContactDetail, Contributor, DataRequirement, Expression, ParameterDefinition, RelatedArtifact, TriggerDefinition, UsageContext, Dosage, Meta: 

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type base64Binary, boolean, canonical, code, date, dateTime, decimal, id, instant, integer, markdown, oid, positiveInt, string, time, unsignedInt, uri, url, uuid, Address, Age, Annotation, Attachment, CodeableConcept, Coding, ContactPoint, Count, Distance, Duration, HumanName, Identifier, Money, Period, Quantity, Range, Ratio, Reference, SampledData, Signature, Timing, ContactDetail, Contributor, DataRequirement, Expression, ParameterDefinition, RelatedArtifact, TriggerDefinition, UsageContext, Dosage, Meta: 

 

Other representations of profile: [CSV](StructureDefinition-references-C.csv), [Excel](StructureDefinition-references-C.xlsx), [Schematron](StructureDefinition-references-C.sch) 

#### Constraints

 IG © 2023+ [HL7 Italy](http://hl7.it). Package hl7.fhir.it.cda2fhir#0.1.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

