# StructureMapProfile - CDA to FHIR Maps v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **StructureMapProfile**

CDA to FHIR Maps, published by HL7 Italy. This guide is not an authorized publication; it is the continuous build for version 0.1.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/hl7-it/cda2fhir/](https://github.com/hl7-it/cda2fhir/) and changes regularly. See the [Directory of published versions](http://hl7.it/fhir/cda2fhir/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-StructureMapProfile-definitions.md) 
*  [Mappings](StructureDefinition-StructureMapProfile-mappings.md) 
*  [XML](StructureDefinition-StructureMapProfile.profile.xml.md) 
*  [JSON](StructureDefinition-StructureMapProfile.profile.json.md) 
*  [TTL](StructureDefinition-StructureMapProfile.profile.ttl.md) 

## Resource Profile: StructureMapProfile 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/cda2fhir/StructureDefinition/StructureMapProfile | *Version*:0.1.0 |
| Draft as of 2025-10-01 | *Computable Name*:StructureMapProfile |

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.cda2fhir|current/StructureDefinition/StructureMapProfile)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [StructureMap](http://hl7.org/fhir/R4/structuremap.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [StructureMap](http://hl7.org/fhir/R4/structuremap.html) 

**Summary**

**Extensions**

This structure refers to these extensions:

* [http://hl7.it/fhir/cda2fhir/StructureDefinition/references-C](StructureDefinition-references-C.md)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [StructureMap](http://hl7.org/fhir/R4/structuremap.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [StructureMap](http://hl7.org/fhir/R4/structuremap.html) 

**Summary**

**Extensions**

This structure refers to these extensions:

* [http://hl7.it/fhir/cda2fhir/StructureDefinition/references-C](StructureDefinition-references-C.md)

 

Other representations of profile: [CSV](StructureDefinition-StructureMapProfile.csv), [Excel](StructureDefinition-StructureMapProfile.xlsx), [Schematron](StructureDefinition-StructureMapProfile.sch) 

 IG © 2023+ [HL7 Italy](http://hl7.it). Package hl7.fhir.it.cda2fhir#0.1.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

