# ConceptMap - CDA to FHIR Maps v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* [**CDA to FHIR - Data Types**](StructureMap-cda2fhirDataTypes.md)
* **ConceptMap**

CDA to FHIR Maps, published by HL7 Italy. This guide is not an authorized publication; it is the continuous build for version 0.1.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/hl7-it/cda2fhir/](https://github.com/hl7-it/cda2fhir/) and changes regularly. See the [Directory of published versions](http://hl7.it/fhir/cda2fhir/history.html)

*  [Narrative Content](#) 

## ConceptMap: ConceptMap 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/cda2fhir/StructureMap/cda2fhirDataTypes#addressUse | *Version*:0.1.0 |
| Draft | *Computable Name*: |

Mapping from (not specified) to (not specified)

**Group 1**Mapping from [AddressUse](http://terminology.hl7.org/6.5.0/ValueSet-v3-AddressUse.html) to [AddressUse](http://hl7.org/fhir/R4/codesystem-address-use.html)

* **Source Code**: H
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: home
* **Source Code**: HP
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: home
* **Source Code**: HV
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: home
* **Source Code**: WP
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: work
* **Source Code**: DIR
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: work
* **Source Code**: PUB
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: work
* **Source Code**: TMP
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: temp (Temporary)
* **Source Code**: OLD
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: old (Old / Incorrect)
* **Source Code**: BAD
  * **Relationship**: [is equivalent to](http://hl7.org/fhir/R5/codesystem-concept-map-relationship.html#equivalent)
  * **Target Code**: old (Old / Incorrect)

 IG © 2023+ [HL7 Italy](http://hl7.it). Package hl7.fhir.it.cda2fhir#0.1.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

