# Artifacts Summary - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [Azienda Sanitaria](StructureDefinition-AziendaSanitaria.md) | Modello Logico che definisce il set minimo di dati che caratterizzano una Azienda Sanitaria. |
| [Documento di Identificazione](StructureDefinition-DocumentoIdentificazione.md) | Modello Logico che definisce il set di dati che caratterizzano i documenti di Identificazione (e.g. Passaporto, CI) . |
| [EHIC (TEAM)](StructureDefinition-EHIC.md) | Modello Logico che definisce il set di dati che caratterizzano la tessera TEAM o EHIC (European Healthcare Insurance Card). |
| [Esenzione](StructureDefinition-Esenzione.md) | Modello Logico che definisce il set minimo di dati che caratterizzano una Esenzione. |
| [Indirizzo](StructureDefinition-Indirizzo.md) | Modello Logico che definisce le tipiche informazioni che caratterizzano un indirizzo nella giurisdizione italiana. |
| [Medico Curante](StructureDefinition-MedicoCurante.md) | Modello Logico che definisce il set minimo di dati che caratterizzano un Medico Curante. |
| [Paziente](StructureDefinition-Paziente.md) | Modello Logico che definisce il set minimo di dati che caratterizzano un paziente nella giurisdizione italiana.. |
| [Persona di Contatto](StructureDefinition-ContattoPersona.md) | Modello Logico che definisce il set di dati che caratterizzano una persona identificato come possibile contatto per il paziente. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Coverage - base](StructureDefinition-Coverage-it-base.md) | Profilo base generico per Coverage: include la rappresentazione dell'ASL di residenza e delle esensioni. |
| [Organization - Operatore sanitario/socio sanitario](StructureDefinition-Organization-it-hcp.md) | Profilo base specifico per Organization: include le informazioni minime per descrivere una organizzazione che eroga od è responsabile per prestazioni sanitarie o socio sanitarie |
| [Organization - base](StructureDefinition-Organization-it-base.md) | Profilo base generico per Organization |
| [Patient - base](StructureDefinition-Patient-it-base.md) | Profilo base generico per Patient: descrive come rappresentare in FHIR alcune informazioni tipiche per il contesto Italiano. |
| [Practitioner - base](StructureDefinition-Practitioner-it-base.md) | Profilo base generico per Practitioner |
| [PractitionerRole - MMG/PLS](StructureDefinition-PractitionerRole-it-mmg.md) | Profilo base specifico per PractitionerRole: include le informazioni minime per descrivere un Medico Medicina Generale od un Pediatra di Libera Scelta e la sua ASL di appartenenza |
| [PractitionerRole - base](StructureDefinition-PractitionerRole-it-base.md) | Profilo base generico per PractitionerRole |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Address - base](StructureDefinition-Address-it-base.md) | Base StructureDefinition per il tipo Address con parti addizionali specifiche per gli indirizzi italiani. Questo profilo struttura l'elemento Address.line in più parti, consente la codifica di alcune di queste parti e supporta la caratterizzazine degli indirizzi di tipo Residenza. Questa prima versione è ispirata al data type Address Olandese. |
| [Money - base](StructureDefinition-Money-it-base.md) | Profilo base generico per Money |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Certificazione](StructureDefinition-recordCertification.md) | Estensione usata per indicare che l'informazione associata è stata certificata (od autocertificata) da una certa entità (persona, organizzazione). L'estensione è caratterizzata da: (a) una data di certificazione o da una periodo di validità (b) un codice od un riferimento al certificatore. |
| [Codice comune e/o stato di nascita](StructureDefinition-patient-codeableBirthPlace.md) | Codice comune e/o stato di nascita |
| [DUG (Denominazione Urbanistica Generica)](StructureDefinition-address-dug.md) | Denominazione Urbanistica Ufficiale |
| [Official Address](StructureDefinition-address-official.md) | Indicate that this address is meant to be the 'official' address for that person. What an 'official' address is depends on the country. This extension allows to specify if this address is or it is not the official address, or to indicate that this is the official address for that country |
| [Professione del paziente](StructureDefinition-patient-occupation-it.md) | Estensione per gestire la professione del paziente come CodeableConcept |
| [Stato Esenzione](StructureDefinition-coverage-exceptionStatus.md) | Estensione per gestire lo stato di una esenzione |
| [Titolo di Studio del paziente](StructureDefinition-patient-qualification-it.md) | Estensione per gestire il Titolo di studio del paziente come CodeableConcept |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Coverage. Esempio di gestire delle esenzioni](Coverage-EsempioEsenzione.md) | Esempio di uso della risorsa coverage per gestire le esenzioni |
| [Organization. Esempio di Azienda Sanitaria Locale](Organization-asl-020101.md) | Esempio di uso della risorsa Organization per descrivere una Azienda Sanitaria Locale |
| [Organization. Esempio generico](Organization-nice-org.md) | Esempio di uso della risorsa Organization |
| [Patient. Esempio con Codice Fiscale, Residenza e Domicilio](Patient-esempio-CF-residenza.md) | Istanza di Patient con Codice Fiscale (certificato), Residenza e Domicilio |
| [Patient. Esempio con Codice Fiscale, Residenza e Domicilio](Patient-esempio-professione.md) | Istanza di Patient con Codice Fiscale, Residenza e Domicilio |
| [Patient. Esempio con STP e birthPlace codificato con SC-code](Patient-Patient-STP-soloTesto.md) | Istanza di Patient con birthPlace codificato usando l'estensione SC-code all'interno di patientBirthPlace |
| [Patient. Esempio di translitterazione di nome con caratteri speciali](Patient-es-trad.md) | Istanza di Patient con esempio di translitterazione del nome con caratteri speciali. Forma con carattere accentato e senza accento |
| [Patient. Esempio con estensione patient-codedBirthPlace-it](Patient-Patient-birthPlace-opt2.md) | Istanza di Patient con birthPlace codificato usando l'estensione patient-codedBirthPlace-it |
| [Practitioner. Esempio](Practitioner-PractitionerExample.md) | Esempio di uso della risorsa Practitioner. |
| [Practitioner. Medico di Medicina Generale](Practitioner-PractitionerMMGExample.md) | Esempio di uso della risorsa Practitioner per rappresentare i dati anagrafici di un medico. |
| [PractitionerRole. Esempio](PractitionerRole-PractitionerRoleExample.md) | Esempio di uso della risorsa PractitionerRole. |
| [PractitionerRole. Medico di Medicina Generale](PractitionerRole-PractitionerRoleMMGExample.md) | Esempio di uso della risorsa PractitionerRole per rappresentare i dati anagrafici di un medico. |

