# PractitionerRole - MMG/PLS - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PractitionerRole - MMG/PLS**

## Resource Profile: PractitionerRole - MMG/PLS 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/PractitionerRole-it-mmg | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:PractitionerRoleMMG |

 
Profilo base specifico per PractitionerRole: include le informazioni minime per descrivere un Medico Medicina Generale od un Pediatra di Libera Scelta e la sua ASL di appartenenza 

**Usages:**

* Refer to this Profile: [Patient - base](StructureDefinition-Patient-it-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/PractitionerRole-it-mmg)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PractitionerRole-it-mmg.csv), [Excel](StructureDefinition-PractitionerRole-it-mmg.xlsx), [Schematron](StructureDefinition-PractitionerRole-it-mmg.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PractitionerRole-it-mmg",
  "url" : "http://hl7.it/fhir/StructureDefinition/PractitionerRole-it-mmg",
  "version" : "0.1.1",
  "name" : "PractitionerRoleMMG",
  "title" : "PractitionerRole - MMG/PLS",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Profilo base specifico per PractitionerRole:  include le informazioni minime per descrivere un Medico Medicina Generale od un Pediatra di Libera Scelta e la sua ASL di appartenenza",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.it/fhir/StructureDefinition/PractitionerRole-it-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole"
      },
      {
        "id" : "PractitionerRole.identifier",
        "path" : "PractitionerRole.identifier",
        "short" : "Identificativo del MMG/PLS (e.g. Codice Fiscale, ID Regionale)"
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "short" : "Dettagli del Medico"
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "short" : "Azienda Sanitaria di Appartenenza",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.it/fhir/StructureDefinition/Organization-it-hcp"]
          }
        ]
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.it/ValueSet/mmgOrPls"
        }
      }
    ]
  }
}

```
