# Practitioner - base - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner - base**

## Resource Profile: Practitioner - base 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/Practitioner-it-base | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:PractitionerBaseIt |

 
Profilo base generico per Practitioner 

**Usages:**

* Refer to this Profile: [Patient - base](StructureDefinition-Patient-it-base.md) and [PractitionerRole - base](StructureDefinition-PractitionerRole-it-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/Practitioner-it-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Practitioner-it-base.csv), [Excel](StructureDefinition-Practitioner-it-base.xlsx), [Schematron](StructureDefinition-Practitioner-it-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Practitioner-it-base",
  "url" : "http://hl7.it/fhir/StructureDefinition/Practitioner-it-base",
  "version" : "0.1.1",
  "name" : "PractitionerBaseIt",
  "title" : "Practitioner - base",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Profilo base generico per Practitioner",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner"
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "description" : "Slice based on the identifier pattern",
          "rules" : "open"
        },
        "short" : "Identificativo dell'operatore sanitario",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier:codiceFiscale",
        "path" : "Practitioner.identifier",
        "sliceName" : "codiceFiscale",
        "min" : 0,
        "max" : "1",
        "patternIdentifier" : {
          "system" : "http://hl7.it/sid/codiceFiscale"
        },
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "short" : "Nome dell'operatore sanitario: include le informazioni minime per descrivere un operatore sanitario",
        "mustSupport" : true
      }
    ]
  }
}

```
