# Paziente - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Paziente**

## Logical Model: Paziente ( Abstract Experimental ) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/Paziente | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:Paziente |

 
Modello Logico che definisce il set minimo di dati che caratterizzano un paziente nella giurisdizione italiana.. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/Paziente)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Paziente.csv), [Excel](StructureDefinition-Paziente.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Paziente",
  "url" : "http://hl7.it/fhir/StructureDefinition/Paziente",
  "version" : "0.1.1",
  "name" : "Paziente",
  "title" : "Paziente",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Modello Logico che definisce il set minimo di dati che caratterizzano un paziente nella giurisdizione italiana..",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir-it",
      "uri" : "http://hl7.it/fhir",
      "name" : "HL7 FHIR IT Profiles"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : true,
  "type" : "Paziente",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Element",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Paziente",
        "path" : "Paziente",
        "short" : "Paziente",
        "definition" : "Modello Logico che definisce il set minimo di dati che caratterizzano un paziente nella giurisdizione italiano.",
        "alias" : ["Patient"],
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient"
          }
        ]
      },
      {
        "id" : "Paziente.identificatori",
        "path" : "Paziente.identificatori",
        "short" : "Identificatori del Paziente",
        "definition" : "Lista degli identificatori del paziente. In base al tipo di soggetto ed al contesto di uso uno o più ID possono essere richiesti",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.identifier"
          }
        ]
      },
      {
        "id" : "Paziente.identificatori.codiceFiscale",
        "path" : "Paziente.identificatori.codiceFiscale",
        "short" : "Codice Fiscale",
        "definition" : "Codice Fiscale",
        "requirements" : "Per i soggetti assistiti dal Servizio Sanitario Nazionale",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Identifier"]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.identifier.slice(codiceFiscale)"
          }
        ]
      },
      {
        "id" : "Paziente.identificatori.idRegionale",
        "path" : "Paziente.identificatori.idRegionale",
        "short" : "Identificativo Regionale",
        "definition" : "Identificativo Regionale",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Identifier"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.identifier.slice(idRegionale)"
          }
        ]
      },
      {
        "id" : "Paziente.identificatori.idLocaleAzienda",
        "path" : "Paziente.identificatori.idLocaleAzienda",
        "short" : "ID locale Aziendale",
        "definition" : "ID locale Aziendale, per tutti i soggetti che hanno avuto un contatto con una specifica Azienda",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Identifier"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.identifier"
          }
        ]
      },
      {
        "id" : "Paziente.identificatori.codiceSanitario",
        "path" : "Paziente.identificatori.codiceSanitario",
        "short" : "Codice Sanitario",
        "definition" : "Codice Sanitario",
        "requirements" : "Per i soggetti assistiti dal Servizio Sanitario Regionale",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Identifier"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.identifier"
          }
        ]
      },
      {
        "id" : "Paziente.identificatori.codiceSTP",
        "path" : "Paziente.identificatori.codiceSTP",
        "short" : "Codice STP",
        "definition" : "Codice STP",
        "comment" : "Codice STP, per gli Stranieri temporaneamente presenti",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Identifier"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.identifier.slice(codiceSTP)"
          }
        ]
      },
      {
        "id" : "Paziente.identificatori.codiceENI",
        "path" : "Paziente.identificatori.codiceENI",
        "short" : "Codice ENI",
        "definition" : "Codice ENI",
        "comment" : "Codice ENI, per i cittadini Europei Non Iscritti",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Identifier"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.identifier.slice(codiceENI)"
          }
        ]
      },
      {
        "id" : "Paziente.identificatori.anpr",
        "path" : "Paziente.identificatori.anpr",
        "short" : "ANPR",
        "definition" : "Identificativo Anagrafe nazionale della popolazione residente (quando applicabile)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Identifier"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.identifier.slice(anpr)"
          }
        ]
      },
      {
        "id" : "Paziente.documentiIdentificazione",
        "path" : "Paziente.documentiIdentificazione",
        "short" : "Documenti di Identificazione",
        "definition" : "Documenti usati per l'identificazione della persona: e.g. Passaporto, Carta di Identità,..",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Paziente.documentiIdentificazione.passaporto",
        "path" : "Paziente.documentiIdentificazione.passaporto",
        "short" : "Passaporto",
        "definition" : "Passaporto",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/DocumentoIdentificazione"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Non ancora mappato"
          }
        ]
      },
      {
        "id" : "Paziente.documentiIdentificazione.cartaIdentita",
        "path" : "Paziente.documentiIdentificazione.cartaIdentita",
        "short" : "Carta di Identità",
        "definition" : "Carta di Identità",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/DocumentoIdentificazione"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Non ancora mappato"
          }
        ]
      },
      {
        "id" : "Paziente.tesseraTEAM",
        "path" : "Paziente.tesseraTEAM",
        "short" : "Tessera Team (aka EHIC)",
        "definition" : "Tessera Team (aka EHIC)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/EHIC"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Non ancora mappato"
          }
        ]
      },
      {
        "id" : "Paziente.nome",
        "path" : "Paziente.nome",
        "short" : "Nome completo",
        "definition" : "Nome completo",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "HumanName",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/HumanName"]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.name"
          }
        ]
      },
      {
        "id" : "Paziente.genere",
        "path" : "Paziente.genere",
        "short" : "Genere (Amministrativo)",
        "definition" : "Genere (Amministrativo)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.gender"
          }
        ]
      },
      {
        "id" : "Paziente.statoCivile",
        "path" : "Paziente.statoCivile",
        "short" : "Stato Civile",
        "definition" : "Stato Civile",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.maritalStatus"
          }
        ]
      },
      {
        "id" : "Paziente.dataNascita",
        "path" : "Paziente.dataNascita",
        "short" : "Data di Nascita",
        "definition" : "Data di Nascita",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/date"]
          },
          {
            "code" : "dateTime",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/dateTime"]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.birthDate"
          },
          {
            "identity" : "fhir-it",
            "map" : "Patient.extension('http://hl7.org/fhir/StructureDefinition/birthDateTime')"
          }
        ]
      },
      {
        "id" : "Paziente.luogoNascita",
        "path" : "Paziente.luogoNascita",
        "short" : "Luogo di Nascita (codice)",
        "definition" : "Luogo di Nascita (codice)",
        "comment" : "Solo stringa od anche codice",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.extension('http://hl7.org/fhir/StructureDefinition/birthPlace')"
          },
          {
            "identity" : "fhir-it",
            "map" : "Patient.extension('http://hl7.it/fhir/StructureDefinition/patient-codeableBirthPlace')"
          }
        ]
      },
      {
        "id" : "Paziente.indirizzi",
        "path" : "Paziente.indirizzi",
        "short" : "Indirizzi (residenza; domicilio)",
        "definition" : "Indirizzi (e.g. residenza; domicilio)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.address"
          }
        ]
      },
      {
        "id" : "Paziente.indirizzi.residenza",
        "path" : "Paziente.indirizzi.residenza",
        "short" : "Residenza",
        "definition" : "Residenza",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/Indirizzo"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.address.where(extension('http://hl7.org/fhir/StructureDefinition/address-official').valueBoolean='true')"
          }
        ]
      },
      {
        "id" : "Paziente.indirizzi.domicilio",
        "path" : "Paziente.indirizzi.domicilio",
        "short" : "Domicilio",
        "definition" : "Domicilio",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/Indirizzo"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.address.where(use.code='home')"
          }
        ]
      },
      {
        "id" : "Paziente.listaAUSL",
        "path" : "Paziente.listaAUSL",
        "short" : "Aziende Sanitarie (Assistenza, residenza)",
        "definition" : "Aziende Sanitarie (Assistenza, residenza)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Paziente.listaAUSL.auslAssistenza",
        "path" : "Paziente.listaAUSL.auslAssistenza",
        "short" : "ASL di Assistenza",
        "definition" : "ASL di Assistenza",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/AziendaSanitaria"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.generalPractitioner.slice(mmgPlsAzienda)"
          }
        ]
      },
      {
        "id" : "Paziente.listaAUSL.aslResidenza",
        "path" : "Paziente.listaAUSL.aslResidenza",
        "short" : "ASL di Residenza",
        "definition" : "ASL di Residenza",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/AziendaSanitaria"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Coverage.where(beneficiary.id = Patient.id).payorOrganization"
          }
        ]
      },
      {
        "id" : "Paziente.recapiti",
        "path" : "Paziente.recapiti",
        "short" : "Recapiti (telecom)",
        "definition" : "Recapiti del paziente (telecom)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.telecom"
          }
        ]
      },
      {
        "id" : "Paziente.recapiti.telefono",
        "path" : "Paziente.recapiti.telefono",
        "short" : "telefono",
        "definition" : "telefono",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactDetail",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/ContactDetail"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.telecom.where(system = 'phone')"
          }
        ]
      },
      {
        "id" : "Paziente.recapiti.eMail",
        "path" : "Paziente.recapiti.eMail",
        "short" : "eMail",
        "definition" : "eMail",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactDetail",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/ContactDetail"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.telecom.where(system = 'email')"
          }
        ]
      },
      {
        "id" : "Paziente.recapiti.pec",
        "path" : "Paziente.recapiti.pec",
        "short" : "pec",
        "definition" : "pec",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactDetail",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/ContactDetail"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.telecom.where(system = 'email')"
          }
        ]
      },
      {
        "id" : "Paziente.recapiti.cellulare",
        "path" : "Paziente.recapiti.cellulare",
        "short" : "Cellulare",
        "definition" : "Cellulare",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactDetail",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/ContactDetail"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.telecom.where(use = 'mobile')"
          }
        ]
      },
      {
        "id" : "Paziente.contatti",
        "path" : "Paziente.contatti",
        "short" : "Contatto del paziente",
        "definition" : "Persona od organizzazione di contatto per il paziente",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact"
          }
        ]
      },
      {
        "id" : "Paziente.contatti.persona",
        "path" : "Paziente.contatti.persona",
        "short" : "Persona di contatto per il paziente",
        "definition" : "Persona di contatto per il paziente",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/ContattoPersona"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact"
          }
        ]
      },
      {
        "id" : "Paziente.contatti.organizzazione",
        "path" : "Paziente.contatti.organizzazione",
        "short" : "Organizzazione di contatto per il paziente",
        "definition" : "Organizzazione di contatto per il paziente",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.org/fhir/StructureDefinition/Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.contact.organization"
          }
        ]
      },
      {
        "id" : "Paziente.cittadinanza",
        "path" : "Paziente.cittadinanza",
        "short" : "Cittadinanza",
        "definition" : "Cittadinanza",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.extension('http://hl7.org/fhir/StructureDefinition/patient-citizenship')"
          }
        ]
      },
      {
        "id" : "Paziente.decesso",
        "path" : "Paziente.decesso",
        "short" : "Decesso",
        "definition" : "Informazioni sul decesso",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.deceased[x]"
          }
        ]
      },
      {
        "id" : "Paziente.decesso.flagDeceduto",
        "path" : "Paziente.decesso.flagDeceduto",
        "short" : "Deceduto (si/no)",
        "definition" : "Deceduto (si/no)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "boolean",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/boolean"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.deceasedBoolean"
          }
        ]
      },
      {
        "id" : "Paziente.decesso.dataDecesso",
        "path" : "Paziente.decesso.dataDecesso",
        "short" : "Data decesso",
        "definition" : "Data decesso",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "dateTime",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/dateTime"]
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.deceasedDateTime"
          }
        ]
      },
      {
        "id" : "Paziente.altriDati",
        "path" : "Paziente.altriDati",
        "short" : "Altre informazioni sul paziente",
        "definition" : "Altre informazioni sul paziente: e.g. professione, titolo di studio, qualifica.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Paziente.altriDati.professione",
        "path" : "Paziente.altriDati.professione",
        "short" : "Professione",
        "definition" : "Professione attuale del paziente",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.extension('http://hl7.it/fhir/StructureDefinition/patient-occupation-it')"
          }
        ]
      },
      {
        "id" : "Paziente.altriDati.titoloStudio",
        "path" : "Paziente.altriDati.titoloStudio",
        "short" : "Titolo Studio",
        "definition" : "Titolo di studio del paziente",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.extension('http://hl7.it/fhir/StructureDefinition/patient-qualification-it')"
          }
        ]
      },
      {
        "id" : "Paziente.esenzione",
        "path" : "Paziente.esenzione",
        "short" : "Esenzioni",
        "definition" : "Esenzioni",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/Esenzione"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Coverage.where(beneficiary.id = Patient.id).costToBeneficiary.exception"
          }
        ]
      },
      {
        "id" : "Paziente.medicoCurante",
        "path" : "Paziente.medicoCurante",
        "short" : "Medico Curante",
        "definition" : "Medico Curante",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/MedicoCurante"
          }
        ],
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Patient.generalPractitioner.slice(mmgPls)"
          },
          {
            "identity" : "fhir-it",
            "map" : "Patient.generalPractitioner.slice(mmgPlsRole)"
          }
        ]
      }
    ]
  }
}

```
