# Organization - Operatore sanitario/socio sanitario - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization - Operatore sanitario/socio sanitario**

## Resource Profile: Organization - Operatore sanitario/socio sanitario 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/Organization-it-hcp | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:OrganizationHcp |

 
Profilo base specifico per Organization: include le informazioni minime per descrivere una organizzazione che eroga od è responsabile per prestazioni sanitarie o socio sanitarie 

**Usages:**

* Refer to this Profile: [Patient - base](StructureDefinition-Patient-it-base.md) and [PractitionerRole - MMG/PLS](StructureDefinition-PractitionerRole-it-mmg.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/Organization-it-hcp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Organization-it-hcp.csv), [Excel](StructureDefinition-Organization-it-hcp.xlsx), [Schematron](StructureDefinition-Organization-it-hcp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Organization-it-hcp",
  "url" : "http://hl7.it/fhir/StructureDefinition/Organization-it-hcp",
  "version" : "0.1.1",
  "name" : "OrganizationHcp",
  "title" : "Organization - Operatore sanitario/socio sanitario",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Profilo base specifico per Organization: include le informazioni minime per descrivere una organizzazione che eroga od è responsabile per prestazioni sanitarie o socio sanitarie",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.it/fhir/StructureDefinition/Organization-it-base",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this.system"
            },
            {
              "type" : "value",
              "path" : "$this.value"
            }
          ],
          "description" : "Slice based on the identifier pattern",
          "rules" : "open"
        }
      },
      {
        "id" : "Organization.identifier.system",
        "path" : "Organization.identifier.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier.value",
        "path" : "Organization.identifier.value",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Organization.identifier:asl",
        "path" : "Organization.identifier",
        "sliceName" : "asl",
        "short" : "Identificativo Azienda Sanitaria Locale (FLS 11 - 6 char)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:asl.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/fls"
      },
      {
        "id" : "Organization.identifier:asl.value",
        "path" : "Organization.identifier.value",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.it/ValueSet/minsan-idAsl"
        }
      },
      {
        "id" : "Organization.identifier:aslRegione",
        "path" : "Organization.identifier",
        "sliceName" : "aslRegione",
        "short" : "Identificativo Regionale Azienda Sanitaria Locale (FLS 11 - 3 char)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:aslRegione.system",
        "path" : "Organization.identifier.system",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.it/ValueSet/uri-idAslRegione"
        }
      },
      {
        "id" : "Organization.identifier:aziendaOspedaliera",
        "path" : "Organization.identifier",
        "sliceName" : "aziendaOspedaliera",
        "short" : "Identificativo Azienda Ospedaliera (HSP 11)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:aziendaOspedaliera.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/hsp"
      },
      {
        "id" : "Organization.identifier:aziendaOspedaliera.value",
        "path" : "Organization.identifier.value",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.it/ValueSet/minsan-idAziendeOspedaliere"
        }
      },
      {
        "id" : "Organization.identifier:struttura",
        "path" : "Organization.identifier",
        "sliceName" : "struttura",
        "short" : "Identificativo Struttura di Ricovero (HSP 11)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:struttura.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/hsp"
      },
      {
        "id" : "Organization.identifier:struttura.value",
        "path" : "Organization.identifier.value",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.it/ValueSet/minsan-idStrutture"
        }
      },
      {
        "id" : "Organization.identifier:partitaIva",
        "path" : "Organization.identifier",
        "sliceName" : "partitaIva",
        "short" : "Partita IVA Organizzazione",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:partitaIva.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/partitaIva"
      },
      {
        "id" : "Organization.identifier:codiceFiscale",
        "path" : "Organization.identifier",
        "sliceName" : "codiceFiscale",
        "short" : "Codice Fiscale Organizzazione",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:codiceFiscale.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/codiceFiscale"
      },
      {
        "id" : "Organization.identifier:strutturaInterna",
        "path" : "Organization.identifier",
        "sliceName" : "strutturaInterna",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Organization.identifier:strutturaInterna.system",
        "path" : "Organization.identifier.system",
        "fixedUri" : "http://hl7.it/sid/hsp"
      },
      {
        "id" : "Organization.identifier:strutturaInterna.value",
        "path" : "Organization.identifier.value",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.it/ValueSet/minsan-idStruttureInterne"
        }
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.it/ValueSet/tipoOrgSocioSanitaria"
        }
      }
    ]
  }
}

```
