# Organization - base - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization - base**

## Resource Profile: Organization - base 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/Organization-it-base | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:OrganizationItBase |

 
Profilo base generico per Organization 

**Usages:**

* Derived from this Profile: [Organization - Operatore sanitario/socio sanitario](StructureDefinition-Organization-it-hcp.md)
* Refer to this Profile: [PractitionerRole - base](StructureDefinition-PractitionerRole-it-base.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/Organization-it-base)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Organization-it-base.csv), [Excel](StructureDefinition-Organization-it-base.xlsx), [Schematron](StructureDefinition-Organization-it-base.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Organization-it-base",
  "url" : "http://hl7.it/fhir/StructureDefinition/Organization-it-base",
  "version" : "0.1.1",
  "name" : "OrganizationItBase",
  "title" : "Organization - base",
  "status" : "draft",
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Profilo base generico per Organization",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.identifier",
        "path" : "Organization.identifier",
        "mustSupport" : true
      },
      {
        "id" : "Organization.active",
        "path" : "Organization.active",
        "mustSupport" : true
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "mustSupport" : true,
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://terminology.hl7.it/ValueSet/tipoOrganizzazione"
        }
      },
      {
        "id" : "Organization.name",
        "path" : "Organization.name",
        "mustSupport" : true
      }
    ]
  }
}

```
