# Medico Curante - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medico Curante**

## Logical Model: Medico Curante ( Abstract Experimental ) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/MedicoCurante | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:MedicoCurante |

 
Modello Logico che definisce il set minimo di dati che caratterizzano un Medico Curante. 

**Usages:**

* Use this Logical Model: [Paziente](StructureDefinition-Paziente.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/MedicoCurante)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicoCurante.csv), [Excel](StructureDefinition-MedicoCurante.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicoCurante",
  "url" : "http://hl7.it/fhir/StructureDefinition/MedicoCurante",
  "version" : "0.1.1",
  "name" : "MedicoCurante",
  "title" : "Medico Curante",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Modello Logico che definisce il set minimo di dati che caratterizzano un Medico Curante.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "fhir-it",
      "uri" : "http://hl7.it/fhir",
      "name" : "HL7 FHIR IT Profiles"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : true,
  "type" : "MedicoCurante",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Element",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "MedicoCurante",
        "path" : "MedicoCurante",
        "short" : "Medico Curante",
        "definition" : "Modello Logico che definisce il set minimo di dati che caratterizzano una Medico Curante",
        "min" : 0,
        "max" : "*",
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Practitioner.conformsTo('http://hl7.it/fhir/StructureDefinition/Practitioner-it-base')"
          },
          {
            "identity" : "fhir-it",
            "map" : "PractitionerRole.conformsTo('http://hl7.it/fhir/StructureDefinition/PractitionerRole-it-mmg')"
          }
        ]
      },
      {
        "id" : "MedicoCurante.identificativo",
        "path" : "MedicoCurante.identificativo",
        "short" : "ID Medico Curante",
        "definition" : "ID Medico Curante",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/Identifier"]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Practitioner.conformsTo('http://hl7.it/fhir/StructureDefinition/Practitioner-it-base').identifier"
          },
          {
            "identity" : "fhir-it",
            "map" : "PractitionerRole.conformsTo('http://hl7.it/fhir/StructureDefinition/PractitionerRole-it-mmg').identifier"
          }
        ]
      },
      {
        "id" : "MedicoCurante.nome",
        "path" : "MedicoCurante.nome",
        "short" : "Nome Medico Curante",
        "definition" : "Nome Medico Curante",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "HumanName",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/HumanName"]
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "Practitioner.conformsTo('http://hl7.it/fhir/StructureDefinition/Practitioner-it-base').name"
          },
          {
            "identity" : "fhir-it",
            "map" : "PractitionerRole.conformsTo('http://hl7.it/fhir/StructureDefinition/PractitionerRole-it-mmg').practitioner.name"
          }
        ]
      },
      {
        "id" : "MedicoCurante.aslAppartenenza",
        "path" : "MedicoCurante.aslAppartenenza",
        "short" : "Azienda di Appartenenza",
        "definition" : "Azienda di Appartenenza del Medico Curante",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.it/fhir/StructureDefinition/AziendaSanitaria"
          }
        ],
        "mustSupport" : true,
        "mapping" : [
          {
            "identity" : "fhir-it",
            "map" : "PractitionerRole.conformsTo('http://hl7.it/fhir/StructureDefinition/PractitionerRole-it-mmg').organization.resolve().conformsTo('http://hl7.it/fhir/StructureDefinition/Organization-it-hcp')"
          }
        ]
      }
    ]
  }
}

```
