# EHIC (TEAM) - HL7 Italia FHIR Implementation Guide (base) v0.1.1

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EHIC (TEAM)**

## Logical Model: EHIC (TEAM) ( Experimental ) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.it/fhir/StructureDefinition/EHIC | *Version*:0.1.1 |
| Draft as of 2025-11-18 | *Computable Name*:EHIC |

 
Modello Logico che definisce il set di dati che caratterizzano la tessera TEAM o EHIC (European Healthcare Insurance Card). 

### European Health Insurance Card

The European Health Insurance Card (EHIC) is a free card that gives you access to medically necessary, state-provided healthcare during a temporary stay in any of the 27 EU countries, Iceland, Liechtenstein, Norway, Switzerland and the United Kingdom, under the same conditions and at the same cost (free in some countries) as people insured in that country.

#### How to recognise the card

The cards can be easily recognised. The front of the card looks the same and carries the same information, although in different languages, in each country. The back of the card can vary from country to country. You can click on a country in the [How to recognise the card](https://ec.europa.eu/social/main.jsp?catId=653&langId=en) page to see what it looks like in that country.

### Tessera Europea di Assicurazione Malattia

La Tessera Europea di Assicurazione Malattia (TEAM) è una tessera gratuita che dà diritto all'assistenza sanitaria statale in caso di permanenza temporanea in uno dei 27 Stati membri dell'UE, in Islanda, in Liechtenstein, in Norvegia e in Svizzera, alle stesse condizioni e allo stesso costo (gratuitamente in alcuni paesi) degli assistiti del paese in cui ci si trova.

#### Come riconoscere la tessera

La tessera è facilmente riconoscibile. Il fronte ha lo stesso aspetto e contiene le stesse informazioni, sebbene in lingue differenti, in tutti i paesi, mentre il retro varia da nazione a nazione. Fate clic sul paese che vi interessa nella pagina [Come riconoscere la tessera](https://ec.europa.eu/social/main.jsp?catId=653&langId=it), per visualizzare il modello di tessera rilasciato a livello nazionale.

**Usages:**

* Use this Logical Model: [Paziente](StructureDefinition-Paziente.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.it.base|current/StructureDefinition/EHIC)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-EHIC.csv), [Excel](StructureDefinition-EHIC.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "EHIC",
  "url" : "http://hl7.it/fhir/StructureDefinition/EHIC",
  "version" : "0.1.1",
  "name" : "EHIC",
  "title" : "EHIC (TEAM)",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-11-18T14:18:52+00:00",
  "publisher" : "HL7 Italia",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.it"
        }
      ]
    }
  ],
  "description" : "Modello Logico che definisce il set di dati che caratterizzano la tessera TEAM o EHIC (European Healthcare Insurance Card).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "IT"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "EHIC",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Element",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "EHIC",
        "path" : "EHIC",
        "short" : "European Healthcare Insurance Card",
        "definition" : "Logical Model describing the European Healthcare Insurance Card",
        "alias" : ["TEAM"],
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "EHIC.countryCode",
        "path" : "EHIC.countryCode",
        "short" : "Country Code",
        "definition" : "Country Code",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/CodeableConcept"]
          }
        ]
      }
    ]
  }
}

```
